###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for Linux kernel vulnerabilities USN-894-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840383);
  script_version("$Revision: 8167 $: 1.0");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "894-1");
  script_cve_id("CVE-2009-4020", "CVE-2009-4021", "CVE-2009-4031", "CVE-2009-4138", "CVE-2009-4141", "CVE-2009-4308", "CVE-2009-4536", "CVE-2009-4538", "CVE-2010-0003", "CVE-2010-0006", "CVE-2010-0007", "CVE-2010-0291");
  script_name("Ubuntu Update for Linux kernel vulnerabilities USN-894-1");
  desc = "

  Vulnerability Insight:

  Amerigo Wang and Eric Sesterhenn discovered that the HFS and ext4
  filesystems did not correctly check certain disk structures. If a user
  were tricked into mounting a specially crafted filesystem, a remote
  attacker could crash the system or gain root privileges. (CVE-2009-4020,
  CVE-2009-4308)
  
  It was discovered that FUSE did not correctly check certain requests.
  A local attacker with access to FUSE mounts could exploit this to
  crash the system or possibly gain root privileges.  Ubuntu 9.10 was not
  affected. (CVE-2009-4021)
  
  It was discovered that KVM did not correctly decode certain guest
  instructions.  A local attacker in a guest could exploit this to
  trigger high scheduling latency in the host, leading to a denial of
  service.  Ubuntu 6.06 was not affected. (CVE-2009-4031)
  
  It was discovered that the OHCI fireware driver did not correctly
  handle certain ioctls.  A local attacker could exploit this to crash
  the system, or possibly gain root privileges.  Ubuntu 6.06 was not
  affected. (CVE-2009-4138)
  
  Tavis Ormandy discovered that the kernel did not correctly handle
  O_ASYNC on locked files.  A local attacker could exploit this to gain
  root privileges.  Only Ubuntu 9.04 and 9.10 were affected. (CVE-2009-4141)
  
  Neil Horman and Eugene Teo discovered that the e1000 and e1000e
  network drivers did not correctly check the size of Ethernet frames.
  An attacker on the local network could send specially crafted traffic
  to bypass packet filters, crash the system, or possibly gain root
  privileges. (CVE-2009-4536, CVE-2009-4538)
  
  It was discovered that &quot;print-fatal-signals&quot; reporting could show
  arbitrary kernel memory contents.  A local attacker could exploit
  this, leading to a loss of privacy.  By default this is disabled in
  Ubuntu and did not affect Ubuntu 6.06. (CVE-2010-0003)
  
  Olli Jarva and Tuomo Untinen discovered that IPv6 did not correctly
  handle jumbo frames.  A remote attacker could exploit this to crash the
  system, leading to a denial of service.  Only Ubuntu 9.04 and 9.10 were
  affected. (CVE-2010-0006)
  
  Florian Westphal discovered that bridging netfilter rules could be
  modified by unprivileged users.  A local attacker could disrupt network
  traffic, leading to a denial of service. (CVE-2010-0007)
  
  Al Viro discovered that certain mremap operations could leak kernel
  memory.  A local attacker could exploit this to consume all available
  memory, leading to a denial of service. (CVE-2010-0291)

  Affected Software/OS:
  Linux kernel vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-February/001041.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of Linux kernel vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"linux-headers-2.6.28-18-generic", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.28-18-server", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.28-18-generic", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.28-18-server", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.28-18-virtual", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc-2.6.28", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.28-18", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source-2.6.28", ver:"2.6.28-18.59", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers-2.6.15-55-386", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.15-55-686", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.15-55-k7", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.15-55-server-bigiron", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.15-55-server", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.15-55", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.15-55-386", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.15-55-686", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.15-55-k7", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.15-55-server-bigiron", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.15-55-server", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc-2.6.15", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source-2.6.15", ver:"2.6.15-55.82", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"linux-headers-2.6.27-17-generic", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.27-17-server", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.27-17-generic", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.27-17-server", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.27-17-virtual", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc-2.6.27", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.27-17", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source-2.6.27", ver:"2.6.27-17.45", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"linux-headers-2.6.24-27-386", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.24-27-generic", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.24-27-openvz", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.24-27-rt", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.24-27-server", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.24-27-virtual", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.24-27-xen", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.24-27-386", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.24-27-generic", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.24-27-server", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.24-27-virtual", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug-2.6.24-27-386", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug-2.6.24-27-generic", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug-2.6.24-27-server", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-debug-2.6.24-27-virtual", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.24-27-openvz", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.24-27-rt", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.24-27-xen", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc-2.6.24", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.24-27", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-kernel-devel", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source-2.6.24", ver:"2.6.24-27.65", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"linux-headers-2.6.31-304-ec2", ver:"2.6.31-304.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.31-304-ec2", ver:"2.6.31-304.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.31-19-386", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.31-19-generic-pae", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.31-19-generic", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.31-19-386", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.31-19-generic-pae", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.31-19-generic", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-image-2.6.31-19-virtual", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-libc-dev", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ec2-doc", ver:"2.6.31-304.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-ec2-source-2.6.31", ver:"2.6.31-304.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.31-304", ver:"2.6.31-304.10", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-doc", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-headers-2.6.31-19", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"linux-source-2.6.31", ver:"2.6.31-19.56", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}