##############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apache_mod_jk_detect.nasl 1630 2009-04-14 17:40:24Z apr $
#
# Apache mod_jk Module Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (C) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800279);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Apache mod_jk Module Version Detection");
  desc = "

  Overview: This script detects the installed version of Apache mod_jk Module
  and saves the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Set the KB for the Version of Apache Module mod_jk");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Service detection");
  script_dependencies("find_service.nes");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port)){
  exit(0);
}

banner = get_http_banner(port:port);
if("mod_jk" >< banner)
{
  version = eregmatch(pattern:"mod_jk/([0-9.]+)", string:banner);
  if(version[1] != NULL)
  {
    set_kb_item(name:"www/" + port + "/Apache/Mod_Jk", value:version[1]);
    security_note(data:"Mod JK version " + version[1] + " was detected on the host");
    exit(0);
  }
}
