# @rjsf/validator-ajv8 APIs

In RJSF version 5, the original, embedded AJV 6 validator implementation from earlier versions was extracted into its own package, `@rjsf/validator-ajv6`, which was immediately deprecated since AJV 6 is no longer getting maintenance updates.
A new `@rjsf/validator-ajv8` package was added that uses the AJV 8 package, including adding support for using precompiled validators.
Below are the exported API functions that are provided by this package.
See the [Validation documentation](../usage/validation.md) for examples of using these APIs.

## Types

There are a few Typescript types that are exported by `@rjsf/validator-ajv8` in support of the APIs.

These types can be found on GitHub [here](https://github.com/rjsf-team/react-jsonschema-form/blob/main/packages/validator-ajv8/src/types.ts).

## APIs

### customizeValidator<T = any, S extends StrictRJSFSchema = RJSFSchema, F extends FormContextType = any>()

Creates and returns a customized implementation of the `ValidatorType` with the given customization `options` if provided.
If a `localizer` is provided, it is used to translate the messages generated by the underlying AJV validation.

#### Parameters

- [options={}]: CustomValidatorOptionsType - The optional map of `CustomValidatorOptionsType` options that are used to create the `ValidatorType` instance
- [localizer]: Localizer | undefined - If provided, is used to localize a list of Ajv `ErrorObject`s after running the form validation using AJV

#### Returns

- ValidatorType&lt;T, S, F>: The custom validator implementation resulting from the set of parameters provided

### compileSchemaValidators&lt;S extends StrictRJSFSchema = RJSFSchema>()

The function used to compile a schema into an output file in the form that allows it to be used as a precompiled validator.
The main reasons for using a precompiled validator is reducing code size, improving validation speed and, most importantly, avoiding dynamic code compilation when prohibited by a browser's Content Security Policy.
For more information about AJV code compilation see: https://ajv.js.org/standalone.html

#### Parameters

- schema: S - The schema to be compiled into a set of precompiled validators functions
- output: string - The name of the file into which the precompiled validator functions will be generated
- [options={}]: CustomValidatorOptionsType - The set of `CustomValidatorOptionsType` information used to alter the AJV validator used for compiling the schema. They are the same options that are passed to the `customizeValidator()` function in order to modify the behavior of the regular AJV-based validator.

### createPrecompiledValidator<T = any, S extends StrictRJSFSchema = RJSFSchema, F extends FormContextType = any>()

Creates and returns a `ValidatorType` interface that is implemented with a precompiled validator.
If a `localizer` is provided, it is used to translate the messages generated by the underlying AJV validation.

> NOTE: The `validateFns` parameter is an object obtained by importing from a precompiled validation file created via the `compileSchemaValidators()` function.

#### Parameters

- validateFns: ValidatorFunctions - The map of the validation functions that are created by the `compileSchemaValidators()` function
- rootSchema: S - The root schema that was used with the `compileSchemaValidators()` function
- [localizer]: Localizer | undefined - If provided, is used to localize a list of Ajv `ErrorObject`s after running the form validation using AJV

#### Returns

- ValidatorType&lt;T, S, F>: The precompiled validator implementation resulting from the set of parameters provided
