<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[Home](./index.md) &gt; [puppeteer](./puppeteer.md) &gt; [Page](./puppeteer.page.md) &gt; [waitForResponse](./puppeteer.page.waitforresponse.md)

## Page.waitForResponse() method

<b>Signature:</b>

```typescript
waitForResponse(urlOrPredicate: string | ((res: HTTPResponse) => boolean | Promise<boolean>), options?: {
        timeout?: number;
    }): Promise<HTTPResponse>;
```

## Parameters

|  Parameter | Type | Description |
|  --- | --- | --- |
|  urlOrPredicate | string \| ((res: [HTTPResponse](./puppeteer.httpresponse.md)) =&gt; boolean \| Promise&lt;boolean&gt;) | A URL or predicate to wait for. |
|  options | { timeout?: number; } | Optional waiting parameters |

<b>Returns:</b>

Promise&lt;[HTTPResponse](./puppeteer.httpresponse.md)&gt;

Promise which resolves to the matched response.

## Remarks

Optional Parameter have:

- `timeout`: Maximum wait time in milliseconds, defaults to `30` seconds, pass `0` to disable the timeout. The default value can be changed by using the [Page.setDefaultTimeout()](./puppeteer.page.setdefaulttimeout.md) method.

## Example


```js
const firstResponse = await page.waitForResponse(
'https://example.com/resource'
);
const finalResponse = await page.waitForResponse(
(response) =>
response.url() === 'https://example.com' && response.status() === 200
);
const finalResponse = await page.waitForResponse(async (response) => {
return (await response.text()).includes('<html>');
});
return finalResponse.ok();

```

