{{#block "logo"}}
<p align="center">
  <a href="{%= homepage %}">
    <img height="250" width="250" src="https://raw.githubusercontent.com/node-base/base/master/docs/logo.png">
  </a>
</p>
{{/block}}

{{#block "about"}}
## What is Base?

Base is a framework for rapidly creating high quality node.js applications, using plugins like building blocks. 

### Guiding principles

The core team follows these principles to help guide API decisions:

- **Compact API surface**: The smaller the API surface, the easier the library will be to learn and use.
- **Easy to extend**: Implementors can use any npm package, and write plugins in pure JavaScript. If you're building complex apps, Base simplifies inheritance.
- **Easy to test**: No special setup should be required to unit test `Base` or base plugins 

### Minimal API surface

[The API](#api) was designed to provide only the minimum necessary functionality for creating a useful application, with or without [plugins](#plugins). 

**Base core**

Base itself ships with only a handful of [useful methods](#api), such as:

- `.set`: for setting values on the instance
- `.get`: for getting values from the instance
- `.has`: to check if a property exists on the instance
- `.define`: for setting non-enumerable values on the instance
- `.use`: for adding plugins

**Be generic**

When deciding on method to add or remove, we try to answer these questions: 

1. Will all or most Base applications need this method? 
1. Will this method encourage practices or enforce conventions that are beneficial to implementors?
1. Can or should this be done in a plugin instead?

### Composability

**Plugin system**

It couldn't be easier to extend Base with any features or custom functionality you can think of. 

Base plugins are just functions that take an instance of `Base`:

```js
var base = new Base();

function plugin(base) {
  // do plugin stuff, in pure JavaScript
}
// use the plugin
base.use(plugin);
```

**Inheritance**

Easily inherit Base using `.extend`:

```js
var Base = require('{%= name %}');

function MyApp() {
  Base.call(this);
}
Base.extend(MyApp);

var app = new MyApp();
app.set('a', 'b');
app.get('a');
//=> 'b';
```

**Inherit or instantiate with a namespace**

By default, the `.get`, `.set` and `.has` methods set and get values from the root of the `base` instance. You can customize this using the `.namespace` method exposed on the exported function. For example:

```js
var Base = require('{%= name %}');
// get and set values on the `base.cache` object
var base = Base.namespace('cache');

var app = base();
app.set('foo', 'bar');
console.log(app.cache.foo);
//=> 'bar'
```


{{/block}}


## API

**Usage**

```js
var Base = require('base');
var app = new Base();
app.set('foo', 'bar');
console.log(app.foo);
//=> 'bar'
```

{%= apidocs("index.js") %}

## In the wild

The following node.js applications were built with `Base`:

- [assemble][]
- [verb][]
- [generate][]
- [scaffold][]
- [boilerplate][]

## Test coverage

```
{%= coverage('coverage/summary.txt') %}
```

## History

**v0.11.0 - major breaking changes!**

- Static `.use` and `.run` methods are now non-enumerable

**v0.9.0 - major breaking changes!**

- `.is` no longer takes a function, a string must be passed 
- all remaining `.debug` code has been removed
- `app._namespace` was removed (related to `debug`)
- `.plugin`, `.use`, and `.define` no longer emit events
- `.assertPlugin` was removed
- `.lazy` was removed