/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import org.apache.hadoop.mapred.TaskTracker;
import org.apache.hadoop.metrics2.MetricsBuilder;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterInt;
import org.apache.hadoop.metrics2.lib.MetricMutableCounterLong;
import org.apache.hadoop.metrics2.lib.MetricsRegistry;

class ShuffleServerInstrumentation
implements MetricsSource {
    final int ttWorkerThreads;
    final MetricsRegistry registry = new MetricsRegistry("shuffleOutput");
    private volatile int serverHandlerBusy = 0;
    final MetricMutableCounterLong outputBytes = this.registry.newCounter("shuffle_output_bytes", "", 0L);
    final MetricMutableCounterInt failedOutputs = this.registry.newCounter("shuffle_failed_outputs", "", 0);
    final MetricMutableCounterInt successOutputs = this.registry.newCounter("shuffle_success_outputs", "", 0);
    final MetricMutableCounterInt exceptionsCaught = this.registry.newCounter("shuffle_exceptions_caught", "", 0);

    ShuffleServerInstrumentation(TaskTracker tt) {
        this.ttWorkerThreads = tt.workerThreads;
        this.registry.setContext("mapred").tag("sessionId", "session id", tt.getJobConf().getSessionId());
    }

    synchronized void serverHandlerBusy() {
        ++this.serverHandlerBusy;
    }

    synchronized void serverHandlerFree() {
        --this.serverHandlerBusy;
    }

    void outputBytes(long bytes) {
        this.outputBytes.incr(bytes);
    }

    void failedOutput() {
        this.failedOutputs.incr();
    }

    void successOutput() {
        this.successOutputs.incr();
    }

    void exceptionsCaught() {
        this.exceptionsCaught.incr();
    }

    @Override
    public void getMetrics(MetricsBuilder builder, boolean all) {
        MetricsRecordBuilder rb = builder.addRecord(this.registry.name());
        rb.addGauge("shuffle_handler_busy_percent", "", this.ttWorkerThreads == 0 ? 0.0 : 100.0 * (double)this.serverHandlerBusy / (double)this.ttWorkerThreads);
        this.registry.snapshot(rb, all);
    }

    static ShuffleServerInstrumentation create(TaskTracker tt) {
        return ShuffleServerInstrumentation.create(tt, DefaultMetricsSystem.INSTANCE);
    }

    static ShuffleServerInstrumentation create(TaskTracker tt, MetricsSystem ms) {
        return ms.register("ShuffleServerMetrics", "Shuffle output metrics", new ShuffleServerInstrumentation(tt));
    }
}

