/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#ifndef Folder_H
#define Folder_H

#include "IconObject.h"

class FolderInfo;
class FolderSettings;
class FolderObserver;
class Request;

class FolderVisitor
{
public:
    virtual void visit(IconObject*) = 0;
};

class Folder : public IconObject
{
public:
    Folder(Folder*, const IconClass& kind, const string& name,
           IconInfo* info);

    virtual ~Folder();

    virtual IconObject* find(const vector<string>&);
    virtual IconObject* find(const string&);
    virtual IconObject* create(const string&);

    virtual bool adopt(IconObject*);
    virtual bool release(IconObject*);

    //virtual void visit(FolderVisitor&);

    void addObserver(FolderObserver*);
    void removeObserver(FolderObserver*);

    string uniqueName(const string&);
    string duplicateName(const string&);
    void position(IconObject*, int x, int y);
    void renamed(IconObject*, const string&, const string&);

    //virtual void empty();
    virtual void destroy();
    void scan();
    void scanForNewFile(const string&, int x = 0, int y = 0);
    void recheckKidsIconClass();
    void recheckKidIconClass(IconObject*);

    //void copyContent(Folder*);
    //virtual void drop(IconObject*);

    typedef void (FolderObserver::*TellObserverProc)(IconObject*);
    void tellObservers(TellObserverProc, IconObject*);

    //void open();
    //void close();

    virtual bool ancestor(IconObject*);
    virtual bool descendant(Folder*);
    //virtual bool sameAs(IconObject*);
    //virtual void notifyChanged();

    int numOfIconKids();
    const map<string, IconObjectH>& kids() const { return kids_; }
    void iconClasses(map<string, IconObjectH>&);
    virtual bool isFolder() { return true; }

    virtual Request request() const;
    virtual void request(const Request&);

    static Folder* top();
    static Folder* folder(const string&, bool create = true);
    static Folder* folder(const string&, const string&, bool create = true);
    static Folder* folder(const string&, const string&, const string&, bool create = true);
    static IconObject* icon(const string&);

    void saveFolderInfo();
    FolderInfo* folderInfo();
    FolderSettings* settings();

protected:
    virtual set<string> can();

    typedef map<string, IconObjectH> KidMap;
    KidMap kids_;
    std::set<string> noKids_;

    static const unsigned int maxNokidsNum_;
    bool ready_;
    bool scanIsOn_;
    FolderInfo* folderInfo_;
    FolderSettings* settings_;

    std::set<FolderObserver*> observers_;

    static vector<Folder*> folders_;

    virtual void createFiles();

private:
    // No copy allowed
    Folder(const Folder&);
    Folder& operator=(const Folder&);

    // -- Overridden methods

    // From IconObject
    //virtual void edit();
};

class FolderH : public Handle<Folder>
{
public:
    FolderH(Folder* f) :
        Handle<Folder>(f) {}
};

#endif
