# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.data_set_algorithm import DataSetAlgorithm


class CellQuality(DataSetAlgorithm):
    r"""
    CellQuality - Calculate functions of quality of the elements of a
    mesh
    
    Superclass: DataSetAlgorithm
    
    CellQuality computes one or more functions of (geometric) quality
    for each cell of a mesh.  The per-cell quality is added to the mesh's
    cell data, in an array named "cell_quality." Cell types not supported
    by this filter or undefined quality of supported cell types will have
    an entry of -1.
    
    @warning
    Most quadrilateral quality functions are intended for planar
    quadrilaterals only.  The minimal angle is not, strictly speaking, a
    quality function, but it is provided because of its usage by many
    authors.
    
    @warning
    This class has been threaded with SMPTools. Using TBB or other
    non-sequential type (set in the CMake variable
    VTK_SMP_IMPLEMENTATION_TYPE) may improve performance significantly.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkCellQuality, obj, update, **traits)
    
    undefined_quality = traits.Float(-1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the return value for undefined quality. Undefined quality
        are qualities that could be addressed by this filter but is not
        well defined for the particular geometry of cell in question,
        e.g. a volume query for a triangle. Undefined quality will always
        be undefined. The default value for undefined_quality is -1.
        """
    )

    def _undefined_quality_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUndefinedQuality,
                        self.undefined_quality)

    unsupported_geometry = traits.Float(-1.0, enter_set=True, auto_set=False, desc=\
        r"""
        Set/Get the return value for unsupported geometry. Unsupported
        geometry are geometries that are not supported by this filter
        currently, future implementation might include support for them.
        The default value for unsupported_geometry is -1.
        """
    )

    def _unsupported_geometry_changed(self, old_val, new_val):
        self._do_change(self._vtk_obj.SetUnsupportedGeometry,
                        self.unsupported_geometry)

    def _get_input(self):
        return wrap_vtk(self._vtk_obj.GetInput())
    input = traits.Property(_get_input, desc=\
        r"""
        Get the input data object. This method is not recommended for
        use, but lots of old style filters use it.
        """
    )

    def pixel_area(self, *args):
        """
        pixel_area(self, __a:Cell) -> float
        C++: double pixel_area(Cell *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PixelArea, *my_args)
        return ret

    def polygon_area(self, *args):
        """
        polygon_area(self, __a:Cell) -> float
        C++: double polygon_area(Cell *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.PolygonArea, *my_args)
        return ret

    def set_quality_measure(self, *args):
        """
        set_quality_measure(self, measure:int) -> None
        C++: virtual void set_quality_measure(int measure)"""
        ret = self._wrap_call(self._vtk_obj.SetQualityMeasure, *args)
        return ret

    def set_quality_measure_to_area(self):
        """
        set_quality_measure_to_area(self) -> None
        C++: void set_quality_measure_to_area()"""
        ret = self._vtk_obj.SetQualityMeasureToArea()
        return ret
        

    def set_quality_measure_to_aspect_frobenius(self):
        """
        set_quality_measure_to_aspect_frobenius(self) -> None
        C++: void set_quality_measure_to_aspect_frobenius()"""
        ret = self._vtk_obj.SetQualityMeasureToAspectFrobenius()
        return ret
        

    def set_quality_measure_to_aspect_gamma(self):
        """
        set_quality_measure_to_aspect_gamma(self) -> None
        C++: void set_quality_measure_to_aspect_gamma()"""
        ret = self._vtk_obj.SetQualityMeasureToAspectGamma()
        return ret
        

    def set_quality_measure_to_aspect_ratio(self):
        """
        set_quality_measure_to_aspect_ratio(self) -> None
        C++: void set_quality_measure_to_aspect_ratio()"""
        ret = self._vtk_obj.SetQualityMeasureToAspectRatio()
        return ret
        

    def set_quality_measure_to_collapse_ratio(self):
        """
        set_quality_measure_to_collapse_ratio(self) -> None
        C++: void set_quality_measure_to_collapse_ratio()"""
        ret = self._vtk_obj.SetQualityMeasureToCollapseRatio()
        return ret
        

    def set_quality_measure_to_condition(self):
        """
        set_quality_measure_to_condition(self) -> None
        C++: void set_quality_measure_to_condition()"""
        ret = self._vtk_obj.SetQualityMeasureToCondition()
        return ret
        

    def set_quality_measure_to_diagonal(self):
        """
        set_quality_measure_to_diagonal(self) -> None
        C++: void set_quality_measure_to_diagonal()"""
        ret = self._vtk_obj.SetQualityMeasureToDiagonal()
        return ret
        

    def set_quality_measure_to_dimension(self):
        """
        set_quality_measure_to_dimension(self) -> None
        C++: void set_quality_measure_to_dimension()"""
        ret = self._vtk_obj.SetQualityMeasureToDimension()
        return ret
        

    def set_quality_measure_to_distortion(self):
        """
        set_quality_measure_to_distortion(self) -> None
        C++: void set_quality_measure_to_distortion()"""
        ret = self._vtk_obj.SetQualityMeasureToDistortion()
        return ret
        

    def set_quality_measure_to_jacobian(self):
        """
        set_quality_measure_to_jacobian(self) -> None
        C++: void set_quality_measure_to_jacobian()"""
        ret = self._vtk_obj.SetQualityMeasureToJacobian()
        return ret
        

    def set_quality_measure_to_max_angle(self):
        """
        set_quality_measure_to_max_angle(self) -> None
        C++: void set_quality_measure_to_max_angle()"""
        ret = self._vtk_obj.SetQualityMeasureToMaxAngle()
        return ret
        

    def set_quality_measure_to_max_aspect_frobenius(self):
        """
        set_quality_measure_to_max_aspect_frobenius(self) -> None
        C++: void set_quality_measure_to_max_aspect_frobenius()"""
        ret = self._vtk_obj.SetQualityMeasureToMaxAspectFrobenius()
        return ret
        

    def set_quality_measure_to_max_edge_ratio(self):
        """
        set_quality_measure_to_max_edge_ratio(self) -> None
        C++: void set_quality_measure_to_max_edge_ratio()"""
        ret = self._vtk_obj.SetQualityMeasureToMaxEdgeRatio()
        return ret
        

    def set_quality_measure_to_med_aspect_frobenius(self):
        """
        set_quality_measure_to_med_aspect_frobenius(self) -> None
        C++: void set_quality_measure_to_med_aspect_frobenius()"""
        ret = self._vtk_obj.SetQualityMeasureToMedAspectFrobenius()
        return ret
        

    def set_quality_measure_to_min_angle(self):
        """
        set_quality_measure_to_min_angle(self) -> None
        C++: void set_quality_measure_to_min_angle()"""
        ret = self._vtk_obj.SetQualityMeasureToMinAngle()
        return ret
        

    def set_quality_measure_to_oddy(self):
        """
        set_quality_measure_to_oddy(self) -> None
        C++: void set_quality_measure_to_oddy()"""
        ret = self._vtk_obj.SetQualityMeasureToOddy()
        return ret
        

    def set_quality_measure_to_radius_ratio(self):
        """
        set_quality_measure_to_radius_ratio(self) -> None
        C++: void set_quality_measure_to_radius_ratio()"""
        ret = self._vtk_obj.SetQualityMeasureToRadiusRatio()
        return ret
        

    def set_quality_measure_to_relative_size_squared(self):
        """
        set_quality_measure_to_relative_size_squared(self) -> None
        C++: void set_quality_measure_to_relative_size_squared()"""
        ret = self._vtk_obj.SetQualityMeasureToRelativeSizeSquared()
        return ret
        

    def set_quality_measure_to_scaled_jacobian(self):
        """
        set_quality_measure_to_scaled_jacobian(self) -> None
        C++: void set_quality_measure_to_scaled_jacobian()"""
        ret = self._vtk_obj.SetQualityMeasureToScaledJacobian()
        return ret
        

    def set_quality_measure_to_shape(self):
        """
        set_quality_measure_to_shape(self) -> None
        C++: void set_quality_measure_to_shape()"""
        ret = self._vtk_obj.SetQualityMeasureToShape()
        return ret
        

    def set_quality_measure_to_shape_and_size(self):
        """
        set_quality_measure_to_shape_and_size(self) -> None
        C++: void set_quality_measure_to_shape_and_size()"""
        ret = self._vtk_obj.SetQualityMeasureToShapeAndSize()
        return ret
        

    def set_quality_measure_to_shear(self):
        """
        set_quality_measure_to_shear(self) -> None
        C++: void set_quality_measure_to_shear()"""
        ret = self._vtk_obj.SetQualityMeasureToShear()
        return ret
        

    def set_quality_measure_to_shear_and_size(self):
        """
        set_quality_measure_to_shear_and_size(self) -> None
        C++: void set_quality_measure_to_shear_and_size()"""
        ret = self._vtk_obj.SetQualityMeasureToShearAndSize()
        return ret
        

    def set_quality_measure_to_skew(self):
        """
        set_quality_measure_to_skew(self) -> None
        C++: void set_quality_measure_to_skew()"""
        ret = self._vtk_obj.SetQualityMeasureToSkew()
        return ret
        

    def set_quality_measure_to_stretch(self):
        """
        set_quality_measure_to_stretch(self) -> None
        C++: void set_quality_measure_to_stretch()"""
        ret = self._vtk_obj.SetQualityMeasureToStretch()
        return ret
        

    def set_quality_measure_to_taper(self):
        """
        set_quality_measure_to_taper(self) -> None
        C++: void set_quality_measure_to_taper()"""
        ret = self._vtk_obj.SetQualityMeasureToTaper()
        return ret
        

    def set_quality_measure_to_volume(self):
        """
        set_quality_measure_to_volume(self) -> None
        C++: void set_quality_measure_to_volume()"""
        ret = self._vtk_obj.SetQualityMeasureToVolume()
        return ret
        

    def set_quality_measure_to_warpage(self):
        """
        set_quality_measure_to_warpage(self) -> None
        C++: void set_quality_measure_to_warpage()"""
        ret = self._vtk_obj.SetQualityMeasureToWarpage()
        return ret
        

    def triangle_strip_area(self, *args):
        """
        triangle_strip_area(self, __a:Cell) -> float
        C++: double triangle_strip_area(Cell *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.TriangleStripArea, *my_args)
        return ret

    _updateable_traits_ = \
    (('abort_execute', 'GetAbortExecute'), ('release_data_flag',
    'GetReleaseDataFlag'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'),
    ('undefined_quality', 'GetUndefinedQuality'), ('unsupported_geometry',
    'GetUnsupportedGeometry'), ('progress_text', 'GetProgressText'),
    ('object_name', 'GetObjectName'), ('reference_count',
    'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['abort_execute', 'debug', 'global_warning_display',
    'release_data_flag', 'object_name', 'progress_text',
    'undefined_quality', 'unsupported_geometry'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(CellQuality, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit CellQuality properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name', 'undefined_quality',
            'unsupported_geometry']),
            title='Edit CellQuality properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit CellQuality properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

