--
-- _cmake.lua
-- Define the CMake action(s).
-- Copyright (c) 2015 Miodrag Milanovic
--

function premake.cmake.workspace(sln)
	if (sln.location ~= _WORKING_DIR) then
		local name = string.format("%s/CMakeLists.txt", _WORKING_DIR)
		local f, err = io.open(name, "wb")
		if (not f) then
			error(err, 0)
		end
		f:write([[
			# CMakeLists autogenerated by GENie
			project(GENie)
			cmake_minimum_required(VERSION 3.15)

			#########################################################################

			# Set a default build type if none was specified
			# Source: https://blog.kitware.com/cmake-and-the-default-build-type/
			set(default_build_type "Release")
			if(EXISTS "${CMAKE_SOURCE_DIR}/.git")
			  set(default_build_type "Debug")
			endif()
			if(NOT CMAKE_BUILD_TYPE AND NOT CMAKE_CONFIGURATION_TYPES)
			  message(STATUS "Setting build type to '${default_build_type}' as none was specified.")
			  set(CMAKE_BUILD_TYPE "${default_build_type}" CACHE STRING "Choose the type of build." FORCE)
			  # Set the possible values of build type for cmake-gui
			  set_property(CACHE CMAKE_BUILD_TYPE PROPERTY STRINGS "Debug" "Release" "MinSizeRel" "RelWithDebInfo")
			endif()

			#########################################################################
		]])
		if os.is("windows") then
			-- Add support for CMP0091, see https://cmake.org/cmake/help/latest/policy/CMP0091.html
			f:write('cmake_policy(SET CMP0091 NEW)\n')
		end
		f:write('add_subdirectory('.. path.getrelative(_WORKING_DIR, sln.location) ..')\n')
		f:close()
	end
	_p([[
		# CMakeLists autogenerated by GENie
		cmake_minimum_required(VERSION 3.15)
	]])
	if os.is("windows") then
		-- Add support for CMP0091, see https://cmake.org/cmake/help/latest/policy/CMP0091.html
		_p('cmake_policy(SET CMP0091 NEW)')
	end
	for i,prj in ipairs(sln.projects) do
		local name = premake.esc(prj.name)
		_p('add_subdirectory(%s)', name)
	end
end
