#pragma clang diagnostic ignored "-Wmissing-prototypes"
#pragma clang diagnostic ignored "-Wmissing-braces"

#include <metal_stdlib>
#include <simd/simd.h>

using namespace metal;

template<typename T, size_t Num>
struct spvUnsafeArray
{
    T elements[Num ? Num : 1];
    
    thread T& operator [] (size_t pos) thread
    {
        return elements[pos];
    }
    constexpr const thread T& operator [] (size_t pos) const thread
    {
        return elements[pos];
    }
    
    device T& operator [] (size_t pos) device
    {
        return elements[pos];
    }
    constexpr const device T& operator [] (size_t pos) const device
    {
        return elements[pos];
    }
    
    constexpr const constant T& operator [] (size_t pos) const constant
    {
        return elements[pos];
    }
    
    threadgroup T& operator [] (size_t pos) threadgroup
    {
        return elements[pos];
    }
    constexpr const threadgroup T& operator [] (size_t pos) const threadgroup
    {
        return elements[pos];
    }
};

struct type_Globals
{
    float4 MappingPolynomial;
    float3 InverseGamma;
    float4 ColorMatrixR_ColorCurveCd1;
    float4 ColorMatrixG_ColorCurveCd3Cm3;
    float4 ColorMatrixB_ColorCurveCm2;
    float4 ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3;
    float4 ColorCurve_Ch1_Ch2;
    float4 ColorShadow_Luma;
    float4 ColorShadow_Tint1;
    float4 ColorShadow_Tint2;
    float FilmSlope;
    float FilmToe;
    float FilmShoulder;
    float FilmBlackClip;
    float FilmWhiteClip;
    packed_float3 ColorScale;
    float4 OverlayColor;
    float WhiteTemp;
    float WhiteTint;
    float4 ColorSaturation;
    float4 ColorContrast;
    float4 ColorGamma;
    float4 ColorGain;
    float4 ColorOffset;
    float4 ColorSaturationShadows;
    float4 ColorContrastShadows;
    float4 ColorGammaShadows;
    float4 ColorGainShadows;
    float4 ColorOffsetShadows;
    float4 ColorSaturationMidtones;
    float4 ColorContrastMidtones;
    float4 ColorGammaMidtones;
    float4 ColorGainMidtones;
    float4 ColorOffsetMidtones;
    float4 ColorSaturationHighlights;
    float4 ColorContrastHighlights;
    float4 ColorGammaHighlights;
    float4 ColorGainHighlights;
    float4 ColorOffsetHighlights;
    float ColorCorrectionShadowsMax;
    float ColorCorrectionHighlightsMin;
    uint OutputDevice;
    uint OutputGamut;
    float BlueCorrection;
    float ExpandGamut;
};

constant spvUnsafeArray<float, 6> _475 = spvUnsafeArray<float, 6>({ -4.0, -4.0, -3.1573765277862548828125, -0.485249996185302734375, 1.84773242473602294921875, 1.84773242473602294921875 });
constant spvUnsafeArray<float, 6> _476 = spvUnsafeArray<float, 6>({ -0.718548238277435302734375, 2.0810306072235107421875, 3.66812419891357421875, 4.0, 4.0, 4.0 });
constant spvUnsafeArray<float, 10> _479 = spvUnsafeArray<float, 10>({ -4.97062206268310546875, -3.0293781757354736328125, -2.1261999607086181640625, -1.5104999542236328125, -1.0578000545501708984375, -0.4668000042438507080078125, 0.11937999725341796875, 0.7088134288787841796875, 1.2911865711212158203125, 1.2911865711212158203125 });
constant spvUnsafeArray<float, 10> _480 = spvUnsafeArray<float, 10>({ 0.80891323089599609375, 1.19108676910400390625, 1.5683000087738037109375, 1.94830000400543212890625, 2.308300018310546875, 2.63840007781982421875, 2.85949993133544921875, 2.9872608184814453125, 3.0127391815185546875, 3.0127391815185546875 });
constant spvUnsafeArray<float, 10> _482 = spvUnsafeArray<float, 10>({ -2.3010299205780029296875, -2.3010299205780029296875, -1.9312000274658203125, -1.5204999446868896484375, -1.0578000545501708984375, -0.4668000042438507080078125, 0.11937999725341796875, 0.7088134288787841796875, 1.2911865711212158203125, 1.2911865711212158203125 });
constant spvUnsafeArray<float, 10> _483 = spvUnsafeArray<float, 10>({ 0.801995217800140380859375, 1.19800484180450439453125, 1.5943000316619873046875, 1.99730002880096435546875, 2.3782999515533447265625, 2.7683999538421630859375, 3.0515000820159912109375, 3.2746293544769287109375, 3.32743072509765625, 3.32743072509765625 });

constant float3 _391 = {};

struct main0_out
{
    float4 out_var_SV_Target0 [[color(0)]];
};

struct main0_in
{
    float2 in_var_TEXCOORD0 [[user(locn0), center_no_perspective]];
};

fragment main0_out main0(main0_in in [[stage_in]], constant type_Globals& _Globals [[buffer(0)]], uint gl_Layer [[render_target_array_index]])
{
    main0_out out = {};
    float3x3 _546 = float3x3(float3(0.41245639324188232421875, 0.3575761020183563232421875, 0.180437505245208740234375), float3(0.21267290413379669189453125, 0.715152204036712646484375, 0.072175003588199615478515625), float3(0.01933390088379383087158203125, 0.119191996753215789794921875, 0.950304090976715087890625)) * float3x3(float3(1.01303005218505859375, 0.0061053098179399967193603515625, -0.014971000142395496368408203125), float3(0.0076982299797236919403076171875, 0.99816501140594482421875, -0.005032029934227466583251953125), float3(-0.0028413101099431514739990234375, 0.0046851597726345062255859375, 0.92450702190399169921875));
    float3x3 _547 = _546 * float3x3(float3(1.6410233974456787109375, -0.324803292751312255859375, -0.23642469942569732666015625), float3(-0.663662850856781005859375, 1.6153316497802734375, 0.016756348311901092529296875), float3(0.01172189414501190185546875, -0.008284442126750946044921875, 0.98839485645294189453125));
    float3x3 _548 = float3x3(float3(0.662454187870025634765625, 0.1340042054653167724609375, 0.1561876833438873291015625), float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625), float3(-0.0055746496655046939849853515625, 0.0040607335977256298065185546875, 1.01033914089202880859375)) * float3x3(float3(0.98722398281097412109375, -0.0061132698319852352142333984375, 0.01595330052077770233154296875), float3(-0.007598360069096088409423828125, 1.00186002254486083984375, 0.0053300200961530208587646484375), float3(0.003072570078074932098388671875, -0.0050959498621523380279541015625, 1.0816800594329833984375));
    float3x3 _549 = _548 * float3x3(float3(3.2409698963165283203125, -1.53738319873809814453125, -0.4986107647418975830078125), float3(-0.96924364566802978515625, 1.875967502593994140625, 0.0415550582110881805419921875), float3(0.055630080401897430419921875, -0.2039769589900970458984375, 1.05697154998779296875));
    float3x3 _550 = float3x3(float3(0.952552378177642822265625, 0.0, 9.25), float3(0.3439664542675018310546875, 0.728166103363037109375, -0.07213254272937774658203125), float3(0.0, 0.0, 1.00882518291473388671875)) * float3x3(float3(1.6410233974456787109375, -0.324803292751312255859375, -0.23642469942569732666015625), float3(-0.663662850856781005859375, 1.6153316497802734375, 0.016756348311901092529296875), float3(0.01172189414501190185546875, -0.008284442126750946044921875, 0.98839485645294189453125));
    float3x3 _551 = float3x3(float3(0.662454187870025634765625, 0.1340042054653167724609375, 0.1561876833438873291015625), float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625), float3(-0.0055746496655046939849853515625, 0.0040607335977256298065185546875, 1.01033914089202880859375)) * float3x3(float3(1.04981100559234619140625, 0.0, -9.74845024757087230682373046875e-05), float3(-0.49590301513671875, 1.37331306934356689453125, 0.09824003279209136962890625), float3(0.0, 0.0, 0.991252005100250244140625));
    float3x3 _576;
    for (;;)
    {
        if (_Globals.OutputGamut == 1u)
        {
            _576 = _548 * float3x3(float3(2.493396282196044921875, -0.931345880031585693359375, -0.4026944935321807861328125), float3(-0.829486787319183349609375, 1.76265966892242431640625, 0.02362460084259510040283203125), float3(0.0358506999909877777099609375, -0.076182700693607330322265625, 0.957014024257659912109375));
            break;
        }
        else
        {
            if (_Globals.OutputGamut == 2u)
            {
                _576 = _548 * float3x3(float3(1.71660840511322021484375, -0.3556621074676513671875, -0.253360092639923095703125), float3(-0.666682898998260498046875, 1.61647760868072509765625, 0.01576850004494190216064453125), float3(0.017642199993133544921875, -0.04277630150318145751953125, 0.94222867488861083984375));
                break;
            }
            else
            {
                if (_Globals.OutputGamut == 3u)
                {
                    _576 = float3x3(float3(0.695452213287353515625, 0.140678703784942626953125, 0.16386906802654266357421875), float3(0.0447945632040500640869140625, 0.859671115875244140625, 0.095534317195415496826171875), float3(-0.0055258828215301036834716796875, 0.0040252101607620716094970703125, 1.00150072574615478515625));
                    break;
                }
                else
                {
                    if (_Globals.OutputGamut == 4u)
                    {
                        _576 = float3x3(float3(1.0, 0.0, 0.0), float3(0.0, 1.0, 0.0), float3(0.0, 0.0, 1.0));
                        break;
                    }
                    else
                    {
                        _576 = _549;
                        break;
                    }
                }
            }
        }
    }
    float3 _577 = float4((in.in_var_TEXCOORD0 - float2(0.015625)) * float2(1.03225803375244140625), float(gl_Layer) * 0.0322580635547637939453125, 0.0).xyz;
    float3 _599;
    if (_Globals.OutputDevice >= 3u)
    {
        float3 _591 = pow(_577, float3(0.0126833133399486541748046875));
        _599 = pow(fast::max(float3(0.0), _591 - float3(0.8359375)) / (float3(18.8515625) - (float3(18.6875) * _591)), float3(6.277394771575927734375)) * float3(10000.0);
    }
    else
    {
        _599 = (exp2((_577 - float3(0.434017598628997802734375)) * float3(14.0)) * float3(0.180000007152557373046875)) - (exp2(float3(-6.0762462615966796875)) * float3(0.180000007152557373046875));
    }
    float _602 = _Globals.WhiteTemp * 1.00055634975433349609375;
    float _616 = (_602 <= 7000.0) ? (0.24406300485134124755859375 + ((99.1100006103515625 + ((2967800.0 - (4604438528.0 / _Globals.WhiteTemp)) / _602)) / _602)) : (0.23703999817371368408203125 + ((247.4799957275390625 + ((1901800.0 - (2005284352.0 / _Globals.WhiteTemp)) / _602)) / _602));
    float _633 = ((0.860117733478546142578125 + (0.00015411825734190642833709716796875 * _Globals.WhiteTemp)) + ((1.2864121856637211749330163002014e-07 * _Globals.WhiteTemp) * _Globals.WhiteTemp)) / ((1.0 + (0.0008424202096648514270782470703125 * _Globals.WhiteTemp)) + ((7.0814513719597016461193561553955e-07 * _Globals.WhiteTemp) * _Globals.WhiteTemp));
    float _644 = ((0.317398726940155029296875 + (4.25 * _Globals.WhiteTemp)) + ((4.2048167614439080352894961833954e-08 * _Globals.WhiteTemp) * _Globals.WhiteTemp)) / ((1.0 - (2.8974181986995972692966461181641e-05 * _Globals.WhiteTemp)) + ((1.6145605741257895715534687042236e-07 * _Globals.WhiteTemp) * _Globals.WhiteTemp));
    float _649 = ((2.0 * _633) - (8.0 * _644)) + 4.0;
    float2 _653 = float2((3.0 * _633) / _649, (2.0 * _644) / _649);
    float2 _660 = normalize(float2(_633, _644));
    float _665 = _633 + (((-_660.y) * _Globals.WhiteTint) * 0.0500000007450580596923828125);
    float _669 = _644 + ((_660.x * _Globals.WhiteTint) * 0.0500000007450580596923828125);
    float _674 = ((2.0 * _665) - (8.0 * _669)) + 4.0;
    float2 _680 = select(float2(_616, ((((-3.0) * _616) * _616) + (2.86999988555908203125 * _616)) - 0.2750000059604644775390625), _653, bool2(_Globals.WhiteTemp < 4000.0)) + (float2((3.0 * _665) / _674, (2.0 * _669) / _674) - _653);
    float _681 = _680.x;
    float _682 = _680.y;
    float _683 = fast::max(_682, 1.0000000133514319600180897396058e-10);
    float3 _685 = _391;
    _685.x = _681 / _683;
    float3 _686 = _685;
    _686.y = 1.0;
    float3 _690 = _686;
    _690.z = ((1.0 - _681) - _682) / _683;
    float3 _693 = _391;
    _693.x = 0.950455963611602783203125;
    float3 _694 = _693;
    _694.y = 1.0;
    float3 _696 = _694;
    _696.z = 1.0890576839447021484375;
    float3 _697 = _690 * float3x3(float3(0.89509999752044677734375, 0.2664000093936920166015625, -0.16140000522136688232421875), float3(-0.750199973583221435546875, 1.71350002288818359375, 0.0366999991238117218017578125), float3(0.0388999991118907928466796875, -0.06849999725818634033203125, 1.02960002422332763671875));
    float3 _698 = _696 * float3x3(float3(0.89509999752044677734375, 0.2664000093936920166015625, -0.16140000522136688232421875), float3(-0.750199973583221435546875, 1.71350002288818359375, 0.0366999991238117218017578125), float3(0.0388999991118907928466796875, -0.06849999725818634033203125, 1.02960002422332763671875));
    float3 _717 = (_599 * ((float3x3(float3(0.41245639324188232421875, 0.3575761020183563232421875, 0.180437505245208740234375), float3(0.21267290413379669189453125, 0.715152204036712646484375, 0.072175003588199615478515625), float3(0.01933390088379383087158203125, 0.119191996753215789794921875, 0.950304090976715087890625)) * ((float3x3(float3(0.89509999752044677734375, 0.2664000093936920166015625, -0.16140000522136688232421875), float3(-0.750199973583221435546875, 1.71350002288818359375, 0.0366999991238117218017578125), float3(0.0388999991118907928466796875, -0.06849999725818634033203125, 1.02960002422332763671875)) * float3x3(float3(_698.x / _697.x, 0.0, 0.0), float3(0.0, _698.y / _697.y, 0.0), float3(0.0, 0.0, _698.z / _697.z))) * float3x3(float3(0.986992895603179931640625, -0.14705429971218109130859375, 0.15996269881725311279296875), float3(0.4323053061962127685546875, 0.518360316753387451171875, 0.049291200935840606689453125), float3(-0.00852870009839534759521484375, 0.0400427989661693572998046875, 0.968486726284027099609375)))) * float3x3(float3(3.2409698963165283203125, -1.53738319873809814453125, -0.4986107647418975830078125), float3(-0.96924364566802978515625, 1.875967502593994140625, 0.0415550582110881805419921875), float3(0.055630080401897430419921875, -0.2039769589900970458984375, 1.05697154998779296875)))) * _547;
    float3 _745;
    if (_Globals.ColorShadow_Tint2.w != 0.0)
    {
        float _724 = dot(_717, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625));
        float3 _727 = (_717 / float3(_724)) - float3(1.0);
        _745 = mix(_717, _717 * (_549 * (float3x3(float3(0.544169127941131591796875, 0.23959259688854217529296875, 0.16669429838657379150390625), float3(0.23946559429168701171875, 0.702153027057647705078125, 0.058381401002407073974609375), float3(-0.0023439000360667705535888671875, 0.0361833982169628143310546875, 1.05521833896636962890625)) * float3x3(float3(1.6410233974456787109375, -0.324803292751312255859375, -0.23642469942569732666015625), float3(-0.663662850856781005859375, 1.6153316497802734375, 0.016756348311901092529296875), float3(0.01172189414501190185546875, -0.008284442126750946044921875, 0.98839485645294189453125)))), float3((1.0 - exp2((-4.0) * dot(_727, _727))) * (1.0 - exp2((((-4.0) * _Globals.ExpandGamut) * _724) * _724))));
    }
    else
    {
        _745 = _717;
    }
    float _746 = dot(_745, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625));
    float4 _751 = _Globals.ColorSaturationShadows * _Globals.ColorSaturation;
    float4 _756 = _Globals.ColorContrastShadows * _Globals.ColorContrast;
    float4 _761 = _Globals.ColorGammaShadows * _Globals.ColorGamma;
    float4 _766 = _Globals.ColorGainShadows * _Globals.ColorGain;
    float4 _771 = _Globals.ColorOffsetShadows + _Globals.ColorOffset;
    float3 _772 = float3(_746);
    float _804 = smoothstep(0.0, _Globals.ColorCorrectionShadowsMax, _746);
    float4 _808 = _Globals.ColorSaturationHighlights * _Globals.ColorSaturation;
    float4 _811 = _Globals.ColorContrastHighlights * _Globals.ColorContrast;
    float4 _814 = _Globals.ColorGammaHighlights * _Globals.ColorGamma;
    float4 _817 = _Globals.ColorGainHighlights * _Globals.ColorGain;
    float4 _820 = _Globals.ColorOffsetHighlights + _Globals.ColorOffset;
    float _852 = smoothstep(_Globals.ColorCorrectionHighlightsMin, 1.0, _746);
    float4 _855 = _Globals.ColorSaturationMidtones * _Globals.ColorSaturation;
    float4 _858 = _Globals.ColorContrastMidtones * _Globals.ColorContrast;
    float4 _861 = _Globals.ColorGammaMidtones * _Globals.ColorGamma;
    float4 _864 = _Globals.ColorGainMidtones * _Globals.ColorGain;
    float4 _867 = _Globals.ColorOffsetMidtones + _Globals.ColorOffset;
    float3 _905 = ((((pow(pow(fast::max(float3(0.0), mix(_772, _745, _751.xyz * float3(_751.w))) * float3(5.5555553436279296875), _756.xyz * float3(_756.w)) * float3(0.180000007152557373046875), float3(1.0) / (_761.xyz * float3(_761.w))) * (_766.xyz * float3(_766.w))) + (_771.xyz + float3(_771.w))) * float3(1.0 - _804)) + (((pow(pow(fast::max(float3(0.0), mix(_772, _745, _855.xyz * float3(_855.w))) * float3(5.5555553436279296875), _858.xyz * float3(_858.w)) * float3(0.180000007152557373046875), float3(1.0) / (_861.xyz * float3(_861.w))) * (_864.xyz * float3(_864.w))) + (_867.xyz + float3(_867.w))) * float3(_804 - _852))) + (((pow(pow(fast::max(float3(0.0), mix(_772, _745, _808.xyz * float3(_808.w))) * float3(5.5555553436279296875), _811.xyz * float3(_811.w)) * float3(0.180000007152557373046875), float3(1.0) / (_814.xyz * float3(_814.w))) * (_817.xyz * float3(_817.w))) + (_820.xyz + float3(_820.w))) * float3(_852));
    float3 _906 = _905 * _549;
    float3 _914 = float3(_Globals.BlueCorrection);
    float3 _916 = mix(_905, _905 * ((_551 * float3x3(float3(0.940437257289886474609375, -0.01830687932670116424560546875, 0.07786960899829864501953125), float3(0.008378696627914905548095703125, 0.82866001129150390625, 0.162961304187774658203125), float3(0.0005471261101774871349334716796875, -0.00088337459601461887359619140625, 1.00033628940582275390625))) * _550), _914) * _551;
    float _917 = _916.x;
    float _918 = _916.y;
    float _920 = _916.z;
    float _923 = fast::max(fast::max(_917, _918), _920);
    float _928 = (fast::max(_923, 1.0000000133514319600180897396058e-10) - fast::max(fast::min(fast::min(_917, _918), _920), 1.0000000133514319600180897396058e-10)) / fast::max(_923, 0.00999999977648258209228515625);
    float _941 = ((_920 + _918) + _917) + (1.75 * sqrt(((_920 * (_920 - _918)) + (_918 * (_918 - _917))) + (_917 * (_917 - _920))));
    float _942 = _941 * 0.3333333432674407958984375;
    float _943 = _928 - 0.4000000059604644775390625;
    float _948 = fast::max(1.0 - abs(_943 * 2.5), 0.0);
    float _956 = (1.0 + (float(int(sign(_943 * 5.0))) * (1.0 - (_948 * _948)))) * 0.02500000037252902984619140625;
    float _969;
    if (_942 <= 0.053333334624767303466796875)
    {
        _969 = _956;
    }
    else
    {
        float _968;
        if (_942 >= 0.1599999964237213134765625)
        {
            _968 = 0.0;
        }
        else
        {
            _968 = _956 * ((0.23999999463558197021484375 / _941) - 0.5);
        }
        _969 = _968;
    }
    float3 _972 = _916 * float3(1.0 + _969);
    float _973 = _972.x;
    float _974 = _972.y;
    float _976 = _972.z;
    float _990;
    if ((_973 == _974) && (_974 == _976))
    {
        _990 = 0.0;
    }
    else
    {
        _990 = 57.2957763671875 * atan2(sqrt(3.0) * (_974 - _976), ((2.0 * _973) - _974) - _976);
    }
    float _995;
    if (_990 < 0.0)
    {
        _995 = _990 + 360.0;
    }
    else
    {
        _995 = _990;
    }
    float _996 = fast::clamp(_995, 0.0, 360.0);
    float _1001;
    if (_996 > 180.0)
    {
        _1001 = _996 - 360.0;
    }
    else
    {
        _1001 = _996;
    }
    float _1005 = smoothstep(0.0, 1.0, 1.0 - abs(_1001 * 0.01481481455266475677490234375));
    float3 _1012 = _972;
    _1012.x = _973 + ((((_1005 * _1005) * _928) * (0.02999999932944774627685546875 - _973)) * 0.180000007152557373046875);
    float3 _1014 = fast::max(float3(0.0), _1012 * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375)));
    float _1023 = (1.0 + _Globals.FilmBlackClip) - _Globals.FilmToe;
    float _1026 = 1.0 + _Globals.FilmWhiteClip;
    float _1029 = _1026 - _Globals.FilmShoulder;
    float _1056;
    if (_Globals.FilmToe > 0.800000011920928955078125)
    {
        _1056 = ((0.819999992847442626953125 - _Globals.FilmToe) / _Globals.FilmSlope) + (log(0.180000007152557373046875) / log(10.0));
    }
    else
    {
        float _1035 = (0.180000007152557373046875 + _Globals.FilmBlackClip) / _1023;
        _1056 = (log(0.180000007152557373046875) / log(10.0)) - ((0.5 * log(_1035 / (2.0 - _1035))) * (_1023 / _Globals.FilmSlope));
    }
    float _1061 = ((1.0 - _Globals.FilmToe) / _Globals.FilmSlope) - _1056;
    float _1063 = (_Globals.FilmShoulder / _Globals.FilmSlope) - _1061;
    float _1065 = log(10.0);
    float3 _1067 = log(mix(float3(dot(_1014, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625))), _1014, float3(0.959999978542327880859375))) / float3(_1065);
    float3 _1071 = float3(_Globals.FilmSlope) * (_1067 + float3(_1061));
    float3 _1079 = float3(_1056);
    float3 _1080 = _1067 - _1079;
    float3 _1092 = float3(_1063);
    float3 _1106 = fast::clamp(_1080 / float3(_1063 - _1056), float3(0.0), float3(1.0));
    float3 _1110 = select(_1106, float3(1.0) - _1106, bool3(_1063 < _1056));
    float3 _1115 = mix(select(_1071, float3(-_Globals.FilmBlackClip) + (float3(2.0 * _1023) / (float3(1.0) + exp(float3(((-2.0) * _Globals.FilmSlope) / _1023) * _1080))), _1067 < _1079), select(_1071, float3(_1026) - (float3(2.0 * _1029) / (float3(1.0) + exp(float3((2.0 * _Globals.FilmSlope) / _1029) * (_1067 - _1092)))), _1067 > _1092), ((float3(3.0) - (float3(2.0) * _1110)) * _1110) * _1110);
    float3 _1119 = fast::max(float3(0.0), mix(float3(dot(_1115, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625))), _1115, float3(0.930000007152557373046875)));
    float3 _1189;
    if (_Globals.ColorShadow_Tint2.w == 0.0)
    {
        float3 _1131 = _391;
        _1131.x = dot(_906, _Globals.ColorMatrixR_ColorCurveCd1.xyz);
        float3 _1136 = _1131;
        _1136.y = dot(_906, _Globals.ColorMatrixG_ColorCurveCd3Cm3.xyz);
        float3 _1141 = _1136;
        _1141.z = dot(_906, _Globals.ColorMatrixB_ColorCurveCm2.xyz);
        float3 _1157 = fast::max(float3(0.0), _1141 * (_Globals.ColorShadow_Tint1.xyz + (_Globals.ColorShadow_Tint2.xyz * float3(1.0 / (dot(_906, _Globals.ColorShadow_Luma.xyz) + 1.0)))));
        float3 _1162 = fast::max(float3(0.0), _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.xxx - _1157);
        float3 _1164 = fast::max(_1157, _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.zzz);
        _1189 = ((((_1164 * _Globals.ColorCurve_Ch1_Ch2.xxx) + _Globals.ColorCurve_Ch1_Ch2.yyy) * (float3(1.0) / (_1164 + _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.www))) + ((fast::clamp(_1157, _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.xxx, _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.zzz) * _Globals.ColorMatrixB_ColorCurveCm2.www) + (((_1162 * _Globals.ColorMatrixR_ColorCurveCd1.www) * (float3(1.0) / (_1162 + _Globals.ColorCurve_Cm0Cd0_Cd2_Ch0Cm1_Ch3.yyy))) + _Globals.ColorMatrixG_ColorCurveCd3Cm3.www))) - float3(0.00200000009499490261077880859375);
    }
    else
    {
        _1189 = fast::max(float3(0.0), mix(_1119, _1119 * ((_551 * float3x3(float3(1.06317996978759765625, 0.02339559979736804962158203125, -0.08657260239124298095703125), float3(-0.010633699595928192138671875, 1.2063200473785400390625, -0.1956900060176849365234375), float3(-0.0005908869788981974124908447265625, 0.00105247995816171169281005859375, 0.999538004398345947265625))) * _550), _914) * _549);
    }
    float3 _1218 = pow(fast::max(float3(0.0), mix((((float3(_Globals.MappingPolynomial.x) * (_1189 * _1189)) + (float3(_Globals.MappingPolynomial.y) * _1189)) + float3(_Globals.MappingPolynomial.z)) * float3(_Globals.ColorScale), _Globals.OverlayColor.xyz, float3(_Globals.OverlayColor.w))), float3(_Globals.InverseGamma.y));
    float3 _3001;
    if (_Globals.OutputDevice == 0u)
    {
        float _2961 = _1218.x;
        float _2973;
        for (;;)
        {
            if (_2961 < 0.00313066993840038776397705078125)
            {
                _2973 = _2961 * 12.9200000762939453125;
                break;
            }
            _2973 = (pow(_2961, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
            break;
        }
        float _2974 = _1218.y;
        float _2986;
        for (;;)
        {
            if (_2974 < 0.00313066993840038776397705078125)
            {
                _2986 = _2974 * 12.9200000762939453125;
                break;
            }
            _2986 = (pow(_2974, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
            break;
        }
        float _2987 = _1218.z;
        float _2999;
        for (;;)
        {
            if (_2987 < 0.00313066993840038776397705078125)
            {
                _2999 = _2987 * 12.9200000762939453125;
                break;
            }
            _2999 = (pow(_2987, 0.4166666567325592041015625) * 1.05499994754791259765625) - 0.054999999701976776123046875;
            break;
        }
        _3001 = float3(_2973, _2986, _2999);
    }
    else
    {
        float3 _2960;
        if (_Globals.OutputDevice == 1u)
        {
            float3 _2953 = fast::max(float3(6.1035199905745685100555419921875e-05), (_1218 * _547) * _576);
            _2960 = fast::min(_2953 * float3(4.5), (pow(fast::max(_2953, float3(0.017999999225139617919921875)), float3(0.449999988079071044921875)) * float3(1.09899997711181640625)) - float3(0.098999999463558197021484375));
        }
        else
        {
            float3 _2950;
            if ((_Globals.OutputDevice == 3u) || (_Globals.OutputDevice == 5u))
            {
                float3 _2100 = (_906 * float3(1.5)) * (_546 * float3x3(float3(1.04981100559234619140625, 0.0, -9.74845024757087230682373046875e-05), float3(-0.49590301513671875, 1.37331306934356689453125, 0.09824003279209136962890625), float3(0.0, 0.0, 0.991252005100250244140625)));
                float _2101 = _2100.x;
                float _2102 = _2100.y;
                float _2104 = _2100.z;
                float _2107 = fast::max(fast::max(_2101, _2102), _2104);
                float _2112 = (fast::max(_2107, 1.0000000133514319600180897396058e-10) - fast::max(fast::min(fast::min(_2101, _2102), _2104), 1.0000000133514319600180897396058e-10)) / fast::max(_2107, 0.00999999977648258209228515625);
                float _2125 = ((_2104 + _2102) + _2101) + (1.75 * sqrt(((_2104 * (_2104 - _2102)) + (_2102 * (_2102 - _2101))) + (_2101 * (_2101 - _2104))));
                float _2126 = _2125 * 0.3333333432674407958984375;
                float _2127 = _2112 - 0.4000000059604644775390625;
                float _2132 = fast::max(1.0 - abs(_2127 * 2.5), 0.0);
                float _2140 = (1.0 + (float(int(sign(_2127 * 5.0))) * (1.0 - (_2132 * _2132)))) * 0.02500000037252902984619140625;
                float _2153;
                if (_2126 <= 0.053333334624767303466796875)
                {
                    _2153 = _2140;
                }
                else
                {
                    float _2152;
                    if (_2126 >= 0.1599999964237213134765625)
                    {
                        _2152 = 0.0;
                    }
                    else
                    {
                        _2152 = _2140 * ((0.23999999463558197021484375 / _2125) - 0.5);
                    }
                    _2153 = _2152;
                }
                float3 _2156 = _2100 * float3(1.0 + _2153);
                float _2157 = _2156.x;
                float _2158 = _2156.y;
                float _2160 = _2156.z;
                float _2174;
                if ((_2157 == _2158) && (_2158 == _2160))
                {
                    _2174 = 0.0;
                }
                else
                {
                    _2174 = 57.2957763671875 * atan2(sqrt(3.0) * (_2158 - _2160), ((2.0 * _2157) - _2158) - _2160);
                }
                float _2179;
                if (_2174 < 0.0)
                {
                    _2179 = _2174 + 360.0;
                }
                else
                {
                    _2179 = _2174;
                }
                float _2180 = fast::clamp(_2179, 0.0, 360.0);
                float _2185;
                if (_2180 > 180.0)
                {
                    _2185 = _2180 - 360.0;
                }
                else
                {
                    _2185 = _2180;
                }
                float _2235;
                if ((_2185 > (-67.5)) && (_2185 < 67.5))
                {
                    float _2192 = (_2185 - (-67.5)) * 0.0296296291053295135498046875;
                    int _2193 = int(_2192);
                    float _2195 = _2192 - float(_2193);
                    float _2196 = _2195 * _2195;
                    float _2197 = _2196 * _2195;
                    float _2234;
                    if (_2193 == 3)
                    {
                        _2234 = (((_2197 * (-0.16666667163372039794921875)) + (_2196 * 0.5)) + (_2195 * (-0.5))) + 0.16666667163372039794921875;
                    }
                    else
                    {
                        float _2227;
                        if (_2193 == 2)
                        {
                            _2227 = ((_2197 * 0.5) + (_2196 * (-1.0))) + 0.666666686534881591796875;
                        }
                        else
                        {
                            float _2222;
                            if (_2193 == 1)
                            {
                                _2222 = (((_2197 * (-0.5)) + (_2196 * 0.5)) + (_2195 * 0.5)) + 0.16666667163372039794921875;
                            }
                            else
                            {
                                float _2215;
                                if (_2193 == 0)
                                {
                                    _2215 = _2197 * 0.16666667163372039794921875;
                                }
                                else
                                {
                                    _2215 = 0.0;
                                }
                                _2222 = _2215;
                            }
                            _2227 = _2222;
                        }
                        _2234 = _2227;
                    }
                    _2235 = _2234;
                }
                else
                {
                    _2235 = 0.0;
                }
                float3 _2242 = _2156;
                _2242.x = _2157 + ((((_2235 * 1.5) * _2112) * (0.02999999932944774627685546875 - _2157)) * 0.180000007152557373046875);
                float3 _2245 = fast::clamp(fast::clamp(_2242, float3(0.0), float3(65535.0)) * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375)), float3(0.0), float3(65535.0));
                float3 _2248 = mix(float3(dot(_2245, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625))), _2245, float3(0.959999978542327880859375));
                float _2249 = _2248.x;
                float _2253 = 0.17999999225139617919921875 * exp2(18.0);
                float _2255 = exp2(-14.0);
                float _2258 = log((_2249 <= 0.0) ? _2255 : _2249) / _1065;
                float _2260 = log(0.17999999225139617919921875 * exp2(-15.0)) / _1065;
                float _2327;
                if (_2258 <= _2260)
                {
                    _2327 = log(9.9999997473787516355514526367188e-05) / _1065;
                }
                else
                {
                    float _2267 = log(0.180000007152557373046875) / _1065;
                    float _2324;
                    if ((_2258 > _2260) && (_2258 < _2267))
                    {
                        float _2307 = (3.0 * (_2258 - _2260)) / (_2267 - _2260);
                        int _2308 = int(_2307);
                        float _2310 = _2307 - float(_2308);
                        _2324 = dot(float3(_2310 * _2310, _2310, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_2308], _475[_2308 + 1], _475[_2308 + 2]));
                    }
                    else
                    {
                        float _2275 = log(_2253) / _1065;
                        float _2303;
                        if ((_2258 >= _2267) && (_2258 < _2275))
                        {
                            float _2286 = (3.0 * (_2258 - _2267)) / (_2275 - _2267);
                            int _2287 = int(_2286);
                            float _2289 = _2286 - float(_2287);
                            _2303 = dot(float3(_2289 * _2289, _2289, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_2287], _476[_2287 + 1], _476[_2287 + 2]));
                        }
                        else
                        {
                            _2303 = log(10000.0) / _1065;
                        }
                        _2324 = _2303;
                    }
                    _2327 = _2324;
                }
                float3 _2329 = _391;
                _2329.x = pow(10.0, _2327);
                float _2330 = _2248.y;
                float _2334 = log((_2330 <= 0.0) ? _2255 : _2330) / _1065;
                float _2401;
                if (_2334 <= _2260)
                {
                    _2401 = log(9.9999997473787516355514526367188e-05) / _1065;
                }
                else
                {
                    float _2341 = log(0.180000007152557373046875) / _1065;
                    float _2398;
                    if ((_2334 > _2260) && (_2334 < _2341))
                    {
                        float _2381 = (3.0 * (_2334 - _2260)) / (_2341 - _2260);
                        int _2382 = int(_2381);
                        float _2384 = _2381 - float(_2382);
                        _2398 = dot(float3(_2384 * _2384, _2384, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_2382], _475[_2382 + 1], _475[_2382 + 2]));
                    }
                    else
                    {
                        float _2349 = log(_2253) / _1065;
                        float _2377;
                        if ((_2334 >= _2341) && (_2334 < _2349))
                        {
                            float _2360 = (3.0 * (_2334 - _2341)) / (_2349 - _2341);
                            int _2361 = int(_2360);
                            float _2363 = _2360 - float(_2361);
                            _2377 = dot(float3(_2363 * _2363, _2363, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_2361], _476[_2361 + 1], _476[_2361 + 2]));
                        }
                        else
                        {
                            _2377 = log(10000.0) / _1065;
                        }
                        _2398 = _2377;
                    }
                    _2401 = _2398;
                }
                float3 _2403 = _2329;
                _2403.y = pow(10.0, _2401);
                float _2404 = _2248.z;
                float _2408 = log((_2404 <= 0.0) ? _2255 : _2404) / _1065;
                float _2475;
                if (_2408 <= _2260)
                {
                    _2475 = log(9.9999997473787516355514526367188e-05) / _1065;
                }
                else
                {
                    float _2415 = log(0.180000007152557373046875) / _1065;
                    float _2472;
                    if ((_2408 > _2260) && (_2408 < _2415))
                    {
                        float _2455 = (3.0 * (_2408 - _2260)) / (_2415 - _2260);
                        int _2456 = int(_2455);
                        float _2458 = _2455 - float(_2456);
                        _2472 = dot(float3(_2458 * _2458, _2458, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_2456], _475[_2456 + 1], _475[_2456 + 2]));
                    }
                    else
                    {
                        float _2423 = log(_2253) / _1065;
                        float _2451;
                        if ((_2408 >= _2415) && (_2408 < _2423))
                        {
                            float _2434 = (3.0 * (_2408 - _2415)) / (_2423 - _2415);
                            int _2435 = int(_2434);
                            float _2437 = _2434 - float(_2435);
                            _2451 = dot(float3(_2437 * _2437, _2437, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_2435], _476[_2435 + 1], _476[_2435 + 2]));
                        }
                        else
                        {
                            _2451 = log(10000.0) / _1065;
                        }
                        _2472 = _2451;
                    }
                    _2475 = _2472;
                }
                float3 _2477 = _2403;
                _2477.z = pow(10.0, _2475);
                float3 _2479 = (_2477 * float3x3(float3(0.695452213287353515625, 0.140678703784942626953125, 0.16386906802654266357421875), float3(0.0447945632040500640869140625, 0.859671115875244140625, 0.095534317195415496826171875), float3(-0.0055258828215301036834716796875, 0.0040252101607620716094970703125, 1.00150072574615478515625))) * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375));
                float _2481 = 0.17999999225139617919921875 * pow(2.0, -12.0);
                float _2485 = log((_2481 <= 0.0) ? _2255 : _2481) / _1065;
                float _2552;
                if (_2485 <= _2260)
                {
                    _2552 = log(9.9999997473787516355514526367188e-05) / _1065;
                }
                else
                {
                    float _2492 = log(0.180000007152557373046875) / _1065;
                    float _2549;
                    if ((_2485 > _2260) && (_2485 < _2492))
                    {
                        float _2532 = (3.0 * (_2485 - _2260)) / (_2492 - _2260);
                        int _2533 = int(_2532);
                        float _2535 = _2532 - float(_2533);
                        _2549 = dot(float3(_2535 * _2535, _2535, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_2533], _475[_2533 + 1], _475[_2533 + 2]));
                    }
                    else
                    {
                        float _2500 = log(_2253) / _1065;
                        float _2528;
                        if ((_2485 >= _2492) && (_2485 < _2500))
                        {
                            float _2511 = (3.0 * (_2485 - _2492)) / (_2500 - _2492);
                            int _2512 = int(_2511);
                            float _2514 = _2511 - float(_2512);
                            _2528 = dot(float3(_2514 * _2514, _2514, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_2512], _476[_2512 + 1], _476[_2512 + 2]));
                        }
                        else
                        {
                            _2528 = log(10000.0) / _1065;
                        }
                        _2549 = _2528;
                    }
                    _2552 = _2549;
                }
                float _2555 = log(0.180000007152557373046875) / _1065;
                float _2611;
                if (_2555 <= _2260)
                {
                    _2611 = log(9.9999997473787516355514526367188e-05) / _1065;
                }
                else
                {
                    float _2608;
                    if ((_2555 > _2260) && (_2555 < _2555))
                    {
                        _2608 = (float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(-0.485249996185302734375, 1.84773242473602294921875, 1.84773242473602294921875)).z;
                    }
                    else
                    {
                        float _2568 = log(_2253) / _1065;
                        float _2596;
                        if ((_2555 >= _2555) && (_2555 < _2568))
                        {
                            float _2579 = (3.0 * (_2555 - _2555)) / (_2568 - _2555);
                            int _2580 = int(_2579);
                            float _2582 = _2579 - float(_2580);
                            _2596 = dot(float3(_2582 * _2582, _2582, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_2580], _476[_2580 + 1], _476[_2580 + 2]));
                        }
                        else
                        {
                            _2596 = log(10000.0) / _1065;
                        }
                        _2608 = _2596;
                    }
                    _2611 = _2608;
                }
                float _2612 = pow(10.0, _2611);
                float _2614 = 0.17999999225139617919921875 * pow(2.0, 10.0);
                float _2618 = log((_2614 <= 0.0) ? _2255 : _2614) / _1065;
                float _2683;
                if (_2618 <= _2260)
                {
                    _2683 = log(9.9999997473787516355514526367188e-05) / _1065;
                }
                else
                {
                    float _2680;
                    if ((_2618 > _2260) && (_2618 < _2555))
                    {
                        float _2663 = (3.0 * (_2618 - _2260)) / (_2555 - _2260);
                        int _2664 = int(_2663);
                        float _2666 = _2663 - float(_2664);
                        _2680 = dot(float3(_2666 * _2666, _2666, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_2664], _475[_2664 + 1], _475[_2664 + 2]));
                    }
                    else
                    {
                        float _2631 = log(_2253) / _1065;
                        float _2659;
                        if ((_2618 >= _2555) && (_2618 < _2631))
                        {
                            float _2642 = (3.0 * (_2618 - _2555)) / (_2631 - _2555);
                            int _2643 = int(_2642);
                            float _2645 = _2642 - float(_2643);
                            _2659 = dot(float3(_2645 * _2645, _2645, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_2643], _476[_2643 + 1], _476[_2643 + 2]));
                        }
                        else
                        {
                            _2659 = log(10000.0) / _1065;
                        }
                        _2680 = _2659;
                    }
                    _2683 = _2680;
                }
                float _2684 = pow(10.0, _2683);
                float _2685 = _2479.x;
                float _2689 = log((_2685 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2685) / _1065;
                float _2690 = log(pow(10.0, _2552));
                float _2691 = _2690 / _1065;
                float _2768;
                if (_2689 <= _2691)
                {
                    _2768 = (_2689 * 3.0) + ((log(9.9999997473787516355514526367188e-05) / _1065) - ((3.0 * _2690) / _1065));
                }
                else
                {
                    float _2698 = log(_2612) / _1065;
                    float _2760;
                    if ((_2689 > _2691) && (_2689 < _2698))
                    {
                        float _2743 = (7.0 * (_2689 - _2691)) / (_2698 - _2691);
                        int _2744 = int(_2743);
                        float _2746 = _2743 - float(_2744);
                        _2760 = dot(float3(_2746 * _2746, _2746, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_479[_2744], _479[_2744 + 1], _479[_2744 + 2]));
                    }
                    else
                    {
                        float _2705 = log(_2684);
                        float _2706 = _2705 / _1065;
                        float _2739;
                        if ((_2689 >= _2698) && (_2689 < _2706))
                        {
                            float _2722 = (7.0 * (_2689 - _2698)) / (_2706 - _2698);
                            int _2723 = int(_2722);
                            float _2725 = _2722 - float(_2723);
                            _2739 = dot(float3(_2725 * _2725, _2725, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_480[_2723], _480[_2723 + 1], _480[_2723 + 2]));
                        }
                        else
                        {
                            _2739 = (_2689 * 0.0599999986588954925537109375) + ((log(1000.0) / _1065) - ((0.0599999986588954925537109375 * _2705) / _1065));
                        }
                        _2760 = _2739;
                    }
                    _2768 = _2760;
                }
                float3 _2770 = _391;
                _2770.x = pow(10.0, _2768);
                float _2771 = _2479.y;
                float _2775 = log((_2771 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2771) / _1065;
                float _2852;
                if (_2775 <= _2691)
                {
                    _2852 = (_2775 * 3.0) + ((log(9.9999997473787516355514526367188e-05) / _1065) - ((3.0 * _2690) / _1065));
                }
                else
                {
                    float _2782 = log(_2612) / _1065;
                    float _2844;
                    if ((_2775 > _2691) && (_2775 < _2782))
                    {
                        float _2827 = (7.0 * (_2775 - _2691)) / (_2782 - _2691);
                        int _2828 = int(_2827);
                        float _2830 = _2827 - float(_2828);
                        _2844 = dot(float3(_2830 * _2830, _2830, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_479[_2828], _479[_2828 + 1], _479[_2828 + 2]));
                    }
                    else
                    {
                        float _2789 = log(_2684);
                        float _2790 = _2789 / _1065;
                        float _2823;
                        if ((_2775 >= _2782) && (_2775 < _2790))
                        {
                            float _2806 = (7.0 * (_2775 - _2782)) / (_2790 - _2782);
                            int _2807 = int(_2806);
                            float _2809 = _2806 - float(_2807);
                            _2823 = dot(float3(_2809 * _2809, _2809, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_480[_2807], _480[_2807 + 1], _480[_2807 + 2]));
                        }
                        else
                        {
                            _2823 = (_2775 * 0.0599999986588954925537109375) + ((log(1000.0) / _1065) - ((0.0599999986588954925537109375 * _2789) / _1065));
                        }
                        _2844 = _2823;
                    }
                    _2852 = _2844;
                }
                float3 _2854 = _2770;
                _2854.y = pow(10.0, _2852);
                float _2855 = _2479.z;
                float _2859 = log((_2855 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2855) / _1065;
                float _2936;
                if (_2859 <= _2691)
                {
                    _2936 = (_2859 * 3.0) + ((log(9.9999997473787516355514526367188e-05) / _1065) - ((3.0 * _2690) / _1065));
                }
                else
                {
                    float _2866 = log(_2612) / _1065;
                    float _2928;
                    if ((_2859 > _2691) && (_2859 < _2866))
                    {
                        float _2911 = (7.0 * (_2859 - _2691)) / (_2866 - _2691);
                        int _2912 = int(_2911);
                        float _2914 = _2911 - float(_2912);
                        _2928 = dot(float3(_2914 * _2914, _2914, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_479[_2912], _479[_2912 + 1], _479[_2912 + 2]));
                    }
                    else
                    {
                        float _2873 = log(_2684);
                        float _2874 = _2873 / _1065;
                        float _2907;
                        if ((_2859 >= _2866) && (_2859 < _2874))
                        {
                            float _2890 = (7.0 * (_2859 - _2866)) / (_2874 - _2866);
                            int _2891 = int(_2890);
                            float _2893 = _2890 - float(_2891);
                            _2907 = dot(float3(_2893 * _2893, _2893, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_480[_2891], _480[_2891 + 1], _480[_2891 + 2]));
                        }
                        else
                        {
                            _2907 = (_2859 * 0.0599999986588954925537109375) + ((log(1000.0) / _1065) - ((0.0599999986588954925537109375 * _2873) / _1065));
                        }
                        _2928 = _2907;
                    }
                    _2936 = _2928;
                }
                float3 _2938 = _2854;
                _2938.z = pow(10.0, _2936);
                float3 _2942 = pow(((_2938 - float3(3.5073844628641381859779357910156e-05)) * _576) * float3(9.9999997473787516355514526367188e-05), float3(0.1593017578125));
                _2950 = pow((float3(0.8359375) + (float3(18.8515625) * _2942)) * (float3(1.0) / (float3(1.0) + (float3(18.6875) * _2942))), float3(78.84375));
            }
            else
            {
                float3 _2097;
                if ((_Globals.OutputDevice == 4u) || (_Globals.OutputDevice == 6u))
                {
                    float3 _1263 = (_906 * float3(1.5)) * (_546 * float3x3(float3(1.04981100559234619140625, 0.0, -9.74845024757087230682373046875e-05), float3(-0.49590301513671875, 1.37331306934356689453125, 0.09824003279209136962890625), float3(0.0, 0.0, 0.991252005100250244140625)));
                    float _1264 = _1263.x;
                    float _1265 = _1263.y;
                    float _1267 = _1263.z;
                    float _1270 = fast::max(fast::max(_1264, _1265), _1267);
                    float _1275 = (fast::max(_1270, 1.0000000133514319600180897396058e-10) - fast::max(fast::min(fast::min(_1264, _1265), _1267), 1.0000000133514319600180897396058e-10)) / fast::max(_1270, 0.00999999977648258209228515625);
                    float _1288 = ((_1267 + _1265) + _1264) + (1.75 * sqrt(((_1267 * (_1267 - _1265)) + (_1265 * (_1265 - _1264))) + (_1264 * (_1264 - _1267))));
                    float _1289 = _1288 * 0.3333333432674407958984375;
                    float _1290 = _1275 - 0.4000000059604644775390625;
                    float _1295 = fast::max(1.0 - abs(_1290 * 2.5), 0.0);
                    float _1303 = (1.0 + (float(int(sign(_1290 * 5.0))) * (1.0 - (_1295 * _1295)))) * 0.02500000037252902984619140625;
                    float _1316;
                    if (_1289 <= 0.053333334624767303466796875)
                    {
                        _1316 = _1303;
                    }
                    else
                    {
                        float _1315;
                        if (_1289 >= 0.1599999964237213134765625)
                        {
                            _1315 = 0.0;
                        }
                        else
                        {
                            _1315 = _1303 * ((0.23999999463558197021484375 / _1288) - 0.5);
                        }
                        _1316 = _1315;
                    }
                    float3 _1319 = _1263 * float3(1.0 + _1316);
                    float _1320 = _1319.x;
                    float _1321 = _1319.y;
                    float _1323 = _1319.z;
                    float _1337;
                    if ((_1320 == _1321) && (_1321 == _1323))
                    {
                        _1337 = 0.0;
                    }
                    else
                    {
                        _1337 = 57.2957763671875 * atan2(sqrt(3.0) * (_1321 - _1323), ((2.0 * _1320) - _1321) - _1323);
                    }
                    float _1342;
                    if (_1337 < 0.0)
                    {
                        _1342 = _1337 + 360.0;
                    }
                    else
                    {
                        _1342 = _1337;
                    }
                    float _1343 = fast::clamp(_1342, 0.0, 360.0);
                    float _1348;
                    if (_1343 > 180.0)
                    {
                        _1348 = _1343 - 360.0;
                    }
                    else
                    {
                        _1348 = _1343;
                    }
                    float _1398;
                    if ((_1348 > (-67.5)) && (_1348 < 67.5))
                    {
                        float _1355 = (_1348 - (-67.5)) * 0.0296296291053295135498046875;
                        int _1356 = int(_1355);
                        float _1358 = _1355 - float(_1356);
                        float _1359 = _1358 * _1358;
                        float _1360 = _1359 * _1358;
                        float _1397;
                        if (_1356 == 3)
                        {
                            _1397 = (((_1360 * (-0.16666667163372039794921875)) + (_1359 * 0.5)) + (_1358 * (-0.5))) + 0.16666667163372039794921875;
                        }
                        else
                        {
                            float _1390;
                            if (_1356 == 2)
                            {
                                _1390 = ((_1360 * 0.5) + (_1359 * (-1.0))) + 0.666666686534881591796875;
                            }
                            else
                            {
                                float _1385;
                                if (_1356 == 1)
                                {
                                    _1385 = (((_1360 * (-0.5)) + (_1359 * 0.5)) + (_1358 * 0.5)) + 0.16666667163372039794921875;
                                }
                                else
                                {
                                    float _1378;
                                    if (_1356 == 0)
                                    {
                                        _1378 = _1360 * 0.16666667163372039794921875;
                                    }
                                    else
                                    {
                                        _1378 = 0.0;
                                    }
                                    _1385 = _1378;
                                }
                                _1390 = _1385;
                            }
                            _1397 = _1390;
                        }
                        _1398 = _1397;
                    }
                    else
                    {
                        _1398 = 0.0;
                    }
                    float3 _1405 = _1319;
                    _1405.x = _1320 + ((((_1398 * 1.5) * _1275) * (0.02999999932944774627685546875 - _1320)) * 0.180000007152557373046875);
                    float3 _1408 = fast::clamp(fast::clamp(_1405, float3(0.0), float3(65535.0)) * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375)), float3(0.0), float3(65535.0));
                    float3 _1411 = mix(float3(dot(_1408, float3(0.272228717803955078125, 0.674081742763519287109375, 0.053689517080783843994140625))), _1408, float3(0.959999978542327880859375));
                    float _1412 = _1411.x;
                    float _1416 = 0.17999999225139617919921875 * exp2(18.0);
                    float _1418 = exp2(-14.0);
                    float _1421 = log((_1412 <= 0.0) ? _1418 : _1412) / _1065;
                    float _1423 = log(0.17999999225139617919921875 * exp2(-15.0)) / _1065;
                    float _1490;
                    if (_1421 <= _1423)
                    {
                        _1490 = log(9.9999997473787516355514526367188e-05) / _1065;
                    }
                    else
                    {
                        float _1430 = log(0.180000007152557373046875) / _1065;
                        float _1487;
                        if ((_1421 > _1423) && (_1421 < _1430))
                        {
                            float _1470 = (3.0 * (_1421 - _1423)) / (_1430 - _1423);
                            int _1471 = int(_1470);
                            float _1473 = _1470 - float(_1471);
                            _1487 = dot(float3(_1473 * _1473, _1473, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_1471], _475[_1471 + 1], _475[_1471 + 2]));
                        }
                        else
                        {
                            float _1438 = log(_1416) / _1065;
                            float _1466;
                            if ((_1421 >= _1430) && (_1421 < _1438))
                            {
                                float _1449 = (3.0 * (_1421 - _1430)) / (_1438 - _1430);
                                int _1450 = int(_1449);
                                float _1452 = _1449 - float(_1450);
                                _1466 = dot(float3(_1452 * _1452, _1452, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_1450], _476[_1450 + 1], _476[_1450 + 2]));
                            }
                            else
                            {
                                _1466 = log(10000.0) / _1065;
                            }
                            _1487 = _1466;
                        }
                        _1490 = _1487;
                    }
                    float3 _1492 = _391;
                    _1492.x = pow(10.0, _1490);
                    float _1493 = _1411.y;
                    float _1497 = log((_1493 <= 0.0) ? _1418 : _1493) / _1065;
                    float _1564;
                    if (_1497 <= _1423)
                    {
                        _1564 = log(9.9999997473787516355514526367188e-05) / _1065;
                    }
                    else
                    {
                        float _1504 = log(0.180000007152557373046875) / _1065;
                        float _1561;
                        if ((_1497 > _1423) && (_1497 < _1504))
                        {
                            float _1544 = (3.0 * (_1497 - _1423)) / (_1504 - _1423);
                            int _1545 = int(_1544);
                            float _1547 = _1544 - float(_1545);
                            _1561 = dot(float3(_1547 * _1547, _1547, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_1545], _475[_1545 + 1], _475[_1545 + 2]));
                        }
                        else
                        {
                            float _1512 = log(_1416) / _1065;
                            float _1540;
                            if ((_1497 >= _1504) && (_1497 < _1512))
                            {
                                float _1523 = (3.0 * (_1497 - _1504)) / (_1512 - _1504);
                                int _1524 = int(_1523);
                                float _1526 = _1523 - float(_1524);
                                _1540 = dot(float3(_1526 * _1526, _1526, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_1524], _476[_1524 + 1], _476[_1524 + 2]));
                            }
                            else
                            {
                                _1540 = log(10000.0) / _1065;
                            }
                            _1561 = _1540;
                        }
                        _1564 = _1561;
                    }
                    float3 _1566 = _1492;
                    _1566.y = pow(10.0, _1564);
                    float _1567 = _1411.z;
                    float _1571 = log((_1567 <= 0.0) ? _1418 : _1567) / _1065;
                    float _1638;
                    if (_1571 <= _1423)
                    {
                        _1638 = log(9.9999997473787516355514526367188e-05) / _1065;
                    }
                    else
                    {
                        float _1578 = log(0.180000007152557373046875) / _1065;
                        float _1635;
                        if ((_1571 > _1423) && (_1571 < _1578))
                        {
                            float _1618 = (3.0 * (_1571 - _1423)) / (_1578 - _1423);
                            int _1619 = int(_1618);
                            float _1621 = _1618 - float(_1619);
                            _1635 = dot(float3(_1621 * _1621, _1621, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_1619], _475[_1619 + 1], _475[_1619 + 2]));
                        }
                        else
                        {
                            float _1586 = log(_1416) / _1065;
                            float _1614;
                            if ((_1571 >= _1578) && (_1571 < _1586))
                            {
                                float _1597 = (3.0 * (_1571 - _1578)) / (_1586 - _1578);
                                int _1598 = int(_1597);
                                float _1600 = _1597 - float(_1598);
                                _1614 = dot(float3(_1600 * _1600, _1600, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_1598], _476[_1598 + 1], _476[_1598 + 2]));
                            }
                            else
                            {
                                _1614 = log(10000.0) / _1065;
                            }
                            _1635 = _1614;
                        }
                        _1638 = _1635;
                    }
                    float3 _1640 = _1566;
                    _1640.z = pow(10.0, _1638);
                    float3 _1642 = (_1640 * float3x3(float3(0.695452213287353515625, 0.140678703784942626953125, 0.16386906802654266357421875), float3(0.0447945632040500640869140625, 0.859671115875244140625, 0.095534317195415496826171875), float3(-0.0055258828215301036834716796875, 0.0040252101607620716094970703125, 1.00150072574615478515625))) * float3x3(float3(1.45143926143646240234375, -0.236510753631591796875, -0.214928567409515380859375), float3(-0.07655377686023712158203125, 1.1762297153472900390625, -0.0996759235858917236328125), float3(0.0083161480724811553955078125, -0.0060324496589601039886474609375, 0.99771630764007568359375));
                    float _1644 = 0.17999999225139617919921875 * pow(2.0, -12.0);
                    float _1648 = log((_1644 <= 0.0) ? _1418 : _1644) / _1065;
                    float _1715;
                    if (_1648 <= _1423)
                    {
                        _1715 = log(9.9999997473787516355514526367188e-05) / _1065;
                    }
                    else
                    {
                        float _1655 = log(0.180000007152557373046875) / _1065;
                        float _1712;
                        if ((_1648 > _1423) && (_1648 < _1655))
                        {
                            float _1695 = (3.0 * (_1648 - _1423)) / (_1655 - _1423);
                            int _1696 = int(_1695);
                            float _1698 = _1695 - float(_1696);
                            _1712 = dot(float3(_1698 * _1698, _1698, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_1696], _475[_1696 + 1], _475[_1696 + 2]));
                        }
                        else
                        {
                            float _1663 = log(_1416) / _1065;
                            float _1691;
                            if ((_1648 >= _1655) && (_1648 < _1663))
                            {
                                float _1674 = (3.0 * (_1648 - _1655)) / (_1663 - _1655);
                                int _1675 = int(_1674);
                                float _1677 = _1674 - float(_1675);
                                _1691 = dot(float3(_1677 * _1677, _1677, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_1675], _476[_1675 + 1], _476[_1675 + 2]));
                            }
                            else
                            {
                                _1691 = log(10000.0) / _1065;
                            }
                            _1712 = _1691;
                        }
                        _1715 = _1712;
                    }
                    float _1718 = log(0.180000007152557373046875) / _1065;
                    float _1774;
                    if (_1718 <= _1423)
                    {
                        _1774 = log(9.9999997473787516355514526367188e-05) / _1065;
                    }
                    else
                    {
                        float _1771;
                        if ((_1718 > _1423) && (_1718 < _1718))
                        {
                            _1771 = (float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(-0.485249996185302734375, 1.84773242473602294921875, 1.84773242473602294921875)).z;
                        }
                        else
                        {
                            float _1731 = log(_1416) / _1065;
                            float _1759;
                            if ((_1718 >= _1718) && (_1718 < _1731))
                            {
                                float _1742 = (3.0 * (_1718 - _1718)) / (_1731 - _1718);
                                int _1743 = int(_1742);
                                float _1745 = _1742 - float(_1743);
                                _1759 = dot(float3(_1745 * _1745, _1745, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_1743], _476[_1743 + 1], _476[_1743 + 2]));
                            }
                            else
                            {
                                _1759 = log(10000.0) / _1065;
                            }
                            _1771 = _1759;
                        }
                        _1774 = _1771;
                    }
                    float _1775 = pow(10.0, _1774);
                    float _1777 = 0.17999999225139617919921875 * pow(2.0, 11.0);
                    float _1781 = log((_1777 <= 0.0) ? _1418 : _1777) / _1065;
                    float _1846;
                    if (_1781 <= _1423)
                    {
                        _1846 = log(9.9999997473787516355514526367188e-05) / _1065;
                    }
                    else
                    {
                        float _1843;
                        if ((_1781 > _1423) && (_1781 < _1718))
                        {
                            float _1826 = (3.0 * (_1781 - _1423)) / (_1718 - _1423);
                            int _1827 = int(_1826);
                            float _1829 = _1826 - float(_1827);
                            _1843 = dot(float3(_1829 * _1829, _1829, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_475[_1827], _475[_1827 + 1], _475[_1827 + 2]));
                        }
                        else
                        {
                            float _1794 = log(_1416) / _1065;
                            float _1822;
                            if ((_1781 >= _1718) && (_1781 < _1794))
                            {
                                float _1805 = (3.0 * (_1781 - _1718)) / (_1794 - _1718);
                                int _1806 = int(_1805);
                                float _1808 = _1805 - float(_1806);
                                _1822 = dot(float3(_1808 * _1808, _1808, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_476[_1806], _476[_1806 + 1], _476[_1806 + 2]));
                            }
                            else
                            {
                                _1822 = log(10000.0) / _1065;
                            }
                            _1843 = _1822;
                        }
                        _1846 = _1843;
                    }
                    float _1847 = pow(10.0, _1846);
                    float _1848 = _1642.x;
                    float _1852 = log((_1848 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _1848) / _1065;
                    float _1854 = log(pow(10.0, _1715)) / _1065;
                    float _1926;
                    if (_1852 <= _1854)
                    {
                        _1926 = log(0.004999999888241291046142578125) / _1065;
                    }
                    else
                    {
                        float _1861 = log(_1775) / _1065;
                        float _1923;
                        if ((_1852 > _1854) && (_1852 < _1861))
                        {
                            float _1906 = (7.0 * (_1852 - _1854)) / (_1861 - _1854);
                            int _1907 = int(_1906);
                            float _1909 = _1906 - float(_1907);
                            _1923 = dot(float3(_1909 * _1909, _1909, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_482[_1907], _482[_1907 + 1], _482[_1907 + 2]));
                        }
                        else
                        {
                            float _1868 = log(_1847);
                            float _1869 = _1868 / _1065;
                            float _1902;
                            if ((_1852 >= _1861) && (_1852 < _1869))
                            {
                                float _1885 = (7.0 * (_1852 - _1861)) / (_1869 - _1861);
                                int _1886 = int(_1885);
                                float _1888 = _1885 - float(_1886);
                                _1902 = dot(float3(_1888 * _1888, _1888, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_483[_1886], _483[_1886 + 1], _483[_1886 + 2]));
                            }
                            else
                            {
                                _1902 = (_1852 * 0.119999997317790985107421875) + ((log(2000.0) / _1065) - ((0.119999997317790985107421875 * _1868) / _1065));
                            }
                            _1923 = _1902;
                        }
                        _1926 = _1923;
                    }
                    float3 _1928 = _391;
                    _1928.x = pow(10.0, _1926);
                    float _1929 = _1642.y;
                    float _1933 = log((_1929 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _1929) / _1065;
                    float _2005;
                    if (_1933 <= _1854)
                    {
                        _2005 = log(0.004999999888241291046142578125) / _1065;
                    }
                    else
                    {
                        float _1940 = log(_1775) / _1065;
                        float _2002;
                        if ((_1933 > _1854) && (_1933 < _1940))
                        {
                            float _1985 = (7.0 * (_1933 - _1854)) / (_1940 - _1854);
                            int _1986 = int(_1985);
                            float _1988 = _1985 - float(_1986);
                            _2002 = dot(float3(_1988 * _1988, _1988, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_482[_1986], _482[_1986 + 1], _482[_1986 + 2]));
                        }
                        else
                        {
                            float _1947 = log(_1847);
                            float _1948 = _1947 / _1065;
                            float _1981;
                            if ((_1933 >= _1940) && (_1933 < _1948))
                            {
                                float _1964 = (7.0 * (_1933 - _1940)) / (_1948 - _1940);
                                int _1965 = int(_1964);
                                float _1967 = _1964 - float(_1965);
                                _1981 = dot(float3(_1967 * _1967, _1967, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_483[_1965], _483[_1965 + 1], _483[_1965 + 2]));
                            }
                            else
                            {
                                _1981 = (_1933 * 0.119999997317790985107421875) + ((log(2000.0) / _1065) - ((0.119999997317790985107421875 * _1947) / _1065));
                            }
                            _2002 = _1981;
                        }
                        _2005 = _2002;
                    }
                    float3 _2007 = _1928;
                    _2007.y = pow(10.0, _2005);
                    float _2008 = _1642.z;
                    float _2012 = log((_2008 <= 0.0) ? 9.9999997473787516355514526367188e-05 : _2008) / _1065;
                    float _2084;
                    if (_2012 <= _1854)
                    {
                        _2084 = log(0.004999999888241291046142578125) / _1065;
                    }
                    else
                    {
                        float _2019 = log(_1775) / _1065;
                        float _2081;
                        if ((_2012 > _1854) && (_2012 < _2019))
                        {
                            float _2064 = (7.0 * (_2012 - _1854)) / (_2019 - _1854);
                            int _2065 = int(_2064);
                            float _2067 = _2064 - float(_2065);
                            _2081 = dot(float3(_2067 * _2067, _2067, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_482[_2065], _482[_2065 + 1], _482[_2065 + 2]));
                        }
                        else
                        {
                            float _2026 = log(_1847);
                            float _2027 = _2026 / _1065;
                            float _2060;
                            if ((_2012 >= _2019) && (_2012 < _2027))
                            {
                                float _2043 = (7.0 * (_2012 - _2019)) / (_2027 - _2019);
                                int _2044 = int(_2043);
                                float _2046 = _2043 - float(_2044);
                                _2060 = dot(float3(_2046 * _2046, _2046, 1.0), float3x3(float3(0.5, -1.0, 0.5), float3(-1.0, 1.0, 0.5), float3(0.5, 0.0, 0.0)) * float3(_483[_2044], _483[_2044 + 1], _483[_2044 + 2]));
                            }
                            else
                            {
                                _2060 = (_2012 * 0.119999997317790985107421875) + ((log(2000.0) / _1065) - ((0.119999997317790985107421875 * _2026) / _1065));
                            }
                            _2081 = _2060;
                        }
                        _2084 = _2081;
                    }
                    float3 _2086 = _2007;
                    _2086.z = pow(10.0, _2084);
                    float3 _2089 = pow((_2086 * _576) * float3(9.9999997473787516355514526367188e-05), float3(0.1593017578125));
                    _2097 = pow((float3(0.8359375) + (float3(18.8515625) * _2089)) * (float3(1.0) / (float3(1.0) + (float3(18.6875) * _2089))), float3(78.84375));
                }
                else
                {
                    float3 _1260;
                    if (_Globals.OutputDevice == 7u)
                    {
                        float3 _1252 = pow(((_906 * _547) * _576) * float3(9.9999997473787516355514526367188e-05), float3(0.1593017578125));
                        _1260 = pow((float3(0.8359375) + (float3(18.8515625) * _1252)) * (float3(1.0) / (float3(1.0) + (float3(18.6875) * _1252))), float3(78.84375));
                    }
                    else
                    {
                        _1260 = pow((_1218 * _547) * _576, float3(_Globals.InverseGamma.z));
                    }
                    _2097 = _1260;
                }
                _2950 = _2097;
            }
            _2960 = _2950;
        }
        _3001 = _2960;
    }
    float3 _3002 = _3001 * float3(0.95238101482391357421875);
    float4 _3004 = float4(_3002.x, _3002.y, _3002.z, float4(0.0).w);
    _3004.w = 0.0;
    out.out_var_SV_Target0 = _3004;
    return out;
}

