/*
 * Decompiled with CFR 0.152.
 */
package org.boehn.kmlframework.kml;

import org.boehn.kmlframework.kml.ColorModeEnum;
import org.boehn.kmlframework.kml.ColorStyle;
import org.boehn.kmlframework.kml.Kml;
import org.boehn.kmlframework.kml.KmlException;
import org.boehn.kmlframework.kml.UnitEnum;

public class IconStyle
extends ColorStyle {
    private Double scale;
    private Double heading;
    private String iconHref;
    private Double hotSpotX;
    private Double hotSpotY;
    private UnitEnum hotSpotXunits;
    private UnitEnum hotSpotYunits;

    public IconStyle() {
    }

    public IconStyle(String color, ColorModeEnum colorMode, Double scale, Double heading, String iconHref, Double hotSpotX, Double hotSpotY, UnitEnum hotSpotXunits, UnitEnum hotSpotYunits) {
        super(color, colorMode);
        this.scale = scale;
        this.heading = heading;
        this.iconHref = iconHref;
        this.hotSpotX = hotSpotX;
        this.hotSpotY = hotSpotY;
        this.hotSpotXunits = hotSpotXunits;
        this.hotSpotYunits = hotSpotYunits;
    }

    public Double getScale() {
        return this.scale;
    }

    public void setScale(Double scale) {
        this.scale = scale;
    }

    public Double getHeading() {
        return this.heading;
    }

    public void setHeading(Double heading) {
        this.heading = heading;
    }

    public String getIconHref() {
        return this.iconHref;
    }

    public void setIconHref(String iconHref) {
        this.iconHref = iconHref;
    }

    public Double getHotSpotX() {
        return this.hotSpotX;
    }

    public void setHotSpotX(Double hotSpotX) {
        this.hotSpotX = hotSpotX;
    }

    public Double getHotSpotY() {
        return this.hotSpotY;
    }

    public void setHotSpotY(Double hotSpotY) {
        this.hotSpotY = hotSpotY;
    }

    public UnitEnum getHotSpotXunits() {
        return this.hotSpotXunits;
    }

    public void setHotSpotXunits(UnitEnum hotSpotXunits) {
        this.hotSpotXunits = hotSpotXunits;
    }

    public UnitEnum getHotSpotYunits() {
        return this.hotSpotYunits;
    }

    public void setHotSpotYunits(UnitEnum hotSpotYunits) {
        this.hotSpotYunits = hotSpotYunits;
    }

    public void write(Kml kml) throws KmlException {
        kml.println("<IconStyle" + this.getIdAndTargetIdFormatted(kml) + ">", 1);
        super.writeInner(kml);
        if (this.scale != null) {
            kml.println("<scale>" + this.scale + "</scale>");
        }
        if (this.heading != null) {
            kml.println("<heading>" + this.heading + "</heading>");
        }
        if (this.iconHref != null) {
            kml.println("<Icon>", 1);
            kml.println("<href>" + this.iconHref + "</href>");
            kml.println(-1, "</Icon>");
        }
        if (this.hotSpotX != null || this.hotSpotY != null || this.hotSpotXunits != null || this.hotSpotYunits != null) {
            kml.println("<hotSpot" + (this.hotSpotX != null ? " x=\"" + this.hotSpotX + "\"" : "") + (this.hotSpotY != null ? " y=\"" + this.hotSpotY + "\"" : "") + (this.hotSpotXunits != null ? " xunits=\"" + (Object)((Object)this.hotSpotXunits) + "\"" : "") + (this.hotSpotYunits != null ? " yunits=\"" + (Object)((Object)this.hotSpotYunits) + "\"" : "") + "/>");
        }
        kml.println(-1, "</IconStyle>");
    }

    public void writeDelete(Kml kml) throws KmlException {
        kml.println("<IconStyle" + this.getIdAndTargetIdFormatted(kml) + "></>");
    }
}

