/*
 * @(#)UrlClassLoaderUTest.java      0.9.0 23-May-2001 - 14:40
 *
 * Copyright (C) 2001,2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.util.classes.v1.jdk0;

import net.sourceforge.groboutils.util.classes.v1.*;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

import java.io.InputStream;
import java.io.IOException;
import java.net.URL;


/**
 * Offline version of this test.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/05/06 05:35:01 $
 * @since     May 23, 2001
 */
public class UrlClassLoaderUTest extends TestCase
{
    private static final Class THIS_CLASS = UrlClassLoaderUTest.class;
    
    public UrlClassLoaderUTest( String name )
    {
        super( name );
    }
    
    public static Test suite()
    {
        InterfaceTestSuite suite = IUrlClassLoaderUTestI.suite();
        suite.addTestSuite( THIS_CLASS );
        suite.addFactory( new CxFactory( "A" ) {
            public Object createImplObject() {
                return createLoader();
            }
        } );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        super.tearDown();
    }

    
    protected static UrlClassLoader createLoader()
    {
        return new UrlClassLoader();
    }
    
    
    
    
    public static class MyInner
    {
        // default constructor implied
    }
    public static final String MY_INNER_RES =
        "UrlClassLoaderUTest$MyInner.class";
    public static final String MY_INNER_CLASS = MyInner.class.getName();
    public static final String MY_INNER_FULL_RES =
        '/' + MY_INNER_CLASS.replace( '.', '/' ) + ".class";
    
    public static class InnerClass
    {
        public InnerClass()
        {
            // do nothing
        }
    }
    
    public void testFlush1()
    {
        // override the original, because we can better test the flushing
        // mechanism.
        
        UrlClassLoader loader = createLoader();
        
        // load up bytecode from a separate location
        URL url = this.getClass().getResource( MY_INNER_RES );
        assertNotNull(
            "No resource found for "+MY_INNER_RES,
            url );
        System.out.println("Found class in URL "+url);
        String urlStr = url.toString();
        if (urlStr.endsWith( MY_INNER_FULL_RES ))
        {
            urlStr = urlStr.substring( 0, urlStr.length() -
                MY_INNER_FULL_RES.length() );
        }
        
        Class c = loader.loadClass( MY_INNER_CLASS, urlStr );
        assertNotNull( "loadClass( "+MY_INNER_CLASS+" ) returned null.", c );
        assertEquals( "loadClass( "+MY_INNER_CLASS+
            " ) returned the wrong class.",
            MyInner.class.getName(), c.getName() );
        
        byte b[] = loader.getBytecode( MY_INNER_CLASS );
        assertGetBytecodeResult( MY_INNER_CLASS, b, url );
        
        loader.flush();
        
        // make sure the bytecode was properly eliminated.
        b = loader.getBytecode( MY_INNER_CLASS );
        assertEquals( "getBytecode( "+MY_INNER_CLASS+" ) did not return null.",
            null, b );
    }
    
    
    public void testGetBytecode1()
    {
        UrlClassLoader loader = (UrlClassLoader)createLoader();
        
        // load up bytecode from a separate location
        URL url = this.getClass().getResource( MY_INNER_RES );
        assertNotNull( "No resource for inner class "+MY_INNER_RES, url );
        System.out.println("Found class in URL "+url);
        String urlStr = url.toString();
        if (urlStr.endsWith( MY_INNER_FULL_RES ))
        {
            urlStr = urlStr.substring( 0, urlStr.length() -
                MY_INNER_FULL_RES.length() );
        }
        
        Class c = loader.loadClass( MY_INNER_CLASS, urlStr );
        assertNotNull( "loadClass( "+MY_INNER_CLASS+" ) returned null.", c );
        assertEquals( "loadClass( "+MY_INNER_CLASS+
            " ) returned the wrong class.",
            MY_INNER_CLASS, c.getName() );
        
        byte b[] = loader.getBytecode( MY_INNER_CLASS );
        assertGetBytecodeResult( MY_INNER_CLASS, b, url );
    }
    
    
    protected void assertGetBytecodeResult( String className, byte[] result,
            URL sourceURL )
    {
        if (result == null)
        {
            // JDK 1.1 won't let us load a Class file through the resource
            // - it will through a SecurityException.  No way around this,
            // I guess.
            try
            {
                InputStream is = sourceURL.openStream();
                is.close();
                fail("getBytecode( "+className+" ) returned null, "+
                    "but no SecurityException was thrown." );
            }
            catch (SecurityException e)
            {
                // this is fine - JDK 1.1 or whatever is behaving
                // (unfortunately) as expected.
            }
            catch (IOException ioe)
            {
                ioe.printStackTrace();
                fail("Should not have encountered an IOException.");
            }
        }
        else
        {
            //assertNotNull( "getBytecode( "+className+
            //    " ) returned null.", result );
            assertTrue( "getBytecode( "+className+" ) returned no data.",
                result.length > 0 );
        }
    }
}
