------------------------------------------------------------------------------
--                                  G P S                                   --
--                                                                          --
--                     Copyright (C) 2005-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;                   use Ada.Text_IO;
with Ada.Unchecked_Deallocation;
with GNATCOLL.Storage_Pools.Alignment;  use GNATCOLL.Storage_Pools.Alignment;
with System.Storage_Elements;       use System.Storage_Elements;

procedure Test_Alignment is
   generic
      Align : System.Storage_Elements.Storage_Count;
   procedure Do_Test;

   procedure Do_Test is
      My_Pool : Unbounded_No_Reclaim_Align_Pool (Alignment => Align);
      type IA is access Integer;
      for IA'Storage_Pool use My_Pool;
      procedure Unchecked_Free is new Ada.Unchecked_Deallocation (Integer, IA);

      type IA_Array is array (1 .. 10) of IA;
      Var : IA_Array;
      Add : Integer_Address;
   begin
      for I in Var'Range loop
         Var (I) := new Integer;
         Add := To_Integer (Var (I).all'Address);
         if (Add - Integer_Address (Align)
              * (Add / Integer_Address (Align))) /= 0
         then
            Put_Line ("Incorrect alignment:" & Integer_Address'Image (Add)
                      & " should be aligned on "
                      & Storage_Count'Image (Align));
         end if;
      end loop;

      for I in Var'Range loop
         Unchecked_Free (Var (I));
      end loop;
   end Do_Test;

   procedure Do_Test1 is new Do_Test (Align => 128);
   procedure Do_Test2 is new Do_Test (Align => 64_000);
   procedure Do_Test3 is new Do_Test (Align => 128_000);
   procedure Do_Test4 is new Do_Test (Align => 4);
begin
   Do_Test1;
   Do_Test2;
   Do_Test3;
   Do_Test4;
end Test_Alignment;
