/* Generated by GOB (v2.0.18)   (do not edit directly) */

/* End world hunger, donate to the World Food Programme, http://www.wfp.org */


#line 3 "loqui-account-ipmsg.gob"

/*
 * libloqui -- Chat/IM client library for GLib <http://launchpad.net/loqui/>
 * Copyright (C) 2004 Yoichi Imai <sunnyone41@gmail.com>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with the Gnome Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#line 29 "loqui-account-ipmsg.c"
#define GOB_VERSION_MAJOR 2
#define GOB_VERSION_MINOR 0
#define GOB_VERSION_PATCHLEVEL 18

#define selfp (self->_priv)

#include <string.h> /* memset() */

#include "loqui-account-ipmsg.h"

#include "loqui-account-ipmsg-private.h"

#ifdef G_LIKELY
#define ___GOB_LIKELY(expr) G_LIKELY(expr)
#define ___GOB_UNLIKELY(expr) G_UNLIKELY(expr)
#else /* ! G_LIKELY */
#define ___GOB_LIKELY(expr) (expr)
#define ___GOB_UNLIKELY(expr) (expr)
#endif /* G_LIKELY */

#line 32 "loqui-account-ipmsg.gob"

#include <libloqui-intl.h>
#include "loqui-utils.h"

#include "loqui-sender-ipmsg.h"
#include "loqui-receiver-ipmsg.h"

#include "loqui-utils-ipmsg.h"
#include "ipmsg_packet.h"
#include "ipmsg.h"

#line 62 "loqui-account-ipmsg.c"
/* self casting macros */
#define SELF(x) LOQUI_ACCOUNT_IPMSG(x)
#define SELF_CONST(x) LOQUI_ACCOUNT_IPMSG_CONST(x)
#define IS_SELF(x) LOQUI_IS_ACCOUNT_IPMSG(x)
#define TYPE_SELF LOQUI_TYPE_ACCOUNT_IPMSG
#define SELF_CLASS(x) LOQUI_ACCOUNT_IPMSG_CLASS(x)

#define SELF_GET_CLASS(x) LOQUI_ACCOUNT_IPMSG_GET_CLASS(x)

/* self typedefs */
typedef LoquiAccountIPMsg Self;
typedef LoquiAccountIPMsgClass SelfClass;

/* here are local prototypes */
#line 0 "loqui-account-ipmsg.gob"
static void loqui_account_ipmsg_init (LoquiAccountIPMsg * o) G_GNUC_UNUSED;
#line 79 "loqui-account-ipmsg.c"
#line 0 "loqui-account-ipmsg.gob"
static void loqui_account_ipmsg_class_init (LoquiAccountIPMsgClass * c) G_GNUC_UNUSED;
#line 82 "loqui-account-ipmsg.c"
#line 49 "loqui-account-ipmsg.gob"
static GObject * ___1_loqui_account_ipmsg_constructor (GType type, guint n_props, GObjectConstructParam * props) G_GNUC_UNUSED;
#line 85 "loqui-account-ipmsg.c"
#line 69 "loqui-account-ipmsg.gob"
static void ___2_loqui_account_ipmsg_connect (LoquiAccount * account) G_GNUC_UNUSED;
#line 88 "loqui-account-ipmsg.c"
#line 113 "loqui-account-ipmsg.gob"
static void ___3_loqui_account_ipmsg_disconnect (LoquiAccount * account) G_GNUC_UNUSED;
#line 91 "loqui-account-ipmsg.c"

/* pointer to the class of our parent */
static LoquiAccountClass *parent_class = NULL;

/* Short form macros */
#define self_new loqui_account_ipmsg_new
#define self_get_socket loqui_account_ipmsg_get_socket
#define self_create_packet loqui_account_ipmsg_create_packet
#define self_fetch_user_by_pair loqui_account_ipmsg_fetch_user_by_pair
GType
loqui_account_ipmsg_get_type (void)
{
	static GType type = 0;

	if ___GOB_UNLIKELY(type == 0) {
		static const GTypeInfo info = {
			sizeof (LoquiAccountIPMsgClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) loqui_account_ipmsg_class_init,
			(GClassFinalizeFunc) NULL,
			NULL /* class_data */,
			sizeof (LoquiAccountIPMsg),
			0 /* n_preallocs */,
			(GInstanceInitFunc) loqui_account_ipmsg_init,
			NULL
		};

		type = g_type_register_static (LOQUI_TYPE_ACCOUNT, "LoquiAccountIPMsg", &info, (GTypeFlags)0);
	}

	return type;
}

/* a macro for creating a new object of our type */
#define GET_NEW ((LoquiAccountIPMsg *)g_object_new(loqui_account_ipmsg_get_type(), NULL))

/* a function for creating a new object of our type */
#include <stdarg.h>
static LoquiAccountIPMsg * GET_NEW_VARG (const char *first, ...) G_GNUC_UNUSED;
static LoquiAccountIPMsg *
GET_NEW_VARG (const char *first, ...)
{
	LoquiAccountIPMsg *ret;
	va_list ap;
	va_start (ap, first);
	ret = (LoquiAccountIPMsg *)g_object_new_valist (loqui_account_ipmsg_get_type (), first, ap);
	va_end (ap);
	return ret;
}


static void
___finalize(GObject *obj_self)
{
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::finalize"
	LoquiAccountIPMsg *self G_GNUC_UNUSED = LOQUI_ACCOUNT_IPMSG (obj_self);
	gpointer priv G_GNUC_UNUSED = self->_priv;
	if(G_OBJECT_CLASS(parent_class)->finalize) \
		(* G_OBJECT_CLASS(parent_class)->finalize)(obj_self);
}
#undef __GOB_FUNCTION__

static void 
loqui_account_ipmsg_init (LoquiAccountIPMsg * o G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::init"
	o->_priv = G_TYPE_INSTANCE_GET_PRIVATE(o,LOQUI_TYPE_ACCOUNT_IPMSG,LoquiAccountIPMsgPrivate);
#line 47 "loqui-account-ipmsg.gob"
	o->_priv->current_packet_num =  (gint) time(NULL) ;
#line 162 "loqui-account-ipmsg.c"
}
#undef __GOB_FUNCTION__
static void 
loqui_account_ipmsg_class_init (LoquiAccountIPMsgClass * c G_GNUC_UNUSED)
{
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::class_init"
	GObjectClass *g_object_class G_GNUC_UNUSED = (GObjectClass*) c;
	LoquiAccountClass *loqui_account_class = (LoquiAccountClass *)c;

	g_type_class_add_private(c,sizeof(LoquiAccountIPMsgPrivate));

	parent_class = g_type_class_ref (LOQUI_TYPE_ACCOUNT);

#line 49 "loqui-account-ipmsg.gob"
	g_object_class->constructor = ___1_loqui_account_ipmsg_constructor;
#line 69 "loqui-account-ipmsg.gob"
	loqui_account_class->connect = ___2_loqui_account_ipmsg_connect;
#line 113 "loqui-account-ipmsg.gob"
	loqui_account_class->disconnect = ___3_loqui_account_ipmsg_disconnect;
#line 182 "loqui-account-ipmsg.c"
	g_object_class->finalize = ___finalize;
}
#undef __GOB_FUNCTION__



#line 49 "loqui-account-ipmsg.gob"
static GObject * 
___1_loqui_account_ipmsg_constructor (GType type G_GNUC_UNUSED, guint n_props, GObjectConstructParam * props)
#line 192 "loqui-account-ipmsg.c"
#define PARENT_HANDLER(___type,___n_props,___props) \
	((G_OBJECT_CLASS(parent_class)->constructor)? \
		(* G_OBJECT_CLASS(parent_class)->constructor)(___type,___n_props,___props): \
		((GObject * )0))
{
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::constructor"
{
#line 50 "loqui-account-ipmsg.gob"
	
		GObject *object;

		LoquiAccount *account;
		LoquiUser *user;

		object = PARENT_HANDLER(type, n_props, props);

		account = LOQUI_ACCOUNT(object);

		loqui_account_set_sender(account, LOQUI_SENDER(loqui_sender_ipmsg_new(account)));
		loqui_account_set_receiver(account, LOQUI_RECEIVER(loqui_receiver_ipmsg_new(account)));

		user = LOQUI_USER(loqui_user_ipmsg_new());
		loqui_user_set_away(user, LOQUI_AWAY_TYPE_OFFLINE);
		loqui_account_set_user_self(account, user);

		return object;
	}}
#line 220 "loqui-account-ipmsg.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 69 "loqui-account-ipmsg.gob"
static void 
___2_loqui_account_ipmsg_connect (LoquiAccount * account G_GNUC_UNUSED)
#line 227 "loqui-account-ipmsg.c"
#define PARENT_HANDLER(___account) \
	{ if(LOQUI_ACCOUNT_CLASS(parent_class)->connect) \
		(* LOQUI_ACCOUNT_CLASS(parent_class)->connect)(___account); }
{
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::connect"
{
#line 69 "loqui-account-ipmsg.gob"
	
		Self *self;
		LoquiUser *user_self;
		gchar *str;
		
		self = SELF(account);

		if (loqui_account_get_is_connected(LOQUI_ACCOUNT(self))) {
			loqui_account_warning(LOQUI_ACCOUNT(self), _("Already connected."));
			return;
		}

		selfp->sock = loqui_socket_ipmsg_new(account);

		if (!loqui_socket_ipmsg_bind(selfp->sock)) {
			loqui_account_warning(LOQUI_ACCOUNT(self), _("Failed to create socket. Is used the port?"));
			LOQUI_G_OBJECT_UNREF_UNLESS_NULL(selfp->sock);
			return;
		}
	
		loqui_account_set_is_connected(LOQUI_ACCOUNT(self), TRUE);

		str = g_strdup_printf(_("Opened the socket."));
		loqui_account_append_text(LOQUI_ACCOUNT(self), NULL, LOQUI_TEXT_TYPE_INFO, str);
		g_free(str);

		user_self = loqui_account_get_user_self(LOQUI_ACCOUNT(self));
		loqui_user_set_away(user_self, LOQUI_AWAY_TYPE_ONLINE);
		loqui_user_set_nick(user_self, loqui_profile_account_get_nick(loqui_account_get_profile(LOQUI_ACCOUNT(self))));
		loqui_user_set_hostname(user_self, g_get_host_name());

		/* FIXME: can't get ?
		   tmp = loqui_socket_ipmsg_get_current_ip_addr(selfp->sock);
		   loqui_user_ipmsg_set_ip_addr(LOQUI_USER_IPMSG(user_self), tmp);
		   g_free(tmp); */

		loqui_user_ipmsg_set_ip_addr(LOQUI_USER_IPMSG(user_self), "127.0.0.1");
		loqui_user_ipmsg_set_port(LOQUI_USER_IPMSG(user_self), loqui_socket_ipmsg_get_current_port(selfp->sock));
		/* FIXME: originally this should do in UserIPMsg */
		g_object_notify(G_OBJECT(user_self), "identifier");

		loqui_sender_ipmsg_br_entry(LOQUI_SENDER_IPMSG(LOQUI_ACCOUNT(self)->sender));
	}}
#line 278 "loqui-account-ipmsg.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 113 "loqui-account-ipmsg.gob"
static void 
___3_loqui_account_ipmsg_disconnect (LoquiAccount * account G_GNUC_UNUSED)
#line 285 "loqui-account-ipmsg.c"
#define PARENT_HANDLER(___account) \
	{ if(LOQUI_ACCOUNT_CLASS(parent_class)->disconnect) \
		(* LOQUI_ACCOUNT_CLASS(parent_class)->disconnect)(___account); }
{
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::disconnect"
{
#line 113 "loqui-account-ipmsg.gob"
	
		Self *self;

		self = SELF(account);

		if (!loqui_account_get_is_connected(LOQUI_ACCOUNT(account)))
			return;
		
		loqui_account_remove_all_user(LOQUI_ACCOUNT(account));
		loqui_sender_ipmsg_br_exit(LOQUI_SENDER_IPMSG(LOQUI_ACCOUNT(self)->sender));

		if (selfp->sock)
			loqui_socket_ipmsg_unbind(selfp->sock);
		LOQUI_G_OBJECT_UNREF_UNLESS_NULL(selfp->sock);

		loqui_account_append_text(account, NULL, LOQUI_TEXT_TYPE_INFO, _("Disconnected."));

		loqui_account_set_is_connected(LOQUI_ACCOUNT(account), FALSE);
		loqui_user_set_away(loqui_account_get_user_self(LOQUI_ACCOUNT(account)), LOQUI_AWAY_TYPE_OFFLINE);
	}}
#line 313 "loqui-account-ipmsg.c"
#undef __GOB_FUNCTION__
#undef PARENT_HANDLER

#line 134 "loqui-account-ipmsg.gob"
LoquiAccountIPMsg * 
loqui_account_ipmsg_new (LoquiProfileAccount * profile)
{
#line 321 "loqui-account-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::new"
{
#line 135 "loqui-account-ipmsg.gob"
	
		Self *self = g_object_new(TYPE_SELF, "profile", profile, NULL);

		return self;
	}}
#line 330 "loqui-account-ipmsg.c"
#undef __GOB_FUNCTION__

#line 141 "loqui-account-ipmsg.gob"
LoquiSocketIPMsg * 
loqui_account_ipmsg_get_socket (LoquiAccountIPMsg * self)
{
#line 337 "loqui-account-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::get_socket"
#line 141 "loqui-account-ipmsg.gob"
	g_return_val_if_fail (self != NULL, (LoquiSocketIPMsg * )0);
#line 141 "loqui-account-ipmsg.gob"
	g_return_val_if_fail (LOQUI_IS_ACCOUNT_IPMSG (self), (LoquiSocketIPMsg * )0);
#line 343 "loqui-account-ipmsg.c"
{
#line 141 "loqui-account-ipmsg.gob"
	
		return selfp->sock;
	}}
#line 349 "loqui-account-ipmsg.c"
#undef __GOB_FUNCTION__

#line 145 "loqui-account-ipmsg.gob"
IPMsgPacket * 
loqui_account_ipmsg_create_packet (LoquiAccountIPMsg * self, gint command_num, const gchar * extra)
{
#line 356 "loqui-account-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::create_packet"
#line 145 "loqui-account-ipmsg.gob"
	g_return_val_if_fail (self != NULL, (IPMsgPacket * )0);
#line 145 "loqui-account-ipmsg.gob"
	g_return_val_if_fail (LOQUI_IS_ACCOUNT_IPMSG (self), (IPMsgPacket * )0);
#line 362 "loqui-account-ipmsg.c"
{
#line 145 "loqui-account-ipmsg.gob"
	
		LoquiUser *user;
		LoquiProfileAccount *profile;

		user = loqui_account_get_user_self(LOQUI_ACCOUNT(self));
		profile = loqui_account_get_profile(LOQUI_ACCOUNT(self));

		return ipmsg_packet_create(IPMSG_VERSION,
					   selfp->current_packet_num++,
					   loqui_profile_account_get_username(profile),
					   loqui_user_get_hostname(user),
					   command_num,
					   extra,
					   loqui_user_ipmsg_get_group_name(LOQUI_USER_IPMSG(user)));
	}}
#line 380 "loqui-account-ipmsg.c"
#undef __GOB_FUNCTION__

#line 161 "loqui-account-ipmsg.gob"
LoquiUserIPMsg * 
loqui_account_ipmsg_fetch_user_by_pair (LoquiAccountIPMsg * self, const gchar * ip_addr, gint port)
{
#line 387 "loqui-account-ipmsg.c"
#define __GOB_FUNCTION__ "Loqui:Account:IPMsg::fetch_user_by_pair"
#line 161 "loqui-account-ipmsg.gob"
	g_return_val_if_fail (self != NULL, (LoquiUserIPMsg * )0);
#line 161 "loqui-account-ipmsg.gob"
	g_return_val_if_fail (LOQUI_IS_ACCOUNT_IPMSG (self), (LoquiUserIPMsg * )0);
#line 393 "loqui-account-ipmsg.c"
{
#line 161 "loqui-account-ipmsg.gob"
	
		gchar *identifier;
		LoquiUser *user;

		identifier = loqui_utils_ipmsg_create_identifier(ip_addr, port);
		if ((user = loqui_account_peek_user(LOQUI_ACCOUNT(self), identifier)) == NULL) {
			user = LOQUI_USER(loqui_user_ipmsg_new());

			loqui_user_ipmsg_set_ip_addr(LOQUI_USER_IPMSG(user), ip_addr);
			loqui_user_ipmsg_set_port(LOQUI_USER_IPMSG(user), port);

			loqui_account_add_user(LOQUI_ACCOUNT(self), user);
		} else {
			g_object_ref(user);
		}
		g_free(identifier);

		return LOQUI_USER_IPMSG(user);
	}}
#line 415 "loqui-account-ipmsg.c"
#undef __GOB_FUNCTION__
