package tests::OutputFormatsDVITest;

use strict;

use base qw/Lire::Test::PluginTestCase/;

use Lire::OutputFormats::DVI;
use Lire::PluginManager;
use File::Basename qw/dirname/;

sub set_up {
    my $self = $_[0];
    $self->SUPER::set_up();

    $self->{'testdir'} = dirname( __FILE__ ) ;

    return;
}

sub tear_down {
    my $self = $_[0];
    $self->SUPER::tear_down();

    return;
}

sub create_plugin {
    return new Lire::OutputFormats::DVI();
}

sub registration_file {
    return dirname( __FILE__ ) . "/../Lire/OutputFormats/of_dvi_init";
}

sub test_missing_requirements {
    my $self = $_[0];

    my $spec = $self->lire_default_config_spec();
    $self->{'cfg'}{'lambda_path'} =
      $spec->get( 'lambda_path' )->instance( 'value' => '' );

    $self->test_registration_file();
    my $dvi = Lire::PluginManager->get_plugin( 'output_format', 'dvi');
    $self->assert_deep_equals( [ "missing Omega 'lambda' command" ],
                               [ $dvi->missing_requirements() ] );
}

1;
