/* gEDA - GPL Electronic Design Automation
 * libgeda - gEDA's library
 * Copyright (C) 1998-2010 Ales Hvezda
 * Copyright (C) 1998-2010 gEDA Contributors (see ChangeLog for details)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */
/*! \file geda_color.h
 */

G_BEGIN_DECLS

typedef struct st_color GedaColor;
//typedef struct st_color COLOR;

struct st_color
{
  guint8 r, g, b, a;
  gboolean enabled;
};

gdouble
geda_color_get_blue_double (const GedaColor *color);

gdouble
geda_color_get_green_double (const GedaColor *color);

gdouble
geda_color_get_red_double (const GedaColor *color);

gdouble
geda_color_get_alpha_double (const GedaColor *color);

gboolean
s_color_rgba_decode (const gchar *rgba, guchar *r, guchar *g, guchar *b, guchar *a);

gchar*
s_color_rgba_encode (guint8 r, guint8 g, guint8 b, guint8 a);

G_END_DECLS
