/* completion.c generated by valac 0.28.0.1-2361a, the Vala compiler
 * generated from completion.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2012 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Sébastien Wilmet
 *          Pieter Pareit
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <latexila.h>
#include <glib/gi18n-lib.h>
#include "config.h"


#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
typedef struct _CompletionProviderPrivate CompletionProviderPrivate;

#define COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND (completion_provider_completion_command_get_type ())

#define COMPLETION_PROVIDER_TYPE_COMPLETION_ARGUMENT (completion_provider_completion_argument_get_type ())

#define COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE (completion_provider_completion_choice_get_type ())
typedef struct _CompletionProviderCompletionChoice CompletionProviderCompletionChoice;
typedef struct _CompletionProviderCompletionArgument CompletionProviderCompletionArgument;
typedef struct _CompletionProviderCompletionCommand CompletionProviderCompletionCommand;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define COMPLETION_PROVIDER_TYPE_ARGUMENT_CONTEXT (completion_provider_argument_context_get_type ())
typedef struct _CompletionProviderArgumentContext CompletionProviderArgumentContext;
#define _completion_provider_completion_command_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_command_free (var), NULL)))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_LATEXILA_APP (latexila_app_get_type ())
#define LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LATEXILA_APP, LatexilaApp))
#define LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LATEXILA_APP, LatexilaAppClass))
#define IS_LATEXILA_APP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LATEXILA_APP))
#define IS_LATEXILA_APP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LATEXILA_APP))
#define LATEXILA_APP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LATEXILA_APP, LatexilaAppClass))

typedef struct _LatexilaApp LatexilaApp;
typedef struct _LatexilaAppClass LatexilaAppClass;

#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
typedef struct _DocumentPrivate DocumentPrivate;

#define TYPE_DOCUMENT_TAB (document_tab_get_type ())
#define DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_TAB, DocumentTab))
#define DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_TAB, DocumentTabClass))
#define IS_DOCUMENT_TAB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_TAB))
#define IS_DOCUMENT_TAB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_TAB))
#define DOCUMENT_TAB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_TAB, DocumentTabClass))

typedef struct _DocumentTab DocumentTab;
typedef struct _DocumentTabClass DocumentTabClass;
#define _completion_provider_completion_choice_free0(var) ((var == NULL) ? NULL : (var = (completion_provider_completion_choice_free (var), NULL)))
#define _g_markup_parse_context_unref0(var) ((var == NULL) ? NULL : (var = (g_markup_parse_context_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _CompletionProvider {
	GObject parent_instance;
	CompletionProviderPrivate * priv;
};

struct _CompletionProviderClass {
	GObjectClass parent_class;
};

struct _CompletionProviderCompletionChoice {
	gchar* name;
	gchar* package;
	gchar* insert;
	gchar* insert_after;
};

struct _CompletionProviderCompletionArgument {
	gchar* label;
	gboolean optional;
	CompletionProviderCompletionChoice* choices;
	gint choices_length1;
	gint _choices_size_;
};

struct _CompletionProviderCompletionCommand {
	gchar* name;
	gchar* package;
	CompletionProviderCompletionArgument* args;
	gint args_length1;
	gint _args_size_;
};

struct _CompletionProviderPrivate {
	GSettings* _settings;
	GList* _proposals;
	GeeHashMap* _commands;
	GeeHashMap* _environments;
	CompletionProviderCompletionCommand _current_command;
	CompletionProviderCompletionArgument _current_arg;
	CompletionProviderCompletionChoice _current_choice;
	GdkPixbuf* _icon_cmd;
	GdkPixbuf* _icon_choice;
	GdkPixbuf* _icon_package_required;
	GtkSourceCompletionInfo* _calltip_window;
	GtkLabel* _calltip_window_label;
};

struct _CompletionProviderArgumentContext {
	gchar* cmd_name;
	gchar* arg_contents;
	GeeArrayList* args_types;
};

struct _Document {
	GtkSourceBuffer parent_instance;
	DocumentPrivate * priv;
	DocumentTab* tab;
	guint _unsaved_doc_num;
};

struct _DocumentClass {
	GtkSourceBufferClass parent_class;
};


static gpointer completion_provider_parent_class = NULL;
static CompletionProvider* completion_provider__instance;
static CompletionProvider* completion_provider__instance = NULL;
static GtkSourceCompletionProviderIface* completion_provider_gtk_source_completion_provider_parent_iface = NULL;

GType completion_provider_get_type (void) G_GNUC_CONST;
static GType completion_provider_completion_command_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_argument_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static GType completion_provider_completion_choice_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self);
static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self, CompletionProviderCompletionChoice* dest);
static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self);
static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self);
static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self, CompletionProviderCompletionArgument* dest);
static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self);
static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self);
static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self, CompletionProviderCompletionCommand* dest);
static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self);
#define COMPLETION_PROVIDER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_COMPLETION_PROVIDER, CompletionProviderPrivate))
enum  {
	COMPLETION_PROVIDER_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
static CompletionProvider* completion_provider_new (void);
static CompletionProvider* completion_provider_construct (GType object_type);
static void completion_provider_load_data (CompletionProvider* self);
CompletionProvider* completion_provider_get_default (void);
static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base);
static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base);
static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
static gboolean completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self, GtkTextIter* iter);
static void completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context);
static void completion_provider_show_no_proposals (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_populate_command (CompletionProvider* self, GtkSourceCompletionContext* context, const gchar* cmd);
static GType completion_provider_argument_context_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static CompletionProviderArgumentContext* completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_free (CompletionProviderArgumentContext* self);
static void completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self, CompletionProviderArgumentContext* dest);
static void completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self);
static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self, GtkTextIter* iter, CompletionProviderArgumentContext* info);
static void completion_provider_populate_argument (CompletionProvider* self, GtkSourceCompletionContext* context, CompletionProviderArgumentContext* info);
static gboolean completion_provider_is_user_request (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_show_all_proposals (CompletionProvider* self, GtkSourceCompletionContext* context);
static void completion_provider_show_filtered_proposals (CompletionProvider* self, GtkSourceCompletionContext* context, GList* proposals_to_filter, const gchar* prefix);
static GList* completion_provider_get_argument_proposals (CompletionProvider* self, CompletionProviderArgumentContext* arg_context);
static void completion_provider_show_calltip_cmd_prototype (CompletionProvider* self, const gchar* arg_cmd, GeeArrayList* arguments);
static gchar* completion_provider_get_command_info (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, gint cur_arg);
static gint completion_provider_get_argument_num (CompletionProvider* self, CompletionProviderCompletionArgument* all_args, int all_args_length1, GeeArrayList* args);
static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b);
static void completion_provider_init_calltip_window (CompletionProvider* self);
static void completion_provider_show_calltip_info (CompletionProvider* self, const gchar* markup);
GType main_window_get_type (void) G_GNUC_CONST;
GType latexila_app_get_type (void) G_GNUC_CONST;
LatexilaApp* latexila_app_get_instance (void);
GType document_view_get_type (void) G_GNUC_CONST;
DocumentView* main_window_get_active_view (MainWindow* self);
static void completion_provider_get_begin_arg_pos (CompletionProvider* self, GtkTextIter* in_arg_pos, GtkTextIter* result);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter);
static void completion_provider_activate_proposal_command_name (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd);
static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* arg_cmd, const gchar* arg_contents);
static void completion_provider_close_environment (CompletionProvider* self, const gchar* env_name, GtkTextIter* iter);
GType document_get_type (void) G_GNUC_CONST;
void document_insert (Document* self, GtkTextIter* iter, const gchar* text, gint len);
gchar* document_get_current_indentation (Document* self, GtkTextIter* iter);
GType document_tab_get_type (void) G_GNUC_CONST;
DocumentView* document_tab_get_view (DocumentTab* self);
gchar* document_view_get_indentation_style (DocumentView* self);
static gchar* completion_provider_get_text_line_to_iter (CompletionProvider* self, GtkTextIter* iter);
gboolean utils_char_is_escaped (const gchar* text, glong char_index);
static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self, const gchar* text, gint index);
static gchar* completion_provider_get_command_text_to_insert (CompletionProvider* self, CompletionProviderCompletionCommand* cmd);
gchar* utils_load_file (GFile* file);
static void completion_provider_parser_start (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error);
static void completion_provider_parser_end (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, GError** error);
static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error);
static void completion_provider_parser_text (CompletionProvider* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error);
static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error);
static void completion_provider_parser_add_command (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void completion_provider_parser_add_argument (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void completion_provider_parser_add_choice (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error);
static void _vala_array_add2 (CompletionProviderCompletionArgument** array, int* length, int* size, const CompletionProviderCompletionArgument* value);
static void _vala_array_add3 (CompletionProviderCompletionChoice** array, int* length, int* size, const CompletionProviderCompletionChoice* value);
static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument* array, gint array_length);
static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self, int length);
static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice* array, gint array_length);
static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self, int length);
static void completion_provider_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static CompletionProvider* completion_provider_construct (GType object_type) {
	CompletionProvider * self = NULL;
	GSettings* _tmp0_ = NULL;
	GdkPixbuf* _tmp1_ = NULL;
	GdkPixbuf* _tmp2_ = NULL;
	GdkPixbuf* _tmp3_ = NULL;
	self = (CompletionProvider*) g_object_new (object_type, NULL);
	_tmp0_ = g_settings_new ("org.gnome.latexila.preferences.latex");
	_g_object_unref0 (self->priv->_settings);
	self->priv->_settings = _tmp0_;
	_tmp1_ = latexila_utils_get_pixbuf_from_icon_name ("completion_cmd", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_cmd);
	self->priv->_icon_cmd = _tmp1_;
	_tmp2_ = latexila_utils_get_pixbuf_from_icon_name ("gray-square", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_choice);
	self->priv->_icon_choice = _tmp2_;
	_tmp3_ = latexila_utils_get_pixbuf_from_icon_name ("dialog-warning", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->priv->_icon_package_required);
	self->priv->_icon_package_required = _tmp3_;
	completion_provider_load_data (self);
	return self;
}


static CompletionProvider* completion_provider_new (void) {
	return completion_provider_construct (TYPE_COMPLETION_PROVIDER);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


CompletionProvider* completion_provider_get_default (void) {
	CompletionProvider* result = NULL;
	CompletionProvider* _tmp0_ = NULL;
	CompletionProvider* _tmp2_ = NULL;
	CompletionProvider* _tmp3_ = NULL;
	_tmp0_ = completion_provider__instance;
	if (_tmp0_ == NULL) {
		CompletionProvider* _tmp1_ = NULL;
		_tmp1_ = completion_provider_new ();
		_g_object_unref0 (completion_provider__instance);
		completion_provider__instance = _tmp1_;
	}
	_tmp2_ = completion_provider__instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}


static gchar* completion_provider_real_get_name (GtkSourceCompletionProvider* base) {
	CompletionProvider * self;
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	self = (CompletionProvider*) base;
	_tmp0_ = g_strdup ("LaTeX");
	result = _tmp0_;
	return result;
}


static GtkSourceCompletionActivation completion_provider_real_get_activation (GtkSourceCompletionProvider* base) {
	CompletionProvider * self;
	GtkSourceCompletionActivation result = 0;
	GtkSourceCompletionActivation activation = 0;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	self = (CompletionProvider*) base;
	activation = GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "interactive-completion");
	if (_tmp1_) {
		GtkSourceCompletionActivation _tmp2_ = 0;
		_tmp2_ = activation;
		activation = _tmp2_ | GTK_SOURCE_COMPLETION_ACTIVATION_INTERACTIVE;
	}
	result = activation;
	return result;
}


static gboolean completion_provider_real_match (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	CompletionProvider * self;
	gboolean result = FALSE;
	GtkTextIter iter = {0};
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	GtkTextBuffer* buf = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = gtk_text_iter_get_buffer (&iter);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	buf = _tmp4_;
	_tmp5_ = buf;
	_tmp6_ = gtk_text_buffer_get_has_selection (_tmp5_);
	_tmp7_ = _tmp6_;
	if (_tmp7_) {
		result = FALSE;
		_g_object_unref0 (buf);
		return result;
	}
	result = TRUE;
	_g_object_unref0 (buf);
	return result;
}


static gboolean completion_provider_real_get_start_iter (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	CompletionProvider * self;
	GtkTextIter _vala_iter = {0};
	gboolean result = FALSE;
	GtkTextIter _tmp0_ = {0};
	gchar* cmd = NULL;
	GtkSourceCompletionContext* _tmp1_ = NULL;
	GtkTextIter* _tmp2_ = NULL;
	GtkTextIter* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	GtkSourceCompletionContext* _tmp7_ = NULL;
	GtkTextIter* _tmp8_ = NULL;
	GtkTextIter* _tmp9_ = NULL;
	GtkTextIter prev = {0};
	GtkTextIter _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	gboolean _tmp15_ = FALSE;
	GtkTextIter _tmp16_ = {0};
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (context != NULL, FALSE);
	g_return_val_if_fail (proposal != NULL, FALSE);
	_vala_iter = _tmp0_;
	_tmp1_ = context;
	g_object_get (_tmp1_, "iter", &_tmp2_, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = *_tmp3_;
	_tmp5_ = completion_provider_get_latex_command_at_iter (self, &_tmp4_);
	cmd = _tmp5_;
	_tmp6_ = cmd;
	if (_tmp6_ == NULL) {
		result = FALSE;
		_g_free0 (cmd);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp7_ = context;
	g_object_get (_tmp7_, "iter", &_tmp8_, NULL);
	_tmp9_ = _tmp8_;
	_vala_iter = *_tmp9_;
	_tmp10_ = _vala_iter;
	prev = _tmp10_;
	_tmp12_ = gtk_text_iter_backward_char (&prev);
	if (_tmp12_) {
		gunichar _tmp13_ = 0U;
		_tmp13_ = gtk_text_iter_get_char (&prev);
		_tmp11_ = _tmp13_ == ((gunichar) '\\');
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		GtkTextIter _tmp14_ = {0};
		_tmp14_ = prev;
		_vala_iter = _tmp14_;
		result = TRUE;
		_g_free0 (cmd);
		if (iter) {
			*iter = _vala_iter;
		}
		return result;
	}
	_tmp15_ = gtk_text_iter_starts_word (&_vala_iter);
	if (!_tmp15_) {
		gtk_text_iter_backward_visible_word_start (&_vala_iter);
	}
	_tmp16_ = _vala_iter;
	prev = _tmp16_;
	_tmp18_ = gtk_text_iter_backward_char (&prev);
	if (_tmp18_) {
		gunichar _tmp19_ = 0U;
		_tmp19_ = gtk_text_iter_get_char (&prev);
		_tmp17_ = _tmp19_ == ((gunichar) '\\');
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		GtkTextIter _tmp20_ = {0};
		_tmp20_ = prev;
		_vala_iter = _tmp20_;
	}
	result = TRUE;
	_g_free0 (cmd);
	if (iter) {
		*iter = _vala_iter;
	}
	return result;
}


/*************************************************************************/
static void completion_provider_real_populate (GtkSourceCompletionProvider* base, GtkSourceCompletionContext* context) {
	CompletionProvider * self;
	GtkTextIter iter = {0};
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkTextIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	gchar* cmd = NULL;
	GtkTextIter _tmp4_ = {0};
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	CompletionProviderArgumentContext info = {0};
	gboolean in_arg = FALSE;
	GtkTextIter _tmp9_ = {0};
	CompletionProviderArgumentContext _tmp10_ = {0};
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	GtkSourceCompletionContext* _tmp15_ = NULL;
	gboolean _tmp16_ = FALSE;
	self = (CompletionProvider*) base;
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp2_ = gtk_source_completion_context_get_iter (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		GtkSourceCompletionContext* _tmp3_ = NULL;
		_tmp3_ = context;
		completion_provider_show_no_proposals (self, _tmp3_);
		return;
	}
	_tmp4_ = iter;
	_tmp5_ = completion_provider_get_latex_command_at_iter (self, &_tmp4_);
	cmd = _tmp5_;
	_tmp6_ = cmd;
	if (_tmp6_ != NULL) {
		GtkSourceCompletionContext* _tmp7_ = NULL;
		const gchar* _tmp8_ = NULL;
		_tmp7_ = context;
		_tmp8_ = cmd;
		completion_provider_populate_command (self, _tmp7_, _tmp8_);
		_g_free0 (cmd);
		return;
	}
	_tmp9_ = iter;
	_tmp11_ = completion_provider_in_latex_command_argument (self, &_tmp9_, &_tmp10_);
	completion_provider_argument_context_destroy (&info);
	info = _tmp10_;
	in_arg = _tmp11_;
	_tmp12_ = in_arg;
	if (_tmp12_) {
		GtkSourceCompletionContext* _tmp13_ = NULL;
		CompletionProviderArgumentContext _tmp14_ = {0};
		_tmp13_ = context;
		_tmp14_ = info;
		completion_provider_populate_argument (self, _tmp13_, &_tmp14_);
		completion_provider_argument_context_destroy (&info);
		_g_free0 (cmd);
		return;
	}
	_tmp15_ = context;
	_tmp16_ = completion_provider_is_user_request (self, _tmp15_);
	if (_tmp16_) {
		GtkSourceCompletionContext* _tmp17_ = NULL;
		_tmp17_ = context;
		completion_provider_show_all_proposals (self, _tmp17_);
	} else {
		GtkSourceCompletionContext* _tmp18_ = NULL;
		_tmp18_ = context;
		completion_provider_show_no_proposals (self, _tmp18_);
	}
	completion_provider_argument_context_destroy (&info);
	_g_free0 (cmd);
}


static void completion_provider_populate_command (CompletionProvider* self, GtkSourceCompletionContext* context, const gchar* cmd) {
	GtkSourceCompletionContext* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp8_ = NULL;
	GtkSourceCompletionContext* _tmp10_ = NULL;
	GList* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (cmd != NULL);
	_tmp0_ = context;
	_tmp1_ = completion_provider_is_user_request (self, _tmp0_);
	if (!_tmp1_) {
		guint min_nb_chars = 0U;
		GSettings* _tmp2_ = NULL;
		const gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		guint _tmp6_ = 0U;
		_tmp2_ = self->priv->_settings;
		g_settings_get (_tmp2_, "interactive-completion-num", "u", &min_nb_chars);
		_tmp3_ = cmd;
		_tmp4_ = strlen (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = min_nb_chars;
		if (((guint) _tmp5_) <= _tmp6_) {
			GtkSourceCompletionContext* _tmp7_ = NULL;
			_tmp7_ = context;
			completion_provider_show_no_proposals (self, _tmp7_);
			return;
		}
	}
	_tmp8_ = cmd;
	if (g_strcmp0 (_tmp8_, "\\") == 0) {
		GtkSourceCompletionContext* _tmp9_ = NULL;
		_tmp9_ = context;
		completion_provider_show_all_proposals (self, _tmp9_);
		return;
	}
	_tmp10_ = context;
	_tmp11_ = self->priv->_proposals;
	_tmp12_ = cmd;
	completion_provider_show_filtered_proposals (self, _tmp10_, _tmp11_, _tmp12_);
}


static void completion_provider_populate_argument (CompletionProvider* self, GtkSourceCompletionContext* context, CompletionProviderArgumentContext* info) {
	GeeHashMap* _tmp0_ = NULL;
	CompletionProviderArgumentContext _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	GList* proposals_to_filter = NULL;
	CompletionProviderArgumentContext _tmp5_ = {0};
	GList* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	GtkSourceCompletionContext* _tmp15_ = NULL;
	GList* _tmp16_ = NULL;
	CompletionProviderArgumentContext _tmp17_ = {0};
	const gchar* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (info != NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = *info;
	_tmp2_ = _tmp1_.cmd_name;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_);
	if (!_tmp3_) {
		GtkSourceCompletionContext* _tmp4_ = NULL;
		_tmp4_ = context;
		completion_provider_show_no_proposals (self, _tmp4_);
		return;
	}
	_tmp5_ = *info;
	_tmp6_ = completion_provider_get_argument_proposals (self, &_tmp5_);
	proposals_to_filter = _tmp6_;
	_tmp7_ = proposals_to_filter;
	if (_tmp7_ == NULL) {
		GtkSourceCompletionContext* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		_tmp8_ = context;
		_tmp9_ = completion_provider_is_user_request (self, _tmp8_);
		if (_tmp9_) {
			CompletionProviderArgumentContext _tmp10_ = {0};
			const gchar* _tmp11_ = NULL;
			CompletionProviderArgumentContext _tmp12_ = {0};
			GeeArrayList* _tmp13_ = NULL;
			_tmp10_ = *info;
			_tmp11_ = _tmp10_.cmd_name;
			_tmp12_ = *info;
			_tmp13_ = _tmp12_.args_types;
			completion_provider_show_calltip_cmd_prototype (self, _tmp11_, _tmp13_);
		} else {
			GtkSourceCompletionContext* _tmp14_ = NULL;
			_tmp14_ = context;
			completion_provider_show_no_proposals (self, _tmp14_);
		}
		return;
	}
	_tmp15_ = context;
	_tmp16_ = proposals_to_filter;
	_tmp17_ = *info;
	_tmp18_ = _tmp17_.arg_contents;
	completion_provider_show_filtered_proposals (self, _tmp15_, _tmp16_, _tmp18_);
}


static GList* completion_provider_get_argument_proposals (CompletionProvider* self, CompletionProviderArgumentContext* arg_context) {
	GList* result = NULL;
	GeeHashMap* _tmp0_ = NULL;
	CompletionProviderArgumentContext _tmp1_ = {0};
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	CompletionProviderCompletionCommand cmd = {0};
	GeeHashMap* _tmp4_ = NULL;
	CompletionProviderArgumentContext _tmp5_ = {0};
	const gchar* _tmp6_ = NULL;
	gpointer _tmp7_ = NULL;
	CompletionProviderCompletionCommand* _tmp8_ = NULL;
	CompletionProviderCompletionCommand _tmp9_ = {0};
	CompletionProviderCompletionCommand _tmp10_ = {0};
	gchar* cmd_info = NULL;
	CompletionProviderCompletionCommand _tmp11_ = {0};
	gchar* _tmp12_ = NULL;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp13_ = {0};
	CompletionProviderCompletionArgument* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	CompletionProviderArgumentContext _tmp15_ = {0};
	GeeArrayList* _tmp16_ = NULL;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	CompletionProviderCompletionArgument arg = {0};
	CompletionProviderCompletionCommand _tmp19_ = {0};
	CompletionProviderCompletionArgument* _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gint _tmp21_ = 0;
	CompletionProviderCompletionArgument _tmp22_ = {0};
	CompletionProviderCompletionArgument _tmp23_ = {0};
	GList* items = NULL;
	CompletionProviderCompletionArgument _tmp24_ = {0};
	CompletionProviderCompletionChoice* _tmp25_ = NULL;
	gint _tmp25__length1 = 0;
	GList* _tmp50_ = NULL;
	GList* _tmp51_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (arg_context != NULL, NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = *arg_context;
	_tmp2_ = _tmp1_.cmd_name;
	_tmp3_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp2_);
	g_return_val_if_fail (_tmp3_, NULL);
	_tmp4_ = self->priv->_commands;
	_tmp5_ = *arg_context;
	_tmp6_ = _tmp5_.cmd_name;
	_tmp7_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp6_);
	_tmp8_ = (CompletionProviderCompletionCommand*) _tmp7_;
	completion_provider_completion_command_copy (_tmp8_, &_tmp9_);
	_tmp10_ = _tmp9_;
	_completion_provider_completion_command_free0 (_tmp8_);
	cmd = _tmp10_;
	_tmp11_ = cmd;
	_tmp12_ = completion_provider_get_command_info (self, &_tmp11_, -1);
	cmd_info = _tmp12_;
	_tmp13_ = cmd;
	_tmp14_ = _tmp13_.args;
	_tmp14__length1 = _tmp13_.args_length1;
	_tmp15_ = *arg_context;
	_tmp16_ = _tmp15_.args_types;
	_tmp17_ = completion_provider_get_argument_num (self, _tmp14_, _tmp14__length1, _tmp16_);
	arg_num = _tmp17_;
	_tmp18_ = arg_num;
	if (_tmp18_ == (-1)) {
		result = NULL;
		_g_free0 (cmd_info);
		completion_provider_completion_command_destroy (&cmd);
		return result;
	}
	_tmp19_ = cmd;
	_tmp20_ = _tmp19_.args;
	_tmp20__length1 = _tmp19_.args_length1;
	_tmp21_ = arg_num;
	_tmp22_ = _tmp20_[_tmp21_ - 1];
	completion_provider_completion_argument_copy (&_tmp22_, &_tmp23_);
	arg = _tmp23_;
	items = NULL;
	_tmp24_ = arg;
	_tmp25_ = _tmp24_.choices;
	_tmp25__length1 = _tmp24_.choices_length1;
	{
		CompletionProviderCompletionChoice* choice_collection = NULL;
		gint choice_collection_length1 = 0;
		gint _choice_collection_size_ = 0;
		gint choice_it = 0;
		choice_collection = _tmp25_;
		choice_collection_length1 = _tmp25__length1;
		for (choice_it = 0; choice_it < _tmp25__length1; choice_it = choice_it + 1) {
			CompletionProviderCompletionChoice _tmp26_ = {0};
			CompletionProviderCompletionChoice choice = {0};
			completion_provider_completion_choice_copy (&choice_collection[choice_it], &_tmp26_);
			choice = _tmp26_;
			{
				GdkPixbuf* pixbuf = NULL;
				gchar* arg_info = NULL;
				CompletionProviderCompletionChoice _tmp27_ = {0};
				const gchar* _tmp28_ = NULL;
				const gchar* _tmp39_ = NULL;
				const gchar* _tmp40_ = NULL;
				GtkSourceCompletionItem* item = NULL;
				CompletionProviderCompletionChoice _tmp42_ = {0};
				const gchar* _tmp43_ = NULL;
				CompletionProviderCompletionChoice _tmp44_ = {0};
				const gchar* _tmp45_ = NULL;
				GdkPixbuf* _tmp46_ = NULL;
				GtkSourceCompletionItem* _tmp47_ = NULL;
				GtkSourceCompletionItem* _tmp48_ = NULL;
				GtkSourceCompletionItem* _tmp49_ = NULL;
				arg_info = NULL;
				_tmp27_ = choice;
				_tmp28_ = _tmp27_.package;
				if (_tmp28_ != NULL) {
					GdkPixbuf* _tmp29_ = NULL;
					GdkPixbuf* _tmp30_ = NULL;
					const gchar* _tmp31_ = NULL;
					gchar* _tmp32_ = NULL;
					gchar* _tmp33_ = NULL;
					CompletionProviderCompletionChoice _tmp34_ = {0};
					const gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					_tmp29_ = self->priv->_icon_package_required;
					_tmp30_ = _g_object_ref0 (_tmp29_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp30_;
					_tmp31_ = cmd_info;
					_tmp32_ = g_strconcat (_tmp31_, "\nPackage: ", NULL);
					_tmp33_ = _tmp32_;
					_tmp34_ = choice;
					_tmp35_ = _tmp34_.package;
					_tmp36_ = g_strconcat (_tmp33_, _tmp35_, NULL);
					_g_free0 (arg_info);
					arg_info = _tmp36_;
					_g_free0 (_tmp33_);
				} else {
					GdkPixbuf* _tmp37_ = NULL;
					GdkPixbuf* _tmp38_ = NULL;
					_tmp37_ = self->priv->_icon_choice;
					_tmp38_ = _g_object_ref0 (_tmp37_);
					_g_object_unref0 (pixbuf);
					pixbuf = _tmp38_;
				}
				_tmp40_ = arg_info;
				_tmp39_ = _tmp40_;
				if (_tmp39_ == NULL) {
					const gchar* _tmp41_ = NULL;
					_tmp41_ = cmd_info;
					_tmp39_ = _tmp41_;
				}
				_tmp42_ = choice;
				_tmp43_ = _tmp42_.name;
				_tmp44_ = choice;
				_tmp45_ = _tmp44_.name;
				_tmp46_ = pixbuf;
				_tmp47_ = gtk_source_completion_item_new (_tmp43_, _tmp45_, _tmp46_, _tmp39_);
				item = _tmp47_;
				_tmp48_ = item;
				_tmp49_ = _g_object_ref0 (_tmp48_);
				items = g_list_prepend (items, _tmp49_);
				_g_object_unref0 (item);
				_g_free0 (arg_info);
				_g_object_unref0 (pixbuf);
				completion_provider_completion_choice_destroy (&choice);
			}
		}
	}
	_tmp50_ = items;
	if (_tmp50_ == NULL) {
		result = NULL;
		completion_provider_completion_argument_destroy (&arg);
		_g_free0 (cmd_info);
		completion_provider_completion_command_destroy (&cmd);
		return result;
	}
	items = g_list_sort (items, (GCompareFunc) completion_provider_compare_proposals);
	_tmp51_ = items;
	result = _tmp51_;
	completion_provider_completion_argument_destroy (&arg);
	_g_free0 (cmd_info);
	completion_provider_completion_command_destroy (&cmd);
	return result;
}


static void completion_provider_show_no_proposals (CompletionProvider* self, GtkSourceCompletionContext* context) {
	GtkSourceCompletionContext* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	gtk_source_completion_context_add_proposals (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), NULL, TRUE);
}


static void completion_provider_show_all_proposals (CompletionProvider* self, GtkSourceCompletionContext* context) {
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GList* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp0_ = context;
	_tmp1_ = self->priv->_proposals;
	gtk_source_completion_context_add_proposals (_tmp0_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp1_, TRUE);
}


static void completion_provider_show_filtered_proposals (CompletionProvider* self, GtkSourceCompletionContext* context, GList* proposals_to_filter, const gchar* prefix) {
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_ = NULL;
	GList* filtered_proposals = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp16_ = NULL;
	GtkSourceCompletionContext* _tmp21_ = NULL;
	GList* _tmp22_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	_tmp1_ = prefix;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp2_ = NULL;
		_tmp2_ = prefix;
		_tmp0_ = g_strcmp0 (_tmp2_, "") == 0;
	}
	if (_tmp0_) {
		GtkSourceCompletionContext* _tmp3_ = NULL;
		GList* _tmp4_ = NULL;
		_tmp3_ = context;
		_tmp4_ = proposals_to_filter;
		gtk_source_completion_context_add_proposals (_tmp3_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp4_, TRUE);
		return;
	}
	filtered_proposals = NULL;
	_tmp5_ = proposals_to_filter;
	{
		GList* item_collection = NULL;
		GList* item_it = NULL;
		item_collection = _tmp5_;
		for (item_it = item_collection; item_it != NULL; item_it = item_it->next) {
			GtkSourceCompletionItem* _tmp6_ = NULL;
			GtkSourceCompletionItem* item = NULL;
			_tmp6_ = _g_object_ref0 ((GtkSourceCompletionItem*) item_it->data);
			item = _tmp6_;
			{
				GtkSourceCompletionItem* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				gchar* _tmp9_ = NULL;
				gchar* _tmp10_ = NULL;
				const gchar* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				_tmp7_ = item;
				g_object_get (_tmp7_, "text", &_tmp8_, NULL);
				_tmp9_ = _tmp8_;
				_tmp10_ = _tmp9_;
				_tmp11_ = prefix;
				_tmp12_ = g_str_has_prefix (_tmp10_, _tmp11_);
				_tmp13_ = _tmp12_;
				_g_free0 (_tmp10_);
				if (_tmp13_) {
					GtkSourceCompletionItem* _tmp14_ = NULL;
					GtkSourceCompletionItem* _tmp15_ = NULL;
					_tmp14_ = item;
					_tmp15_ = _g_object_ref0 (_tmp14_);
					filtered_proposals = g_list_prepend (filtered_proposals, _tmp15_);
				}
				_g_object_unref0 (item);
			}
		}
	}
	_tmp16_ = filtered_proposals;
	if (_tmp16_ != NULL) {
		filtered_proposals = g_list_reverse (filtered_proposals);
	} else {
		GtkSourceCompletionItem* dummy_proposal = NULL;
		const gchar* _tmp17_ = NULL;
		GtkSourceCompletionItem* _tmp18_ = NULL;
		GtkSourceCompletionItem* _tmp19_ = NULL;
		GtkSourceCompletionItem* _tmp20_ = NULL;
		_tmp17_ = _ ("No matching proposal");
		_tmp18_ = gtk_source_completion_item_new (_tmp17_, "", NULL, NULL);
		dummy_proposal = _tmp18_;
		_tmp19_ = dummy_proposal;
		_tmp20_ = _g_object_ref0 (_tmp19_);
		filtered_proposals = g_list_prepend (filtered_proposals, _tmp20_);
		_g_object_unref0 (dummy_proposal);
	}
	_tmp21_ = context;
	_tmp22_ = filtered_proposals;
	gtk_source_completion_context_add_proposals (_tmp21_, G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_completion_provider_get_type (), GtkSourceCompletionProvider), _tmp22_, TRUE);
	__g_list_free__g_object_unref0_0 (filtered_proposals);
}


/*************************************************************************/
static void completion_provider_init_calltip_window (CompletionProvider* self) {
	GtkSourceCompletionInfo* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkSourceCompletionInfo* _tmp2_ = NULL;
	GtkLabel* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_source_completion_info_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_calltip_window);
	self->priv->_calltip_window = _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->_calltip_window_label);
	self->priv->_calltip_window_label = _tmp1_;
	_tmp2_ = self->priv->_calltip_window;
	_tmp3_ = self->priv->_calltip_window_label;
	gtk_container_add ((GtkContainer*) _tmp2_, (GtkWidget*) _tmp3_);
}


static void completion_provider_show_calltip_cmd_prototype (CompletionProvider* self, const gchar* arg_cmd, GeeArrayList* arguments) {
	GeeHashMap* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	CompletionProviderCompletionCommand command = {0};
	GeeHashMap* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gpointer _tmp5_ = NULL;
	CompletionProviderCompletionCommand* _tmp6_ = NULL;
	CompletionProviderCompletionCommand _tmp7_ = {0};
	CompletionProviderCompletionCommand _tmp8_ = {0};
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp9_ = {0};
	CompletionProviderCompletionArgument* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	GeeArrayList* _tmp11_ = NULL;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (arg_cmd != NULL);
	g_return_if_fail (arguments != NULL);
	_tmp0_ = self->priv->_commands;
	_tmp1_ = arg_cmd;
	_tmp2_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, _tmp1_);
	g_return_if_fail (_tmp2_);
	_tmp3_ = self->priv->_commands;
	_tmp4_ = arg_cmd;
	_tmp5_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp3_, _tmp4_);
	_tmp6_ = (CompletionProviderCompletionCommand*) _tmp5_;
	completion_provider_completion_command_copy (_tmp6_, &_tmp7_);
	_tmp8_ = _tmp7_;
	_completion_provider_completion_command_free0 (_tmp6_);
	command = _tmp8_;
	_tmp9_ = command;
	_tmp10_ = _tmp9_.args;
	_tmp10__length1 = _tmp9_.args_length1;
	_tmp11_ = arguments;
	_tmp12_ = completion_provider_get_argument_num (self, _tmp10_, _tmp10__length1, _tmp11_);
	arg_num = _tmp12_;
	_tmp13_ = arg_num;
	if (_tmp13_ != (-1)) {
		gchar* info = NULL;
		CompletionProviderCompletionCommand _tmp14_ = {0};
		gint _tmp15_ = 0;
		gchar* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		_tmp14_ = command;
		_tmp15_ = arg_num;
		_tmp16_ = completion_provider_get_command_info (self, &_tmp14_, _tmp15_);
		info = _tmp16_;
		_tmp17_ = info;
		completion_provider_show_calltip_info (self, _tmp17_);
		_g_free0 (info);
	}
	completion_provider_completion_command_destroy (&command);
}


static void completion_provider_show_calltip_info (CompletionProvider* self, const gchar* markup) {
	GtkSourceCompletionInfo* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	MainWindow* window = NULL;
	LatexilaApp* _tmp3_ = NULL;
	LatexilaApp* _tmp4_ = NULL;
	GtkWindow* _tmp5_ = NULL;
	GtkWindow* _tmp6_ = NULL;
	MainWindow* _tmp7_ = NULL;
	MainWindow* _tmp8_ = NULL;
	GtkSourceCompletionInfo* _tmp9_ = NULL;
	GtkSourceCompletionInfo* _tmp10_ = NULL;
	DocumentView* _tmp11_ = NULL;
	DocumentView* _tmp12_ = NULL;
	GtkTextIter cursor_pos = {0};
	GtkTextBuffer* buffer = NULL;
	DocumentView* _tmp13_ = NULL;
	DocumentView* _tmp14_ = NULL;
	GtkTextBuffer* _tmp15_ = NULL;
	GtkTextBuffer* _tmp16_ = NULL;
	GtkTextBuffer* _tmp17_ = NULL;
	GtkTextMark* _tmp18_ = NULL;
	GtkTextIter _tmp19_ = {0};
	GtkTextIter begin_arg_pos = {0};
	GtkTextIter _tmp20_ = {0};
	GtkTextIter _tmp21_ = {0};
	GtkSourceCompletionInfo* _tmp22_ = NULL;
	DocumentView* _tmp23_ = NULL;
	DocumentView* _tmp24_ = NULL;
	GtkTextIter _tmp25_ = {0};
	GtkSourceCompletionInfo* _tmp26_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (markup != NULL);
	_tmp0_ = self->priv->_calltip_window;
	if (_tmp0_ == NULL) {
		completion_provider_init_calltip_window (self);
	}
	_tmp1_ = self->priv->_calltip_window_label;
	_tmp2_ = markup;
	gtk_label_set_markup (_tmp1_, _tmp2_);
	_tmp3_ = latexila_app_get_instance ();
	_tmp4_ = _tmp3_;
	_tmp5_ = gtk_application_get_active_window ((GtkApplication*) _tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp6_, TYPE_MAIN_WINDOW) ? ((MainWindow*) _tmp6_) : NULL);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (_tmp4_);
	window = _tmp8_;
	_tmp9_ = self->priv->_calltip_window;
	gtk_window_set_transient_for ((GtkWindow*) _tmp9_, (GtkWindow*) window);
	_tmp10_ = self->priv->_calltip_window;
	_tmp11_ = main_window_get_active_view (window);
	_tmp12_ = _tmp11_;
	gtk_window_set_attached_to ((GtkWindow*) _tmp10_, (GtkWidget*) _tmp12_);
	_tmp13_ = main_window_get_active_view (window);
	_tmp14_ = _tmp13_;
	_tmp15_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	buffer = _tmp17_;
	_tmp18_ = gtk_text_buffer_get_insert (buffer);
	gtk_text_buffer_get_iter_at_mark (buffer, &_tmp19_, _tmp18_);
	cursor_pos = _tmp19_;
	_tmp20_ = cursor_pos;
	completion_provider_get_begin_arg_pos (self, &_tmp20_, &_tmp21_);
	begin_arg_pos = _tmp21_;
	_tmp22_ = self->priv->_calltip_window;
	_tmp23_ = main_window_get_active_view (window);
	_tmp24_ = _tmp23_;
	_tmp25_ = begin_arg_pos;
	gtk_source_completion_info_move_to_iter (_tmp22_, (GtkTextView*) _tmp24_, &_tmp25_);
	_tmp26_ = self->priv->_calltip_window;
	gtk_widget_show_all ((GtkWidget*) _tmp26_);
	_g_object_unref0 (buffer);
	_g_object_unref0 (window);
}


void completion_provider_hide_calltip_window (CompletionProvider* self) {
	GtkSourceCompletionInfo* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_calltip_window;
	if (_tmp0_ != NULL) {
		GtkSourceCompletionInfo* _tmp1_ = NULL;
		_tmp1_ = self->priv->_calltip_window;
		gtk_widget_hide ((GtkWidget*) _tmp1_);
	}
}


/*************************************************************************/
static gboolean completion_provider_real_activate_proposal (GtkSourceCompletionProvider* base, GtkSourceCompletionProposal* proposal, GtkTextIter* iter) {
	CompletionProvider * self;
	gboolean result = FALSE;
	gchar* text = NULL;
	GtkSourceCompletionProposal* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	const gchar* _tmp3_ = NULL;
	gchar* cmd = NULL;
	GtkTextIter _tmp5_ = {0};
	gchar* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	const gchar* _tmp8_ = NULL;
	self = (CompletionProvider*) base;
	g_return_val_if_fail (proposal != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = text;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp4_ = NULL;
		_tmp4_ = text;
		_tmp2_ = g_strcmp0 (_tmp4_, "") == 0;
	}
	if (_tmp2_) {
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_tmp5_ = *iter;
	_tmp6_ = completion_provider_get_latex_command_at_iter (self, &_tmp5_);
	cmd = _tmp6_;
	_tmp8_ = cmd;
	if (_tmp8_ != NULL) {
		_tmp7_ = TRUE;
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = text;
		_tmp10_ = g_str_has_prefix (_tmp9_, "\\");
		_tmp7_ = _tmp10_;
	}
	if (_tmp7_) {
		GtkSourceCompletionProposal* _tmp11_ = NULL;
		GtkTextIter _tmp12_ = {0};
		const gchar* _tmp13_ = NULL;
		_tmp11_ = proposal;
		_tmp12_ = *iter;
		_tmp13_ = cmd;
		completion_provider_activate_proposal_command_name (self, _tmp11_, &_tmp12_, _tmp13_);
	} else {
		CompletionProviderArgumentContext info = {0};
		GtkTextIter _tmp14_ = {0};
		CompletionProviderArgumentContext _tmp15_ = {0};
		gboolean _tmp16_ = FALSE;
		_tmp14_ = *iter;
		_tmp16_ = completion_provider_in_latex_command_argument (self, &_tmp14_, &_tmp15_);
		completion_provider_argument_context_destroy (&info);
		info = _tmp15_;
		if (_tmp16_) {
			GtkSourceCompletionProposal* _tmp17_ = NULL;
			GtkTextIter _tmp18_ = {0};
			CompletionProviderArgumentContext _tmp19_ = {0};
			const gchar* _tmp20_ = NULL;
			CompletionProviderArgumentContext _tmp21_ = {0};
			const gchar* _tmp22_ = NULL;
			_tmp17_ = proposal;
			_tmp18_ = *iter;
			_tmp19_ = info;
			_tmp20_ = _tmp19_.cmd_name;
			_tmp21_ = info;
			_tmp22_ = _tmp21_.arg_contents;
			completion_provider_activate_proposal_argument_choice (self, _tmp17_, &_tmp18_, _tmp20_, _tmp22_);
		} else {
			g_warning ("completion.vala:415: Not in a LaTeX command argument.");
		}
		completion_provider_argument_context_destroy (&info);
	}
	result = TRUE;
	_g_free0 (cmd);
	_g_free0 (text);
	return result;
}


static gchar* string_slice (const gchar* self, glong start, glong end) {
	gchar* result = NULL;
	glong string_length = 0L;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	glong _tmp2_ = 0L;
	glong _tmp5_ = 0L;
	gboolean _tmp8_ = FALSE;
	glong _tmp9_ = 0L;
	gboolean _tmp12_ = FALSE;
	glong _tmp13_ = 0L;
	glong _tmp16_ = 0L;
	glong _tmp17_ = 0L;
	glong _tmp18_ = 0L;
	glong _tmp19_ = 0L;
	glong _tmp20_ = 0L;
	gchar* _tmp21_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	_tmp2_ = start;
	if (_tmp2_ < ((glong) 0)) {
		glong _tmp3_ = 0L;
		glong _tmp4_ = 0L;
		_tmp3_ = string_length;
		_tmp4_ = start;
		start = _tmp3_ + _tmp4_;
	}
	_tmp5_ = end;
	if (_tmp5_ < ((glong) 0)) {
		glong _tmp6_ = 0L;
		glong _tmp7_ = 0L;
		_tmp6_ = string_length;
		_tmp7_ = end;
		end = _tmp6_ + _tmp7_;
	}
	_tmp9_ = start;
	if (_tmp9_ >= ((glong) 0)) {
		glong _tmp10_ = 0L;
		glong _tmp11_ = 0L;
		_tmp10_ = start;
		_tmp11_ = string_length;
		_tmp8_ = _tmp10_ <= _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	g_return_val_if_fail (_tmp8_, NULL);
	_tmp13_ = end;
	if (_tmp13_ >= ((glong) 0)) {
		glong _tmp14_ = 0L;
		glong _tmp15_ = 0L;
		_tmp14_ = end;
		_tmp15_ = string_length;
		_tmp12_ = _tmp14_ <= _tmp15_;
	} else {
		_tmp12_ = FALSE;
	}
	g_return_val_if_fail (_tmp12_, NULL);
	_tmp16_ = start;
	_tmp17_ = end;
	g_return_val_if_fail (_tmp16_ <= _tmp17_, NULL);
	_tmp18_ = start;
	_tmp19_ = end;
	_tmp20_ = start;
	_tmp21_ = g_strndup (((gchar*) self) + _tmp18_, (gsize) (_tmp19_ - _tmp20_));
	result = _tmp21_;
	return result;
}


static void completion_provider_activate_proposal_command_name (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* cmd) {
	gchar* text = NULL;
	GtkSourceCompletionProposal* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	glong index_start = 0L;
	gchar* text_to_insert = NULL;
	const gchar* _tmp7_ = NULL;
	glong _tmp8_ = 0L;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp13_ = NULL;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextMark* old_pos_mark = NULL;
	GtkTextBuffer* _tmp15_ = NULL;
	GtkTextIter _tmp16_ = {0};
	GtkTextMark* _tmp17_ = NULL;
	GtkTextMark* _tmp18_ = NULL;
	GtkTextBuffer* _tmp19_ = NULL;
	GtkTextBuffer* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	GtkTextBuffer* _tmp22_ = NULL;
	GtkTextIter old_pos_iter = {0};
	GtkTextBuffer* _tmp23_ = NULL;
	GtkTextMark* _tmp24_ = NULL;
	GtkTextIter _tmp25_ = {0};
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextMark* _tmp27_ = NULL;
	GtkTextIter match_end = {0};
	GtkTextIter _tmp28_ = {0};
	GtkTextIter _tmp29_ = {0};
	gboolean _tmp30_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = cmd;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp4_ = cmd;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = 0;
	}
	index_start = (glong) _tmp2_;
	_tmp7_ = text;
	_tmp8_ = index_start;
	_tmp9_ = text;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_slice (_tmp7_, _tmp8_, (glong) _tmp11_);
	text_to_insert = _tmp12_;
	_tmp13_ = gtk_text_iter_get_buffer (iter);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	doc = _tmp14_;
	_tmp15_ = doc;
	_tmp16_ = *iter;
	_tmp17_ = gtk_text_buffer_create_mark (_tmp15_, NULL, &_tmp16_, TRUE);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	old_pos_mark = _tmp18_;
	_tmp19_ = doc;
	gtk_text_buffer_begin_user_action (_tmp19_);
	_tmp20_ = doc;
	_tmp21_ = text_to_insert;
	gtk_text_buffer_insert (_tmp20_, iter, _tmp21_, -1);
	_tmp22_ = doc;
	gtk_text_buffer_end_user_action (_tmp22_);
	_tmp23_ = doc;
	_tmp24_ = old_pos_mark;
	gtk_text_buffer_get_iter_at_mark (_tmp23_, &_tmp25_, _tmp24_);
	old_pos_iter = _tmp25_;
	_tmp26_ = doc;
	_tmp27_ = old_pos_mark;
	gtk_text_buffer_delete_mark (_tmp26_, _tmp27_);
	_tmp28_ = *iter;
	_tmp30_ = gtk_text_iter_forward_search (&old_pos_iter, "{", GTK_TEXT_SEARCH_TEXT_ONLY | GTK_TEXT_SEARCH_VISIBLE_ONLY, NULL, &_tmp29_, &_tmp28_);
	match_end = _tmp29_;
	if (_tmp30_) {
		GtkTextBuffer* _tmp31_ = NULL;
		GtkTextIter _tmp32_ = {0};
		_tmp31_ = doc;
		_tmp32_ = match_end;
		gtk_text_buffer_place_cursor (_tmp31_, &_tmp32_);
	}
	_g_object_unref0 (old_pos_mark);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}


static void completion_provider_activate_proposal_argument_choice (CompletionProvider* self, GtkSourceCompletionProposal* proposal, GtkTextIter* iter, const gchar* arg_cmd, const gchar* arg_contents) {
	gchar* text = NULL;
	GtkSourceCompletionProposal* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	const gchar* _tmp3_ = NULL;
	glong index_start = 0L;
	gchar* text_to_insert = NULL;
	const gchar* _tmp7_ = NULL;
	glong _tmp8_ = 0L;
	const gchar* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gchar* _tmp12_ = NULL;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp13_ = NULL;
	GtkTextBuffer* _tmp14_ = NULL;
	GtkTextBuffer* _tmp15_ = NULL;
	GtkTextBuffer* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	GtkTextBuffer* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (proposal != NULL);
	g_return_if_fail (iter != NULL);
	g_return_if_fail (arg_cmd != NULL);
	_tmp0_ = proposal;
	_tmp1_ = gtk_source_completion_proposal_get_text (_tmp0_);
	text = _tmp1_;
	_tmp3_ = arg_contents;
	if (_tmp3_ != NULL) {
		const gchar* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		_tmp4_ = arg_contents;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = 0;
	}
	index_start = (glong) _tmp2_;
	_tmp7_ = text;
	_tmp8_ = index_start;
	_tmp9_ = text;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = string_slice (_tmp7_, _tmp8_, (glong) _tmp11_);
	text_to_insert = _tmp12_;
	_tmp13_ = gtk_text_iter_get_buffer (iter);
	_tmp14_ = _g_object_ref0 (_tmp13_);
	doc = _tmp14_;
	_tmp15_ = doc;
	gtk_text_buffer_begin_user_action (_tmp15_);
	_tmp16_ = doc;
	_tmp17_ = text_to_insert;
	gtk_text_buffer_insert (_tmp16_, iter, _tmp17_, -1);
	_tmp18_ = arg_cmd;
	if (g_strcmp0 (_tmp18_, "\\begin") == 0) {
		const gchar* _tmp19_ = NULL;
		GtkTextIter _tmp20_ = {0};
		_tmp19_ = text;
		_tmp20_ = *iter;
		completion_provider_close_environment (self, _tmp19_, &_tmp20_);
	} else {
	}
	_tmp21_ = doc;
	gtk_text_buffer_end_user_action (_tmp21_);
	_g_object_unref0 (doc);
	_g_free0 (text_to_insert);
	_g_free0 (text);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void completion_provider_close_environment (CompletionProvider* self, const gchar* env_name, GtkTextIter* iter) {
	Document* doc = NULL;
	GtkTextBuffer* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	gunichar _tmp2_ = 0U;
	gchar* cur_indent = NULL;
	Document* _tmp4_ = NULL;
	GtkTextIter _tmp5_ = {0};
	gchar* _tmp6_ = NULL;
	gchar* indent = NULL;
	Document* _tmp7_ = NULL;
	DocumentTab* _tmp8_ = NULL;
	DocumentView* _tmp9_ = NULL;
	DocumentView* _tmp10_ = NULL;
	gchar* _tmp11_ = NULL;
	CompletionProviderCompletionChoice* env = NULL;
	GeeHashMap* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	gpointer _tmp14_ = NULL;
	Document* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	const gchar* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	gchar* _tmp20_ = NULL;
	gchar* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	CompletionProviderCompletionChoice* _tmp23_ = NULL;
	GtkTextMark* cursor_pos = NULL;
	Document* _tmp29_ = NULL;
	GtkTextIter _tmp30_ = {0};
	GtkTextMark* _tmp31_ = NULL;
	GtkTextMark* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	CompletionProviderCompletionChoice* _tmp34_ = NULL;
	Document* _tmp40_ = NULL;
	const gchar* _tmp41_ = NULL;
	const gchar* _tmp42_ = NULL;
	const gchar* _tmp43_ = NULL;
	const gchar* _tmp44_ = NULL;
	gchar* _tmp45_ = NULL;
	gchar* _tmp46_ = NULL;
	Document* _tmp47_ = NULL;
	GtkTextMark* _tmp48_ = NULL;
	GtkTextIter _tmp49_ = {0};
	Document* _tmp50_ = NULL;
	GtkTextMark* _tmp51_ = NULL;
	Document* _tmp52_ = NULL;
	GtkTextIter _tmp53_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (env_name != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = gtk_text_iter_get_buffer (iter);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp0_, TYPE_DOCUMENT) ? ((Document*) _tmp0_) : NULL);
	doc = _tmp1_;
	_tmp2_ = gtk_text_iter_get_char (iter);
	if (_tmp2_ == ((gunichar) '}')) {
		gtk_text_iter_forward_char (iter);
	} else {
		Document* _tmp3_ = NULL;
		_tmp3_ = doc;
		document_insert (_tmp3_, iter, "}", -1);
	}
	_tmp4_ = doc;
	_tmp5_ = *iter;
	_tmp6_ = document_get_current_indentation (_tmp4_, &_tmp5_);
	cur_indent = _tmp6_;
	_tmp7_ = doc;
	_tmp8_ = _tmp7_->tab;
	_tmp9_ = document_tab_get_view (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = document_view_get_indentation_style (_tmp10_);
	indent = _tmp11_;
	_tmp12_ = self->priv->_environments;
	_tmp13_ = env_name;
	_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp12_, _tmp13_);
	env = (CompletionProviderCompletionChoice*) _tmp14_;
	_tmp15_ = doc;
	_tmp16_ = cur_indent;
	_tmp17_ = string_to_string (_tmp16_);
	_tmp18_ = indent;
	_tmp19_ = string_to_string (_tmp18_);
	_tmp20_ = g_strconcat ("\n", _tmp17_, _tmp19_, NULL);
	_tmp21_ = _tmp20_;
	document_insert (_tmp15_, iter, _tmp21_, -1);
	_g_free0 (_tmp21_);
	_tmp23_ = env;
	if (_tmp23_ != NULL) {
		CompletionProviderCompletionChoice* _tmp24_ = NULL;
		const gchar* _tmp25_ = NULL;
		_tmp24_ = env;
		_tmp25_ = (*_tmp24_).insert;
		_tmp22_ = _tmp25_ != NULL;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		Document* _tmp26_ = NULL;
		CompletionProviderCompletionChoice* _tmp27_ = NULL;
		const gchar* _tmp28_ = NULL;
		_tmp26_ = doc;
		_tmp27_ = env;
		_tmp28_ = (*_tmp27_).insert;
		document_insert (_tmp26_, iter, _tmp28_, -1);
	}
	_tmp29_ = doc;
	_tmp30_ = *iter;
	_tmp31_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) _tmp29_, NULL, &_tmp30_, TRUE);
	_tmp32_ = _g_object_ref0 (_tmp31_);
	cursor_pos = _tmp32_;
	_tmp34_ = env;
	if (_tmp34_ != NULL) {
		CompletionProviderCompletionChoice* _tmp35_ = NULL;
		const gchar* _tmp36_ = NULL;
		_tmp35_ = env;
		_tmp36_ = (*_tmp35_).insert_after;
		_tmp33_ = _tmp36_ != NULL;
	} else {
		_tmp33_ = FALSE;
	}
	if (_tmp33_) {
		Document* _tmp37_ = NULL;
		CompletionProviderCompletionChoice* _tmp38_ = NULL;
		const gchar* _tmp39_ = NULL;
		_tmp37_ = doc;
		_tmp38_ = env;
		_tmp39_ = (*_tmp38_).insert_after;
		document_insert (_tmp37_, iter, _tmp39_, -1);
	}
	_tmp40_ = doc;
	_tmp41_ = cur_indent;
	_tmp42_ = string_to_string (_tmp41_);
	_tmp43_ = env_name;
	_tmp44_ = string_to_string (_tmp43_);
	_tmp45_ = g_strconcat ("\n", _tmp42_, "\\end{", _tmp44_, "}", NULL);
	_tmp46_ = _tmp45_;
	document_insert (_tmp40_, iter, _tmp46_, -1);
	_g_free0 (_tmp46_);
	_tmp47_ = doc;
	_tmp48_ = cursor_pos;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) _tmp47_, &_tmp49_, _tmp48_);
	*iter = _tmp49_;
	_tmp50_ = doc;
	_tmp51_ = cursor_pos;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) _tmp50_, _tmp51_);
	_tmp52_ = doc;
	_tmp53_ = *iter;
	gtk_text_buffer_place_cursor ((GtkTextBuffer*) _tmp52_, &_tmp53_);
	_g_object_unref0 (cursor_pos);
	_completion_provider_completion_choice_free0 (env);
	_g_free0 (indent);
	_g_free0 (cur_indent);
	_g_object_unref0 (doc);
}


/*************************************************************************/
static gboolean string_get_prev_char (const gchar* self, gint* index, gunichar* c) {
	gunichar _vala_c = 0U;
	gboolean result = FALSE;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = *index;
	if (0 < _tmp0_) {
		gint _tmp1_ = 0;
		gchar* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gunichar _tmp4_ = 0U;
		_tmp1_ = *index;
		_tmp2_ = g_utf8_prev_char (((gchar*) self) + _tmp1_);
		*index = (gint) (_tmp2_ - ((gchar*) self));
		_tmp3_ = *index;
		_tmp4_ = g_utf8_get_char (((gchar*) self) + _tmp3_);
		_vala_c = _tmp4_;
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		_vala_c = (gunichar) 0;
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	if (c) {
		*c = _vala_c;
	}
}


static void completion_provider_get_begin_arg_pos (CompletionProvider* self, GtkTextIter* in_arg_pos, GtkTextIter* result) {
	gchar* text = NULL;
	GtkTextIter _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	gint index = 0;
	const gchar* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gunichar cur_char = 0U;
	GtkTextIter begin_arg_pos = {0};
	GtkTextIter _tmp15_ = {0};
	gint _tmp16_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (in_arg_pos != NULL);
	_tmp0_ = *in_arg_pos;
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = text;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	index = _tmp4_;
	while (TRUE) {
		const gchar* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		gboolean _tmp9_ = FALSE;
		gunichar _tmp10_ = 0U;
		_tmp5_ = text;
		_tmp7_ = string_get_prev_char (_tmp5_, &index, &_tmp6_);
		cur_char = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp10_ = cur_char;
		if (_tmp10_ == ((gunichar) '[')) {
			_tmp9_ = TRUE;
		} else {
			gunichar _tmp11_ = 0U;
			_tmp11_ = cur_char;
			_tmp9_ = _tmp11_ == ((gunichar) '{');
		}
		if (_tmp9_) {
			const gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gboolean _tmp14_ = FALSE;
			_tmp12_ = text;
			_tmp13_ = index;
			_tmp14_ = utils_char_is_escaped (_tmp12_, (glong) _tmp13_);
			_tmp8_ = !_tmp14_;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			break;
		}
	}
	_tmp15_ = *in_arg_pos;
	begin_arg_pos = _tmp15_;
	_tmp16_ = index;
	gtk_text_iter_set_visible_line_index (&begin_arg_pos, _tmp16_);
	gtk_text_iter_forward_char (&begin_arg_pos);
	*result = begin_arg_pos;
	_g_free0 (text);
	return;
}


static gchar* completion_provider_get_latex_command_at_iter (CompletionProvider* self, GtkTextIter* iter) {
	gchar* result = NULL;
	gchar* text = NULL;
	GtkTextIter _tmp0_ = {0};
	gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = *iter;
	_tmp1_ = completion_provider_get_text_line_to_iter (self, &_tmp0_);
	text = _tmp1_;
	_tmp2_ = strlen (text);
	_tmp3_ = _tmp2_;
	_tmp4_ = completion_provider_get_latex_command_at_index (self, text, _tmp3_);
	result = _tmp4_;
	_g_free0 (text);
	return result;
}


static gchar* completion_provider_get_latex_command_at_index (CompletionProvider* self, const gchar* text, gint index) {
	gchar* result = NULL;
	gint _tmp0_ = 0;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint cur_index = 0;
	gint _tmp4_ = 0;
	gunichar cur_char = 0U;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = index;
	_tmp1_ = text;
	_tmp2_ = strlen (_tmp1_);
	_tmp3_ = _tmp2_;
	g_return_val_if_fail (_tmp0_ <= _tmp3_, NULL);
	_tmp4_ = index;
	cur_index = _tmp4_;
	while (TRUE) {
		const gchar* _tmp5_ = NULL;
		gunichar _tmp6_ = 0U;
		gboolean _tmp7_ = FALSE;
		gunichar _tmp8_ = 0U;
		gboolean _tmp16_ = FALSE;
		gunichar _tmp17_ = 0U;
		gboolean _tmp18_ = FALSE;
		_tmp5_ = text;
		_tmp7_ = string_get_prev_char (_tmp5_, &cur_index, &_tmp6_);
		cur_char = _tmp6_;
		if (!_tmp7_) {
			break;
		}
		_tmp8_ = cur_char;
		if (_tmp8_ == ((gunichar) '\\')) {
			const gchar* _tmp9_ = NULL;
			gint _tmp10_ = 0;
			gboolean _tmp11_ = FALSE;
			const gchar* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			gchar* _tmp15_ = NULL;
			_tmp9_ = text;
			_tmp10_ = cur_index;
			_tmp11_ = utils_char_is_escaped (_tmp9_, (glong) _tmp10_);
			if (_tmp11_) {
				break;
			}
			_tmp12_ = text;
			_tmp13_ = cur_index;
			_tmp14_ = index;
			_tmp15_ = string_slice (_tmp12_, (glong) _tmp13_, (glong) _tmp14_);
			result = _tmp15_;
			return result;
		}
		_tmp17_ = cur_char;
		_tmp18_ = g_unichar_isalpha (_tmp17_);
		if (!_tmp18_) {
			gunichar _tmp19_ = 0U;
			_tmp19_ = cur_char;
			_tmp16_ = _tmp19_ != ((gunichar) '*');
		} else {
			_tmp16_ = FALSE;
		}
		if (_tmp16_) {
			break;
		}
	}
	result = NULL;
	return result;
}


static gboolean completion_provider_in_latex_command_argument (CompletionProvider* self, GtkTextIter* iter, CompletionProviderArgumentContext* info) {
	CompletionProviderArgumentContext _vala_info = {0};
	gboolean result = FALSE;
	GeeArrayList* _tmp0_ = NULL;
	gchar* text = NULL;
	GtkTextIter _tmp1_ = {0};
	gchar* _tmp2_ = NULL;
	gint last_index = 0;
	const gchar* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint cur_index = 0;
	gint _tmp6_ = 0;
	gboolean in_prev_arg = FALSE;
	gunichar prev_arg_opening_bracket = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	completion_provider_argument_context_destroy (&_vala_info);
	memset (&_vala_info, 0, sizeof (CompletionProviderArgumentContext));
	_g_free0 (_vala_info.cmd_name);
	_vala_info.cmd_name = NULL;
	_g_free0 (_vala_info.arg_contents);
	_vala_info.arg_contents = NULL;
	_tmp0_ = gee_array_list_new (G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (_vala_info.args_types);
	_vala_info.args_types = _tmp0_;
	_tmp1_ = *iter;
	_tmp2_ = completion_provider_get_text_line_to_iter (self, &_tmp1_);
	text = _tmp2_;
	_tmp3_ = text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	last_index = _tmp5_;
	_tmp6_ = last_index;
	cur_index = _tmp6_;
	while (TRUE) {
		gunichar cur_char = 0U;
		const gchar* _tmp7_ = NULL;
		gunichar _tmp8_ = 0U;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		gunichar _tmp11_ = 0U;
		gboolean opening_bracket = FALSE;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp7_ = text;
		_tmp9_ = string_get_prev_char (_tmp7_, &cur_index, &_tmp8_);
		cur_char = _tmp8_;
		if (!_tmp9_) {
			result = FALSE;
			_g_free0 (text);
			if (info) {
				*info = _vala_info;
			} else {
				completion_provider_argument_context_destroy (&_vala_info);
			}
			return result;
		}
		_tmp11_ = cur_char;
		if (_tmp11_ == ((gunichar) '{')) {
			_tmp10_ = TRUE;
		} else {
			gunichar _tmp12_ = 0U;
			_tmp12_ = cur_char;
			_tmp10_ = _tmp12_ == ((gunichar) '[');
		}
		opening_bracket = _tmp10_;
		_tmp14_ = opening_bracket;
		if (_tmp14_) {
			const gchar* _tmp15_ = NULL;
			gint _tmp16_ = 0;
			gboolean _tmp17_ = FALSE;
			_tmp15_ = text;
			_tmp16_ = cur_index;
			_tmp17_ = utils_char_is_escaped (_tmp15_, (glong) _tmp16_);
			_tmp13_ = !_tmp17_;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			CompletionProviderArgumentContext _tmp18_ = {0};
			GeeArrayList* _tmp19_ = NULL;
			gunichar _tmp20_ = 0U;
			const gchar* _tmp21_ = NULL;
			gint _tmp22_ = 0;
			gint _tmp23_ = 0;
			gchar* _tmp24_ = NULL;
			_tmp18_ = _vala_info;
			_tmp19_ = _tmp18_.args_types;
			_tmp20_ = cur_char;
			gee_abstract_list_insert ((GeeAbstractList*) _tmp19_, 0, (gpointer) ((gintptr) (_tmp20_ == ((gunichar) '['))));
			_tmp21_ = text;
			_tmp22_ = cur_index;
			_tmp23_ = last_index;
			_tmp24_ = string_slice (_tmp21_, (glong) (_tmp22_ + 1), (glong) _tmp23_);
			_g_free0 (_vala_info.arg_contents);
			_vala_info.arg_contents = _tmp24_;
			break;
		}
	}
	in_prev_arg = FALSE;
	prev_arg_opening_bracket = (gunichar) '{';
	while (TRUE) {
		gunichar cur_char = 0U;
		const gchar* _tmp25_ = NULL;
		gunichar _tmp26_ = 0U;
		gboolean _tmp27_ = FALSE;
		gboolean _tmp28_ = FALSE;
		_tmp25_ = text;
		_tmp27_ = string_get_prev_char (_tmp25_, &cur_index, &_tmp26_);
		cur_char = _tmp26_;
		if (!_tmp27_) {
			result = FALSE;
			_g_free0 (text);
			if (info) {
				*info = _vala_info;
			} else {
				completion_provider_argument_context_destroy (&_vala_info);
			}
			return result;
		}
		_tmp28_ = in_prev_arg;
		if (_tmp28_) {
			gunichar _tmp29_ = 0U;
			gunichar _tmp30_ = 0U;
			_tmp29_ = cur_char;
			_tmp30_ = prev_arg_opening_bracket;
			if (_tmp29_ == _tmp30_) {
				const gchar* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gboolean _tmp33_ = FALSE;
				_tmp31_ = text;
				_tmp32_ = cur_index;
				_tmp33_ = utils_char_is_escaped (_tmp31_, (glong) _tmp32_);
				in_prev_arg = _tmp33_;
			}
		} else {
			gboolean _tmp34_ = FALSE;
			gunichar _tmp35_ = 0U;
			_tmp35_ = cur_char;
			if (_tmp35_ == ((gunichar) '}')) {
				_tmp34_ = TRUE;
			} else {
				gunichar _tmp36_ = 0U;
				_tmp36_ = cur_char;
				_tmp34_ = _tmp36_ == ((gunichar) ']');
			}
			if (_tmp34_) {
				const gchar* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gboolean _tmp39_ = FALSE;
				gchar _tmp40_ = '\0';
				gunichar _tmp41_ = 0U;
				CompletionProviderArgumentContext _tmp42_ = {0};
				GeeArrayList* _tmp43_ = NULL;
				gunichar _tmp44_ = 0U;
				_tmp37_ = text;
				_tmp38_ = cur_index;
				_tmp39_ = utils_char_is_escaped (_tmp37_, (glong) _tmp38_);
				if (_tmp39_) {
					result = FALSE;
					_g_free0 (text);
					if (info) {
						*info = _vala_info;
					} else {
						completion_provider_argument_context_destroy (&_vala_info);
					}
					return result;
				}
				in_prev_arg = TRUE;
				_tmp41_ = cur_char;
				if (_tmp41_ == ((gunichar) '}')) {
					_tmp40_ = '{';
				} else {
					_tmp40_ = '[';
				}
				prev_arg_opening_bracket = (gunichar) _tmp40_;
				_tmp42_ = _vala_info;
				_tmp43_ = _tmp42_.args_types;
				_tmp44_ = cur_char;
				gee_abstract_list_insert ((GeeAbstractList*) _tmp43_, 0, (gpointer) ((gintptr) (_tmp44_ == ((gunichar) ']'))));
			} else {
				gboolean _tmp45_ = FALSE;
				gunichar _tmp46_ = 0U;
				gboolean _tmp47_ = FALSE;
				_tmp46_ = cur_char;
				_tmp47_ = g_unichar_isalpha (_tmp46_);
				if (_tmp47_) {
					_tmp45_ = TRUE;
				} else {
					gunichar _tmp48_ = 0U;
					_tmp48_ = cur_char;
					_tmp45_ = _tmp48_ == ((gunichar) '*');
				}
				if (_tmp45_) {
					const gchar* _tmp49_ = NULL;
					gint _tmp50_ = 0;
					gchar* _tmp51_ = NULL;
					CompletionProviderArgumentContext _tmp52_ = {0};
					const gchar* _tmp53_ = NULL;
					_tmp49_ = text;
					_tmp50_ = cur_index;
					_tmp51_ = completion_provider_get_latex_command_at_index (self, _tmp49_, _tmp50_ + 1);
					_g_free0 (_vala_info.cmd_name);
					_vala_info.cmd_name = _tmp51_;
					_tmp52_ = _vala_info;
					_tmp53_ = _tmp52_.cmd_name;
					result = _tmp53_ != NULL;
					_g_free0 (text);
					if (info) {
						*info = _vala_info;
					} else {
						completion_provider_argument_context_destroy (&_vala_info);
					}
					return result;
				} else {
					gunichar _tmp54_ = 0U;
					gboolean _tmp55_ = FALSE;
					_tmp54_ = cur_char;
					_tmp55_ = g_unichar_isspace (_tmp54_);
					if (!_tmp55_) {
						result = FALSE;
						_g_free0 (text);
						if (info) {
							*info = _vala_info;
						} else {
							completion_provider_argument_context_destroy (&_vala_info);
						}
						return result;
					}
				}
			}
		}
	}
	_g_free0 (text);
	if (info) {
		*info = _vala_info;
	} else {
		completion_provider_argument_context_destroy (&_vala_info);
	}
}


/*************************************************************************/
static gboolean completion_provider_is_user_request (CompletionProvider* self, GtkSourceCompletionContext* context) {
	gboolean result = FALSE;
	GtkSourceCompletionContext* _tmp0_ = NULL;
	GtkSourceCompletionActivation _tmp1_ = 0;
	GtkSourceCompletionActivation _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (context != NULL, FALSE);
	_tmp0_ = context;
	g_object_get (_tmp0_, "activation", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_ == GTK_SOURCE_COMPLETION_ACTIVATION_USER_REQUESTED;
	return result;
}


static gint completion_provider_compare_proposals (GtkSourceCompletionItem* a, GtkSourceCompletionItem* b) {
	gint result = 0;
	GtkSourceCompletionItem* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GtkSourceCompletionItem* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = a;
	g_object_get (_tmp0_, "text", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = b;
	g_object_get (_tmp4_, "text", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_;
	_tmp8_ = g_utf8_collate (_tmp3_, _tmp7_);
	_tmp9_ = _tmp8_;
	_g_free0 (_tmp7_);
	_g_free0 (_tmp3_);
	result = _tmp9_;
	return result;
}


static gchar* completion_provider_get_text_line_to_iter (CompletionProvider* self, GtkTextIter* iter) {
	gchar* result = NULL;
	gint line = 0;
	gint _tmp0_ = 0;
	GtkTextBuffer* doc = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextIter iter_start = {0};
	GtkTextIter _tmp3_ = {0};
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	gchar* _tmp6_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (iter != NULL, NULL);
	_tmp0_ = gtk_text_iter_get_line (iter);
	line = _tmp0_;
	_tmp1_ = gtk_text_iter_get_buffer (iter);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	doc = _tmp2_;
	gtk_text_buffer_get_iter_at_line (doc, &_tmp3_, line);
	iter_start = _tmp3_;
	_tmp4_ = iter_start;
	_tmp5_ = *iter;
	_tmp6_ = gtk_text_buffer_get_text (doc, &_tmp4_, &_tmp5_, FALSE);
	result = _tmp6_;
	_g_object_unref0 (doc);
	return result;
}


static gchar* completion_provider_get_command_info (CompletionProvider* self, CompletionProviderCompletionCommand* cmd, gint cur_arg) {
	gchar* result = NULL;
	gchar* info = NULL;
	CompletionProviderCompletionCommand _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gint arg_num = 0;
	CompletionProviderCompletionCommand _tmp3_ = {0};
	CompletionProviderCompletionArgument* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	CompletionProviderCompletionCommand _tmp33_ = {0};
	const gchar* _tmp34_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	info = _tmp2_;
	arg_num = 1;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < _tmp4__length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			completion_provider_completion_argument_copy (&arg_collection[arg_it], &_tmp5_);
			arg = _tmp5_;
			{
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				CompletionProviderCompletionArgument _tmp10_ = {0};
				gboolean _tmp11_ = FALSE;
				gint _tmp28_ = 0;
				gint _tmp29_ = 0;
				gint _tmp32_ = 0;
				_tmp6_ = arg_num;
				_tmp7_ = cur_arg;
				if (_tmp6_ == _tmp7_) {
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					_tmp8_ = info;
					_tmp9_ = g_strconcat (_tmp8_, "<b>", NULL);
					_g_free0 (info);
					info = _tmp9_;
				}
				_tmp10_ = arg;
				_tmp11_ = _tmp10_.optional;
				if (_tmp11_) {
					const gchar* _tmp12_ = NULL;
					CompletionProviderCompletionArgument _tmp13_ = {0};
					const gchar* _tmp14_ = NULL;
					gchar* _tmp15_ = NULL;
					gchar* _tmp16_ = NULL;
					gchar* _tmp17_ = NULL;
					gchar* _tmp18_ = NULL;
					gchar* _tmp19_ = NULL;
					_tmp12_ = info;
					_tmp13_ = arg;
					_tmp14_ = _tmp13_.label;
					_tmp15_ = g_strconcat ("[", _tmp14_, NULL);
					_tmp16_ = _tmp15_;
					_tmp17_ = g_strconcat (_tmp16_, "]", NULL);
					_tmp18_ = _tmp17_;
					_tmp19_ = g_strconcat (_tmp12_, _tmp18_, NULL);
					_g_free0 (info);
					info = _tmp19_;
					_g_free0 (_tmp18_);
					_g_free0 (_tmp16_);
				} else {
					const gchar* _tmp20_ = NULL;
					CompletionProviderCompletionArgument _tmp21_ = {0};
					const gchar* _tmp22_ = NULL;
					gchar* _tmp23_ = NULL;
					gchar* _tmp24_ = NULL;
					gchar* _tmp25_ = NULL;
					gchar* _tmp26_ = NULL;
					gchar* _tmp27_ = NULL;
					_tmp20_ = info;
					_tmp21_ = arg;
					_tmp22_ = _tmp21_.label;
					_tmp23_ = g_strconcat ("{", _tmp22_, NULL);
					_tmp24_ = _tmp23_;
					_tmp25_ = g_strconcat (_tmp24_, "}", NULL);
					_tmp26_ = _tmp25_;
					_tmp27_ = g_strconcat (_tmp20_, _tmp26_, NULL);
					_g_free0 (info);
					info = _tmp27_;
					_g_free0 (_tmp26_);
					_g_free0 (_tmp24_);
				}
				_tmp28_ = arg_num;
				_tmp29_ = cur_arg;
				if (_tmp28_ == _tmp29_) {
					const gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					_tmp30_ = info;
					_tmp31_ = g_strconcat (_tmp30_, "</b>", NULL);
					_g_free0 (info);
					info = _tmp31_;
				}
				_tmp32_ = arg_num;
				arg_num = _tmp32_ + 1;
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	_tmp33_ = *cmd;
	_tmp34_ = _tmp33_.package;
	if (_tmp34_ != NULL) {
		const gchar* _tmp35_ = NULL;
		CompletionProviderCompletionCommand _tmp36_ = {0};
		const gchar* _tmp37_ = NULL;
		gchar* _tmp38_ = NULL;
		gchar* _tmp39_ = NULL;
		gchar* _tmp40_ = NULL;
		_tmp35_ = info;
		_tmp36_ = *cmd;
		_tmp37_ = _tmp36_.package;
		_tmp38_ = g_strconcat ("\nPackage: ", _tmp37_, NULL);
		_tmp39_ = _tmp38_;
		_tmp40_ = g_strconcat (_tmp35_, _tmp39_, NULL);
		_g_free0 (info);
		info = _tmp40_;
		_g_free0 (_tmp39_);
	}
	result = info;
	return result;
}


static gint completion_provider_get_argument_num (CompletionProvider* self, CompletionProviderCompletionArgument* all_args, int all_args_length1, GeeArrayList* args) {
	gint result = 0;
	CompletionProviderCompletionArgument* _tmp0_ = NULL;
	gint _tmp0__length1 = 0;
	GeeArrayList* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint num = 0;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (args != NULL, 0);
	_tmp0_ = all_args;
	_tmp0__length1 = all_args_length1;
	_tmp1_ = args;
	_tmp2_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp0__length1 < _tmp3_) {
		result = -1;
		return result;
	}
	num = 0;
	{
		GeeArrayList* _arg_list = NULL;
		GeeArrayList* _tmp4_ = NULL;
		GeeArrayList* _tmp5_ = NULL;
		gint _arg_size = 0;
		GeeArrayList* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _arg_index = 0;
		_tmp4_ = args;
		_tmp5_ = _g_object_ref0 (_tmp4_);
		_arg_list = _tmp5_;
		_tmp6_ = _arg_list;
		_tmp7_ = gee_abstract_collection_get_size ((GeeCollection*) _tmp6_);
		_tmp8_ = _tmp7_;
		_arg_size = _tmp8_;
		_arg_index = -1;
		while (TRUE) {
			gint _tmp9_ = 0;
			gint _tmp10_ = 0;
			gint _tmp11_ = 0;
			gboolean arg = FALSE;
			GeeArrayList* _tmp12_ = NULL;
			gint _tmp13_ = 0;
			gpointer _tmp14_ = NULL;
			gint _tmp27_ = 0;
			_tmp9_ = _arg_index;
			_arg_index = _tmp9_ + 1;
			_tmp10_ = _arg_index;
			_tmp11_ = _arg_size;
			if (!(_tmp10_ < _tmp11_)) {
				break;
			}
			_tmp12_ = _arg_list;
			_tmp13_ = _arg_index;
			_tmp14_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _tmp13_);
			arg = (gboolean) ((gintptr) _tmp14_);
			while (TRUE) {
				CompletionProviderCompletionArgument* _tmp15_ = NULL;
				gint _tmp15__length1 = 0;
				gint _tmp16_ = 0;
				CompletionProviderCompletionArgument* _tmp17_ = NULL;
				gint _tmp17__length1 = 0;
				gint _tmp18_ = 0;
				CompletionProviderCompletionArgument _tmp19_ = {0};
				gboolean _tmp20_ = FALSE;
				gboolean _tmp21_ = FALSE;
				gint _tmp26_ = 0;
				_tmp15_ = all_args;
				_tmp15__length1 = all_args_length1;
				_tmp16_ = num;
				if (_tmp15__length1 <= _tmp16_) {
					result = -1;
					_g_object_unref0 (_arg_list);
					return result;
				}
				_tmp17_ = all_args;
				_tmp17__length1 = all_args_length1;
				_tmp18_ = num;
				_tmp19_ = _tmp17_[_tmp18_];
				_tmp20_ = _tmp19_.optional;
				_tmp21_ = arg;
				if (_tmp20_ == _tmp21_) {
					break;
				} else {
					CompletionProviderCompletionArgument* _tmp22_ = NULL;
					gint _tmp22__length1 = 0;
					gint _tmp23_ = 0;
					CompletionProviderCompletionArgument _tmp24_ = {0};
					gboolean _tmp25_ = FALSE;
					_tmp22_ = all_args;
					_tmp22__length1 = all_args_length1;
					_tmp23_ = num;
					_tmp24_ = _tmp22_[_tmp23_];
					_tmp25_ = _tmp24_.optional;
					if (!_tmp25_) {
						result = -1;
						_g_object_unref0 (_arg_list);
						return result;
					}
				}
				_tmp26_ = num;
				num = _tmp26_ + 1;
			}
			_tmp27_ = num;
			num = _tmp27_ + 1;
		}
		_g_object_unref0 (_arg_list);
	}
	result = num;
	return result;
}


static gchar* completion_provider_get_command_text_to_insert (CompletionProvider* self, CompletionProviderCompletionCommand* cmd) {
	gchar* result = NULL;
	gchar* text_to_insert = NULL;
	CompletionProviderCompletionCommand _tmp0_ = {0};
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	CompletionProviderCompletionCommand _tmp3_ = {0};
	CompletionProviderCompletionArgument* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cmd != NULL, NULL);
	_tmp0_ = *cmd;
	_tmp1_ = _tmp0_.name;
	_tmp2_ = g_strdup (_tmp1_);
	text_to_insert = _tmp2_;
	_tmp3_ = *cmd;
	_tmp4_ = _tmp3_.args;
	_tmp4__length1 = _tmp3_.args_length1;
	{
		CompletionProviderCompletionArgument* arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _tmp4_;
		arg_collection_length1 = _tmp4__length1;
		for (arg_it = 0; arg_it < _tmp4__length1; arg_it = arg_it + 1) {
			CompletionProviderCompletionArgument _tmp5_ = {0};
			CompletionProviderCompletionArgument arg = {0};
			completion_provider_completion_argument_copy (&arg_collection[arg_it], &_tmp5_);
			arg = _tmp5_;
			{
				CompletionProviderCompletionArgument _tmp6_ = {0};
				gboolean _tmp7_ = FALSE;
				_tmp6_ = arg;
				_tmp7_ = _tmp6_.optional;
				if (!_tmp7_) {
					const gchar* _tmp8_ = NULL;
					gchar* _tmp9_ = NULL;
					_tmp8_ = text_to_insert;
					_tmp9_ = g_strconcat (_tmp8_, "{}", NULL);
					_g_free0 (text_to_insert);
					text_to_insert = _tmp9_;
				}
				completion_provider_completion_argument_destroy (&arg);
			}
		}
	}
	result = text_to_insert;
	return result;
}


/*************************************************************************/
static void _completion_provider_parser_start_gmarkup_parser_start_element_func (GMarkupParseContext* context, const gchar* element_name, gchar** attribute_names, gchar** attribute_values, gpointer self, GError** error) {
	completion_provider_parser_start ((CompletionProvider*) self, context, element_name, attribute_names, _vala_array_length (attribute_names), attribute_values, _vala_array_length (attribute_values), error);
}


static void _completion_provider_parser_end_gmarkup_parser_end_element_func (GMarkupParseContext* context, const gchar* element_name, gpointer self, GError** error) {
	completion_provider_parser_end ((CompletionProvider*) self, context, element_name, error);
}


static void _completion_provider_parser_text_gmarkup_parser_text_func (GMarkupParseContext* context, const gchar* text, gsize text_len, gpointer self, GError** error) {
	completion_provider_parser_text ((CompletionProvider*) self, context, text, text_len, error);
}


static void completion_provider_load_data (CompletionProvider* self) {
	GeeHashMap* _tmp0_ = NULL;
	GeeHashMap* _tmp1_ = NULL;
	GFile* file = NULL;
	gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GFile* _tmp4_ = NULL;
	GFile* _tmp5_ = NULL;
	gchar* contents = NULL;
	GFile* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_COMMAND, (GBoxedCopyFunc) completion_provider_completion_command_dup, completion_provider_completion_command_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_commands);
	self->priv->_commands = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, COMPLETION_PROVIDER_TYPE_COMPLETION_CHOICE, (GBoxedCopyFunc) completion_provider_completion_choice_dup, completion_provider_completion_choice_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->_environments);
	self->priv->_environments = _tmp1_;
	_tmp2_ = g_build_filename (DATA_DIR, "completion.xml", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_file_new_for_path (_tmp3_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	file = _tmp5_;
	_tmp6_ = file;
	_tmp7_ = utils_load_file (_tmp6_);
	contents = _tmp7_;
	_tmp8_ = contents;
	if (_tmp8_ == NULL) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		return;
	}
	{
		GMarkupParser parser = {0};
		GMarkupParser _tmp9_ = {0};
		GMarkupParseContext* context = NULL;
		GMarkupParser _tmp10_ = {0};
		GMarkupParseContext* _tmp11_ = NULL;
		GMarkupParseContext* _tmp12_ = NULL;
		const gchar* _tmp13_ = NULL;
		_tmp9_.start_element = _completion_provider_parser_start_gmarkup_parser_start_element_func;
		_tmp9_.end_element = _completion_provider_parser_end_gmarkup_parser_end_element_func;
		_tmp9_.text = _completion_provider_parser_text_gmarkup_parser_text_func;
		_tmp9_.passthrough = NULL;
		_tmp9_.error = NULL;
		parser = _tmp9_;
		_tmp10_ = parser;
		_tmp11_ = g_markup_parse_context_new (&_tmp10_, 0, self, NULL);
		context = _tmp11_;
		_tmp12_ = context;
		_tmp13_ = contents;
		g_markup_parse_context_parse (_tmp12_, _tmp13_, (gssize) (-1), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_markup_parse_context_unref0 (context);
			goto __catch2_g_error;
		}
		self->priv->_proposals = g_list_sort (self->priv->_proposals, (GCompareFunc) completion_provider_compare_proposals);
		_g_markup_parse_context_unref0 (context);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp14_ = NULL;
		const gchar* _tmp15_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp14_ = e;
		_tmp15_ = _tmp14_->message;
		g_warning ("completion.vala:787: Impossible to load completion data: %s", _tmp15_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (contents);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (contents);
	_g_object_unref0 (file);
}


static void completion_provider_parser_start (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	static GQuark _tmp2_label3 = 0;
	static GQuark _tmp2_label4 = 0;
	static GQuark _tmp2_label5 = 0;
	static GQuark _tmp2_label6 = 0;
	static GQuark _tmp2_label7 = 0;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("commands")))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gchar** _tmp5_ = NULL;
				gint _tmp5__length1 = 0;
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_values;
				_tmp5__length1 = attr_values_length1;
				completion_provider_parser_add_command (self, _tmp4_, _tmp4__length1, _tmp5_, _tmp5__length1, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				gchar** _tmp6_ = NULL;
				gint _tmp6__length1 = 0;
				gchar** _tmp7_ = NULL;
				gint _tmp7__length1 = 0;
				_tmp6_ = attr_names;
				_tmp6__length1 = attr_names_length1;
				_tmp7_ = attr_values;
				_tmp7__length1 = attr_values_length1;
				completion_provider_parser_add_argument (self, _tmp6_, _tmp6__length1, _tmp7_, _tmp7__length1, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label3) ? _tmp2_label3 : (_tmp2_label3 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				gchar** _tmp8_ = NULL;
				gint _tmp8__length1 = 0;
				gchar** _tmp9_ = NULL;
				gint _tmp9__length1 = 0;
				_tmp8_ = attr_names;
				_tmp8__length1 = attr_names_length1;
				_tmp9_ = attr_values;
				_tmp9__length1 = attr_values_length1;
				completion_provider_parser_add_choice (self, _tmp8_, _tmp8__length1, _tmp9_, _tmp9__length1, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					if (_inner_error_->domain == G_MARKUP_ERROR) {
						g_propagate_error (error, _inner_error_);
						return;
					} else {
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label4) ? _tmp2_label4 : (_tmp2_label4 = g_quark_from_static_string ("insert")))) || (_tmp3_ == ((0 != _tmp2_label5) ? _tmp2_label5 : (_tmp2_label5 = g_quark_from_static_string ("insert_after"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label6) ? _tmp2_label6 : (_tmp2_label6 = g_quark_from_static_string ("placeholder")))) || (_tmp3_ == ((0 != _tmp2_label7) ? _tmp2_label7 : (_tmp2_label7 = g_quark_from_static_string ("component"))))) {
		switch (0) {
			default:
			{
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_ = NULL;
				gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				GError* _tmp15_ = NULL;
				GError* _tmp16_ = NULL;
				_tmp10_ = name;
				_tmp11_ = g_strconcat ("unknown element \"", _tmp10_, NULL);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strconcat (_tmp12_, "\"", NULL);
				_tmp14_ = _tmp13_;
				_tmp15_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ELEMENT, _tmp14_);
				_tmp16_ = _tmp15_;
				_g_free0 (_tmp14_);
				_g_free0 (_tmp12_);
				_inner_error_ = _tmp16_;
				if (_inner_error_->domain == G_MARKUP_ERROR) {
					g_propagate_error (error, _inner_error_);
					return;
				} else {
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
		}
	}
}


static void completion_provider_parser_add_command (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_command_destroy (&self->priv->_current_command);
	memset (&self->priv->_current_command, 0, sizeof (CompletionProviderCompletionCommand));
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				GQuark _tmp9_ = 0U;
				static GQuark _tmp8_label0 = 0;
				static GQuark _tmp8_label1 = 0;
				static GQuark _tmp8_label2 = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attr_num;
				_tmp3_ = attr_names;
				_tmp3__length1 = attr_names_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_num;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _tmp6_;
				_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							gchar** _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp11_ = 0;
							const gchar* _tmp12_ = NULL;
							gchar* _tmp13_ = NULL;
							_tmp10_ = attr_values;
							_tmp10__length1 = attr_values_length1;
							_tmp11_ = attr_num;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = g_strconcat ("\\", _tmp12_, NULL);
							_g_free0 (self->priv->_current_command.name);
							self->priv->_current_command.name = _tmp13_;
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("package")))) {
					switch (0) {
						default:
						{
							gchar** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp15_ = 0;
							const gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							_tmp14_ = attr_values;
							_tmp14__length1 = attr_values_length1;
							_tmp15_ = attr_num;
							_tmp16_ = _tmp14_[_tmp15_];
							_tmp17_ = g_strdup (_tmp16_);
							_g_free0 (self->priv->_current_command.package);
							self->priv->_current_command.package = _tmp17_;
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label2) ? _tmp8_label2 : (_tmp8_label2 = g_quark_from_static_string ("environment")))) {
					switch (0) {
						default:
						{
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp19_ = 0;
							const gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							GError* _tmp25_ = NULL;
							GError* _tmp26_ = NULL;
							_tmp18_ = attr_names;
							_tmp18__length1 = attr_names_length1;
							_tmp19_ = attr_num;
							_tmp20_ = _tmp18_[_tmp19_];
							_tmp21_ = g_strconcat ("unknown command attribute \"", _tmp20_, NULL);
							_tmp22_ = _tmp21_;
							_tmp23_ = g_strconcat (_tmp22_, "\"", NULL);
							_tmp24_ = _tmp23_;
							_tmp25_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp24_);
							_tmp26_ = _tmp25_;
							_g_free0 (_tmp24_);
							_g_free0 (_tmp22_);
							_inner_error_ = _tmp26_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void completion_provider_parser_add_argument (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
	memset (&self->priv->_current_arg, 0, sizeof (CompletionProviderCompletionArgument));
	self->priv->_current_arg.optional = FALSE;
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				GQuark _tmp9_ = 0U;
				static GQuark _tmp8_label0 = 0;
				static GQuark _tmp8_label1 = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attr_num;
				_tmp3_ = attr_names;
				_tmp3__length1 = attr_names_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_num;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _tmp6_;
				_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("label")))) {
					switch (0) {
						default:
						{
							gchar** _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp11_ = 0;
							const gchar* _tmp12_ = NULL;
							gchar* _tmp13_ = NULL;
							_tmp10_ = attr_values;
							_tmp10__length1 = attr_values_length1;
							_tmp11_ = attr_num;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = g_strdup (_tmp12_);
							_g_free0 (self->priv->_current_arg.label);
							self->priv->_current_arg.label = _tmp13_;
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("type")))) {
					switch (0) {
						default:
						{
							gchar** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp15_ = 0;
							const gchar* _tmp16_ = NULL;
							_tmp14_ = attr_values;
							_tmp14__length1 = attr_values_length1;
							_tmp15_ = attr_num;
							_tmp16_ = _tmp14_[_tmp15_];
							self->priv->_current_arg.optional = g_strcmp0 (_tmp16_, "optional") == 0;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp17_ = NULL;
							gint _tmp17__length1 = 0;
							gint _tmp18_ = 0;
							const gchar* _tmp19_ = NULL;
							gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							GError* _tmp24_ = NULL;
							GError* _tmp25_ = NULL;
							_tmp17_ = attr_names;
							_tmp17__length1 = attr_names_length1;
							_tmp18_ = attr_num;
							_tmp19_ = _tmp17_[_tmp18_];
							_tmp20_ = g_strconcat ("unknown argument attribute \"", _tmp19_, NULL);
							_tmp21_ = _tmp20_;
							_tmp22_ = g_strconcat (_tmp21_, "\"", NULL);
							_tmp23_ = _tmp22_;
							_tmp24_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp23_);
							_tmp25_ = _tmp24_;
							_g_free0 (_tmp23_);
							_g_free0 (_tmp21_);
							_inner_error_ = _tmp25_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void completion_provider_parser_add_choice (CompletionProvider* self, gchar** attr_names, int attr_names_length1, gchar** attr_values, int attr_values_length1, GError** error) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
	memset (&self->priv->_current_choice, 0, sizeof (CompletionProviderCompletionChoice));
	{
		gint attr_num = 0;
		attr_num = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				gchar** _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				gchar** _tmp4_ = NULL;
				gint _tmp4__length1 = 0;
				gint _tmp5_ = 0;
				const gchar* _tmp6_ = NULL;
				const gchar* _tmp7_ = NULL;
				GQuark _tmp9_ = 0U;
				static GQuark _tmp8_label0 = 0;
				static GQuark _tmp8_label1 = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = attr_num;
					attr_num = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = attr_num;
				_tmp3_ = attr_names;
				_tmp3__length1 = attr_names_length1;
				if (!(_tmp2_ < _tmp3__length1)) {
					break;
				}
				_tmp4_ = attr_names;
				_tmp4__length1 = attr_names_length1;
				_tmp5_ = attr_num;
				_tmp6_ = _tmp4_[_tmp5_];
				_tmp7_ = _tmp6_;
				_tmp9_ = (NULL == _tmp7_) ? 0 : g_quark_from_string (_tmp7_);
				if (_tmp9_ == ((0 != _tmp8_label0) ? _tmp8_label0 : (_tmp8_label0 = g_quark_from_static_string ("name")))) {
					switch (0) {
						default:
						{
							gchar** _tmp10_ = NULL;
							gint _tmp10__length1 = 0;
							gint _tmp11_ = 0;
							const gchar* _tmp12_ = NULL;
							gchar* _tmp13_ = NULL;
							_tmp10_ = attr_values;
							_tmp10__length1 = attr_values_length1;
							_tmp11_ = attr_num;
							_tmp12_ = _tmp10_[_tmp11_];
							_tmp13_ = g_strdup (_tmp12_);
							_g_free0 (self->priv->_current_choice.name);
							self->priv->_current_choice.name = _tmp13_;
							break;
						}
					}
				} else if (_tmp9_ == ((0 != _tmp8_label1) ? _tmp8_label1 : (_tmp8_label1 = g_quark_from_static_string ("package")))) {
					switch (0) {
						default:
						{
							gchar** _tmp14_ = NULL;
							gint _tmp14__length1 = 0;
							gint _tmp15_ = 0;
							const gchar* _tmp16_ = NULL;
							gchar* _tmp17_ = NULL;
							_tmp14_ = attr_values;
							_tmp14__length1 = attr_values_length1;
							_tmp15_ = attr_num;
							_tmp16_ = _tmp14_[_tmp15_];
							_tmp17_ = g_strdup (_tmp16_);
							_g_free0 (self->priv->_current_choice.package);
							self->priv->_current_choice.package = _tmp17_;
							break;
						}
					}
				} else {
					switch (0) {
						default:
						{
							gchar** _tmp18_ = NULL;
							gint _tmp18__length1 = 0;
							gint _tmp19_ = 0;
							const gchar* _tmp20_ = NULL;
							gchar* _tmp21_ = NULL;
							gchar* _tmp22_ = NULL;
							gchar* _tmp23_ = NULL;
							gchar* _tmp24_ = NULL;
							GError* _tmp25_ = NULL;
							GError* _tmp26_ = NULL;
							_tmp18_ = attr_names;
							_tmp18__length1 = attr_names_length1;
							_tmp19_ = attr_num;
							_tmp20_ = _tmp18_[_tmp19_];
							_tmp21_ = g_strconcat ("unknown choice attribute \"", _tmp20_, NULL);
							_tmp22_ = _tmp21_;
							_tmp23_ = g_strconcat (_tmp22_, "\"", NULL);
							_tmp24_ = _tmp23_;
							_tmp25_ = g_error_new_literal (G_MARKUP_ERROR, G_MARKUP_ERROR_UNKNOWN_ATTRIBUTE, _tmp24_);
							_tmp26_ = _tmp25_;
							_g_free0 (_tmp24_);
							_g_free0 (_tmp22_);
							_inner_error_ = _tmp26_;
							if (_inner_error_->domain == G_MARKUP_ERROR) {
								g_propagate_error (error, _inner_error_);
								return;
							} else {
								g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
								g_clear_error (&_inner_error_);
								return;
							}
						}
					}
				}
			}
		}
	}
}


static void _vala_array_add2 (CompletionProviderCompletionArgument** array, int* length, int* size, const CompletionProviderCompletionArgument* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionArgument, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void _vala_array_add3 (CompletionProviderCompletionChoice** array, int* length, int* size, const CompletionProviderCompletionChoice* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (CompletionProviderCompletionChoice, *array, *size);
	}
	(*array)[(*length)++] = *value;
}


static void completion_provider_parser_end (CompletionProvider* self, GMarkupParseContext* context, const gchar* name, GError** error) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = name;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("command")))) {
		switch (0) {
			default:
			{
				GdkPixbuf* _tmp4_ = NULL;
				CompletionProviderCompletionCommand _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				GdkPixbuf* pixbuf = NULL;
				GdkPixbuf* _tmp9_ = NULL;
				GtkSourceCompletionItem* item = NULL;
				CompletionProviderCompletionCommand _tmp10_ = {0};
				const gchar* _tmp11_ = NULL;
				CompletionProviderCompletionCommand _tmp12_ = {0};
				gchar* _tmp13_ = NULL;
				gchar* _tmp14_ = NULL;
				GdkPixbuf* _tmp15_ = NULL;
				CompletionProviderCompletionCommand _tmp16_ = {0};
				gchar* _tmp17_ = NULL;
				gchar* _tmp18_ = NULL;
				GtkSourceCompletionItem* _tmp19_ = NULL;
				GtkSourceCompletionItem* _tmp20_ = NULL;
				GtkSourceCompletionItem* _tmp21_ = NULL;
				GtkSourceCompletionItem* _tmp22_ = NULL;
				CompletionProviderCompletionCommand _tmp23_ = {0};
				CompletionProviderCompletionArgument* _tmp24_ = NULL;
				gint _tmp24__length1 = 0;
				_tmp5_ = self->priv->_current_command;
				_tmp6_ = _tmp5_.package;
				if (_tmp6_ != NULL) {
					GdkPixbuf* _tmp7_ = NULL;
					_tmp7_ = self->priv->_icon_package_required;
					_tmp4_ = _tmp7_;
				} else {
					GdkPixbuf* _tmp8_ = NULL;
					_tmp8_ = self->priv->_icon_cmd;
					_tmp4_ = _tmp8_;
				}
				_tmp9_ = _g_object_ref0 (_tmp4_);
				pixbuf = _tmp9_;
				_tmp10_ = self->priv->_current_command;
				_tmp11_ = _tmp10_.name;
				_tmp12_ = self->priv->_current_command;
				_tmp13_ = completion_provider_get_command_text_to_insert (self, &_tmp12_);
				_tmp14_ = _tmp13_;
				_tmp15_ = pixbuf;
				_tmp16_ = self->priv->_current_command;
				_tmp17_ = completion_provider_get_command_info (self, &_tmp16_, -1);
				_tmp18_ = _tmp17_;
				_tmp19_ = gtk_source_completion_item_new (_tmp11_, _tmp14_, _tmp15_, _tmp18_);
				_tmp20_ = _tmp19_;
				_g_free0 (_tmp18_);
				_g_free0 (_tmp14_);
				item = _tmp20_;
				_tmp21_ = item;
				_tmp22_ = _g_object_ref0 (_tmp21_);
				self->priv->_proposals = g_list_prepend (self->priv->_proposals, _tmp22_);
				_tmp23_ = self->priv->_current_command;
				_tmp24_ = _tmp23_.args;
				_tmp24__length1 = _tmp23_.args_length1;
				if (0 < _tmp24__length1) {
					GeeHashMap* _tmp25_ = NULL;
					CompletionProviderCompletionCommand _tmp26_ = {0};
					const gchar* _tmp27_ = NULL;
					CompletionProviderCompletionCommand _tmp28_ = {0};
					_tmp25_ = self->priv->_commands;
					_tmp26_ = self->priv->_current_command;
					_tmp27_ = _tmp26_.name;
					_tmp28_ = self->priv->_current_command;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp25_, _tmp27_, &_tmp28_);
				}
				_g_object_unref0 (item);
				_g_object_unref0 (pixbuf);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("argument")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionArgument* _tmp29_ = NULL;
				gint _tmp29__length1 = 0;
				CompletionProviderCompletionArgument _tmp30_ = {0};
				CompletionProviderCompletionArgument _tmp31_ = {0};
				_tmp29_ = self->priv->_current_command.args;
				_tmp29__length1 = self->priv->_current_command.args_length1;
				_tmp30_ = self->priv->_current_arg;
				completion_provider_completion_argument_copy (&_tmp30_, &_tmp31_);
				_vala_array_add2 (&self->priv->_current_command.args, &self->priv->_current_command.args_length1, &self->priv->_current_command._args_size_, &_tmp31_);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("choice")))) {
		switch (0) {
			default:
			{
				CompletionProviderCompletionChoice* _tmp32_ = NULL;
				gint _tmp32__length1 = 0;
				CompletionProviderCompletionChoice _tmp33_ = {0};
				CompletionProviderCompletionChoice _tmp34_ = {0};
				gboolean _tmp35_ = FALSE;
				CompletionProviderCompletionChoice _tmp36_ = {0};
				const gchar* _tmp37_ = NULL;
				_tmp32_ = self->priv->_current_arg.choices;
				_tmp32__length1 = self->priv->_current_arg.choices_length1;
				_tmp33_ = self->priv->_current_choice;
				completion_provider_completion_choice_copy (&_tmp33_, &_tmp34_);
				_vala_array_add3 (&self->priv->_current_arg.choices, &self->priv->_current_arg.choices_length1, &self->priv->_current_arg._choices_size_, &_tmp34_);
				_tmp36_ = self->priv->_current_choice;
				_tmp37_ = _tmp36_.insert;
				if (_tmp37_ != NULL) {
					_tmp35_ = TRUE;
				} else {
					CompletionProviderCompletionChoice _tmp38_ = {0};
					const gchar* _tmp39_ = NULL;
					_tmp38_ = self->priv->_current_choice;
					_tmp39_ = _tmp38_.insert_after;
					_tmp35_ = _tmp39_ != NULL;
				}
				if (_tmp35_) {
					GeeHashMap* _tmp40_ = NULL;
					CompletionProviderCompletionChoice _tmp41_ = {0};
					const gchar* _tmp42_ = NULL;
					CompletionProviderCompletionChoice _tmp43_ = {0};
					_tmp40_ = self->priv->_environments;
					_tmp41_ = self->priv->_current_choice;
					_tmp42_ = _tmp41_.name;
					_tmp43_ = self->priv->_current_choice;
					gee_abstract_map_set ((GeeAbstractMap*) _tmp40_, _tmp42_, &_tmp43_);
				}
				break;
			}
		}
	}
}


static void completion_provider_parser_text (CompletionProvider* self, GMarkupParseContext* context, const gchar* text, gsize text_len, GError** error) {
	GMarkupParseContext* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	GQuark _tmp4_ = 0U;
	static GQuark _tmp3_label0 = 0;
	static GQuark _tmp3_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (text != NULL);
	_tmp0_ = context;
	_tmp1_ = g_markup_parse_context_get_element (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if (_tmp4_ == ((0 != _tmp3_label0) ? _tmp3_label0 : (_tmp3_label0 = g_quark_from_static_string ("insert")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_ = NULL;
				_tmp5_ = text;
				_tmp6_ = g_strdup (_tmp5_);
				_g_free0 (self->priv->_current_choice.insert);
				self->priv->_current_choice.insert = _tmp6_;
				break;
			}
		}
	} else if (_tmp4_ == ((0 != _tmp3_label1) ? _tmp3_label1 : (_tmp3_label1 = g_quark_from_static_string ("insert_after")))) {
		switch (0) {
			default:
			{
				const gchar* _tmp7_ = NULL;
				gchar* _tmp8_ = NULL;
				_tmp7_ = text;
				_tmp8_ = g_strdup (_tmp7_);
				_g_free0 (self->priv->_current_choice.insert_after);
				self->priv->_current_choice.insert_after = _tmp8_;
				break;
			}
		}
	}
}


static void _vala_CompletionProviderCompletionArgument_array_free (CompletionProviderCompletionArgument* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_argument_destroy (&array[i]);
		}
	}
	g_free (array);
}


static CompletionProviderCompletionArgument* _vala_array_dup1 (CompletionProviderCompletionArgument* self, int length) {
	CompletionProviderCompletionArgument* result;
	int i;
	result = g_new0 (CompletionProviderCompletionArgument, length);
	for (i = 0; i < length; i++) {
		CompletionProviderCompletionArgument _tmp0_ = {0};
		completion_provider_completion_argument_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void completion_provider_completion_command_copy (const CompletionProviderCompletionCommand* self, CompletionProviderCompletionCommand* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	CompletionProviderCompletionArgument* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	CompletionProviderCompletionArgument* _tmp5_ = NULL;
	gint _tmp5__length1 = 0;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).args;
	_tmp4__length1 = (*self).args_length1;
	_tmp5_ = (_tmp4_ != NULL) ? _vala_array_dup1 (_tmp4_, _tmp4__length1) : ((gpointer) _tmp4_);
	_tmp5__length1 = _tmp4__length1;
	(*dest).args = (_vala_CompletionProviderCompletionArgument_array_free ((*dest).args, (*dest).args_length1), NULL);
	(*dest).args = _tmp5_;
	(*dest).args_length1 = _tmp5__length1;
	(*dest)._args_size_ = (*dest).args_length1;
}


static void completion_provider_completion_command_destroy (CompletionProviderCompletionCommand* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	(*self).args = (_vala_CompletionProviderCompletionArgument_array_free ((*self).args, (*self).args_length1), NULL);
}


static CompletionProviderCompletionCommand* completion_provider_completion_command_dup (const CompletionProviderCompletionCommand* self) {
	CompletionProviderCompletionCommand* dup;
	dup = g_new0 (CompletionProviderCompletionCommand, 1);
	completion_provider_completion_command_copy (self, dup);
	return dup;
}


static void completion_provider_completion_command_free (CompletionProviderCompletionCommand* self) {
	completion_provider_completion_command_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_command_get_type (void) {
	static volatile gsize completion_provider_completion_command_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_command_type_id__volatile)) {
		GType completion_provider_completion_command_type_id;
		completion_provider_completion_command_type_id = g_boxed_type_register_static ("CompletionProviderCompletionCommand", (GBoxedCopyFunc) completion_provider_completion_command_dup, (GBoxedFreeFunc) completion_provider_completion_command_free);
		g_once_init_leave (&completion_provider_completion_command_type_id__volatile, completion_provider_completion_command_type_id);
	}
	return completion_provider_completion_command_type_id__volatile;
}


static void _vala_CompletionProviderCompletionChoice_array_free (CompletionProviderCompletionChoice* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			completion_provider_completion_choice_destroy (&array[i]);
		}
	}
	g_free (array);
}


static CompletionProviderCompletionChoice* _vala_array_dup2 (CompletionProviderCompletionChoice* self, int length) {
	CompletionProviderCompletionChoice* result;
	int i;
	result = g_new0 (CompletionProviderCompletionChoice, length);
	for (i = 0; i < length; i++) {
		CompletionProviderCompletionChoice _tmp0_ = {0};
		completion_provider_completion_choice_copy (&self[i], &_tmp0_);
		result[i] = _tmp0_;
	}
	return result;
}


static void completion_provider_completion_argument_copy (const CompletionProviderCompletionArgument* self, CompletionProviderCompletionArgument* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	CompletionProviderCompletionChoice* _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	CompletionProviderCompletionChoice* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	_tmp0_ = (*self).label;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).label);
	(*dest).label = _tmp1_;
	_tmp2_ = (*self).optional;
	(*dest).optional = _tmp2_;
	_tmp3_ = (*self).choices;
	_tmp3__length1 = (*self).choices_length1;
	_tmp4_ = (_tmp3_ != NULL) ? _vala_array_dup2 (_tmp3_, _tmp3__length1) : ((gpointer) _tmp3_);
	_tmp4__length1 = _tmp3__length1;
	(*dest).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*dest).choices, (*dest).choices_length1), NULL);
	(*dest).choices = _tmp4_;
	(*dest).choices_length1 = _tmp4__length1;
	(*dest)._choices_size_ = (*dest).choices_length1;
}


static void completion_provider_completion_argument_destroy (CompletionProviderCompletionArgument* self) {
	_g_free0 ((*self).label);
	(*self).choices = (_vala_CompletionProviderCompletionChoice_array_free ((*self).choices, (*self).choices_length1), NULL);
}


static CompletionProviderCompletionArgument* completion_provider_completion_argument_dup (const CompletionProviderCompletionArgument* self) {
	CompletionProviderCompletionArgument* dup;
	dup = g_new0 (CompletionProviderCompletionArgument, 1);
	completion_provider_completion_argument_copy (self, dup);
	return dup;
}


static void completion_provider_completion_argument_free (CompletionProviderCompletionArgument* self) {
	completion_provider_completion_argument_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_argument_get_type (void) {
	static volatile gsize completion_provider_completion_argument_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_argument_type_id__volatile)) {
		GType completion_provider_completion_argument_type_id;
		completion_provider_completion_argument_type_id = g_boxed_type_register_static ("CompletionProviderCompletionArgument", (GBoxedCopyFunc) completion_provider_completion_argument_dup, (GBoxedFreeFunc) completion_provider_completion_argument_free);
		g_once_init_leave (&completion_provider_completion_argument_type_id__volatile, completion_provider_completion_argument_type_id);
	}
	return completion_provider_completion_argument_type_id__volatile;
}


static void completion_provider_completion_choice_copy (const CompletionProviderCompletionChoice* self, CompletionProviderCompletionChoice* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	_tmp2_ = (*self).package;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).package);
	(*dest).package = _tmp3_;
	_tmp4_ = (*self).insert;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).insert);
	(*dest).insert = _tmp5_;
	_tmp6_ = (*self).insert_after;
	_tmp7_ = g_strdup (_tmp6_);
	_g_free0 ((*dest).insert_after);
	(*dest).insert_after = _tmp7_;
}


static void completion_provider_completion_choice_destroy (CompletionProviderCompletionChoice* self) {
	_g_free0 ((*self).name);
	_g_free0 ((*self).package);
	_g_free0 ((*self).insert);
	_g_free0 ((*self).insert_after);
}


static CompletionProviderCompletionChoice* completion_provider_completion_choice_dup (const CompletionProviderCompletionChoice* self) {
	CompletionProviderCompletionChoice* dup;
	dup = g_new0 (CompletionProviderCompletionChoice, 1);
	completion_provider_completion_choice_copy (self, dup);
	return dup;
}


static void completion_provider_completion_choice_free (CompletionProviderCompletionChoice* self) {
	completion_provider_completion_choice_destroy (self);
	g_free (self);
}


static GType completion_provider_completion_choice_get_type (void) {
	static volatile gsize completion_provider_completion_choice_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_completion_choice_type_id__volatile)) {
		GType completion_provider_completion_choice_type_id;
		completion_provider_completion_choice_type_id = g_boxed_type_register_static ("CompletionProviderCompletionChoice", (GBoxedCopyFunc) completion_provider_completion_choice_dup, (GBoxedFreeFunc) completion_provider_completion_choice_free);
		g_once_init_leave (&completion_provider_completion_choice_type_id__volatile, completion_provider_completion_choice_type_id);
	}
	return completion_provider_completion_choice_type_id__volatile;
}


static void completion_provider_argument_context_copy (const CompletionProviderArgumentContext* self, CompletionProviderArgumentContext* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	GeeArrayList* _tmp4_ = NULL;
	GeeArrayList* _tmp5_ = NULL;
	_tmp0_ = (*self).cmd_name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).cmd_name);
	(*dest).cmd_name = _tmp1_;
	_tmp2_ = (*self).arg_contents;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).arg_contents);
	(*dest).arg_contents = _tmp3_;
	_tmp4_ = (*self).args_types;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 ((*dest).args_types);
	(*dest).args_types = _tmp5_;
}


static void completion_provider_argument_context_destroy (CompletionProviderArgumentContext* self) {
	_g_free0 ((*self).cmd_name);
	_g_free0 ((*self).arg_contents);
	_g_object_unref0 ((*self).args_types);
}


static CompletionProviderArgumentContext* completion_provider_argument_context_dup (const CompletionProviderArgumentContext* self) {
	CompletionProviderArgumentContext* dup;
	dup = g_new0 (CompletionProviderArgumentContext, 1);
	completion_provider_argument_context_copy (self, dup);
	return dup;
}


static void completion_provider_argument_context_free (CompletionProviderArgumentContext* self) {
	completion_provider_argument_context_destroy (self);
	g_free (self);
}


static GType completion_provider_argument_context_get_type (void) {
	static volatile gsize completion_provider_argument_context_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_argument_context_type_id__volatile)) {
		GType completion_provider_argument_context_type_id;
		completion_provider_argument_context_type_id = g_boxed_type_register_static ("CompletionProviderArgumentContext", (GBoxedCopyFunc) completion_provider_argument_context_dup, (GBoxedFreeFunc) completion_provider_argument_context_free);
		g_once_init_leave (&completion_provider_argument_context_type_id__volatile, completion_provider_argument_context_type_id);
	}
	return completion_provider_argument_context_type_id__volatile;
}


static void completion_provider_class_init (CompletionProviderClass * klass) {
	completion_provider_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (CompletionProviderPrivate));
	G_OBJECT_CLASS (klass)->finalize = completion_provider_finalize;
}


static void completion_provider_gtk_source_completion_provider_interface_init (GtkSourceCompletionProviderIface * iface) {
	completion_provider_gtk_source_completion_provider_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_name = (gchar* (*)(GtkSourceCompletionProvider*)) completion_provider_real_get_name;
	iface->get_activation = (GtkSourceCompletionActivation (*)(GtkSourceCompletionProvider*)) completion_provider_real_get_activation;
	iface->match = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_match;
	iface->get_start_iter = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_get_start_iter;
	iface->populate = (void (*)(GtkSourceCompletionProvider*, GtkSourceCompletionContext*)) completion_provider_real_populate;
	iface->activate_proposal = (gboolean (*)(GtkSourceCompletionProvider*, GtkSourceCompletionProposal*, GtkTextIter*)) completion_provider_real_activate_proposal;
}


static void completion_provider_instance_init (CompletionProvider * self) {
	self->priv = COMPLETION_PROVIDER_GET_PRIVATE (self);
	self->priv->_calltip_window = NULL;
	self->priv->_calltip_window_label = NULL;
}


static void completion_provider_finalize (GObject* obj) {
	CompletionProvider * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETION_PROVIDER, CompletionProvider);
	_g_object_unref0 (self->priv->_settings);
	__g_list_free__g_object_unref0_0 (self->priv->_proposals);
	_g_object_unref0 (self->priv->_commands);
	_g_object_unref0 (self->priv->_environments);
	completion_provider_completion_command_destroy (&self->priv->_current_command);
	completion_provider_completion_argument_destroy (&self->priv->_current_arg);
	completion_provider_completion_choice_destroy (&self->priv->_current_choice);
	_g_object_unref0 (self->priv->_icon_cmd);
	_g_object_unref0 (self->priv->_icon_choice);
	_g_object_unref0 (self->priv->_icon_package_required);
	_g_object_unref0 (self->priv->_calltip_window);
	_g_object_unref0 (self->priv->_calltip_window_label);
	G_OBJECT_CLASS (completion_provider_parent_class)->finalize (obj);
}


GType completion_provider_get_type (void) {
	static volatile gsize completion_provider_type_id__volatile = 0;
	if (g_once_init_enter (&completion_provider_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (CompletionProviderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completion_provider_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletionProvider), 0, (GInstanceInitFunc) completion_provider_instance_init, NULL };
		static const GInterfaceInfo gtk_source_completion_provider_info = { (GInterfaceInitFunc) completion_provider_gtk_source_completion_provider_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType completion_provider_type_id;
		completion_provider_type_id = g_type_register_static (G_TYPE_OBJECT, "CompletionProvider", &g_define_type_info, 0);
		g_type_add_interface_static (completion_provider_type_id, gtk_source_completion_provider_get_type (), &gtk_source_completion_provider_info);
		g_once_init_leave (&completion_provider_type_id__volatile, completion_provider_type_id);
	}
	return completion_provider_type_id__volatile;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



