/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.stripes.controller;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletContext;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ForwardResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.config.Configuration;
import net.sourceforge.stripes.controller.AnnotatedClassActionResolver;
import net.sourceforge.stripes.controller.DefaultViewActionBean;
import net.sourceforge.stripes.controller.StripesFilter;
import net.sourceforge.stripes.exception.StripesServletException;
import net.sourceforge.stripes.util.Literal;
import net.sourceforge.stripes.util.Log;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NameBasedActionResolver
extends AnnotatedClassActionResolver {
    public static final Set<String> BASE_PACKAGES = Collections.unmodifiableSet(Literal.set("web", "www", "stripes", "action"));
    public static final String DEFAULT_BINDING_SUFFIX = ".action";
    public static final List<String> DEFAULT_ACTION_BEAN_SUFFIXES = Collections.unmodifiableList(Literal.list("Bean", "Action"));
    private static final Log log = Log.getInstance(NameBasedActionResolver.class);

    @Override
    public void init(Configuration configuration) throws Exception {
        super.init(configuration);
        this.addActionBean(DefaultViewActionBean.class);
    }

    @Override
    public String getUrlBinding(Class<? extends ActionBean> clazz) {
        String binding = super.getUrlBinding(clazz);
        if (binding == null && !Modifier.isAbstract(clazz.getModifiers())) {
            binding = this.getUrlBinding(clazz.getName());
        }
        return binding;
    }

    protected String getUrlBinding(String name) {
        for (String base : this.getBasePackages()) {
            int i = name.indexOf("." + base + ".");
            if (i != -1) {
                name = name.substring(i + base.length() + 1);
                continue;
            }
            if (!name.startsWith(base + ".")) continue;
            name = name.substring(base.length());
        }
        for (String suffix : this.getActionBeanSuffixes()) {
            if (!name.endsWith(suffix)) continue;
            name = name.substring(0, name.length() - suffix.length());
        }
        if (!(name = name.replace('.', '/')).startsWith("/")) {
            name = "/" + name;
        }
        name = name + this.getBindingSuffix();
        return name;
    }

    protected Set<String> getBasePackages() {
        return BASE_PACKAGES;
    }

    protected String getBindingSuffix() {
        return DEFAULT_BINDING_SUFFIX;
    }

    protected List<String> getActionBeanSuffixes() {
        return DEFAULT_ACTION_BEAN_SUFFIXES;
    }

    @Override
    public String getHandledEvent(Method handler) {
        String name = super.getHandledEvent(handler);
        if (name == null && !Modifier.isAbstract(handler.getModifiers()) && Resolution.class.isAssignableFrom(handler.getReturnType()) && handler.getParameterTypes().length == 0) {
            name = handler.getName();
        }
        return name;
    }

    @Override
    public ActionBean getActionBean(ActionBeanContext context, String urlBinding) throws StripesServletException {
        try {
            return super.getActionBean(context, urlBinding);
        }
        catch (StripesServletException sse) {
            ActionBean bean = this.handleActionBeanNotFound(context, urlBinding);
            if (bean != null) {
                this.setActionBeanContext(bean, context);
                this.assertGetContextWorks(bean);
                return bean;
            }
            throw sse;
        }
    }

    protected ActionBean handleActionBeanNotFound(ActionBeanContext context, String urlBinding) {
        DefaultViewActionBean bean = null;
        Resolution view = this.findView(urlBinding);
        if (view != null) {
            log.debug("Could not find an ActionBean bound to '", urlBinding, "', but found a view ", "at '", view, "'. Forwarding the user there instead.");
            bean = new DefaultViewActionBean(view);
        }
        return bean;
    }

    protected Resolution findView(String urlBinding) {
        List<String> attempts = this.getFindViewAttempts(urlBinding);
        ServletContext ctx = StripesFilter.getConfiguration().getBootstrapPropertyResolver().getFilterConfig().getServletContext();
        for (String jsp : attempts) {
            try {
                if (ctx.getResource(jsp) == null) continue;
                return new ForwardResolution(jsp);
            }
            catch (MalformedURLException mue) {
            }
        }
        return null;
    }

    protected List<String> getFindViewAttempts(String urlBinding) {
        String path;
        ArrayList<String> attempts = new ArrayList<String>(3);
        int lastPeriod = urlBinding.lastIndexOf(46);
        String name = lastPeriod >= (path = urlBinding.substring(0, urlBinding.lastIndexOf("/") + 1)).length() ? urlBinding.substring(path.length(), lastPeriod) : urlBinding.substring(path.length());
        attempts.add(path + name + ".jsp");
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        attempts.add(path + name + ".jsp");
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (Character.isUpperCase(ch)) {
                builder.append("_");
                builder.append(Character.toLowerCase(ch));
                continue;
            }
            builder.append(ch);
        }
        attempts.add(path + builder.toString() + ".jsp");
        return attempts;
    }
}

