/*
 * Decompiled with CFR 0.152.
 */
package org.testng.internal;

import java.lang.reflect.Method;
import java.util.Comparator;
import org.testng.ITestClass;
import org.testng.ITestNGMethod;
import org.testng.internal.BaseTestMethod;
import org.testng.internal.NoOpTestClass;
import org.testng.internal.annotations.AnnotationHelper;
import org.testng.internal.annotations.IAnnotationFinder;
import org.testng.internal.annotations.ITest;

public class TestNGMethod
extends BaseTestMethod {
    private int m_threadPoolSize = 0;
    private int m_invocationCount = 1;
    private int m_successPercentage = 100;
    private long m_timeOut = 0L;
    public static final Comparator<ITestNGMethod> SORT_BY_CLASS = new Comparator<ITestNGMethod>(){

        @Override
        public int compare(ITestNGMethod o1, ITestNGMethod o2) {
            String c1 = o1.getTestClass().getName();
            String c2 = o2.getTestClass().getName();
            return c1.compareTo(c2);
        }
    };

    public TestNGMethod(Method method, IAnnotationFinder finder) {
        this(method, finder, true);
    }

    private TestNGMethod(Method method, IAnnotationFinder finder, boolean initialize) {
        super(method, finder);
        if (initialize) {
            this.init();
        }
    }

    public long getTimeOut() {
        return this.m_timeOut;
    }

    public int getInvocationCount() {
        return this.m_invocationCount;
    }

    public int getSuccessPercentage() {
        return this.m_successPercentage;
    }

    public boolean isTest() {
        return true;
    }

    private void ppp(String s) {
        System.out.println("[TestNGMethod] " + s);
    }

    private void init() {
        ITest testAnnotation = AnnotationHelper.findTest(this.getAnnotationFinder(), this.m_method);
        if (testAnnotation == null) {
            testAnnotation = AnnotationHelper.findTest(this.getAnnotationFinder(), this.m_method.getDeclaringClass());
        }
        if (null != testAnnotation) {
            this.m_timeOut = testAnnotation.getTimeOut();
            this.m_successPercentage = testAnnotation.getSuccessPercentage();
            this.setInvocationCount(testAnnotation.getInvocationCount());
            this.setThreadPoolSize(testAnnotation.getThreadPoolSize());
            this.setAlwaysRun(testAnnotation.getAlwaysRun());
            this.setDescription(testAnnotation.getDescription());
            this.setRetryAnalyzer(testAnnotation.getRetryAnalyzer());
            this.setSkipFailedInvocations(testAnnotation.skipFailedInvocations());
        }
        this.initGroups(ITest.class);
    }

    public int getThreadPoolSize() {
        return this.m_threadPoolSize;
    }

    public void setThreadPoolSize(int threadPoolSize) {
        this.m_threadPoolSize = threadPoolSize;
    }

    public void setInvocationCount(int counter) {
        this.m_invocationCount = counter;
    }

    public TestNGMethod clone() {
        TestNGMethod clone = new TestNGMethod(this.getMethod(), this.getAnnotationFinder(), false);
        ITestClass tc = this.getTestClass();
        NoOpTestClass testClass = new NoOpTestClass(tc);
        testClass.setBeforeTestMethods(this.clone(tc.getBeforeTestMethods()));
        testClass.setAfterTestMethod(this.clone(tc.getAfterTestMethods()));
        clone.m_testClass = testClass;
        clone.setDate(this.getDate());
        clone.setGroups(this.getGroups());
        clone.setGroupsDependedUpon(this.getGroupsDependedUpon());
        clone.setMethodsDependedUpon(this.getMethodsDependedUpon());
        clone.setAlwaysRun(this.isAlwaysRun());
        clone.m_beforeGroups = this.getBeforeGroups();
        clone.m_afterGroups = this.getAfterGroups();
        clone.m_currentInvocationCount = this.m_currentInvocationCount;
        clone.setMissingGroup(this.getMissingGroup());
        clone.setThreadPoolSize(this.getThreadPoolSize());
        clone.setDescription(this.getDescription());
        clone.setParameterInvocationCount(this.getParameterInvocationCount());
        clone.setInvocationCount(this.getInvocationCount());
        clone.m_successPercentage = this.getSuccessPercentage();
        clone.m_timeOut = this.getTimeOut();
        clone.setRetryAnalyzer(this.getRetryAnalyzer());
        clone.setSkipFailedInvocations(this.skipFailedInvocations());
        return clone;
    }

    private ITestNGMethod[] clone(ITestNGMethod[] sources) {
        ITestNGMethod[] clones = new ITestNGMethod[sources.length];
        for (int i = 0; i < sources.length; ++i) {
            clones[i] = sources[i].clone();
        }
        return clones;
    }
}

