/* Copyright 2017-present Samsung Electronics Co., Ltd. and other contributors
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef IOTJS_STRING_CONSTANTS_H
#define IOTJS_STRING_CONSTANTS_H

#define IOTJS_MAGIC_STRING_0 "0"
#define IOTJS_MAGIC_STRING_1 "1"
#define IOTJS_MAGIC_STRING_2 "2"
#define IOTJS_MAGIC_STRING_3 "3"
#define IOTJS_MAGIC_STRING_ADC "Adc"
#define IOTJS_MAGIC_STRING_ADDMEMBERSHIP "addMembership"
#define IOTJS_MAGIC_STRING_ADDRESS "address"
#define IOTJS_MAGIC_STRING_ARCH "arch"
#define IOTJS_MAGIC_STRING_ARGV "argv"
#define IOTJS_MAGIC_STRING_BAUDRATE "baudRate"
#define IOTJS_MAGIC_STRING_BIND "bind"
#define IOTJS_MAGIC_STRING_BINDCONTROL "bindControl"
#define IOTJS_MAGIC_STRING_BINDING "binding"
#define IOTJS_MAGIC_STRING_BINDRAW "bindRaw"
#define IOTJS_MAGIC_STRING_BINDUSER "bindUser"
#define IOTJS_MAGIC_STRING_BITORDER "bitOrder"
#define IOTJS_MAGIC_STRING_BITORDER_U "BITORDER"
#define IOTJS_MAGIC_STRING_BITSPERWORD "bitsPerWord"
#define IOTJS_MAGIC_STRING_BOARD "board"
#define IOTJS_MAGIC_STRING_BOTH_U "BOTH"
#define IOTJS_MAGIC_STRING_BUFFER "Buffer"
#define IOTJS_MAGIC_STRING__BUFFER "_buffer"
#define IOTJS_MAGIC_STRING__BUILTIN "_builtin"
#define IOTJS_MAGIC_STRING_BYTELENGTH "byteLength"
#define IOTJS_MAGIC_STRING_BYTEPARSED "byteParsed"
#define IOTJS_MAGIC_STRING_CHDIR "chdir"
#define IOTJS_MAGIC_STRING_CHIP "chip"
#define IOTJS_MAGIC_STRING_CHIPSELECT "chipSelect"
#define IOTJS_MAGIC_STRING_CHIPSELECT_U "CHIPSELECT"
#define IOTJS_MAGIC_STRING_CLOSE "close"
#define IOTJS_MAGIC_STRING_CLOSESYNC "closeSync"
#define IOTJS_MAGIC_STRING_CODE "code"
#define IOTJS_MAGIC_STRING_COMPARE "compare"
#define IOTJS_MAGIC_STRING_COMPILE "compile"
#define IOTJS_MAGIC_STRING_COMPILENATIVEPTR "compileNativePtr"
#define IOTJS_MAGIC_STRING_CONNECT "connect"
#define IOTJS_MAGIC_STRING_COPY "copy"
#define IOTJS_MAGIC_STRING__CREATESTAT "_createStat"
#define IOTJS_MAGIC_STRING_CREATETCP "createTCP"
#define IOTJS_MAGIC_STRING_CWD "cwd"
#define IOTJS_MAGIC_STRING_DATABITS "dataBits"
#define IOTJS_MAGIC_STRING_DEVICE "device"
#define IOTJS_MAGIC_STRING_DIRECTION "direction"
#define IOTJS_MAGIC_STRING_DIRECTION_U "DIRECTION"
#define IOTJS_MAGIC_STRING_DOEXIT "doExit"
#define IOTJS_MAGIC_STRING_DROPMEMBERSHIP "dropMembership"
#define IOTJS_MAGIC_STRING_DUTYCYCLE "dutyCycle"
#define IOTJS_MAGIC_STRING_EDGE "edge"
#define IOTJS_MAGIC_STRING_EDGE_U "EDGE"
#define IOTJS_MAGIC_STRING_EMIT "emit"
#define IOTJS_MAGIC_STRING_EMITEXIT "emitExit"
#define IOTJS_MAGIC_STRING_ENV "env"
#define IOTJS_MAGIC_STRING_ERRNAME "errname"
#define IOTJS_MAGIC_STRING_EXECUTE "execute"
#define IOTJS_MAGIC_STRING_EXPORT "export"
#define IOTJS_MAGIC_STRING_FALLING_U "FALLING"
#define IOTJS_MAGIC_STRING_FAMILY "family"
#define IOTJS_MAGIC_STRING_FINISH "finish"
#define IOTJS_MAGIC_STRING_FLOAT "FLOAT"
#define IOTJS_MAGIC_STRING_FSTAT "fstat"
#define IOTJS_MAGIC_STRING_GETADDRINFO "getaddrinfo"
#define IOTJS_MAGIC_STRING_GETSOCKNAME "getsockname"
#define IOTJS_MAGIC_STRING_GPIO "Gpio"
#define IOTJS_MAGIC_STRING_HANDLER "handler"
#define IOTJS_MAGIC_STRING_HANDLETIMEOUT "handleTimeout"
#define IOTJS_MAGIC_STRING_HEADERS "headers"
#define IOTJS_MAGIC_STRING_HEXWRITE "hexWrite"
#define IOTJS_MAGIC_STRING_HIGH "HIGH"
#define IOTJS_MAGIC_STRING_HOME "HOME"
#define IOTJS_MAGIC_STRING_HTTPPARSER "HTTPParser"
#define IOTJS_MAGIC_STRING_IN "IN"
#define IOTJS_MAGIC_STRING_IOTJS_ENV "IOTJS_ENV"
#define IOTJS_MAGIC_STRING_IOTJS_PATH "IOTJS_PATH"
#define IOTJS_MAGIC_STRING_IOTJS "iotjs"
#define IOTJS_MAGIC_STRING_IPV4 "IPv4"
#define IOTJS_MAGIC_STRING_IPV6 "IPv6"
#define IOTJS_MAGIC_STRING_ISALIVEEXCEPTFOR "isAliveExceptFor"
#define IOTJS_MAGIC_STRING_ISDEVUP "isDevUp"
#define IOTJS_MAGIC_STRING_LENGTH "length"
#define IOTJS_MAGIC_STRING_LISTEN "listen"
#define IOTJS_MAGIC_STRING_LOOPBACK "loopback"
#define IOTJS_MAGIC_STRING_LSB "LSB"
#define IOTJS_MAGIC_STRING_MAXSPEED "maxSpeed"
#define IOTJS_MAGIC_STRING_METHOD "method"
#define IOTJS_MAGIC_STRING_METHODS "methods"
#define IOTJS_MAGIC_STRING_MKDIR "mkdir"
#define IOTJS_MAGIC_STRING_MODE "mode"
#define IOTJS_MAGIC_STRING_MODE_U "MODE"
#define IOTJS_MAGIC_STRING_MSB "MSB"
#define IOTJS_MAGIC_STRING_NATIVE_SOURCES "native_sources"
#define IOTJS_MAGIC_STRING_NONE "NONE"
#define IOTJS_MAGIC_STRING_ONBODY "OnBody"
#define IOTJS_MAGIC_STRING_ONCLOSE "onclose"
#define IOTJS_MAGIC_STRING_ONCONNECTION "onconnection"
#define IOTJS_MAGIC_STRING_ONHEADERSCOMPLETE "OnHeadersComplete"
#define IOTJS_MAGIC_STRING_ONHEADERS "OnHeaders"
#define IOTJS_MAGIC_STRING_ONMESSAGECOMPLETE "OnMessageComplete"
#define IOTJS_MAGIC_STRING_ONMESSAGE "onmessage"
#define IOTJS_MAGIC_STRING__ONNEXTTICK "_onNextTick"
#define IOTJS_MAGIC_STRING_ONREAD "onread"
#define IOTJS_MAGIC_STRING__ONUNCAUGHTEXCEPTION "_onUncaughtException"
#define IOTJS_MAGIC_STRING_OPENDRAIN "OPENDRAIN"
#define IOTJS_MAGIC_STRING_OPEN "open"
#define IOTJS_MAGIC_STRING_OUT "OUT"
#define IOTJS_MAGIC_STRING_OWNER "owner"
#define IOTJS_MAGIC_STRING_PAUSE "pause"
#define IOTJS_MAGIC_STRING_PERIOD "period"
#define IOTJS_MAGIC_STRING_PIN "pin"
#define IOTJS_MAGIC_STRING_PLATFORM "platform"
#define IOTJS_MAGIC_STRING_PORT "port"
#define IOTJS_MAGIC_STRING_PROTOTYPE "prototype"
#define IOTJS_MAGIC_STRING_PULLDOWN "PULLDOWN"
#define IOTJS_MAGIC_STRING_PULLUP "PULLUP"
#define IOTJS_MAGIC_STRING_PUSHPULL "PUSHPULL"
#define IOTJS_MAGIC_STRING_READDIR "readdir"
#define IOTJS_MAGIC_STRING_READ "read"
#define IOTJS_MAGIC_STRING_READSOURCE "readSource"
#define IOTJS_MAGIC_STRING_READSTART "readStart"
#define IOTJS_MAGIC_STRING_READSYNC "readSync"
#define IOTJS_MAGIC_STRING_READUINT8 "readUInt8"
#define IOTJS_MAGIC_STRING_RECVSTART "recvStart"
#define IOTJS_MAGIC_STRING_RECVSTOP "recvStop"
#define IOTJS_MAGIC_STRING_REF "ref"
#define IOTJS_MAGIC_STRING_REINITIALIZE "reinitialize"
#define IOTJS_MAGIC_STRING_RENAME "rename"
#define IOTJS_MAGIC_STRING_REQUEST "REQUEST"
#define IOTJS_MAGIC_STRING_RESPONSE "RESPONSE"
#define IOTJS_MAGIC_STRING_RESUME "resume"
#define IOTJS_MAGIC_STRING__REUSEADDR "_reuseAddr"
#define IOTJS_MAGIC_STRING_RISING_U "RISING"
#define IOTJS_MAGIC_STRING_RMDIR "rmdir"
#define IOTJS_MAGIC_STRING_SEND "send"
#define IOTJS_MAGIC_STRING_SETADDRESS "setAddress"
#define IOTJS_MAGIC_STRING_SETBROADCAST "setBroadcast"
#define IOTJS_MAGIC_STRING_SETDUTYCYCLE "setDutyCycle"
#define IOTJS_MAGIC_STRING_SETENABLE "setEnable"
#define IOTJS_MAGIC_STRING_SETFILTER "setFilter"
#define IOTJS_MAGIC_STRING_SETFREQUENCY "setFrequency"
#define IOTJS_MAGIC_STRING_SETKEEPALIVE "setKeepAlive"
#define IOTJS_MAGIC_STRING_SETMULTICASTLOOPBACK "setMulticastLoopback"
#define IOTJS_MAGIC_STRING_SETMULTICASTTTL "setMulticastTTL"
#define IOTJS_MAGIC_STRING_SETPERIOD "setPeriod"
#define IOTJS_MAGIC_STRING_SETTTL "setTTL"
#define IOTJS_MAGIC_STRING_SHOULDKEEPALIVE "shouldkeepalive"
#define IOTJS_MAGIC_STRING_SHUTDOWN "shutdown"
#define IOTJS_MAGIC_STRING_SLICE "slice"
#define IOTJS_MAGIC_STRING_SPI "Spi"
#define IOTJS_MAGIC_STRING_START "start"
#define IOTJS_MAGIC_STRING_STAT "stat"
#define IOTJS_MAGIC_STRING_STATUS_MSG "status_msg"
#define IOTJS_MAGIC_STRING_STATUS "status"
#define IOTJS_MAGIC_STRING_STDERR "stderr"
#define IOTJS_MAGIC_STRING_STDOUT "stdout"
#define IOTJS_MAGIC_STRING_STOP "stop"
#define IOTJS_MAGIC_STRING_TOHEXSTRING "toHexString"
#define IOTJS_MAGIC_STRING_TOSTRING "toString"
#define IOTJS_MAGIC_STRING_TRANSFERARRAY "transferArray"
#define IOTJS_MAGIC_STRING_TRANSFERBUFFER "transferBuffer"
#define IOTJS_MAGIC_STRING_UNEXPORT "unexport"
#define IOTJS_MAGIC_STRING_UNLINK "unlink"
#define IOTJS_MAGIC_STRING_UNREF "unref"
#define IOTJS_MAGIC_STRING_UPGRADE "upgrade"
#define IOTJS_MAGIC_STRING_URL "url"
#define IOTJS_MAGIC_STRING_WRITESYNC "writeSync"
#define IOTJS_MAGIC_STRING_WRITEUINT8 "writeUInt8"
#define IOTJS_MAGIC_STRING_WRITE "write"

#endif /* IOTJS_STRING_CONSTANTS_H */
