import unittest
import warnings

from iotas.ordered_list_utils import (
    check_line_for_ordered_list_item,
    calculate_ordered_list_index,
    format_ordered_list_item,
)

warnings.filterwarnings("ignore", "version")


class Test(unittest.TestCase):

    def test_check_line_for_ordered_list_item(self) -> None:
        self.assertIsNotNone(check_line_for_ordered_list_item("1. item"))
        self.assertIsNotNone(check_line_for_ordered_list_item("1) item"))
        self.assertIsNotNone(check_line_for_ordered_list_item("a) item"))
        self.assertIsNotNone(check_line_for_ordered_list_item("a. item"))
        self.assertIsNone(check_line_for_ordered_list_item("plain"))
        self.assertIsNone(check_line_for_ordered_list_item(""))
        self.assertIsNone(check_line_for_ordered_list_item("1 item"))
        self.assertIsNone(check_line_for_ordered_list_item("- unordered"))

    def test_calculate_ordered_list_index(self) -> None:
        self.assertEqual(calculate_ordered_list_index("1", 1), "2")
        self.assertEqual(calculate_ordered_list_index("2", -1), "1")
        self.assertEqual(calculate_ordered_list_index("1", -1), "0")
        self.assertEqual(calculate_ordered_list_index("0", -1), "-1")

        self.assertEqual(calculate_ordered_list_index("a", 1), "b")
        self.assertEqual(calculate_ordered_list_index("A", 1), "B")
        self.assertEqual(calculate_ordered_list_index("b", -1), "a")
        self.assertEqual(calculate_ordered_list_index("B", -1), "A")
        self.assertIsNone(calculate_ordered_list_index("z", 1))
        self.assertIsNone(calculate_ordered_list_index("Z", 1))

        self.assertIsNone(calculate_ordered_list_index("1.", 1))
        self.assertIsNone(calculate_ordered_list_index("a)", 1))
        self.assertIsNone(calculate_ordered_list_index("", 1))
        self.assertIsNone(calculate_ordered_list_index("text", 1))

    def test_format_ordered_list_item(self) -> None:
        self.assertEqual(format_ordered_list_item("", "a", ")"), "a) ")
        self.assertEqual(format_ordered_list_item("  ", "3", "."), "  3. ")
