/*=========================================================================

  Program:   Ionization FRont Interactive Tool (IFRIT)
  Language:  C++


Copyright (c) 2002-2012 Nick Gnedin 
All rights reserved.

This file may be distributed and/or modified under the terms of the
GNU General Public License version 2 as published by the Free Software
Foundation and appearing in the file LICENSE.GPL included in the
packaging of this file.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHORS OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

=========================================================================*/


#include "iconfigure.h"
#if ISHELL_INCLUDED(ISHELL_CL)


#include "iclcontrolscript.h"


#include "icontrolmodule.h"
#include "ierror.h"
#include "ihelpfactory.h"
#include "istring.h"
#include "isystem.h"

#include "iclinputchannel.h"
#include "iclshell.h"


#define curScript	iRequiredCast<iclControlScript>(INFO,me)


iclControlScript::iclControlScript(iControlModule *cm, iScript *parent) : iControlScript(cm,parent)
{
	mInputChannel = iRequiredCast<iclShell>(INFO,this->GetControlModule()->GetShell())->GetInputChannel();
}


iclControlScript::~iclControlScript()
{
}

//
//  Own console functions
//
void iclControlScript::OutputText(const iString &s0) const
{
	//
	//  Help is kept in HTML format. Strip formatting first.
	//
	iString s(s0);
	s.ReformatHTMLToText(78);

	//
	//  Use paging (a-la 'more')
	//
	int ioff = 0;
	iString tmp;
	tmp = s.Section("\n",ioff,ioff+19);
	while(!tmp.IsEmpty())
	{
		cout << tmp.ToCharPointer() << endl;
		ioff += 20;
		tmp = s.Section("\n",ioff,ioff+19);
		if(!tmp.IsEmpty())
		{
			cout << "Press <Enter> to continue...";
			cout.flush();
			while(mInputChannel->NextChar() != '\n') iSystem::Sleep(100);
			cout << "\r                            \r";
		}
	}
}

void iclControlScript::OutputError(const iString &s0) const
{
	//
	//  Help is kept in HTML format. Strip formatting first.
	//
	iString s(s0);
	s.ReformatHTMLToText(70);

	//
	//  Send to cerr
	//
	cerr << "ERROR: " << s.ToCharPointer() << endl;
}

#endif
