.TH ICMPINFO 1 "V1.11 - 28 August 1995" "dl's free utilities"
.SH NAME

icmpinfo \- interpret ICMP messages

.SH SYNOPSIS

.B icmpinfo
[\-v[v[v]]] [\-n] [\-p] [\-s] [\-l]

.SH DESCRIPTION
.BR Icmpinfo
is a tool for looking at the ICMP messages received
on the running host.
It can be used to detect and record 'bombs'
as well as various network problems.

The output format is as follows (all on one line):

  MMM DD HH:MM:SS ICMP_type[sub-type]
.br
	< sender_ip [sender_name] > unreach_ip [unreach_name]
.br
	sp=source_port dp=dest_port seq=sequence sz=packet_size

In normal operation,
.B icmpinfo
will only report on "weird" packets, mainly icmp_unreachable.

.SH OPTIONS
.TP
.I "\-v"
Give information about all icmp packets, excepts pings.

.TP
.I "\-vv"
Give about pings too (i.e. icmp_echo_reply).

.TP
.I "\-vvv"
Include an ascii/hex dump of each packet

.TP
.I "\-n"
Avoid name queries - just give IP addresses.
(use this option when running unattended on name server hosts (to avoid
possible looping))

.TP
.I "\-p"
Avoid port number to service name decoding.

.TP
.I "\-s"
Show the interface ip that received the packet. Usefull only if your
host has several network interfaces. In this case an '- my_ip
[my_name]' is added between the sender and unreach ip and name fields.

.TP
.I "\-l"
Forks and use the syslog(3) facility to record events (recomended use).
(root only option).
.SH WARNINGS
The packet decoding is planned for ICMP Unreachable outputs and might
not be significant for all other Icmp types. Output can be shorter
when implied by the packet size or the icmp type.

.SH AUTHOR
Laurent Demailly <dl@hplyot.obspm.fr>. Free software.
