/* Copyright 2013 Google Inc. All Rights Reserved.

   Distributed under MIT license.
   See file LICENSE for detail or copy at https://opensource.org/licenses/MIT
*/

#include "./dictionary.h"

#if defined(__cplusplus) || defined(c_plusplus)
extern "C" {
#endif

/* In case of multiple definition linker error with dictionary.cc from the
  encoder: include only one of enc/dictionary.cc or dec/dictionary.c in a
  target using both enc and dec. */
const uint8_t kBrotliDictionary[122784] = {
  0x74, 0x69, 0x6d, 0x65, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x69, 0x66, 0x65, 0x6c,
  0x65, 0x66, 0x74, 0x62, 0x61, 0x63, 0x6b, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x61,
  0x74, 0x61, 0x73, 0x68, 0x6f, 0x77, 0x6f, 0x6e, 0x6c, 0x79, 0x73, 0x69, 0x74,
  0x65, 0x63, 0x69, 0x74, 0x79, 0x6f, 0x70, 0x65, 0x6e, 0x6a, 0x75, 0x73, 0x74,
  0x6c, 0x69, 0x6b, 0x65, 0x66, 0x72, 0x65, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x74,
  0x65, 0x78, 0x74, 0x79, 0x65, 0x61, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x62, 0x6f,
  0x64, 0x79, 0x6c, 0x6f, 0x76, 0x65, 0x66, 0x6f, 0x72, 0x6d, 0x62, 0x6f, 0x6f,
  0x6b, 0x70, 0x6c, 0x61, 0x79, 0x6c, 0x69, 0x76, 0x65, 0x6c, 0x69, 0x6e, 0x65,
  0x68, 0x65, 0x6c, 0x70, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6d,
  0x6f, 0x72, 0x65, 0x77, 0x6f, 0x72, 0x64, 0x6c, 0x6f, 0x6e, 0x67, 0x74, 0x68,
  0x65, 0x6d, 0x76, 0x69, 0x65, 0x77, 0x66, 0x69, 0x6e, 0x64, 0x70, 0x61, 0x67,
  0x65, 0x64, 0x61, 0x79, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x68, 0x65, 0x61, 0x64,
  0x74, 0x65, 0x72, 0x6d, 0x65, 0x61, 0x63, 0x68, 0x61, 0x72, 0x65, 0x61, 0x66,
  0x72, 0x6f, 0x6d, 0x74, 0x72, 0x75, 0x65, 0x6d, 0x61, 0x72, 0x6b, 0x61, 0x62,
  0x6c, 0x65, 0x75, 0x70, 0x6f, 0x6e, 0x68, 0x69, 0x67, 0x68, 0x64, 0x61, 0x74,
  0x65, 0x6c, 0x61, 0x6e, 0x64, 0x6e, 0x65, 0x77, 0x73, 0x65, 0x76, 0x65, 0x6e,
  0x6e, 0x65, 0x78, 0x74, 0x63, 0x61, 0x73, 0x65, 0x62, 0x6f, 0x74, 0x68, 0x70,
  0x6f, 0x73, 0x74, 0x75, 0x73, 0x65, 0x64, 0x6d, 0x61, 0x64, 0x65, 0x68, 0x61,
  0x6e, 0x64, 0x68, 0x65, 0x72, 0x65, 0x77, 0x68, 0x61, 0x74, 0x6e, 0x61, 0x6d,
  0x65, 0x4c, 0x69, 0x6e, 0x6b, 0x62, 0x6c, 0x6f, 0x67, 0x73, 0x69, 0x7a, 0x65,
  0x62, 0x61, 0x73, 0x65, 0x68, 0x65, 0x6c, 0x64, 0x6d, 0x61, 0x6b, 0x65, 0x6d,
  0x61, 0x69, 0x6e, 0x75, 0x73, 0x65, 0x72, 0x27, 0x29, 0x20, 0x2b, 0x68, 0x6f,
  0x6c, 0x64, 0x65, 0x6e, 0x64, 0x73, 0x77, 0x69, 0x74, 0x68, 0x4e, 0x65, 0x77,
  0x73, 0x72, 0x65, 0x61, 0x64, 0x77, 0x65, 0x72, 0x65, 0x73, 0x69, 0x67, 0x6e,
  0x74, 0x61, 0x6b, 0x65, 0x68, 0x61, 0x76, 0x65, 0x67, 0x61, 0x6d, 0x65, 0x73,
  0x65, 0x65, 0x6e, 0x63, 0x61, 0x6c, 0x6c, 0x70, 0x61, 0x74, 0x68, 0x77, 0x65,
  0x6c, 0x6c, 0x70, 0x6c, 0x75, 0x73, 0x6d, 0x65, 0x6e, 0x75, 0x66, 0x69, 0x6c,
  0x6d, 0x70, 0x61, 0x72, 0x74, 0x6a, 0x6f, 0x69, 0x6e, 0x74, 0x68, 0x69, 0x73,
  0x6c, 0x69, 0x73, 0x74, 0x67, 0x6f, 0x6f, 0x64, 0x6e, 0x65, 0x65, 0x64, 0x77,
  0x61, 0x79, 0x73, 0x77, 0x65, 0x73, 0x74, 0x6a, 0x6f, 0x62, 0x73, 0x6d, 0x69,
  0x6e, 0x64, 0x61, 0x6c, 0x73, 0x6f, 0x6c, 0x6f, 0x67, 0x6f, 0x72, 0x69, 0x63,
  0x68, 0x75, 0x73, 0x65, 0x73, 0x6c, 0x61, 0x73, 0x74, 0x74, 0x65, 0x61, 0x6d,
  0x61, 0x72, 0x6d, 0x79, 0x66, 0x6f, 0x6f, 0x64, 0x6b, 0x69, 0x6e, 0x67, 0x77,
  0x69, 0x6c, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x77, 0x61, 0x72, 0x64, 0x62, 0x65,
  0x73, 0x74, 0x66, 0x69, 0x72, 0x65, 0x50, 0x61, 0x67, 0x65, 0x6b, 0x6e, 0x6f,
  0x77, 0x61, 0x77, 0x61, 0x79, 0x2e, 0x70, 0x6e, 0x67, 0x6d, 0x6f, 0x76, 0x65,
  0x74, 0x68, 0x61, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x67, 0x69, 0x76, 0x65, 0x73,
  0x65, 0x6c, 0x66, 0x6e, 0x6f, 0x74, 0x65, 0x6d, 0x75, 0x63, 0x68, 0x66, 0x65,
  0x65, 0x64, 0x6d, 0x61, 0x6e, 0x79, 0x72, 0x6f, 0x63, 0x6b, 0x69, 0x63, 0x6f,
  0x6e, 0x6f, 0x6e, 0x63, 0x65, 0x6c, 0x6f, 0x6f, 0x6b, 0x68, 0x69, 0x64, 0x65,
  0x64, 0x69, 0x65, 0x64, 0x48, 0x6f, 0x6d, 0x65, 0x72, 0x75, 0x6c, 0x65, 0x68,
  0x6f, 0x73, 0x74, 0x61, 0x6a, 0x61, 0x78, 0x69, 0x6e, 0x66, 0x6f, 0x63, 0x6c,
  0x75, 0x62, 0x6c, 0x61, 0x77, 0x73, 0x6c, 0x65, 0x73, 0x73, 0x68, 0x61, 0x6c,
  0x66, 0x73, 0x6f, 0x6d, 0x65, 0x73, 0x75, 0x63, 0x68, 0x7a, 0x6f, 0x6e, 0x65,
  0x31, 0x30, 0x30, 0x25, 0x6f, 0x6e, 0x65, 0x73, 0x63, 0x61, 0x72, 0x65, 0x54,
  0x69, 0x6d, 0x65, 0x72, 0x61, 0x63, 0x65, 0x62, 0x6c, 0x75, 0x65, 0x66, 0x6f,
  0x75, 0x72, 0x77, 0x65, 0x65, 0x6b, 0x66, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x70,
  0x65, 0x67, 0x61, 0x76, 0x65, 0x68, 0x61, 0x72, 0x64, 0x6c, 0x6f, 0x73, 0x74,
  0x77, 0x68, 0x65, 0x6e, 0x70, 0x61, 0x72, 0x6b, 0x6b, 0x65, 0x70, 0x74, 0x70,
  0x61, 0x73, 0x73, 0x73, 0x68, 0x69, 0x70, 0x72, 0x6f, 0x6f, 0x6d, 0x48, 0x54,
  0x4d, 0x4c, 0x70, 0x6c, 0x61, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x64, 0x6f, 0x6e,
  0x65, 0x73, 0x61, 0x76, 0x65, 0x6b, 0x65, 0x65, 0x70, 0x66, 0x6c, 0x61, 0x67,
  0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x6f, 0x6c, 0x64, 0x66, 0x69, 0x76, 0x65, 0x74,
  0x6f, 0x6f, 0x6b, 0x72, 0x61, 0x74, 0x65, 0x74, 0x6f, 0x77, 0x6e, 0x6a, 0x75,
  0x6d, 0x70, 0x74, 0x68, 0x75, 0x73, 0x64, 0x61, 0x72, 0x6b, 0x63, 0x61, 0x72,
  0x64, 0x66, 0x69, 0x6c, 0x65, 0x66, 0x65, 0x61, 0x72, 0x73, 0x74, 0x61, 0x79,
  0x6b, 0x69, 0x6c, 0x6c, 0x74, 0x68, 0x61, 0x74, 0x66, 0x61, 0x6c, 0x6c, 0x61,
  0x75, 0x74, 0x6f, 0x65, 0x76, 0x65, 0x72, 0x2e, 0x63, 0x6f, 0x6d, 0x74, 0x61,
  0x6c, 0x6b, 0x73, 0x68, 0x6f, 0x70, 0x76, 0x6f, 0x74, 0x65, 0x64, 0x65, 0x65,
  0x70, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x65, 0x73, 0x74, 0x74, 0x75, 0x72, 0x6e,
  0x62, 0x6f, 0x72, 0x6e, 0x62, 0x61, 0x6e, 0x64, 0x66, 0x65, 0x6c, 0x6c, 0x72,
  0x6f, 0x73, 0x65, 0x75, 0x72, 0x6c, 0x28, 0x73, 0x6b, 0x69, 0x6e, 0x72, 0x6f,
  0x6c, 0x65, 0x63, 0x6f, 0x6d, 0x65, 0x61, 0x63, 0x74, 0x73, 0x61, 0x67, 0x65,
  0x73, 0x6d, 0x65, 0x65, 0x74, 0x67, 0x6f, 0x6c, 0x64, 0x2e, 0x6a, 0x70, 0x67,
  0x69, 0x74, 0x65, 0x6d, 0x76, 0x61, 0x72, 0x79, 0x66, 0x65, 0x6c, 0x74, 0x74,
  0x68, 0x65, 0x6e, 0x73, 0x65, 0x6e, 0x64, 0x64, 0x72, 0x6f, 0x70, 0x56, 0x69,
  0x65, 0x77, 0x63, 0x6f, 0x70, 0x79, 0x31, 0x2e, 0x30, 0x22, 0x3c, 0x2f, 0x61,
  0x3e, 0x73, 0x74, 0x6f, 0x70, 0x65, 0x6c, 0x73, 0x65, 0x6c, 0x69, 0x65, 0x73,
  0x74, 0x6f, 0x75, 0x72, 0x70, 0x61, 0x63, 0x6b, 0x2e, 0x67, 0x69, 0x66, 0x70,
  0x61, 0x73, 0x74, 0x63, 0x73, 0x73, 0x3f, 0x67, 0x72, 0x61, 0x79, 0x6d, 0x65,
  0x61, 0x6e, 0x26, 0x67, 0x74, 0x3b, 0x72, 0x69, 0x64, 0x65, 0x73, 0x68, 0x6f,
  0x74, 0x6c, 0x61, 0x74, 0x65, 0x73, 0x61, 0x69, 0x64, 0x72, 0x6f, 0x61, 0x64,
  0x76, 0x61, 0x72, 0x20, 0x66, 0x65, 0x65, 0x6c, 0x6a, 0x6f, 0x68, 0x6e, 0x72,
  0x69, 0x63, 0x6b, 0x70, 0x6f, 0x72, 0x74, 0x66, 0x61, 0x73, 0x74, 0x27, 0x55,
  0x41, 0x2d, 0x64, 0x65, 0x61, 0x64, 0x3c, 0x2f, 0x62, 0x3e, 0x70, 0x6f, 0x6f,
  0x72, 0x62, 0x69, 0x6c, 0x6c, 0x74, 0x79, 0x70, 0x65, 0x55, 0x2e, 0x53, 0x2e,
  0x77, 0x6f, 0x6f, 0x64, 0x6d, 0x75, 0x73, 0x74, 0x32, 0x70, 0x78, 0x3b, 0x49,
  0x6e, 0x66, 0x6f, 0x72, 0x61, 0x6e, 0x6b, 0x77, 0x69, 0x64, 0x65, 0x77, 0x61,
  0x6e, 0x74, 0x77, 0x61, 0x6c, 0x6c, 0x6c, 0x65, 0x61, 0x64, 0x5b, 0x30, 0x5d,
  0x3b, 0x70, 0x61, 0x75, 0x6c, 0x77, 0x61, 0x76, 0x65, 0x73, 0x75, 0x72, 0x65,
  0x24, 0x28, 0x27, 0x23, 0x77, 0x61, 0x69, 0x74, 0x6d, 0x61, 0x73, 0x73, 0x61,
  0x72, 0x6d, 0x73, 0x67, 0x6f, 0x65, 0x73, 0x67, 0x61, 0x69, 0x6e, 0x6c, 0x61,
  0x6e, 0x67, 0x70, 0x61, 0x69, 0x64, 0x21, 0x2d, 0x2d, 0x20, 0x6c, 0x6f, 0x63,
  0x6b, 0x75, 0x6e, 0x69, 0x74, 0x72, 0x6f, 0x6f, 0x74, 0x77, 0x61, 0x6c, 0x6b,
  0x66, 0x69, 0x72, 0x6d, 0x77, 0x69, 0x66, 0x65, 0x78, 0x6d, 0x6c, 0x22, 0x73,
  0x6f, 0x6e, 0x67, 0x74, 0x65, 0x73, 0x74, 0x32, 0x30, 0x70, 0x78, 0x6b, 0x69,
  0x6e, 0x64, 0x72, 0x6f, 0x77, 0x73, 0x74, 0x6f, 0x6f, 0x6c, 0x66, 0x6f, 0x6e,
  0x74, 0x6d, 0x61, 0x69, 0x6c, 0x73, 0x61, 0x66, 0x65, 0x73, 0x74, 0x61, 0x72,
  0x6d, 0x61, 0x70, 0x73, 0x63, 0x6f, 0x72, 0x65, 0x72, 0x61, 0x69, 0x6e, 0x66,
  0x6c, 0x6f, 0x77, 0x62, 0x61, 0x62, 0x79, 0x73, 0x70, 0x61, 0x6e, 0x73, 0x61,
  0x79, 0x73, 0x34, 0x70, 0x78, 0x3b, 0x36, 0x70, 0x78, 0x3b, 0x61, 0x72, 0x74,
  0x73, 0x66, 0x6f, 0x6f, 0x74, 0x72, 0x65, 0x61, 0x6c, 0x77, 0x69, 0x6b, 0x69,
  0x68, 0x65, 0x61, 0x74, 0x73, 0x74, 0x65, 0x70, 0x74, 0x72, 0x69, 0x70, 0x6f,
  0x72, 0x67, 0x2f, 0x6c, 0x61, 0x6b, 0x65, 0x77, 0x65, 0x61, 0x6b, 0x74, 0x6f,
  0x6c, 0x64, 0x46, 0x6f, 0x72, 0x6d, 0x63, 0x61, 0x73, 0x74, 0x66, 0x61, 0x6e,
  0x73, 0x62, 0x61, 0x6e, 0x6b, 0x76, 0x65, 0x72, 0x79, 0x72, 0x75, 0x6e, 0x73,
  0x6a, 0x75, 0x6c, 0x79, 0x74, 0x61, 0x73, 0x6b, 0x31, 0x70, 0x78, 0x3b, 0x67,
  0x6f, 0x61, 0x6c, 0x67, 0x72, 0x65, 0x77, 0x73, 0x6c, 0x6f, 0x77, 0x65, 0x64,
  0x67, 0x65, 0x69, 0x64, 0x3d, 0x22, 0x73, 0x65, 0x74, 0x73, 0x35, 0x70, 0x78,
  0x3b, 0x2e, 0x6a, 0x73, 0x3f, 0x34, 0x30, 0x70, 0x78, 0x69, 0x66, 0x20, 0x28,
  0x73, 0x6f, 0x6f, 0x6e, 0x73, 0x65, 0x61, 0x74, 0x6e, 0x6f, 0x6e, 0x65, 0x74,
  0x75, 0x62, 0x65, 0x7a, 0x65, 0x72, 0x6f, 0x73, 0x65, 0x6e, 0x74, 0x72, 0x65,
  0x65, 0x64, 0x66, 0x61, 0x63, 0x74, 0x69, 0x6e, 0x74, 0x6f, 0x67, 0x69, 0x66,
  0x74, 0x68, 0x61, 0x72, 0x6d, 0x31, 0x38, 0x70, 0x78, 0x63, 0x61, 0x6d, 0x65,
  0x68, 0x69, 0x6c, 0x6c, 0x62, 0x6f, 0x6c, 0x64, 0x7a, 0x6f, 0x6f, 0x6d, 0x76,
  0x6f, 0x69, 0x64, 0x65, 0x61, 0x73, 0x79, 0x72, 0x69, 0x6e, 0x67, 0x66, 0x69,
  0x6c, 0x6c, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x69, 0x74, 0x63, 0x6f, 0x73,
  0x74, 0x33, 0x70, 0x78, 0x3b, 0x6a, 0x61, 0x63, 0x6b, 0x74, 0x61, 0x67, 0x73,
  0x62, 0x69, 0x74, 0x73, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x69, 0x74, 0x6b,
  0x6e, 0x65, 0x77, 0x6e, 0x65, 0x61, 0x72, 0x3c, 0x21, 0x2d, 0x2d, 0x67, 0x72,
  0x6f, 0x77, 0x4a, 0x53, 0x4f, 0x4e, 0x64, 0x75, 0x74, 0x79, 0x4e, 0x61, 0x6d,
  0x65, 0x73, 0x61, 0x6c, 0x65, 0x79, 0x6f, 0x75, 0x20, 0x6c, 0x6f, 0x74, 0x73,
  0x70, 0x61, 0x69, 0x6e, 0x6a, 0x61, 0x7a, 0x7a, 0x63, 0x6f, 0x6c, 0x64, 0x65,
  0x79, 0x65, 0x73, 0x66, 0x69, 0x73, 0x68, 0x77, 0x77, 0x77, 0x2e, 0x72, 0x69,
  0x73, 0x6b, 0x74, 0x61, 0x62, 0x73, 0x70, 0x72, 0x65, 0x76, 0x31, 0x30, 0x70,
  0x78, 0x72, 0x69, 0x73, 0x65, 0x32, 0x35, 0x70, 0x78, 0x42, 0x6c, 0x75, 0x65,
  0x64, 0x69, 0x6e, 0x67, 0x33, 0x30, 0x30, 0x2c, 0x62, 0x61, 0x6c, 0x6c, 0x66,
  0x6f, 0x72, 0x64, 0x65, 0x61, 0x72, 0x6e, 0x77, 0x69, 0x6c, 0x64, 0x62, 0x6f,
  0x78, 0x2e, 0x66, 0x61, 0x69, 0x72, 0x6c, 0x61, 0x63, 0x6b, 0x76, 0x65, 0x72,
  0x73, 0x70, 0x61, 0x69, 0x72, 0x6a, 0x75, 0x6e, 0x65, 0x74, 0x65, 0x63, 0x68,
  0x69, 0x66, 0x28, 0x21, 0x70, 0x69, 0x63, 0x6b, 0x65, 0x76, 0x69, 0x6c, 0x24,
  0x28, 0x22, 0x23, 0x77, 0x61, 0x72, 0x6d, 0x6c, 0x6f, 0x72, 0x64, 0x64, 0x6f,
  0x65, 0x73, 0x70, 0x75, 0x6c, 0x6c, 0x2c, 0x30, 0x30, 0x30, 0x69, 0x64, 0x65,
  0x61, 0x64, 0x72, 0x61, 0x77, 0x68, 0x75, 0x67, 0x65, 0x73, 0x70, 0x6f, 0x74,
  0x66, 0x75, 0x6e, 0x64, 0x62, 0x75, 0x72, 0x6e, 0x68, 0x72, 0x65, 0x66, 0x63,
  0x65, 0x6c, 0x6c, 0x6b, 0x65, 0x79, 0x73, 0x74, 0x69, 0x63, 0x6b, 0x68, 0x6f,
  0x75, 0x72, 0x6c, 0x6f, 0x73, 0x73, 0x66, 0x75, 0x65, 0x6c, 0x31, 0x32, 0x70,
  0x78, 0x73, 0x75, 0x69, 0x74, 0x64, 0x65, 0x61, 0x6c, 0x52, 0x53, 0x53, 0x22,
  0x61, 0x67, 0x65, 0x64, 0x67, 0x72, 0x65, 0x79, 0x47, 0x45, 0x54, 0x22, 0x65,
  0x61, 0x73, 0x65, 0x61, 0x69, 0x6d, 0x73, 0x67, 0x69, 0x72, 0x6c, 0x61, 0x69,
  0x64, 0x73, 0x38, 0x70, 0x78, 0x3b, 0x6e, 0x61, 0x76, 0x79, 0x67, 0x72, 0x69,
  0x64, 0x74, 0x69, 0x70, 0x73, 0x23, 0x39, 0x39, 0x39, 0x77, 0x61, 0x72, 0x73,
  0x6c, 0x61, 0x64, 0x79, 0x63, 0x61, 0x72, 0x73, 0x29, 0x3b, 0x20, 0x7d, 0x70,
  0x68, 0x70, 0x3f, 0x68, 0x65, 0x6c, 0x6c, 0x74, 0x61, 0x6c, 0x6c, 0x77, 0x68,
  0x6f, 0x6d, 0x7a, 0x68, 0x3a, 0xe5, 0x2a, 0x2f, 0x0d, 0x0a, 0x20, 0x31, 0x30,
  0x30, 0x68, 0x61, 0x6c, 0x6c, 0x2e, 0x0a, 0x0a, 0x41, 0x37, 0x70, 0x78, 0x3b,
  0x70, 0x75, 0x73, 0x68, 0x63, 0x68, 0x61, 0x74, 0x30, 0x70, 0x78, 0x3b, 0x63,
  0x72, 0x65, 0x77, 0x2a, 0x2f, 0x3c, 0x2f, 0x68, 0x61, 0x73, 0x68, 0x37, 0x35,
  0x70, 0x78, 0x66, 0x6c, 0x61, 0x74, 0x72, 0x61, 0x72, 0x65, 0x20, 0x26, 0x26,
  0x20, 0x74, 0x65, 0x6c, 0x6c, 0x63, 0x61, 0x6d, 0x70, 0x6f, 0x6e, 0x74, 0x6f,
  0x6c, 0x61, 0x69, 0x64, 0x6d, 0x69, 0x73, 0x73, 0x73, 0x6b, 0x69, 0x70, 0x74,
  0x65, 0x6e, 0x74, 0x66, 0x69, 0x6e, 0x65, 0x6d, 0x61, 0x6c, 0x65, 0x67, 0x65,
  0x74, 0x73, 0x70, 0x6c, 0x6f, 0x74, 0x34, 0x30, 0x30, 0x2c, 0x0d, 0x0a, 0x0d,
  0x0a, 0x63, 0x6f, 0x6f, 0x6c, 0x66, 0x65, 0x65, 0x74, 0x2e, 0x70, 0x68, 0x70,
  0x3c, 0x62, 0x72, 0x3e, 0x65, 0x72, 0x69, 0x63, 0x6d, 0x6f, 0x73, 0x74, 0x67,
  0x75, 0x69, 0x64, 0x62, 0x65, 0x6c, 0x6c, 0x64, 0x65, 0x73, 0x63, 0x68, 0x61,
  0x69, 0x72, 0x6d, 0x61, 0x74, 0x68, 0x61, 0x74, 0x6f, 0x6d, 0x2f, 0x69, 0x6d,
  0x67, 0x26, 0x23, 0x38, 0x32, 0x6c, 0x75, 0x63, 0x6b, 0x63, 0x65, 0x6e, 0x74,
  0x30, 0x30, 0x30, 0x3b, 0x74, 0x69, 0x6e, 0x79, 0x67, 0x6f, 0x6e, 0x65, 0x68,
  0x74, 0x6d, 0x6c, 0x73, 0x65, 0x6c, 0x6c, 0x64, 0x72, 0x75, 0x67, 0x46, 0x52,
  0x45, 0x45, 0x6e, 0x6f, 0x64, 0x65, 0x6e, 0x69, 0x63, 0x6b, 0x3f, 0x69, 0x64,
  0x3d, 0x6c, 0x6f, 0x73, 0x65, 0x6e, 0x75, 0x6c, 0x6c, 0x76, 0x61, 0x73, 0x74,
  0x77, 0x69, 0x6e, 0x64, 0x52, 0x53, 0x53, 0x20, 0x77, 0x65, 0x61, 0x72, 0x72,
  0x65, 0x6c, 0x79, 0x62, 0x65, 0x65, 0x6e, 0x73, 0x61, 0x6d, 0x65, 0x64, 0x75,
  0x6b, 0x65, 0x6e, 0x61, 0x73, 0x61, 0x63, 0x61, 0x70, 0x65, 0x77, 0x69, 0x73,
  0x68, 0x67, 0x75, 0x6c, 0x66, 0x54, 0x32, 0x33, 0x3a, 0x68, 0x69, 0x74, 0x73,
  0x73, 0x6c, 0x6f, 0x74, 0x67, 0x61, 0x74, 0x65, 0x6b, 0x69, 0x63, 0x6b, 0x62,
  0x6c, 0x75, 0x72, 0x74, 0x68, 0x65, 0x79, 0x31, 0x35, 0x70, 0x78, 0x27, 0x27,
  0x29, 0x3b, 0x29, 0x3b, 0x22, 0x3e, 0x6d, 0x73, 0x69, 0x65, 0x77, 0x69, 0x6e,
  0x73, 0x62, 0x69, 0x72, 0x64, 0x73, 0x6f, 0x72, 0x74, 0x62, 0x65, 0x74, 0x61,
  0x73, 0x65, 0x65, 0x6b, 0x54, 0x31, 0x38, 0x3a, 0x6f, 0x72, 0x64, 0x73, 0x74,
  0x72, 0x65, 0x65, 0x6d, 0x61, 0x6c, 0x6c, 0x36, 0x30, 0x70, 0x78, 0x66, 0x61,
  0x72, 0x6d, 0xe2, 0x80, 0x99, 0x73, 0x62, 0x6f, 0x79, 0x73, 0x5b, 0x30, 0x5d,
  0x2e, 0x27, 0x29, 0x3b, 0x22, 0x50, 0x4f, 0x53, 0x54, 0x62, 0x65, 0x61, 0x72,
  0x6b, 0x69, 0x64, 0x73, 0x29, 0x3b, 0x7d, 0x7d, 0x6d, 0x61, 0x72, 0x79, 0x74,
  0x65, 0x6e, 0x64, 0x28, 0x55, 0x4b, 0x29, 0x71, 0x75, 0x61, 0x64, 0x7a, 0x68,
  0x3a, 0xe6, 0x2d, 0x73, 0x69, 0x7a, 0x2d, 0x2d, 0x2d, 0x2d, 0x70, 0x72, 0x6f,
  0x70, 0x27, 0x29, 0x3b, 0x0d, 0x6c, 0x69, 0x66, 0x74, 0x54, 0x31, 0x39, 0x3a,
  0x76, 0x69, 0x63, 0x65, 0x61, 0x6e, 0x64, 0x79, 0x64, 0x65, 0x62, 0x74, 0x3e,
  0x52, 0x53, 0x53, 0x70, 0x6f, 0x6f, 0x6c, 0x6e, 0x65, 0x63, 0x6b, 0x62, 0x6c,
  0x6f, 0x77, 0x54, 0x31, 0x36, 0x3a, 0x64, 0x6f, 0x6f, 0x72, 0x65, 0x76, 0x61,
  0x6c, 0x54, 0x31, 0x37, 0x3a, 0x6c, 0x65, 0x74, 0x73, 0x66, 0x61, 0x69, 0x6c,
  0x6f, 0x72, 0x61, 0x6c, 0x70, 0x6f, 0x6c, 0x6c, 0x6e, 0x6f, 0x76, 0x61, 0x63,
  0x6f, 0x6c, 0x73, 0x67, 0x65, 0x6e, 0x65, 0x20, 0xe2, 0x80, 0x94, 0x73, 0x6f,
  0x66, 0x74, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x69, 0x6c, 0x6c, 0x72, 0x6f, 0x73,
  0x73, 0x3c, 0x68, 0x33, 0x3e, 0x70, 0x6f, 0x75, 0x72, 0x66, 0x61, 0x64, 0x65,
  0x70, 0x69, 0x6e, 0x6b, 0x3c, 0x74, 0x72, 0x3e, 0x6d, 0x69, 0x6e, 0x69, 0x29,
  0x7c, 0x21, 0x28, 0x6d, 0x69, 0x6e, 0x65, 0x7a, 0x68, 0x3a, 0xe8, 0x62, 0x61,
  0x72, 0x73, 0x68, 0x65, 0x61, 0x72, 0x30, 0x30, 0x29, 0x3b, 0x6d, 0x69, 0x6c,
  0x6b, 0x20, 0x2d, 0x2d, 0x3e, 0x69, 0x72, 0x6f, 0x6e, 0x66, 0x72, 0x65, 0x64,
  0x64, 0x69, 0x73, 0x6b, 0x77, 0x65, 0x6e, 0x74, 0x73, 0x6f, 0x69, 0x6c, 0x70,
  0x75, 0x74, 0x73, 0x2f, 0x6a, 0x73, 0x2f, 0x68, 0x6f, 0x6c, 0x79, 0x54, 0x32,
  0x32, 0x3a, 0x49, 0x53, 0x42, 0x4e, 0x54, 0x32, 0x30, 0x3a, 0x61, 0x64, 0x61,
  0x6d, 0x73, 0x65, 0x65, 0x73, 0x3c, 0x68, 0x32, 0x3e, 0x6a, 0x73, 0x6f, 0x6e,
  0x27, 0x2c, 0x20, 0x27, 0x63, 0x6f, 0x6e, 0x74, 0x54, 0x32, 0x31, 0x3a, 0x20,
  0x52, 0x53, 0x53, 0x6c, 0x6f, 0x6f, 0x70, 0x61, 0x73, 0x69, 0x61, 0x6d, 0x6f,
  0x6f, 0x6e, 0x3c, 0x2f, 0x70, 0x3e, 0x73, 0x6f, 0x75, 0x6c, 0x4c, 0x49, 0x4e,
  0x45, 0x66, 0x6f, 0x72, 0x74, 0x63, 0x61, 0x72, 0x74, 0x54, 0x31, 0x34, 0x3a,
  0x3c, 0x68, 0x31, 0x3e, 0x38, 0x30, 0x70, 0x78, 0x21, 0x2d, 0x2d, 0x3c, 0x39,
  0x70, 0x78, 0x3b, 0x54, 0x30, 0x34, 0x3a, 0x6d, 0x69, 0x6b, 0x65, 0x3a, 0x34,
  0x36, 0x5a, 0x6e, 0x69, 0x63, 0x65, 0x69, 0x6e, 0x63, 0x68, 0x59, 0x6f, 0x72,
  0x6b, 0x72, 0x69, 0x63, 0x65, 0x7a, 0x68, 0x3a, 0xe4, 0x27, 0x29, 0x29, 0x3b,
  0x70, 0x75, 0x72, 0x65, 0x6d, 0x61, 0x67, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74,
  0x6f, 0x6e, 0x65, 0x62, 0x6f, 0x6e, 0x64, 0x3a, 0x33, 0x37, 0x5a, 0x5f, 0x6f,
  0x66, 0x5f, 0x27, 0x5d, 0x29, 0x3b, 0x30, 0x30, 0x30, 0x2c, 0x7a, 0x68, 0x3a,
  0xe7, 0x74, 0x61, 0x6e, 0x6b, 0x79, 0x61, 0x72, 0x64, 0x62, 0x6f, 0x77, 0x6c,
  0x62, 0x75, 0x73, 0x68, 0x3a, 0x35, 0x36, 0x5a, 0x4a, 0x61, 0x76, 0x61, 0x33,
  0x30, 0x70, 0x78, 0x0a, 0x7c, 0x7d, 0x0a, 0x25, 0x43, 0x33, 0x25, 0x3a, 0x33,
  0x34, 0x5a, 0x6a, 0x65, 0x66, 0x66, 0x45, 0x58, 0x50, 0x49, 0x63, 0x61, 0x73,
  0x68, 0x76, 0x69, 0x73, 0x61, 0x67, 0x6f, 0x6c, 0x66, 0x73, 0x6e, 0x6f, 0x77,
  0x7a, 0x68, 0x3a, 0xe9, 0x71, 0x75, 0x65, 0x72, 0x2e, 0x63, 0x73, 0x73, 0x73,
  0x69, 0x63, 0x6b, 0x6d, 0x65, 0x61, 0x74, 0x6d, 0x69, 0x6e, 0x2e, 0x62, 0x69,
  0x6e, 0x64, 0x64, 0x65, 0x6c, 0x6c, 0x68, 0x69, 0x72, 0x65, 0x70, 0x69, 0x63,
  0x73, 0x72, 0x65, 0x6e, 0x74, 0x3a, 0x33, 0x36, 0x5a, 0x48, 0x54, 0x54, 0x50,
  0x2d, 0x32, 0x30, 0x31, 0x66, 0x6f, 0x74, 0x6f, 0x77, 0x6f, 0x6c, 0x66, 0x45,
  0x4e, 0x44, 0x20, 0x78, 0x62, 0x6f, 0x78, 0x3a, 0x35, 0x34, 0x5a, 0x42, 0x4f,
  0x44, 0x59, 0x64, 0x69, 0x63, 0x6b, 0x3b, 0x0a, 0x7d, 0x0a, 0x65, 0x78, 0x69,
  0x74, 0x3a, 0x33, 0x35, 0x5a, 0x76, 0x61, 0x72, 0x73, 0x62, 0x65, 0x61, 0x74,
  0x27, 0x7d, 0x29, 0x3b, 0x64, 0x69, 0x65, 0x74, 0x39, 0x39, 0x39, 0x3b, 0x61,
  0x6e, 0x6e, 0x65, 0x7d, 0x7d, 0x3c, 0x2f, 0x5b, 0x69, 0x5d, 0x2e, 0x4c, 0x61,
  0x6e, 0x67, 0x6b, 0x6d, 0xc2, 0xb2, 0x77, 0x69, 0x72, 0x65, 0x74, 0x6f, 0x79,
  0x73, 0x61, 0x64, 0x64, 0x73, 0x73, 0x65, 0x61, 0x6c, 0x61, 0x6c, 0x65, 0x78,
  0x3b, 0x0a, 0x09, 0x7d, 0x65, 0x63, 0x68, 0x6f, 0x6e, 0x69, 0x6e, 0x65, 0x2e,
  0x6f, 0x72, 0x67, 0x30, 0x30, 0x35, 0x29, 0x74, 0x6f, 0x6e, 0x79, 0x6a, 0x65,
  0x77, 0x73, 0x73, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x67, 0x73, 0x72, 0x6f, 0x6f,
  0x66, 0x30, 0x30, 0x30, 0x29, 0x20, 0x32, 0x30, 0x30, 0x77, 0x69, 0x6e, 0x65,
  0x67, 0x65, 0x61, 0x72, 0x64, 0x6f, 0x67, 0x73, 0x62, 0x6f, 0x6f, 0x74, 0x67,
  0x61, 0x72, 0x79, 0x63, 0x75, 0x74, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x74, 0x65,
  0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x78, 0x6d, 0x6c, 0x63, 0x6f, 0x63,
  0x6b, 0x67, 0x61, 0x6e, 0x67, 0x24, 0x28, 0x27, 0x2e, 0x35, 0x30, 0x70, 0x78,
  0x50, 0x68, 0x2e, 0x44, 0x6d, 0x69, 0x73, 0x63, 0x61, 0x6c, 0x61, 0x6e, 0x6c,
  0x6f, 0x61, 0x6e, 0x64, 0x65, 0x73, 0x6b, 0x6d, 0x69, 0x6c, 0x65, 0x72, 0x79,
  0x61, 0x6e, 0x75, 0x6e, 0x69, 0x78, 0x64, 0x69, 0x73, 0x63, 0x29, 0x3b, 0x7d,
  0x0a, 0x64, 0x75, 0x73, 0x74, 0x63, 0x6c, 0x69, 0x70, 0x29, 0x2e, 0x0a, 0x0a,
  0x37, 0x30, 0x70, 0x78, 0x2d, 0x32, 0x30, 0x30, 0x44, 0x56, 0x44, 0x73, 0x37,
  0x5d, 0x3e, 0x3c, 0x74, 0x61, 0x70, 0x65, 0x64, 0x65, 0x6d, 0x6f, 0x69, 0x2b,
  0x2b, 0x29, 0x77, 0x61, 0x67, 0x65, 0x65, 0x75, 0x72, 0x6f, 0x70, 0x68, 0x69,
  0x6c, 0x6f, 0x70, 0x74, 0x73, 0x68, 0x6f, 0x6c, 0x65, 0x46, 0x41, 0x51, 0x73,
  0x61, 0x73, 0x69, 0x6e, 0x2d, 0x32, 0x36, 0x54, 0x6c, 0x61, 0x62, 0x73, 0x70,
  0x65, 0x74, 0x73, 0x55, 0x52, 0x4c, 0x20, 0x62, 0x75, 0x6c, 0x6b, 0x63, 0x6f,
  0x6f, 0x6b, 0x3b, 0x7d, 0x0d, 0x0a, 0x48, 0x45, 0x41, 0x44, 0x5b, 0x30, 0x5d,
  0x29, 0x61, 0x62, 0x62, 0x72, 0x6a, 0x75, 0x61, 0x6e, 0x28, 0x31, 0x39, 0x38,
  0x6c, 0x65, 0x73, 0x68, 0x74, 0x77, 0x69, 0x6e, 0x3c, 0x2f, 0x69, 0x3e, 0x73,
  0x6f, 0x6e, 0x79, 0x67, 0x75, 0x79, 0x73, 0x66, 0x75, 0x63, 0x6b, 0x70, 0x69,
  0x70, 0x65, 0x7c, 0x2d, 0x0a, 0x21, 0x30, 0x30, 0x32, 0x29, 0x6e, 0x64, 0x6f,
  0x77, 0x5b, 0x31, 0x5d, 0x3b, 0x5b, 0x5d, 0x3b, 0x0a, 0x4c, 0x6f, 0x67, 0x20,
  0x73, 0x61, 0x6c, 0x74, 0x0d, 0x0a, 0x09, 0x09, 0x62, 0x61, 0x6e, 0x67, 0x74,
  0x72, 0x69, 0x6d, 0x62, 0x61, 0x74, 0x68, 0x29, 0x7b, 0x0d, 0x0a, 0x30, 0x30,
  0x70, 0x78, 0x0a, 0x7d, 0x29, 0x3b, 0x6b, 0x6f, 0x3a, 0xec, 0x66, 0x65, 0x65,
  0x73, 0x61, 0x64, 0x3e, 0x0d, 0x73, 0x3a, 0x2f, 0x2f, 0x20, 0x5b, 0x5d, 0x3b,
  0x74, 0x6f, 0x6c, 0x6c, 0x70, 0x6c, 0x75, 0x67, 0x28, 0x29, 0x7b, 0x0a, 0x7b,
  0x0d, 0x0a, 0x20, 0x2e, 0x6a, 0x73, 0x27, 0x32, 0x30, 0x30, 0x70, 0x64, 0x75,
  0x61, 0x6c, 0x62, 0x6f, 0x61, 0x74, 0x2e, 0x4a, 0x50, 0x47, 0x29, 0x3b, 0x0a,
  0x7d, 0x71, 0x75, 0x6f, 0x74, 0x29, 0x3b, 0x0a, 0x0a, 0x27, 0x29, 0x3b, 0x0a,
  0x0d, 0x0a, 0x7d, 0x0d, 0x32, 0x30, 0x31, 0x34, 0x32, 0x30, 0x31, 0x35, 0x32,
  0x30, 0x31, 0x36, 0x32, 0x30, 0x31, 0x37, 0x32, 0x30, 0x31, 0x38, 0x32, 0x30,
  0x31, 0x39, 0x32, 0x30, 0x32, 0x30, 0x32, 0x30, 0x32, 0x31, 0x32, 0x30, 0x32,
  0x32, 0x32, 0x30, 0x32, 0x33, 0x32, 0x30, 0x32, 0x34, 0x32, 0x30, 0x32, 0x35,
  0x32, 0x30, 0x32, 0x36, 0x32, 0x30, 0x32, 0x37, 0x32, 0x30, 0x32, 0x38, 0x32,
  0x30, 0x32, 0x39, 0x32, 0x30, 0x33, 0x30, 0x32, 0x30, 0x33, 0x31, 0x32, 0x30,
  0x33, 0x32, 0x32, 0x30, 0x33, 0x33, 0x32, 0x30, 0x33, 0x34, 0x32, 0x30, 0x33,
  0x35, 0x32, 0x30, 0x33, 0x36, 0x32, 0x30, 0x33, 0x37, 0x32, 0x30, 0x31, 0x33,
  0x32, 0x30, 0x31, 0x32, 0x32, 0x30, 0x31, 0x31, 0x32, 0x30, 0x31, 0x30, 0x32,
  0x30, 0x30, 0x39, 0x32, 0x30, 0x30, 0x38, 0x32, 0x30, 0x30, 0x37, 0x32, 0x30,
  0x30, 0x36, 0x32, 0x30, 0x30, 0x35, 0x32, 0x30, 0x30, 0x34, 0x32, 0x30, 0x30,
  0x33, 0x32, 0x30, 0x30, 0x32, 0x32, 0x30, 0x30, 0x31, 0x32, 0x30, 0x30, 0x30,
  0x31, 0x39, 0x39, 0x39, 0x31, 0x39, 0x39, 0x38, 0x31, 0x39, 0x39, 0x37, 0x31,
  0x39, 0x39, 0x36, 0x31, 0x39, 0x39, 0x35, 0x31, 0x39, 0x39, 0x34, 0x31, 0x39,
  0x39, 0x33, 0x31, 0x39, 0x39, 0x32, 0x31, 0x39, 0x39, 0x31, 0x31, 0x39, 0x39,
  0x30, 0x31, 0x39, 0x38, 0x39, 0x31, 0x39, 0x38, 0x38, 0x31, 0x39, 0x38, 0x37,
  0x31, 0x39, 0x38, 0x36, 0x31, 0x39, 0x38, 0x35, 0x31, 0x39, 0x38, 0x34, 0x31,
  0x39, 0x38, 0x33, 0x31, 0x39, 0x38, 0x32, 0x31, 0x39, 0x38, 0x31, 0x31, 0x39,
  0x38, 0x30, 0x31, 0x39, 0x37, 0x39, 0x31, 0x39, 0x37, 0x38, 0x31, 0x39, 0x37,
  0x37, 0x31, 0x39, 0x37, 0x36, 0x31, 0x39, 0x37, 0x35, 0x31, 0x39, 0x37, 0x34,
  0x31, 0x39, 0x37, 0x33, 0x31, 0x39, 0x37, 0x32, 0x31, 0x39, 0x37, 0x31, 0x31,
  0x39, 0x37, 0x30, 0x31, 0x39, 0x36, 0x39, 0x31, 0x39, 0x36, 0x38, 0x31, 0x39,
  0x36, 0x37, 0x31, 0x39, 0x36, 0x36, 0x31, 0x39, 0x36, 0x35, 0x31, 0x39, 0x36,
  0x34, 0x31, 0x39, 0x36, 0x33, 0x31, 0x39, 0x36, 0x32, 0x31, 0x39, 0x36, 0x31,
  0x31, 0x39, 0x36, 0x30, 0x31, 0x39, 0x35, 0x39, 0x31, 0x39, 0x35, 0x38, 0x31,
  0x39, 0x35, 0x37, 0x31, 0x39, 0x35, 0x36, 0x31, 0x39, 0x35, 0x35, 0x31, 0x39,
  0x35, 0x34, 0x31, 0x39, 0x35, 0x33, 0x31, 0x39, 0x35, 0x32, 0x31, 0x39, 0x35,
  0x31, 0x31, 0x39, 0x35, 0x30, 0x31, 0x30, 0x30, 0x30, 0x31, 0x30, 0x32, 0x34,
  0x31, 0x33, 0x39, 0x34, 0x30, 0x30, 0x30, 0x30, 0x39, 0x39, 0x39, 0x39, 0x63,
  0x6f, 0x6d, 0x6f, 0x6d, 0xc3, 0xa1, 0x73, 0x65, 0x73, 0x74, 0x65, 0x65, 0x73,
  0x74, 0x61, 0x70, 0x65, 0x72, 0x6f, 0x74, 0x6f, 0x64, 0x6f, 0x68, 0x61, 0x63,
  0x65, 0x63, 0x61, 0x64, 0x61, 0x61, 0xc3, 0xb1, 0x6f, 0x62, 0x69, 0x65, 0x6e,
  0x64, 0xc3, 0xad, 0x61, 0x61, 0x73, 0xc3, 0xad, 0x76, 0x69, 0x64, 0x61, 0x63,
  0x61, 0x73, 0x6f, 0x6f, 0x74, 0x72, 0x6f, 0x66, 0x6f, 0x72, 0x6f, 0x73, 0x6f,
  0x6c, 0x6f, 0x6f, 0x74, 0x72, 0x61, 0x63, 0x75, 0x61, 0x6c, 0x64, 0x69, 0x6a,
  0x6f, 0x73, 0x69, 0x64, 0x6f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x69, 0x70, 0x6f,
  0x74, 0x65, 0x6d, 0x61, 0x64, 0x65, 0x62, 0x65, 0x61, 0x6c, 0x67, 0x6f, 0x71,
  0x75, 0xc3, 0xa9, 0x65, 0x73, 0x74, 0x6f, 0x6e, 0x61, 0x64, 0x61, 0x74, 0x72,
  0x65, 0x73, 0x70, 0x6f, 0x63, 0x6f, 0x63, 0x61, 0x73, 0x61, 0x62, 0x61, 0x6a,
  0x6f, 0x74, 0x6f, 0x64, 0x61, 0x73, 0x69, 0x6e, 0x6f, 0x61, 0x67, 0x75, 0x61,
  0x70, 0x75, 0x65, 0x73, 0x75, 0x6e, 0x6f, 0x73, 0x61, 0x6e, 0x74, 0x65, 0x64,
  0x69, 0x63, 0x65, 0x6c, 0x75, 0x69, 0x73, 0x65, 0x6c, 0x6c, 0x61, 0x6d, 0x61,
  0x79, 0x6f, 0x7a, 0x6f, 0x6e, 0x61, 0x61, 0x6d, 0x6f, 0x72, 0x70, 0x69, 0x73,
  0x6f, 0x6f, 0x62, 0x72, 0x61, 0x63, 0x6c, 0x69, 0x63, 0x65, 0x6c, 0x6c, 0x6f,
  0x64, 0x69, 0x6f, 0x73, 0x68, 0x6f, 0x72, 0x61, 0x63, 0x61, 0x73, 0x69, 0xd0,
  0xb7, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x80,
  0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x83, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0,
  0xb5, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xb7,
  0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd0,
  0xb6, 0xd0, 0xb5, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x85, 0xd0, 0x9d,
  0xd0, 0xb0, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xbc, 0xd1,
  0x8b, 0xd0, 0x92, 0xd1, 0x8b, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x8b,
  0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0x9d, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0,
  0x9f, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xa0,
  0xd0, 0xa4, 0xd0, 0x9d, 0xd0, 0xb5, 0xd0, 0x9c, 0xd1, 0x8b, 0xd1, 0x82, 0xd1,
  0x8b, 0xd0, 0x9e, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb4, 0xd0, 0xb0,
  0xd0, 0x97, 0xd0, 0xb0, 0xd0, 0x94, 0xd0, 0xb0, 0xd0, 0x9d, 0xd1, 0x83, 0xd0,
  0x9e, 0xd0, 0xb1, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0x98, 0xd0, 0xb7, 0xd0, 0xb5,
  0xd0, 0xb9, 0xd0, 0xbd, 0xd1, 0x83, 0xd0, 0xbc, 0xd0, 0xbc, 0xd0, 0xa2, 0xd1,
  0x8b, 0xd1, 0x83, 0xd0, 0xb6, 0xd9, 0x81, 0xd9, 0x8a, 0xd8, 0xa3, 0xd9, 0x86,
  0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 0x83, 0xd9, 0x84, 0xd8,
  0xa3, 0xd9, 0x88, 0xd8, 0xb1, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x81,
  0xd9, 0x89, 0xd9, 0x87, 0xd9, 0x88, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x84, 0xd9,
  0x83, 0xd8, 0xa7, 0xd9, 0x88, 0xd9, 0x84, 0xd9, 0x87, 0xd8, 0xa8, 0xd8, 0xb3,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa5, 0xd9, 0x86, 0xd9, 0x87, 0xd9, 0x8a, 0xd8,
  0xa3, 0xd9, 0x8a, 0xd9, 0x82, 0xd8, 0xaf, 0xd9, 0x87, 0xd9, 0x84, 0xd8, 0xab,
  0xd9, 0x85, 0xd8, 0xa8, 0xd9, 0x87, 0xd9, 0x84, 0xd9, 0x88, 0xd9, 0x84, 0xd9,
  0x8a, 0xd8, 0xa8, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x8a, 0xd8, 0xa8, 0xd9, 0x83,
  0xd8, 0xb4, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa3, 0xd9, 0x85, 0xd9,
  0x86, 0xd8, 0xaa, 0xd8, 0xa8, 0xd9, 0x8a, 0xd9, 0x84, 0xd9, 0x86, 0xd8, 0xad,
  0xd8, 0xa8, 0xd9, 0x87, 0xd9, 0x85, 0xd9, 0x85, 0xd8, 0xb4, 0xd9, 0x88, 0xd8,
  0xb4, 0x66, 0x69, 0x72, 0x73, 0x74, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x6c, 0x69,
  0x67, 0x68, 0x74, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x6d, 0x65, 0x64, 0x69, 0x61,
  0x77, 0x68, 0x69, 0x74, 0x65, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x62, 0x6c, 0x61,
  0x63, 0x6b, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x62,
  0x6f, 0x6f, 0x6b, 0x73, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x6d, 0x75, 0x73, 0x69,
  0x63, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x70, 0x6f,
  0x69, 0x6e, 0x74, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x6c, 0x65, 0x76, 0x65, 0x6c,
  0x74, 0x61, 0x62, 0x6c, 0x65, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x68, 0x6f, 0x75,
  0x73, 0x65, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x79,
  0x65, 0x61, 0x72, 0x73, 0x73, 0x74, 0x61, 0x74, 0x65, 0x74, 0x6f, 0x64, 0x61,
  0x79, 0x77, 0x61, 0x74, 0x65, 0x72, 0x73, 0x74, 0x61, 0x72, 0x74, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x64, 0x65, 0x61, 0x74, 0x68, 0x70, 0x6f, 0x77, 0x65, 0x72,
  0x70, 0x68, 0x6f, 0x6e, 0x65, 0x6e, 0x69, 0x67, 0x68, 0x74, 0x65, 0x72, 0x72,
  0x6f, 0x72, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x74,
  0x65, 0x72, 0x6d, 0x73, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x74, 0x6f, 0x6f, 0x6c,
  0x73, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x74, 0x69,
  0x6d, 0x65, 0x73, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x77, 0x6f, 0x72, 0x64, 0x73,
  0x67, 0x61, 0x6d, 0x65, 0x73, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x73, 0x70, 0x61,
  0x63, 0x65, 0x66, 0x6f, 0x63, 0x75, 0x73, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x6d,
  0x6f, 0x64, 0x65, 0x6c, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x67, 0x75, 0x69, 0x64,
  0x65, 0x72, 0x61, 0x64, 0x69, 0x6f, 0x73, 0x68, 0x61, 0x72, 0x65, 0x77, 0x6f,
  0x6d, 0x65, 0x6e, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x6d, 0x6f, 0x6e, 0x65, 0x79,
  0x69, 0x6d, 0x61, 0x67, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x79, 0x6f, 0x75,
  0x6e, 0x67, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x63,
  0x6f, 0x6c, 0x6f, 0x72, 0x67, 0x72, 0x65, 0x65, 0x6e, 0x66, 0x72, 0x6f, 0x6e,
  0x74, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x77, 0x61, 0x74, 0x63, 0x68, 0x66, 0x6f,
  0x72, 0x63, 0x65, 0x70, 0x72, 0x69, 0x63, 0x65, 0x72, 0x75, 0x6c, 0x65, 0x73,
  0x62, 0x65, 0x67, 0x69, 0x6e, 0x61, 0x66, 0x74, 0x65, 0x72, 0x76, 0x69, 0x73,
  0x69, 0x74, 0x69, 0x73, 0x73, 0x75, 0x65, 0x61, 0x72, 0x65, 0x61, 0x73, 0x62,
  0x65, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x74, 0x6f, 0x74, 0x61,
  0x6c, 0x68, 0x6f, 0x75, 0x72, 0x73, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x70, 0x72,
  0x69, 0x6e, 0x74, 0x70, 0x72, 0x65, 0x73, 0x73, 0x62, 0x75, 0x69, 0x6c, 0x74,
  0x6c, 0x69, 0x6e, 0x6b, 0x73, 0x73, 0x70, 0x65, 0x65, 0x64, 0x73, 0x74, 0x75,
  0x64, 0x79, 0x74, 0x72, 0x61, 0x64, 0x65, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x73,
  0x65, 0x6e, 0x73, 0x65, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x77,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x61, 0x64,
  0x64, 0x65, 0x64, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x6d, 0x6f, 0x76, 0x65, 0x64,
  0x74, 0x61, 0x6b, 0x65, 0x6e, 0x61, 0x62, 0x6f, 0x76, 0x65, 0x66, 0x6c, 0x61,
  0x73, 0x68, 0x66, 0x69, 0x78, 0x65, 0x64, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x73, 0x63, 0x68, 0x65, 0x63,
  0x6b, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x72, 0x69, 0x76, 0x65, 0x72, 0x69, 0x74,
  0x65, 0x6d, 0x73, 0x71, 0x75, 0x69, 0x63, 0x6b, 0x73, 0x68, 0x61, 0x70, 0x65,
  0x68, 0x75, 0x6d, 0x61, 0x6e, 0x65, 0x78, 0x69, 0x73, 0x74, 0x67, 0x6f, 0x69,
  0x6e, 0x67, 0x6d, 0x6f, 0x76, 0x69, 0x65, 0x74, 0x68, 0x69, 0x72, 0x64, 0x62,
  0x61, 0x73, 0x69, 0x63, 0x70, 0x65, 0x61, 0x63, 0x65, 0x73, 0x74, 0x61, 0x67,
  0x65, 0x77, 0x69, 0x64, 0x74, 0x68, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x69, 0x64,
  0x65, 0x61, 0x73, 0x77, 0x72, 0x6f, 0x74, 0x65, 0x70, 0x61, 0x67, 0x65, 0x73,
  0x75, 0x73, 0x65, 0x72, 0x73, 0x64, 0x72, 0x69, 0x76, 0x65, 0x73, 0x74, 0x6f,
  0x72, 0x65, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x76,
  0x6f, 0x69, 0x63, 0x65, 0x73, 0x69, 0x74, 0x65, 0x73, 0x6d, 0x6f, 0x6e, 0x74,
  0x68, 0x77, 0x68, 0x65, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x77, 0x68,
  0x69, 0x63, 0x68, 0x65, 0x61, 0x72, 0x74, 0x68, 0x66, 0x6f, 0x72, 0x75, 0x6d,
  0x74, 0x68, 0x72, 0x65, 0x65, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x70, 0x61, 0x72,
  0x74, 0x79, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x6c,
  0x69, 0x76, 0x65, 0x73, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x6c, 0x61, 0x79, 0x65,
  0x72, 0x65, 0x6e, 0x74, 0x72, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x75, 0x73,
  0x61, 0x67, 0x65, 0x73, 0x6f, 0x75, 0x6e, 0x64, 0x63, 0x6f, 0x75, 0x72, 0x74,
  0x79, 0x6f, 0x75, 0x72, 0x20, 0x62, 0x69, 0x72, 0x74, 0x68, 0x70, 0x6f, 0x70,
  0x75, 0x70, 0x74, 0x79, 0x70, 0x65, 0x73, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x49,
  0x6d, 0x61, 0x67, 0x65, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x75, 0x70, 0x70, 0x65,
  0x72, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x65, 0x76, 0x65, 0x72, 0x79, 0x73, 0x68,
  0x6f, 0x77, 0x73, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x65, 0x78, 0x74, 0x72, 0x61,
  0x6d, 0x61, 0x74, 0x63, 0x68, 0x74, 0x72, 0x61, 0x63, 0x6b, 0x6b, 0x6e, 0x6f,
  0x77, 0x6e, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x62, 0x65, 0x67, 0x61, 0x6e, 0x73,
  0x75, 0x70, 0x65, 0x72, 0x70, 0x61, 0x70, 0x65, 0x72, 0x6e, 0x6f, 0x72, 0x74,
  0x68, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x6e, 0x61,
  0x6d, 0x65, 0x64, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x54, 0x65, 0x72, 0x6d, 0x73,
  0x70, 0x61, 0x72, 0x74, 0x73, 0x47, 0x72, 0x6f, 0x75, 0x70, 0x62, 0x72, 0x61,
  0x6e, 0x64, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x77, 0x6f, 0x6d, 0x61, 0x6e, 0x66,
  0x61, 0x6c, 0x73, 0x65, 0x72, 0x65, 0x61, 0x64, 0x79, 0x61, 0x75, 0x64, 0x69,
  0x6f, 0x74, 0x61, 0x6b, 0x65, 0x73, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x2e, 0x63,
  0x6f, 0x6d, 0x2f, 0x6c, 0x69, 0x76, 0x65, 0x64, 0x63, 0x61, 0x73, 0x65, 0x73,
  0x64, 0x61, 0x69, 0x6c, 0x79, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x67, 0x72, 0x65,
  0x61, 0x74, 0x6a, 0x75, 0x64, 0x67, 0x65, 0x74, 0x68, 0x6f, 0x73, 0x65, 0x75,
  0x6e, 0x69, 0x74, 0x73, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x62, 0x72, 0x6f, 0x61,
  0x64, 0x63, 0x6f, 0x61, 0x73, 0x74, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x70,
  0x70, 0x6c, 0x65, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x63, 0x79, 0x63, 0x6c, 0x65,
  0x73, 0x63, 0x65, 0x6e, 0x65, 0x70, 0x6c, 0x61, 0x6e, 0x73, 0x63, 0x6c, 0x69,
  0x63, 0x6b, 0x77, 0x72, 0x69, 0x74, 0x65, 0x71, 0x75, 0x65, 0x65, 0x6e, 0x70,
  0x69, 0x65, 0x63, 0x65, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x66, 0x72, 0x61, 0x6d,
  0x65, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x6c, 0x69,
  0x6d, 0x69, 0x74, 0x63, 0x61, 0x63, 0x68, 0x65, 0x63, 0x69, 0x76, 0x69, 0x6c,
  0x73, 0x63, 0x61, 0x6c, 0x65, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x74, 0x68, 0x65,
  0x6d, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x74, 0x6f, 0x75, 0x63, 0x68, 0x62,
  0x6f, 0x75, 0x6e, 0x64, 0x72, 0x6f, 0x79, 0x61, 0x6c, 0x61, 0x73, 0x6b, 0x65,
  0x64, 0x77, 0x68, 0x6f, 0x6c, 0x65, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x73, 0x74,
  0x6f, 0x63, 0x6b, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x66, 0x61, 0x69, 0x74, 0x68,
  0x68, 0x65, 0x61, 0x72, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x6f, 0x66, 0x66,
  0x65, 0x72, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x6f, 0x77, 0x6e, 0x65, 0x64, 0x6d,
  0x69, 0x67, 0x68, 0x74, 0x61, 0x6c, 0x62, 0x75, 0x6d, 0x74, 0x68, 0x69, 0x6e,
  0x6b, 0x62, 0x6c, 0x6f, 0x6f, 0x64, 0x61, 0x72, 0x72, 0x61, 0x79, 0x6d, 0x61,
  0x6a, 0x6f, 0x72, 0x74, 0x72, 0x75, 0x73, 0x74, 0x63, 0x61, 0x6e, 0x6f, 0x6e,
  0x75, 0x6e, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x76, 0x61, 0x6c,
  0x69, 0x64, 0x73, 0x74, 0x6f, 0x6e, 0x65, 0x53, 0x74, 0x79, 0x6c, 0x65, 0x4c,
  0x6f, 0x67, 0x69, 0x6e, 0x68, 0x61, 0x70, 0x70, 0x79, 0x6f, 0x63, 0x63, 0x75,
  0x72, 0x6c, 0x65, 0x66, 0x74, 0x3a, 0x66, 0x72, 0x65, 0x73, 0x68, 0x71, 0x75,
  0x69, 0x74, 0x65, 0x66, 0x69, 0x6c, 0x6d, 0x73, 0x67, 0x72, 0x61, 0x64, 0x65,
  0x6e, 0x65, 0x65, 0x64, 0x73, 0x75, 0x72, 0x62, 0x61, 0x6e, 0x66, 0x69, 0x67,
  0x68, 0x74, 0x62, 0x61, 0x73, 0x69, 0x73, 0x68, 0x6f, 0x76, 0x65, 0x72, 0x61,
  0x75, 0x74, 0x6f, 0x3b, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x68, 0x74, 0x6d,
  0x6c, 0x6d, 0x69, 0x78, 0x65, 0x64, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x59, 0x6f,
  0x75, 0x72, 0x20, 0x73, 0x6c, 0x69, 0x64, 0x65, 0x74, 0x6f, 0x70, 0x69, 0x63,
  0x62, 0x72, 0x6f, 0x77, 0x6e, 0x61, 0x6c, 0x6f, 0x6e, 0x65, 0x64, 0x72, 0x61,
  0x77, 0x6e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x72, 0x65, 0x61, 0x63, 0x68, 0x52,
  0x69, 0x67, 0x68, 0x74, 0x64, 0x61, 0x74, 0x65, 0x73, 0x6d, 0x61, 0x72, 0x63,
  0x68, 0x71, 0x75, 0x6f, 0x74, 0x65, 0x67, 0x6f, 0x6f, 0x64, 0x73, 0x4c, 0x69,
  0x6e, 0x6b, 0x73, 0x64, 0x6f, 0x75, 0x62, 0x74, 0x61, 0x73, 0x79, 0x6e, 0x63,
  0x74, 0x68, 0x75, 0x6d, 0x62, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x63, 0x68, 0x69,
  0x65, 0x66, 0x79, 0x6f, 0x75, 0x74, 0x68, 0x6e, 0x6f, 0x76, 0x65, 0x6c, 0x31,
  0x30, 0x70, 0x78, 0x3b, 0x73, 0x65, 0x72, 0x76, 0x65, 0x75, 0x6e, 0x74, 0x69,
  0x6c, 0x68, 0x61, 0x6e, 0x64, 0x73, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x53, 0x70,
  0x61, 0x63, 0x65, 0x71, 0x75, 0x65, 0x72, 0x79, 0x6a, 0x61, 0x6d, 0x65, 0x73,
  0x65, 0x71, 0x75, 0x61, 0x6c, 0x74, 0x77, 0x69, 0x63, 0x65, 0x30, 0x2c, 0x30,
  0x30, 0x30, 0x53, 0x74, 0x61, 0x72, 0x74, 0x70, 0x61, 0x6e, 0x65, 0x6c, 0x73,
  0x6f, 0x6e, 0x67, 0x73, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x73, 0x68, 0x69, 0x66, 0x74, 0x77, 0x6f, 0x72, 0x74, 0x68, 0x70, 0x6f,
  0x73, 0x74, 0x73, 0x6c, 0x65, 0x61, 0x64, 0x73, 0x77, 0x65, 0x65, 0x6b, 0x73,
  0x61, 0x76, 0x6f, 0x69, 0x64, 0x74, 0x68, 0x65, 0x73, 0x65, 0x6d, 0x69, 0x6c,
  0x65, 0x73, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x73, 0x6d, 0x61, 0x72, 0x74, 0x61,
  0x6c, 0x70, 0x68, 0x61, 0x70, 0x6c, 0x61, 0x6e, 0x74, 0x6d, 0x61, 0x72, 0x6b,
  0x73, 0x72, 0x61, 0x74, 0x65, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x63, 0x6c,
  0x61, 0x69, 0x6d, 0x73, 0x61, 0x6c, 0x65, 0x73, 0x74, 0x65, 0x78, 0x74, 0x73,
  0x73, 0x74, 0x61, 0x72, 0x73, 0x77, 0x72, 0x6f, 0x6e, 0x67, 0x3c, 0x2f, 0x68,
  0x33, 0x3e, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x6d,
  0x75, 0x6c, 0x74, 0x69, 0x68, 0x65, 0x61, 0x72, 0x64, 0x50, 0x6f, 0x77, 0x65,
  0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x6f,
  0x6c, 0x69, 0x64, 0x28, 0x74, 0x68, 0x69, 0x73, 0x62, 0x72, 0x69, 0x6e, 0x67,
  0x73, 0x68, 0x69, 0x70, 0x73, 0x73, 0x74, 0x61, 0x66, 0x66, 0x74, 0x72, 0x69,
  0x65, 0x64, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x66,
  0x61, 0x63, 0x74, 0x73, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x54, 0x68, 0x69, 0x73,
  0x20, 0x2f, 0x2f, 0x2d, 0x2d, 0x3e, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x65, 0x67,
  0x79, 0x70, 0x74, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x31, 0x35, 0x70, 0x78, 0x3b,
  0x45, 0x6d, 0x61, 0x69, 0x6c, 0x74, 0x72, 0x75, 0x65, 0x22, 0x63, 0x72, 0x6f,
  0x73, 0x73, 0x73, 0x70, 0x65, 0x6e, 0x74, 0x62, 0x6c, 0x6f, 0x67, 0x73, 0x62,
  0x6f, 0x78, 0x22, 0x3e, 0x6e, 0x6f, 0x74, 0x65, 0x64, 0x6c, 0x65, 0x61, 0x76,
  0x65, 0x63, 0x68, 0x69, 0x6e, 0x61, 0x73, 0x69, 0x7a, 0x65, 0x73, 0x67, 0x75,
  0x65, 0x73, 0x74, 0x3c, 0x2f, 0x68, 0x34, 0x3e, 0x72, 0x6f, 0x62, 0x6f, 0x74,
  0x68, 0x65, 0x61, 0x76, 0x79, 0x74, 0x72, 0x75, 0x65, 0x2c, 0x73, 0x65, 0x76,
  0x65, 0x6e, 0x67, 0x72, 0x61, 0x6e, 0x64, 0x63, 0x72, 0x69, 0x6d, 0x65, 0x73,
  0x69, 0x67, 0x6e, 0x73, 0x61, 0x77, 0x61, 0x72, 0x65, 0x64, 0x61, 0x6e, 0x63,
  0x65, 0x70, 0x68, 0x61, 0x73, 0x65, 0x3e, 0x3c, 0x21, 0x2d, 0x2d, 0x65, 0x6e,
  0x5f, 0x55, 0x53, 0x26, 0x23, 0x33, 0x39, 0x3b, 0x32, 0x30, 0x30, 0x70, 0x78,
  0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x65, 0x6e, 0x6a,
  0x6f, 0x79, 0x61, 0x6a, 0x61, 0x78, 0x2e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x6d, 0x69, 0x74, 0x68, 0x55, 0x2e, 0x53, 0x2e, 0x20, 0x68, 0x6f, 0x6c, 0x64,
  0x73, 0x70, 0x65, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x61,
  0x76, 0x22, 0x3e, 0x63, 0x68, 0x61, 0x69, 0x6e, 0x73, 0x63, 0x6f, 0x72, 0x65,
  0x63, 0x6f, 0x6d, 0x65, 0x73, 0x64, 0x6f, 0x69, 0x6e, 0x67, 0x70, 0x72, 0x69,
  0x6f, 0x72, 0x53, 0x68, 0x61, 0x72, 0x65, 0x31, 0x39, 0x39, 0x30, 0x73, 0x72,
  0x6f, 0x6d, 0x61, 0x6e, 0x6c, 0x69, 0x73, 0x74, 0x73, 0x6a, 0x61, 0x70, 0x61,
  0x6e, 0x66, 0x61, 0x6c, 0x6c, 0x73, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x6f, 0x77,
  0x6e, 0x65, 0x72, 0x61, 0x67, 0x72, 0x65, 0x65, 0x3c, 0x2f, 0x68, 0x32, 0x3e,
  0x61, 0x62, 0x75, 0x73, 0x65, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x6f, 0x70, 0x65,
  0x72, 0x61, 0x22, 0x2d, 0x2f, 0x2f, 0x57, 0x63, 0x61, 0x72, 0x64, 0x73, 0x68,
  0x69, 0x6c, 0x6c, 0x73, 0x74, 0x65, 0x61, 0x6d, 0x73, 0x50, 0x68, 0x6f, 0x74,
  0x6f, 0x74, 0x72, 0x75, 0x74, 0x68, 0x63, 0x6c, 0x65, 0x61, 0x6e, 0x2e, 0x70,
  0x68, 0x70, 0x3f, 0x73, 0x61, 0x69, 0x6e, 0x74, 0x6d, 0x65, 0x74, 0x61, 0x6c,
  0x6c, 0x6f, 0x75, 0x69, 0x73, 0x6d, 0x65, 0x61, 0x6e, 0x74, 0x70, 0x72, 0x6f,
  0x6f, 0x66, 0x62, 0x72, 0x69, 0x65, 0x66, 0x72, 0x6f, 0x77, 0x22, 0x3e, 0x67,
  0x65, 0x6e, 0x72, 0x65, 0x74, 0x72, 0x75, 0x63, 0x6b, 0x6c, 0x6f, 0x6f, 0x6b,
  0x73, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x46, 0x72, 0x61, 0x6d, 0x65, 0x2e, 0x6e,
  0x65, 0x74, 0x2f, 0x2d, 0x2d, 0x3e, 0x0a, 0x3c, 0x74, 0x72, 0x79, 0x20, 0x7b,
  0x0a, 0x76, 0x61, 0x72, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x73, 0x63, 0x6f, 0x73,
  0x74, 0x73, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x61, 0x64, 0x75, 0x6c, 0x74, 0x71,
  0x75, 0x65, 0x73, 0x74, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x6c, 0x61, 0x62, 0x6f,
  0x72, 0x68, 0x65, 0x6c, 0x70, 0x73, 0x63, 0x61, 0x75, 0x73, 0x65, 0x6d, 0x61,
  0x67, 0x69, 0x63, 0x6d, 0x6f, 0x74, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x69, 0x72,
  0x32, 0x35, 0x30, 0x70, 0x78, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x73, 0x74, 0x65,
  0x70, 0x73, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x63, 0x6f, 0x75, 0x6c, 0x64, 0x67,
  0x6c, 0x61, 0x73, 0x73, 0x73, 0x69, 0x64, 0x65, 0x73, 0x66, 0x75, 0x6e, 0x64,
  0x73, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x61, 0x77, 0x61, 0x72, 0x64, 0x6d, 0x6f,
  0x75, 0x74, 0x68, 0x6d, 0x6f, 0x76, 0x65, 0x73, 0x70, 0x61, 0x72, 0x69, 0x73,
  0x67, 0x69, 0x76, 0x65, 0x73, 0x64, 0x75, 0x74, 0x63, 0x68, 0x74, 0x65, 0x78,
  0x61, 0x73, 0x66, 0x72, 0x75, 0x69, 0x74, 0x6e, 0x75, 0x6c, 0x6c, 0x2c, 0x7c,
  0x7c, 0x5b, 0x5d, 0x3b, 0x74, 0x6f, 0x70, 0x22, 0x3e, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x50, 0x4f, 0x53, 0x54, 0x22, 0x6f, 0x63, 0x65, 0x61, 0x6e, 0x3c, 0x62,
  0x72, 0x2f, 0x3e, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x73, 0x70, 0x65, 0x61, 0x6b,
  0x64, 0x65, 0x70, 0x74, 0x68, 0x20, 0x73, 0x69, 0x7a, 0x65, 0x62, 0x61, 0x6e,
  0x6b, 0x73, 0x63, 0x61, 0x74, 0x63, 0x68, 0x63, 0x68, 0x61, 0x72, 0x74, 0x32,
  0x30, 0x70, 0x78, 0x3b, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x64, 0x65, 0x61, 0x6c,
  0x73, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x35, 0x30, 0x70, 0x78, 0x3b, 0x75, 0x72,
  0x6c, 0x3d, 0x22, 0x70, 0x61, 0x72, 0x6b, 0x73, 0x6d, 0x6f, 0x75, 0x73, 0x65,
  0x4d, 0x6f, 0x73, 0x74, 0x20, 0x2e, 0x2e, 0x2e, 0x3c, 0x2f, 0x61, 0x6d, 0x6f,
  0x6e, 0x67, 0x62, 0x72, 0x61, 0x69, 0x6e, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x6e,
  0x6f, 0x6e, 0x65, 0x3b, 0x62, 0x61, 0x73, 0x65, 0x64, 0x63, 0x61, 0x72, 0x72,
  0x79, 0x64, 0x72, 0x61, 0x66, 0x74, 0x72, 0x65, 0x66, 0x65, 0x72, 0x70, 0x61,
  0x67, 0x65, 0x5f, 0x68, 0x6f, 0x6d, 0x65, 0x2e, 0x6d, 0x65, 0x74, 0x65, 0x72,
  0x64, 0x65, 0x6c, 0x61, 0x79, 0x64, 0x72, 0x65, 0x61, 0x6d, 0x70, 0x72, 0x6f,
  0x76, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x74, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x64,
  0x72, 0x75, 0x67, 0x73, 0x3c, 0x21, 0x2d, 0x2d, 0x20, 0x61, 0x70, 0x72, 0x69,
  0x6c, 0x69, 0x64, 0x65, 0x61, 0x6c, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x65, 0x78,
  0x61, 0x63, 0x74, 0x66, 0x6f, 0x72, 0x74, 0x68, 0x63, 0x6f, 0x64, 0x65, 0x73,
  0x6c, 0x6f, 0x67, 0x69, 0x63, 0x56, 0x69, 0x65, 0x77, 0x20, 0x73, 0x65, 0x65,
  0x6d, 0x73, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x20,
  0x28, 0x32, 0x30, 0x30, 0x73, 0x61, 0x76, 0x65, 0x64, 0x5f, 0x6c, 0x69, 0x6e,
  0x6b, 0x67, 0x6f, 0x61, 0x6c, 0x73, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x67, 0x72,
  0x65, 0x65, 0x6b, 0x68, 0x6f, 0x6d, 0x65, 0x73, 0x72, 0x69, 0x6e, 0x67, 0x73,
  0x72, 0x61, 0x74, 0x65, 0x64, 0x33, 0x30, 0x70, 0x78, 0x3b, 0x77, 0x68, 0x6f,
  0x73, 0x65, 0x70, 0x61, 0x72, 0x73, 0x65, 0x28, 0x29, 0x3b, 0x22, 0x20, 0x42,
  0x6c, 0x6f, 0x63, 0x6b, 0x6c, 0x69, 0x6e, 0x75, 0x78, 0x6a, 0x6f, 0x6e, 0x65,
  0x73, 0x70, 0x69, 0x78, 0x65, 0x6c, 0x27, 0x29, 0x3b, 0x22, 0x3e, 0x29, 0x3b,
  0x69, 0x66, 0x28, 0x2d, 0x6c, 0x65, 0x66, 0x74, 0x64, 0x61, 0x76, 0x69, 0x64,
  0x68, 0x6f, 0x72, 0x73, 0x65, 0x46, 0x6f, 0x63, 0x75, 0x73, 0x72, 0x61, 0x69,
  0x73, 0x65, 0x62, 0x6f, 0x78, 0x65, 0x73, 0x54, 0x72, 0x61, 0x63, 0x6b, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x3c, 0x2f, 0x65, 0x6d, 0x3e, 0x62, 0x61, 0x72, 0x22,
  0x3e, 0x2e, 0x73, 0x72, 0x63, 0x3d, 0x74, 0x6f, 0x77, 0x65, 0x72, 0x61, 0x6c,
  0x74, 0x3d, 0x22, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x68, 0x65, 0x6e, 0x72, 0x79,
  0x32, 0x34, 0x70, 0x78, 0x3b, 0x73, 0x65, 0x74, 0x75, 0x70, 0x69, 0x74, 0x61,
  0x6c, 0x79, 0x73, 0x68, 0x61, 0x72, 0x70, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x74,
  0x61, 0x73, 0x74, 0x65, 0x77, 0x61, 0x6e, 0x74, 0x73, 0x74, 0x68, 0x69, 0x73,
  0x2e, 0x72, 0x65, 0x73, 0x65, 0x74, 0x77, 0x68, 0x65, 0x65, 0x6c, 0x67, 0x69,
  0x72, 0x6c, 0x73, 0x2f, 0x63, 0x73, 0x73, 0x2f, 0x31, 0x30, 0x30, 0x25, 0x3b,
  0x63, 0x6c, 0x75, 0x62, 0x73, 0x73, 0x74, 0x75, 0x66, 0x66, 0x62, 0x69, 0x62,
  0x6c, 0x65, 0x76, 0x6f, 0x74, 0x65, 0x73, 0x20, 0x31, 0x30, 0x30, 0x30, 0x6b,
  0x6f, 0x72, 0x65, 0x61, 0x7d, 0x29, 0x3b, 0x0d, 0x0a, 0x62, 0x61, 0x6e, 0x64,
  0x73, 0x71, 0x75, 0x65, 0x75, 0x65, 0x3d, 0x20, 0x7b, 0x7d, 0x3b, 0x38, 0x30,
  0x70, 0x78, 0x3b, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x7b, 0x0d, 0x0a, 0x09, 0x09,
  0x61, 0x68, 0x65, 0x61, 0x64, 0x63, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x72, 0x69,
  0x73, 0x68, 0x6c, 0x69, 0x6b, 0x65, 0x20, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x73,
  0x74, 0x61, 0x74, 0x73, 0x46, 0x6f, 0x72, 0x6d, 0x22, 0x79, 0x61, 0x68, 0x6f,
  0x6f, 0x29, 0x5b, 0x30, 0x5d, 0x3b, 0x41, 0x62, 0x6f, 0x75, 0x74, 0x66, 0x69,
  0x6e, 0x64, 0x73, 0x3c, 0x2f, 0x68, 0x31, 0x3e, 0x64, 0x65, 0x62, 0x75, 0x67,
  0x74, 0x61, 0x73, 0x6b, 0x73, 0x55, 0x52, 0x4c, 0x20, 0x3d, 0x63, 0x65, 0x6c,
  0x6c, 0x73, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x31, 0x32, 0x70, 0x78, 0x3b, 0x70,
  0x72, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x6c, 0x6c, 0x73, 0x74, 0x75, 0x72, 0x6e,
  0x73, 0x30, 0x78, 0x36, 0x30, 0x30, 0x2e, 0x6a, 0x70, 0x67, 0x22, 0x73, 0x70,
  0x61, 0x69, 0x6e, 0x62, 0x65, 0x61, 0x63, 0x68, 0x74, 0x61, 0x78, 0x65, 0x73,
  0x6d, 0x69, 0x63, 0x72, 0x6f, 0x61, 0x6e, 0x67, 0x65, 0x6c, 0x2d, 0x2d, 0x3e,
  0x3c, 0x2f, 0x67, 0x69, 0x66, 0x74, 0x73, 0x73, 0x74, 0x65, 0x76, 0x65, 0x2d,
  0x6c, 0x69, 0x6e, 0x6b, 0x62, 0x6f, 0x64, 0x79, 0x2e, 0x7d, 0x29, 0x3b, 0x0a,
  0x09, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x28, 0x31, 0x39, 0x39, 0x46, 0x41,
  0x51, 0x3c, 0x2f, 0x72, 0x6f, 0x67, 0x65, 0x72, 0x66, 0x72, 0x61, 0x6e, 0x6b,
  0x43, 0x6c, 0x61, 0x73, 0x73, 0x32, 0x38, 0x70, 0x78, 0x3b, 0x66, 0x65, 0x65,
  0x64, 0x73, 0x3c, 0x68, 0x31, 0x3e, 0x3c, 0x73, 0x63, 0x6f, 0x74, 0x74, 0x74,
  0x65, 0x73, 0x74, 0x73, 0x32, 0x32, 0x70, 0x78, 0x3b, 0x64, 0x72, 0x69, 0x6e,
  0x6b, 0x29, 0x20, 0x7c, 0x7c, 0x20, 0x6c, 0x65, 0x77, 0x69, 0x73, 0x73, 0x68,
  0x61, 0x6c, 0x6c, 0x23, 0x30, 0x33, 0x39, 0x3b, 0x20, 0x66, 0x6f, 0x72, 0x20,
  0x6c, 0x6f, 0x76, 0x65, 0x64, 0x77, 0x61, 0x73, 0x74, 0x65, 0x30, 0x30, 0x70,
  0x78, 0x3b, 0x6a, 0x61, 0x3a, 0xe3, 0x82, 0x73, 0x69, 0x6d, 0x6f, 0x6e, 0x3c,
  0x66, 0x6f, 0x6e, 0x74, 0x72, 0x65, 0x70, 0x6c, 0x79, 0x6d, 0x65, 0x65, 0x74,
  0x73, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x68, 0x65, 0x61, 0x70, 0x74, 0x69,
  0x67, 0x68, 0x74, 0x42, 0x72, 0x61, 0x6e, 0x64, 0x29, 0x20, 0x21, 0x3d, 0x20,
  0x64, 0x72, 0x65, 0x73, 0x73, 0x63, 0x6c, 0x69, 0x70, 0x73, 0x72, 0x6f, 0x6f,
  0x6d, 0x73, 0x6f, 0x6e, 0x6b, 0x65, 0x79, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x6d,
  0x61, 0x69, 0x6e, 0x2e, 0x4e, 0x61, 0x6d, 0x65, 0x20, 0x70, 0x6c, 0x61, 0x74,
  0x65, 0x66, 0x75, 0x6e, 0x6e, 0x79, 0x74, 0x72, 0x65, 0x65, 0x73, 0x63, 0x6f,
  0x6d, 0x2f, 0x22, 0x31, 0x2e, 0x6a, 0x70, 0x67, 0x77, 0x6d, 0x6f, 0x64, 0x65,
  0x70, 0x61, 0x72, 0x61, 0x6d, 0x53, 0x54, 0x41, 0x52, 0x54, 0x6c, 0x65, 0x66,
  0x74, 0x20, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x2c, 0x20, 0x32, 0x30, 0x31, 0x29,
  0x3b, 0x0a, 0x7d, 0x0a, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x69, 0x72, 0x75,
  0x73, 0x63, 0x68, 0x61, 0x69, 0x72, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x77, 0x6f,
  0x72, 0x73, 0x74, 0x50, 0x61, 0x67, 0x65, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x70, 0x61, 0x74, 0x63, 0x68, 0x3c, 0x21, 0x2d, 0x2d, 0x0a, 0x6f, 0x2d, 0x63,
  0x61, 0x63, 0x66, 0x69, 0x72, 0x6d, 0x73, 0x74, 0x6f, 0x75, 0x72, 0x73, 0x2c,
  0x30, 0x30, 0x30, 0x20, 0x61, 0x73, 0x69, 0x61, 0x6e, 0x69, 0x2b, 0x2b, 0x29,
  0x7b, 0x61, 0x64, 0x6f, 0x62, 0x65, 0x27, 0x29, 0x5b, 0x30, 0x5d, 0x69, 0x64,
  0x3d, 0x31, 0x30, 0x62, 0x6f, 0x74, 0x68, 0x3b, 0x6d, 0x65, 0x6e, 0x75, 0x20,
  0x2e, 0x32, 0x2e, 0x6d, 0x69, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x6b, 0x65, 0x76,
  0x69, 0x6e, 0x63, 0x6f, 0x61, 0x63, 0x68, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x62,
  0x72, 0x75, 0x63, 0x65, 0x32, 0x2e, 0x6a, 0x70, 0x67, 0x55, 0x52, 0x4c, 0x29,
  0x2b, 0x2e, 0x6a, 0x70, 0x67, 0x7c, 0x73, 0x75, 0x69, 0x74, 0x65, 0x73, 0x6c,
  0x69, 0x63, 0x65, 0x68, 0x61, 0x72, 0x72, 0x79, 0x31, 0x32, 0x30, 0x22, 0x20,
  0x73, 0x77, 0x65, 0x65, 0x74, 0x74, 0x72, 0x3e, 0x0d, 0x0a, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x64, 0x69, 0x65, 0x67, 0x6f, 0x70, 0x61, 0x67, 0x65, 0x20, 0x73,
  0x77, 0x69, 0x73, 0x73, 0x2d, 0x2d, 0x3e, 0x0a, 0x0a, 0x23, 0x66, 0x66, 0x66,
  0x3b, 0x22, 0x3e, 0x4c, 0x6f, 0x67, 0x2e, 0x63, 0x6f, 0x6d, 0x22, 0x74, 0x72,
  0x65, 0x61, 0x74, 0x73, 0x68, 0x65, 0x65, 0x74, 0x29, 0x20, 0x26, 0x26, 0x20,
  0x31, 0x34, 0x70, 0x78, 0x3b, 0x73, 0x6c, 0x65, 0x65, 0x70, 0x6e, 0x74, 0x65,
  0x6e, 0x74, 0x66, 0x69, 0x6c, 0x65, 0x64, 0x6a, 0x61, 0x3a, 0xe3, 0x83, 0x69,
  0x64, 0x3d, 0x22, 0x63, 0x4e, 0x61, 0x6d, 0x65, 0x22, 0x77, 0x6f, 0x72, 0x73,
  0x65, 0x73, 0x68, 0x6f, 0x74, 0x73, 0x2d, 0x62, 0x6f, 0x78, 0x2d, 0x64, 0x65,
  0x6c, 0x74, 0x61, 0x0a, 0x26, 0x6c, 0x74, 0x3b, 0x62, 0x65, 0x61, 0x72, 0x73,
  0x3a, 0x34, 0x38, 0x5a, 0x3c, 0x64, 0x61, 0x74, 0x61, 0x2d, 0x72, 0x75, 0x72,
  0x61, 0x6c, 0x3c, 0x2f, 0x61, 0x3e, 0x20, 0x73, 0x70, 0x65, 0x6e, 0x64, 0x62,
  0x61, 0x6b, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x70, 0x73, 0x3d, 0x20, 0x22, 0x22,
  0x3b, 0x70, 0x68, 0x70, 0x22, 0x3e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x31, 0x33,
  0x70, 0x78, 0x3b, 0x62, 0x72, 0x69, 0x61, 0x6e, 0x68, 0x65, 0x6c, 0x6c, 0x6f,
  0x73, 0x69, 0x7a, 0x65, 0x3d, 0x6f, 0x3d, 0x25, 0x32, 0x46, 0x20, 0x6a, 0x6f,
  0x69, 0x6e, 0x6d, 0x61, 0x79, 0x62, 0x65, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x69,
  0x6d, 0x67, 0x22, 0x3e, 0x2c, 0x20, 0x66, 0x6a, 0x73, 0x69, 0x6d, 0x67, 0x22,
  0x20, 0x22, 0x29, 0x5b, 0x30, 0x5d, 0x4d, 0x54, 0x6f, 0x70, 0x42, 0x54, 0x79,
  0x70, 0x65, 0x22, 0x6e, 0x65, 0x77, 0x6c, 0x79, 0x44, 0x61, 0x6e, 0x73, 0x6b,
  0x63, 0x7a, 0x65, 0x63, 0x68, 0x74, 0x72, 0x61, 0x69, 0x6c, 0x6b, 0x6e, 0x6f,
  0x77, 0x73, 0x3c, 0x2f, 0x68, 0x35, 0x3e, 0x66, 0x61, 0x71, 0x22, 0x3e, 0x7a,
  0x68, 0x2d, 0x63, 0x6e, 0x31, 0x30, 0x29, 0x3b, 0x0a, 0x2d, 0x31, 0x22, 0x29,
  0x3b, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x62, 0x6c, 0x75, 0x65, 0x73, 0x74, 0x72,
  0x75, 0x6c, 0x79, 0x64, 0x61, 0x76, 0x69, 0x73, 0x2e, 0x6a, 0x73, 0x27, 0x3b,
  0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x73, 0x74, 0x65, 0x65, 0x6c, 0x20, 0x79, 0x6f,
  0x75, 0x20, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6a,
  0x65, 0x73, 0x75, 0x73, 0x31, 0x30, 0x30, 0x25, 0x20, 0x6d, 0x65, 0x6e, 0x75,
  0x2e, 0x0d, 0x0a, 0x09, 0x0d, 0x0a, 0x77, 0x61, 0x6c, 0x65, 0x73, 0x72, 0x69,
  0x73, 0x6b, 0x73, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x64, 0x64, 0x69, 0x6e, 0x67,
  0x62, 0x2d, 0x6c, 0x69, 0x6b, 0x74, 0x65, 0x61, 0x63, 0x68, 0x67, 0x69, 0x66,
  0x22, 0x20, 0x76, 0x65, 0x67, 0x61, 0x73, 0x64, 0x61, 0x6e, 0x73, 0x6b, 0x65,
  0x65, 0x73, 0x74, 0x69, 0x73, 0x68, 0x71, 0x69, 0x70, 0x73, 0x75, 0x6f, 0x6d,
  0x69, 0x73, 0x6f, 0x62, 0x72, 0x65, 0x64, 0x65, 0x73, 0x64, 0x65, 0x65, 0x6e,
  0x74, 0x72, 0x65, 0x74, 0x6f, 0x64, 0x6f, 0x73, 0x70, 0x75, 0x65, 0x64, 0x65,
  0x61, 0xc3, 0xb1, 0x6f, 0x73, 0x65, 0x73, 0x74, 0xc3, 0xa1, 0x74, 0x69, 0x65,
  0x6e, 0x65, 0x68, 0x61, 0x73, 0x74, 0x61, 0x6f, 0x74, 0x72, 0x6f, 0x73, 0x70,
  0x61, 0x72, 0x74, 0x65, 0x64, 0x6f, 0x6e, 0x64, 0x65, 0x6e, 0x75, 0x65, 0x76,
  0x6f, 0x68, 0x61, 0x63, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6d, 0x69,
  0x73, 0x6d, 0x6f, 0x6d, 0x65, 0x6a, 0x6f, 0x72, 0x6d, 0x75, 0x6e, 0x64, 0x6f,
  0x61, 0x71, 0x75, 0xc3, 0xad, 0x64, 0xc3, 0xad, 0x61, 0x73, 0x73, 0xc3, 0xb3,
  0x6c, 0x6f, 0x61, 0x79, 0x75, 0x64, 0x61, 0x66, 0x65, 0x63, 0x68, 0x61, 0x74,
  0x6f, 0x64, 0x61, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x6f, 0x6d, 0x65, 0x6e, 0x6f,
  0x73, 0x64, 0x61, 0x74, 0x6f, 0x73, 0x6f, 0x74, 0x72, 0x61, 0x73, 0x73, 0x69,
  0x74, 0x69, 0x6f, 0x6d, 0x75, 0x63, 0x68, 0x6f, 0x61, 0x68, 0x6f, 0x72, 0x61,
  0x6c, 0x75, 0x67, 0x61, 0x72, 0x6d, 0x61, 0x79, 0x6f, 0x72, 0x65, 0x73, 0x74,
  0x6f, 0x73, 0x68, 0x6f, 0x72, 0x61, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x61,
  0x6e, 0x74, 0x65, 0x73, 0x66, 0x6f, 0x74, 0x6f, 0x73, 0x65, 0x73, 0x74, 0x61,
  0x73, 0x70, 0x61, 0xc3, 0xad, 0x73, 0x6e, 0x75, 0x65, 0x76, 0x61, 0x73, 0x61,
  0x6c, 0x75, 0x64, 0x66, 0x6f, 0x72, 0x6f, 0x73, 0x6d, 0x65, 0x64, 0x69, 0x6f,
  0x71, 0x75, 0x69, 0x65, 0x6e, 0x6d, 0x65, 0x73, 0x65, 0x73, 0x70, 0x6f, 0x64,
  0x65, 0x72, 0x63, 0x68, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x72, 0xc3, 0xa1, 0x76,
  0x65, 0x63, 0x65, 0x73, 0x64, 0x65, 0x63, 0x69, 0x72, 0x6a, 0x6f, 0x73, 0xc3,
  0xa9, 0x65, 0x73, 0x74, 0x61, 0x72, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x67, 0x72,
  0x75, 0x70, 0x6f, 0x68, 0x65, 0x63, 0x68, 0x6f, 0x65, 0x6c, 0x6c, 0x6f, 0x73,
  0x74, 0x65, 0x6e, 0x67, 0x6f, 0x61, 0x6d, 0x69, 0x67, 0x6f, 0x63, 0x6f, 0x73,
  0x61, 0x73, 0x6e, 0x69, 0x76, 0x65, 0x6c, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6d,
  0x69, 0x73, 0x6d, 0x61, 0x61, 0x69, 0x72, 0x65, 0x73, 0x6a, 0x75, 0x6c, 0x69,
  0x6f, 0x74, 0x65, 0x6d, 0x61, 0x73, 0x68, 0x61, 0x63, 0x69, 0x61, 0x66, 0x61,
  0x76, 0x6f, 0x72, 0x6a, 0x75, 0x6e, 0x69, 0x6f, 0x6c, 0x69, 0x62, 0x72, 0x65,
  0x70, 0x75, 0x6e, 0x74, 0x6f, 0x62, 0x75, 0x65, 0x6e, 0x6f, 0x61, 0x75, 0x74,
  0x6f, 0x72, 0x61, 0x62, 0x72, 0x69, 0x6c, 0x62, 0x75, 0x65, 0x6e, 0x61, 0x74,
  0x65, 0x78, 0x74, 0x6f, 0x6d, 0x61, 0x72, 0x7a, 0x6f, 0x73, 0x61, 0x62, 0x65,
  0x72, 0x6c, 0x69, 0x73, 0x74, 0x61, 0x6c, 0x75, 0x65, 0x67, 0x6f, 0x63, 0xc3,
  0xb3, 0x6d, 0x6f, 0x65, 0x6e, 0x65, 0x72, 0x6f, 0x6a, 0x75, 0x65, 0x67, 0x6f,
  0x70, 0x65, 0x72, 0xc3, 0xba, 0x68, 0x61, 0x62, 0x65, 0x72, 0x65, 0x73, 0x74,
  0x6f, 0x79, 0x6e, 0x75, 0x6e, 0x63, 0x61, 0x6d, 0x75, 0x6a, 0x65, 0x72, 0x76,
  0x61, 0x6c, 0x6f, 0x72, 0x66, 0x75, 0x65, 0x72, 0x61, 0x6c, 0x69, 0x62, 0x72,
  0x6f, 0x67, 0x75, 0x73, 0x74, 0x61, 0x69, 0x67, 0x75, 0x61, 0x6c, 0x76, 0x6f,
  0x74, 0x6f, 0x73, 0x63, 0x61, 0x73, 0x6f, 0x73, 0x67, 0x75, 0xc3, 0xad, 0x61,
  0x70, 0x75, 0x65, 0x64, 0x6f, 0x73, 0x6f, 0x6d, 0x6f, 0x73, 0x61, 0x76, 0x69,
  0x73, 0x6f, 0x75, 0x73, 0x74, 0x65, 0x64, 0x64, 0x65, 0x62, 0x65, 0x6e, 0x6e,
  0x6f, 0x63, 0x68, 0x65, 0x62, 0x75, 0x73, 0x63, 0x61, 0x66, 0x61, 0x6c, 0x74,
  0x61, 0x65, 0x75, 0x72, 0x6f, 0x73, 0x73, 0x65, 0x72, 0x69, 0x65, 0x64, 0x69,
  0x63, 0x68, 0x6f, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x63, 0x6c, 0x61, 0x76, 0x65,
  0x63, 0x61, 0x73, 0x61, 0x73, 0x6c, 0x65, 0xc3, 0xb3, 0x6e, 0x70, 0x6c, 0x61,
  0x7a, 0x6f, 0x6c, 0x61, 0x72, 0x67, 0x6f, 0x6f, 0x62, 0x72, 0x61, 0x73, 0x76,
  0x69, 0x73, 0x74, 0x61, 0x61, 0x70, 0x6f, 0x79, 0x6f, 0x6a, 0x75, 0x6e, 0x74,
  0x6f, 0x74, 0x72, 0x61, 0x74, 0x61, 0x76, 0x69, 0x73, 0x74, 0x6f, 0x63, 0x72,
  0x65, 0x61, 0x72, 0x63, 0x61, 0x6d, 0x70, 0x6f, 0x68, 0x65, 0x6d, 0x6f, 0x73,
  0x63, 0x69, 0x6e, 0x63, 0x6f, 0x63, 0x61, 0x72, 0x67, 0x6f, 0x70, 0x69, 0x73,
  0x6f, 0x73, 0x6f, 0x72, 0x64, 0x65, 0x6e, 0x68, 0x61, 0x63, 0x65, 0x6e, 0xc3,
  0xa1, 0x72, 0x65, 0x61, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x64, 0x72,
  0x6f, 0x63, 0x65, 0x72, 0x63, 0x61, 0x70, 0x75, 0x65, 0x64, 0x61, 0x70, 0x61,
  0x70, 0x65, 0x6c, 0x6d, 0x65, 0x6e, 0x6f, 0x72, 0xc3, 0xba, 0x74, 0x69, 0x6c,
  0x63, 0x6c, 0x61, 0x72, 0x6f, 0x6a, 0x6f, 0x72, 0x67, 0x65, 0x63, 0x61, 0x6c,
  0x6c, 0x65, 0x70, 0x6f, 0x6e, 0x65, 0x72, 0x74, 0x61, 0x72, 0x64, 0x65, 0x6e,
  0x61, 0x64, 0x69, 0x65, 0x6d, 0x61, 0x72, 0x63, 0x61, 0x73, 0x69, 0x67, 0x75,
  0x65, 0x65, 0x6c, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6c, 0x6f, 0x63, 0x6f,
  0x63, 0x68, 0x65, 0x6d, 0x6f, 0x74, 0x6f, 0x73, 0x6d, 0x61, 0x64, 0x72, 0x65,
  0x63, 0x6c, 0x61, 0x73, 0x65, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x6e, 0x69, 0xc3,
  0xb1, 0x6f, 0x71, 0x75, 0x65, 0x64, 0x61, 0x70, 0x61, 0x73, 0x61, 0x72, 0x62,
  0x61, 0x6e, 0x63, 0x6f, 0x68, 0x69, 0x6a, 0x6f, 0x73, 0x76, 0x69, 0x61, 0x6a,
  0x65, 0x70, 0x61, 0x62, 0x6c, 0x6f, 0xc3, 0xa9, 0x73, 0x74, 0x65, 0x76, 0x69,
  0x65, 0x6e, 0x65, 0x72, 0x65, 0x69, 0x6e, 0x6f, 0x64, 0x65, 0x6a, 0x61, 0x72,
  0x66, 0x6f, 0x6e, 0x64, 0x6f, 0x63, 0x61, 0x6e, 0x61, 0x6c, 0x6e, 0x6f, 0x72,
  0x74, 0x65, 0x6c, 0x65, 0x74, 0x72, 0x61, 0x63, 0x61, 0x75, 0x73, 0x61, 0x74,
  0x6f, 0x6d, 0x61, 0x72, 0x6d, 0x61, 0x6e, 0x6f, 0x73, 0x6c, 0x75, 0x6e, 0x65,
  0x73, 0x61, 0x75, 0x74, 0x6f, 0x73, 0x76, 0x69, 0x6c, 0x6c, 0x61, 0x76, 0x65,
  0x6e, 0x64, 0x6f, 0x70, 0x65, 0x73, 0x61, 0x72, 0x74, 0x69, 0x70, 0x6f, 0x73,
  0x74, 0x65, 0x6e, 0x67, 0x61, 0x6d, 0x61, 0x72, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
  0x76, 0x61, 0x70, 0x61, 0x64, 0x72, 0x65, 0x75, 0x6e, 0x69, 0x64, 0x6f, 0x76,
  0x61, 0x6d, 0x6f, 0x73, 0x7a, 0x6f, 0x6e, 0x61, 0x73, 0x61, 0x6d, 0x62, 0x6f,
  0x73, 0x62, 0x61, 0x6e, 0x64, 0x61, 0x6d, 0x61, 0x72, 0x69, 0x61, 0x61, 0x62,
  0x75, 0x73, 0x6f, 0x6d, 0x75, 0x63, 0x68, 0x61, 0x73, 0x75, 0x62, 0x69, 0x72,
  0x72, 0x69, 0x6f, 0x6a, 0x61, 0x76, 0x69, 0x76, 0x69, 0x72, 0x67, 0x72, 0x61,
  0x64, 0x6f, 0x63, 0x68, 0x69, 0x63, 0x61, 0x61, 0x6c, 0x6c, 0xc3, 0xad, 0x6a,
  0x6f, 0x76, 0x65, 0x6e, 0x64, 0x69, 0x63, 0x68, 0x61, 0x65, 0x73, 0x74, 0x61,
  0x6e, 0x74, 0x61, 0x6c, 0x65, 0x73, 0x73, 0x61, 0x6c, 0x69, 0x72, 0x73, 0x75,
  0x65, 0x6c, 0x6f, 0x70, 0x65, 0x73, 0x6f, 0x73, 0x66, 0x69, 0x6e, 0x65, 0x73,
  0x6c, 0x6c, 0x61, 0x6d, 0x61, 0x62, 0x75, 0x73, 0x63, 0x6f, 0xc3, 0xa9, 0x73,
  0x74, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x61, 0x6e, 0x65, 0x67, 0x72, 0x6f, 0x70,
  0x6c, 0x61, 0x7a, 0x61, 0x68, 0x75, 0x6d, 0x6f, 0x72, 0x70, 0x61, 0x67, 0x61,
  0x72, 0x6a, 0x75, 0x6e, 0x74, 0x61, 0x64, 0x6f, 0x62, 0x6c, 0x65, 0x69, 0x73,
  0x6c, 0x61, 0x73, 0x62, 0x6f, 0x6c, 0x73, 0x61, 0x62, 0x61, 0xc3, 0xb1, 0x6f,
  0x68, 0x61, 0x62, 0x6c, 0x61, 0x6c, 0x75, 0x63, 0x68, 0x61, 0xc3, 0x81, 0x72,
  0x65, 0x61, 0x64, 0x69, 0x63, 0x65, 0x6e, 0x6a, 0x75, 0x67, 0x61, 0x72, 0x6e,
  0x6f, 0x74, 0x61, 0x73, 0x76, 0x61, 0x6c, 0x6c, 0x65, 0x61, 0x6c, 0x6c, 0xc3,
  0xa1, 0x63, 0x61, 0x72, 0x67, 0x61, 0x64, 0x6f, 0x6c, 0x6f, 0x72, 0x61, 0x62,
  0x61, 0x6a, 0x6f, 0x65, 0x73, 0x74, 0xc3, 0xa9, 0x67, 0x75, 0x73, 0x74, 0x6f,
  0x6d, 0x65, 0x6e, 0x74, 0x65, 0x6d, 0x61, 0x72, 0x69, 0x6f, 0x66, 0x69, 0x72,
  0x6d, 0x61, 0x63, 0x6f, 0x73, 0x74, 0x6f, 0x66, 0x69, 0x63, 0x68, 0x61, 0x70,
  0x6c, 0x61, 0x74, 0x61, 0x68, 0x6f, 0x67, 0x61, 0x72, 0x61, 0x72, 0x74, 0x65,
  0x73, 0x6c, 0x65, 0x79, 0x65, 0x73, 0x61, 0x71, 0x75, 0x65, 0x6c, 0x6d, 0x75,
  0x73, 0x65, 0x6f, 0x62, 0x61, 0x73, 0x65, 0x73, 0x70, 0x6f, 0x63, 0x6f, 0x73,
  0x6d, 0x69, 0x74, 0x61, 0x64, 0x63, 0x69, 0x65, 0x6c, 0x6f, 0x63, 0x68, 0x69,
  0x63, 0x6f, 0x6d, 0x69, 0x65, 0x64, 0x6f, 0x67, 0x61, 0x6e, 0x61, 0x72, 0x73,
  0x61, 0x6e, 0x74, 0x6f, 0x65, 0x74, 0x61, 0x70, 0x61, 0x64, 0x65, 0x62, 0x65,
  0x73, 0x70, 0x6c, 0x61, 0x79, 0x61, 0x72, 0x65, 0x64, 0x65, 0x73, 0x73, 0x69,
  0x65, 0x74, 0x65, 0x63, 0x6f, 0x72, 0x74, 0x65, 0x63, 0x6f, 0x72, 0x65, 0x61,
  0x64, 0x75, 0x64, 0x61, 0x73, 0x64, 0x65, 0x73, 0x65, 0x6f, 0x76, 0x69, 0x65,
  0x6a, 0x6f, 0x64, 0x65, 0x73, 0x65, 0x61, 0x61, 0x67, 0x75, 0x61, 0x73, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x64, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x63, 0x6f,
  0x6d, 0x6d, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x65, 0x76, 0x65,
  0x6e, 0x74, 0x73, 0x6d, 0x61, 0x73, 0x74, 0x65, 0x72, 0x73, 0x79, 0x73, 0x74,
  0x65, 0x6d, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x61, 0x6e, 0x6e, 0x65,
  0x72, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x73, 0x63, 0x72, 0x6f, 0x6c, 0x6c,
  0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c, 0x6d,
  0x65, 0x64, 0x69, 0x75, 0x6d, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x75,
  0x6d, 0x62, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x65, 0x73,
  0x75, 0x6c, 0x74, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x73, 0x63, 0x72, 0x65,
  0x65, 0x6e, 0x63, 0x68, 0x6f, 0x6f, 0x73, 0x65, 0x6e, 0x6f, 0x72, 0x6d, 0x61,
  0x6c, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x69, 0x73, 0x73, 0x75, 0x65, 0x73,
  0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73,
  0x70, 0x72, 0x69, 0x6e, 0x67, 0x6d, 0x6f, 0x64, 0x75, 0x6c, 0x65, 0x6d, 0x6f,
  0x62, 0x69, 0x6c, 0x65, 0x73, 0x77, 0x69, 0x74, 0x63, 0x68, 0x70, 0x68, 0x6f,
  0x74, 0x6f, 0x73, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x72, 0x65, 0x67, 0x69,
  0x6f, 0x6e, 0x69, 0x74, 0x73, 0x65, 0x6c, 0x66, 0x73, 0x6f, 0x63, 0x69, 0x61,
  0x6c, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e,
  0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x74,
  0x69, 0x74, 0x6c, 0x65, 0x3e, 0x65, 0x69, 0x74, 0x68, 0x65, 0x72, 0x6c, 0x65,
  0x6e, 0x67, 0x74, 0x68, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x66, 0x72, 0x69,
  0x65, 0x6e, 0x64, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x61, 0x75, 0x74, 0x68,
  0x6f, 0x72, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x72, 0x65, 0x76, 0x69, 0x65,
  0x77, 0x73, 0x75, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x65, 0x72, 0x76, 0x65, 0x72,
  0x70, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x65,
  0x78, 0x70, 0x61, 0x6e, 0x64, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x66, 0x6f,
  0x72, 0x6d, 0x61, 0x74, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x70, 0x6f, 0x69,
  0x6e, 0x74, 0x73, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x70, 0x65, 0x72, 0x73,
  0x6f, 0x6e, 0x6c, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x73, 0x69, 0x67,
  0x6e, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x73, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x73,
  0x75, 0x6e, 0x69, 0x71, 0x75, 0x65, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x65, 0x6e, 0x65, 0x72, 0x67, 0x79, 0x6e, 0x61,
  0x74, 0x75, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x66, 0x69, 0x67,
  0x75, 0x72, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x63, 0x75, 0x73, 0x74,
  0x6f, 0x6d, 0x6f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x6c, 0x65, 0x74, 0x74, 0x65,
  0x72, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74,
  0x72, 0x65, 0x6e, 0x64, 0x65, 0x72, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x73, 0x75,
  0x70, 0x6c, 0x6f, 0x61, 0x64, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x6d, 0x65,
  0x74, 0x68, 0x6f, 0x64, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x73, 0x73, 0x63, 0x68,
  0x6f, 0x6f, 0x6c, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x73, 0x68, 0x61, 0x64,
  0x6f, 0x77, 0x64, 0x65, 0x62, 0x61, 0x74, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x65,
  0x73, 0x4f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73,
  0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x6c, 0x65, 0x61, 0x67, 0x75, 0x65, 0x63,
  0x68, 0x72, 0x6f, 0x6d, 0x65, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6e, 0x6f,
  0x74, 0x69, 0x63, 0x65, 0x73, 0x68, 0x61, 0x72, 0x65, 0x64, 0x65, 0x6e, 0x64,
  0x69, 0x6e, 0x67, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x72, 0x65, 0x70, 0x6f,
  0x72, 0x74, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x71, 0x75, 0x61, 0x72,
  0x65, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73,
  0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x6d, 0x6f, 0x76, 0x69, 0x6e, 0x67, 0x6c,
  0x61, 0x74, 0x65, 0x73, 0x74, 0x77, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x46, 0x72,
  0x61, 0x6e, 0x63, 0x65, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x73, 0x74, 0x72,
  0x6f, 0x6e, 0x67, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x4c, 0x6f, 0x6e, 0x64,
  0x6f, 0x6e, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x66, 0x6f, 0x72, 0x6d, 0x65,
  0x64, 0x64, 0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x65, 0x63, 0x75, 0x72, 0x65,
  0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x74, 0x6f, 0x67, 0x67, 0x6c, 0x65, 0x70,
  0x6c, 0x61, 0x63, 0x65, 0x73, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x74,
  0x61, 0x74, 0x69, 0x63, 0x63, 0x69, 0x74, 0x69, 0x65, 0x73, 0x73, 0x74, 0x72,
  0x65, 0x61, 0x6d, 0x79, 0x65, 0x6c, 0x6c, 0x6f, 0x77, 0x61, 0x74, 0x74, 0x61,
  0x63, 0x6b, 0x73, 0x74, 0x72, 0x65, 0x65, 0x74, 0x66, 0x6c, 0x69, 0x67, 0x68,
  0x74, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x69, 0x6e, 0x66, 0x6f, 0x22, 0x3e,
  0x6f, 0x70, 0x65, 0x6e, 0x65, 0x64, 0x75, 0x73, 0x65, 0x66, 0x75, 0x6c, 0x76,
  0x61, 0x6c, 0x6c, 0x65, 0x79, 0x63, 0x61, 0x75, 0x73, 0x65, 0x73, 0x6c, 0x65,
  0x61, 0x64, 0x65, 0x72, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x73, 0x65, 0x63,
  0x6f, 0x6e, 0x64, 0x64, 0x61, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x70, 0x6f, 0x72,
  0x74, 0x73, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6e,
  0x67, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
  0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x73,
  0x74, 0x61, 0x74, 0x65, 0x73, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x65, 0x76, 0x69,
  0x73, 0x75, 0x61, 0x6c, 0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x76, 0x6f, 0x6c,
  0x75, 0x6d, 0x65, 0x52, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x6d, 0x75, 0x73, 0x65,
  0x75, 0x6d, 0x6d, 0x6f, 0x76, 0x69, 0x65, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e,
  0x74, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x6f, 0x73, 0x74, 0x6c, 0x79,
  0x6d, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x22, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x6d,
  0x61, 0x72, 0x6b, 0x65, 0x74, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x63, 0x68,
  0x61, 0x6e, 0x63, 0x65, 0x73, 0x75, 0x72, 0x76, 0x65, 0x79, 0x62, 0x65, 0x66,
  0x6f, 0x72, 0x65, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x6d, 0x6f, 0x6d, 0x65,
  0x6e, 0x74, 0x73, 0x70, 0x65, 0x65, 0x63, 0x68, 0x6d, 0x6f, 0x74, 0x69, 0x6f,
  0x6e, 0x69, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72,
  0x43, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x65,
  0x78, 0x69, 0x73, 0x74, 0x73, 0x6d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x45, 0x75,
  0x72, 0x6f, 0x70, 0x65, 0x67, 0x72, 0x6f, 0x77, 0x74, 0x68, 0x6c, 0x65, 0x67,
  0x61, 0x63, 0x79, 0x6d, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x65, 0x6e, 0x6f, 0x75,
  0x67, 0x68, 0x63, 0x61, 0x72, 0x65, 0x65, 0x72, 0x61, 0x6e, 0x73, 0x77, 0x65,
  0x72, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6c,
  0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72,
  0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x64, 0x74, 0x6f,
  0x70, 0x69, 0x63, 0x73, 0x63, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x66, 0x61, 0x74,
  0x68, 0x65, 0x72, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x69, 0x6d, 0x70,
  0x6c, 0x79, 0x72, 0x61, 0x69, 0x73, 0x65, 0x64, 0x65, 0x73, 0x63, 0x61, 0x70,
  0x65, 0x63, 0x68, 0x6f, 0x73, 0x65, 0x6e, 0x63, 0x68, 0x75, 0x72, 0x63, 0x68,
  0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x63,
  0x6f, 0x72, 0x6e, 0x65, 0x72, 0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x6d, 0x65,
  0x6d, 0x6f, 0x72, 0x79, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x70, 0x6f, 0x6c,
  0x69, 0x63, 0x65, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x73, 0x4e, 0x75, 0x6d, 0x62,
  0x65, 0x72, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x6f, 0x66, 0x66, 0x65, 0x72,
  0x73, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64,
  0x6c, 0x69, 0x73, 0x74, 0x65, 0x64, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x73,
  0x69, 0x6c, 0x76, 0x65, 0x72, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x64, 0x65,
  0x6c, 0x65, 0x74, 0x65, 0x62, 0x65, 0x74, 0x74, 0x65, 0x72, 0x62, 0x72, 0x6f,
  0x77, 0x73, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x73, 0x47, 0x6c, 0x6f, 0x62,
  0x61, 0x6c, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x77, 0x69, 0x64, 0x67, 0x65,
  0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x62, 0x75, 0x64, 0x67, 0x65, 0x74,
  0x6e, 0x6f, 0x77, 0x72, 0x61, 0x70, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x63,
  0x6c, 0x61, 0x69, 0x6d, 0x73, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73, 0x61,
  0x66, 0x65, 0x74, 0x79, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x70, 0x69,
  0x72, 0x69, 0x74, 0x2d, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x70, 0x72, 0x65,
  0x61, 0x64, 0x6d, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x6e, 0x65, 0x65, 0x64, 0x65,
  0x64, 0x72, 0x75, 0x73, 0x73, 0x69, 0x61, 0x70, 0x6c, 0x65, 0x61, 0x73, 0x65,
  0x65, 0x78, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x62,
  0x72, 0x6f, 0x6b, 0x65, 0x6e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x63, 0x68,
  0x61, 0x72, 0x67, 0x65, 0x64, 0x69, 0x76, 0x69, 0x64, 0x65, 0x66, 0x61, 0x63,
  0x74, 0x6f, 0x72, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x2d, 0x62, 0x61, 0x73,
  0x65, 0x64, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x79, 0x63, 0x6f, 0x6e, 0x66, 0x69,
  0x67, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x64,
  0x68, 0x65, 0x6c, 0x70, 0x65, 0x64, 0x43, 0x68, 0x75, 0x72, 0x63, 0x68, 0x69,
  0x6d, 0x70, 0x61, 0x63, 0x74, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x61, 0x6c,
  0x77, 0x61, 0x79, 0x73, 0x6c, 0x6f, 0x67, 0x6f, 0x22, 0x20, 0x62, 0x6f, 0x74,
  0x74, 0x6f, 0x6d, 0x6c, 0x69, 0x73, 0x74, 0x22, 0x3e, 0x29, 0x7b, 0x76, 0x61,
  0x72, 0x20, 0x70, 0x72, 0x65, 0x66, 0x69, 0x78, 0x6f, 0x72, 0x61, 0x6e, 0x67,
  0x65, 0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x2e, 0x70, 0x75, 0x73, 0x68, 0x28,
  0x63, 0x6f, 0x75, 0x70, 0x6c, 0x65, 0x67, 0x61, 0x72, 0x64, 0x65, 0x6e, 0x62,
  0x72, 0x69, 0x64, 0x67, 0x65, 0x6c, 0x61, 0x75, 0x6e, 0x63, 0x68, 0x52, 0x65,
  0x76, 0x69, 0x65, 0x77, 0x74, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x76, 0x69, 0x73,
  0x69, 0x6f, 0x6e, 0x6c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x69,
  0x6e, 0x67, 0x42, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x62, 0x65, 0x61, 0x75, 0x74,
  0x79, 0x74, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x66, 0x6f, 0x72, 0x67, 0x6f, 0x74,
  0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x63, 0x68, 0x6f, 0x72, 0x61,
  0x6c, 0x6d, 0x6f, 0x73, 0x74, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x64, 0x43, 0x68,
  0x61, 0x6e, 0x67, 0x65, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x74, 0x72,
  0x69, 0x6e, 0x67, 0x72, 0x65, 0x6c, 0x6f, 0x61, 0x64, 0x4d, 0x6f, 0x62, 0x69,
  0x6c, 0x65, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x65, 0x73, 0x75, 0x70, 0x70, 0x6c,
  0x79, 0x53, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x73,
  0x76, 0x69, 0x65, 0x77, 0x65, 0x64, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x63,
  0x6f, 0x75, 0x72, 0x73, 0x65, 0x41, 0x62, 0x6f, 0x75, 0x74, 0x20, 0x69, 0x73,
  0x6c, 0x61, 0x6e, 0x64, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x63, 0x6f, 0x6f,
  0x6b, 0x69, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x6d, 0x61, 0x7a,
  0x6f, 0x6e, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x6e, 0x61, 0x64, 0x76, 0x69, 0x63,
  0x65, 0x69, 0x6e, 0x3c, 0x2f, 0x61, 0x3e, 0x3a, 0x20, 0x54, 0x68, 0x65, 0x20,
  0x64, 0x69, 0x61, 0x6c, 0x6f, 0x67, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x73, 0x42,
  0x45, 0x47, 0x49, 0x4e, 0x20, 0x4d, 0x65, 0x78, 0x69, 0x63, 0x6f, 0x73, 0x74,
  0x61, 0x72, 0x74, 0x73, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x68, 0x65, 0x69,
  0x67, 0x68, 0x74, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x49, 0x73, 0x6c, 0x61,
  0x6e, 0x64, 0x61, 0x73, 0x73, 0x65, 0x74, 0x73, 0x45, 0x6d, 0x70, 0x69, 0x72,
  0x65, 0x53, 0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74,
  0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6e, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x6d,
  0x61, 0x6e, 0x75, 0x61, 0x6c, 0x53, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x2e, 0x0a,
  0x0a, 0x4f, 0x6e, 0x65, 0x6a, 0x6f, 0x69, 0x6e, 0x65, 0x64, 0x6d, 0x65, 0x6e,
  0x75, 0x22, 0x3e, 0x50, 0x68, 0x69, 0x6c, 0x69, 0x70, 0x61, 0x77, 0x61, 0x72,
  0x64, 0x73, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x69, 0x6d, 0x70, 0x6f, 0x72,
  0x74, 0x4f, 0x66, 0x66, 0x69, 0x63, 0x65, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64,
  0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x73, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x53,
  0x70, 0x6f, 0x72, 0x74, 0x73, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x77, 0x65,
  0x65, 0x6b, 0x6c, 0x79, 0x20, 0x28, 0x65, 0x2e, 0x67, 0x2e, 0x62, 0x65, 0x68,
  0x69, 0x6e, 0x64, 0x64, 0x6f, 0x63, 0x74, 0x6f, 0x72, 0x6c, 0x6f, 0x67, 0x67,
  0x65, 0x64, 0x75, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x3c, 0x2f, 0x62, 0x3e, 0x3c,
  0x2f, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x73, 0x70, 0x6c, 0x61, 0x6e, 0x74, 0x73,
  0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x73, 0x74, 0x69,
  0x73, 0x73, 0x75, 0x65, 0x64, 0x33, 0x30, 0x30, 0x70, 0x78, 0x7c, 0x63, 0x61,
  0x6e, 0x61, 0x64, 0x61, 0x61, 0x67, 0x65, 0x6e, 0x63, 0x79, 0x73, 0x63, 0x68,
  0x65, 0x6d, 0x65, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x42, 0x72, 0x61, 0x7a,
  0x69, 0x6c, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x6c, 0x6f, 0x67, 0x6f, 0x22,
  0x3e, 0x62, 0x65, 0x79, 0x6f, 0x6e, 0x64, 0x2d, 0x73, 0x63, 0x61, 0x6c, 0x65,
  0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x6d,
  0x61, 0x72, 0x69, 0x6e, 0x65, 0x46, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x63, 0x61,
  0x6d, 0x65, 0x72, 0x61, 0x3c, 0x2f, 0x68, 0x31, 0x3e, 0x0a, 0x5f, 0x66, 0x6f,
  0x72, 0x6d, 0x22, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x73, 0x73, 0x74, 0x72, 0x65,
  0x73, 0x73, 0x22, 0x20, 0x2f, 0x3e, 0x0d, 0x0a, 0x2e, 0x67, 0x69, 0x66, 0x22,
  0x20, 0x6f, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x6c, 0x6f, 0x61, 0x64, 0x65, 0x72,
  0x4f, 0x78, 0x66, 0x6f, 0x72, 0x64, 0x73, 0x69, 0x73, 0x74, 0x65, 0x72, 0x73,
  0x75, 0x72, 0x76, 0x69, 0x76, 0x6c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x66, 0x65,
  0x6d, 0x61, 0x6c, 0x65, 0x44, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x73, 0x69, 0x7a,
  0x65, 0x3d, 0x22, 0x61, 0x70, 0x70, 0x65, 0x61, 0x6c, 0x74, 0x65, 0x78, 0x74,
  0x22, 0x3e, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x73, 0x74, 0x68, 0x61, 0x6e, 0x6b,
  0x73, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64,
  0x61, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x61, 0x6e, 0x79, 0x6f, 0x6e, 0x65, 0x41,
  0x66, 0x72, 0x69, 0x63, 0x61, 0x61, 0x67, 0x72, 0x65, 0x65, 0x64, 0x72, 0x65,
  0x63, 0x65, 0x6e, 0x74, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x3c, 0x62, 0x72,
  0x20, 0x2f, 0x3e, 0x77, 0x6f, 0x6e, 0x64, 0x65, 0x72, 0x70, 0x72, 0x69, 0x63,
  0x65, 0x73, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x7c, 0x7c, 0x20, 0x7b, 0x7d,
  0x3b, 0x6d, 0x61, 0x69, 0x6e, 0x22, 0x3e, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
  0x73, 0x75, 0x6e, 0x64, 0x61, 0x79, 0x77, 0x72, 0x61, 0x70, 0x22, 0x3e, 0x66,
  0x61, 0x69, 0x6c, 0x65, 0x64, 0x63, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x6d, 0x69,
  0x6e, 0x75, 0x74, 0x65, 0x62, 0x65, 0x61, 0x63, 0x6f, 0x6e, 0x71, 0x75, 0x6f,
  0x74, 0x65, 0x73, 0x31, 0x35, 0x30, 0x70, 0x78, 0x7c, 0x65, 0x73, 0x74, 0x61,
  0x74, 0x65, 0x72, 0x65, 0x6d, 0x6f, 0x74, 0x65, 0x65, 0x6d, 0x61, 0x69, 0x6c,
  0x22, 0x6c, 0x69, 0x6e, 0x6b, 0x65, 0x64, 0x72, 0x69, 0x67, 0x68, 0x74, 0x3b,
  0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6c, 0x31,
  0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x73, 0x69, 0x67, 0x6e, 0x75, 0x70, 0x70, 0x72,
  0x69, 0x6e, 0x63, 0x65, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x3a, 0x2e, 0x70, 0x6e,
  0x67, 0x22, 0x20, 0x66, 0x6f, 0x72, 0x75, 0x6d, 0x2e, 0x41, 0x63, 0x63, 0x65,
  0x73, 0x73, 0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x73, 0x6f, 0x75, 0x6e, 0x64,
  0x73, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x48, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x73, 0x6c, 0x69, 0x64, 0x65, 0x72, 0x55, 0x54, 0x46, 0x2d, 0x38, 0x22, 0x26,
  0x61, 0x6d, 0x70, 0x3b, 0x20, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x2e, 0x20,
  0x57, 0x69, 0x74, 0x68, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x6f, 0x77, 0x6e,
  0x65, 0x72, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x70, 0x72, 0x6f, 0x66,
  0x69, 0x74, 0x6a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x61, 0x6e, 0x6e, 0x75, 0x61,
  0x6c, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x73, 0x62, 0x6f, 0x75, 0x67, 0x68, 0x74,
  0x66, 0x61, 0x6d, 0x6f, 0x75, 0x73, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x6c,
  0x6f, 0x6e, 0x67, 0x65, 0x72, 0x69, 0x2b, 0x2b, 0x29, 0x20, 0x7b, 0x69, 0x73,
  0x72, 0x61, 0x65, 0x6c, 0x73, 0x61, 0x79, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x63,
  0x69, 0x64, 0x65, 0x68, 0x6f, 0x6d, 0x65, 0x22, 0x3e, 0x68, 0x65, 0x61, 0x64,
  0x65, 0x72, 0x65, 0x6e, 0x73, 0x75, 0x72, 0x65, 0x62, 0x72, 0x61, 0x6e, 0x63,
  0x68, 0x70, 0x69, 0x65, 0x63, 0x65, 0x73, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x3b,
  0x73, 0x74, 0x61, 0x74, 0x65, 0x64, 0x74, 0x6f, 0x70, 0x22, 0x3e, 0x3c, 0x72,
  0x61, 0x63, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x65, 0x2d, 0x2d,
  0x26, 0x67, 0x74, 0x3b, 0x70, 0x61, 0x63, 0x69, 0x74, 0x79, 0x73, 0x65, 0x78,
  0x75, 0x61, 0x6c, 0x62, 0x75, 0x72, 0x65, 0x61, 0x75, 0x2e, 0x6a, 0x70, 0x67,
  0x22, 0x20, 0x31, 0x30, 0x2c, 0x30, 0x30, 0x30, 0x6f, 0x62, 0x74, 0x61, 0x69,
  0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x73, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74,
  0x2c, 0x20, 0x49, 0x6e, 0x63, 0x2e, 0x63, 0x6f, 0x6d, 0x65, 0x64, 0x79, 0x6d,
  0x65, 0x6e, 0x75, 0x22, 0x20, 0x6c, 0x79, 0x72, 0x69, 0x63, 0x73, 0x74, 0x6f,
  0x64, 0x61, 0x79, 0x2e, 0x69, 0x6e, 0x64, 0x65, 0x65, 0x64, 0x63, 0x6f, 0x75,
  0x6e, 0x74, 0x79, 0x5f, 0x6c, 0x6f, 0x67, 0x6f, 0x2e, 0x46, 0x61, 0x6d, 0x69,
  0x6c, 0x79, 0x6c, 0x6f, 0x6f, 0x6b, 0x65, 0x64, 0x4d, 0x61, 0x72, 0x6b, 0x65,
  0x74, 0x6c, 0x73, 0x65, 0x20, 0x69, 0x66, 0x50, 0x6c, 0x61, 0x79, 0x65, 0x72,
  0x74, 0x75, 0x72, 0x6b, 0x65, 0x79, 0x29, 0x3b, 0x76, 0x61, 0x72, 0x20, 0x66,
  0x6f, 0x72, 0x65, 0x73, 0x74, 0x67, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x65, 0x72,
  0x72, 0x6f, 0x72, 0x73, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x7d, 0x65, 0x6c,
  0x73, 0x65, 0x7b, 0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x42, 0x6c, 0x6f, 0x67,
  0x3c, 0x2f, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x6c, 0x6f, 0x67, 0x69, 0x6e,
  0x2e, 0x66, 0x61, 0x73, 0x74, 0x65, 0x72, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x73,
  0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x31, 0x30, 0x70, 0x78, 0x20, 0x30, 0x70,
  0x72, 0x61, 0x67, 0x6d, 0x61, 0x66, 0x72, 0x69, 0x64, 0x61, 0x79, 0x6a, 0x75,
  0x6e, 0x69, 0x6f, 0x72, 0x64, 0x6f, 0x6c, 0x6c, 0x61, 0x72, 0x70, 0x6c, 0x61,
  0x63, 0x65, 0x64, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x73, 0x70, 0x6c, 0x75, 0x67,
  0x69, 0x6e, 0x35, 0x2c, 0x30, 0x30, 0x30, 0x20, 0x70, 0x61, 0x67, 0x65, 0x22,
  0x3e, 0x62, 0x6f, 0x73, 0x74, 0x6f, 0x6e, 0x2e, 0x74, 0x65, 0x73, 0x74, 0x28,
  0x61, 0x76, 0x61, 0x74, 0x61, 0x72, 0x74, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f,
  0x63, 0x6f, 0x75, 0x6e, 0x74, 0x66, 0x6f, 0x72, 0x75, 0x6d, 0x73, 0x73, 0x63,
  0x68, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2c, 0x66, 0x69, 0x6c,
  0x6c, 0x65, 0x64, 0x73, 0x68, 0x61, 0x72, 0x65, 0x73, 0x72, 0x65, 0x61, 0x64,
  0x65, 0x72, 0x61, 0x6c, 0x65, 0x72, 0x74, 0x28, 0x61, 0x70, 0x70, 0x65, 0x61,
  0x72, 0x53, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x6c, 0x69, 0x6e, 0x65, 0x22, 0x3e,
  0x62, 0x6f, 0x64, 0x79, 0x22, 0x3e, 0x0a, 0x2a, 0x20, 0x54, 0x68, 0x65, 0x54,
  0x68, 0x6f, 0x75, 0x67, 0x68, 0x73, 0x65, 0x65, 0x69, 0x6e, 0x67, 0x6a, 0x65,
  0x72, 0x73, 0x65, 0x79, 0x4e, 0x65, 0x77, 0x73, 0x3c, 0x2f, 0x76, 0x65, 0x72,
  0x69, 0x66, 0x79, 0x65, 0x78, 0x70, 0x65, 0x72, 0x74, 0x69, 0x6e, 0x6a, 0x75,
  0x72, 0x79, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x43, 0x6f, 0x6f, 0x6b, 0x69,
  0x65, 0x53, 0x54, 0x41, 0x52, 0x54, 0x20, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x73,
  0x5f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x74, 0x68, 0x72, 0x65, 0x61, 0x64, 0x6e,
  0x61, 0x74, 0x69, 0x76, 0x65, 0x70, 0x6f, 0x63, 0x6b, 0x65, 0x74, 0x62, 0x6f,
  0x78, 0x22, 0x3e, 0x0a, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20, 0x44, 0x61,
  0x76, 0x69, 0x64, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x72, 0x74, 0x61, 0x62, 0x6c,
  0x65, 0x73, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x41, 0x70, 0x72, 0x69, 0x6c,
  0x20, 0x72, 0x65, 0x61, 0x6c, 0x6c, 0x79, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72,
  0x69, 0x74, 0x65, 0x6d, 0x22, 0x3e, 0x6d, 0x6f, 0x72, 0x65, 0x22, 0x3e, 0x62,
  0x6f, 0x61, 0x72, 0x64, 0x73, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x63, 0x61,
  0x6d, 0x70, 0x75, 0x73, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x7c, 0x7c, 0x20,
  0x5b, 0x5d, 0x3b, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x2e, 0x67, 0x75, 0x69, 0x74,
  0x61, 0x72, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x77, 0x69, 0x64, 0x74, 0x68,
  0x3a, 0x73, 0x68, 0x6f, 0x77, 0x65, 0x64, 0x4f, 0x74, 0x68, 0x65, 0x72, 0x20,
  0x2e, 0x70, 0x68, 0x70, 0x22, 0x20, 0x61, 0x73, 0x73, 0x75, 0x6d, 0x65, 0x6c,
  0x61, 0x79, 0x65, 0x72, 0x73, 0x77, 0x69, 0x6c, 0x73, 0x6f, 0x6e, 0x73, 0x74,
  0x6f, 0x72, 0x65, 0x73, 0x72, 0x65, 0x6c, 0x69, 0x65, 0x66, 0x73, 0x77, 0x65,
  0x64, 0x65, 0x6e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x61, 0x73, 0x69,
  0x6c, 0x79, 0x20, 0x79, 0x6f, 0x75, 0x72, 0x20, 0x53, 0x74, 0x72, 0x69, 0x6e,
  0x67, 0x0a, 0x0a, 0x57, 0x68, 0x69, 0x6c, 0x74, 0x61, 0x79, 0x6c, 0x6f, 0x72,
  0x63, 0x6c, 0x65, 0x61, 0x72, 0x3a, 0x72, 0x65, 0x73, 0x6f, 0x72, 0x74, 0x66,
  0x72, 0x65, 0x6e, 0x63, 0x68, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x22, 0x29,
  0x20, 0x2b, 0x20, 0x22, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x62, 0x75, 0x79,
  0x69, 0x6e, 0x67, 0x62, 0x72, 0x61, 0x6e, 0x64, 0x73, 0x4d, 0x65, 0x6d, 0x62,
  0x65, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x3e, 0x6f, 0x70, 0x70, 0x69, 0x6e,
  0x67, 0x73, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x35, 0x70, 0x78, 0x3b, 0x22, 0x3e,
  0x76, 0x73, 0x70, 0x61, 0x63, 0x65, 0x70, 0x6f, 0x73, 0x74, 0x65, 0x72, 0x6d,
  0x61, 0x6a, 0x6f, 0x72, 0x20, 0x63, 0x6f, 0x66, 0x66, 0x65, 0x65, 0x6d, 0x61,
  0x72, 0x74, 0x69, 0x6e, 0x6d, 0x61, 0x74, 0x75, 0x72, 0x65, 0x68, 0x61, 0x70,
  0x70, 0x65, 0x6e, 0x3c, 0x2f, 0x6e, 0x61, 0x76, 0x3e, 0x6b, 0x61, 0x6e, 0x73,
  0x61, 0x73, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x3e, 0x49, 0x6d, 0x61, 0x67, 0x65,
  0x73, 0x3d, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20,
  0x68, 0x73, 0x70, 0x61, 0x63, 0x65, 0x30, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x20,
  0x0a, 0x0a, 0x49, 0x6e, 0x20, 0x20, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x50, 0x6f,
  0x6c, 0x73, 0x6b, 0x69, 0x2d, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x6a, 0x6f, 0x72,
  0x64, 0x61, 0x6e, 0x42, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x53, 0x74, 0x61, 0x72,
  0x74, 0x20, 0x2d, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x32, 0x2e, 0x68, 0x74, 0x6d,
  0x6c, 0x6e, 0x65, 0x77, 0x73, 0x22, 0x3e, 0x30, 0x31, 0x2e, 0x6a, 0x70, 0x67,
  0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x6d,
  0x69, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x65, 0x6e, 0x69, 0x6f, 0x72, 0x49, 0x53,
  0x42, 0x4e, 0x20, 0x30, 0x30, 0x2c, 0x30, 0x30, 0x30, 0x20, 0x67, 0x75, 0x69,
  0x64, 0x65, 0x73, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x29, 0x65, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x72, 0x65, 0x70, 0x61, 0x69, 0x72, 0x2e, 0x78, 0x6d, 0x6c, 0x22,
  0x20, 0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x73, 0x2e, 0x68, 0x74, 0x6d, 0x6c,
  0x2d, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x72, 0x65, 0x67, 0x45, 0x78, 0x70, 0x3a,
  0x68, 0x6f, 0x76, 0x65, 0x72, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x76, 0x69,
  0x72, 0x67, 0x69, 0x6e, 0x70, 0x68, 0x6f, 0x6e, 0x65, 0x73, 0x3c, 0x2f, 0x74,
  0x72, 0x3e, 0x0d, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x0a, 0x09, 0x76, 0x61,
  0x72, 0x20, 0x3e, 0x27, 0x29, 0x3b, 0x0a, 0x09, 0x3c, 0x2f, 0x74, 0x64, 0x3e,
  0x0a, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x0a, 0x62, 0x61, 0x68, 0x61, 0x73, 0x61,
  0x62, 0x72, 0x61, 0x73, 0x69, 0x6c, 0x67, 0x61, 0x6c, 0x65, 0x67, 0x6f, 0x6d,
  0x61, 0x67, 0x79, 0x61, 0x72, 0x70, 0x6f, 0x6c, 0x73, 0x6b, 0x69, 0x73, 0x72,
  0x70, 0x73, 0x6b, 0x69, 0xd8, 0xb1, 0xd8, 0xaf, 0xd9, 0x88, 0xe4, 0xb8, 0xad,
  0xe6, 0x96, 0x87, 0xe7, 0xae, 0x80, 0xe4, 0xbd, 0x93, 0xe7, 0xb9, 0x81, 0xe9,
  0xab, 0x94, 0xe4, 0xbf, 0xa1, 0xe6, 0x81, 0xaf, 0xe4, 0xb8, 0xad, 0xe5, 0x9b,
  0xbd, 0xe6, 0x88, 0x91, 0xe4, 0xbb, 0xac, 0xe4, 0xb8, 0x80, 0xe4, 0xb8, 0xaa,
  0xe5, 0x85, 0xac, 0xe5, 0x8f, 0xb8, 0xe7, 0xae, 0xa1, 0xe7, 0x90, 0x86, 0xe8,
  0xae, 0xba, 0xe5, 0x9d, 0x9b, 0xe5, 0x8f, 0xaf, 0xe4, 0xbb, 0xa5, 0xe6, 0x9c,
  0x8d, 0xe5, 0x8a, 0xa1, 0xe6, 0x97, 0xb6, 0xe9, 0x97, 0xb4, 0xe4, 0xb8, 0xaa,
  0xe4, 0xba, 0xba, 0xe4, 0xba, 0xa7, 0xe5, 0x93, 0x81, 0xe8, 0x87, 0xaa, 0xe5,
  0xb7, 0xb1, 0xe4, 0xbc, 0x81, 0xe4, 0xb8, 0x9a, 0xe6, 0x9f, 0xa5, 0xe7, 0x9c,
  0x8b, 0xe5, 0xb7, 0xa5, 0xe4, 0xbd, 0x9c, 0xe8, 0x81, 0x94, 0xe7, 0xb3, 0xbb,
  0xe6, 0xb2, 0xa1, 0xe6, 0x9c, 0x89, 0xe7, 0xbd, 0x91, 0xe7, 0xab, 0x99, 0xe6,
  0x89, 0x80, 0xe6, 0x9c, 0x89, 0xe8, 0xaf, 0x84, 0xe8, 0xae, 0xba, 0xe4, 0xb8,
  0xad, 0xe5, 0xbf, 0x83, 0xe6, 0x96, 0x87, 0xe7, 0xab, 0xa0, 0xe7, 0x94, 0xa8,
  0xe6, 0x88, 0xb7, 0xe9, 0xa6, 0x96, 0xe9, 0xa1, 0xb5, 0xe4, 0xbd, 0x9c, 0xe8,
  0x80, 0x85, 0xe6, 0x8a, 0x80, 0xe6, 0x9c, 0xaf, 0xe9, 0x97, 0xae, 0xe9, 0xa2,
  0x98, 0xe7, 0x9b, 0xb8, 0xe5, 0x85, 0xb3, 0xe4, 0xb8, 0x8b, 0xe8, 0xbd, 0xbd,
  0xe6, 0x90, 0x9c, 0xe7, 0xb4, 0xa2, 0xe4, 0xbd, 0xbf, 0xe7, 0x94, 0xa8, 0xe8,
  0xbd, 0xaf, 0xe4, 0xbb, 0xb6, 0xe5, 0x9c, 0xa8, 0xe7, 0xba, 0xbf, 0xe4, 0xb8,
  0xbb, 0xe9, 0xa2, 0x98, 0xe8, 0xb5, 0x84, 0xe6, 0x96, 0x99, 0xe8, 0xa7, 0x86,
  0xe9, 0xa2, 0x91, 0xe5, 0x9b, 0x9e, 0xe5, 0xa4, 0x8d, 0xe6, 0xb3, 0xa8, 0xe5,
  0x86, 0x8c, 0xe7, 0xbd, 0x91, 0xe7, 0xbb, 0x9c, 0xe6, 0x94, 0xb6, 0xe8, 0x97,
  0x8f, 0xe5, 0x86, 0x85, 0xe5, 0xae, 0xb9, 0xe6, 0x8e, 0xa8, 0xe8, 0x8d, 0x90,
  0xe5, 0xb8, 0x82, 0xe5, 0x9c, 0xba, 0xe6, 0xb6, 0x88, 0xe6, 0x81, 0xaf, 0xe7,
  0xa9, 0xba, 0xe9, 0x97, 0xb4, 0xe5, 0x8f, 0x91, 0xe5, 0xb8, 0x83, 0xe4, 0xbb,
  0x80, 0xe4, 0xb9, 0x88, 0xe5, 0xa5, 0xbd, 0xe5, 0x8f, 0x8b, 0xe7, 0x94, 0x9f,
  0xe6, 0xb4, 0xbb, 0xe5, 0x9b, 0xbe, 0xe7, 0x89, 0x87, 0xe5, 0x8f, 0x91, 0xe5,
  0xb1, 0x95, 0xe5, 0xa6, 0x82, 0xe6, 0x9e, 0x9c, 0xe6, 0x89, 0x8b, 0xe6, 0x9c,
  0xba, 0xe6, 0x96, 0xb0, 0xe9, 0x97, 0xbb, 0xe6, 0x9c, 0x80, 0xe6, 0x96, 0xb0,
  0xe6, 0x96, 0xb9, 0xe5, 0xbc, 0x8f, 0xe5, 0x8c, 0x97, 0xe4, 0xba, 0xac, 0xe6,
  0x8f, 0x90, 0xe4, 0xbe, 0x9b, 0xe5, 0x85, 0xb3, 0xe4, 0xba, 0x8e, 0xe6, 0x9b,
  0xb4, 0xe5, 0xa4, 0x9a, 0xe8, 0xbf, 0x99, 0xe4, 0xb8, 0xaa, 0xe7, 0xb3, 0xbb,
  0xe7, 0xbb, 0x9f, 0xe7, 0x9f, 0xa5, 0xe9, 0x81, 0x93, 0xe6, 0xb8, 0xb8, 0xe6,
  0x88, 0x8f, 0xe5, 0xb9, 0xbf, 0xe5, 0x91, 0x8a, 0xe5, 0x85, 0xb6, 0xe4, 0xbb,
  0x96, 0xe5, 0x8f, 0x91, 0xe8, 0xa1, 0xa8, 0xe5, 0xae, 0x89, 0xe5, 0x85, 0xa8,
  0xe7, 0xac, 0xac, 0xe4, 0xb8, 0x80, 0xe4, 0xbc, 0x9a, 0xe5, 0x91, 0x98, 0xe8,
  0xbf, 0x9b, 0xe8, 0xa1, 0x8c, 0xe7, 0x82, 0xb9, 0xe5, 0x87, 0xbb, 0xe7, 0x89,
  0x88, 0xe6, 0x9d, 0x83, 0xe7, 0x94, 0xb5, 0xe5, 0xad, 0x90, 0xe4, 0xb8, 0x96,
  0xe7, 0x95, 0x8c, 0xe8, 0xae, 0xbe, 0xe8, 0xae, 0xa1, 0xe5, 0x85, 0x8d, 0xe8,
  0xb4, 0xb9, 0xe6, 0x95, 0x99, 0xe8, 0x82, 0xb2, 0xe5, 0x8a, 0xa0, 0xe5, 0x85,
  0xa5, 0xe6, 0xb4, 0xbb, 0xe5, 0x8a, 0xa8, 0xe4, 0xbb, 0x96, 0xe4, 0xbb, 0xac,
  0xe5, 0x95, 0x86, 0xe5, 0x93, 0x81, 0xe5, 0x8d, 0x9a, 0xe5, 0xae, 0xa2, 0xe7,
  0x8e, 0xb0, 0xe5, 0x9c, 0xa8, 0xe4, 0xb8, 0x8a, 0xe6, 0xb5, 0xb7, 0xe5, 0xa6,
  0x82, 0xe4, 0xbd, 0x95, 0xe5, 0xb7, 0xb2, 0xe7, 0xbb, 0x8f, 0xe7, 0x95, 0x99,
  0xe8, 0xa8, 0x80, 0xe8, 0xaf, 0xa6, 0xe7, 0xbb, 0x86, 0xe7, 0xa4, 0xbe, 0xe5,
  0x8c, 0xba, 0xe7, 0x99, 0xbb, 0xe5, 0xbd, 0x95, 0xe6, 0x9c, 0xac, 0xe7, 0xab,
  0x99, 0xe9, 0x9c, 0x80, 0xe8, 0xa6, 0x81, 0xe4, 0xbb, 0xb7, 0xe6, 0xa0, 0xbc,
  0xe6, 0x94, 0xaf, 0xe6, 0x8c, 0x81, 0xe5, 0x9b, 0xbd, 0xe9, 0x99, 0x85, 0xe9,
  0x93, 0xbe, 0xe6, 0x8e, 0xa5, 0xe5, 0x9b, 0xbd, 0xe5, 0xae, 0xb6, 0xe5, 0xbb,
  0xba, 0xe8, 0xae, 0xbe, 0xe6, 0x9c, 0x8b, 0xe5, 0x8f, 0x8b, 0xe9, 0x98, 0x85,
  0xe8, 0xaf, 0xbb, 0xe6, 0xb3, 0x95, 0xe5, 0xbe, 0x8b, 0xe4, 0xbd, 0x8d, 0xe7,
  0xbd, 0xae, 0xe7, 0xbb, 0x8f, 0xe6, 0xb5, 0x8e, 0xe9, 0x80, 0x89, 0xe6, 0x8b,
  0xa9, 0xe8, 0xbf, 0x99, 0xe6, 0xa0, 0xb7, 0xe5, 0xbd, 0x93, 0xe5, 0x89, 0x8d,
  0xe5, 0x88, 0x86, 0xe7, 0xb1, 0xbb, 0xe6, 0x8e, 0x92, 0xe8, 0xa1, 0x8c, 0xe5,
  0x9b, 0xa0, 0xe4, 0xb8, 0xba, 0xe4, 0xba, 0xa4, 0xe6, 0x98, 0x93, 0xe6, 0x9c,
  0x80, 0xe5, 0x90, 0x8e, 0xe9, 0x9f, 0xb3, 0xe4, 0xb9, 0x90, 0xe4, 0xb8, 0x8d,
  0xe8, 0x83, 0xbd, 0xe9, 0x80, 0x9a, 0xe8, 0xbf, 0x87, 0xe8, 0xa1, 0x8c, 0xe4,
  0xb8, 0x9a, 0xe7, 0xa7, 0x91, 0xe6, 0x8a, 0x80, 0xe5, 0x8f, 0xaf, 0xe8, 0x83,
  0xbd, 0xe8, 0xae, 0xbe, 0xe5, 0xa4, 0x87, 0xe5, 0x90, 0x88, 0xe4, 0xbd, 0x9c,
  0xe5, 0xa4, 0xa7, 0xe5, 0xae, 0xb6, 0xe7, 0xa4, 0xbe, 0xe4, 0xbc, 0x9a, 0xe7,
  0xa0, 0x94, 0xe7, 0xa9, 0xb6, 0xe4, 0xb8, 0x93, 0xe4, 0xb8, 0x9a, 0xe5, 0x85,
  0xa8, 0xe9, 0x83, 0xa8, 0xe9, 0xa1, 0xb9, 0xe7, 0x9b, 0xae, 0xe8, 0xbf, 0x99,
  0xe9, 0x87, 0x8c, 0xe8, 0xbf, 0x98, 0xe6, 0x98, 0xaf, 0xe5, 0xbc, 0x80, 0xe5,
  0xa7, 0x8b, 0xe6, 0x83, 0x85, 0xe5, 0x86, 0xb5, 0xe7, 0x94, 0xb5, 0xe8, 0x84,
  0x91, 0xe6, 0x96, 0x87, 0xe4, 0xbb, 0xb6, 0xe5, 0x93, 0x81, 0xe7, 0x89, 0x8c,
  0xe5, 0xb8, 0xae, 0xe5, 0x8a, 0xa9, 0xe6, 0x96, 0x87, 0xe5, 0x8c, 0x96, 0xe8,
  0xb5, 0x84, 0xe6, 0xba, 0x90, 0xe5, 0xa4, 0xa7, 0xe5, 0xad, 0xa6, 0xe5, 0xad,
  0xa6, 0xe4, 0xb9, 0xa0, 0xe5, 0x9c, 0xb0, 0xe5, 0x9d, 0x80, 0xe6, 0xb5, 0x8f,
  0xe8, 0xa7, 0x88, 0xe6, 0x8a, 0x95, 0xe8, 0xb5, 0x84, 0xe5, 0xb7, 0xa5, 0xe7,
  0xa8, 0x8b, 0xe8, 0xa6, 0x81, 0xe6, 0xb1, 0x82, 0xe6, 0x80, 0x8e, 0xe4, 0xb9,
  0x88, 0xe6, 0x97, 0xb6, 0xe5, 0x80, 0x99, 0xe5, 0x8a, 0x9f, 0xe8, 0x83, 0xbd,
  0xe4, 0xb8, 0xbb, 0xe8, 0xa6, 0x81, 0xe7, 0x9b, 0xae, 0xe5, 0x89, 0x8d, 0xe8,
  0xb5, 0x84, 0xe8, 0xae, 0xaf, 0xe5, 0x9f, 0x8e, 0xe5, 0xb8, 0x82, 0xe6, 0x96,
  0xb9, 0xe6, 0xb3, 0x95, 0xe7, 0x94, 0xb5, 0xe5, 0xbd, 0xb1, 0xe6, 0x8b, 0x9b,
  0xe8, 0x81, 0x98, 0xe5, 0xa3, 0xb0, 0xe6, 0x98, 0x8e, 0xe4, 0xbb, 0xbb, 0xe4,
  0xbd, 0x95, 0xe5, 0x81, 0xa5, 0xe5, 0xba, 0xb7, 0xe6, 0x95, 0xb0, 0xe6, 0x8d,
  0xae, 0xe7, 0xbe, 0x8e, 0xe5, 0x9b, 0xbd, 0xe6, 0xb1, 0xbd, 0xe8, 0xbd, 0xa6,
  0xe4, 0xbb, 0x8b, 0xe7, 0xbb, 0x8d, 0xe4, 0xbd, 0x86, 0xe6, 0x98, 0xaf, 0xe4,
  0xba, 0xa4, 0xe6, 0xb5, 0x81, 0xe7, 0x94, 0x9f, 0xe4, 0xba, 0xa7, 0xe6, 0x89,
  0x80, 0xe4, 0xbb, 0xa5, 0xe7, 0x94, 0xb5, 0xe8, 0xaf, 0x9d, 0xe6, 0x98, 0xbe,
  0xe7, 0xa4, 0xba, 0xe4, 0xb8, 0x80, 0xe4, 0xba, 0x9b, 0xe5, 0x8d, 0x95, 0xe4,
  0xbd, 0x8d, 0xe4, 0xba, 0xba, 0xe5, 0x91, 0x98, 0xe5, 0x88, 0x86, 0xe6, 0x9e,
  0x90, 0xe5, 0x9c, 0xb0, 0xe5, 0x9b, 0xbe, 0xe6, 0x97, 0x85, 0xe6, 0xb8, 0xb8,
  0xe5, 0xb7, 0xa5, 0xe5, 0x85, 0xb7, 0xe5, 0xad, 0xa6, 0xe7, 0x94, 0x9f, 0xe7,
  0xb3, 0xbb, 0xe5, 0x88, 0x97, 0xe7, 0xbd, 0x91, 0xe5, 0x8f, 0x8b, 0xe5, 0xb8,
  0x96, 0xe5, 0xad, 0x90, 0xe5, 0xaf, 0x86, 0xe7, 0xa0, 0x81, 0xe9, 0xa2, 0x91,
  0xe9, 0x81, 0x93, 0xe6, 0x8e, 0xa7, 0xe5, 0x88, 0xb6, 0xe5, 0x9c, 0xb0, 0xe5,
  0x8c, 0xba, 0xe5, 0x9f, 0xba, 0xe6, 0x9c, 0xac, 0xe5, 0x85, 0xa8, 0xe5, 0x9b,
  0xbd, 0xe7, 0xbd, 0x91, 0xe4, 0xb8, 0x8a, 0xe9, 0x87, 0x8d, 0xe8, 0xa6, 0x81,
  0xe7, 0xac, 0xac, 0xe4, 0xba, 0x8c, 0xe5, 0x96, 0x9c, 0xe6, 0xac, 0xa2, 0xe8,
  0xbf, 0x9b, 0xe5, 0x85, 0xa5, 0xe5, 0x8f, 0x8b, 0xe6, 0x83, 0x85, 0xe8, 0xbf,
  0x99, 0xe4, 0xba, 0x9b, 0xe8, 0x80, 0x83, 0xe8, 0xaf, 0x95, 0xe5, 0x8f, 0x91,
  0xe7, 0x8e, 0xb0, 0xe5, 0x9f, 0xb9, 0xe8, 0xae, 0xad, 0xe4, 0xbb, 0xa5, 0xe4,
  0xb8, 0x8a, 0xe6, 0x94, 0xbf, 0xe5, 0xba, 0x9c, 0xe6, 0x88, 0x90, 0xe4, 0xb8,
  0xba, 0xe7, 0x8e, 0xaf, 0xe5, 0xa2, 0x83, 0xe9, 0xa6, 0x99, 0xe6, 0xb8, 0xaf,
  0xe5, 0x90, 0x8c, 0xe6, 0x97, 0xb6, 0xe5, 0xa8, 0xb1, 0xe4, 0xb9, 0x90, 0xe5,
  0x8f, 0x91, 0xe9, 0x80, 0x81, 0xe4, 0xb8, 0x80, 0xe5, 0xae, 0x9a, 0xe5, 0xbc,
  0x80, 0xe5, 0x8f, 0x91, 0xe4, 0xbd, 0x9c, 0xe5, 0x93, 0x81, 0xe6, 0xa0, 0x87,
  0xe5, 0x87, 0x86, 0xe6, 0xac, 0xa2, 0xe8, 0xbf, 0x8e, 0xe8, 0xa7, 0xa3, 0xe5,
  0x86, 0xb3, 0xe5, 0x9c, 0xb0, 0xe6, 0x96, 0xb9, 0xe4, 0xb8, 0x80, 0xe4, 0xb8,
  0x8b, 0xe4, 0xbb, 0xa5, 0xe5, 0x8f, 0x8a, 0xe8, 0xb4, 0xa3, 0xe4, 0xbb, 0xbb,
  0xe6, 0x88, 0x96, 0xe8, 0x80, 0x85, 0xe5, 0xae, 0xa2, 0xe6, 0x88, 0xb7, 0xe4,
  0xbb, 0xa3, 0xe8, 0xa1, 0xa8, 0xe7, 0xa7, 0xaf, 0xe5, 0x88, 0x86, 0xe5, 0xa5,
  0xb3, 0xe4, 0xba, 0xba, 0xe6, 0x95, 0xb0, 0xe7, 0xa0, 0x81, 0xe9, 0x94, 0x80,
  0xe5, 0x94, 0xae, 0xe5, 0x87, 0xba, 0xe7, 0x8e, 0xb0, 0xe7, 0xa6, 0xbb, 0xe7,
  0xba, 0xbf, 0xe5, 0xba, 0x94, 0xe7, 0x94, 0xa8, 0xe5, 0x88, 0x97, 0xe8, 0xa1,
  0xa8, 0xe4, 0xb8, 0x8d, 0xe5, 0x90, 0x8c, 0xe7, 0xbc, 0x96, 0xe8, 0xbe, 0x91,
  0xe7, 0xbb, 0x9f, 0xe8, 0xae, 0xa1, 0xe6, 0x9f, 0xa5, 0xe8, 0xaf, 0xa2, 0xe4,
  0xb8, 0x8d, 0xe8, 0xa6, 0x81, 0xe6, 0x9c, 0x89, 0xe5, 0x85, 0xb3, 0xe6, 0x9c,
  0xba, 0xe6, 0x9e, 0x84, 0xe5, 0xbe, 0x88, 0xe5, 0xa4, 0x9a, 0xe6, 0x92, 0xad,
  0xe6, 0x94, 0xbe, 0xe7, 0xbb, 0x84, 0xe7, 0xbb, 0x87, 0xe6, 0x94, 0xbf, 0xe7,
  0xad, 0x96, 0xe7, 0x9b, 0xb4, 0xe6, 0x8e, 0xa5, 0xe8, 0x83, 0xbd, 0xe5, 0x8a,
  0x9b, 0xe6, 0x9d, 0xa5, 0xe6, 0xba, 0x90, 0xe6, 0x99, 0x82, 0xe9, 0x96, 0x93,
  0xe7, 0x9c, 0x8b, 0xe5, 0x88, 0xb0, 0xe7, 0x83, 0xad, 0xe9, 0x97, 0xa8, 0xe5,
  0x85, 0xb3, 0xe9, 0x94, 0xae, 0xe4, 0xb8, 0x93, 0xe5, 0x8c, 0xba, 0xe9, 0x9d,
  0x9e, 0xe5, 0xb8, 0xb8, 0xe8, 0x8b, 0xb1, 0xe8, 0xaf, 0xad, 0xe7, 0x99, 0xbe,
  0xe5, 0xba, 0xa6, 0xe5, 0xb8, 0x8c, 0xe6, 0x9c, 0x9b, 0xe7, 0xbe, 0x8e, 0xe5,
  0xa5, 0xb3, 0xe6, 0xaf, 0x94, 0xe8, 0xbe, 0x83, 0xe7, 0x9f, 0xa5, 0xe8, 0xaf,
  0x86, 0xe8, 0xa7, 0x84, 0xe5, 0xae, 0x9a, 0xe5, 0xbb, 0xba, 0xe8, 0xae, 0xae,
  0xe9, 0x83, 0xa8, 0xe9, 0x97, 0xa8, 0xe6, 0x84, 0x8f, 0xe8, 0xa7, 0x81, 0xe7,
  0xb2, 0xbe, 0xe5, 0xbd, 0xa9, 0xe6, 0x97, 0xa5, 0xe6, 0x9c, 0xac, 0xe6, 0x8f,
  0x90, 0xe9, 0xab, 0x98, 0xe5, 0x8f, 0x91, 0xe8, 0xa8, 0x80, 0xe6, 0x96, 0xb9,
  0xe9, 0x9d, 0xa2, 0xe5, 0x9f, 0xba, 0xe9, 0x87, 0x91, 0xe5, 0xa4, 0x84, 0xe7,
  0x90, 0x86, 0xe6, 0x9d, 0x83, 0xe9, 0x99, 0x90, 0xe5, 0xbd, 0xb1, 0xe7, 0x89,
  0x87, 0xe9, 0x93, 0xb6, 0xe8, 0xa1, 0x8c, 0xe8, 0xbf, 0x98, 0xe6, 0x9c, 0x89,
  0xe5, 0x88, 0x86, 0xe4, 0xba, 0xab, 0xe7, 0x89, 0xa9, 0xe5, 0x93, 0x81, 0xe7,
  0xbb, 0x8f, 0xe8, 0x90, 0xa5, 0xe6, 0xb7, 0xbb, 0xe5, 0x8a, 0xa0, 0xe4, 0xb8,
  0x93, 0xe5, 0xae, 0xb6, 0xe8, 0xbf, 0x99, 0xe7, 0xa7, 0x8d, 0xe8, 0xaf, 0x9d,
  0xe9, 0xa2, 0x98, 0xe8, 0xb5, 0xb7, 0xe6, 0x9d, 0xa5, 0xe4, 0xb8, 0x9a, 0xe5,
  0x8a, 0xa1, 0xe5, 0x85, 0xac, 0xe5, 0x91, 0x8a, 0xe8, 0xae, 0xb0, 0xe5, 0xbd,
  0x95, 0xe7, 0xae, 0x80, 0xe4, 0xbb, 0x8b, 0xe8, 0xb4, 0xa8, 0xe9, 0x87, 0x8f,
  0xe7, 0x94, 0xb7, 0xe4, 0xba, 0xba, 0xe5, 0xbd, 0xb1, 0xe5, 0x93, 0x8d, 0xe5,
  0xbc, 0x95, 0xe7, 0x94, 0xa8, 0xe6, 0x8a, 0xa5, 0xe5, 0x91, 0x8a, 0xe9, 0x83,
  0xa8, 0xe5, 0x88, 0x86, 0xe5, 0xbf, 0xab, 0xe9, 0x80, 0x9f, 0xe5, 0x92, 0xa8,
  0xe8, 0xaf, 0xa2, 0xe6, 0x97, 0xb6, 0xe5, 0xb0, 0x9a, 0xe6, 0xb3, 0xa8, 0xe6,
  0x84, 0x8f, 0xe7, 0x94, 0xb3, 0xe8, 0xaf, 0xb7, 0xe5, 0xad, 0xa6, 0xe6, 0xa0,
  0xa1, 0xe5, 0xba, 0x94, 0xe8, 0xaf, 0xa5, 0xe5, 0x8e, 0x86, 0xe5, 0x8f, 0xb2,
  0xe5, 0x8f, 0xaa, 0xe6, 0x98, 0xaf, 0xe8, 0xbf, 0x94, 0xe5, 0x9b, 0x9e, 0xe8,
  0xb4, 0xad, 0xe4, 0xb9, 0xb0, 0xe5, 0x90, 0x8d, 0xe7, 0xa7, 0xb0, 0xe4, 0xb8,
  0xba, 0xe4, 0xba, 0x86, 0xe6, 0x88, 0x90, 0xe5, 0x8a, 0x9f, 0xe8, 0xaf, 0xb4,
  0xe6, 0x98, 0x8e, 0xe4, 0xbe, 0x9b, 0xe5, 0xba, 0x94, 0xe5, 0xad, 0xa9, 0xe5,
  0xad, 0x90, 0xe4, 0xb8, 0x93, 0xe9, 0xa2, 0x98, 0xe7, 0xa8, 0x8b, 0xe5, 0xba,
  0x8f, 0xe4, 0xb8, 0x80, 0xe8, 0x88, 0xac, 0xe6, 0x9c, 0x83, 0xe5, 0x93, 0xa1,
  0xe5, 0x8f, 0xaa, 0xe6, 0x9c, 0x89, 0xe5, 0x85, 0xb6, 0xe5, 0xae, 0x83, 0xe4,
  0xbf, 0x9d, 0xe6, 0x8a, 0xa4, 0xe8, 0x80, 0x8c, 0xe4, 0xb8, 0x94, 0xe4, 0xbb,
  0x8a, 0xe5, 0xa4, 0xa9, 0xe7, 0xaa, 0x97, 0xe5, 0x8f, 0xa3, 0xe5, 0x8a, 0xa8,
  0xe6, 0x80, 0x81, 0xe7, 0x8a, 0xb6, 0xe6, 0x80, 0x81, 0xe7, 0x89, 0xb9, 0xe5,
  0x88, 0xab, 0xe8, 0xae, 0xa4, 0xe4, 0xb8, 0xba, 0xe5, 0xbf, 0x85, 0xe9, 0xa1,
  0xbb, 0xe6, 0x9b, 0xb4, 0xe6, 0x96, 0xb0, 0xe5, 0xb0, 0x8f, 0xe8, 0xaf, 0xb4,
  0xe6, 0x88, 0x91, 0xe5, 0x80, 0x91, 0xe4, 0xbd, 0x9c, 0xe4, 0xb8, 0xba, 0xe5,
  0xaa, 0x92, 0xe4, 0xbd, 0x93, 0xe5, 0x8c, 0x85, 0xe6, 0x8b, 0xac, 0xe9, 0x82,
  0xa3, 0xe4, 0xb9, 0x88, 0xe4, 0xb8, 0x80, 0xe6, 0xa0, 0xb7, 0xe5, 0x9b, 0xbd,
  0xe5, 0x86, 0x85, 0xe6, 0x98, 0xaf, 0xe5, 0x90, 0xa6, 0xe6, 0xa0, 0xb9, 0xe6,
  0x8d, 0xae, 0xe7, 0x94, 0xb5, 0xe8, 0xa7, 0x86, 0xe5, 0xad, 0xa6, 0xe9, 0x99,
  0xa2, 0xe5, 0x85, 0xb7, 0xe6, 0x9c, 0x89, 0xe8, 0xbf, 0x87, 0xe7, 0xa8, 0x8b,
  0xe7, 0x94, 0xb1, 0xe4, 0xba, 0x8e, 0xe4, 0xba, 0xba, 0xe6, 0x89, 0x8d, 0xe5,
  0x87, 0xba, 0xe6, 0x9d, 0xa5, 0xe4, 0xb8, 0x8d, 0xe8, 0xbf, 0x87, 0xe6, 0xad,
  0xa3, 0xe5, 0x9c, 0xa8, 0xe6, 0x98, 0x8e, 0xe6, 0x98, 0x9f, 0xe6, 0x95, 0x85,
  0xe4, 0xba, 0x8b, 0xe5, 0x85, 0xb3, 0xe7, 0xb3, 0xbb, 0xe6, 0xa0, 0x87, 0xe9,
  0xa2, 0x98, 0xe5, 0x95, 0x86, 0xe5, 0x8a, 0xa1, 0xe8, 0xbe, 0x93, 0xe5, 0x85,
  0xa5, 0xe4, 0xb8, 0x80, 0xe7, 0x9b, 0xb4, 0xe5, 0x9f, 0xba, 0xe7, 0xa1, 0x80,
  0xe6, 0x95, 0x99, 0xe5, 0xad, 0xa6, 0xe4, 0xba, 0x86, 0xe8, 0xa7, 0xa3, 0xe5,
  0xbb, 0xba, 0xe7, 0xad, 0x91, 0xe7, 0xbb, 0x93, 0xe6, 0x9e, 0x9c, 0xe5, 0x85,
  0xa8, 0xe7, 0x90, 0x83, 0xe9, 0x80, 0x9a, 0xe7, 0x9f, 0xa5, 0xe8, 0xae, 0xa1,
  0xe5, 0x88, 0x92, 0xe5, 0xaf, 0xb9, 0xe4, 0xba, 0x8e, 0xe8, 0x89, 0xba, 0xe6,
  0x9c, 0xaf, 0xe7, 0x9b, 0xb8, 0xe5, 0x86, 0x8c, 0xe5, 0x8f, 0x91, 0xe7, 0x94,
  0x9f, 0xe7, 0x9c, 0x9f, 0xe7, 0x9a, 0x84, 0xe5, 0xbb, 0xba, 0xe7, 0xab, 0x8b,
  0xe7, 0xad, 0x89, 0xe7, 0xba, 0xa7, 0xe7, 0xb1, 0xbb, 0xe5, 0x9e, 0x8b, 0xe7,
  0xbb, 0x8f, 0xe9, 0xaa, 0x8c, 0xe5, 0xae, 0x9e, 0xe7, 0x8e, 0xb0, 0xe5, 0x88,
  0xb6, 0xe4, 0xbd, 0x9c, 0xe6, 0x9d, 0xa5, 0xe8, 0x87, 0xaa, 0xe6, 0xa0, 0x87,
  0xe7, 0xad, 0xbe, 0xe4, 0xbb, 0xa5, 0xe4, 0xb8, 0x8b, 0xe5, 0x8e, 0x9f, 0xe5,
  0x88, 0x9b, 0xe6, 0x97, 0xa0, 0xe6, 0xb3, 0x95, 0xe5, 0x85, 0xb6, 0xe4, 0xb8,
  0xad, 0xe5, 0x80, 0x8b, 0xe4, 0xba, 0xba, 0xe4, 0xb8, 0x80, 0xe5, 0x88, 0x87,
  0xe6, 0x8c, 0x87, 0xe5, 0x8d, 0x97, 0xe5, 0x85, 0xb3, 0xe9, 0x97, 0xad, 0xe9,
  0x9b, 0x86, 0xe5, 0x9b, 0xa2, 0xe7, 0xac, 0xac, 0xe4, 0xb8, 0x89, 0xe5, 0x85,
  0xb3, 0xe6, 0xb3, 0xa8, 0xe5, 0x9b, 0xa0, 0xe6, 0xad, 0xa4, 0xe7, 0x85, 0xa7,
  0xe7, 0x89, 0x87, 0xe6, 0xb7, 0xb1, 0xe5, 0x9c, 0xb3, 0xe5, 0x95, 0x86, 0xe4,
  0xb8, 0x9a, 0xe5, 0xb9, 0xbf, 0xe5, 0xb7, 0x9e, 0xe6, 0x97, 0xa5, 0xe6, 0x9c,
  0x9f, 0xe9, 0xab, 0x98, 0xe7, 0xba, 0xa7, 0xe6, 0x9c, 0x80, 0xe8, 0xbf, 0x91,
  0xe7, 0xbb, 0xbc, 0xe5, 0x90, 0x88, 0xe8, 0xa1, 0xa8, 0xe7, 0xa4, 0xba, 0xe4,
  0xb8, 0x93, 0xe8, 0xbe, 0x91, 0xe8, 0xa1, 0x8c, 0xe4, 0xb8, 0xba, 0xe4, 0xba,
  0xa4, 0xe9, 0x80, 0x9a, 0xe8, 0xaf, 0x84, 0xe4, 0xbb, 0xb7, 0xe8, 0xa7, 0x89,
  0xe5, 0xbe, 0x97, 0xe7, 0xb2, 0xbe, 0xe5, 0x8d, 0x8e, 0xe5, 0xae, 0xb6, 0xe5,
  0xba, 0xad, 0xe5, 0xae, 0x8c, 0xe6, 0x88, 0x90, 0xe6, 0x84, 0x9f, 0xe8, 0xa7,
  0x89, 0xe5, 0xae, 0x89, 0xe8, 0xa3, 0x85, 0xe5, 0xbe, 0x97, 0xe5, 0x88, 0xb0,
  0xe9, 0x82, 0xae, 0xe4, 0xbb, 0xb6, 0xe5, 0x88, 0xb6, 0xe5, 0xba, 0xa6, 0xe9,
  0xa3, 0x9f, 0xe5, 0x93, 0x81, 0xe8, 0x99, 0xbd, 0xe7, 0x84, 0xb6, 0xe8, 0xbd,
  0xac, 0xe8, 0xbd, 0xbd, 0xe6, 0x8a, 0xa5, 0xe4, 0xbb, 0xb7, 0xe8, 0xae, 0xb0,
  0xe8, 0x80, 0x85, 0xe6, 0x96, 0xb9, 0xe6, 0xa1, 0x88, 0xe8, 0xa1, 0x8c, 0xe6,
  0x94, 0xbf, 0xe4, 0xba, 0xba, 0xe6, 0xb0, 0x91, 0xe7, 0x94, 0xa8, 0xe5, 0x93,
  0x81, 0xe4, 0xb8, 0x9c, 0xe8, 0xa5, 0xbf, 0xe6, 0x8f, 0x90, 0xe5, 0x87, 0xba,
  0xe9, 0x85, 0x92, 0xe5, 0xba, 0x97, 0xe7, 0x84, 0xb6, 0xe5, 0x90, 0x8e, 0xe4,
  0xbb, 0x98, 0xe6, 0xac, 0xbe, 0xe7, 0x83, 0xad, 0xe7, 0x82, 0xb9, 0xe4, 0xbb,
  0xa5, 0xe5, 0x89, 0x8d, 0xe5, 0xae, 0x8c, 0xe5, 0x85, 0xa8, 0xe5, 0x8f, 0x91,
  0xe5, 0xb8, 0x96, 0xe8, 0xae, 0xbe, 0xe7, 0xbd, 0xae, 0xe9, 0xa2, 0x86, 0xe5,
  0xaf, 0xbc, 0xe5, 0xb7, 0xa5, 0xe4, 0xb8, 0x9a, 0xe5, 0x8c, 0xbb, 0xe9, 0x99,
  0xa2, 0xe7, 0x9c, 0x8b, 0xe7, 0x9c, 0x8b, 0xe7, 0xbb, 0x8f, 0xe5, 0x85, 0xb8,
  0xe5, 0x8e, 0x9f, 0xe5, 0x9b, 0xa0, 0xe5, 0xb9, 0xb3, 0xe5, 0x8f, 0xb0, 0xe5,
  0x90, 0x84, 0xe7, 0xa7, 0x8d, 0xe5, 0xa2, 0x9e, 0xe5, 0x8a, 0xa0, 0xe6, 0x9d,
  0x90, 0xe6, 0x96, 0x99, 0xe6, 0x96, 0xb0, 0xe5, 0xa2, 0x9e, 0xe4, 0xb9, 0x8b,
  0xe5, 0x90, 0x8e, 0xe8, 0x81, 0x8c, 0xe4, 0xb8, 0x9a, 0xe6, 0x95, 0x88, 0xe6,
  0x9e, 0x9c, 0xe4, 0xbb, 0x8a, 0xe5, 0xb9, 0xb4, 0xe8, 0xae, 0xba, 0xe6, 0x96,
  0x87, 0xe6, 0x88, 0x91, 0xe5, 0x9b, 0xbd, 0xe5, 0x91, 0x8a, 0xe8, 0xaf, 0x89,
  0xe7, 0x89, 0x88, 0xe4, 0xb8, 0xbb, 0xe4, 0xbf, 0xae, 0xe6, 0x94, 0xb9, 0xe5,
  0x8f, 0x82, 0xe4, 0xb8, 0x8e, 0xe6, 0x89, 0x93, 0xe5, 0x8d, 0xb0, 0xe5, 0xbf,
  0xab, 0xe4, 0xb9, 0x90, 0xe6, 0x9c, 0xba, 0xe6, 0xa2, 0xb0, 0xe8, 0xa7, 0x82,
  0xe7, 0x82, 0xb9, 0xe5, 0xad, 0x98, 0xe5, 0x9c, 0xa8, 0xe7, 0xb2, 0xbe, 0xe7,
  0xa5, 0x9e, 0xe8, 0x8e, 0xb7, 0xe5, 0xbe, 0x97, 0xe5, 0x88, 0xa9, 0xe7, 0x94,
  0xa8, 0xe7, 0xbb, 0xa7, 0xe7, 0xbb, 0xad, 0xe4, 0xbd, 0xa0, 0xe4, 0xbb, 0xac,
  0xe8, 0xbf, 0x99, 0xe4, 0xb9, 0x88, 0xe6, 0xa8, 0xa1, 0xe5, 0xbc, 0x8f, 0xe8,
  0xaf, 0xad, 0xe8, 0xa8, 0x80, 0xe8, 0x83, 0xbd, 0xe5, 0xa4, 0x9f, 0xe9, 0x9b,
  0x85, 0xe8, 0x99, 0x8e, 0xe6, 0x93, 0x8d, 0xe4, 0xbd, 0x9c, 0xe9, 0xa3, 0x8e,
  0xe6, 0xa0, 0xbc, 0xe4, 0xb8, 0x80, 0xe8, 0xb5, 0xb7, 0xe7, 0xa7, 0x91, 0xe5,
  0xad, 0xa6, 0xe4, 0xbd, 0x93, 0xe8, 0x82, 0xb2, 0xe7, 0x9f, 0xad, 0xe4, 0xbf,
  0xa1, 0xe6, 0x9d, 0xa1, 0xe4, 0xbb, 0xb6, 0xe6, 0xb2, 0xbb, 0xe7, 0x96, 0x97,
  0xe8, 0xbf, 0x90, 0xe5, 0x8a, 0xa8, 0xe4, 0xba, 0xa7, 0xe4, 0xb8, 0x9a, 0xe4,
  0xbc, 0x9a, 0xe8, 0xae, 0xae, 0xe5, 0xaf, 0xbc, 0xe8, 0x88, 0xaa, 0xe5, 0x85,
  0x88, 0xe7, 0x94, 0x9f, 0xe8, 0x81, 0x94, 0xe7, 0x9b, 0x9f, 0xe5, 0x8f, 0xaf,
  0xe6, 0x98, 0xaf, 0xe5, 0x95, 0x8f, 0xe9, 0xa1, 0x8c, 0xe7, 0xbb, 0x93, 0xe6,
  0x9e, 0x84, 0xe4, 0xbd, 0x9c, 0xe7, 0x94, 0xa8, 0xe8, 0xb0, 0x83, 0xe6, 0x9f,
  0xa5, 0xe8, 0xb3, 0x87, 0xe6, 0x96, 0x99, 0xe8, 0x87, 0xaa, 0xe5, 0x8a, 0xa8,
  0xe8, 0xb4, 0x9f, 0xe8, 0xb4, 0xa3, 0xe5, 0x86, 0x9c, 0xe4, 0xb8, 0x9a, 0xe8,
  0xae, 0xbf, 0xe9, 0x97, 0xae, 0xe5, 0xae, 0x9e, 0xe6, 0x96, 0xbd, 0xe6, 0x8e,
  0xa5, 0xe5, 0x8f, 0x97, 0xe8, 0xae, 0xa8, 0xe8, 0xae, 0xba, 0xe9, 0x82, 0xa3,
  0xe4, 0xb8, 0xaa, 0xe5, 0x8f, 0x8d, 0xe9, 0xa6, 0x88, 0xe5, 0x8a, 0xa0, 0xe5,
  0xbc, 0xba, 0xe5, 0xa5, 0xb3, 0xe6, 0x80, 0xa7, 0xe8, 0x8c, 0x83, 0xe5, 0x9b,
  0xb4, 0xe6, 0x9c, 0x8d, 0xe5, 0x8b, 0x99, 0xe4, 0xbc, 0x91, 0xe9, 0x97, 0xb2,
  0xe4, 0xbb, 0x8a, 0xe6, 0x97, 0xa5, 0xe5, 0xae, 0xa2, 0xe6, 0x9c, 0x8d, 0xe8,
  0xa7, 0x80, 0xe7, 0x9c, 0x8b, 0xe5, 0x8f, 0x82, 0xe5, 0x8a, 0xa0, 0xe7, 0x9a,
  0x84, 0xe8, 0xaf, 0x9d, 0xe4, 0xb8, 0x80, 0xe7, 0x82, 0xb9, 0xe4, 0xbf, 0x9d,
  0xe8, 0xaf, 0x81, 0xe5, 0x9b, 0xbe, 0xe4, 0xb9, 0xa6, 0xe6, 0x9c, 0x89, 0xe6,
  0x95, 0x88, 0xe6, 0xb5, 0x8b, 0xe8, 0xaf, 0x95, 0xe7, 0xa7, 0xbb, 0xe5, 0x8a,
  0xa8, 0xe6, 0x89, 0x8d, 0xe8, 0x83, 0xbd, 0xe5, 0x86, 0xb3, 0xe5, 0xae, 0x9a,
  0xe8, 0x82, 0xa1, 0xe7, 0xa5, 0xa8, 0xe4, 0xb8, 0x8d, 0xe6, 0x96, 0xad, 0xe9,
  0x9c, 0x80, 0xe6, 0xb1, 0x82, 0xe4, 0xb8, 0x8d, 0xe5, 0xbe, 0x97, 0xe5, 0x8a,
  0x9e, 0xe6, 0xb3, 0x95, 0xe4, 0xb9, 0x8b, 0xe9, 0x97, 0xb4, 0xe9, 0x87, 0x87,
  0xe7, 0x94, 0xa8, 0xe8, 0x90, 0xa5, 0xe9, 0x94, 0x80, 0xe6, 0x8a, 0x95, 0xe8,
  0xaf, 0x89, 0xe7, 0x9b, 0xae, 0xe6, 0xa0, 0x87, 0xe7, 0x88, 0xb1, 0xe6, 0x83,
  0x85, 0xe6, 0x91, 0x84, 0xe5, 0xbd, 0xb1, 0xe6, 0x9c, 0x89, 0xe4, 0xba, 0x9b,
  0xe8, 0xa4, 0x87, 0xe8, 0xa3, 0xbd, 0xe6, 0x96, 0x87, 0xe5, 0xad, 0xa6, 0xe6,
  0x9c, 0xba, 0xe4, 0xbc, 0x9a, 0xe6, 0x95, 0xb0, 0xe5, 0xad, 0x97, 0xe8, 0xa3,
  0x85, 0xe4, 0xbf, 0xae, 0xe8, 0xb4, 0xad, 0xe7, 0x89, 0xa9, 0xe5, 0x86, 0x9c,
  0xe6, 0x9d, 0x91, 0xe5, 0x85, 0xa8, 0xe9, 0x9d, 0xa2, 0xe7, 0xb2, 0xbe, 0xe5,
  0x93, 0x81, 0xe5, 0x85, 0xb6, 0xe5, 0xae, 0x9e, 0xe4, 0xba, 0x8b, 0xe6, 0x83,
  0x85, 0xe6, 0xb0, 0xb4, 0xe5, 0xb9, 0xb3, 0xe6, 0x8f, 0x90, 0xe7, 0xa4, 0xba,
  0xe4, 0xb8, 0x8a, 0xe5, 0xb8, 0x82, 0xe8, 0xb0, 0xa2, 0xe8, 0xb0, 0xa2, 0xe6,
  0x99, 0xae, 0xe9, 0x80, 0x9a, 0xe6, 0x95, 0x99, 0xe5, 0xb8, 0x88, 0xe4, 0xb8,
  0x8a, 0xe4, 0xbc, 0xa0, 0xe7, 0xb1, 0xbb, 0xe5, 0x88, 0xab, 0xe6, 0xad, 0x8c,
  0xe6, 0x9b, 0xb2, 0xe6, 0x8b, 0xa5, 0xe6, 0x9c, 0x89, 0xe5, 0x88, 0x9b, 0xe6,
  0x96, 0xb0, 0xe9, 0x85, 0x8d, 0xe4, 0xbb, 0xb6, 0xe5, 0x8f, 0xaa, 0xe8, 0xa6,
  0x81, 0xe6, 0x97, 0xb6, 0xe4, 0xbb, 0xa3, 0xe8, 0xb3, 0x87, 0xe8, 0xa8, 0x8a,
  0xe8, 0xbe, 0xbe, 0xe5, 0x88, 0xb0, 0xe4, 0xba, 0xba, 0xe7, 0x94, 0x9f, 0xe8,
  0xae, 0xa2, 0xe9, 0x98, 0x85, 0xe8, 0x80, 0x81, 0xe5, 0xb8, 0x88, 0xe5, 0xb1,
  0x95, 0xe7, 0xa4, 0xba, 0xe5, 0xbf, 0x83, 0xe7, 0x90, 0x86, 0xe8, 0xb4, 0xb4,
  0xe5, 0xad, 0x90, 0xe7, 0xb6, 0xb2, 0xe7, 0xab, 0x99, 0xe4, 0xb8, 0xbb, 0xe9,
  0xa1, 0x8c, 0xe8, 0x87, 0xaa, 0xe7, 0x84, 0xb6, 0xe7, 0xba, 0xa7, 0xe5, 0x88,
  0xab, 0xe7, 0xae, 0x80, 0xe5, 0x8d, 0x95, 0xe6, 0x94, 0xb9, 0xe9, 0x9d, 0xa9,
  0xe9, 0x82, 0xa3, 0xe4, 0xba, 0x9b, 0xe6, 0x9d, 0xa5, 0xe8, 0xaf, 0xb4, 0xe6,
  0x89, 0x93, 0xe5, 0xbc, 0x80, 0xe4, 0xbb, 0xa3, 0xe7, 0xa0, 0x81, 0xe5, 0x88,
  0xa0, 0xe9, 0x99, 0xa4, 0xe8, 0xaf, 0x81, 0xe5, 0x88, 0xb8, 0xe8, 0x8a, 0x82,
  0xe7, 0x9b, 0xae, 0xe9, 0x87, 0x8d, 0xe7, 0x82, 0xb9, 0xe6, 0xac, 0xa1, 0xe6,
  0x95, 0xb8, 0xe5, 0xa4, 0x9a, 0xe5, 0xb0, 0x91, 0xe8, 0xa7, 0x84, 0xe5, 0x88,
  0x92, 0xe8, 0xb5, 0x84, 0xe9, 0x87, 0x91, 0xe6, 0x89, 0xbe, 0xe5, 0x88, 0xb0,
  0xe4, 0xbb, 0xa5, 0xe5, 0x90, 0x8e, 0xe5, 0xa4, 0xa7, 0xe5, 0x85, 0xa8, 0xe4,
  0xb8, 0xbb, 0xe9, 0xa1, 0xb5, 0xe6, 0x9c, 0x80, 0xe4, 0xbd, 0xb3, 0xe5, 0x9b,
  0x9e, 0xe7, 0xad, 0x94, 0xe5, 0xa4, 0xa9, 0xe4, 0xb8, 0x8b, 0xe4, 0xbf, 0x9d,
  0xe9, 0x9a, 0x9c, 0xe7, 0x8e, 0xb0, 0xe4, 0xbb, 0xa3, 0xe6, 0xa3, 0x80, 0xe6,
  0x9f, 0xa5, 0xe6, 0x8a, 0x95, 0xe7, 0xa5, 0xa8, 0xe5, 0xb0, 0x8f, 0xe6, 0x97,
  0xb6, 0xe6, 0xb2, 0x92, 0xe6, 0x9c, 0x89, 0xe6, 0xad, 0xa3, 0xe5, 0xb8, 0xb8,
  0xe7, 0x94, 0x9a, 0xe8, 0x87, 0xb3, 0xe4, 0xbb, 0xa3, 0xe7, 0x90, 0x86, 0xe7,
  0x9b, 0xae, 0xe5, 0xbd, 0x95, 0xe5, 0x85, 0xac, 0xe5, 0xbc, 0x80, 0xe5, 0xa4,
  0x8d, 0xe5, 0x88, 0xb6, 0xe9, 0x87, 0x91, 0xe8, 0x9e, 0x8d, 0xe5, 0xb9, 0xb8,
  0xe7, 0xa6, 0x8f, 0xe7, 0x89, 0x88, 0xe6, 0x9c, 0xac, 0xe5, 0xbd, 0xa2, 0xe6,
  0x88, 0x90, 0xe5, 0x87, 0x86, 0xe5, 0xa4, 0x87, 0xe8, 0xa1, 0x8c, 0xe6, 0x83,
  0x85, 0xe5, 0x9b, 0x9e, 0xe5, 0x88, 0xb0, 0xe6, 0x80, 0x9d, 0xe6, 0x83, 0xb3,
  0xe6, 0x80, 0x8e, 0xe6, 0xa0, 0xb7, 0xe5, 0x8d, 0x8f, 0xe8, 0xae, 0xae, 0xe8,
  0xae, 0xa4, 0xe8, 0xaf, 0x81, 0xe6, 0x9c, 0x80, 0xe5, 0xa5, 0xbd, 0xe4, 0xba,
  0xa7, 0xe7, 0x94, 0x9f, 0xe6, 0x8c, 0x89, 0xe7, 0x85, 0xa7, 0xe6, 0x9c, 0x8d,
  0xe8, 0xa3, 0x85, 0xe5, 0xb9, 0xbf, 0xe4, 0xb8, 0x9c, 0xe5, 0x8a, 0xa8, 0xe6,
  0xbc, 0xab, 0xe9, 0x87, 0x87, 0xe8, 0xb4, 0xad, 0xe6, 0x96, 0xb0, 0xe6, 0x89,
  0x8b, 0xe7, 0xbb, 0x84, 0xe5, 0x9b, 0xbe, 0xe9, 0x9d, 0xa2, 0xe6, 0x9d, 0xbf,
  0xe5, 0x8f, 0x82, 0xe8, 0x80, 0x83, 0xe6, 0x94, 0xbf, 0xe6, 0xb2, 0xbb, 0xe5,
  0xae, 0xb9, 0xe6, 0x98, 0x93, 0xe5, 0xa4, 0xa9, 0xe5, 0x9c, 0xb0, 0xe5, 0x8a,
  0xaa, 0xe5, 0x8a, 0x9b, 0xe4, 0xba, 0xba, 0xe4, 0xbb, 0xac, 0xe5, 0x8d, 0x87,
  0xe7, 0xba, 0xa7, 0xe9, 0x80, 0x9f, 0xe5, 0xba, 0xa6, 0xe4, 0xba, 0xba, 0xe7,
  0x89, 0xa9, 0xe8, 0xb0, 0x83, 0xe6, 0x95, 0xb4, 0xe6, 0xb5, 0x81, 0xe8, 0xa1,
  0x8c, 0xe9, 0x80, 0xa0, 0xe6, 0x88, 0x90, 0xe6, 0x96, 0x87, 0xe5, 0xad, 0x97,
  0xe9, 0x9f, 0xa9, 0xe5, 0x9b, 0xbd, 0xe8, 0xb4, 0xb8, 0xe6, 0x98, 0x93, 0xe5,
  0xbc, 0x80, 0xe5, 0xb1, 0x95, 0xe7, 0x9b, 0xb8, 0xe9, 0x97, 0x9c, 0xe8, 0xa1,
  0xa8, 0xe7, 0x8e, 0xb0, 0xe5, 0xbd, 0xb1, 0xe8, 0xa7, 0x86, 0xe5, 0xa6, 0x82,
  0xe6, 0xad, 0xa4, 0xe7, 0xbe, 0x8e, 0xe5, 0xae, 0xb9, 0xe5, 0xa4, 0xa7, 0xe5,
  0xb0, 0x8f, 0xe6, 0x8a, 0xa5, 0xe9, 0x81, 0x93, 0xe6, 0x9d, 0xa1, 0xe6, 0xac,
  0xbe, 0xe5, 0xbf, 0x83, 0xe6, 0x83, 0x85, 0xe8, 0xae, 0xb8, 0xe5, 0xa4, 0x9a,
  0xe6, 0xb3, 0x95, 0xe8, 0xa7, 0x84, 0xe5, 0xae, 0xb6, 0xe5, 0xb1, 0x85, 0xe4,
  0xb9, 0xa6, 0xe5, 0xba, 0x97, 0xe8, 0xbf, 0x9e, 0xe6, 0x8e, 0xa5, 0xe7, 0xab,
  0x8b, 0xe5, 0x8d, 0xb3, 0xe4, 0xb8, 0xbe, 0xe6, 0x8a, 0xa5, 0xe6, 0x8a, 0x80,
  0xe5, 0xb7, 0xa7, 0xe5, 0xa5, 0xa5, 0xe8, 0xbf, 0x90, 0xe7, 0x99, 0xbb, 0xe5,
  0x85, 0xa5, 0xe4, 0xbb, 0xa5, 0xe6, 0x9d, 0xa5, 0xe7, 0x90, 0x86, 0xe8, 0xae,
  0xba, 0xe4, 0xba, 0x8b, 0xe4, 0xbb, 0xb6, 0xe8, 0x87, 0xaa, 0xe7, 0x94, 0xb1,
  0xe4, 0xb8, 0xad, 0xe5, 0x8d, 0x8e, 0xe5, 0x8a, 0x9e, 0xe5, 0x85, 0xac, 0xe5,
  0xa6, 0x88, 0xe5, 0xa6, 0x88, 0xe7, 0x9c, 0x9f, 0xe6, 0xad, 0xa3, 0xe4, 0xb8,
  0x8d, 0xe9, 0x94, 0x99, 0xe5, 0x85, 0xa8, 0xe6, 0x96, 0x87, 0xe5, 0x90, 0x88,
  0xe5, 0x90, 0x8c, 0xe4, 0xbb, 0xb7, 0xe5, 0x80, 0xbc, 0xe5, 0x88, 0xab, 0xe4,
  0xba, 0xba, 0xe7, 0x9b, 0x91, 0xe7, 0x9d, 0xa3, 0xe5, 0x85, 0xb7, 0xe4, 0xbd,
  0x93, 0xe4, 0xb8, 0x96, 0xe7, 0xba, 0xaa, 0xe5, 0x9b, 0xa2, 0xe9, 0x98, 0x9f,
  0xe5, 0x88, 0x9b, 0xe4, 0xb8, 0x9a, 0xe6, 0x89, 0xbf, 0xe6, 0x8b, 0x85, 0xe5,
  0xa2, 0x9e, 0xe9, 0x95, 0xbf, 0xe6, 0x9c, 0x89, 0xe4, 0xba, 0xba, 0xe4, 0xbf,
  0x9d, 0xe6, 0x8c, 0x81, 0xe5, 0x95, 0x86, 0xe5, 0xae, 0xb6, 0xe7, 0xbb, 0xb4,
  0xe4, 0xbf, 0xae, 0xe5, 0x8f, 0xb0, 0xe6, 0xb9, 0xbe, 0xe5, 0xb7, 0xa6, 0xe5,
  0x8f, 0xb3, 0xe8, 0x82, 0xa1, 0xe4, 0xbb, 0xbd, 0xe7, 0xad, 0x94, 0xe6, 0xa1,
  0x88, 0xe5, 0xae, 0x9e, 0xe9, 0x99, 0x85, 0xe7, 0x94, 0xb5, 0xe4, 0xbf, 0xa1,
  0xe7, 0xbb, 0x8f, 0xe7, 0x90, 0x86, 0xe7, 0x94, 0x9f, 0xe5, 0x91, 0xbd, 0xe5,
  0xae, 0xa3, 0xe4, 0xbc, 0xa0, 0xe4, 0xbb, 0xbb, 0xe5, 0x8a, 0xa1, 0xe6, 0xad,
  0xa3, 0xe5, 0xbc, 0x8f, 0xe7, 0x89, 0xb9, 0xe8, 0x89, 0xb2, 0xe4, 0xb8, 0x8b,
  0xe6, 0x9d, 0xa5, 0xe5, 0x8d, 0x8f, 0xe4, 0xbc, 0x9a, 0xe5, 0x8f, 0xaa, 0xe8,
  0x83, 0xbd, 0xe5, 0xbd, 0x93, 0xe7, 0x84, 0xb6, 0xe9, 0x87, 0x8d, 0xe6, 0x96,
  0xb0, 0xe5, 0x85, 0xa7, 0xe5, 0xae, 0xb9, 0xe6, 0x8c, 0x87, 0xe5, 0xaf, 0xbc,
  0xe8, 0xbf, 0x90, 0xe8, 0xa1, 0x8c, 0xe6, 0x97, 0xa5, 0xe5, 0xbf, 0x97, 0xe8,
  0xb3, 0xa3, 0xe5, 0xae, 0xb6, 0xe8, 0xb6, 0x85, 0xe8, 0xbf, 0x87, 0xe5, 0x9c,
  0x9f, 0xe5, 0x9c, 0xb0, 0xe6, 0xb5, 0x99, 0xe6, 0xb1, 0x9f, 0xe6, 0x94, 0xaf,
  0xe4, 0xbb, 0x98, 0xe6, 0x8e, 0xa8, 0xe5, 0x87, 0xba, 0xe7, 0xab, 0x99, 0xe9,
  0x95, 0xbf, 0xe6, 0x9d, 0xad, 0xe5, 0xb7, 0x9e, 0xe6, 0x89, 0xa7, 0xe8, 0xa1,
  0x8c, 0xe5, 0x88, 0xb6, 0xe9, 0x80, 0xa0, 0xe4, 0xb9, 0x8b, 0xe4, 0xb8, 0x80,
  0xe6, 0x8e, 0xa8, 0xe5, 0xb9, 0xbf, 0xe7, 0x8e, 0xb0, 0xe5, 0x9c, 0xba, 0xe6,
  0x8f, 0x8f, 0xe8, 0xbf, 0xb0, 0xe5, 0x8f, 0x98, 0xe5, 0x8c, 0x96, 0xe4, 0xbc,
  0xa0, 0xe7, 0xbb, 0x9f, 0xe6, 0xad, 0x8c, 0xe6, 0x89, 0x8b, 0xe4, 0xbf, 0x9d,
  0xe9, 0x99, 0xa9, 0xe8, 0xaf, 0xbe, 0xe7, 0xa8, 0x8b, 0xe5, 0x8c, 0xbb, 0xe7,
  0x96, 0x97, 0xe7, 0xbb, 0x8f, 0xe8, 0xbf, 0x87, 0xe8, 0xbf, 0x87, 0xe5, 0x8e,
  0xbb, 0xe4, 0xb9, 0x8b, 0xe5, 0x89, 0x8d, 0xe6, 0x94, 0xb6, 0xe5, 0x85, 0xa5,
  0xe5, 0xb9, 0xb4, 0xe5, 0xba, 0xa6, 0xe6, 0x9d, 0x82, 0xe5, 0xbf, 0x97, 0xe7,
  0xbe, 0x8e, 0xe4, 0xb8, 0xbd, 0xe6, 0x9c, 0x80, 0xe9, 0xab, 0x98, 0xe7, 0x99,
  0xbb, 0xe9, 0x99, 0x86, 0xe6, 0x9c, 0xaa, 0xe6, 0x9d, 0xa5, 0xe5, 0x8a, 0xa0,
  0xe5, 0xb7, 0xa5, 0xe5, 0x85, 0x8d, 0xe8, 0xb4, 0xa3, 0xe6, 0x95, 0x99, 0xe7,
  0xa8, 0x8b, 0xe7, 0x89, 0x88, 0xe5, 0x9d, 0x97, 0xe8, 0xba, 0xab, 0xe4, 0xbd,
  0x93, 0xe9, 0x87, 0x8d, 0xe5, 0xba, 0x86, 0xe5, 0x87, 0xba, 0xe5, 0x94, 0xae,
  0xe6, 0x88, 0x90, 0xe6, 0x9c, 0xac, 0xe5, 0xbd, 0xa2, 0xe5, 0xbc, 0x8f, 0xe5,
  0x9c, 0x9f, 0xe8, 0xb1, 0x86, 0xe5, 0x87, 0xba, 0xe5, 0x83, 0xb9, 0xe4, 0xb8,
  0x9c, 0xe6, 0x96, 0xb9, 0xe9, 0x82, 0xae, 0xe7, 0xae, 0xb1, 0xe5, 0x8d, 0x97,
  0xe4, 0xba, 0xac, 0xe6, 0xb1, 0x82, 0xe8, 0x81, 0x8c, 0xe5, 0x8f, 0x96, 0xe5,
  0xbe, 0x97, 0xe8, 0x81, 0x8c, 0xe4, 0xbd, 0x8d, 0xe7, 0x9b, 0xb8, 0xe4, 0xbf,
  0xa1, 0xe9, 0xa1, 0xb5, 0xe9, 0x9d, 0xa2, 0xe5, 0x88, 0x86, 0xe9, 0x92, 0x9f,
  0xe7, 0xbd, 0x91, 0xe9, 0xa1, 0xb5, 0xe7, 0xa1, 0xae, 0xe5, 0xae, 0x9a, 0xe5,
  0x9b, 0xbe, 0xe4, 0xbe, 0x8b, 0xe7, 0xbd, 0x91, 0xe5, 0x9d, 0x80, 0xe7, 0xa7,
  0xaf, 0xe6, 0x9e, 0x81, 0xe9, 0x94, 0x99, 0xe8, 0xaf, 0xaf, 0xe7, 0x9b, 0xae,
  0xe7, 0x9a, 0x84, 0xe5, 0xae, 0x9d, 0xe8, 0xb4, 0x9d, 0xe6, 0x9c, 0xba, 0xe5,
  0x85, 0xb3, 0xe9, 0xa3, 0x8e, 0xe9, 0x99, 0xa9, 0xe6, 0x8e, 0x88, 0xe6, 0x9d,
  0x83, 0xe7, 0x97, 0x85, 0xe6, 0xaf, 0x92, 0xe5, 0xae, 0xa0, 0xe7, 0x89, 0xa9,
  0xe9, 0x99, 0xa4, 0xe4, 0xba, 0x86, 0xe8, 0xa9, 0x95, 0xe8, 0xab, 0x96, 0xe7,
  0x96, 0xbe, 0xe7, 0x97, 0x85, 0xe5, 0x8f, 0x8a, 0xe6, 0x97, 0xb6, 0xe6, 0xb1,
  0x82, 0xe8, 0xb4, 0xad, 0xe7, 0xab, 0x99, 0xe7, 0x82, 0xb9, 0xe5, 0x84, 0xbf,
  0xe7, 0xab, 0xa5, 0xe6, 0xaf, 0x8f, 0xe5, 0xa4, 0xa9, 0xe4, 0xb8, 0xad, 0xe5,
  0xa4, 0xae, 0xe8, 0xae, 0xa4, 0xe8, 0xaf, 0x86, 0xe6, 0xaf, 0x8f, 0xe4, 0xb8,
  0xaa, 0xe5, 0xa4, 0xa9, 0xe6, 0xb4, 0xa5, 0xe5, 0xad, 0x97, 0xe4, 0xbd, 0x93,
  0xe5, 0x8f, 0xb0, 0xe7, 0x81, 0xa3, 0xe7, 0xbb, 0xb4, 0xe6, 0x8a, 0xa4, 0xe6,
  0x9c, 0xac, 0xe9, 0xa1, 0xb5, 0xe4, 0xb8, 0xaa, 0xe6, 0x80, 0xa7, 0xe5, 0xae,
  0x98, 0xe6, 0x96, 0xb9, 0xe5, 0xb8, 0xb8, 0xe8, 0xa7, 0x81, 0xe7, 0x9b, 0xb8,
  0xe6, 0x9c, 0xba, 0xe6, 0x88, 0x98, 0xe7, 0x95, 0xa5, 0xe5, 0xba, 0x94, 0xe5,
  0xbd, 0x93, 0xe5, 0xbe, 0x8b, 0xe5, 0xb8, 0x88, 0xe6, 0x96, 0xb9, 0xe4, 0xbe,
  0xbf, 0xe6, 0xa0, 0xa1, 0xe5, 0x9b, 0xad, 0xe8, 0x82, 0xa1, 0xe5, 0xb8, 0x82,
  0xe6, 0x88, 0xbf, 0xe5, 0xb1, 0x8b, 0xe6, 0xa0, 0x8f, 0xe7, 0x9b, 0xae, 0xe5,
  0x91, 0x98, 0xe5, 0xb7, 0xa5, 0xe5, 0xaf, 0xbc, 0xe8, 0x87, 0xb4, 0xe7, 0xaa,
  0x81, 0xe7, 0x84, 0xb6, 0xe9, 0x81, 0x93, 0xe5, 0x85, 0xb7, 0xe6, 0x9c, 0xac,
  0xe7, 0xbd, 0x91, 0xe7, 0xbb, 0x93, 0xe5, 0x90, 0x88, 0xe6, 0xa1, 0xa3, 0xe6,
  0xa1, 0x88, 0xe5, 0x8a, 0xb3, 0xe5, 0x8a, 0xa8, 0xe5, 0x8f, 0xa6, 0xe5, 0xa4,
  0x96, 0xe7, 0xbe, 0x8e, 0xe5, 0x85, 0x83, 0xe5, 0xbc, 0x95, 0xe8, 0xb5, 0xb7,
  0xe6, 0x94, 0xb9, 0xe5, 0x8f, 0x98, 0xe7, 0xac, 0xac, 0xe5, 0x9b, 0x9b, 0xe4,
  0xbc, 0x9a, 0xe8, 0xae, 0xa1, 0xe8, 0xaa, 0xaa, 0xe6, 0x98, 0x8e, 0xe9, 0x9a,
  0x90, 0xe7, 0xa7, 0x81, 0xe5, 0xae, 0x9d, 0xe5, 0xae, 0x9d, 0xe8, 0xa7, 0x84,
  0xe8, 0x8c, 0x83, 0xe6, 0xb6, 0x88, 0xe8, 0xb4, 0xb9, 0xe5, 0x85, 0xb1, 0xe5,
  0x90, 0x8c, 0xe5, 0xbf, 0x98, 0xe8, 0xae, 0xb0, 0xe4, 0xbd, 0x93, 0xe7, 0xb3,
  0xbb, 0xe5, 0xb8, 0xa6, 0xe6, 0x9d, 0xa5, 0xe5, 0x90, 0x8d, 0xe5, 0xad, 0x97,
  0xe7, 0x99, 0xbc, 0xe8, 0xa1, 0xa8, 0xe5, 0xbc, 0x80, 0xe6, 0x94, 0xbe, 0xe5,
  0x8a, 0xa0, 0xe7, 0x9b, 0x9f, 0xe5, 0x8f, 0x97, 0xe5, 0x88, 0xb0, 0xe4, 0xba,
  0x8c, 0xe6, 0x89, 0x8b, 0xe5, 0xa4, 0xa7, 0xe9, 0x87, 0x8f, 0xe6, 0x88, 0x90,
  0xe4, 0xba, 0xba, 0xe6, 0x95, 0xb0, 0xe9, 0x87, 0x8f, 0xe5, 0x85, 0xb1, 0xe4,
  0xba, 0xab, 0xe5, 0x8c, 0xba, 0xe5, 0x9f, 0x9f, 0xe5, 0xa5, 0xb3, 0xe5, 0xad,
  0xa9, 0xe5, 0x8e, 0x9f, 0xe5, 0x88, 0x99, 0xe6, 0x89, 0x80, 0xe5, 0x9c, 0xa8,
  0xe7, 0xbb, 0x93, 0xe6, 0x9d, 0x9f, 0xe9, 0x80, 0x9a, 0xe4, 0xbf, 0xa1, 0xe8,
  0xb6, 0x85, 0xe7, 0xba, 0xa7, 0xe9, 0x85, 0x8d, 0xe7, 0xbd, 0xae, 0xe5, 0xbd,
  0x93, 0xe6, 0x97, 0xb6, 0xe4, 0xbc, 0x98, 0xe7, 0xa7, 0x80, 0xe6, 0x80, 0xa7,
  0xe6, 0x84, 0x9f, 0xe6, 0x88, 0xbf, 0xe4, 0xba, 0xa7, 0xe9, 0x81, 0x8a, 0xe6,
  0x88, 0xb2, 0xe5, 0x87, 0xba, 0xe5, 0x8f, 0xa3, 0xe6, 0x8f, 0x90, 0xe4, 0xba,
  0xa4, 0xe5, 0xb0, 0xb1, 0xe4, 0xb8, 0x9a, 0xe4, 0xbf, 0x9d, 0xe5, 0x81, 0xa5,
  0xe7, 0xa8, 0x8b, 0xe5, 0xba, 0xa6, 0xe5, 0x8f, 0x82, 0xe6, 0x95, 0xb0, 0xe4,
  0xba, 0x8b, 0xe4, 0xb8, 0x9a, 0xe6, 0x95, 0xb4, 0xe4, 0xb8, 0xaa, 0xe5, 0xb1,
  0xb1, 0xe4, 0xb8, 0x9c, 0xe6, 0x83, 0x85, 0xe6, 0x84, 0x9f, 0xe7, 0x89, 0xb9,
  0xe6, 0xae, 0x8a, 0xe5, 0x88, 0x86, 0xe9, 0xa1, 0x9e, 0xe6, 0x90, 0x9c, 0xe5,
  0xb0, 0x8b, 0xe5, 0xb1, 0x9e, 0xe4, 0xba, 0x8e, 0xe9, 0x97, 0xa8, 0xe6, 0x88,
  0xb7, 0xe8, 0xb4, 0xa2, 0xe5, 0x8a, 0xa1, 0xe5, 0xa3, 0xb0, 0xe9, 0x9f, 0xb3,
  0xe5, 0x8f, 0x8a, 0xe5, 0x85, 0xb6, 0xe8, 0xb4, 0xa2, 0xe7, 0xbb, 0x8f, 0xe5,
  0x9d, 0x9a, 0xe6, 0x8c, 0x81, 0xe5, 0xb9, 0xb2, 0xe9, 0x83, 0xa8, 0xe6, 0x88,
  0x90, 0xe7, 0xab, 0x8b, 0xe5, 0x88, 0xa9, 0xe7, 0x9b, 0x8a, 0xe8, 0x80, 0x83,
  0xe8, 0x99, 0x91, 0xe6, 0x88, 0x90, 0xe9, 0x83, 0xbd, 0xe5, 0x8c, 0x85, 0xe8,
  0xa3, 0x85, 0xe7, 0x94, 0xa8, 0xe6, 0x88, 0xb6, 0xe6, 0xaf, 0x94, 0xe8, 0xb5,
  0x9b, 0xe6, 0x96, 0x87, 0xe6, 0x98, 0x8e, 0xe6, 0x8b, 0x9b, 0xe5, 0x95, 0x86,
  0xe5, 0xae, 0x8c, 0xe6, 0x95, 0xb4, 0xe7, 0x9c, 0x9f, 0xe6, 0x98, 0xaf, 0xe7,
  0x9c, 0xbc, 0xe7, 0x9d, 0x9b, 0xe4, 0xbc, 0x99, 0xe4, 0xbc, 0xb4, 0xe5, 0xa8,
  0x81, 0xe6, 0x9c, 0x9b, 0xe9, 0xa2, 0x86, 0xe5, 0x9f, 0x9f, 0xe5, 0x8d, 0xab,
  0xe7, 0x94, 0x9f, 0xe4, 0xbc, 0x98, 0xe6, 0x83, 0xa0, 0xe8, 0xab, 0x96, 0xe5,
  0xa3, 0x87, 0xe5, 0x85, 0xac, 0xe5, 0x85, 0xb1, 0xe8, 0x89, 0xaf, 0xe5, 0xa5,
  0xbd, 0xe5, 0x85, 0x85, 0xe5, 0x88, 0x86, 0xe7, 0xac, 0xa6, 0xe5, 0x90, 0x88,
  0xe9, 0x99, 0x84, 0xe4, 0xbb, 0xb6, 0xe7, 0x89, 0xb9, 0xe7, 0x82, 0xb9, 0xe4,
  0xb8, 0x8d, 0xe5, 0x8f, 0xaf, 0xe8, 0x8b, 0xb1, 0xe6, 0x96, 0x87, 0xe8, 0xb5,
  0x84, 0xe4, 0xba, 0xa7, 0xe6, 0xa0, 0xb9, 0xe6, 0x9c, 0xac, 0xe6, 0x98, 0x8e,
  0xe6, 0x98, 0xbe, 0xe5, 0xaf, 0x86, 0xe7, 0xa2, 0xbc, 0xe5, 0x85, 0xac, 0xe4,
  0xbc, 0x97, 0xe6, 0xb0, 0x91, 0xe6, 0x97, 0x8f, 0xe6, 0x9b, 0xb4, 0xe5, 0x8a,
  0xa0, 0xe4, 0xba, 0xab, 0xe5, 0x8f, 0x97, 0xe5, 0x90, 0x8c, 0xe5, 0xad, 0xa6,
  0xe5, 0x90, 0xaf, 0xe5, 0x8a, 0xa8, 0xe9, 0x80, 0x82, 0xe5, 0x90, 0x88, 0xe5,
  0x8e, 0x9f, 0xe6, 0x9d, 0xa5, 0xe9, 0x97, 0xae, 0xe7, 0xad, 0x94, 0xe6, 0x9c,
  0xac, 0xe6, 0x96, 0x87, 0xe7, 0xbe, 0x8e, 0xe9, 0xa3, 0x9f, 0xe7, 0xbb, 0xbf,
  0xe8, 0x89, 0xb2, 0xe7, 0xa8, 0xb3, 0xe5, 0xae, 0x9a, 0xe7, 0xbb, 0x88, 0xe4,
  0xba, 0x8e, 0xe7, 0x94, 0x9f, 0xe7, 0x89, 0xa9, 0xe4, 0xbe, 0x9b, 0xe6, 0xb1,
  0x82, 0xe6, 0x90, 0x9c, 0xe7, 0x8b, 0x90, 0xe5, 0x8a, 0x9b, 0xe9, 0x87, 0x8f,
  0xe4, 0xb8, 0xa5, 0xe9, 0x87, 0x8d, 0xe6, 0xb0, 0xb8, 0xe8, 0xbf, 0x9c, 0xe5,
  0x86, 0x99, 0xe7, 0x9c, 0x9f, 0xe6, 0x9c, 0x89, 0xe9, 0x99, 0x90, 0xe7, 0xab,
  0x9e, 0xe4, 0xba, 0x89, 0xe5, 0xaf, 0xb9, 0xe8, 0xb1, 0xa1, 0xe8, 0xb4, 0xb9,
  0xe7, 0x94, 0xa8, 0xe4, 0xb8, 0x8d, 0xe5, 0xa5, 0xbd, 0xe7, 0xbb, 0x9d, 0xe5,
  0xaf, 0xb9, 0xe5, 0x8d, 0x81, 0xe5, 0x88, 0x86, 0xe4, 0xbf, 0x83, 0xe8, 0xbf,
  0x9b, 0xe7, 0x82, 0xb9, 0xe8, 0xaf, 0x84, 0xe5, 0xbd, 0xb1, 0xe9, 0x9f, 0xb3,
  0xe4, 0xbc, 0x98, 0xe5, 0x8a, 0xbf, 0xe4, 0xb8, 0x8d, 0xe5, 0xb0, 0x91, 0xe6,
  0xac, 0xa3, 0xe8, 0xb5, 0x8f, 0xe5, 0xb9, 0xb6, 0xe4, 0xb8, 0x94, 0xe6, 0x9c,
  0x89, 0xe7, 0x82, 0xb9, 0xe6, 0x96, 0xb9, 0xe5, 0x90, 0x91, 0xe5, 0x85, 0xa8,
  0xe6, 0x96, 0xb0, 0xe4, 0xbf, 0xa1, 0xe7, 0x94, 0xa8, 0xe8, 0xae, 0xbe, 0xe6,
  0x96, 0xbd, 0xe5, 0xbd, 0xa2, 0xe8, 0xb1, 0xa1, 0xe8, 0xb5, 0x84, 0xe6, 0xa0,
  0xbc, 0xe7, 0xaa, 0x81, 0xe7, 0xa0, 0xb4, 0xe9, 0x9a, 0x8f, 0xe7, 0x9d, 0x80,
  0xe9, 0x87, 0x8d, 0xe5, 0xa4, 0xa7, 0xe4, 0xba, 0x8e, 0xe6, 0x98, 0xaf, 0xe6,
  0xaf, 0x95, 0xe4, 0xb8, 0x9a, 0xe6, 0x99, 0xba, 0xe8, 0x83, 0xbd, 0xe5, 0x8c,
  0x96, 0xe5, 0xb7, 0xa5, 0xe5, 0xae, 0x8c, 0xe7, 0xbe, 0x8e, 0xe5, 0x95, 0x86,
  0xe5, 0x9f, 0x8e, 0xe7, 0xbb, 0x9f, 0xe4, 0xb8, 0x80, 0xe5, 0x87, 0xba, 0xe7,
  0x89, 0x88, 0xe6, 0x89, 0x93, 0xe9, 0x80, 0xa0, 0xe7, 0x94, 0xa2, 0xe5, 0x93,
  0x81, 0xe6, 0xa6, 0x82, 0xe5, 0x86, 0xb5, 0xe7, 0x94, 0xa8, 0xe4, 0xba, 0x8e,
  0xe4, 0xbf, 0x9d, 0xe7, 0x95, 0x99, 0xe5, 0x9b, 0xa0, 0xe7, 0xb4, 0xa0, 0xe4,
  0xb8, 0xad, 0xe5, 0x9c, 0x8b, 0xe5, 0xad, 0x98, 0xe5, 0x82, 0xa8, 0xe8, 0xb4,
  0xb4, 0xe5, 0x9b, 0xbe, 0xe6, 0x9c, 0x80, 0xe6, 0x84, 0x9b, 0xe9, 0x95, 0xbf,
  0xe6, 0x9c, 0x9f, 0xe5, 0x8f, 0xa3, 0xe4, 0xbb, 0xb7, 0xe7, 0x90, 0x86, 0xe8,
  0xb4, 0xa2, 0xe5, 0x9f, 0xba, 0xe5, 0x9c, 0xb0, 0xe5, 0xae, 0x89, 0xe6, 0x8e,
  0x92, 0xe6, 0xad, 0xa6, 0xe6, 0xb1, 0x89, 0xe9, 0x87, 0x8c, 0xe9, 0x9d, 0xa2,
  0xe5, 0x88, 0x9b, 0xe5, 0xbb, 0xba, 0xe5, 0xa4, 0xa9, 0xe7, 0xa9, 0xba, 0xe9,
  0xa6, 0x96, 0xe5, 0x85, 0x88, 0xe5, 0xae, 0x8c, 0xe5, 0x96, 0x84, 0xe9, 0xa9,
  0xb1, 0xe5, 0x8a, 0xa8, 0xe4, 0xb8, 0x8b, 0xe9, 0x9d, 0xa2, 0xe4, 0xb8, 0x8d,
  0xe5, 0x86, 0x8d, 0xe8, 0xaf, 0x9a, 0xe4, 0xbf, 0xa1, 0xe6, 0x84, 0x8f, 0xe4,
  0xb9, 0x89, 0xe9, 0x98, 0xb3, 0xe5, 0x85, 0x89, 0xe8, 0x8b, 0xb1, 0xe5, 0x9b,
  0xbd, 0xe6, 0xbc, 0x82, 0xe4, 0xba, 0xae, 0xe5, 0x86, 0x9b, 0xe4, 0xba, 0x8b,
  0xe7, 0x8e, 0xa9, 0xe5, 0xae, 0xb6, 0xe7, 0xbe, 0xa4, 0xe4, 0xbc, 0x97, 0xe5,
  0x86, 0x9c, 0xe6, 0xb0, 0x91, 0xe5, 0x8d, 0xb3, 0xe5, 0x8f, 0xaf, 0xe5, 0x90,
  0x8d, 0xe7, 0xa8, 0xb1, 0xe5, 0xae, 0xb6, 0xe5, 0x85, 0xb7, 0xe5, 0x8a, 0xa8,
  0xe7, 0x94, 0xbb, 0xe6, 0x83, 0xb3, 0xe5, 0x88, 0xb0, 0xe6, 0xb3, 0xa8, 0xe6,
  0x98, 0x8e, 0xe5, 0xb0, 0x8f, 0xe5, 0xad, 0xa6, 0xe6, 0x80, 0xa7, 0xe8, 0x83,
  0xbd, 0xe8, 0x80, 0x83, 0xe7, 0xa0, 0x94, 0xe7, 0xa1, 0xac, 0xe4, 0xbb, 0xb6,
  0xe8, 0xa7, 0x82, 0xe7, 0x9c, 0x8b, 0xe6, 0xb8, 0x85, 0xe6, 0xa5, 0x9a, 0xe6,
  0x90, 0x9e, 0xe7, 0xac, 0x91, 0xe9, 0xa6, 0x96, 0xe9, 0xa0, 0x81, 0xe9, 0xbb,
  0x84, 0xe9, 0x87, 0x91, 0xe9, 0x80, 0x82, 0xe7, 0x94, 0xa8, 0xe6, 0xb1, 0x9f,
  0xe8, 0x8b, 0x8f, 0xe7, 0x9c, 0x9f, 0xe5, 0xae, 0x9e, 0xe4, 0xb8, 0xbb, 0xe7,
  0xae, 0xa1, 0xe9, 0x98, 0xb6, 0xe6, 0xae, 0xb5, 0xe8, 0xa8, 0xbb, 0xe5, 0x86,
  0x8a, 0xe7, 0xbf, 0xbb, 0xe8, 0xaf, 0x91, 0xe6, 0x9d, 0x83, 0xe5, 0x88, 0xa9,
  0xe5, 0x81, 0x9a, 0xe5, 0xa5, 0xbd, 0xe4, 0xbc, 0xbc, 0xe4, 0xb9, 0x8e, 0xe9,
  0x80, 0x9a, 0xe8, 0xae, 0xaf, 0xe6, 0x96, 0xbd, 0xe5, 0xb7, 0xa5, 0xe7, 0x8b,
  0x80, 0xe6, 0x85, 0x8b, 0xe4, 0xb9, 0x9f, 0xe8, 0xae, 0xb8, 0xe7, 0x8e, 0xaf,
  0xe4, 0xbf, 0x9d, 0xe5, 0x9f, 0xb9, 0xe5, 0x85, 0xbb, 0xe6, 0xa6, 0x82, 0xe5,
  0xbf, 0xb5, 0xe5, 0xa4, 0xa7, 0xe5, 0x9e, 0x8b, 0xe6, 0x9c, 0xba, 0xe7, 0xa5,
  0xa8, 0xe7, 0x90, 0x86, 0xe8, 0xa7, 0xa3, 0xe5, 0x8c, 0xbf, 0xe5, 0x90, 0x8d,
  0x63, 0x75, 0x61, 0x6e, 0x64, 0x6f, 0x65, 0x6e, 0x76, 0x69, 0x61, 0x72, 0x6d,
  0x61, 0x64, 0x72, 0x69, 0x64, 0x62, 0x75, 0x73, 0x63, 0x61, 0x72, 0x69, 0x6e,
  0x69, 0x63, 0x69, 0x6f, 0x74, 0x69, 0x65, 0x6d, 0x70, 0x6f, 0x70, 0x6f, 0x72,
  0x71, 0x75, 0x65, 0x63, 0x75, 0x65, 0x6e, 0x74, 0x61, 0x65, 0x73, 0x74, 0x61,
  0x64, 0x6f, 0x70, 0x75, 0x65, 0x64, 0x65, 0x6e, 0x6a, 0x75, 0x65, 0x67, 0x6f,
  0x73, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x65, 0x73, 0x74, 0xc3, 0xa1, 0x6e,
  0x6e, 0x6f, 0x6d, 0x62, 0x72, 0x65, 0x74, 0x69, 0x65, 0x6e, 0x65, 0x6e, 0x70,
  0x65, 0x72, 0x66, 0x69, 0x6c, 0x6d, 0x61, 0x6e, 0x65, 0x72, 0x61, 0x61, 0x6d,
  0x69, 0x67, 0x6f, 0x73, 0x63, 0x69, 0x75, 0x64, 0x61, 0x64, 0x63, 0x65, 0x6e,
  0x74, 0x72, 0x6f, 0x61, 0x75, 0x6e, 0x71, 0x75, 0x65, 0x70, 0x75, 0x65, 0x64,
  0x65, 0x73, 0x64, 0x65, 0x6e, 0x74, 0x72, 0x6f, 0x70, 0x72, 0x69, 0x6d, 0x65,
  0x72, 0x70, 0x72, 0x65, 0x63, 0x69, 0x6f, 0x73, 0x65, 0x67, 0xc3, 0xba, 0x6e,
  0x62, 0x75, 0x65, 0x6e, 0x6f, 0x73, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x72, 0x70,
  0x75, 0x6e, 0x74, 0x6f, 0x73, 0x73, 0x65, 0x6d, 0x61, 0x6e, 0x61, 0x68, 0x61,
  0x62, 0xc3, 0xad, 0x61, 0x61, 0x67, 0x6f, 0x73, 0x74, 0x6f, 0x6e, 0x75, 0x65,
  0x76, 0x6f, 0x73, 0x75, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x63, 0x61, 0x72, 0x6c,
  0x6f, 0x73, 0x65, 0x71, 0x75, 0x69, 0x70, 0x6f, 0x6e, 0x69, 0xc3, 0xb1, 0x6f,
  0x73, 0x6d, 0x75, 0x63, 0x68, 0x6f, 0x73, 0x61, 0x6c, 0x67, 0x75, 0x6e, 0x61,
  0x63, 0x6f, 0x72, 0x72, 0x65, 0x6f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x6e, 0x70,
  0x61, 0x72, 0x74, 0x69, 0x72, 0x61, 0x72, 0x72, 0x69, 0x62, 0x61, 0x6d, 0x61,
  0x72, 0xc3, 0xad, 0x61, 0x68, 0x6f, 0x6d, 0x62, 0x72, 0x65, 0x65, 0x6d, 0x70,
  0x6c, 0x65, 0x6f, 0x76, 0x65, 0x72, 0x64, 0x61, 0x64, 0x63, 0x61, 0x6d, 0x62,
  0x69, 0x6f, 0x6d, 0x75, 0x63, 0x68, 0x61, 0x73, 0x66, 0x75, 0x65, 0x72, 0x6f,
  0x6e, 0x70, 0x61, 0x73, 0x61, 0x64, 0x6f, 0x6c, 0xc3, 0xad, 0x6e, 0x65, 0x61,
  0x70, 0x61, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x75, 0x65, 0x76, 0x61, 0x73, 0x63,
  0x75, 0x72, 0x73, 0x6f, 0x73, 0x65, 0x73, 0x74, 0x61, 0x62, 0x61, 0x71, 0x75,
  0x69, 0x65, 0x72, 0x6f, 0x6c, 0x69, 0x62, 0x72, 0x6f, 0x73, 0x63, 0x75, 0x61,
  0x6e, 0x74, 0x6f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x6f, 0x6d, 0x69, 0x67, 0x75,
  0x65, 0x6c, 0x76, 0x61, 0x72, 0x69, 0x6f, 0x73, 0x63, 0x75, 0x61, 0x74, 0x72,
  0x6f, 0x74, 0x69, 0x65, 0x6e, 0x65, 0x73, 0x67, 0x72, 0x75, 0x70, 0x6f, 0x73,
  0x73, 0x65, 0x72, 0xc3, 0xa1, 0x6e, 0x65, 0x75, 0x72, 0x6f, 0x70, 0x61, 0x6d,
  0x65, 0x64, 0x69, 0x6f, 0x73, 0x66, 0x72, 0x65, 0x6e, 0x74, 0x65, 0x61, 0x63,
  0x65, 0x72, 0x63, 0x61, 0x64, 0x65, 0x6d, 0xc3, 0xa1, 0x73, 0x6f, 0x66, 0x65,
  0x72, 0x74, 0x61, 0x63, 0x6f, 0x63, 0x68, 0x65, 0x73, 0x6d, 0x6f, 0x64, 0x65,
  0x6c, 0x6f, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x6c, 0x65, 0x74, 0x72, 0x61,
  0x73, 0x61, 0x6c, 0x67, 0xc3, 0xba, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x61,
  0x63, 0x75, 0x61, 0x6c, 0x65, 0x73, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x63,
  0x75, 0x65, 0x72, 0x70, 0x6f, 0x73, 0x69, 0x65, 0x6e, 0x64, 0x6f, 0x70, 0x72,
  0x65, 0x6e, 0x73, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x61, 0x72, 0x76, 0x69, 0x61,
  0x6a, 0x65, 0x73, 0x64, 0x69, 0x6e, 0x65, 0x72, 0x6f, 0x6d, 0x75, 0x72, 0x63,
  0x69, 0x61, 0x70, 0x6f, 0x64, 0x72, 0xc3, 0xa1, 0x70, 0x75, 0x65, 0x73, 0x74,
  0x6f, 0x64, 0x69, 0x61, 0x72, 0x69, 0x6f, 0x70, 0x75, 0x65, 0x62, 0x6c, 0x6f,
  0x71, 0x75, 0x69, 0x65, 0x72, 0x65, 0x6d, 0x61, 0x6e, 0x75, 0x65, 0x6c, 0x70,
  0x72, 0x6f, 0x70, 0x69, 0x6f, 0x63, 0x72, 0x69, 0x73, 0x69, 0x73, 0x63, 0x69,
  0x65, 0x72, 0x74, 0x6f, 0x73, 0x65, 0x67, 0x75, 0x72, 0x6f, 0x6d, 0x75, 0x65,
  0x72, 0x74, 0x65, 0x66, 0x75, 0x65, 0x6e, 0x74, 0x65, 0x63, 0x65, 0x72, 0x72,
  0x61, 0x72, 0x67, 0x72, 0x61, 0x6e, 0x64, 0x65, 0x65, 0x66, 0x65, 0x63, 0x74,
  0x6f, 0x70, 0x61, 0x72, 0x74, 0x65, 0x73, 0x6d, 0x65, 0x64, 0x69, 0x64, 0x61,
  0x70, 0x72, 0x6f, 0x70, 0x69, 0x61, 0x6f, 0x66, 0x72, 0x65, 0x63, 0x65, 0x74,
  0x69, 0x65, 0x72, 0x72, 0x61, 0x65, 0x2d, 0x6d, 0x61, 0x69, 0x6c, 0x76, 0x61,
  0x72, 0x69, 0x61, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x73, 0x66, 0x75, 0x74,
  0x75, 0x72, 0x6f, 0x6f, 0x62, 0x6a, 0x65, 0x74, 0x6f, 0x73, 0x65, 0x67, 0x75,
  0x69, 0x72, 0x72, 0x69, 0x65, 0x73, 0x67, 0x6f, 0x6e, 0x6f, 0x72, 0x6d, 0x61,
  0x73, 0x6d, 0x69, 0x73, 0x6d, 0x6f, 0x73, 0xc3, 0xba, 0x6e, 0x69, 0x63, 0x6f,
  0x63, 0x61, 0x6d, 0x69, 0x6e, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x73, 0x72,
  0x61, 0x7a, 0xc3, 0xb3, 0x6e, 0x64, 0x65, 0x62, 0x69, 0x64, 0x6f, 0x70, 0x72,
  0x75, 0x65, 0x62, 0x61, 0x74, 0x6f, 0x6c, 0x65, 0x64, 0x6f, 0x74, 0x65, 0x6e,
  0xc3, 0xad, 0x61, 0x6a, 0x65, 0x73, 0xc3, 0xba, 0x73, 0x65, 0x73, 0x70, 0x65,
  0x72, 0x6f, 0x63, 0x6f, 0x63, 0x69, 0x6e, 0x61, 0x6f, 0x72, 0x69, 0x67, 0x65,
  0x6e, 0x74, 0x69, 0x65, 0x6e, 0x64, 0x61, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x6f,
  0x63, 0xc3, 0xa1, 0x64, 0x69, 0x7a, 0x68, 0x61, 0x62, 0x6c, 0x61, 0x72, 0x73,
  0x65, 0x72, 0xc3, 0xad, 0x61, 0x6c, 0x61, 0x74, 0x69, 0x6e, 0x61, 0x66, 0x75,
  0x65, 0x72, 0x7a, 0x61, 0x65, 0x73, 0x74, 0x69, 0x6c, 0x6f, 0x67, 0x75, 0x65,
  0x72, 0x72, 0x61, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x72, 0xc3, 0xa9, 0x78, 0x69,
  0x74, 0x6f, 0x6c, 0xc3, 0xb3, 0x70, 0x65, 0x7a, 0x61, 0x67, 0x65, 0x6e, 0x64,
  0x61, 0x76, 0xc3, 0xad, 0x64, 0x65, 0x6f, 0x65, 0x76, 0x69, 0x74, 0x61, 0x72,
  0x70, 0x61, 0x67, 0x69, 0x6e, 0x61, 0x6d, 0x65, 0x74, 0x72, 0x6f, 0x73, 0x6a,
  0x61, 0x76, 0x69, 0x65, 0x72, 0x70, 0x61, 0x64, 0x72, 0x65, 0x73, 0x66, 0xc3,
  0xa1, 0x63, 0x69, 0x6c, 0x63, 0x61, 0x62, 0x65, 0x7a, 0x61, 0xc3, 0xa1, 0x72,
  0x65, 0x61, 0x73, 0x73, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x65, 0x6e, 0x76, 0xc3,
  0xad, 0x6f, 0x6a, 0x61, 0x70, 0xc3, 0xb3, 0x6e, 0x61, 0x62, 0x75, 0x73, 0x6f,
  0x73, 0x62, 0x69, 0x65, 0x6e, 0x65, 0x73, 0x74, 0x65, 0x78, 0x74, 0x6f, 0x73,
  0x6c, 0x6c, 0x65, 0x76, 0x61, 0x72, 0x70, 0x75, 0x65, 0x64, 0x61, 0x6e, 0x66,
  0x75, 0x65, 0x72, 0x74, 0x65, 0x63, 0x6f, 0x6d, 0xc3, 0xba, 0x6e, 0x63, 0x6c,
  0x61, 0x73, 0x65, 0x73, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x6f, 0x74, 0x65, 0x6e,
  0x69, 0x64, 0x6f, 0x62, 0x69, 0x6c, 0x62, 0x61, 0x6f, 0x75, 0x6e, 0x69, 0x64,
  0x61, 0x64, 0x65, 0x73, 0x74, 0xc3, 0xa1, 0x73, 0x65, 0x64, 0x69, 0x74, 0x61,
  0x72, 0x63, 0x72, 0x65, 0x61, 0x64, 0x6f, 0xd0, 0xb4, 0xd0, 0xbb, 0xd1, 0x8f,
  0xd1, 0x87, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xba, 0xd0,
  0xb8, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb2,
  0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xbf, 0xd1,
  0x80, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xb5, 0xd1, 0x89,
  0xd0, 0xb5, 0xd1, 0x83, 0xd0, 0xb6, 0xd0, 0xb5, 0xd0, 0x9a, 0xd0, 0xb0, 0xd0,
  0xba, 0xd0, 0xb1, 0xd0, 0xb5, 0xd0, 0xb7, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xbb,
  0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0x92, 0xd1, 0x81, 0xd0, 0xb5, 0xd0,
  0xbf, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xad, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x82,
  0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xbd, 0xd0,
  0xb5, 0xd1, 0x82, 0xd0, 0xbb, 0xd0, 0xb5, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0,
  0xd0, 0xb7, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0,
  0xb5, 0xd0, 0xbc, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0x94, 0xd0, 0xbb, 0xd1, 0x8f,
  0xd0, 0x9f, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x81, 0xd0,
  0xbd, 0xd0, 0xb8, 0xd1, 0x85, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xba,
  0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb2, 0xd0,
  0xbe, 0xd1, 0x82, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xa1, 0xd0, 0xa8,
  0xd0, 0x90, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x8f, 0xd0, 0xa7, 0xd1, 0x82, 0xd0,
  0xbe, 0xd0, 0xb2, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xb0, 0xd0, 0xbc,
  0xd0, 0xb5, 0xd0, 0xbc, 0xd1, 0x83, 0xd0, 0xa2, 0xd0, 0xb0, 0xd0, 0xba, 0xd0,
  0xb4, 0xd0, 0xb2, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xbc, 0xd1, 0x8d,
  0xd1, 0x82, 0xd0, 0xb8, 0xd1, 0x8d, 0xd1, 0x82, 0xd1, 0x83, 0xd0, 0x92, 0xd0,
  0xb0, 0xd0, 0xbc, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80,
  0xd0, 0xbe, 0xd1, 0x82, 0xd1, 0x83, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0,
  0xb4, 0xd0, 0xb4, 0xd0, 0xbd, 0xd1, 0x8f, 0xd0, 0x92, 0xd0, 0xbe, 0xd1, 0x82,
  0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb9, 0xd0,
  0x92, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd1, 0x81,
  0xd0, 0xb0, 0xd0, 0xbc, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x82, 0xd1, 0x80, 0xd1,
  0x83, 0xd0, 0xb1, 0xd0, 0x9e, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb8,
  0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0x9e, 0xd0, 0x9e, 0xd0,
  0x9e, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x86, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xb0,
  0xd0, 0x9e, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xb4, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0, 0xb4,
  0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xbe, 0xd1, 0x81, 0xd1,
  0x83, 0xd0, 0xb4, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb9, 0xe0,
  0xa5, 0x88, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0x94, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xad, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x87,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0,
  0xa5, 0x8b, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x86, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb9,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xa5, 0xe0, 0xa4, 0xbe, 0x6a, 0x61, 0x67, 0x72, 0x61, 0x6e, 0xe0, 0xa4,
  0x86, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x85,
  0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0,
  0xa4, 0x88, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4,
  0x8f, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xa5, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa5, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0x98, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0x9c, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0x88, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0x95, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x93, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0x86, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa5, 0x80, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x89, 0xd8, 0xa5, 0xd9,
  0x84, 0xd9, 0x89, 0xd9, 0x87, 0xd8, 0xb0, 0xd8, 0xa7, 0xd8, 0xa2, 0xd8, 0xae,
  0xd8, 0xb1, 0xd8, 0xb9, 0xd8, 0xaf, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x89, 0xd9, 0x87, 0xd8, 0xb0, 0xd9, 0x87, 0xd8, 0xb5, 0xd9, 0x88, 0xd8, 0xb1,
  0xd8, 0xba, 0xd9, 0x8a, 0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x86, 0xd9,
  0x88, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xa8, 0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xb9,
  0xd8, 0xb1, 0xd8, 0xb6, 0xd8, 0xb0, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x87, 0xd9,
  0x86, 0xd8, 0xa7, 0xd9, 0x8a, 0xd9, 0x88, 0xd9, 0x85, 0xd9, 0x82, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x86, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x86, 0xd8, 0xad, 0xd8, 0xaa, 0xd9, 0x89,
  0xd9, 0x82, 0xd8, 0xa8, 0xd9, 0x84, 0xd9, 0x88, 0xd8, 0xad, 0xd8, 0xa9, 0xd8,
  0xa7, 0xd8, 0xae, 0xd8, 0xb1, 0xd9, 0x81, 0xd9, 0x82, 0xd8, 0xb7, 0xd8, 0xb9,
  0xd8, 0xa8, 0xd8, 0xaf, 0xd8, 0xb1, 0xd9, 0x83, 0xd9, 0x86, 0xd8, 0xa5, 0xd8,
  0xb0, 0xd8, 0xa7, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xa7, 0xd8, 0xad,
  0xd8, 0xaf, 0xd8, 0xa5, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x81, 0xd9, 0x8a, 0xd9,
  0x87, 0xd8, 0xa8, 0xd8, 0xb9, 0xd8, 0xb6, 0xd9, 0x83, 0xd9, 0x8a, 0xd9, 0x81,
  0xd8, 0xa8, 0xd8, 0xad, 0xd8, 0xab, 0xd9, 0x88, 0xd9, 0x85, 0xd9, 0x86, 0xd9,
  0x88, 0xd9, 0x87, 0xd9, 0x88, 0xd8, 0xa3, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xac,
  0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xb3, 0xd9,
  0x84, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 0x86, 0xd8, 0xaf, 0xd9, 0x84, 0xd9, 0x8a,
  0xd8, 0xb3, 0xd8, 0xb9, 0xd8, 0xa8, 0xd8, 0xb1, 0xd8, 0xb5, 0xd9, 0x84, 0xd9,
  0x89, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xb0, 0xd8, 0xa8, 0xd9, 0x87, 0xd8, 0xa7,
  0xd8, 0xa3, 0xd9, 0x86, 0xd9, 0x87, 0xd9, 0x85, 0xd8, 0xab, 0xd9, 0x84, 0xd9,
  0x83, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xad,
  0xd9, 0x8a, 0xd8, 0xab, 0xd9, 0x85, 0xd8, 0xb5, 0xd8, 0xb1, 0xd8, 0xb4, 0xd8,
  0xb1, 0xd8, 0xad, 0xd8, 0xad, 0xd9, 0x88, 0xd9, 0x84, 0xd9, 0x88, 0xd9, 0x81,
  0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xb0, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd9,
  0x84, 0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x86, 0xd8, 0xaa,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x81, 0xd8, 0xa3, 0xd8, 0xa8, 0xd9, 0x88, 0xd8,
  0xae, 0xd8, 0xa7, 0xd8, 0xb5, 0xd8, 0xa3, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7,
  0xd9, 0x86, 0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x8a, 0xd8, 0xb9, 0xd8,
  0xb6, 0xd9, 0x88, 0xd9, 0x88, 0xd9, 0x82, 0xd8, 0xaf, 0xd8, 0xa7, 0xd8, 0xa8,
  0xd9, 0x86, 0xd8, 0xae, 0xd9, 0x8a, 0xd8, 0xb1, 0xd8, 0xa8, 0xd9, 0x86, 0xd8,
  0xaa, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8, 0xa1,
  0xd9, 0x88, 0xd9, 0x87, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xa8, 0xd9, 0x88, 0xd9,
  0x82, 0xd8, 0xb5, 0xd8, 0xb5, 0xd9, 0x88, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xb1,
  0xd9, 0x82, 0xd9, 0x85, 0xd8, 0xa3, 0xd8, 0xad, 0xd8, 0xaf, 0xd9, 0x86, 0xd8,
  0xad, 0xd9, 0x86, 0xd8, 0xb9, 0xd8, 0xaf, 0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xa3,
  0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xad, 0xd8, 0xa9, 0xd9, 0x83, 0xd8, 0xaa, 0xd8,
  0xa8, 0xd8, 0xaf, 0xd9, 0x88, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xac, 0xd8, 0xa8,
  0xd9, 0x85, 0xd9, 0x86, 0xd9, 0x87, 0xd8, 0xaa, 0xd8, 0xad, 0xd8, 0xaa, 0xd8,
  0xac, 0xd9, 0x87, 0xd8, 0xa9, 0xd8, 0xb3, 0xd9, 0x86, 0xd8, 0xa9, 0xd9, 0x8a,
  0xd8, 0xaa, 0xd9, 0x85, 0xd9, 0x83, 0xd8, 0xb1, 0xd8, 0xa9, 0xd8, 0xba, 0xd8,
  0xb2, 0xd8, 0xa9, 0xd9, 0x86, 0xd9, 0x81, 0xd8, 0xb3, 0xd8, 0xa8, 0xd9, 0x8a,
  0xd8, 0xaa, 0xd9, 0x84, 0xd9, 0x84, 0xd9, 0x87, 0xd9, 0x84, 0xd9, 0x86, 0xd8,
  0xa7, 0xd8, 0xaa, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x82, 0xd9, 0x84, 0xd8, 0xa8,
  0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xb9, 0xd9, 0x86, 0xd9, 0x87, 0xd8,
  0xa3, 0xd9, 0x88, 0xd9, 0x84, 0xd8, 0xb4, 0xd9, 0x8a, 0xd8, 0xa1, 0xd9, 0x86,
  0xd9, 0x88, 0xd8, 0xb1, 0xd8, 0xa3, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x81, 0xd9,
  0x8a, 0xd9, 0x83, 0xd8, 0xa8, 0xd9, 0x83, 0xd9, 0x84, 0xd8, 0xb0, 0xd8, 0xa7,
  0xd8, 0xaa, 0xd8, 0xb1, 0xd8, 0xaa, 0xd8, 0xa8, 0xd8, 0xa8, 0xd8, 0xa3, 0xd9,
  0x86, 0xd9, 0x87, 0xd9, 0x85, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 0x83,
  0xd8, 0xa8, 0xd9, 0x8a, 0xd8, 0xb9, 0xd9, 0x81, 0xd9, 0x82, 0xd8, 0xaf, 0xd8,
  0xad, 0xd8, 0xb3, 0xd9, 0x86, 0xd9, 0x84, 0xd9, 0x87, 0xd9, 0x85, 0xd8, 0xb4,
  0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa3, 0xd9, 0x87, 0xd9, 0x84, 0xd8, 0xb4, 0xd9,
  0x87, 0xd8, 0xb1, 0xd9, 0x82, 0xd8, 0xb7, 0xd8, 0xb1, 0xd8, 0xb7, 0xd9, 0x84,
  0xd8, 0xa8, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x6c, 0x65, 0x73, 0x65, 0x72, 0x76,
  0x69, 0x63, 0x65, 0x64, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x68, 0x69, 0x6d,
  0x73, 0x65, 0x6c, 0x66, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x63, 0x6f,
  0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73,
  0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
  0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x61, 0x73, 0x68, 0x69, 0x6f,
  0x6e, 0x3c, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x63, 0x6f, 0x75, 0x6e, 0x74,
  0x72, 0x79, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x63, 0x72, 0x65, 0x61,
  0x74, 0x65, 0x64, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x72, 0x65, 0x73,
  0x75, 0x6c, 0x74, 0x73, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x70, 0x72,
  0x6f, 0x63, 0x65, 0x73, 0x73, 0x77, 0x72, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x6f,
  0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x76, 0x69, 0x73, 0x69, 0x62, 0x6c, 0x65,
  0x77, 0x65, 0x6c, 0x63, 0x6f, 0x6d, 0x65, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c,
  0x65, 0x75, 0x6e, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
  0x72, 0x6b, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x64, 0x79, 0x6e, 0x61,
  0x6d, 0x69, 0x63, 0x62, 0x72, 0x6f, 0x77, 0x73, 0x65, 0x72, 0x70, 0x72, 0x69,
  0x76, 0x61, 0x63, 0x79, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x53, 0x65,
  0x72, 0x76, 0x69, 0x63, 0x65, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x64,
  0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
  0x72, 0x65, 0x73, 0x65, 0x72, 0x76, 0x65, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74,
  0x65, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x66, 0x72, 0x69, 0x65, 0x6e,
  0x64, 0x73, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x77, 0x6f, 0x72, 0x6b,
  0x69, 0x6e, 0x67, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x6d, 0x69, 0x6c,
  0x6c, 0x69, 0x6f, 0x6e, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x77, 0x69,
  0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x76,
  0x69, 0x73, 0x69, 0x74, 0x65, 0x64, 0x77, 0x65, 0x61, 0x74, 0x68, 0x65, 0x72,
  0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
  0x74, 0x65, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x66, 0x6f, 0x72, 0x77, 0x61,
  0x72, 0x64, 0x79, 0x6f, 0x75, 0x20, 0x63, 0x61, 0x6e, 0x72, 0x65, 0x6d, 0x6f,
  0x76, 0x65, 0x64, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x63, 0x6f, 0x6e,
  0x74, 0x72, 0x6f, 0x6c, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x63, 0x75,
  0x72, 0x72, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x6c,
  0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64,
  0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x66, 0x75, 0x72, 0x74, 0x68, 0x65,
  0x72, 0x73, 0x75, 0x6d, 0x6d, 0x61, 0x72, 0x79, 0x6d, 0x61, 0x63, 0x68, 0x69,
  0x6e, 0x65, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x65, 0x73, 0x70, 0x72, 0x69, 0x76,
  0x61, 0x74, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x78, 0x74, 0x70, 0x72, 0x6f,
  0x67, 0x72, 0x61, 0x6d, 0x73, 0x6f, 0x63, 0x69, 0x65, 0x74, 0x79, 0x6e, 0x75,
  0x6d, 0x62, 0x65, 0x72, 0x73, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x65,
  0x6e, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72,
  0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x6c, 0x6f, 0x61, 0x64, 0x69, 0x6e,
  0x67, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x61, 0x72, 0x74, 0x6e,
  0x65, 0x72, 0x66, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x70, 0x65, 0x72, 0x66,
  0x65, 0x63, 0x74, 0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x73, 0x79, 0x73,
  0x74, 0x65, 0x6d, 0x73, 0x6b, 0x65, 0x65, 0x70, 0x69, 0x6e, 0x67, 0x63, 0x75,
  0x6c, 0x74, 0x75, 0x72, 0x65, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x2c, 0x6a,
  0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
  0x73, 0x75, 0x72, 0x66, 0x61, 0x63, 0x65, 0x73, 0x26, 0x71, 0x75, 0x6f, 0x74,
  0x3b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x73, 0x72, 0x65, 0x76, 0x69, 0x65,
  0x77, 0x73, 0x62, 0x61, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x45, 0x6e, 0x67, 0x6c,
  0x69, 0x73, 0x68, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x74, 0x68, 0x72,
  0x6f, 0x75, 0x67, 0x68, 0x50, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x70,
  0x69, 0x6e, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x61,
  0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79,
  0x76, 0x69, 0x6c, 0x6c, 0x61, 0x67, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x69, 0x73,
  0x68, 0x67, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x79, 0x64, 0x65, 0x63, 0x6c, 0x69,
  0x6e, 0x65, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x6d, 0x69, 0x73, 0x73,
  0x69, 0x6f, 0x6e, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x71, 0x75, 0x61,
  0x6c, 0x69, 0x74, 0x79, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x67, 0x65,
  0x6e, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x70, 0x65, 0x63, 0x69, 0x65, 0x73, 0x73,
  0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x77, 0x72, 0x69, 0x74, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65,
  0x72, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x72, 0x65, 0x70, 0x6f, 0x72,
  0x74, 0x73, 0x66, 0x69, 0x67, 0x75, 0x72, 0x65, 0x73, 0x6d, 0x65, 0x6d, 0x62,
  0x65, 0x72, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x73,
  0x70, 0x75, 0x74, 0x65, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x72, 0x65, 0x78,
  0x70, 0x72, 0x65, 0x73, 0x73, 0x64, 0x69, 0x67, 0x69, 0x74, 0x61, 0x6c, 0x70,
  0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x41, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72,
  0x6d, 0x61, 0x72, 0x72, 0x69, 0x65, 0x64, 0x74, 0x72, 0x61, 0x66, 0x66, 0x69,
  0x63, 0x6c, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x63, 0x68, 0x61, 0x6e, 0x67,
  0x65, 0x64, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x76, 0x69, 0x63, 0x74,
  0x6f, 0x72, 0x79, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x72, 0x65, 0x61,
  0x73, 0x6f, 0x6e, 0x73, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x66, 0x65,
  0x61, 0x74, 0x75, 0x72, 0x65, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x6d,
  0x75, 0x73, 0x74, 0x20, 0x62, 0x65, 0x73, 0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x73,
  0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c,
  0x79, 0x65, 0x70, 0x69, 0x73, 0x6f, 0x64, 0x65, 0x70, 0x6c, 0x61, 0x79, 0x69,
  0x6e, 0x67, 0x67, 0x72, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x6f, 0x62, 0x76, 0x69,
  0x6f, 0x75, 0x73, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x79, 0x70, 0x72, 0x65,
  0x73, 0x65, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x2f,
  0x75, 0x6c, 0x3e, 0x0d, 0x0a, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x61,
  0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x63, 0x65, 0x72, 0x74, 0x61, 0x69, 0x6e,
  0x72, 0x65, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x67,
  0x65, 0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x64, 0x65, 0x73, 0x6b, 0x74,
  0x6f, 0x70, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x65, 0x64, 0x70, 0x61, 0x74, 0x74,
  0x65, 0x72, 0x6e, 0x75, 0x6e, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x44, 0x69, 0x67,
  0x69, 0x74, 0x61, 0x6c, 0x63, 0x61, 0x70, 0x69, 0x74, 0x61, 0x6c, 0x57, 0x65,
  0x62, 0x73, 0x69, 0x74, 0x65, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x63,
  0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x64,
  0x41, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x64, 0x65, 0x63, 0x61, 0x64, 0x65,
  0x73, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x26, 0x61, 0x6d, 0x70,
  0x3b, 0x20, 0x61, 0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x73, 0x72, 0x65, 0x6c, 0x65,
  0x61, 0x73, 0x65, 0x41, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x67, 0x65, 0x74,
  0x74, 0x69, 0x6e, 0x67, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x73, 0x6e, 0x6f,
  0x74, 0x68, 0x69, 0x6e, 0x67, 0x50, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x63,
  0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x73,
  0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63,
  0x65, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x67,
  0x65, 0x73, 0x45, 0x6e, 0x67, 0x6c, 0x61, 0x6e, 0x64, 0x3d, 0x31, 0x26, 0x61,
  0x6d, 0x70, 0x3b, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x3d, 0x20,
  0x6e, 0x65, 0x77, 0x20, 0x43, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c, 0x75, 0x70,
  0x64, 0x61, 0x74, 0x65, 0x64, 0x53, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x4e,
  0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
  0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x6e, 0x69, 0x6e,
  0x67, 0x43, 0x6f, 0x6c, 0x6c, 0x65, 0x67, 0x65, 0x74, 0x6f, 0x6f, 0x6c, 0x62,
  0x61, 0x72, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x62, 0x65, 0x63, 0x61,
  0x75, 0x73, 0x65, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x44, 0x65, 0x75,
  0x74, 0x73, 0x63, 0x68, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x65, 0x77, 0x6f,
  0x72, 0x6b, 0x65, 0x72, 0x73, 0x71, 0x75, 0x69, 0x63, 0x6b, 0x6c, 0x79, 0x62,
  0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x65, 0x78, 0x61, 0x63, 0x74, 0x6c, 0x79,
  0x73, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x73, 0x65, 0x61, 0x73,
  0x65, 0x53, 0x6f, 0x63, 0x69, 0x65, 0x74, 0x79, 0x77, 0x65, 0x61, 0x70, 0x6f,
  0x6e, 0x73, 0x65, 0x78, 0x68, 0x69, 0x62, 0x69, 0x74, 0x26, 0x6c, 0x74, 0x3b,
  0x21, 0x2d, 0x2d, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x65, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x6f, 0x75,
  0x74, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x73, 0x64,
  0x65, 0x76, 0x69, 0x63, 0x65, 0x73, 0x28, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
  0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d,
  0x22, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x65, 0x20, 0x6b, 0x69, 0x6c, 0x6c, 0x69,
  0x6e, 0x67, 0x73, 0x68, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x49, 0x74, 0x61, 0x6c,
  0x69, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x68, 0x65, 0x61,
  0x76, 0x69, 0x6c, 0x79, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x73, 0x2d, 0x31,
  0x27, 0x5d, 0x29, 0x3b, 0x0a, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x43,
  0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65,
  0x73, 0x68, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x6f, 0x70, 0x65, 0x6e, 0x69, 0x6e,
  0x67, 0x64, 0x72, 0x61, 0x77, 0x69, 0x6e, 0x67, 0x62, 0x69, 0x6c, 0x6c, 0x69,
  0x6f, 0x6e, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x65, 0x64, 0x47, 0x65, 0x72, 0x6d,
  0x61, 0x6e, 0x79, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x3c, 0x2f, 0x66,
  0x6f, 0x72, 0x6d, 0x3e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x77, 0x68,
  0x65, 0x74, 0x68, 0x65, 0x72, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x53,
  0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x63, 0x61, 0x74, 0x61, 0x6c, 0x6f, 0x67,
  0x41, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e,
  0x73, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x73, 0x74, 0x75, 0x6e, 0x69, 0x66, 0x6f,
  0x72, 0x6d, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x65, 0x79, 0x73, 0x69, 0x64, 0x65,
  0x62, 0x61, 0x72, 0x43, 0x68, 0x69, 0x63, 0x61, 0x67, 0x6f, 0x68, 0x6f, 0x6c,
  0x69, 0x64, 0x61, 0x79, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x70, 0x61,
  0x73, 0x73, 0x61, 0x67, 0x65, 0x2c, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x61,
  0x6e, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x66, 0x65, 0x65, 0x6c, 0x69, 0x6e, 0x67,
  0x61, 0x72, 0x72, 0x69, 0x76, 0x65, 0x64, 0x70, 0x61, 0x73, 0x73, 0x69, 0x6e,
  0x67, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x72, 0x6f, 0x75, 0x67, 0x68,
  0x6c, 0x79, 0x2e, 0x0a, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x62, 0x75, 0x74, 0x20,
  0x6e, 0x6f, 0x74, 0x64, 0x65, 0x6e, 0x73, 0x69, 0x74, 0x79, 0x42, 0x72, 0x69,
  0x74, 0x61, 0x69, 0x6e, 0x43, 0x68, 0x69, 0x6e, 0x65, 0x73, 0x65, 0x6c, 0x61,
  0x63, 0x6b, 0x20, 0x6f, 0x66, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x49,
  0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x22, 0x20, 0x64, 0x61, 0x74, 0x61, 0x2d,
  0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76,
  0x65, 0x74, 0x68, 0x61, 0x74, 0x20, 0x69, 0x73, 0x4c, 0x69, 0x62, 0x72, 0x61,
  0x72, 0x79, 0x68, 0x75, 0x73, 0x62, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x20, 0x66,
  0x61, 0x63, 0x74, 0x61, 0x66, 0x66, 0x61, 0x69, 0x72, 0x73, 0x43, 0x68, 0x61,
  0x72, 0x6c, 0x65, 0x73, 0x72, 0x61, 0x64, 0x69, 0x63, 0x61, 0x6c, 0x62, 0x72,
  0x6f, 0x75, 0x67, 0x68, 0x74, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x6c,
  0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22,
  0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72,
  0x73, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x65, 0x64, 0x70, 0x72, 0x65, 0x6d, 0x69,
  0x75, 0x6d, 0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x41, 0x6d, 0x65, 0x72,
  0x69, 0x63, 0x61, 0x45, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5d, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x6e, 0x65,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x78, 0x6c, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67,
  0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76,
  0x65, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x2d, 0x6d, 0x6f, 0x62, 0x69,
  0x6c, 0x65, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x77, 0x61, 0x6e, 0x74,
  0x20, 0x74, 0x6f, 0x6b, 0x69, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x46, 0x69, 0x72,
  0x65, 0x66, 0x6f, 0x78, 0x79, 0x6f, 0x75, 0x20, 0x61, 0x72, 0x65, 0x73, 0x69,
  0x6d, 0x69, 0x6c, 0x61, 0x72, 0x73, 0x74, 0x75, 0x64, 0x69, 0x65, 0x64, 0x6d,
  0x61, 0x78, 0x69, 0x6d, 0x75, 0x6d, 0x68, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67,
  0x72, 0x61, 0x70, 0x69, 0x64, 0x6c, 0x79, 0x63, 0x6c, 0x69, 0x6d, 0x61, 0x74,
  0x65, 0x6b, 0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x65, 0x6d, 0x65, 0x72, 0x67,
  0x65, 0x64, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x66, 0x6f, 0x75, 0x6e,
  0x64, 0x65, 0x64, 0x70, 0x69, 0x6f, 0x6e, 0x65, 0x65, 0x72, 0x66, 0x6f, 0x72,
  0x6d, 0x75, 0x6c, 0x61, 0x64, 0x79, 0x6e, 0x61, 0x73, 0x74, 0x79, 0x68, 0x6f,
  0x77, 0x20, 0x74, 0x6f, 0x20, 0x53, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x72,
  0x65, 0x76, 0x65, 0x6e, 0x75, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x79,
  0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x62, 0x72, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x73, 0x6f, 0x6c, 0x64, 0x69, 0x65, 0x72, 0x6c, 0x61, 0x72, 0x67, 0x65,
  0x6c, 0x79, 0x63, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x2e, 0x26, 0x71, 0x75,
  0x6f, 0x74, 0x3b, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x45, 0x64, 0x77,
  0x61, 0x72, 0x64, 0x20, 0x73, 0x65, 0x67, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x6f,
  0x62, 0x65, 0x72, 0x74, 0x20, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x73, 0x50,
  0x61, 0x63, 0x69, 0x66, 0x69, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x6e, 0x65, 0x64,
  0x75, 0x70, 0x20, 0x77, 0x69, 0x74, 0x68, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x3a, 0x77, 0x65, 0x20, 0x68, 0x61, 0x76, 0x65, 0x41, 0x6e, 0x67, 0x65, 0x6c,
  0x65, 0x73, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x5f, 0x73, 0x65, 0x61,
  0x72, 0x63, 0x68, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x61, 0x63, 0x71,
  0x75, 0x69, 0x72, 0x65, 0x6d, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x67, 0x72,
  0x61, 0x6e, 0x74, 0x65, 0x64, 0x3a, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x74,
  0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x62, 0x69, 0x67, 0x67, 0x65, 0x73, 0x74,
  0x62, 0x65, 0x6e, 0x65, 0x66, 0x69, 0x74, 0x64, 0x72, 0x69, 0x76, 0x69, 0x6e,
  0x67, 0x53, 0x74, 0x75, 0x64, 0x69, 0x65, 0x73, 0x6d, 0x69, 0x6e, 0x69, 0x6d,
  0x75, 0x6d, 0x70, 0x65, 0x72, 0x68, 0x61, 0x70, 0x73, 0x6d, 0x6f, 0x72, 0x6e,
  0x69, 0x6e, 0x67, 0x73, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x69, 0x73, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x72, 0x65, 0x76, 0x65, 0x72, 0x73, 0x65, 0x76, 0x61,
  0x72, 0x69, 0x61, 0x6e, 0x74, 0x20, 0x72, 0x6f, 0x6c, 0x65, 0x3d, 0x22, 0x6d,
  0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x61, 0x63, 0x68, 0x69, 0x65, 0x76, 0x65,
  0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74, 0x65, 0x73, 0x74, 0x75, 0x64, 0x65, 0x6e,
  0x74, 0x73, 0x6f, 0x6d, 0x65, 0x6f, 0x6e, 0x65, 0x65, 0x78, 0x74, 0x72, 0x65,
  0x6d, 0x65, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x62, 0x6f, 0x74, 0x74,
  0x6f, 0x6d, 0x3a, 0x65, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x61, 0x6c, 0x6c,
  0x20, 0x74, 0x68, 0x65, 0x73, 0x69, 0x74, 0x65, 0x6d, 0x61, 0x70, 0x65, 0x6e,
  0x67, 0x6c, 0x69, 0x73, 0x68, 0x77, 0x61, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x20,
  0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x73,
  0x43, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72,
  0x73, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x61, 0x67, 0x61, 0x69, 0x6e,
  0x73, 0x74, 0x73, 0x65, 0x72, 0x76, 0x69, 0x6e, 0x67, 0x7d, 0x29, 0x28, 0x29,
  0x3b, 0x0d, 0x0a, 0x70, 0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x74, 0x72, 0x6f,
  0x75, 0x62, 0x6c, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x63, 0x6f,
  0x6d, 0x70, 0x61, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x73, 0x70,
  0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73,
  0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72, 0x20, 0x27, 0x27, 0x54, 0x68, 0x65,
  0x20, 0x77, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x65, 0x78, 0x70, 0x6c, 0x6f,
  0x72, 0x65, 0x61, 0x64, 0x61, 0x70, 0x74, 0x65, 0x64, 0x47, 0x61, 0x6c, 0x6c,
  0x65, 0x72, 0x79, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x61, 0x62, 0x69,
  0x6c, 0x69, 0x74, 0x79, 0x65, 0x6e, 0x68, 0x61, 0x6e, 0x63, 0x65, 0x63, 0x61,
  0x72, 0x65, 0x65, 0x72, 0x73, 0x29, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x63,
  0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x20,
  0x61, 0x6e, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65,
  0x64, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x20, 0x68, 0x61, 0x6e, 0x64, 0x6c,
  0x65, 0x72, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x63, 0x6f, 0x6e, 0x73,
  0x6f, 0x6c, 0x65, 0x45, 0x61, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x78, 0x70,
  0x6f, 0x72, 0x74, 0x73, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x43, 0x68,
  0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x69, 0x6c, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x6e,
  0x65, 0x75, 0x74, 0x72, 0x61, 0x6c, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
  0x5f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x6e,
  0x67, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x3e, 0x73, 0x65, 0x74, 0x74, 0x6c,
  0x65, 0x64, 0x77, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x63, 0x61, 0x75, 0x73,
  0x69, 0x6e, 0x67, 0x2d, 0x77, 0x65, 0x62, 0x6b, 0x69, 0x74, 0x63, 0x6c, 0x61,
  0x69, 0x6d, 0x65, 0x64, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x63, 0x65, 0x63, 0x68,
  0x61, 0x70, 0x74, 0x65, 0x72, 0x76, 0x69, 0x63, 0x74, 0x69, 0x6d, 0x73, 0x54,
  0x68, 0x6f, 0x6d, 0x61, 0x73, 0x20, 0x6d, 0x6f, 0x7a, 0x69, 0x6c, 0x6c, 0x61,
  0x70, 0x72, 0x6f, 0x6d, 0x69, 0x73, 0x65, 0x70, 0x61, 0x72, 0x74, 0x69, 0x65,
  0x73, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x75, 0x74, 0x73, 0x69,
  0x64, 0x65, 0x3a, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x2c, 0x68, 0x75, 0x6e, 0x64,
  0x72, 0x65, 0x64, 0x4f, 0x6c, 0x79, 0x6d, 0x70, 0x69, 0x63, 0x5f, 0x62, 0x75,
  0x74, 0x74, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x73, 0x72, 0x65,
  0x61, 0x63, 0x68, 0x65, 0x64, 0x63, 0x68, 0x72, 0x6f, 0x6e, 0x69, 0x63, 0x64,
  0x65, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x73,
  0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x61, 0x64, 0x6f, 0x70, 0x74, 0x65,
  0x64, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x65, 0x69, 0x74, 0x68,
  0x65, 0x72, 0x67, 0x72, 0x65, 0x61, 0x74, 0x6c, 0x79, 0x67, 0x72, 0x65, 0x61,
  0x74, 0x65, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x69, 0x6d, 0x70,
  0x72, 0x6f, 0x76, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x73, 0x70,
  0x65, 0x63, 0x69, 0x61, 0x6c, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x77,
  0x6f, 0x72, 0x73, 0x68, 0x69, 0x70, 0x66, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67,
  0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73,
  0x74, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61, 0x64, 0x75, 0x74, 0x69, 0x6c, 0x69,
  0x74, 0x79, 0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72, 0x43, 0x75, 0x6c, 0x74,
  0x75, 0x72, 0x65, 0x74, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x63, 0x6c, 0x65,
  0x61, 0x72, 0x6c, 0x79, 0x65, 0x78, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x42, 0x72,
  0x6f, 0x77, 0x73, 0x65, 0x72, 0x6c, 0x69, 0x62, 0x65, 0x72, 0x61, 0x6c, 0x7d,
  0x20, 0x63, 0x61, 0x74, 0x63, 0x68, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
  0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x68, 0x69, 0x64, 0x65, 0x28, 0x29,
  0x3b, 0x46, 0x6c, 0x6f, 0x72, 0x69, 0x64, 0x61, 0x61, 0x6e, 0x73, 0x77, 0x65,
  0x72, 0x73, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x45, 0x6d, 0x70, 0x65,
  0x72, 0x6f, 0x72, 0x64, 0x65, 0x66, 0x65, 0x6e, 0x73, 0x65, 0x73, 0x65, 0x72,
  0x69, 0x6f, 0x75, 0x73, 0x66, 0x72, 0x65, 0x65, 0x64, 0x6f, 0x6d, 0x53, 0x65,
  0x76, 0x65, 0x72, 0x61, 0x6c, 0x2d, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x46,
  0x75, 0x72, 0x74, 0x68, 0x65, 0x72, 0x6f, 0x75, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x21, 0x3d, 0x20, 0x6e, 0x75, 0x6c, 0x6c, 0x74, 0x72, 0x61, 0x69, 0x6e, 0x65,
  0x64, 0x44, 0x65, 0x6e, 0x6d, 0x61, 0x72, 0x6b, 0x76, 0x6f, 0x69, 0x64, 0x28,
  0x30, 0x29, 0x2f, 0x61, 0x6c, 0x6c, 0x2e, 0x6a, 0x73, 0x70, 0x72, 0x65, 0x76,
  0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x65,
  0x70, 0x68, 0x65, 0x6e, 0x0a, 0x0a, 0x57, 0x68, 0x65, 0x6e, 0x20, 0x6f, 0x62,
  0x73, 0x65, 0x72, 0x76, 0x65, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0d, 0x0a, 0x4d,
  0x6f, 0x64, 0x65, 0x72, 0x6e, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
  0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x73, 0x2e, 0x0a, 0x0a, 0x46, 0x6f, 0x72, 0x20, 0x0a, 0x0a, 0x4d, 0x61, 0x6e,
  0x79, 0x20, 0x61, 0x72, 0x74, 0x69, 0x73, 0x74, 0x73, 0x70, 0x6f, 0x77, 0x65,
  0x72, 0x65, 0x64, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x66, 0x69, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x74, 0x79, 0x70, 0x65, 0x20, 0x6f, 0x66, 0x6d, 0x65,
  0x64, 0x69, 0x63, 0x61, 0x6c, 0x74, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x73, 0x6f,
  0x70, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x43, 0x6f, 0x75, 0x6e, 0x63, 0x69, 0x6c,
  0x77, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x63,
  0x65, 0x47, 0x65, 0x6f, 0x72, 0x67, 0x65, 0x20, 0x42, 0x65, 0x6c, 0x67, 0x69,
  0x75, 0x6d, 0x2e, 0x2e, 0x2e, 0x3c, 0x2f, 0x61, 0x3e, 0x74, 0x77, 0x69, 0x74,
  0x74, 0x65, 0x72, 0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x79, 0x77, 0x61, 0x69,
  0x74, 0x69, 0x6e, 0x67, 0x77, 0x61, 0x72, 0x66, 0x61, 0x72, 0x65, 0x20, 0x4f,
  0x74, 0x68, 0x65, 0x72, 0x20, 0x72, 0x61, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x70,
  0x68, 0x72, 0x61, 0x73, 0x65, 0x73, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x75, 0x72, 0x76, 0x69, 0x76, 0x65, 0x73, 0x63, 0x68, 0x6f, 0x6c, 0x61,
  0x72, 0x3c, 0x2f, 0x70, 0x3e, 0x0d, 0x0a, 0x20, 0x43, 0x6f, 0x75, 0x6e, 0x74,
  0x72, 0x79, 0x69, 0x67, 0x6e, 0x6f, 0x72, 0x65, 0x64, 0x6c, 0x6f, 0x73, 0x73,
  0x20, 0x6f, 0x66, 0x6a, 0x75, 0x73, 0x74, 0x20, 0x61, 0x73, 0x47, 0x65, 0x6f,
  0x72, 0x67, 0x69, 0x61, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x3c, 0x68,
  0x65, 0x61, 0x64, 0x3e, 0x3c, 0x73, 0x74, 0x6f, 0x70, 0x70, 0x65, 0x64, 0x31,
  0x27, 0x5d, 0x29, 0x3b, 0x0d, 0x0a, 0x69, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
  0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x3a, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x63, 0x61, 0x72, 0x72, 0x69,
  0x65, 0x64, 0x31, 0x30, 0x30, 0x2c, 0x30, 0x30, 0x30, 0x3c, 0x2f, 0x68, 0x33,
  0x3e, 0x0a, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x62, 0x65, 0x63,
  0x6f, 0x6d, 0x65, 0x73, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x20, 0x77, 0x65,
  0x64, 0x64, 0x69, 0x6e, 0x67, 0x30, 0x30, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x6d,
  0x6f, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x6f, 0x66, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x74, 0x65, 0x61, 0x63, 0x68, 0x65, 0x72, 0x68, 0x69, 0x67, 0x68, 0x6c, 0x79,
  0x20, 0x62, 0x69, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x6c, 0x69, 0x66, 0x65, 0x20,
  0x6f, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x76, 0x65, 0x6e, 0x72, 0x69, 0x73, 0x65,
  0x20, 0x6f, 0x66, 0x26, 0x72, 0x61, 0x71, 0x75, 0x6f, 0x3b, 0x70, 0x6c, 0x75,
  0x73, 0x6f, 0x6e, 0x65, 0x68, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x28, 0x74,
  0x68, 0x6f, 0x75, 0x67, 0x68, 0x44, 0x6f, 0x75, 0x67, 0x6c, 0x61, 0x73, 0x6a,
  0x6f, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x63, 0x69, 0x72, 0x63, 0x6c, 0x65, 0x73,
  0x46, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x41, 0x6e, 0x63, 0x69, 0x65, 0x6e,
  0x74, 0x56, 0x69, 0x65, 0x74, 0x6e, 0x61, 0x6d, 0x76, 0x65, 0x68, 0x69, 0x63,
  0x6c, 0x65, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x63, 0x72, 0x79, 0x73,
  0x74, 0x61, 0x6c, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x3d, 0x57, 0x69, 0x6e,
  0x64, 0x6f, 0x77, 0x73, 0x65, 0x6e, 0x6a, 0x6f, 0x79, 0x65, 0x64, 0x61, 0x20,
  0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x61, 0x73, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x3c,
  0x61, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x66, 0x6f, 0x72, 0x65, 0x69, 0x67, 0x6e,
  0x20, 0x41, 0x6c, 0x6c, 0x20, 0x72, 0x69, 0x68, 0x6f, 0x77, 0x20, 0x74, 0x68,
  0x65, 0x44, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x72, 0x65, 0x74, 0x69, 0x72,
  0x65, 0x64, 0x68, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x68, 0x69, 0x64, 0x64,
  0x65, 0x6e, 0x3b, 0x62, 0x61, 0x74, 0x74, 0x6c, 0x65, 0x73, 0x73, 0x65, 0x65,
  0x6b, 0x69, 0x6e, 0x67, 0x63, 0x61, 0x62, 0x69, 0x6e, 0x65, 0x74, 0x77, 0x61,
  0x73, 0x20, 0x6e, 0x6f, 0x74, 0x6c, 0x6f, 0x6f, 0x6b, 0x20, 0x61, 0x74, 0x63,
  0x6f, 0x6e, 0x64, 0x75, 0x63, 0x74, 0x67, 0x65, 0x74, 0x20, 0x74, 0x68, 0x65,
  0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x68, 0x61, 0x70, 0x70, 0x65, 0x6e,
  0x73, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x61, 0x3a, 0x68, 0x6f, 0x76,
  0x65, 0x72, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x20, 0x46, 0x72, 0x65, 0x6e,
  0x63, 0x68, 0x20, 0x6c, 0x61, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x74, 0x79, 0x70,
  0x69, 0x63, 0x61, 0x6c, 0x65, 0x78, 0x74, 0x72, 0x61, 0x63, 0x74, 0x65, 0x6e,
  0x65, 0x6d, 0x69, 0x65, 0x73, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x69, 0x66, 0x67,
  0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x64, 0x65, 0x63, 0x69, 0x64, 0x65, 0x64,
  0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63,
  0x68, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x66, 0x73, 0x2d, 0x69, 0x6d, 0x61, 0x67,
  0x65, 0x3a, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x73, 0x74, 0x61, 0x74,
  0x69, 0x63, 0x2e, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x22, 0x3e, 0x63, 0x6f, 0x6e,
  0x76, 0x65, 0x72, 0x74, 0x76, 0x69, 0x6f, 0x6c, 0x65, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x65, 0x72, 0x65, 0x64, 0x66, 0x69, 0x72, 0x73, 0x74, 0x22, 0x3e, 0x63,
  0x69, 0x72, 0x63, 0x75, 0x69, 0x74, 0x46, 0x69, 0x6e, 0x6c, 0x61, 0x6e, 0x64,
  0x63, 0x68, 0x65, 0x6d, 0x69, 0x73, 0x74, 0x73, 0x68, 0x65, 0x20, 0x77, 0x61,
  0x73, 0x31, 0x30, 0x70, 0x78, 0x3b, 0x22, 0x3e, 0x61, 0x73, 0x20, 0x73, 0x75,
  0x63, 0x68, 0x64, 0x69, 0x76, 0x69, 0x64, 0x65, 0x64, 0x3c, 0x2f, 0x73, 0x70,
  0x61, 0x6e, 0x3e, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x6e,
  0x65, 0x20, 0x6f, 0x66, 0x61, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x79,
  0x73, 0x74, 0x65, 0x72, 0x79, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x66,
  0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x64, 0x75, 0x65, 0x20, 0x74, 0x6f, 0x20,
  0x72, 0x61, 0x69, 0x6c, 0x77, 0x61, 0x79, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x67,
  0x65, 0x6d, 0x6f, 0x6e, 0x73, 0x74, 0x65, 0x72, 0x64, 0x65, 0x73, 0x63, 0x65,
  0x6e, 0x74, 0x69, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6e, 0x75, 0x63, 0x6c,
  0x65, 0x61, 0x72, 0x4a, 0x65, 0x77, 0x69, 0x73, 0x68, 0x20, 0x70, 0x72, 0x6f,
  0x74, 0x65, 0x73, 0x74, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x66, 0x6c,
  0x6f, 0x77, 0x65, 0x72, 0x73, 0x70, 0x72, 0x65, 0x64, 0x69, 0x63, 0x74, 0x72,
  0x65, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x20,
  0x77, 0x68, 0x6f, 0x20, 0x77, 0x61, 0x73, 0x6c, 0x65, 0x63, 0x74, 0x75, 0x72,
  0x65, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x75, 0x69, 0x63, 0x69,
  0x64, 0x65, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x63, 0x70, 0x65, 0x72, 0x69,
  0x6f, 0x64, 0x73, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x74, 0x73, 0x53, 0x6f, 0x63,
  0x69, 0x61, 0x6c, 0x20, 0x66, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x63, 0x6f,
  0x6d, 0x62, 0x69, 0x6e, 0x65, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x77,
  0x69, 0x6e, 0x6e, 0x65, 0x72, 0x73, 0x3c, 0x62, 0x72, 0x20, 0x2f, 0x3e, 0x3c,
  0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x61, 0x74, 0x75, 0x72, 0x61,
  0x6c, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63, 0x79, 0x63, 0x6f, 0x6f, 0x6b, 0x69,
  0x65, 0x73, 0x6f, 0x75, 0x74, 0x63, 0x6f, 0x6d, 0x65, 0x72, 0x65, 0x73, 0x6f,
  0x6c, 0x76, 0x65, 0x53, 0x77, 0x65, 0x64, 0x69, 0x73, 0x68, 0x62, 0x72, 0x69,
  0x65, 0x66, 0x6c, 0x79, 0x50, 0x65, 0x72, 0x73, 0x69, 0x61, 0x6e, 0x73, 0x6f,
  0x20, 0x6d, 0x75, 0x63, 0x68, 0x43, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x64,
  0x65, 0x70, 0x69, 0x63, 0x74, 0x73, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x6e, 0x73,
  0x68, 0x6f, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x73, 0x6e, 0x65, 0x78, 0x74, 0x20, 0x74, 0x6f, 0x62, 0x65, 0x61, 0x72, 0x69,
  0x6e, 0x67, 0x6d, 0x61, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x76, 0x69,
  0x73, 0x65, 0x64, 0x6a, 0x51, 0x75, 0x65, 0x72, 0x79, 0x28, 0x2d, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3a, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x3e, 0x74, 0x6f,
  0x6f, 0x6c, 0x74, 0x69, 0x70, 0x53, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x64,
  0x65, 0x73, 0x69, 0x67, 0x6e, 0x73, 0x54, 0x75, 0x72, 0x6b, 0x69, 0x73, 0x68,
  0x79, 0x6f, 0x75, 0x6e, 0x67, 0x65, 0x72, 0x2e, 0x6d, 0x61, 0x74, 0x63, 0x68,
  0x28, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x0a, 0x0a, 0x62, 0x75, 0x72, 0x6e, 0x69,
  0x6e, 0x67, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x65, 0x67, 0x72,
  0x65, 0x65, 0x73, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x3d, 0x52, 0x69, 0x63,
  0x68, 0x61, 0x72, 0x64, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x6c, 0x79, 0x70, 0x6c,
  0x61, 0x73, 0x74, 0x69, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3c,
  0x2f, 0x74, 0x72, 0x3e, 0x0d, 0x0a, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23,
  0x75, 0x6c, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x70, 0x6f, 0x73, 0x73, 0x65, 0x73,
  0x73, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x70, 0x68, 0x79, 0x73, 0x69,
  0x63, 0x73, 0x66, 0x61, 0x69, 0x6c, 0x69, 0x6e, 0x67, 0x65, 0x78, 0x65, 0x63,
  0x75, 0x74, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x73, 0x74, 0x6c, 0x69, 0x6e,
  0x6b, 0x20, 0x74, 0x6f, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c, 0x74, 0x3c, 0x62,
  0x72, 0x20, 0x2f, 0x3e, 0x0a, 0x3a, 0x20, 0x74, 0x72, 0x75, 0x65, 0x2c, 0x63,
  0x68, 0x61, 0x72, 0x74, 0x65, 0x72, 0x74, 0x6f, 0x75, 0x72, 0x69, 0x73, 0x6d,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x63, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x65,
  0x64, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x3c, 0x2f, 0x68, 0x31, 0x3e,
  0x0d, 0x0a, 0x6f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x3f, 0x78, 0x6d, 0x6c,
  0x20, 0x76, 0x65, 0x68, 0x65, 0x6c, 0x70, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x61,
  0x6d, 0x6f, 0x6e, 0x64, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x61, 0x69,
  0x72, 0x6c, 0x69, 0x6e, 0x65, 0x65, 0x6e, 0x64, 0x20, 0x2d, 0x2d, 0x3e, 0x29,
  0x2e, 0x61, 0x74, 0x74, 0x72, 0x28, 0x72, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
  0x68, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x23, 0x66, 0x66, 0x66, 0x66, 0x66,
  0x66, 0x72, 0x65, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x56, 0x69, 0x6e, 0x63, 0x65,
  0x6e, 0x74, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x6c, 0x73, 0x20, 0x73, 0x72, 0x63,
  0x3d, 0x22, 0x2f, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x64, 0x65, 0x73,
  0x70, 0x69, 0x74, 0x65, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x65, 0x74, 0x65,
  0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x68,
  0x65, 0x6c, 0x64, 0x20, 0x69, 0x6e, 0x4a, 0x6f, 0x73, 0x65, 0x70, 0x68, 0x20,
  0x74, 0x68, 0x65, 0x61, 0x74, 0x72, 0x65, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74,
  0x73, 0x3c, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3e, 0x61, 0x20, 0x6c, 0x61, 0x72,
  0x67, 0x65, 0x64, 0x6f, 0x65, 0x73, 0x6e, 0x27, 0x74, 0x6c, 0x61, 0x74, 0x65,
  0x72, 0x2c, 0x20, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x66, 0x61, 0x76,
  0x69, 0x63, 0x6f, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x6f, 0x72, 0x48, 0x75,
  0x6e, 0x67, 0x61, 0x72, 0x79, 0x41, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x73,
  0x65, 0x65, 0x20, 0x74, 0x68, 0x65, 0x73, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x4d, 0x69, 0x63, 0x68, 0x61, 0x65, 0x6c, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d,
  0x73, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x2c, 0x20, 0x61, 0x6e,
  0x64, 0x20, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x65, 0x26, 0x71, 0x75,
  0x6f, 0x74, 0x3b, 0x74, 0x72, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x66,
  0x74, 0x22, 0x3e, 0x0a, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x73, 0x47, 0x6f,
  0x6c, 0x64, 0x65, 0x6e, 0x20, 0x41, 0x66, 0x66, 0x61, 0x69, 0x72, 0x73, 0x67,
  0x72, 0x61, 0x6d, 0x6d, 0x61, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x69, 0x6e, 0x67,
  0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x69, 0x64, 0x65, 0x61, 0x20, 0x6f,
  0x66, 0x63, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x73,
  0x74, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x2e, 0x73, 0x72, 0x63,
  0x20, 0x3d, 0x20, 0x63, 0x61, 0x72, 0x74, 0x6f, 0x6f, 0x6e, 0x72, 0x65, 0x67,
  0x69, 0x73, 0x74, 0x72, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x73, 0x4d, 0x75,
  0x73, 0x6c, 0x69, 0x6d, 0x73, 0x57, 0x68, 0x61, 0x74, 0x20, 0x69, 0x73, 0x69,
  0x6e, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x6d, 0x61, 0x72, 0x6b, 0x69, 0x6e, 0x67,
  0x72, 0x65, 0x76, 0x65, 0x61, 0x6c, 0x73, 0x49, 0x6e, 0x64, 0x65, 0x65, 0x64,
  0x2c, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x2f, 0x73, 0x68, 0x6f, 0x77,
  0x5f, 0x61, 0x6f, 0x75, 0x74, 0x64, 0x6f, 0x6f, 0x72, 0x65, 0x73, 0x63, 0x61,
  0x70, 0x65, 0x28, 0x41, 0x75, 0x73, 0x74, 0x72, 0x69, 0x61, 0x67, 0x65, 0x6e,
  0x65, 0x74, 0x69, 0x63, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2c, 0x49, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x69, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x48,
  0x65, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x49, 0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73,
  0x41, 0x63, 0x61, 0x64, 0x65, 0x6d, 0x79, 0x0a, 0x09, 0x09, 0x3c, 0x21, 0x2d,
  0x2d, 0x44, 0x61, 0x6e, 0x69, 0x65, 0x6c, 0x20, 0x62, 0x69, 0x6e, 0x64, 0x69,
  0x6e, 0x67, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x22, 0x3e, 0x69, 0x6d, 0x70, 0x6f,
  0x73, 0x65, 0x64, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x65, 0x41, 0x62, 0x72,
  0x61, 0x68, 0x61, 0x6d, 0x28, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x7b, 0x77,
  0x69, 0x64, 0x74, 0x68, 0x3a, 0x70, 0x75, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x29,
  0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x28, 0x7c, 0x7c, 0x20, 0x5b, 0x5d, 0x3b, 0x0a,
  0x44, 0x41, 0x54, 0x41, 0x5b, 0x20, 0x2a, 0x6b, 0x69, 0x74, 0x63, 0x68, 0x65,
  0x6e, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x64, 0x61, 0x63, 0x74, 0x75, 0x61,
  0x6c, 0x20, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x6d, 0x61, 0x69, 0x6e,
  0x6c, 0x79, 0x20, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x27, 0x69, 0x6e, 0x73,
  0x74, 0x61, 0x6c, 0x6c, 0x65, 0x78, 0x70, 0x65, 0x72, 0x74, 0x73, 0x69, 0x66,
  0x28, 0x74, 0x79, 0x70, 0x65, 0x49, 0x74, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x26,
  0x63, 0x6f, 0x70, 0x79, 0x3b, 0x20, 0x22, 0x3e, 0x54, 0x65, 0x72, 0x6d, 0x73,
  0x62, 0x6f, 0x72, 0x6e, 0x20, 0x69, 0x6e, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x65, 0x61, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x74, 0x61, 0x6c, 0x6b, 0x69,
  0x6e, 0x67, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x72, 0x6e, 0x67, 0x61, 0x69, 0x6e,
  0x65, 0x64, 0x20, 0x6f, 0x6e, 0x67, 0x6f, 0x69, 0x6e, 0x67, 0x6a, 0x75, 0x73,
  0x74, 0x69, 0x66, 0x79, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x73, 0x66, 0x61,
  0x63, 0x74, 0x6f, 0x72, 0x79, 0x69, 0x74, 0x73, 0x20, 0x6f, 0x77, 0x6e, 0x61,
  0x73, 0x73, 0x61, 0x75, 0x6c, 0x74, 0x69, 0x6e, 0x76, 0x69, 0x74, 0x65, 0x64,
  0x6c, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x68, 0x69, 0x73, 0x20, 0x6f, 0x77,
  0x6e, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x22, 0x20, 0x72, 0x65, 0x6c,
  0x3d, 0x22, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x63, 0x6f, 0x6e, 0x63,
  0x65, 0x72, 0x74, 0x64, 0x69, 0x61, 0x67, 0x72, 0x61, 0x6d, 0x64, 0x6f, 0x6c,
  0x6c, 0x61, 0x72, 0x73, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x70, 0x68,
  0x70, 0x3f, 0x69, 0x64, 0x3d, 0x61, 0x6c, 0x63, 0x6f, 0x68, 0x6f, 0x6c, 0x29,
  0x3b, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x61,
  0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x76, 0x65, 0x73, 0x73, 0x65, 0x6c,
  0x73, 0x72, 0x65, 0x76, 0x69, 0x76, 0x61, 0x6c, 0x41, 0x64, 0x64, 0x72, 0x65,
  0x73, 0x73, 0x61, 0x6d, 0x61, 0x74, 0x65, 0x75, 0x72, 0x61, 0x6e, 0x64, 0x72,
  0x6f, 0x69, 0x64, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x69, 0x6c, 0x6c,
  0x6e, 0x65, 0x73, 0x73, 0x77, 0x61, 0x6c, 0x6b, 0x69, 0x6e, 0x67, 0x63, 0x65,
  0x6e, 0x74, 0x65, 0x72, 0x73, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x66, 0x79, 0x6d,
  0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x75, 0x6e, 0x69, 0x66, 0x69, 0x65, 0x64,
  0x65, 0x78, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x73,
  0x65, 0x64, 0x69, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x0a, 0x09, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x73, 0x6c, 0x69, 0x6e, 0x6b,
  0x69, 0x6e, 0x67, 0x4c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x20, 0x42, 0x6f, 0x6f,
  0x6b, 0x20, 0x6f, 0x66, 0x65, 0x76, 0x65, 0x6e, 0x69, 0x6e, 0x67, 0x6d, 0x69,
  0x6e, 0x2e, 0x6a, 0x73, 0x3f, 0x61, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x6b,
  0x6f, 0x6e, 0x74, 0x61, 0x6b, 0x74, 0x74, 0x6f, 0x64, 0x61, 0x79, 0x27, 0x73,
  0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x3d, 0x77, 0x65, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x41, 0x6c, 0x6c, 0x20, 0x52,
  0x69, 0x67, 0x3b, 0x0a, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x72, 0x61, 0x69, 0x73,
  0x69, 0x6e, 0x67, 0x20, 0x41, 0x6c, 0x73, 0x6f, 0x2c, 0x20, 0x63, 0x72, 0x75,
  0x63, 0x69, 0x61, 0x6c, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x22, 0x3e, 0x64, 0x65,
  0x63, 0x6c, 0x61, 0x72, 0x65, 0x2d, 0x2d, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x66,
  0x69, 0x72, 0x65, 0x66, 0x6f, 0x78, 0x61, 0x73, 0x20, 0x6d, 0x75, 0x63, 0x68,
  0x61, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x73, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2c,
  0x20, 0x73, 0x2c, 0x20, 0x62, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x20,
  0x3d, 0x20, 0x0a, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x74, 0x6f, 0x77, 0x61,
  0x72, 0x64, 0x73, 0x52, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x73, 0x50, 0x72, 0x69,
  0x76, 0x61, 0x74, 0x65, 0x46, 0x6f, 0x72, 0x65, 0x69, 0x67, 0x6e, 0x50, 0x72,
  0x65, 0x6d, 0x69, 0x65, 0x72, 0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x73, 0x56,
  0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73,
  0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x6f, 0x77, 0x65, 0x72, 0x65,
  0x64, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x3b, 0x70, 0x6f, 0x76, 0x65, 0x72,
  0x74, 0x79, 0x63, 0x68, 0x61, 0x6d, 0x62, 0x65, 0x72, 0x4c, 0x69, 0x76, 0x69,
  0x6e, 0x67, 0x20, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x73, 0x41, 0x6e, 0x74,
  0x68, 0x6f, 0x6e, 0x79, 0x6c, 0x6f, 0x67, 0x69, 0x6e, 0x22, 0x20, 0x52, 0x65,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x45, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x72,
  0x65, 0x61, 0x63, 0x68, 0x65, 0x73, 0x63, 0x75, 0x74, 0x74, 0x69, 0x6e, 0x67,
  0x67, 0x72, 0x61, 0x76, 0x69, 0x74, 0x79, 0x6c, 0x69, 0x66, 0x65, 0x20, 0x69,
  0x6e, 0x43, 0x68, 0x61, 0x70, 0x74, 0x65, 0x72, 0x2d, 0x73, 0x68, 0x61, 0x64,
  0x6f, 0x77, 0x4e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3c, 0x2f, 0x74, 0x64,
  0x3e, 0x0d, 0x0a, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x73, 0x74, 0x61,
  0x64, 0x69, 0x75, 0x6d, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x76, 0x61,
  0x72, 0x79, 0x69, 0x6e, 0x67, 0x74, 0x72, 0x61, 0x76, 0x65, 0x6c, 0x73, 0x68,
  0x65, 0x6c, 0x64, 0x20, 0x62, 0x79, 0x77, 0x68, 0x6f, 0x20, 0x61, 0x72, 0x65,
  0x77, 0x6f, 0x72, 0x6b, 0x20, 0x69, 0x6e, 0x66, 0x61, 0x63, 0x75, 0x6c, 0x74,
  0x79, 0x61, 0x6e, 0x67, 0x75, 0x6c, 0x61, 0x72, 0x77, 0x68, 0x6f, 0x20, 0x68,
  0x61, 0x64, 0x61, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x74, 0x6f, 0x77, 0x6e,
  0x20, 0x6f, 0x66, 0x0a, 0x0a, 0x53, 0x6f, 0x6d, 0x65, 0x20, 0x27, 0x63, 0x6c,
  0x69, 0x63, 0x6b, 0x27, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65, 0x73, 0x6b, 0x65,
  0x79, 0x77, 0x6f, 0x72, 0x64, 0x69, 0x74, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x63,
  0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x28, 0x74, 0x68, 0x69, 0x73, 0x29, 0x3b,
  0x41, 0x6e, 0x64, 0x72, 0x65, 0x77, 0x20, 0x75, 0x6e, 0x69, 0x71, 0x75, 0x65,
  0x20, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x65, 0x64, 0x6f, 0x72, 0x20, 0x6d, 0x6f,
  0x72, 0x65, 0x33, 0x30, 0x30, 0x70, 0x78, 0x3b, 0x20, 0x72, 0x65, 0x74, 0x75,
  0x72, 0x6e, 0x3b, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x70, 0x6c, 0x75,
  0x67, 0x69, 0x6e, 0x73, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x20, 0x68, 0x65,
  0x72, 0x73, 0x65, 0x6c, 0x66, 0x53, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46,
  0x65, 0x64, 0x65, 0x72, 0x61, 0x6c, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x65,
  0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x73, 0x65, 0x6e, 0x74, 0x20, 0x74,
  0x6f, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x63, 0x74, 0x72, 0x65,
  0x73, 0x73, 0x63, 0x6f, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x66, 0x69, 0x6e, 0x67,
  0x65, 0x72, 0x73, 0x44, 0x75, 0x6b, 0x65, 0x20, 0x6f, 0x66, 0x70, 0x65, 0x6f,
  0x70, 0x6c, 0x65, 0x2c, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x69, 0x74, 0x77, 0x68,
  0x61, 0x74, 0x20, 0x69, 0x73, 0x68, 0x61, 0x72, 0x6d, 0x6f, 0x6e, 0x79, 0x61,
  0x20, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x22, 0x3a, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x69, 0x6e, 0x20, 0x68, 0x69, 0x73, 0x20, 0x6d, 0x65, 0x6e, 0x75, 0x22, 0x3e,
  0x0a, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x6c, 0x79, 0x6f, 0x66, 0x66, 0x69, 0x63,
  0x65, 0x72, 0x63, 0x6f, 0x75, 0x6e, 0x63, 0x69, 0x6c, 0x67, 0x61, 0x69, 0x6e,
  0x69, 0x6e, 0x67, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x69, 0x6e, 0x53, 0x75, 0x6d,
  0x6d, 0x61, 0x72, 0x79, 0x64, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x6c, 0x6f,
  0x79, 0x61, 0x6c, 0x74, 0x79, 0x66, 0x69, 0x74, 0x6e, 0x65, 0x73, 0x73, 0x61,
  0x6e, 0x64, 0x20, 0x77, 0x61, 0x73, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x6f, 0x72,
  0x73, 0x75, 0x70, 0x72, 0x65, 0x6d, 0x65, 0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64,
  0x20, 0x68, 0x65, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x52, 0x75, 0x73, 0x73, 0x69,
  0x61, 0x6e, 0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x73, 0x74, 0x41, 0x6c, 0x62, 0x65,
  0x72, 0x74, 0x61, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x61, 0x6c, 0x73, 0x65, 0x74,
  0x20, 0x6f, 0x66, 0x20, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x22, 0x3e, 0x2e, 0x61,
  0x70, 0x70, 0x65, 0x6e, 0x64, 0x64, 0x6f, 0x20, 0x77, 0x69, 0x74, 0x68, 0x66,
  0x65, 0x64, 0x65, 0x72, 0x61, 0x6c, 0x62, 0x61, 0x6e, 0x6b, 0x20, 0x6f, 0x66,
  0x62, 0x65, 0x6e, 0x65, 0x61, 0x74, 0x68, 0x44, 0x65, 0x73, 0x70, 0x69, 0x74,
  0x65, 0x43, 0x61, 0x70, 0x69, 0x74, 0x61, 0x6c, 0x67, 0x72, 0x6f, 0x75, 0x6e,
  0x64, 0x73, 0x29, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x65, 0x72, 0x63,
  0x65, 0x6e, 0x74, 0x69, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x63, 0x6c, 0x6f,
  0x73, 0x69, 0x6e, 0x67, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x49, 0x6e,
  0x73, 0x74, 0x65, 0x61, 0x64, 0x66, 0x69, 0x66, 0x74, 0x65, 0x65, 0x6e, 0x61,
  0x73, 0x20, 0x77, 0x65, 0x6c, 0x6c, 0x2e, 0x79, 0x61, 0x68, 0x6f, 0x6f, 0x2e,
  0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x66, 0x69, 0x67, 0x68, 0x74, 0x65,
  0x72, 0x6f, 0x62, 0x73, 0x63, 0x75, 0x72, 0x65, 0x72, 0x65, 0x66, 0x6c, 0x65,
  0x63, 0x74, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x63, 0x3d, 0x20, 0x4d, 0x61,
  0x74, 0x68, 0x2e, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6e, 0x67, 0x6f, 0x6e, 0x6c,
  0x69, 0x6e, 0x65, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x61, 0x20,
  0x77, 0x68, 0x6f, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x79,
  0x65, 0x61, 0x72, 0x20, 0x6f, 0x66, 0x65, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20,
  0x62, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x69,
  0x74, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x20, 0x68, 0x6f, 0x6d, 0x65, 0x20,
  0x6f, 0x66, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x65, 0x64, 0x72, 0x65, 0x6e, 0x61,
  0x6d, 0x65, 0x64, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x68, 0x65, 0x61,
  0x74, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x63, 0x6c,
  0x6f, 0x75, 0x64, 0x66, 0x72, 0x77, 0x61, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x4d,
  0x61, 0x72, 0x63, 0x68, 0x20, 0x31, 0x6b, 0x6e, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x69, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x74, 0x42, 0x65, 0x74, 0x77, 0x65, 0x65,
  0x6e, 0x6c, 0x65, 0x73, 0x73, 0x6f, 0x6e, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x65,
  0x73, 0x74, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x69, 0x6e, 0x6b,
  0x73, 0x22, 0x3e, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x65, 0x64, 0x45, 0x4e, 0x44,
  0x20, 0x2d, 0x2d, 0x3e, 0x66, 0x61, 0x6d, 0x6f, 0x75, 0x73, 0x20, 0x61, 0x77,
  0x61, 0x72, 0x64, 0x65, 0x64, 0x4c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x48,
  0x65, 0x61, 0x6c, 0x74, 0x68, 0x20, 0x66, 0x61, 0x69, 0x72, 0x6c, 0x79, 0x20,
  0x77, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x6d, 0x69, 0x6e, 0x69, 0x6d, 0x61,
  0x6c, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x65,
  0x74, 0x65, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x22, 0x3e, 0x73, 0x69, 0x6e, 0x67,
  0x69, 0x6e, 0x67, 0x66, 0x61, 0x72, 0x6d, 0x65, 0x72, 0x73, 0x42, 0x72, 0x61,
  0x73, 0x69, 0x6c, 0x29, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x72, 0x65,
  0x70, 0x6c, 0x61, 0x63, 0x65, 0x47, 0x72, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x66,
  0x6f, 0x6e, 0x74, 0x20, 0x63, 0x6f, 0x70, 0x75, 0x72, 0x73, 0x75, 0x65, 0x64,
  0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x75,
  0x70, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x62, 0x6f, 0x74, 0x68, 0x20,
  0x6f, 0x66, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x73, 0x61, 0x77, 0x20,
  0x74, 0x68, 0x65, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x65, 0x73, 0x63, 0x6f, 0x6c,
  0x6f, 0x75, 0x72, 0x73, 0x69, 0x66, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x77, 0x68,
  0x65, 0x6e, 0x20, 0x68, 0x65, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x70,
  0x75, 0x73, 0x68, 0x28, 0x66, 0x75, 0x41, 0x75, 0x67, 0x75, 0x73, 0x74, 0x20,
  0x55, 0x54, 0x46, 0x2d, 0x38, 0x22, 0x3e, 0x46, 0x61, 0x6e, 0x74, 0x61, 0x73,
  0x79, 0x69, 0x6e, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x69, 0x6e, 0x6a, 0x75, 0x72,
  0x65, 0x64, 0x55, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x66, 0x61, 0x72, 0x6d,
  0x69, 0x6e, 0x67, 0x63, 0x6c, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x6f, 0x62, 0x6a,
  0x65, 0x63, 0x74, 0x20, 0x64, 0x65, 0x66, 0x65, 0x6e, 0x63, 0x65, 0x75, 0x73,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x4d, 0x65, 0x64, 0x69, 0x63, 0x61, 0x6c, 0x3c,
  0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x74,
  0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x6b, 0x65, 0x79, 0x43, 0x6f, 0x64,
  0x65, 0x73, 0x69, 0x78, 0x74, 0x65, 0x65, 0x6e, 0x49, 0x73, 0x6c, 0x61, 0x6d,
  0x69, 0x63, 0x23, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x65, 0x6e, 0x74, 0x69,
  0x72, 0x65, 0x20, 0x77, 0x69, 0x64, 0x65, 0x6c, 0x79, 0x20, 0x61, 0x63, 0x74,
  0x69, 0x76, 0x65, 0x20, 0x28, 0x74, 0x79, 0x70, 0x65, 0x6f, 0x66, 0x6f, 0x6e,
  0x65, 0x20, 0x63, 0x61, 0x6e, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x20, 0x3d, 0x73,
  0x70, 0x65, 0x61, 0x6b, 0x65, 0x72, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x73,
  0x50, 0x68, 0x79, 0x73, 0x69, 0x63, 0x73, 0x74, 0x65, 0x72, 0x72, 0x61, 0x69,
  0x6e, 0x3c, 0x74, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x66, 0x75, 0x6e, 0x65, 0x72,
  0x61, 0x6c, 0x76, 0x69, 0x65, 0x77, 0x69, 0x6e, 0x67, 0x6d, 0x69, 0x64, 0x64,
  0x6c, 0x65, 0x20, 0x63, 0x72, 0x69, 0x63, 0x6b, 0x65, 0x74, 0x70, 0x72, 0x6f,
  0x70, 0x68, 0x65, 0x74, 0x73, 0x68, 0x69, 0x66, 0x74, 0x65, 0x64, 0x64, 0x6f,
  0x63, 0x74, 0x6f, 0x72, 0x73, 0x52, 0x75, 0x73, 0x73, 0x65, 0x6c, 0x6c, 0x20,
  0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x63, 0x74,
  0x61, 0x6c, 0x67, 0x65, 0x62, 0x72, 0x61, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x6c,
  0x2d, 0x62, 0x75, 0x6c, 0x6b, 0x20, 0x6f, 0x66, 0x6d, 0x61, 0x6e, 0x20, 0x61,
  0x6e, 0x64, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x0a, 0x20, 0x68, 0x65, 0x20, 0x6c,
  0x65, 0x66, 0x74, 0x29, 0x2e, 0x76, 0x61, 0x6c, 0x28, 0x29, 0x66, 0x61, 0x6c,
  0x73, 0x65, 0x29, 0x3b, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x62, 0x61,
  0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x68, 0x6f, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x6e,
  0x61, 0x6d, 0x69, 0x6e, 0x67, 0x20, 0x41, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x61,
  0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x73, 0x29, 0x3b, 0x0a, 0x7d, 0x29, 0x3b,
  0x0a, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x20, 0x74, 0x75,
  0x72, 0x6e, 0x43, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x73, 0x62, 0x65, 0x66, 0x6f,
  0x72, 0x65, 0x20, 0x42, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x63, 0x68, 0x61,
  0x72, 0x67, 0x65, 0x64, 0x54, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x3e, 0x43, 0x61,
  0x70, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x70, 0x65, 0x6c, 0x6c, 0x65, 0x64, 0x67,
  0x6f, 0x64, 0x64, 0x65, 0x73, 0x73, 0x54, 0x61, 0x67, 0x20, 0x2d, 0x2d, 0x3e,
  0x41, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x62, 0x75, 0x74, 0x20, 0x77, 0x61,
  0x73, 0x52, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x70, 0x61, 0x74, 0x69, 0x65,
  0x6e, 0x74, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x69, 0x6e, 0x3d, 0x66, 0x61, 0x6c,
  0x73, 0x65, 0x26, 0x4c, 0x69, 0x6e, 0x63, 0x6f, 0x6c, 0x6e, 0x77, 0x65, 0x20,
  0x6b, 0x6e, 0x6f, 0x77, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x4a, 0x75,
  0x64, 0x61, 0x69, 0x73, 0x6d, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x61,
  0x6c, 0x74, 0x65, 0x72, 0x65, 0x64, 0x27, 0x5d, 0x29, 0x3b, 0x0a, 0x20, 0x20,
  0x68, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x75, 0x6e, 0x63, 0x6c, 0x65, 0x61,
  0x72, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x27, 0x2c, 0x62, 0x6f, 0x74, 0x68, 0x20,
  0x69, 0x6e, 0x6e, 0x6f, 0x74, 0x20, 0x61, 0x6c, 0x6c, 0x0a, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x68, 0x61, 0x72,
  0x64, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x73, 0x6f,
  0x72, 0x74, 0x20, 0x6f, 0x66, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x73,
  0x74, 0x72, 0x65, 0x65, 0x74, 0x73, 0x42, 0x65, 0x72, 0x6e, 0x61, 0x72, 0x64,
  0x61, 0x73, 0x73, 0x65, 0x72, 0x74, 0x73, 0x74, 0x65, 0x6e, 0x64, 0x20, 0x74,
  0x6f, 0x66, 0x61, 0x6e, 0x74, 0x61, 0x73, 0x79, 0x64, 0x6f, 0x77, 0x6e, 0x20,
  0x69, 0x6e, 0x68, 0x61, 0x72, 0x62, 0x6f, 0x75, 0x72, 0x46, 0x72, 0x65, 0x65,
  0x64, 0x6f, 0x6d, 0x6a, 0x65, 0x77, 0x65, 0x6c, 0x72, 0x79, 0x2f, 0x61, 0x62,
  0x6f, 0x75, 0x74, 0x2e, 0x2e, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x6c, 0x65,
  0x67, 0x65, 0x6e, 0x64, 0x73, 0x69, 0x73, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x6d,
  0x6f, 0x64, 0x65, 0x72, 0x6e, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x6f, 0x6e,
  0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x74, 0x6f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x22,
  0x20, 0x6c, 0x69, 0x6e, 0x65, 0x61, 0x72, 0x20, 0x70, 0x61, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x61, 0x6e, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x72, 0x61, 0x72, 0x65,
  0x6c, 0x79, 0x20, 0x61, 0x63, 0x72, 0x6f, 0x6e, 0x79, 0x6d, 0x64, 0x65, 0x6c,
  0x69, 0x76, 0x65, 0x72, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x65, 0x72, 0x30, 0x30,
  0x26, 0x61, 0x6d, 0x70, 0x3b, 0x61, 0x73, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x77,
  0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x2f, 0x2a, 0x20, 0x3c, 0x21, 0x5b, 0x43,
  0x74, 0x69, 0x74, 0x6c, 0x65, 0x20, 0x3d, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x6c, 0x6f, 0x77, 0x65, 0x73, 0x74, 0x20, 0x70, 0x69, 0x63, 0x6b, 0x65,
  0x64, 0x20, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x64, 0x75, 0x73, 0x65, 0x73,
  0x20, 0x6f, 0x66, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x73, 0x20, 0x50, 0x75,
  0x62, 0x6c, 0x69, 0x63, 0x4d, 0x61, 0x74, 0x74, 0x68, 0x65, 0x77, 0x74, 0x61,
  0x63, 0x74, 0x69, 0x63, 0x73, 0x64, 0x61, 0x6d, 0x61, 0x67, 0x65, 0x64, 0x77,
  0x61, 0x79, 0x20, 0x66, 0x6f, 0x72, 0x6c, 0x61, 0x77, 0x73, 0x20, 0x6f, 0x66,
  0x65, 0x61, 0x73, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x69, 0x6e, 0x64, 0x6f,
  0x77, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x20, 0x20, 0x73, 0x69, 0x6d, 0x70,
  0x6c, 0x65, 0x7d, 0x63, 0x61, 0x74, 0x63, 0x68, 0x28, 0x73, 0x65, 0x76, 0x65,
  0x6e, 0x74, 0x68, 0x69, 0x6e, 0x66, 0x6f, 0x62, 0x6f, 0x78, 0x77, 0x65, 0x6e,
  0x74, 0x20, 0x74, 0x6f, 0x70, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x63, 0x69,
  0x74, 0x69, 0x7a, 0x65, 0x6e, 0x49, 0x20, 0x64, 0x6f, 0x6e, 0x27, 0x74, 0x72,
  0x65, 0x74, 0x72, 0x65, 0x61, 0x74, 0x2e, 0x20, 0x53, 0x6f, 0x6d, 0x65, 0x20,
  0x77, 0x77, 0x2e, 0x22, 0x29, 0x3b, 0x0a, 0x62, 0x6f, 0x6d, 0x62, 0x69, 0x6e,
  0x67, 0x6d, 0x61, 0x69, 0x6c, 0x74, 0x6f, 0x3a, 0x6d, 0x61, 0x64, 0x65, 0x20,
  0x69, 0x6e, 0x2e, 0x20, 0x4d, 0x61, 0x6e, 0x79, 0x20, 0x63, 0x61, 0x72, 0x72,
  0x69, 0x65, 0x73, 0x7c, 0x7c, 0x7b, 0x7d, 0x3b, 0x77, 0x69, 0x77, 0x6f, 0x72,
  0x6b, 0x20, 0x6f, 0x66, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x64, 0x65,
  0x66, 0x65, 0x61, 0x74, 0x73, 0x66, 0x61, 0x76, 0x6f, 0x72, 0x65, 0x64, 0x6f,
  0x70, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x70, 0x61, 0x67, 0x65, 0x54, 0x72, 0x61,
  0x75, 0x6e, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x73, 0x65, 0x6e, 0x64, 0x69, 0x6e,
  0x67, 0x6c, 0x65, 0x66, 0x74, 0x22, 0x3e, 0x3c, 0x63, 0x6f, 0x6d, 0x53, 0x63,
  0x6f, 0x72, 0x41, 0x6c, 0x6c, 0x20, 0x74, 0x68, 0x65, 0x6a, 0x51, 0x75, 0x65,
  0x72, 0x79, 0x2e, 0x74, 0x6f, 0x75, 0x72, 0x69, 0x73, 0x74, 0x43, 0x6c, 0x61,
  0x73, 0x73, 0x69, 0x63, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x20, 0x57, 0x69,
  0x6c, 0x68, 0x65, 0x6c, 0x6d, 0x73, 0x75, 0x62, 0x75, 0x72, 0x62, 0x73, 0x67,
  0x65, 0x6e, 0x75, 0x69, 0x6e, 0x65, 0x62, 0x69, 0x73, 0x68, 0x6f, 0x70, 0x73,
  0x2e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x28, 0x67, 0x6c, 0x6f, 0x62, 0x61, 0x6c,
  0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x62, 0x6f, 0x64, 0x79, 0x20,
  0x6f, 0x66, 0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x74,
  0x61, 0x63, 0x74, 0x73, 0x65, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x6c, 0x65, 0x66,
  0x74, 0x20, 0x74, 0x6f, 0x63, 0x68, 0x69, 0x65, 0x66, 0x6c, 0x79, 0x2d, 0x68,
  0x69, 0x64, 0x64, 0x65, 0x6e, 0x2d, 0x62, 0x61, 0x6e, 0x6e, 0x65, 0x72, 0x3c,
  0x2f, 0x6c, 0x69, 0x3e, 0x0a, 0x0a, 0x2e, 0x20, 0x57, 0x68, 0x65, 0x6e, 0x20,
  0x69, 0x6e, 0x20, 0x62, 0x6f, 0x74, 0x68, 0x64, 0x69, 0x73, 0x6d, 0x69, 0x73,
  0x73, 0x45, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x61, 0x6c, 0x77, 0x61, 0x79,
  0x73, 0x20, 0x76, 0x69, 0x61, 0x20, 0x74, 0x68, 0x65, 0x73, 0x70, 0x61, 0xc3,
  0xb1, 0x6f, 0x6c, 0x77, 0x65, 0x6c, 0x66, 0x61, 0x72, 0x65, 0x72, 0x75, 0x6c,
  0x69, 0x6e, 0x67, 0x20, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x63, 0x61,
  0x70, 0x74, 0x61, 0x69, 0x6e, 0x68, 0x69, 0x73, 0x20, 0x73, 0x6f, 0x6e, 0x72,
  0x75, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x6f, 0x6b,
  0x69, 0x74, 0x73, 0x65, 0x6c, 0x66, 0x2c, 0x3d, 0x30, 0x26, 0x61, 0x6d, 0x70,
  0x3b, 0x28, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x73, 0x61, 0x6d, 0x70, 0x6c,
  0x65, 0x73, 0x74, 0x6f, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x63, 0x6f, 0x6d, 0x2f,
  0x70, 0x61, 0x67, 0x4d, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x20, 0x4b, 0x65, 0x6e,
  0x6e, 0x65, 0x64, 0x79, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x73, 0x66, 0x75,
  0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x68, 0x61, 0x6e, 0x64, 0x6c, 0x65, 0x64, 0x42,
  0x65, 0x73, 0x69, 0x64, 0x65, 0x73, 0x2f, 0x2f, 0x2d, 0x2d, 0x3e, 0x3c, 0x2f,
  0x61, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x73, 0x65, 0x73, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x68, 0x69, 0x6d, 0x20, 0x74,
  0x6f, 0x20, 0x69, 0x74, 0x73, 0x20, 0x62, 0x79, 0x20, 0x63, 0x6f, 0x6d, 0x6d,
  0x6f, 0x6e, 0x2e, 0x6d, 0x69, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x74, 0x6f, 0x20,
  0x74, 0x61, 0x6b, 0x65, 0x77, 0x61, 0x79, 0x73, 0x20, 0x74, 0x6f, 0x73, 0x2e,
  0x6f, 0x72, 0x67, 0x2f, 0x6c, 0x61, 0x64, 0x76, 0x69, 0x73, 0x65, 0x64, 0x70,
  0x65, 0x6e, 0x61, 0x6c, 0x74, 0x79, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x3a,
  0x69, 0x66, 0x20, 0x74, 0x68, 0x65, 0x79, 0x4c, 0x65, 0x74, 0x74, 0x65, 0x72,
  0x73, 0x61, 0x20, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x48, 0x65, 0x72, 0x62, 0x65,
  0x72, 0x74, 0x73, 0x74, 0x72, 0x69, 0x6b, 0x65, 0x73, 0x20, 0x67, 0x72, 0x6f,
  0x75, 0x70, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x66, 0x6c, 0x69,
  0x67, 0x68, 0x74, 0x73, 0x6f, 0x76, 0x65, 0x72, 0x6c, 0x61, 0x70, 0x73, 0x6c,
  0x6f, 0x77, 0x6c, 0x79, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x65, 0x72, 0x20, 0x73,
  0x6f, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x3c, 0x2f, 0x70, 0x3e, 0x0a, 0x09, 0x09,
  0x69, 0x74, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x72, 0x61, 0x6e, 0x6b, 0x65, 0x64,
  0x20, 0x72, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x75, 0x6c, 0x3e, 0x0d, 0x0a,
  0x20, 0x20, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x70, 0x61, 0x69, 0x72,
  0x20, 0x6f, 0x66, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x69, 0x74, 0x4b, 0x6f, 0x6e,
  0x74, 0x61, 0x6b, 0x74, 0x41, 0x6e, 0x74, 0x6f, 0x6e, 0x69, 0x6f, 0x68, 0x61,
  0x76, 0x69, 0x6e, 0x67, 0x20, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x20,
  0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x73,
  0x74, 0x72, 0x61, 0x70, 0x70, 0x65, 0x64, 0x22, 0x29, 0x2e, 0x63, 0x73, 0x73,
  0x28, 0x68, 0x6f, 0x73, 0x74, 0x69, 0x6c, 0x65, 0x6c, 0x65, 0x61, 0x64, 0x20,
  0x74, 0x6f, 0x6c, 0x69, 0x74, 0x74, 0x6c, 0x65, 0x20, 0x67, 0x72, 0x6f, 0x75,
  0x70, 0x73, 0x2c, 0x50, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x2d, 0x2d, 0x3e,
  0x0d, 0x0a, 0x0d, 0x0a, 0x20, 0x72, 0x6f, 0x77, 0x73, 0x3d, 0x22, 0x20, 0x6f,
  0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x65, 0x3c,
  0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56,
  0x3e, 0x3c, 0x5c, 0x2f, 0x73, 0x63, 0x72, 0x73, 0x6f, 0x6c, 0x76, 0x69, 0x6e,
  0x67, 0x43, 0x68, 0x61, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x6c, 0x61, 0x76, 0x65,
  0x72, 0x79, 0x77, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x77, 0x68, 0x65, 0x72,
  0x65, 0x61, 0x73, 0x21, 0x3d, 0x20, 0x27, 0x75, 0x6e, 0x64, 0x66, 0x6f, 0x72,
  0x20, 0x61, 0x6c, 0x6c, 0x70, 0x61, 0x72, 0x74, 0x6c, 0x79, 0x20, 0x2d, 0x72,
  0x69, 0x67, 0x68, 0x74, 0x3a, 0x41, 0x72, 0x61, 0x62, 0x69, 0x61, 0x6e, 0x62,
  0x61, 0x63, 0x6b, 0x65, 0x64, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79,
  0x75, 0x6e, 0x69, 0x74, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x62, 0x69, 0x6c, 0x65,
  0x2d, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x2c, 0x69, 0x73, 0x20, 0x68, 0x6f,
  0x6d, 0x65, 0x72, 0x69, 0x73, 0x6b, 0x20, 0x6f, 0x66, 0x64, 0x65, 0x73, 0x69,
  0x72, 0x65, 0x64, 0x43, 0x6c, 0x69, 0x6e, 0x74, 0x6f, 0x6e, 0x63, 0x6f, 0x73,
  0x74, 0x20, 0x6f, 0x66, 0x61, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x62, 0x65,
  0x63, 0x6f, 0x6d, 0x65, 0x20, 0x6e, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x70,
  0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x4d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x20,
  0x65, 0x61, 0x64, 0x27, 0x29, 0x5b, 0x30, 0x43, 0x72, 0x69, 0x74, 0x69, 0x63,
  0x73, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x73, 0x3e, 0x26, 0x63, 0x6f, 0x70,
  0x79, 0x3b, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x22, 0x3e, 0x61, 0x73, 0x73, 0x65,
  0x6d, 0x62, 0x6c, 0x6d, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x70, 0x72, 0x65,
  0x73, 0x73, 0x65, 0x64, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x2e, 0x70, 0x73,
  0x3a, 0x22, 0x20, 0x3f, 0x20, 0x72, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x62,
  0x79, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x46, 0x6f, 0x72, 0x6d, 0x65, 0x72, 0x20,
  0x65, 0x64, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x64, 0x65, 0x6c, 0x61, 0x79, 0x65,
  0x64, 0x43, 0x61, 0x6e, 0x6f, 0x6e, 0x69, 0x63, 0x68, 0x61, 0x64, 0x20, 0x74,
  0x68, 0x65, 0x70, 0x75, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x62, 0x75, 0x74, 0x20, 0x61, 0x72, 0x65, 0x70, 0x61, 0x72,
  0x74, 0x69, 0x61, 0x6c, 0x42, 0x61, 0x62, 0x79, 0x6c, 0x6f, 0x6e, 0x62, 0x6f,
  0x74, 0x74, 0x6f, 0x6d, 0x20, 0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x72, 0x43,
  0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x69, 0x74, 0x73, 0x20, 0x75, 0x73, 0x65,
  0x41, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x63, 0x6f, 0x75, 0x72, 0x73, 0x65,
  0x73, 0x61, 0x20, 0x74, 0x68, 0x69, 0x72, 0x64, 0x64, 0x65, 0x6e, 0x6f, 0x74,
  0x65, 0x73, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x69, 0x6e, 0x48, 0x6f, 0x75, 0x73,
  0x74, 0x6f, 0x6e, 0x32, 0x30, 0x70, 0x78, 0x3b, 0x22, 0x3e, 0x61, 0x63, 0x63,
  0x75, 0x73, 0x65, 0x64, 0x64, 0x6f, 0x75, 0x62, 0x6c, 0x65, 0x20, 0x67, 0x6f,
  0x61, 0x6c, 0x20, 0x6f, 0x66, 0x46, 0x61, 0x6d, 0x6f, 0x75, 0x73, 0x20, 0x29,
  0x2e, 0x62, 0x69, 0x6e, 0x64, 0x28, 0x70, 0x72, 0x69, 0x65, 0x73, 0x74, 0x73,
  0x20, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x69, 0x6e, 0x20, 0x4a, 0x75, 0x6c,
  0x79, 0x73, 0x74, 0x20, 0x2b, 0x20, 0x22, 0x67, 0x63, 0x6f, 0x6e, 0x73, 0x75,
  0x6c, 0x74, 0x64, 0x65, 0x63, 0x69, 0x6d, 0x61, 0x6c, 0x68, 0x65, 0x6c, 0x70,
  0x66, 0x75, 0x6c, 0x72, 0x65, 0x76, 0x69, 0x76, 0x65, 0x64, 0x69, 0x73, 0x20,
  0x76, 0x65, 0x72, 0x79, 0x72, 0x27, 0x2b, 0x27, 0x69, 0x70, 0x74, 0x6c, 0x6f,
  0x73, 0x69, 0x6e, 0x67, 0x20, 0x66, 0x65, 0x6d, 0x61, 0x6c, 0x65, 0x73, 0x69,
  0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x73,
  0x64, 0x61, 0x79, 0x73, 0x20, 0x6f, 0x66, 0x61, 0x72, 0x72, 0x69, 0x76, 0x61,
  0x6c, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x20, 0x3c, 0x6f, 0x62, 0x6a, 0x65,
  0x63, 0x74, 0x66, 0x6f, 0x72, 0x63, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x72, 0x69,
  0x6e, 0x67, 0x28, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x09, 0x09, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x69, 0x73, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x64, 0x2e, 0x20,
  0x20, 0x54, 0x68, 0x65, 0x20, 0x62, 0x61, 0x6c, 0x6c, 0x6f, 0x6f, 0x6e, 0x64,
  0x6f, 0x6e, 0x65, 0x20, 0x62, 0x79, 0x2f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e,
  0x62, 0x67, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x6c, 0x61, 0x77, 0x20, 0x6f, 0x66,
  0x20, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x61, 0x61, 0x76, 0x6f, 0x69, 0x64,
  0x65, 0x64, 0x62, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x32, 0x70, 0x78, 0x20,
  0x33, 0x70, 0x78, 0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x61, 0x66, 0x74,
  0x65, 0x72, 0x20, 0x61, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x6d, 0x65,
  0x6e, 0x20, 0x61, 0x6e, 0x64, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x2d, 0x3d,
  0x20, 0x74, 0x72, 0x75, 0x65, 0x3b, 0x66, 0x6f, 0x72, 0x20, 0x75, 0x73, 0x65,
  0x73, 0x63, 0x72, 0x65, 0x65, 0x6e, 0x2e, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e,
  0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x20, 0x3d, 0x66, 0x61, 0x6d, 0x69, 0x6c,
  0x79, 0x2c, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x20, 0x26, 0x6e, 0x62,
  0x73, 0x70, 0x3b, 0x64, 0x72, 0x69, 0x76, 0x65, 0x72, 0x73, 0x65, 0x74, 0x65,
  0x72, 0x6e, 0x61, 0x6c, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x61, 0x73, 0x6e, 0x6f,
  0x74, 0x69, 0x63, 0x65, 0x64, 0x76, 0x69, 0x65, 0x77, 0x65, 0x72, 0x73, 0x7d,
  0x29, 0x28, 0x29, 0x3b, 0x0a, 0x20, 0x69, 0x73, 0x20, 0x6d, 0x6f, 0x72, 0x65,
  0x73, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x72,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x65, 0x77, 0x69, 0x73, 0x20, 0x6a, 0x75,
  0x73, 0x74, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x20, 0x53, 0x65, 0x61,
  0x72, 0x63, 0x68, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x77, 0x68, 0x79,
  0x20, 0x74, 0x68, 0x65, 0x73, 0x68, 0x69, 0x70, 0x70, 0x65, 0x64, 0x62, 0x72,
  0x3e, 0x3c, 0x62, 0x72, 0x3e, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x20, 0x68,
  0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x6f, 0x66,
  0x63, 0x75, 0x69, 0x73, 0x69, 0x6e, 0x65, 0x69, 0x73, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x61, 0x20, 0x76, 0x65, 0x72, 0x79, 0x20, 0x41, 0x64, 0x6d, 0x69, 0x72,
  0x61, 0x6c, 0x20, 0x66, 0x69, 0x78, 0x65, 0x64, 0x3b, 0x6e, 0x6f, 0x72, 0x6d,
  0x61, 0x6c, 0x20, 0x4d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x50, 0x72, 0x65,
  0x73, 0x73, 0x2c, 0x20, 0x6f, 0x6e, 0x74, 0x61, 0x72, 0x69, 0x6f, 0x63, 0x68,
  0x61, 0x72, 0x73, 0x65, 0x74, 0x74, 0x72, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x69,
  0x6e, 0x76, 0x61, 0x64, 0x65, 0x64, 0x3d, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22,
  0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x69, 0x73, 0x20, 0x6d, 0x6f, 0x73,
  0x74, 0x61, 0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6c,
  0x6c, 0x79, 0x66, 0x61, 0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x7d, 0x29, 0x3b, 0x0d,
  0x0a, 0x20, 0x20, 0x69, 0x6d, 0x6d, 0x65, 0x6e, 0x73, 0x65, 0x74, 0x69, 0x6d,
  0x65, 0x20, 0x69, 0x6e, 0x73, 0x65, 0x74, 0x20, 0x6f, 0x75, 0x74, 0x73, 0x61,
  0x74, 0x69, 0x73, 0x66, 0x79, 0x74, 0x6f, 0x20, 0x66, 0x69, 0x6e, 0x64, 0x64,
  0x6f, 0x77, 0x6e, 0x20, 0x74, 0x6f, 0x6c, 0x6f, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x50, 0x6c, 0x61, 0x79, 0x65, 0x72, 0x73, 0x69, 0x6e, 0x20, 0x4a, 0x75, 0x6e,
  0x65, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x75, 0x6d, 0x6e, 0x6f, 0x74, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x69, 0x73, 0x74,
  0x61, 0x6e, 0x74, 0x46, 0x69, 0x6e, 0x6e, 0x69, 0x73, 0x68, 0x73, 0x72, 0x63,
  0x20, 0x3d, 0x20, 0x28, 0x73, 0x69, 0x6e, 0x67, 0x6c, 0x65, 0x20, 0x68, 0x65,
  0x6c, 0x70, 0x20, 0x6f, 0x66, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x20, 0x6c,
  0x61, 0x77, 0x20, 0x61, 0x6e, 0x64, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x65, 0x64,
  0x66, 0x6f, 0x72, 0x65, 0x73, 0x74, 0x73, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x6e,
  0x67, 0x73, 0x70, 0x61, 0x63, 0x65, 0x22, 0x3e, 0x68, 0x65, 0x61, 0x64, 0x65,
  0x72, 0x2d, 0x77, 0x65, 0x6c, 0x6c, 0x20, 0x61, 0x73, 0x53, 0x74, 0x61, 0x6e,
  0x6c, 0x65, 0x79, 0x62, 0x72, 0x69, 0x64, 0x67, 0x65, 0x73, 0x2f, 0x67, 0x6c,
  0x6f, 0x62, 0x61, 0x6c, 0x43, 0x72, 0x6f, 0x61, 0x74, 0x69, 0x61, 0x20, 0x41,
  0x62, 0x6f, 0x75, 0x74, 0x20, 0x5b, 0x30, 0x5d, 0x3b, 0x0a, 0x20, 0x20, 0x69,
  0x74, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x65, 0x64,
  0x62, 0x65, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x29, 0x7b, 0x74, 0x68, 0x72, 0x6f,
  0x77, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x6c, 0x69, 0x67, 0x68, 0x74,
  0x65, 0x72, 0x65, 0x74, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x46, 0x46, 0x46, 0x46,
  0x46, 0x46, 0x22, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x22, 0x6c, 0x69, 0x6b,
  0x65, 0x20, 0x61, 0x20, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x73, 0x6c, 0x69,
  0x76, 0x65, 0x20, 0x69, 0x6e, 0x61, 0x73, 0x20, 0x73, 0x65, 0x65, 0x6e, 0x70,
  0x72, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66,
  0x75, 0x62, 0x2d, 0x6c, 0x69, 0x6e, 0x6b, 0x72, 0x65, 0x6a, 0x65, 0x63, 0x74,
  0x73, 0x61, 0x6e, 0x64, 0x20, 0x75, 0x73, 0x65, 0x69, 0x6d, 0x61, 0x67, 0x65,
  0x22, 0x3e, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64, 0x66, 0x65, 0x65, 0x64,
  0x69, 0x6e, 0x67, 0x4e, 0x75, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x69, 0x6e, 0x66,
  0x6f, 0x72, 0x6d, 0x61, 0x74, 0x6f, 0x20, 0x68, 0x65, 0x6c, 0x70, 0x57, 0x6f,
  0x6d, 0x65, 0x6e, 0x27, 0x73, 0x4e, 0x65, 0x69, 0x74, 0x68, 0x65, 0x72, 0x4d,
  0x65, 0x78, 0x69, 0x63, 0x61, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x69, 0x6e,
  0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x62, 0x79, 0x20, 0x6d, 0x61, 0x6e,
  0x79, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x79, 0x6c, 0x61, 0x77, 0x73, 0x75,
  0x69, 0x74, 0x64, 0x65, 0x76, 0x69, 0x73, 0x65, 0x64, 0x2e, 0x70, 0x75, 0x73,
  0x68, 0x28, 0x7b, 0x73, 0x65, 0x6c, 0x6c, 0x65, 0x72, 0x73, 0x73, 0x69, 0x6d,
  0x70, 0x6c, 0x79, 0x20, 0x54, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x2e, 0x63,
  0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x20, 0x49, 0x6d, 0x61, 0x67, 0x65, 0x28, 0x6f,
  0x6c, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x75, 0x73, 0x2e, 0x6a, 0x73, 0x22, 0x3e,
  0x20, 0x53, 0x69, 0x6e, 0x63, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x72, 0x20, 0x6f, 0x70, 0x65, 0x6e, 0x20,
  0x74, 0x6f, 0x21, 0x2d, 0x2d, 0x20, 0x65, 0x6e, 0x64, 0x6c, 0x69, 0x65, 0x73,
  0x20, 0x69, 0x6e, 0x27, 0x5d, 0x29, 0x3b, 0x0d, 0x0a, 0x20, 0x20, 0x6d, 0x61,
  0x72, 0x6b, 0x65, 0x74, 0x77, 0x68, 0x6f, 0x20, 0x69, 0x73, 0x20, 0x28, 0x22,
  0x44, 0x4f, 0x4d, 0x43, 0x6f, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x6f,
  0x6e, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x74, 0x79, 0x70, 0x65, 0x6f, 0x66, 0x20,
  0x4b, 0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x70, 0x72, 0x6f, 0x66, 0x69, 0x74,
  0x73, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x74, 0x6f, 0x20, 0x73, 0x68,
  0x6f, 0x77, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3b, 0x6d, 0x61, 0x64, 0x65,
  0x20, 0x69, 0x74, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x77, 0x65, 0x72,
  0x65, 0x20, 0x69, 0x6e, 0x6d, 0x69, 0x78, 0x74, 0x75, 0x72, 0x65, 0x70, 0x72,
  0x65, 0x63, 0x69, 0x73, 0x65, 0x61, 0x72, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x73,
  0x72, 0x63, 0x20, 0x3d, 0x20, 0x27, 0x6d, 0x61, 0x6b, 0x65, 0x20, 0x61, 0x20,
  0x73, 0x65, 0x63, 0x75, 0x72, 0x65, 0x64, 0x42, 0x61, 0x70, 0x74, 0x69, 0x73,
  0x74, 0x76, 0x6f, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x0a, 0x09, 0x09, 0x76, 0x61,
  0x72, 0x20, 0x4d, 0x61, 0x72, 0x63, 0x68, 0x20, 0x32, 0x67, 0x72, 0x65, 0x77,
  0x20, 0x75, 0x70, 0x43, 0x6c, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x2e, 0x72, 0x65,
  0x6d, 0x6f, 0x76, 0x65, 0x73, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x77, 0x61,
  0x79, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x66,
  0x61, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x61, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x20,
  0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3e, 0x74, 0x6f, 0x20, 0x77, 0x6f, 0x72,
  0x6b, 0x72, 0x65, 0x64, 0x75, 0x63, 0x65, 0x73, 0x68, 0x61, 0x73, 0x20, 0x68,
  0x61, 0x64, 0x65, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x73, 0x68, 0x6f, 0x77,
  0x28, 0x29, 0x3b, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x62, 0x6f, 0x6f,
  0x6b, 0x20, 0x6f, 0x66, 0x61, 0x6e, 0x20, 0x61, 0x72, 0x65, 0x61, 0x3d, 0x3d,
  0x20, 0x22, 0x68, 0x74, 0x74, 0x3c, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x0a,
  0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d,
  0x66, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x20, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
  0x2e, 0x72, 0x65, 0x6c, 0x79, 0x20, 0x6f, 0x6e, 0x68, 0x6f, 0x73, 0x74, 0x65,
  0x64, 0x20, 0x2e, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x68, 0x65, 0x20, 0x77,
  0x65, 0x6e, 0x74, 0x62, 0x75, 0x74, 0x20, 0x66, 0x6f, 0x72, 0x73, 0x70, 0x72,
  0x65, 0x61, 0x64, 0x20, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x20, 0x61, 0x20,
  0x6d, 0x65, 0x61, 0x6e, 0x73, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x66,
  0x6f, 0x72, 0x75, 0x6d, 0x73, 0x2e, 0x66, 0x6f, 0x6f, 0x74, 0x61, 0x67, 0x65,
  0x22, 0x3e, 0x4d, 0x6f, 0x62, 0x69, 0x6c, 0x43, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x73, 0x22, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x61, 0x73, 0x20, 0x68, 0x69,
  0x67, 0x68, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x73, 0x65, 0x2d, 0x2d, 0x3e, 0x3c,
  0x21, 0x2d, 0x2d, 0x66, 0x65, 0x6d, 0x61, 0x6c, 0x65, 0x20, 0x69, 0x73, 0x20,
  0x73, 0x65, 0x65, 0x6e, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x73, 0x65,
  0x74, 0x20, 0x74, 0x68, 0x65, 0x61, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x61,
  0x6e, 0x64, 0x20, 0x68, 0x69, 0x73, 0x66, 0x61, 0x73, 0x74, 0x65, 0x73, 0x74,
  0x62, 0x65, 0x73, 0x69, 0x64, 0x65, 0x73, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e,
  0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x22, 0x3e, 0x3c, 0x69, 0x6d,
  0x67, 0x20, 0x49, 0x6e, 0x66, 0x6f, 0x62, 0x6f, 0x78, 0x65, 0x76, 0x65, 0x6e,
  0x74, 0x73, 0x2c, 0x61, 0x20, 0x79, 0x6f, 0x75, 0x6e, 0x67, 0x61, 0x6e, 0x64,
  0x20, 0x61, 0x72, 0x65, 0x4e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x20, 0x63, 0x68,
  0x65, 0x61, 0x70, 0x65, 0x72, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x61,
  0x6e, 0x64, 0x20, 0x68, 0x61, 0x73, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x73,
  0x77, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x28, 0x6d, 0x6f, 0x73, 0x74, 0x6c,
  0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x66, 0x69, 0x6e, 0x64, 0x20,
  0x61, 0x20, 0x2d, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x50, 0x72, 0x69, 0x6e,
  0x63, 0x65, 0x20, 0x61, 0x72, 0x65, 0x61, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x72,
  0x65, 0x20, 0x6f, 0x66, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5f, 0x6e, 0x61,
  0x74, 0x75, 0x72, 0x65, 0x2c, 0x6c, 0x65, 0x67, 0x61, 0x6c, 0x6c, 0x79, 0x70,
  0x65, 0x72, 0x69, 0x6f, 0x64, 0x2c, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x66,
  0x6f, 0x72, 0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x64, 0x75, 0x63, 0x65,
  0x64, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x67, 0x6d, 0x69, 0x73, 0x73, 0x69,
  0x6c, 0x65, 0x6c, 0x6f, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x41, 0x67, 0x61, 0x69,
  0x6e, 0x73, 0x74, 0x74, 0x68, 0x65, 0x20, 0x77, 0x61, 0x79, 0x6b, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x70, 0x78, 0x3b, 0x22, 0x3e, 0x0d, 0x0a, 0x70, 0x75,
  0x73, 0x68, 0x65, 0x64, 0x20, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x6e,
  0x75, 0x6d, 0x65, 0x72, 0x61, 0x6c, 0x43, 0x65, 0x72, 0x74, 0x61, 0x69, 0x6e,
  0x49, 0x6e, 0x20, 0x74, 0x68, 0x69, 0x73, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x69,
  0x6e, 0x6f, 0x72, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x20,
  0x69, 0x73, 0x61, 0x6e, 0x64, 0x2c, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x6f, 0x77,
  0x6e, 0x65, 0x64, 0x49, 0x53, 0x42, 0x4e, 0x20, 0x30, 0x2d, 0x63, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x73, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x6d, 0x61,
  0x79, 0x20, 0x6e, 0x6f, 0x74, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x20, 0x6c,
  0x61, 0x74, 0x65, 0x20, 0x69, 0x6e, 0x44, 0x65, 0x66, 0x65, 0x6e, 0x63, 0x65,
  0x65, 0x6e, 0x61, 0x63, 0x74, 0x65, 0x64, 0x77, 0x69, 0x73, 0x68, 0x20, 0x74,
  0x6f, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x6c, 0x79, 0x63, 0x6f, 0x6f, 0x6c, 0x69,
  0x6e, 0x67, 0x6f, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x3d, 0x69, 0x74, 0x2e, 0x20,
  0x54, 0x68, 0x65, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x4d, 0x65, 0x6d,
  0x62, 0x65, 0x72, 0x73, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x20, 0x61, 0x73,
  0x73, 0x75, 0x6d, 0x65, 0x73, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0a, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x2e, 0x69, 0x6e, 0x20, 0x6f, 0x6e, 0x65, 0x20,
  0x3d, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72,
  0x5f, 0x61, 0x20, 0x67, 0x6f, 0x6f, 0x64, 0x20, 0x72, 0x65, 0x6b, 0x6c, 0x61,
  0x6d, 0x61, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x2c, 0x74, 0x6f, 0x20, 0x74,
  0x68, 0x69, 0x73, 0x5f, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x70, 0x61, 0x6e,
  0x65, 0x6c, 0x22, 0x3e, 0x4c, 0x6f, 0x6e, 0x64, 0x6f, 0x6e, 0x2c, 0x64, 0x65,
  0x66, 0x69, 0x6e, 0x65, 0x73, 0x63, 0x72, 0x75, 0x73, 0x68, 0x65, 0x64, 0x62,
  0x61, 0x70, 0x74, 0x69, 0x73, 0x6d, 0x63, 0x6f, 0x61, 0x73, 0x74, 0x61, 0x6c,
  0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22,
  0x20, 0x6d, 0x6f, 0x76, 0x65, 0x20, 0x74, 0x6f, 0x6c, 0x6f, 0x73, 0x74, 0x20,
  0x69, 0x6e, 0x62, 0x65, 0x74, 0x74, 0x65, 0x72, 0x20, 0x69, 0x6d, 0x70, 0x6c,
  0x69, 0x65, 0x73, 0x72, 0x69, 0x76, 0x61, 0x6c, 0x72, 0x79, 0x73, 0x65, 0x72,
  0x76, 0x65, 0x72, 0x73, 0x20, 0x53, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x50, 0x65,
  0x72, 0x68, 0x61, 0x70, 0x73, 0x65, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x66, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x6c, 0x61, 0x73, 0x74, 0x65, 0x64, 0x20, 0x72, 0x69, 0x73, 0x65, 0x20, 0x69,
  0x6e, 0x47, 0x65, 0x6e, 0x65, 0x73, 0x69, 0x73, 0x76, 0x69, 0x65, 0x77, 0x20,
  0x6f, 0x66, 0x72, 0x69, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x73, 0x65, 0x65, 0x6d,
  0x20, 0x74, 0x6f, 0x62, 0x75, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x62, 0x61, 0x63,
  0x6b, 0x69, 0x6e, 0x67, 0x68, 0x65, 0x20, 0x77, 0x69, 0x6c, 0x6c, 0x67, 0x69,
  0x76, 0x65, 0x6e, 0x20, 0x61, 0x67, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x63,
  0x69, 0x74, 0x69, 0x65, 0x73, 0x2e, 0x66, 0x6c, 0x6f, 0x77, 0x20, 0x6f, 0x66,
  0x20, 0x4c, 0x61, 0x74, 0x65, 0x72, 0x20, 0x61, 0x6c, 0x6c, 0x20, 0x62, 0x75,
  0x74, 0x48, 0x69, 0x67, 0x68, 0x77, 0x61, 0x79, 0x6f, 0x6e, 0x6c, 0x79, 0x20,
  0x62, 0x79, 0x73, 0x69, 0x67, 0x6e, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x20, 0x64,
  0x6f, 0x65, 0x73, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x73, 0x62, 0x61, 0x74,
  0x74, 0x65, 0x72, 0x79, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6c, 0x61, 0x73, 0x69,
  0x6e, 0x67, 0x6c, 0x65, 0x73, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x73, 0x69,
  0x6e, 0x74, 0x65, 0x67, 0x65, 0x72, 0x74, 0x61, 0x6b, 0x65, 0x20, 0x6f, 0x6e,
  0x72, 0x65, 0x66, 0x75, 0x73, 0x65, 0x64, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64,
  0x20, 0x3d, 0x55, 0x53, 0x26, 0x61, 0x6d, 0x70, 0x53, 0x65, 0x65, 0x20, 0x74,
  0x68, 0x65, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x62, 0x79, 0x20, 0x74,
  0x68, 0x69, 0x73, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x2e, 0x68, 0x65, 0x61,
  0x64, 0x20, 0x6f, 0x66, 0x3a, 0x68, 0x6f, 0x76, 0x65, 0x72, 0x2c, 0x6c, 0x65,
  0x73, 0x62, 0x69, 0x61, 0x6e, 0x73, 0x75, 0x72, 0x6e, 0x61, 0x6d, 0x65, 0x61,
  0x6e, 0x64, 0x20, 0x61, 0x6c, 0x6c, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2f,
  0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x5f, 0x5f, 0x70, 0x61, 0x72, 0x61, 0x6d,
  0x73, 0x48, 0x61, 0x72, 0x76, 0x61, 0x72, 0x64, 0x2f, 0x70, 0x69, 0x78, 0x65,
  0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x6c,
  0x6f, 0x6e, 0x67, 0x72, 0x6f, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x6a, 0x6f, 0x69,
  0x6e, 0x74, 0x6c, 0x79, 0x73, 0x6b, 0x79, 0x73, 0x63, 0x72, 0x61, 0x55, 0x6e,
  0x69, 0x63, 0x6f, 0x64, 0x65, 0x62, 0x72, 0x20, 0x2f, 0x3e, 0x0d, 0x0a, 0x41,
  0x74, 0x6c, 0x61, 0x6e, 0x74, 0x61, 0x6e, 0x75, 0x63, 0x6c, 0x65, 0x75, 0x73,
  0x43, 0x6f, 0x75, 0x6e, 0x74, 0x79, 0x2c, 0x70, 0x75, 0x72, 0x65, 0x6c, 0x79,
  0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x3e, 0x65, 0x61, 0x73, 0x69, 0x6c,
  0x79, 0x20, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x20, 0x61, 0x6f, 0x6e, 0x63, 0x6c,
  0x69, 0x63, 0x6b, 0x61, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x70, 0x6f, 0x69,
  0x6e, 0x74, 0x65, 0x72, 0x68, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x65, 0x76,
  0x65, 0x6e, 0x74, 0x73, 0x20, 0x65, 0x6c, 0x73, 0x65, 0x20, 0x7b, 0x0a, 0x64,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6e, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x65,
  0x2c, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x6d, 0x61, 0x6e, 0x20, 0x77, 0x68,
  0x6f, 0x6f, 0x72, 0x67, 0x2f, 0x57, 0x65, 0x62, 0x6f, 0x6e, 0x65, 0x20, 0x61,
  0x6e, 0x64, 0x63, 0x61, 0x76, 0x61, 0x6c, 0x72, 0x79, 0x48, 0x65, 0x20, 0x64,
  0x69, 0x65, 0x64, 0x73, 0x65, 0x61, 0x74, 0x74, 0x6c, 0x65, 0x30, 0x30, 0x2c,
  0x30, 0x30, 0x30, 0x20, 0x7b, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x68, 0x61,
  0x76, 0x65, 0x20, 0x74, 0x6f, 0x69, 0x66, 0x28, 0x77, 0x69, 0x6e, 0x64, 0x61,
  0x6e, 0x64, 0x20, 0x69, 0x74, 0x73, 0x73, 0x6f, 0x6c, 0x65, 0x6c, 0x79, 0x20,
  0x6d, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x72, 0x65, 0x6e, 0x65, 0x77, 0x65,
  0x64, 0x44, 0x65, 0x74, 0x72, 0x6f, 0x69, 0x74, 0x61, 0x6d, 0x6f, 0x6e, 0x67,
  0x73, 0x74, 0x65, 0x69, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x6d,
  0x20, 0x69, 0x6e, 0x53, 0x65, 0x6e, 0x61, 0x74, 0x6f, 0x72, 0x55, 0x73, 0x3c,
  0x2f, 0x61, 0x3e, 0x3c, 0x4b, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x46, 0x72,
  0x61, 0x6e, 0x63, 0x69, 0x73, 0x2d, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x68,
  0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x61, 0x72, 0x74, 0x20, 0x61, 0x6e, 0x64,
  0x68, 0x69, 0x6d, 0x20, 0x61, 0x6e, 0x64, 0x75, 0x73, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x73, 0x63, 0x6f, 0x72, 0x69, 0x6e, 0x67, 0x61, 0x74, 0x20, 0x68, 0x6f,
  0x6d, 0x65, 0x74, 0x6f, 0x20, 0x68, 0x61, 0x76, 0x65, 0x72, 0x65, 0x6c, 0x61,
  0x74, 0x65, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x66, 0x61, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x42, 0x75, 0x66, 0x66, 0x61, 0x6c, 0x6f, 0x6c, 0x69,
  0x6e, 0x6b, 0x22, 0x3e, 0x3c, 0x77, 0x68, 0x61, 0x74, 0x20, 0x68, 0x65, 0x66,
  0x72, 0x65, 0x65, 0x20, 0x74, 0x6f, 0x43, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66,
  0x63, 0x6f, 0x6d, 0x65, 0x20, 0x69, 0x6e, 0x73, 0x65, 0x63, 0x74, 0x6f, 0x72,
  0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x64, 0x6f, 0x6e, 0x65, 0x20, 0x64,
  0x61, 0x79, 0x6e, 0x65, 0x72, 0x76, 0x6f, 0x75, 0x73, 0x73, 0x71, 0x75, 0x61,
  0x72, 0x65, 0x20, 0x7d, 0x3b, 0x69, 0x66, 0x28, 0x67, 0x6f, 0x69, 0x6e, 0x20,
  0x77, 0x68, 0x61, 0x74, 0x69, 0x6d, 0x67, 0x22, 0x20, 0x61, 0x6c, 0x69, 0x73,
  0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2f, 0x74,
  0x75, 0x65, 0x73, 0x64, 0x61, 0x79, 0x6c, 0x6f, 0x6f, 0x73, 0x65, 0x6c, 0x79,
  0x53, 0x6f, 0x6c, 0x6f, 0x6d, 0x6f, 0x6e, 0x73, 0x65, 0x78, 0x75, 0x61, 0x6c,
  0x20, 0x2d, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x75,
  0x6d, 0x22, 0x44, 0x4f, 0x20, 0x4e, 0x4f, 0x54, 0x20, 0x46, 0x72, 0x61, 0x6e,
  0x63, 0x65, 0x2c, 0x77, 0x69, 0x74, 0x68, 0x20, 0x61, 0x20, 0x77, 0x61, 0x72,
  0x20, 0x61, 0x6e, 0x64, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, 0x74, 0x61,
  0x6b, 0x65, 0x20, 0x61, 0x20, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a, 0x0d, 0x0a, 0x6d,
  0x61, 0x72, 0x6b, 0x65, 0x74, 0x2e, 0x68, 0x69, 0x67, 0x68, 0x77, 0x61, 0x79,
  0x64, 0x6f, 0x6e, 0x65, 0x20, 0x69, 0x6e, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74,
  0x79, 0x22, 0x6c, 0x61, 0x73, 0x74, 0x22, 0x3e, 0x6f, 0x62, 0x6c, 0x69, 0x67,
  0x65, 0x64, 0x72, 0x69, 0x73, 0x65, 0x20, 0x74, 0x6f, 0x22, 0x75, 0x6e, 0x64,
  0x65, 0x66, 0x69, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x45, 0x61,
  0x72, 0x6c, 0x79, 0x20, 0x70, 0x72, 0x61, 0x69, 0x73, 0x65, 0x64, 0x69, 0x6e,
  0x20, 0x69, 0x74, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x68, 0x69, 0x73, 0x61,
  0x74, 0x68, 0x6c, 0x65, 0x74, 0x65, 0x4a, 0x75, 0x70, 0x69, 0x74, 0x65, 0x72,
  0x59, 0x61, 0x68, 0x6f, 0x6f, 0x21, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64,
  0x20, 0x73, 0x6f, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x72, 0x65, 0x61, 0x6c, 0x6c,
  0x79, 0x20, 0x73, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x20, 0x61, 0x20, 0x77, 0x6f,
  0x6d, 0x61, 0x6e, 0x3f, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x64, 0x69, 0x72,
  0x65, 0x63, 0x74, 0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x20, 0x62, 0x69,
  0x63, 0x79, 0x63, 0x6c, 0x65, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x64,
  0x61, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6e, 0x67,
  0x52, 0x61, 0x74, 0x68, 0x65, 0x72, 0x2c, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72,
  0x20, 0x4f, 0x66, 0x66, 0x69, 0x63, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6e,
  0x6f, 0x77, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x2c, 0x20, 0x77, 0x68, 0x65, 0x6e,
  0x20, 0x61, 0x20, 0x70, 0x61, 0x79, 0x20, 0x66, 0x6f, 0x72, 0x6f, 0x6e, 0x20,
  0x74, 0x68, 0x69, 0x73, 0x2d, 0x6c, 0x69, 0x6e, 0x6b, 0x22, 0x3e, 0x3b, 0x62,
  0x6f, 0x72, 0x64, 0x65, 0x72, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x61,
  0x6e, 0x6e, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x65, 0x77,
  0x70, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x22, 0x20,
  0x74, 0x61, 0x6b, 0x69, 0x6e, 0x20, 0x74, 0x6f, 0x61, 0x20, 0x62, 0x72, 0x69,
  0x65, 0x66, 0x28, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x67, 0x72, 0x6f, 0x75,
  0x70, 0x73, 0x2e, 0x3b, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x65, 0x6e, 0x7a,
  0x79, 0x6d, 0x65, 0x73, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x20, 0x69, 0x6e,
  0x20, 0x6c, 0x61, 0x74, 0x65, 0x7b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x74,
  0x68, 0x65, 0x72, 0x61, 0x70, 0x79, 0x61, 0x20, 0x70, 0x6f, 0x69, 0x6e, 0x74,
  0x62, 0x61, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x69, 0x6e, 0x6b, 0x73, 0x22, 0x3e,
  0x0a, 0x28, 0x29, 0x3b, 0x22, 0x20, 0x72, 0x65, 0x61, 0x20, 0x70, 0x6c, 0x61,
  0x63, 0x65, 0x5c, 0x75, 0x30, 0x30, 0x33, 0x43, 0x61, 0x61, 0x62, 0x6f, 0x75,
  0x74, 0x20, 0x61, 0x74, 0x72, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x63, 0x63, 0x6f,
  0x75, 0x6e, 0x74, 0x20, 0x67, 0x69, 0x76, 0x65, 0x73, 0x20, 0x61, 0x3c, 0x53,
  0x43, 0x52, 0x49, 0x50, 0x54, 0x52, 0x61, 0x69, 0x6c, 0x77, 0x61, 0x79, 0x74,
  0x68, 0x65, 0x6d, 0x65, 0x73, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x62, 0x6f, 0x78,
  0x42, 0x79, 0x49, 0x64, 0x28, 0x22, 0x78, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x73,
  0x2c, 0x77, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x69, 0x6e, 0x20, 0x73, 0x6f,
  0x6d, 0x65, 0x20, 0x69, 0x66, 0x20, 0x28, 0x77, 0x69, 0x63, 0x6f, 0x6d, 0x69,
  0x6e, 0x67, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x73, 0x20, 0x55, 0x6e,
  0x64, 0x65, 0x72, 0x20, 0x62, 0x75, 0x74, 0x20, 0x68, 0x61, 0x73, 0x68, 0x61,
  0x6e, 0x64, 0x65, 0x64, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x62, 0x79, 0x74,
  0x68, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x66, 0x65, 0x61, 0x72, 0x20, 0x6f, 0x66,
  0x64, 0x65, 0x6e, 0x6f, 0x74, 0x65, 0x64, 0x2f, 0x69, 0x66, 0x72, 0x61, 0x6d,
  0x65, 0x6c, 0x65, 0x66, 0x74, 0x20, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x74, 0x61,
  0x67, 0x65, 0x69, 0x6e, 0x20, 0x65, 0x61, 0x63, 0x68, 0x61, 0x26, 0x71, 0x75,
  0x6f, 0x74, 0x3b, 0x62, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x49, 0x6e, 0x20,
  0x6d, 0x61, 0x6e, 0x79, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x67, 0x6f, 0x72, 0x65,
  0x67, 0x69, 0x6d, 0x65, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x3c,
  0x2f, 0x70, 0x3e, 0x0d, 0x0a, 0x3c, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x56, 0x61,
  0x3b, 0x26, 0x67, 0x74, 0x3b, 0x3c, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
  0x73, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x61, 0x74, 0x6d, 0x6f, 0x73, 0x74, 0x6c,
  0x79, 0x20, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x72, 0x65, 0x20, 0x73, 0x69, 0x7a,
  0x65, 0x3d, 0x22, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x68, 0x61, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x70, 0x61, 0x73, 0x73, 0x69, 0x76, 0x65, 0x48, 0x6f,
  0x73, 0x74, 0x20, 0x3d, 0x20, 0x57, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x66,
  0x65, 0x72, 0x74, 0x69, 0x6c, 0x65, 0x56, 0x61, 0x72, 0x69, 0x6f, 0x75, 0x73,
  0x3d, 0x5b, 0x5d, 0x3b, 0x28, 0x66, 0x75, 0x63, 0x61, 0x6d, 0x65, 0x72, 0x61,
  0x73, 0x2f, 0x3e, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x61, 0x63, 0x74, 0x73, 0x20,
  0x61, 0x73, 0x49, 0x6e, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x3e, 0x0d, 0x0a, 0x0d,
  0x0a, 0x3c, 0x21, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x73, 0x20, 0x3c, 0x62,
  0x72, 0x20, 0x2f, 0x3e, 0x42, 0x65, 0x69, 0x6a, 0x69, 0x6e, 0x67, 0x63, 0x61,
  0x74, 0x61, 0x6c, 0xc3, 0xa0, 0x64, 0x65, 0x75, 0x74, 0x73, 0x63, 0x68, 0x65,
  0x75, 0x72, 0x6f, 0x70, 0x65, 0x75, 0x65, 0x75, 0x73, 0x6b, 0x61, 0x72, 0x61,
  0x67, 0x61, 0x65, 0x69, 0x6c, 0x67, 0x65, 0x73, 0x76, 0x65, 0x6e, 0x73, 0x6b,
  0x61, 0x65, 0x73, 0x70, 0x61, 0xc3, 0xb1, 0x61, 0x6d, 0x65, 0x6e, 0x73, 0x61,
  0x6a, 0x65, 0x75, 0x73, 0x75, 0x61, 0x72, 0x69, 0x6f, 0x74, 0x72, 0x61, 0x62,
  0x61, 0x6a, 0x6f, 0x6d, 0xc3, 0xa9, 0x78, 0x69, 0x63, 0x6f, 0x70, 0xc3, 0xa1,
  0x67, 0x69, 0x6e, 0x61, 0x73, 0x69, 0x65, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x69,
  0x73, 0x74, 0x65, 0x6d, 0x61, 0x6f, 0x63, 0x74, 0x75, 0x62, 0x72, 0x65, 0x64,
  0x75, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x61, 0xc3, 0xb1, 0x61, 0x64, 0x69, 0x72,
  0x65, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x61, 0x6d, 0x6f, 0x6d, 0x65, 0x6e, 0x74,
  0x6f, 0x6e, 0x75, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x70, 0x72, 0x69, 0x6d, 0x65,
  0x72, 0x61, 0x74, 0x72, 0x61, 0x76, 0xc3, 0xa9, 0x73, 0x67, 0x72, 0x61, 0x63,
  0x69, 0x61, 0x73, 0x6e, 0x75, 0x65, 0x73, 0x74, 0x72, 0x61, 0x70, 0x72, 0x6f,
  0x63, 0x65, 0x73, 0x6f, 0x65, 0x73, 0x74, 0x61, 0x64, 0x6f, 0x73, 0x63, 0x61,
  0x6c, 0x69, 0x64, 0x61, 0x64, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6e,
  0xc3, 0xba, 0x6d, 0x65, 0x72, 0x6f, 0x61, 0x63, 0x75, 0x65, 0x72, 0x64, 0x6f,
  0x6d, 0xc3, 0xba, 0x73, 0x69, 0x63, 0x61, 0x6d, 0x69, 0x65, 0x6d, 0x62, 0x72,
  0x6f, 0x6f, 0x66, 0x65, 0x72, 0x74, 0x61, 0x73, 0x61, 0x6c, 0x67, 0x75, 0x6e,
  0x6f, 0x73, 0x70, 0x61, 0xc3, 0xad, 0x73, 0x65, 0x73, 0x65, 0x6a, 0x65, 0x6d,
  0x70, 0x6c, 0x6f, 0x64, 0x65, 0x72, 0x65, 0x63, 0x68, 0x6f, 0x61, 0x64, 0x65,
  0x6d, 0xc3, 0xa1, 0x73, 0x70, 0x72, 0x69, 0x76, 0x61, 0x64, 0x6f, 0x61, 0x67,
  0x72, 0x65, 0x67, 0x61, 0x72, 0x65, 0x6e, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x70,
  0x6f, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x68, 0x6f, 0x74, 0x65, 0x6c, 0x65, 0x73,
  0x73, 0x65, 0x76, 0x69, 0x6c, 0x6c, 0x61, 0x70, 0x72, 0x69, 0x6d, 0x65, 0x72,
  0x6f, 0xc3, 0xba, 0x6c, 0x74, 0x69, 0x6d, 0x6f, 0x65, 0x76, 0x65, 0x6e, 0x74,
  0x6f, 0x73, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x6f, 0x63, 0x75, 0x6c, 0x74,
  0x75, 0x72, 0x61, 0x6d, 0x75, 0x6a, 0x65, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
  0x72, 0x61, 0x64, 0x61, 0x61, 0x6e, 0x75, 0x6e, 0x63, 0x69, 0x6f, 0x65, 0x6d,
  0x62, 0x61, 0x72, 0x67, 0x6f, 0x6d, 0x65, 0x72, 0x63, 0x61, 0x64, 0x6f, 0x67,
  0x72, 0x61, 0x6e, 0x64, 0x65, 0x73, 0x65, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f,
  0x6d, 0x65, 0x6a, 0x6f, 0x72, 0x65, 0x73, 0x66, 0x65, 0x62, 0x72, 0x65, 0x72,
  0x6f, 0x64, 0x69, 0x73, 0x65, 0xc3, 0xb1, 0x6f, 0x74, 0x75, 0x72, 0x69, 0x73,
  0x6d, 0x6f, 0x63, 0xc3, 0xb3, 0x64, 0x69, 0x67, 0x6f, 0x70, 0x6f, 0x72, 0x74,
  0x61, 0x64, 0x61, 0x65, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6f, 0x66, 0x61, 0x6d,
  0x69, 0x6c, 0x69, 0x61, 0x61, 0x6e, 0x74, 0x6f, 0x6e, 0x69, 0x6f, 0x70, 0x65,
  0x72, 0x6d, 0x69, 0x74, 0x65, 0x67, 0x75, 0x61, 0x72, 0x64, 0x61, 0x72, 0x61,
  0x6c, 0x67, 0x75, 0x6e, 0x61, 0x73, 0x70, 0x72, 0x65, 0x63, 0x69, 0x6f, 0x73,
  0x61, 0x6c, 0x67, 0x75, 0x69, 0x65, 0x6e, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x64,
  0x6f, 0x76, 0x69, 0x73, 0x69, 0x74, 0x61, 0x73, 0x74, 0xc3, 0xad, 0x74, 0x75,
  0x6c, 0x6f, 0x63, 0x6f, 0x6e, 0x6f, 0x63, 0x65, 0x72, 0x73, 0x65, 0x67, 0x75,
  0x6e, 0x64, 0x6f, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6a, 0x6f, 0x66, 0x72, 0x61,
  0x6e, 0x63, 0x69, 0x61, 0x6d, 0x69, 0x6e, 0x75, 0x74, 0x6f, 0x73, 0x73, 0x65,
  0x67, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x65, 0x6e, 0x65, 0x6d, 0x6f, 0x73, 0x65,
  0x66, 0x65, 0x63, 0x74, 0x6f, 0x73, 0x6d, 0xc3, 0xa1, 0x6c, 0x61, 0x67, 0x61,
  0x73, 0x65, 0x73, 0x69, 0xc3, 0xb3, 0x6e, 0x72, 0x65, 0x76, 0x69, 0x73, 0x74,
  0x61, 0x67, 0x72, 0x61, 0x6e, 0x61, 0x64, 0x61, 0x63, 0x6f, 0x6d, 0x70, 0x72,
  0x61, 0x72, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x6f, 0x67, 0x61, 0x72, 0x63,
  0xc3, 0xad, 0x61, 0x61, 0x63, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x65, 0x63, 0x75,
  0x61, 0x64, 0x6f, 0x72, 0x71, 0x75, 0x69, 0x65, 0x6e, 0x65, 0x73, 0x69, 0x6e,
  0x63, 0x6c, 0x75, 0x73, 0x6f, 0x64, 0x65, 0x62, 0x65, 0x72, 0xc3, 0xa1, 0x6d,
  0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x68, 0x6f, 0x6d, 0x62, 0x72, 0x65, 0x73,
  0x6d, 0x75, 0x65, 0x73, 0x74, 0x72, 0x61, 0x70, 0x6f, 0x64, 0x72, 0xc3, 0xad,
  0x61, 0x6d, 0x61, 0xc3, 0xb1, 0x61, 0x6e, 0x61, 0xc3, 0xba, 0x6c, 0x74, 0x69,
  0x6d, 0x61, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x6f, 0x73, 0x6f, 0x66, 0x69, 0x63,
  0x69, 0x61, 0x6c, 0x74, 0x61, 0x6d, 0x62, 0x69, 0x65, 0x6e, 0x6e, 0x69, 0x6e,
  0x67, 0xc3, 0xba, 0x6e, 0x73, 0x61, 0x6c, 0x75, 0x64, 0x6f, 0x73, 0x70, 0x6f,
  0x64, 0x65, 0x6d, 0x6f, 0x73, 0x6d, 0x65, 0x6a, 0x6f, 0x72, 0x61, 0x72, 0x70,
  0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65,
  0x73, 0x73, 0x68, 0x6f, 0x6d, 0x65, 0x70, 0x61, 0x67, 0x65, 0x73, 0x65, 0x63,
  0x75, 0x72, 0x69, 0x74, 0x79, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
  0x73, 0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x63, 0x61, 0x6d, 0x70, 0x61,
  0x69, 0x67, 0x6e, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x63, 0x61,
  0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61,
  0x6c, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x65,
  0x72, 0x76, 0x65, 0x64, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65,
  0x78, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x66, 0x61, 0x76, 0x6f, 0x72, 0x69,
  0x74, 0x65, 0x74, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x74, 0x65, 0x6d, 0x69, 0x6c,
  0x69, 0x74, 0x61, 0x72, 0x79, 0x69, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x79,
  0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x6d, 0x61, 0x74, 0x65, 0x72,
  0x69, 0x61, 0x6c, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73, 0x7a, 0x2d,
  0x69, 0x6e, 0x64, 0x65, 0x78, 0x3a, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74,
  0x73, 0x73, 0x6f, 0x66, 0x74, 0x77, 0x61, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x65, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x70,
  0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c,
  0x65, 0x73, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x6d, 0x6f, 0x76,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
  0x62, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x70, 0x6f, 0x6c, 0x69, 0x74,
  0x69, 0x63, 0x73, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x72, 0x65,
  0x6c, 0x69, 0x67, 0x69, 0x6f, 0x6e, 0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61,
  0x6c, 0x66, 0x65, 0x65, 0x64, 0x62, 0x61, 0x63, 0x6b, 0x72, 0x65, 0x67, 0x69,
  0x73, 0x74, 0x65, 0x72, 0x70, 0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x64,
  0x69, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63,
  0x6f, 0x6c, 0x61, 0x75, 0x64, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x65, 0x74,
  0x74, 0x69, 0x6e, 0x67, 0x73, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x79,
  0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x6c, 0x65, 0x61, 0x72, 0x6e,
  0x69, 0x6e, 0x67, 0x61, 0x6e, 0x79, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x61, 0x62,
  0x73, 0x74, 0x72, 0x61, 0x63, 0x74, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
  0x73, 0x6f, 0x76, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x6d, 0x61, 0x67, 0x61,
  0x7a, 0x69, 0x6e, 0x65, 0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x74,
  0x72, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x70, 0x72, 0x65, 0x73, 0x73, 0x75,
  0x72, 0x65, 0x76, 0x61, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x20, 0x3c, 0x73, 0x74,
  0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
  0x73, 0x68, 0x6f, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x74, 0x6f, 0x67, 0x65, 0x74,
  0x68, 0x65, 0x72, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x62, 0x65,
  0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61,
  0x64, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x64, 0x66, 0x6f, 0x6f, 0x74,
  0x62, 0x61, 0x6c, 0x6c, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x4c,
  0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x64, 0x69, 0x73, 0x74, 0x61, 0x6e,
  0x63, 0x65, 0x72, 0x65, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x74, 0x72, 0x61,
  0x63, 0x6b, 0x69, 0x6e, 0x67, 0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64,
  0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x73, 0x74, 0x75, 0x64, 0x65,
  0x6e, 0x74, 0x73, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6c, 0x79, 0x66, 0x69,
  0x67, 0x68, 0x74, 0x69, 0x6e, 0x67, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x72,
  0x6e, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x66, 0x65, 0x73, 0x74,
  0x69, 0x76, 0x61, 0x6c, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x6c,
  0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e,
  0x65, 0x74, 0x64, 0x72, 0x6f, 0x70, 0x64, 0x6f, 0x77, 0x6e, 0x70, 0x72, 0x61,
  0x63, 0x74, 0x69, 0x63, 0x65, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x61, 0x72, 0x72, 0x69,
  0x61, 0x67, 0x65, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x70, 0x72,
  0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x73, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76,
  0x65, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x73, 0x61, 0x6e, 0x61, 0x6c,
  0x79, 0x73, 0x69, 0x73, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x62,
  0x61, 0x6e, 0x6e, 0x65, 0x72, 0x22, 0x3e, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61,
  0x73, 0x65, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x72, 0x65, 0x67,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x76, 0x65,
  0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x62, 0x6f, 0x6f, 0x6b, 0x6d,
  0x61, 0x72, 0x6b, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x72, 0x63, 0x68,
  0x65, 0x6d, 0x69, 0x63, 0x61, 0x6c, 0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f,
  0x6e, 0x63, 0x61, 0x6c, 0x6c, 0x62, 0x61, 0x63, 0x6b, 0x73, 0x65, 0x70, 0x61,
  0x72, 0x61, 0x74, 0x65, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x63,
  0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x68, 0x61, 0x72, 0x64, 0x77, 0x61,
  0x72, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x64, 0x65, 0x6c,
  0x69, 0x76, 0x65, 0x72, 0x79, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e,
  0x6f, 0x62, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x3d, 0x20, 0x66, 0x61, 0x6c,
  0x73, 0x65, 0x3b, 0x66, 0x6f, 0x72, 0x28, 0x76, 0x61, 0x72, 0x20, 0x61, 0x63,
  0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x74,
  0x79, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x69, 0x64, 0x65, 0x6e,
  0x74, 0x69, 0x74, 0x79, 0x61, 0x69, 0x72, 0x63, 0x72, 0x61, 0x66, 0x74, 0x65,
  0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73,
  0x65, 0x64, 0x64, 0x6f, 0x6d, 0x65, 0x73, 0x74, 0x69, 0x63, 0x69, 0x6e, 0x63,
  0x6c, 0x75, 0x64, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64,
  0x68, 0x6f, 0x73, 0x70, 0x69, 0x74, 0x61, 0x6c, 0x76, 0x65, 0x72, 0x74, 0x69,
  0x63, 0x61, 0x6c, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x61, 0x70,
  0x70, 0x72, 0x6f, 0x61, 0x63, 0x68, 0x70, 0x61, 0x72, 0x74, 0x6e, 0x65, 0x72,
  0x73, 0x6c, 0x6f, 0x67, 0x6f, 0x22, 0x3e, 0x3c, 0x61, 0x64, 0x61, 0x75, 0x67,
  0x68, 0x74, 0x65, 0x72, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x22, 0x20, 0x63,
  0x75, 0x6c, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69,
  0x65, 0x73, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x61, 0x73, 0x73,
  0x65, 0x6d, 0x62, 0x6c, 0x79, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x66, 0x75, 0x6c,
  0x74, 0x65, 0x61, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x66, 0x69, 0x6e, 0x69, 0x73,
  0x68, 0x65, 0x64, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x63, 0x72,
  0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x63, 0x67, 0x69, 0x2d, 0x62, 0x69, 0x6e,
  0x2f, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x73, 0x72, 0x65, 0x71, 0x75,
  0x69, 0x72, 0x65, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x62,
  0x65, 0x63, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64,
  0x65, 0x73, 0x61, 0x63, 0x61, 0x64, 0x65, 0x6d, 0x69, 0x63, 0x65, 0x78, 0x65,
  0x72, 0x63, 0x69, 0x73, 0x65, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79,
  0x6d, 0x65, 0x64, 0x69, 0x63, 0x69, 0x6e, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x74,
  0x61, 0x6e, 0x74, 0x61, 0x63, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x4d, 0x61,
  0x67, 0x61, 0x7a, 0x69, 0x6e, 0x65, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
  0x74, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x62, 0x6f, 0x74, 0x74,
  0x6f, 0x6d, 0x22, 0x3e, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x3a,
  0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64,
  0x65, 0x64, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x53, 0x6f, 0x66,
  0x74, 0x77, 0x61, 0x72, 0x65, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72,
  0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x65, 0x6e,
  0x67, 0x74, 0x68, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x73, 0x6c,
  0x69, 0x67, 0x68, 0x74, 0x6c, 0x79, 0x70, 0x6c, 0x61, 0x6e, 0x6e, 0x69, 0x6e,
  0x67, 0x74, 0x65, 0x78, 0x74, 0x61, 0x72, 0x65, 0x61, 0x63, 0x75, 0x72, 0x72,
  0x65, 0x6e, 0x63, 0x79, 0x65, 0x76, 0x65, 0x72, 0x79, 0x6f, 0x6e, 0x65, 0x73,
  0x74, 0x72, 0x61, 0x69, 0x67, 0x68, 0x74, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
  0x65, 0x72, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x70, 0x72, 0x6f,
  0x64, 0x75, 0x63, 0x65, 0x64, 0x68, 0x65, 0x72, 0x69, 0x74, 0x61, 0x67, 0x65,
  0x73, 0x68, 0x69, 0x70, 0x70, 0x69, 0x6e, 0x67, 0x61, 0x62, 0x73, 0x6f, 0x6c,
  0x75, 0x74, 0x65, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x72, 0x65,
  0x6c, 0x65, 0x76, 0x61, 0x6e, 0x74, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x22,
  0x20, 0x76, 0x69, 0x6f, 0x6c, 0x65, 0x6e, 0x63, 0x65, 0x61, 0x6e, 0x79, 0x77,
  0x68, 0x65, 0x72, 0x65, 0x62, 0x65, 0x6e, 0x65, 0x66, 0x69, 0x74, 0x73, 0x6c,
  0x61, 0x75, 0x6e, 0x63, 0x68, 0x65, 0x64, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74,
  0x6c, 0x79, 0x61, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x66, 0x6f, 0x6c,
  0x6c, 0x6f, 0x77, 0x65, 0x64, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65,
  0x62, 0x75, 0x6c, 0x6c, 0x65, 0x74, 0x69, 0x6e, 0x69, 0x6e, 0x63, 0x6c, 0x75,
  0x64, 0x65, 0x64, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65, 0x64, 0x69, 0x6e,
  0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x24, 0x28, 0x74, 0x68, 0x69, 0x73, 0x29,
  0x2e, 0x72, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x3e, 0x3c, 0x74, 0x72,
  0x3e, 0x3c, 0x74, 0x64, 0x63, 0x6f, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x72,
  0x65, 0x63, 0x6f, 0x72, 0x64, 0x65, 0x64, 0x75, 0x6c, 0x74, 0x69, 0x6d, 0x61,
  0x74, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x3c, 0x75, 0x6c,
  0x20, 0x69, 0x64, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
  0x48, 0x6f, 0x6d, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x77, 0x65, 0x62, 0x73, 0x69,
  0x74, 0x65, 0x73, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x61, 0x6c,
  0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x65, 0x6e, 0x74, 0x69, 0x72, 0x65, 0x6c,
  0x79, 0x6d, 0x65, 0x6d, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x6d, 0x65, 0x73, 0x73,
  0x61, 0x67, 0x65, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x61,
  0x63, 0x74, 0x69, 0x76, 0x65, 0x22, 0x3e, 0x73, 0x6f, 0x6d, 0x65, 0x77, 0x68,
  0x61, 0x74, 0x76, 0x69, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x57, 0x65, 0x73,
  0x74, 0x65, 0x72, 0x6e, 0x20, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22,
  0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x74, 0x72,
  0x61, 0x63, 0x74, 0x76, 0x69, 0x73, 0x69, 0x74, 0x6f, 0x72, 0x73, 0x44, 0x6f,
  0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x77, 0x69, 0x74, 0x68, 0x6f, 0x75, 0x74,
  0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3e, 0x0a, 0x6d, 0x65, 0x61, 0x73,
  0x75, 0x72, 0x65, 0x73, 0x77, 0x69, 0x64, 0x74, 0x68, 0x20, 0x3d, 0x20, 0x76,
  0x61, 0x72, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76,
  0x65, 0x64, 0x76, 0x69, 0x72, 0x67, 0x69, 0x6e, 0x69, 0x61, 0x6e, 0x6f, 0x72,
  0x6d, 0x61, 0x6c, 0x6c, 0x79, 0x68, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x65, 0x64,
  0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x73, 0x74, 0x61, 0x6e, 0x64,
  0x69, 0x6e, 0x67, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x52, 0x65,
  0x67, 0x69, 0x73, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x65,
  0x64, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x73, 0x61, 0x63, 0x63, 0x75,
  0x72, 0x61, 0x74, 0x65, 0x62, 0x69, 0x72, 0x74, 0x68, 0x64, 0x61, 0x79, 0x73,
  0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x79, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69,
  0x61, 0x6c, 0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x73, 0x63, 0x72, 0x69,
  0x6d, 0x69, 0x6e, 0x61, 0x6c, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x79,
  0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x65, 0x72, 0x50, 0x65, 0x72, 0x73, 0x6f,
  0x6e, 0x61, 0x6c, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x76, 0x61,
  0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x61, 0x63, 0x68, 0x69, 0x65, 0x76, 0x65,
  0x64, 0x2e, 0x6a, 0x70, 0x67, 0x22, 0x20, 0x2f, 0x3e, 0x6d, 0x61, 0x63, 0x68,
  0x69, 0x6e, 0x65, 0x73, 0x3c, 0x2f, 0x68, 0x32, 0x3e, 0x0a, 0x20, 0x20, 0x6b,
  0x65, 0x79, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x66, 0x72, 0x69, 0x65, 0x6e, 0x64,
  0x6c, 0x79, 0x62, 0x72, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x6d,
  0x62, 0x69, 0x6e, 0x65, 0x64, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
  0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x65, 0x78, 0x70, 0x65, 0x63,
  0x74, 0x65, 0x64, 0x61, 0x64, 0x65, 0x71, 0x75, 0x61, 0x74, 0x65, 0x70, 0x61,
  0x6b, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x22,
  0x20, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x62, 0x6c, 0x65, 0x3c, 0x2f, 0x6c, 0x61,
  0x62, 0x65, 0x6c, 0x3e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x62,
  0x72, 0x69, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61,
  0x73, 0x65, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6f, 0x72, 0x70, 0x6c, 0x75,
  0x67, 0x69, 0x6e, 0x73, 0x2f, 0x4c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x48, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x22, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x22, 0x20, 0x28, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x67, 0x72,
  0x61, 0x64, 0x75, 0x61, 0x74, 0x65, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e,
  0x0a, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x65, 0x6d, 0x61, 0x6c, 0x61,
  0x79, 0x73, 0x69, 0x61, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x6d,
  0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x3b, 0x68, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x3a, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x63, 0x68, 0x61,
  0x6e, 0x67, 0x69, 0x6e, 0x67, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x74, 0x6f, 0x20,
  0x63, 0x61, 0x74, 0x68, 0x6f, 0x6c, 0x69, 0x63, 0x70, 0x61, 0x74, 0x74, 0x65,
  0x72, 0x6e, 0x73, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x20, 0x23, 0x67, 0x72,
  0x65, 0x61, 0x74, 0x65, 0x73, 0x74, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65,
  0x73, 0x72, 0x65, 0x6c, 0x69, 0x61, 0x62, 0x6c, 0x65, 0x3c, 0x2f, 0x75, 0x6c,
  0x3e, 0x0a, 0x09, 0x09, 0x3c, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x20, 0x63,
  0x69, 0x74, 0x69, 0x7a, 0x65, 0x6e, 0x73, 0x63, 0x6c, 0x6f, 0x74, 0x68, 0x69,
  0x6e, 0x67, 0x77, 0x61, 0x74, 0x63, 0x68, 0x69, 0x6e, 0x67, 0x3c, 0x6c, 0x69,
  0x20, 0x69, 0x64, 0x3d, 0x22, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,
  0x63, 0x61, 0x72, 0x72, 0x79, 0x69, 0x6e, 0x67, 0x73, 0x65, 0x6e, 0x74, 0x65,
  0x6e, 0x63, 0x65, 0x3c, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3e, 0x63, 0x6f,
  0x6e, 0x74, 0x72, 0x61, 0x73, 0x74, 0x74, 0x68, 0x69, 0x6e, 0x6b, 0x69, 0x6e,
  0x67, 0x63, 0x61, 0x74, 0x63, 0x68, 0x28, 0x65, 0x29, 0x73, 0x6f, 0x75, 0x74,
  0x68, 0x65, 0x72, 0x6e, 0x4d, 0x69, 0x63, 0x68, 0x61, 0x65, 0x6c, 0x20, 0x6d,
  0x65, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x74, 0x63, 0x61, 0x72, 0x6f, 0x75, 0x73,
  0x65, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x69, 0x6f, 0x72, 0x2e, 0x73, 0x70, 0x6c, 0x69, 0x74, 0x28, 0x22,
  0x6c, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x63, 0x74, 0x6f, 0x62,
  0x65, 0x72, 0x20, 0x29, 0x7b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x6d,
  0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x2d, 0x2d, 0x26, 0x67, 0x74, 0x3b, 0x0a,
  0x0a, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x61, 0x67, 0x65, 0x63, 0x68, 0x61, 0x69,
  0x72, 0x6d, 0x61, 0x6e, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x20, 0x2f, 0x3e, 0x73,
  0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x52, 0x69, 0x63, 0x68, 0x61, 0x72,
  0x64, 0x20, 0x77, 0x68, 0x61, 0x74, 0x65, 0x76, 0x65, 0x72, 0x70, 0x72, 0x6f,
  0x62, 0x61, 0x62, 0x6c, 0x79, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
  0x62, 0x61, 0x73, 0x65, 0x62, 0x61, 0x6c, 0x6c, 0x6a, 0x75, 0x64, 0x67, 0x6d,
  0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x2e, 0x2e, 0x63,
  0x73, 0x73, 0x22, 0x20, 0x2f, 0x3e, 0x20, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74,
  0x65, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x64, 0x65, 0x66, 0x61,
  0x75, 0x6c, 0x74, 0x22, 0x2f, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x0d, 0x0a, 0x65,
  0x6c, 0x65, 0x63, 0x74, 0x72, 0x69, 0x63, 0x73, 0x63, 0x6f, 0x74, 0x6c, 0x61,
  0x6e, 0x64, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x71, 0x75, 0x61,
  0x6e, 0x74, 0x69, 0x74, 0x79, 0x2e, 0x20, 0x49, 0x53, 0x42, 0x4e, 0x20, 0x30,
  0x64, 0x69, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x61,
  0x6e, 0x63, 0x65, 0x2d, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2d, 0x22, 0x20,
  0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x65, 0x72,
  0x73, 0x43, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x73, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x65, 0x73, 0x6d,
  0x69, 0x6e, 0x69, 0x73, 0x74, 0x65, 0x72, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x74, 0x61,
  0x6c, 0x69, 0x61, 0x6e, 0x6f, 0x63, 0x72, 0x69, 0x74, 0x65, 0x72, 0x69, 0x61,
  0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x6c, 0x79, 0x3a, 0x20, 0x27, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x27, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x27, 0x63, 0x6f,
  0x76, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x6f, 0x66, 0x66, 0x65, 0x72, 0x69, 0x6e,
  0x67, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x42, 0x72, 0x69, 0x74,
  0x69, 0x73, 0x68, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x79, 0x46,
  0x61, 0x63, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x6f,
  0x75, 0x73, 0x76, 0x65, 0x68, 0x69, 0x63, 0x6c, 0x65, 0x73, 0x63, 0x6f, 0x6e,
  0x63, 0x65, 0x72, 0x6e, 0x73, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e,
  0x68, 0x61, 0x6e, 0x64, 0x6c, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x76, 0x20, 0x69,
  0x64, 0x3d, 0x22, 0x57, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6d, 0x20, 0x70, 0x72,
  0x6f, 0x76, 0x69, 0x64, 0x65, 0x72, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x61, 0x63, 0x63, 0x75, 0x72, 0x61, 0x63, 0x79, 0x73, 0x65, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x61, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x66,
  0x6c, 0x65, 0x78, 0x69, 0x62, 0x6c, 0x65, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f,
  0x72, 0x79, 0x6c, 0x61, 0x77, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x3c, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x6c, 0x61, 0x79, 0x6f, 0x75, 0x74, 0x3d, 0x22,
  0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x6d, 0x61, 0x78, 0x69,
  0x6d, 0x75, 0x6d, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x3c, 0x2f,
  0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
  0x73, 0x68, 0x61, 0x6d, 0x69, 0x6c, 0x74, 0x6f, 0x6e, 0x63, 0x75, 0x72, 0x72,
  0x65, 0x6e, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x61, 0x64, 0x69, 0x61, 0x6e, 0x63,
  0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x2f, 0x74, 0x68, 0x65, 0x6d, 0x65,
  0x73, 0x2f, 0x2f, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x6f, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x61, 0x6c,
  0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x22, 0x69, 0x6e, 0x74, 0x65, 0x72,
  0x76, 0x61, 0x6c, 0x77, 0x69, 0x72, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x65, 0x6e,
  0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x61, 0x67, 0x65, 0x6e, 0x63, 0x69, 0x65,
  0x73, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x20, 0x6d, 0x65, 0x61, 0x73,
  0x75, 0x72, 0x65, 0x64, 0x74, 0x68, 0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64, 0x73,
  0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x26, 0x68, 0x65, 0x6c, 0x6c, 0x69,
  0x70, 0x3b, 0x6e, 0x65, 0x77, 0x20, 0x44, 0x61, 0x74, 0x65, 0x22, 0x20, 0x73,
  0x69, 0x7a, 0x65, 0x3d, 0x22, 0x70, 0x61, 0x67, 0x65, 0x4e, 0x61, 0x6d, 0x65,
  0x6d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x22, 0x20, 0x22, 0x20, 0x2f, 0x3e, 0x3c,
  0x2f, 0x61, 0x3e, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x3e, 0x73, 0x65,
  0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61,
  0x6c, 0x6f, 0x76, 0x65, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x6f, 0x70, 0x69, 0x6e,
  0x69, 0x6f, 0x6e, 0x73, 0x69, 0x6c, 0x6c, 0x69, 0x6e, 0x6f, 0x69, 0x73, 0x6c,
  0x69, 0x6e, 0x6b, 0x73, 0x22, 0x3e, 0x0a, 0x09, 0x3c, 0x74, 0x69, 0x74, 0x6c,
  0x65, 0x3e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x61, 0x74,
  0x75, 0x72, 0x64, 0x61, 0x79, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x6c,
  0x69, 0x74, 0x65, 0x6d, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x6e, 0x67, 0x69, 0x6e,
  0x65, 0x65, 0x72, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x64, 0x65,
  0x73, 0x69, 0x67, 0x6e, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x61,
  0x6c, 0x3d, 0x22, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x22, 0x45, 0x73, 0x70, 0x61,
  0xc3, 0xb1, 0x6f, 0x6c, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x73, 0x73,
  0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x65, 0x72, 0x26, 0x71, 0x75, 0x6f,
  0x74, 0x3b, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x79, 0x6d,
  0x70, 0x74, 0x6f, 0x6d, 0x73, 0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x64,
  0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x72, 0x69, 0x67, 0x68, 0x74,
  0x22, 0x3e, 0x3c, 0x70, 0x6c, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x73, 0x74,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
  0x2e, 0x6c, 0x65, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x20, 0x62, 0x6f, 0x72,
  0x64, 0x65, 0x72, 0x3d, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x73, 0x63,
  0x65, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x3e, 0x2e, 0x0a, 0x0a, 0x53, 0x6f, 0x6d,
  0x65, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x73, 0x75, 0x69,
  0x74, 0x61, 0x62, 0x6c, 0x65, 0x62, 0x75, 0x6c, 0x67, 0x61, 0x72, 0x69, 0x61,
  0x2e, 0x73, 0x68, 0x6f, 0x77, 0x28, 0x29, 0x3b, 0x64, 0x65, 0x73, 0x69, 0x67,
  0x6e, 0x65, 0x64, 0x47, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x63, 0x6f,
  0x6e, 0x63, 0x65, 0x70, 0x74, 0x73, 0x45, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
  0x73, 0x77, 0x69, 0x6c, 0x6c, 0x69, 0x61, 0x6d, 0x73, 0x4f, 0x72, 0x69, 0x67,
  0x69, 0x6e, 0x61, 0x6c, 0x22, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x73,
  0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x3e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
  0x6f, 0x72, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73, 0x61, 0x20, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x76, 0x69, 0x73,
  0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x0a, 0x0a, 0x54, 0x68, 0x65, 0x20, 0x79, 0x6f,
  0x75, 0x72, 0x73, 0x65, 0x6c, 0x66, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
  0x20, 0x6d, 0x69, 0x63, 0x68, 0x69, 0x67, 0x61, 0x6e, 0x45, 0x6e, 0x67, 0x6c,
  0x69, 0x73, 0x68, 0x20, 0x63, 0x6f, 0x6c, 0x75, 0x6d, 0x62, 0x69, 0x61, 0x70,
  0x72, 0x69, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x70, 0x72, 0x69, 0x6e, 0x74, 0x69,
  0x6e, 0x67, 0x64, 0x72, 0x69, 0x6e, 0x6b, 0x69, 0x6e, 0x67, 0x66, 0x61, 0x63,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64,
  0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x66, 0x69, 0x63,
  0x65, 0x72, 0x73, 0x52, 0x75, 0x73, 0x73, 0x69, 0x61, 0x6e, 0x20, 0x67, 0x65,
  0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x2d, 0x38, 0x38, 0x35, 0x39, 0x2d, 0x31,
  0x22, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x66, 0x61, 0x6d, 0x69,
  0x6c, 0x69, 0x61, 0x72, 0x20, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x6d,
  0x61, 0x72, 0x67, 0x69, 0x6e, 0x3a, 0x30, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65,
  0x6e, 0x74, 0x76, 0x69, 0x65, 0x77, 0x70, 0x6f, 0x72, 0x74, 0x63, 0x6f, 0x6e,
  0x74, 0x61, 0x63, 0x74, 0x73, 0x2d, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x3e,
  0x70, 0x6f, 0x72, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x2e, 0x6c, 0x65, 0x6e, 0x67,
  0x74, 0x68, 0x20, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x69, 0x6e,
  0x76, 0x6f, 0x6c, 0x76, 0x65, 0x73, 0x61, 0x74, 0x6c, 0x61, 0x6e, 0x74, 0x69,
  0x63, 0x6f, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x3d, 0x22, 0x64, 0x65, 0x66, 0x61,
  0x75, 0x6c, 0x74, 0x2e, 0x73, 0x75, 0x70, 0x70, 0x6c, 0x69, 0x65, 0x64, 0x70,
  0x61, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x67, 0x6c, 0x6f, 0x73, 0x73, 0x61,
  0x72, 0x79, 0x0a, 0x0a, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x67, 0x75, 0x69,
  0x64, 0x61, 0x6e, 0x63, 0x65, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x74, 0x64,
  0x65, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x6d, 0x69, 0x64, 0x64, 0x6c,
  0x65, 0x22, 0x3e, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x64, 0x69,
  0x73, 0x70, 0x6c, 0x61, 0x79, 0x73, 0x73, 0x63, 0x6f, 0x74, 0x74, 0x69, 0x73,
  0x68, 0x6a, 0x6f, 0x6e, 0x61, 0x74, 0x68, 0x61, 0x6e, 0x6d, 0x61, 0x6a, 0x6f,
  0x72, 0x69, 0x74, 0x79, 0x77, 0x69, 0x64, 0x67, 0x65, 0x74, 0x73, 0x2e, 0x63,
  0x6c, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x74, 0x68, 0x61, 0x69, 0x6c, 0x61,
  0x6e, 0x64, 0x74, 0x65, 0x61, 0x63, 0x68, 0x65, 0x72, 0x73, 0x3c, 0x68, 0x65,
  0x61, 0x64, 0x3e, 0x0a, 0x09, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65, 0x64,
  0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x73, 0x70, 0x6f, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x3b, 0x74, 0x6f, 0x53, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x3c, 0x2f,
  0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x3e, 0x6f, 0x6b, 0x6c, 0x61, 0x68, 0x6f, 0x6d,
  0x61, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x62, 0x65, 0x20, 0x69, 0x6e, 0x76, 0x65,
  0x73, 0x74, 0x6f, 0x72, 0x30, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22, 0x68,
  0x6f, 0x6c, 0x69, 0x64, 0x61, 0x79, 0x73, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72,
  0x63, 0x65, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x64, 0x20, 0x28, 0x77,
  0x68, 0x69, 0x63, 0x68, 0x20, 0x2e, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20,
  0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x76, 0x69, 0x73, 0x69, 0x74,
  0x69, 0x6e, 0x67, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x72, 0x70, 0x72,
  0x69, 0x6d, 0x61, 0x72, 0x79, 0x20, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22,
  0x20, 0x61, 0x6e, 0x64, 0x72, 0x6f, 0x69, 0x64, 0x22, 0x71, 0x75, 0x69, 0x63,
  0x6b, 0x6c, 0x79, 0x20, 0x6d, 0x65, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x65,
  0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x3b, 0x72, 0x65, 0x74, 0x75, 0x72,
  0x6e, 0x20, 0x3b, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x20, 0x68, 0x65,
  0x69, 0x67, 0x68, 0x74, 0x3d, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
  0x2c, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x20, 0x63, 0x68, 0x65, 0x63,
  0x6b, 0x65, 0x64, 0x2e, 0x6d, 0x69, 0x6e, 0x2e, 0x6a, 0x73, 0x22, 0x6d, 0x61,
  0x67, 0x6e, 0x65, 0x74, 0x69, 0x63, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f,
  0x68, 0x66, 0x6f, 0x72, 0x65, 0x63, 0x61, 0x73, 0x74, 0x2e, 0x20, 0x57, 0x68,
  0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x75, 0x72, 0x73, 0x64, 0x61, 0x79, 0x64,
  0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x26, 0x65, 0x61, 0x63, 0x75, 0x74,
  0x65, 0x3b, 0x68, 0x61, 0x73, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x65, 0x76, 0x61,
  0x6c, 0x75, 0x61, 0x74, 0x65, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67,
  0x65, 0x78, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x70, 0x61, 0x74, 0x69, 0x65,
  0x6e, 0x74, 0x73, 0x20, 0x4f, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x20, 0x63, 0x6f,
  0x6c, 0x6f, 0x72, 0x61, 0x64, 0x6f, 0x4f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x22, 0x63, 0x61, 0x6d, 0x70, 0x62, 0x65, 0x6c, 0x6c, 0x3c, 0x21, 0x2d, 0x2d,
  0x20, 0x65, 0x6e, 0x64, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x3c,
  0x62, 0x72, 0x20, 0x2f, 0x3e, 0x0d, 0x0a, 0x5f, 0x70, 0x6f, 0x70, 0x75, 0x70,
  0x73, 0x7c, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x2c, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x20, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x20,
  0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73, 0x20, 0x61, 0x73, 0x73, 0x69, 0x67,
  0x6e, 0x65, 0x64, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x3c, 0x62,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x6c, 0x65, 0x26, 0x71, 0x75, 0x6f, 0x74,
  0x3b, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x20, 0x43, 0x6f, 0x6d,
  0x70, 0x61, 0x6e, 0x79, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x3c,
  0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76,
  0x65, 0x73, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x6d, 0x61, 0x72,
  0x73, 0x68, 0x61, 0x6c, 0x6c, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x6c, 0x79, 0x29, 0x2e, 0x0a, 0x0a, 0x54,
  0x68, 0x65, 0x20, 0x74, 0x61, 0x78, 0x6f, 0x6e, 0x6f, 0x6d, 0x79, 0x6d, 0x75,
  0x63, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e,
  0x0a, 0x22, 0x20, 0x64, 0x61, 0x74, 0x61, 0x2d, 0x73, 0x72, 0x74, 0x75, 0x67,
  0x75, 0xc3, 0xaa, 0x73, 0x73, 0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x54, 0x6f, 0x20,
  0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e,
  0x0d, 0x0a, 0x61, 0x74, 0x74, 0x6f, 0x72, 0x6e, 0x65, 0x79, 0x65, 0x6d, 0x70,
  0x68, 0x61, 0x73, 0x69, 0x73, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x6f, 0x72, 0x73,
  0x66, 0x61, 0x6e, 0x63, 0x79, 0x62, 0x6f, 0x78, 0x77, 0x6f, 0x72, 0x6c, 0x64,
  0x27, 0x73, 0x20, 0x77, 0x69, 0x6c, 0x64, 0x6c, 0x69, 0x66, 0x65, 0x63, 0x68,
  0x65, 0x63, 0x6b, 0x65, 0x64, 0x3d, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e,
  0x73, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x70, 0x78, 0x3b, 0x66,
  0x6f, 0x6e, 0x74, 0x2d, 0x20, 0x50, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x6a,
  0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x73, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76,
  0x65, 0x64, 0x76, 0x61, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x68, 0x6f,
  0x6d, 0x70, 0x73, 0x6f, 0x6e, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x69, 0x6e, 0x67,
  0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69,
  0x61, 0x6c, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x30, 0x63, 0x68,
  0x65, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x3c, 0x2f, 0x74, 0x62, 0x6f, 0x64, 0x79,
  0x3e, 0x3c, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x20, 0x43, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x65, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x66, 0x69, 0x78, 0x0a,
  0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c,
  0x65, 0x20, 0x3c, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x69, 0x6e,
  0x64, 0x69, 0x6e, 0x67, 0x73, 0x72, 0x6f, 0x6c, 0x65, 0x20, 0x69, 0x6e, 0x20,
  0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x20, 0x4f, 0x63, 0x74, 0x6f,
  0x62, 0x65, 0x72, 0x77, 0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x20, 0x65, 0x78,
  0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x20, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x73, 0x6f, 0x70, 0x65, 0x72,
  0x61, 0x74, 0x65, 0x64, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x69, 0x6e, 0x67, 0x65,
  0x6e, 0x74, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e,
  0x64, 0x73, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x20, 0x6e, 0x75,
  0x6d, 0x62, 0x65, 0x72, 0x73, 0x20, 0x20, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x6f, 0x6e, 0x53, 0x75, 0x62,
  0x6d, 0x69, 0x74, 0x6d, 0x61, 0x72, 0x79, 0x6c, 0x61, 0x6e, 0x64, 0x63, 0x6f,
  0x6c, 0x6c, 0x65, 0x67, 0x65, 0x73, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69,
  0x63, 0x6c, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x63, 0x74, 0x2e, 0x6c, 0x6f, 0x67, 0x67, 0x65, 0x64, 0x49, 0x6e, 0x61,
  0x64, 0x76, 0x69, 0x73, 0x6f, 0x72, 0x79, 0x73, 0x69, 0x62, 0x6c, 0x69, 0x6e,
  0x67, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x73, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x29, 0x73, 0x2e, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20,
  0x70, 0x61, 0x63, 0x6b, 0x61, 0x67, 0x65, 0x73, 0x63, 0x68, 0x65, 0x63, 0x6b,
  0x62, 0x6f, 0x78, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x73, 0x70, 0x72,
  0x65, 0x67, 0x6e, 0x61, 0x6e, 0x74, 0x74, 0x6f, 0x6d, 0x6f, 0x72, 0x72, 0x6f,
  0x77, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x69, 0x63, 0x6f, 0x6e,
  0x2e, 0x70, 0x6e, 0x67, 0x6a, 0x61, 0x70, 0x61, 0x6e, 0x65, 0x73, 0x65, 0x63,
  0x6f, 0x64, 0x65, 0x62, 0x61, 0x73, 0x65, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e,
  0x22, 0x3e, 0x67, 0x61, 0x6d, 0x62, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x75, 0x63,
  0x68, 0x20, 0x61, 0x73, 0x20, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20,
  0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x20, 0x6d, 0x69, 0x73, 0x73, 0x6f,
  0x75, 0x72, 0x69, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x74, 0x6f,
  0x70, 0x3a, 0x31, 0x70, 0x78, 0x20, 0x2e, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e,
  0x3e, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x77, 0x69, 0x64, 0x74,
  0x68, 0x3d, 0x22, 0x32, 0x6c, 0x61, 0x7a, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x6e,
  0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x75, 0x73, 0x65, 0x64, 0x20, 0x69,
  0x6e, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x22, 0x3e, 0x0a, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x2f,
  0x3c, 0x74, 0x72, 0x3e, 0x3c, 0x74, 0x64, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x3a, 0x32, 0x2f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x63, 0x6f,
  0x75, 0x6e, 0x74, 0x72, 0x79, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65,
  0x20, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x22, 0x20, 0x26, 0x6c, 0x74, 0x3b,
  0x21, 0x2d, 0x2d, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x22, 0x3e, 0x3c, 0x2f,
  0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d,
  0x3e, 0x0a, 0x28, 0xe7, 0xae, 0x80, 0xe4, 0xbd, 0x93, 0x29, 0x28, 0xe7, 0xb9,
  0x81, 0xe9, 0xab, 0x94, 0x29, 0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69,
  0x69, 0x74, 0x61, 0x6c, 0x69, 0x61, 0x6e, 0x6f, 0x72, 0x6f, 0x6d, 0xc3, 0xa2,
  0x6e, 0xc4, 0x83, 0x74, 0xc3, 0xbc, 0x72, 0x6b, 0xc3, 0xa7, 0x65, 0xd8, 0xa7,
  0xd8, 0xb1, 0xd8, 0xaf, 0xd9, 0x88, 0x74, 0x61, 0x6d, 0x62, 0x69, 0xc3, 0xa9,
  0x6e, 0x6e, 0x6f, 0x74, 0x69, 0x63, 0x69, 0x61, 0x73, 0x6d, 0x65, 0x6e, 0x73,
  0x61, 0x6a, 0x65, 0x73, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x73, 0x64,
  0x65, 0x72, 0x65, 0x63, 0x68, 0x6f, 0x73, 0x6e, 0x61, 0x63, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x69, 0x6f, 0x63, 0x6f, 0x6e,
  0x74, 0x61, 0x63, 0x74, 0x6f, 0x75, 0x73, 0x75, 0x61, 0x72, 0x69, 0x6f, 0x73,
  0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x61, 0x67, 0x6f, 0x62, 0x69, 0x65,
  0x72, 0x6e, 0x6f, 0x65, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x61, 0x73, 0x61, 0x6e,
  0x75, 0x6e, 0x63, 0x69, 0x6f, 0x73, 0x76, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x69,
  0x61, 0x63, 0x6f, 0x6c, 0x6f, 0x6d, 0x62, 0x69, 0x61, 0x64, 0x65, 0x73, 0x70,
  0x75, 0xc3, 0xa9, 0x73, 0x64, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x73, 0x70,
  0x72, 0x6f, 0x79, 0x65, 0x63, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63,
  0x74, 0x6f, 0x70, 0xc3, 0xba, 0x62, 0x6c, 0x69, 0x63, 0x6f, 0x6e, 0x6f, 0x73,
  0x6f, 0x74, 0x72, 0x6f, 0x73, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x61,
  0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x6d, 0x69, 0x6c, 0x6c, 0x6f,
  0x6e, 0x65, 0x73, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x6e, 0x74, 0x65, 0x70, 0x72,
  0x65, 0x67, 0x75, 0x6e, 0x74, 0x61, 0x61, 0x6e, 0x74, 0x65, 0x72, 0x69, 0x6f,
  0x72, 0x72, 0x65, 0x63, 0x75, 0x72, 0x73, 0x6f, 0x73, 0x70, 0x72, 0x6f, 0x62,
  0x6c, 0x65, 0x6d, 0x61, 0x73, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x67, 0x6f, 0x6e,
  0x75, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x73, 0x6f, 0x70, 0x69, 0x6e, 0x69, 0xc3,
  0xb3, 0x6e, 0x69, 0x6d, 0x70, 0x72, 0x69, 0x6d, 0x69, 0x72, 0x6d, 0x69, 0x65,
  0x6e, 0x74, 0x72, 0x61, 0x73, 0x61, 0x6d, 0xc3, 0xa9, 0x72, 0x69, 0x63, 0x61,
  0x76, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x6f, 0x72, 0x73, 0x6f, 0x63, 0x69, 0x65,
  0x64, 0x61, 0x64, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x65,
  0x61, 0x6c, 0x69, 0x7a, 0x61, 0x72, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72,
  0x6f, 0x70, 0x61, 0x6c, 0x61, 0x62, 0x72, 0x61, 0x73, 0x69, 0x6e, 0x74, 0x65,
  0x72, 0xc3, 0xa9, 0x73, 0x65, 0x6e, 0x74, 0x6f, 0x6e, 0x63, 0x65, 0x73, 0x65,
  0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x6d, 0x69, 0x65, 0x6d, 0x62, 0x72,
  0x6f, 0x73, 0x72, 0x65, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x64, 0x63, 0xc3, 0xb3,
  0x72, 0x64, 0x6f, 0x62, 0x61, 0x7a, 0x61, 0x72, 0x61, 0x67, 0x6f, 0x7a, 0x61,
  0x70, 0xc3, 0xa1, 0x67, 0x69, 0x6e, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61,
  0x6c, 0x65, 0x73, 0x62, 0x6c, 0x6f, 0x71, 0x75, 0x65, 0x61, 0x72, 0x67, 0x65,
  0x73, 0x74, 0x69, 0xc3, 0xb3, 0x6e, 0x61, 0x6c, 0x71, 0x75, 0x69, 0x6c, 0x65,
  0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6d, 0x61, 0x73, 0x63, 0x69, 0x65, 0x6e,
  0x63, 0x69, 0x61, 0x73, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x6f, 0x76,
  0x65, 0x72, 0x73, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x74, 0x61, 0x65, 0x73, 0x74, 0x75, 0x64, 0x69, 0x6f, 0x73, 0x70, 0xc3, 0xba,
  0x62, 0x6c, 0x69, 0x63, 0x61, 0x6f, 0x62, 0x6a, 0x65, 0x74, 0x69, 0x76, 0x6f,
  0x61, 0x6c, 0x69, 0x63, 0x61, 0x6e, 0x74, 0x65, 0x62, 0x75, 0x73, 0x63, 0x61,
  0x64, 0x6f, 0x72, 0x63, 0x61, 0x6e, 0x74, 0x69, 0x64, 0x61, 0x64, 0x65, 0x6e,
  0x74, 0x72, 0x61, 0x64, 0x61, 0x73, 0x61, 0x63, 0x63, 0x69, 0x6f, 0x6e, 0x65,
  0x73, 0x61, 0x72, 0x63, 0x68, 0x69, 0x76, 0x6f, 0x73, 0x73, 0x75, 0x70, 0x65,
  0x72, 0x69, 0x6f, 0x72, 0x6d, 0x61, 0x79, 0x6f, 0x72, 0xc3, 0xad, 0x61, 0x61,
  0x6c, 0x65, 0x6d, 0x61, 0x6e, 0x69, 0x61, 0x66, 0x75, 0x6e, 0x63, 0x69, 0xc3,
  0xb3, 0x6e, 0xc3, 0xba, 0x6c, 0x74, 0x69, 0x6d, 0x6f, 0x73, 0x68, 0x61, 0x63,
  0x69, 0x65, 0x6e, 0x64, 0x6f, 0x61, 0x71, 0x75, 0x65, 0x6c, 0x6c, 0x6f, 0x73,
  0x65, 0x64, 0x69, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x66, 0x65, 0x72, 0x6e, 0x61,
  0x6e, 0x64, 0x6f, 0x61, 0x6d, 0x62, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x66, 0x61,
  0x63, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x6e, 0x75, 0x65, 0x73, 0x74, 0x72, 0x61,
  0x73, 0x63, 0x6c, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x63,
  0x65, 0x73, 0x6f, 0x73, 0x62, 0x61, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x65, 0x70,
  0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74,
  0x61, 0x72, 0x63, 0x6f, 0x6e, 0x67, 0x72, 0x65, 0x73, 0x6f, 0x70, 0x75, 0x62,
  0x6c, 0x69, 0x63, 0x61, 0x72, 0x63, 0x6f, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x6f,
  0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x6f, 0x6a, 0xc3, 0xb3, 0x76, 0x65,
  0x6e, 0x65, 0x73, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x74, 0x6f, 0x74, 0xc3,
  0xa9, 0x63, 0x6e, 0x69, 0x63, 0x61, 0x63, 0x6f, 0x6e, 0x6a, 0x75, 0x6e, 0x74,
  0x6f, 0x65, 0x6e, 0x65, 0x72, 0x67, 0xc3, 0xad, 0x61, 0x74, 0x72, 0x61, 0x62,
  0x61, 0x6a, 0x61, 0x72, 0x61, 0x73, 0x74, 0x75, 0x72, 0x69, 0x61, 0x73, 0x72,
  0x65, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a,
  0x61, 0x72, 0x62, 0x6f, 0x6c, 0x65, 0x74, 0xc3, 0xad, 0x6e, 0x73, 0x61, 0x6c,
  0x76, 0x61, 0x64, 0x6f, 0x72, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x63, 0x74, 0x61,
  0x74, 0x72, 0x61, 0x62, 0x61, 0x6a, 0x6f, 0x73, 0x70, 0x72, 0x69, 0x6d, 0x65,
  0x72, 0x6f, 0x73, 0x6e, 0x65, 0x67, 0x6f, 0x63, 0x69, 0x6f, 0x73, 0x6c, 0x69,
  0x62, 0x65, 0x72, 0x74, 0x61, 0x64, 0x64, 0x65, 0x74, 0x61, 0x6c, 0x6c, 0x65,
  0x73, 0x70, 0x61, 0x6e, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x70, 0x72, 0xc3, 0xb3,
  0x78, 0x69, 0x6d, 0x6f, 0x61, 0x6c, 0x6d, 0x65, 0x72, 0xc3, 0xad, 0x61, 0x61,
  0x6e, 0x69, 0x6d, 0x61, 0x6c, 0x65, 0x73, 0x71, 0x75, 0x69, 0xc3, 0xa9, 0x6e,
  0x65, 0x73, 0x63, 0x6f, 0x72, 0x61, 0x7a, 0xc3, 0xb3, 0x6e, 0x73, 0x65, 0x63,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x62, 0x75, 0x73, 0x63, 0x61, 0x6e, 0x64, 0x6f,
  0x6f, 0x70, 0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x65, 0x78, 0x74, 0x65, 0x72,
  0x69, 0x6f, 0x72, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x6f, 0x74, 0x6f,
  0x64, 0x61, 0x76, 0xc3, 0xad, 0x61, 0x67, 0x61, 0x6c, 0x65, 0x72, 0xc3, 0xad,
  0x61, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x69, 0x72, 0x6d, 0x65, 0x64, 0x69,
  0x63, 0x69, 0x6e, 0x61, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x63,
  0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x74, 0x61, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74,
  0x6f, 0x73, 0x63, 0x72, 0xc3, 0xad, 0x74, 0x69, 0x63, 0x61, 0x64, 0xc3, 0xb3,
  0x6c, 0x61, 0x72, 0x65, 0x73, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x63, 0x69, 0x61,
  0x64, 0x65, 0x62, 0x65, 0x72, 0xc3, 0xa1, 0x6e, 0x70, 0x65, 0x72, 0xc3, 0xad,
  0x6f, 0x64, 0x6f, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x69, 0x74, 0x61, 0x6d, 0x61,
  0x6e, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x70, 0x65, 0x71, 0x75, 0x65, 0xc3, 0xb1,
  0x6f, 0x72, 0x65, 0x63, 0x69, 0x62, 0x69, 0x64, 0x61, 0x74, 0x72, 0x69, 0x62,
  0x75, 0x6e, 0x61, 0x6c, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x69, 0x66, 0x65, 0x63,
  0x61, 0x6e, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x61, 0x6e, 0x61, 0x72, 0x69,
  0x61, 0x73, 0x64, 0x65, 0x73, 0x63, 0x61, 0x72, 0x67, 0x61, 0x64, 0x69, 0x76,
  0x65, 0x72, 0x73, 0x6f, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x6f, 0x72, 0x63, 0x61,
  0x72, 0x65, 0x71, 0x75, 0x69, 0x65, 0x72, 0x65, 0x74, 0xc3, 0xa9, 0x63, 0x6e,
  0x69, 0x63, 0x6f, 0x64, 0x65, 0x62, 0x65, 0x72, 0xc3, 0xad, 0x61, 0x76, 0x69,
  0x76, 0x69, 0x65, 0x6e, 0x64, 0x61, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x7a, 0x61,
  0x73, 0x61, 0x64, 0x65, 0x6c, 0x61, 0x6e, 0x74, 0x65, 0x66, 0x75, 0x6e, 0x63,
  0x69, 0x6f, 0x6e, 0x61, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6a, 0x6f, 0x73, 0x64,
  0x69, 0x66, 0xc3, 0xad, 0x63, 0x69, 0x6c, 0x63, 0x69, 0x75, 0x64, 0x61, 0x64,
  0x65, 0x73, 0x61, 0x6e, 0x74, 0x69, 0x67, 0x75, 0x61, 0x73, 0x61, 0x76, 0x61,
  0x6e, 0x7a, 0x61, 0x64, 0x61, 0x74, 0xc3, 0xa9, 0x72, 0x6d, 0x69, 0x6e, 0x6f,
  0x75, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x65, 0x73, 0x73, 0xc3, 0xa1, 0x6e, 0x63,
  0x68, 0x65, 0x7a, 0x63, 0x61, 0x6d, 0x70, 0x61, 0xc3, 0xb1, 0x61, 0x73, 0x6f,
  0x66, 0x74, 0x6f, 0x6e, 0x69, 0x63, 0x72, 0x65, 0x76, 0x69, 0x73, 0x74, 0x61,
  0x73, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x65, 0x6e, 0x65, 0x73, 0x65, 0x63, 0x74,
  0x6f, 0x72, 0x65, 0x73, 0x6d, 0x6f, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x73, 0x66,
  0x61, 0x63, 0x75, 0x6c, 0x74, 0x61, 0x64, 0x63, 0x72, 0xc3, 0xa9, 0x64, 0x69,
  0x74, 0x6f, 0x64, 0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x73, 0x73, 0x75, 0x70,
  0x75, 0x65, 0x73, 0x74, 0x6f, 0x66, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x65, 0x73,
  0x73, 0x65, 0x67, 0x75, 0x6e, 0x64, 0x6f, 0x73, 0x70, 0x65, 0x71, 0x75, 0x65,
  0xc3, 0xb1, 0x61, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xb5,
  0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x82, 0xd1,
  0x8c, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x8b,
  0xd1, 0x82, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0,
  0x95, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb3,
  0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8f, 0xd0, 0xb2, 0xd1,
  0x81, 0xd0, 0xb5, 0xd1, 0x85, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb9,
  0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xb6, 0xd0, 0xb5, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0,
  0xbb, 0xd0, 0xb8, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd1, 0x83, 0xd0, 0xb4,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd1,
  0x82, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xbb, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb5,
  0xd0, 0xb1, 0xd1, 0x8f, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1,
  0x81, 0xd0, 0xb5, 0xd0, 0xb1, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb4,
  0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xb9, 0xd1, 0x82, 0xd1, 0x84, 0xd0,
  0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe,
  0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xb2, 0xd0,
  0xbe, 0xd0, 0xb9, 0xd0, 0xb8, 0xd0, 0xb3, 0xd1, 0x80, 0xd1, 0x8b, 0xd1, 0x82,
  0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xb5, 0xd0, 0xb2, 0xd1, 0x81, 0xd0, 0xb5, 0xd0,
  0xbc, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd1, 0x8e, 0xd0, 0xbb, 0xd0, 0xb8,
  0xd1, 0x88, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xb8, 0xd1, 0x85, 0xd0,
  0xbf, 0xd0, 0xbe, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xb5,
  0xd0, 0xb9, 0xd0, 0xb4, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0,
  0xb8, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xb1, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd1, 0x83, 0xd1, 0x85, 0xd0, 0xbe, 0xd1,
  0x82, 0xd1, 0x8f, 0xd0, 0xb4, 0xd0, 0xb2, 0xd1, 0x83, 0xd1, 0x85, 0xd1, 0x81,
  0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xbb, 0xd1, 0x8e, 0xd0, 0xb4, 0xd0,
  0xb8, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xb8,
  0xd1, 0x80, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xb1, 0xd1, 0x8f, 0xd1,
  0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xb2, 0xd0, 0xb8, 0xd0, 0xb4,
  0xd0, 0xb5, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1, 0x8d, 0xd1,
  0x82, 0xd0, 0xb8, 0xd0, 0xbc, 0xd1, 0x81, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x82,
  0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd1, 0x8b, 0xd1, 0x86, 0xd0, 0xb5, 0xd0,
  0xbd, 0xd1, 0x8b, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbb, 0xd0, 0xb2,
  0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x8c, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xb5, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb4, 0xd1, 0x8b, 0xd1, 0x82, 0xd0, 0xb5,
  0xd0, 0xb1, 0xd0, 0xb5, 0xd0, 0xb2, 0xd1, 0x8b, 0xd1, 0x88, 0xd0, 0xb5, 0xd0,
  0xbd, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xbf,
  0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x83, 0xd0, 0xbf, 0xd1,
  0x80, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x86, 0xd0, 0xb0,
  0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0,
  0xb4, 0xd1, 0x8b, 0xd0, 0xb7, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x8e, 0xd0, 0xbc,
  0xd0, 0xbe, 0xd0, 0xb3, 0xd1, 0x83, 0xd0, 0xb4, 0xd1, 0x80, 0xd1, 0x83, 0xd0,
  0xb3, 0xd0, 0xb2, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xb9, 0xd0, 0xb8, 0xd0, 0xb4,
  0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0,
  0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb,
  0xd0, 0xb0, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb5, 0xd1, 0x81, 0xd1,
  0x80, 0xd0, 0xbe, 0xd0, 0xba, 0xd0, 0xb8, 0xd1, 0x8e, 0xd0, 0xbd, 0xd1, 0x8f,
  0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x8c, 0xd0, 0x95, 0xd1, 0x81, 0xd1,
  0x82, 0xd1, 0x8c, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0, 0xb0, 0xd0, 0xbd,
  0xd0, 0xb0, 0xd1, 0x88, 0xd0, 0xb8, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x84, 0xd9,
  0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd9, 0x8a, 0xd8, 0xac, 0xd9, 0x85,
  0xd9, 0x8a, 0xd8, 0xb9, 0xd8, 0xae, 0xd8, 0xa7, 0xd8, 0xb5, 0xd8, 0xa9, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xb0, 0xd9, 0x8a, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x8a,
  0xd9, 0x87, 0xd8, 0xac, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xa2, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xaf,
  0xd8, 0xaa, 0xd8, 0xad, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xb5, 0xd9, 0x81, 0xd8,
  0xad, 0xd8, 0xa9, 0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x8a, 0xd9, 0x83, 0xd9, 0x88, 0xd9,
  0x86, 0xd8, 0xb4, 0xd8, 0xa8, 0xd9, 0x83, 0xd8, 0xa9, 0xd9, 0x81, 0xd9, 0x8a,
  0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xa8, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8,
  0xad, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xa1, 0xd8, 0xa3, 0xd9, 0x83, 0xd8, 0xab,
  0xd8, 0xb1, 0xd8, 0xae, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xad, 0xd8, 0xa8, 0xd8, 0xaf, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x84,
  0xd8, 0xaf, 0xd8, 0xb1, 0xd9, 0x88, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8, 0xb6, 0xd8,
  0xba, 0xd8, 0xb7, 0xd8, 0xaa, 0xd9, 0x83, 0xd9, 0x88, 0xd9, 0x86, 0xd9, 0x87,
  0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x83, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8, 0xad, 0xd8,
  0xa9, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb7, 0xd8, 0xa8, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x83, 0xd8,
  0xb4, 0xd9, 0x83, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x8a, 0xd9, 0x85, 0xd9, 0x83,
  0xd9, 0x86, 0xd9, 0x85, 0xd9, 0x86, 0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xb4, 0xd8,
  0xb1, 0xd9, 0x83, 0xd8, 0xa9, 0xd8, 0xb1, 0xd8, 0xa6, 0xd9, 0x8a, 0xd8, 0xb3,
  0xd9, 0x86, 0xd8, 0xb4, 0xd9, 0x8a, 0xd8, 0xb7, 0xd9, 0x85, 0xd8, 0xa7, 0xd8,
  0xb0, 0xd8, 0xa7, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x86, 0xd8, 0xb4,
  0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xaa, 0xd8, 0xb9, 0xd8, 0xa8, 0xd8,
  0xb1, 0xd8, 0xb1, 0xd8, 0xad, 0xd9, 0x85, 0xd8, 0xa9, 0xd9, 0x83, 0xd8, 0xa7,
  0xd9, 0x81, 0xd8, 0xa9, 0xd9, 0x8a, 0xd9, 0x82, 0xd9, 0x88, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xb2, 0xd9, 0x83, 0xd9, 0x84, 0xd9, 0x85,
  0xd8, 0xa9, 0xd8, 0xa3, 0xd8, 0xad, 0xd9, 0x85, 0xd8, 0xaf, 0xd9, 0x82, 0xd9,
  0x84, 0xd8, 0xa8, 0xd9, 0x8a, 0xd9, 0x8a, 0xd8, 0xb9, 0xd9, 0x86, 0xd9, 0x8a,
  0xd8, 0xb5, 0xd9, 0x88, 0xd8, 0xb1, 0xd8, 0xa9, 0xd8, 0xb7, 0xd8, 0xb1, 0xd9,
  0x8a, 0xd9, 0x82, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xac,
  0xd9, 0x88, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8, 0xae, 0xd8, 0xb1, 0xd9,
  0x89, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xa7, 0xd8, 0xa8,
  0xd8, 0xad, 0xd8, 0xab, 0xd8, 0xb9, 0xd8, 0xb1, 0xd9, 0x88, 0xd8, 0xb6, 0xd8,
  0xa8, 0xd8, 0xb4, 0xd9, 0x83, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb3, 0xd8, 0xac,
  0xd9, 0x84, 0xd8, 0xa8, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x86, 0xd8, 0xae, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xaf, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xa8,
  0xd9, 0x83, 0xd9, 0x84, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa8, 0xd8, 0xaf, 0xd9,
  0x88, 0xd9, 0x86, 0xd8, 0xa3, 0xd9, 0x8a, 0xd8, 0xb6, 0xd8, 0xa7, 0xd9, 0x8a,
  0xd9, 0x88, 0xd8, 0xac, 0xd8, 0xaf, 0xd9, 0x81, 0xd8, 0xb1, 0xd9, 0x8a, 0xd9,
  0x82, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa8, 0xd8, 0xaa, 0xd8, 0xa3, 0xd9, 0x81,
  0xd8, 0xb6, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb7, 0xd8, 0xa8, 0xd8, 0xae, 0xd8,
  0xa7, 0xd9, 0x83, 0xd8, 0xab, 0xd8, 0xb1, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xb1,
  0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x81, 0xd8, 0xb6, 0xd9, 0x84, 0xd8, 0xa7, 0xd8,
  0xad, 0xd9, 0x84, 0xd9, 0x89, 0xd9, 0x86, 0xd9, 0x81, 0xd8, 0xb3, 0xd9, 0x87,
  0xd8, 0xa3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xaf, 0xd9,
  0x88, 0xd8, 0xaf, 0xd8, 0xa3, 0xd9, 0x86, 0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xaf,
  0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9,
  0x86, 0xd9, 0x85, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xb6, 0xd8, 0xaa, 0xd8, 0xb9,
  0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xaf, 0xd8, 0xa7, 0xd8, 0xae, 0xd9, 0x84, 0xd9,
  0x85, 0xd9, 0x85, 0xd9, 0x83, 0xd9, 0x86, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
  0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x02,
  0x00, 0x02, 0x00, 0x02, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00,
  0x00, 0x01, 0x02, 0x03, 0x04, 0x05, 0x06, 0x07, 0x07, 0x06, 0x05, 0x04, 0x03,
  0x02, 0x01, 0x00, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e, 0x0f, 0x0f, 0x0e,
  0x0d, 0x0c, 0x0b, 0x0a, 0x09, 0x08, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16,
  0x17, 0x17, 0x16, 0x15, 0x14, 0x13, 0x12, 0x11, 0x10, 0x18, 0x19, 0x1a, 0x1b,
  0x1c, 0x1d, 0x1e, 0x1f, 0x1f, 0x1e, 0x1d, 0x1c, 0x1b, 0x1a, 0x19, 0x18, 0xff,
  0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff,
  0xff, 0xff, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00, 0x00,
  0xff, 0xff, 0x00, 0x01, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0xff, 0xff, 0x00,
  0x01, 0x00, 0x00, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x00,
  0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x00, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00,
  0x07, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x63, 0x6f, 0x75,
  0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x65, 0x71, 0x75, 0x69, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f,
  0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
  0x62, 0x6c, 0x65, 0x68, 0x69, 0x67, 0x68, 0x6c, 0x69, 0x67, 0x68, 0x74, 0x44,
  0x54, 0x44, 0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x6d, 0x61, 0x72, 0x6b, 0x65,
  0x74, 0x69, 0x6e, 0x67, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65,
  0x73, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x65, 0x72, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x61, 0x64, 0x76,
  0x65, 0x72, 0x74, 0x69, 0x73, 0x65, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
  0x65, 0x72, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x3c, 0x2f,
  0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x3e, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61,
  0x6c, 0x69, 0x61, 0x22, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73,
  0x69, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f,
  0x72, 0x69, 0x74, 0x79, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x69, 0x6c, 0x79, 0x6f, 0x70, 0x65, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67,
  0x65, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x64, 0x61, 0x6e, 0x6f,
  0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x63, 0x6f,
  0x6d, 0x70, 0x61, 0x6e, 0x69, 0x65, 0x73, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
  0x75, 0x72, 0x65, 0x61, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22,
  0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22, 0x70, 0x6f, 0x74, 0x65, 0x6e,
  0x74, 0x69, 0x61, 0x6c, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x72, 0x67, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x73, 0x65, 0x63, 0x6f,
  0x6e, 0x64, 0x61, 0x72, 0x79, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68,
  0x74, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x65, 0x78, 0x63,
  0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x3e, 0x0d, 0x0a, 0x73, 0x74,
  0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x74, 0x65, 0x6e, 0x74,
  0x69, 0x6f, 0x6e, 0x42, 0x69, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x79, 0x7d,
  0x20, 0x65, 0x6c, 0x73, 0x65, 0x20, 0x7b, 0x0a, 0x73, 0x6f, 0x6c, 0x75, 0x74,
  0x69, 0x6f, 0x6e, 0x73, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x74, 0x65, 0x6d, 0x70,
  0x6c, 0x61, 0x74, 0x65, 0x73, 0x64, 0x61, 0x6e, 0x67, 0x65, 0x72, 0x6f, 0x75,
  0x73, 0x73, 0x61, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x74, 0x65, 0x64, 0x6f, 0x63,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68,
  0x65, 0x72, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x70, 0x72,
  0x6f, 0x74, 0x6f, 0x74, 0x79, 0x70, 0x65, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65,
  0x6e, 0x63, 0x65, 0x26, 0x72, 0x61, 0x71, 0x75, 0x6f, 0x3b, 0x3c, 0x2f, 0x65,
  0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x67, 0x65, 0x6e, 0x65, 0x72,
  0x61, 0x6c, 0x6c, 0x79, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
  0x62, 0x65, 0x61, 0x75, 0x74, 0x69, 0x66, 0x75, 0x6c, 0x74, 0x72, 0x61, 0x6e,
  0x73, 0x70, 0x6f, 0x72, 0x74, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x65,
  0x64, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x70, 0x72, 0x6f,
  0x6d, 0x69, 0x6e, 0x65, 0x6e, 0x74, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x6e, 0x61, 0x69, 0x6c, 0x4e, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x2e, 0x66, 0x6f, 0x63, 0x75, 0x73,
  0x28, 0x29, 0x3b, 0x6f, 0x76, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d,
  0x69, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6e, 0x6e, 0x6f, 0x75,
  0x6e, 0x63, 0x65, 0x64, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x22, 0x3e, 0x0a,
  0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x6c, 0x65, 0x73, 0x73,
  0x20, 0x74, 0x68, 0x61, 0x6e, 0x65, 0x78, 0x70, 0x65, 0x6e, 0x73, 0x69, 0x76,
  0x65, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x72, 0x61,
  0x6d, 0x65, 0x77, 0x6f, 0x72, 0x6b, 0x74, 0x65, 0x72, 0x72, 0x69, 0x74, 0x6f,
  0x72, 0x79, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x75,
  0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x4e,
  0x61, 0x6d, 0x65, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x69, 0x73, 0x6d, 0x74,
  0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6c, 0x73, 0x65, 0x77,
  0x68, 0x65, 0x72, 0x65, 0x41, 0x6c, 0x65, 0x78, 0x61, 0x6e, 0x64, 0x65, 0x72,
  0x61, 0x70, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x64, 0x6d, 0x61, 0x74, 0x65,
  0x72, 0x69, 0x61, 0x6c, 0x73, 0x62, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73,
  0x74, 0x6d, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x61, 0x66, 0x66,
  0x69, 0x6c, 0x69, 0x61, 0x74, 0x65, 0x3c, 0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f,
  0x6e, 0x3e, 0x74, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x64, 0x69,
  0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x2f, 0x64, 0x65, 0x66, 0x61, 0x75,
  0x6c, 0x74, 0x2e, 0x50, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x6f,
  0x6e, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x3d, 0x22, 0x62, 0x69, 0x6f, 0x67, 0x72,
  0x61, 0x70, 0x68, 0x79, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x77, 0x69, 0x73, 0x65,
  0x70, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x65, 0x6e, 0x74, 0x46, 0x72, 0x61, 0x6e,
  0xc3, 0xa7, 0x61, 0x69, 0x73, 0x48, 0x6f, 0x6c, 0x6c, 0x79, 0x77, 0x6f, 0x6f,
  0x64, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x61,
  0x6e, 0x64, 0x61, 0x72, 0x64, 0x73, 0x3c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3e, 0x0a, 0x72, 0x65, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
  0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72,
  0x72, 0x65, 0x64, 0x43, 0x61, 0x6d, 0x62, 0x72, 0x69, 0x64, 0x67, 0x65, 0x6f,
  0x70, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x75, 0x73, 0x69, 0x6e,
  0x65, 0x73, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x69, 0x6f, 0x6e,
  0x3e, 0x0a, 0x3c, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x70, 0x72, 0x65, 0x73,
  0x65, 0x6e, 0x74, 0x65, 0x64, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x65,
  0x64, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x77, 0x6f, 0x72,
  0x6c, 0x64, 0x77, 0x69, 0x64, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x61,
  0x63, 0x65, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6e, 0x65,
  0x77, 0x73, 0x70, 0x61, 0x70, 0x65, 0x72, 0x3c, 0x2f, 0x74, 0x61, 0x62, 0x6c,
  0x65, 0x3e, 0x0a, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x6c,
  0x69, 0x6b, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x73, 0x73, 0x65, 0x6e,
  0x74, 0x69, 0x61, 0x6c, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c,
  0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x3d, 0x22, 0x2f, 0x61, 0x62, 0x61, 0x6e, 0x64, 0x6f, 0x6e, 0x65,
  0x64, 0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x61, 0x72,
  0x73, 0x65, 0x49, 0x6e, 0x74, 0x28, 0x73, 0x74, 0x61, 0x62, 0x69, 0x6c, 0x69,
  0x74, 0x79, 0x75, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x3c, 0x2f,
  0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x0a, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x73, 0x4e, 0x6f, 0x74, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x65,
  0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x70, 0x65, 0x72, 0x66, 0x6f,
  0x72, 0x6d, 0x65, 0x64, 0x74, 0x77, 0x6f, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73,
  0x53, 0x69, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x66, 0x6f, 0x72, 0x65, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x22,
  0x3e, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x69, 0x6e, 0x63,
  0x72, 0x65, 0x61, 0x73, 0x65, 0x64, 0x42, 0x61, 0x74, 0x74, 0x6c, 0x65, 0x20,
  0x6f, 0x66, 0x70, 0x65, 0x72, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x74, 0x72,
  0x79, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73,
  0x61, 0x72, 0x79, 0x70, 0x6f, 0x72, 0x74, 0x72, 0x61, 0x79, 0x65, 0x64, 0x65,
  0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6c, 0x69, 0x7a, 0x61,
  0x62, 0x65, 0x74, 0x68, 0x3c, 0x2f, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x3e,
  0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x69, 0x6e, 0x73, 0x75,
  0x72, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
  0x3b, 0x6c, 0x65, 0x67, 0x65, 0x6e, 0x64, 0x61, 0x72, 0x79, 0x47, 0x65, 0x6f,
  0x67, 0x72, 0x61, 0x70, 0x68, 0x79, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61,
  0x74, 0x65, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x73, 0x6f,
  0x6d, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
  0x65, 0x73, 0x2e, 0x69, 0x6e, 0x68, 0x65, 0x72, 0x69, 0x74, 0x65, 0x64, 0x3c,
  0x2f, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x43, 0x6f, 0x6d, 0x6d, 0x75,
  0x6e, 0x69, 0x74, 0x79, 0x72, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x6f, 0x75, 0x73,
  0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x43, 0x6f, 0x6d, 0x6d,
  0x69, 0x74, 0x74, 0x65, 0x65, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67,
  0x73, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x6e, 0x6f, 0x20,
  0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69,
  0x6e, 0x67, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x63, 0x61,
  0x6e, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x63, 0x79, 0x74, 0x79, 0x70, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x69,
  0x6e, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x74,
  0x69, 0x76, 0x65, 0x3b, 0x72, 0x65, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67,
  0x70, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x69, 0x74,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71, 0x75,
  0x65, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x69, 0x74, 0x20,
  0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e,
  0x63, 0x65, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x6c, 0x69, 0x6e, 0x65, 0x74, 0x68,
  0x69, 0x73, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x74, 0x65, 0x6c, 0x65, 0x70, 0x68,
  0x6f, 0x6e, 0x65, 0x69, 0x74, 0x65, 0x6d, 0x73, 0x63, 0x6f, 0x70, 0x65, 0x70,
  0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x65, 0x73, 0x61, 0x64, 0x76, 0x61, 0x6e,
  0x74, 0x61, 0x67, 0x65, 0x29, 0x3b, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20,
  0x46, 0x6f, 0x72, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x76,
  0x69, 0x64, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x6d, 0x6f, 0x63, 0x72, 0x61, 0x63,
  0x79, 0x62, 0x6f, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x78, 0x74,
  0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x73, 0x75, 0x66, 0x66, 0x65, 0x72, 0x69,
  0x6e, 0x67, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x63, 0x6f,
  0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x73, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x73,
  0x61, 0x69, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x74, 0x20, 0x6d, 0x61,
  0x79, 0x20, 0x62, 0x65, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x3c, 0x2f,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x63, 0x68, 0x65,
  0x64, 0x75, 0x6c, 0x65, 0x64, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64,
  0x73, 0x3c, 0x2f, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x3e, 0x0a, 0x73, 0x75, 0x73,
  0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x3a,
  0x20, 0x30, 0x73, 0x70, 0x69, 0x72, 0x69, 0x74, 0x75, 0x61, 0x6c, 0x3c, 0x2f,
  0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x0a, 0x6d, 0x69, 0x63, 0x72, 0x6f, 0x73,
  0x6f, 0x66, 0x74, 0x67, 0x72, 0x61, 0x64, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x64,
  0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x65, 0x64, 0x68, 0x65, 0x20, 0x62, 0x65,
  0x63, 0x61, 0x6d, 0x65, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x76, 0x65,
  0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6a, 0x73, 0x68, 0x6f, 0x75, 0x73,
  0x65, 0x68, 0x6f, 0x6c, 0x64, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x72, 0x6d, 0x65,
  0x64, 0x70, 0x75, 0x72, 0x63, 0x68, 0x61, 0x73, 0x65, 0x64, 0x6c, 0x69, 0x74,
  0x65, 0x72, 0x61, 0x6c, 0x6c, 0x79, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79,
  0x65, 0x64, 0x75, 0x70, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x76, 0x61,
  0x72, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e,
  0x69, 0x6e, 0x67, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x63,
  0x65, 0x6e, 0x74, 0x75, 0x72, 0x69, 0x65, 0x73, 0x4a, 0x61, 0x70, 0x61, 0x6e,
  0x65, 0x73, 0x65, 0x20, 0x61, 0x6d, 0x6f, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
  0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x61, 0x6c, 0x67, 0x6f,
  0x72, 0x69, 0x74, 0x68, 0x6d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74,
  0x73, 0x72, 0x65, 0x62, 0x65, 0x6c, 0x6c, 0x69, 0x6f, 0x6e, 0x75, 0x6e, 0x64,
  0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x65, 0x6e, 0x63, 0x6f, 0x75, 0x72, 0x61,
  0x67, 0x65, 0x72, 0x65, 0x73, 0x69, 0x7a, 0x61, 0x62, 0x6c, 0x65, 0x69, 0x6e,
  0x76, 0x6f, 0x6c, 0x76, 0x69, 0x6e, 0x67, 0x73, 0x65, 0x6e, 0x73, 0x69, 0x74,
  0x69, 0x76, 0x65, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x6c, 0x70,
  0x72, 0x6f, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x28, 0x61, 0x6c, 0x74, 0x68,
  0x6f, 0x75, 0x67, 0x68, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x69, 0x6e, 0x67,
  0x63, 0x6f, 0x6e, 0x64, 0x75, 0x63, 0x74, 0x65, 0x64, 0x29, 0x2c, 0x20, 0x77,
  0x68, 0x69, 0x63, 0x68, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65,
  0x64, 0x2d, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x46, 0x65, 0x62,
  0x72, 0x75, 0x61, 0x72, 0x79, 0x20, 0x6e, 0x75, 0x6d, 0x65, 0x72, 0x6f, 0x75,
  0x73, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x63, 0x6f,
  0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x66, 0x72, 0x61, 0x67, 0x6d, 0x65,
  0x6e, 0x74, 0x73, 0x65, 0x78, 0x63, 0x65, 0x6c, 0x6c, 0x65, 0x6e, 0x74, 0x63,
  0x6f, 0x6c, 0x73, 0x70, 0x61, 0x6e, 0x3d, 0x22, 0x74, 0x65, 0x63, 0x68, 0x6e,
  0x69, 0x63, 0x61, 0x6c, 0x6e, 0x65, 0x61, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x20, 0x73, 0x6f, 0x75, 0x72,
  0x63, 0x65, 0x20, 0x6f, 0x66, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x65,
  0x64, 0x48, 0x6f, 0x6e, 0x67, 0x20, 0x4b, 0x6f, 0x6e, 0x67, 0x20, 0x46, 0x61,
  0x63, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c,
  0x65, 0x20, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x6d, 0x65, 0x6c,
  0x65, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x66, 0x66, 0x65, 0x6e, 0x73,
  0x69, 0x76, 0x65, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x3e, 0x0a, 0x09, 0x73,
  0x70, 0x6f, 0x6e, 0x73, 0x6f, 0x72, 0x65, 0x64, 0x64, 0x6f, 0x63, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x2e, 0x6f, 0x72, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b,
  0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x74, 0x68, 0x6f, 0x73,
  0x65, 0x20, 0x77, 0x68, 0x6f, 0x6d, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x73, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x65, 0x73, 0x64, 0x69, 0x66,
  0x66, 0x69, 0x63, 0x75, 0x6c, 0x74, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x74,
  0x65, 0x64, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x63, 0x6f,
  0x6e, 0x76, 0x69, 0x6e, 0x63, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x6d, 0x6f, 0x74,
  0x69, 0x6e, 0x67, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x2e,
  0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x28, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x69, 0x63, 0x61, 0x6c, 0x63, 0x6f, 0x61, 0x6c, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x68, 0x69, 0x73, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x64, 0x65, 0x63, 0x69,
  0x73, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
  0x74, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x65, 0x76, 0x6f,
  0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x2d, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65,
  0x72, 0x22, 0x65, 0x6e, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x6f, 0x61, 0x6c,
  0x6f, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x64, 0x65, 0x6c, 0x69, 0x76, 0x65,
  0x72, 0x65, 0x64, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x21, 0x2d, 0x2d, 0x41,
  0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x70, 0x72, 0x6f, 0x74, 0x65,
  0x63, 0x74, 0x65, 0x64, 0x4e, 0x6f, 0x76, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20,
  0x3c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3e, 0x3c, 0x66, 0x75, 0x72, 0x6e,
  0x69, 0x74, 0x75, 0x72, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74,
  0x20, 0x20, 0x6f, 0x6e, 0x62, 0x6c, 0x75, 0x72, 0x3d, 0x22, 0x73, 0x75, 0x73,
  0x70, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65,
  0x6e, 0x74, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x20, 0x4d, 0x6f,
  0x72, 0x65, 0x6f, 0x76, 0x65, 0x72, 0x2c, 0x61, 0x62, 0x6f, 0x6c, 0x69, 0x73,
  0x68, 0x65, 0x64, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x77,
  0x65, 0x72, 0x65, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x65, 0x6d, 0x6f, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x6e, 0x63, 0x79,
  0x6e, 0x61, 0x72, 0x72, 0x61, 0x74, 0x69, 0x76, 0x65, 0x61, 0x64, 0x76, 0x6f,
  0x63, 0x61, 0x74, 0x65, 0x73, 0x70, 0x78, 0x3b, 0x62, 0x6f, 0x72, 0x64, 0x65,
  0x72, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x64, 0x69, 0x72,
  0x3d, 0x22, 0x6c, 0x74, 0x72, 0x22, 0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x65,
  0x65, 0x73, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x2e, 0x20, 0x73,
  0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73,
  0x73, 0x6f, 0x72, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x73, 0x64,
  0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x53, 0x65, 0x70, 0x74, 0x65,
  0x6d, 0x62, 0x65, 0x72, 0x61, 0x64, 0x64, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x28,
  0x46, 0x61, 0x63, 0x65, 0x62, 0x6f, 0x6f, 0x6b, 0x20, 0x73, 0x75, 0x67, 0x67,
  0x65, 0x73, 0x74, 0x65, 0x64, 0x61, 0x6e, 0x64, 0x20, 0x6c, 0x61, 0x74, 0x65,
  0x72, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x65, 0x6c, 0x61,
  0x62, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x53, 0x6f, 0x6d, 0x65, 0x74, 0x69, 0x6d,
  0x65, 0x73, 0x49, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x65, 0x63, 0x65,
  0x72, 0x74, 0x61, 0x69, 0x6e, 0x6c, 0x79, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
  0x6c, 0x65, 0x64, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x72, 0x73, 0x4a,
  0x65, 0x72, 0x75, 0x73, 0x61, 0x6c, 0x65, 0x6d, 0x74, 0x68, 0x65, 0x79, 0x20,
  0x68, 0x61, 0x76, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x69, 0x6e, 0x67,
  0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x76,
  0x69, 0x6e, 0x63, 0x65, 0x73, 0x67, 0x75, 0x61, 0x72, 0x61, 0x6e, 0x74, 0x65,
  0x65, 0x61, 0x72, 0x62, 0x69, 0x74, 0x72, 0x61, 0x72, 0x79, 0x72, 0x65, 0x63,
  0x6f, 0x67, 0x6e, 0x69, 0x7a, 0x65, 0x77, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x70, 0x78, 0x3b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x74, 0x68,
  0x65, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
  0x6f, 0x75, 0x72, 0x57, 0x68, 0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x65, 0x65,
  0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x62, 0x65, 0x67, 0x61, 0x6e,
  0x20, 0x74, 0x6f, 0x20, 0x69, 0x74, 0x20, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65,
  0x6d, 0x61, 0x67, 0x6e, 0x69, 0x74, 0x75, 0x64, 0x65, 0x6d, 0x75, 0x73, 0x74,
  0x20, 0x68, 0x61, 0x76, 0x65, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61,
  0x6e, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x65, 0x78, 0x74,
  0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x72, 0x65, 0x74, 0x61,
  0x72, 0x79, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x6c, 0x79, 0x6f, 0x63,
  0x63, 0x75, 0x72, 0x72, 0x69, 0x6e, 0x67, 0x76, 0x61, 0x72, 0x69, 0x61, 0x62,
  0x6c, 0x65, 0x73, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x70,
  0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x3c, 0x2f, 0x6c, 0x61, 0x62,
  0x65, 0x6c, 0x3e, 0x3c, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x6b, 0x69, 0x6e, 0x64,
  0x73, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x6f, 0x63, 0x69, 0x65, 0x74, 0x69, 0x65,
  0x73, 0x61, 0x6c, 0x6f, 0x6e, 0x67, 0x73, 0x69, 0x64, 0x65, 0x20, 0x2d, 0x2d,
  0x26, 0x67, 0x74, 0x3b, 0x0a, 0x0a, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x77, 0x65,
  0x73, 0x74, 0x74, 0x68, 0x65, 0x20, 0x72, 0x69, 0x67, 0x68, 0x74, 0x72, 0x61,
  0x64, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x61, 0x79, 0x20, 0x68, 0x61,
  0x76, 0x65, 0x20, 0x75, 0x6e, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x28, 0x73,
  0x70, 0x6f, 0x6b, 0x65, 0x6e, 0x20, 0x69, 0x6e, 0x22, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x2f, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65,
  0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x65,
  0x20, 0x66, 0x72, 0x6f, 0x6d, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72,
  0x79, 0x62, 0x75, 0x72, 0x69, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x61, 0x20, 0x73,
  0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x74, 0x68, 0x65, 0x79, 0x20, 0x77, 0x65,
  0x72, 0x65, 0x3c, 0x2f, 0x66, 0x6f, 0x6e, 0x74, 0x3e, 0x3c, 0x2f, 0x4e, 0x6f,
  0x72, 0x77, 0x65, 0x67, 0x69, 0x61, 0x6e, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66,
  0x69, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x69, 0x6e, 0x67, 0x70,
  0x61, 0x73, 0x73, 0x65, 0x6e, 0x67, 0x65, 0x72, 0x28, 0x6e, 0x65, 0x77, 0x20,
  0x44, 0x61, 0x74, 0x65, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x79,
  0x66, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x41, 0x66, 0x74, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x65, 0x71, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x64, 0x6f, 0x77, 0x6e, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x72, 0x65, 0x67,
  0x75, 0x6c, 0x61, 0x72, 0x6c, 0x79, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
  0x65, 0x72, 0x61, 0x62, 0x6f, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x6c, 0x69,
  0x6e, 0x6b, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x70, 0x68, 0x65, 0x6e, 0x6f, 0x6d,
  0x65, 0x6e, 0x61, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x20, 0x6f, 0x66, 0x74,
  0x6f, 0x6f, 0x6c, 0x74, 0x69, 0x70, 0x22, 0x3e, 0x73, 0x75, 0x62, 0x73, 0x74,
  0x61, 0x6e, 0x63, 0x65, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63,
  0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x20, 0x6f, 0x66, 0x41, 0x6d, 0x6f, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65,
  0x64, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x73, 0x41, 0x69, 0x72,
  0x20, 0x46, 0x6f, 0x72, 0x63, 0x65, 0x73, 0x79, 0x73, 0x74, 0x65, 0x6d, 0x20,
  0x6f, 0x66, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x69, 0x6d,
  0x6d, 0x65, 0x64, 0x69, 0x61, 0x74, 0x65, 0x6d, 0x61, 0x6b, 0x69, 0x6e, 0x67,
  0x20, 0x69, 0x74, 0x70, 0x61, 0x69, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x63,
  0x6f, 0x6e, 0x71, 0x75, 0x65, 0x72, 0x65, 0x64, 0x61, 0x72, 0x65, 0x20, 0x73,
  0x74, 0x69, 0x6c, 0x6c, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x64, 0x75, 0x72, 0x65,
  0x67, 0x72, 0x6f, 0x77, 0x74, 0x68, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x61, 0x64,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x61, 0x6e,
  0x20, 0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x6d, 0x6f, 0x6c,
  0x65, 0x63, 0x75, 0x6c, 0x65, 0x73, 0x66, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x69,
  0x73, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x74,
  0x74, 0x72, 0x61, 0x63, 0x74, 0x65, 0x64, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x68,
  0x6f, 0x6f, 0x64, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x75, 0x73, 0x65, 0x64, 0x64,
  0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x73, 0x69, 0x6e, 0x67, 0x61,
  0x70, 0x6f, 0x72, 0x65, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65, 0x20, 0x6f, 0x66,
  0x66, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x66,
  0x6c, 0x69, 0x63, 0x74, 0x73, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x70, 0x3e,
  0x0a, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x77, 0x65, 0x72,
  0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x6e, 0x6f, 0x74, 0x65, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x45, 0x78,
  0x65, 0x63, 0x75, 0x74, 0x69, 0x76, 0x65, 0x65, 0x76, 0x65, 0x6e, 0x20, 0x6d,
  0x6f, 0x72, 0x65, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x74, 0x6f, 0x63,
  0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x65, 0x72, 0x50, 0x6f, 0x6c, 0x69, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x6d, 0x75, 0x73, 0x69, 0x63, 0x69, 0x61, 0x6e, 0x73,
  0x64, 0x65, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x70, 0x72, 0x69, 0x73,
  0x6f, 0x6e, 0x65, 0x72, 0x73, 0x61, 0x64, 0x76, 0x65, 0x6e, 0x74, 0x20, 0x6f,
  0x66, 0x55, 0x54, 0x46, 0x2d, 0x38, 0x22, 0x20, 0x2f, 0x3e, 0x3c, 0x21, 0x5b,
  0x43, 0x44, 0x41, 0x54, 0x41, 0x5b, 0x22, 0x3e, 0x43, 0x6f, 0x6e, 0x74, 0x61,
  0x63, 0x74, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x65, 0x72, 0x6e, 0x20, 0x62, 0x67,
  0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3d, 0x22, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73,
  0x20, 0x6f, 0x66, 0x2e, 0x20, 0x49, 0x74, 0x20, 0x77, 0x61, 0x73, 0x20, 0x69,
  0x6e, 0x20, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x70, 0x65, 0x72, 0x6d, 0x69,
  0x74, 0x74, 0x65, 0x64, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x65, 0x2e,
  0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x69, 0x6e, 0x67, 0x6f, 0x66, 0x66, 0x69,
  0x63, 0x69, 0x61, 0x6c, 0x73, 0x73, 0x65, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x6c,
  0x79, 0x2d, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x69, 0x6e, 0x69,
  0x74, 0x69, 0x61, 0x74, 0x65, 0x64, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x64, 0x69,
  0x6e, 0x67, 0x6c, 0x6f, 0x6e, 0x67, 0x2d, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x66, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x63, 0x68, 0x20, 0x74,
  0x68, 0x61, 0x74, 0x67, 0x65, 0x74, 0x43, 0x6f, 0x6f, 0x6b, 0x69, 0x65, 0x6d,
  0x61, 0x72, 0x6b, 0x65, 0x64, 0x20, 0x62, 0x79, 0x3c, 0x2f, 0x62, 0x75, 0x74,
  0x74, 0x6f, 0x6e, 0x3e, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x62, 0x75, 0x74, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73, 0x69, 0x6e, 0x63, 0x72,
  0x65, 0x61, 0x73, 0x65, 0x73, 0x64, 0x6f, 0x77, 0x6e, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x70,
  0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x2d, 0x2d, 0x3e, 0x0a, 0x3c, 0x21, 0x2d,
  0x2d, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77, 0x57, 0x69,
  0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x70, 0x69, 0x65, 0x73,
  0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x73, 0x75, 0x73, 0x77,
  0x61, 0x73, 0x20, 0x62, 0x75, 0x69, 0x6c, 0x74, 0x56, 0x65, 0x6e, 0x65, 0x7a,
  0x75, 0x65, 0x6c, 0x61, 0x28, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x72, 0x6c, 0x79,
  0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x61, 0x74, 0x65, 0x70, 0x65, 0x72, 0x73,
  0x6f, 0x6e, 0x6e, 0x65, 0x6c, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x69,
  0x63, 0x66, 0x61, 0x76, 0x6f, 0x75, 0x72, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x76,
  0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x57, 0x69, 0x6b, 0x69, 0x70, 0x65, 0x64,
  0x69, 0x61, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x65, 0x6e, 0x74, 0x76, 0x69,
  0x72, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20,
  0x77, 0x61, 0x73, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x6c, 0x65, 0x43,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x20, 0x69, 0x64, 0x65, 0x6e, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x73, 0x68, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x70, 0x72, 0x69, 0x6d, 0x69, 0x74, 0x69, 0x76, 0x65, 0x61, 0x77, 0x61, 0x79,
  0x20, 0x66, 0x72, 0x6f, 0x6d, 0x6d, 0x6f, 0x6c, 0x65, 0x63, 0x75, 0x6c, 0x61,
  0x72, 0x70, 0x72, 0x65, 0x63, 0x69, 0x73, 0x65, 0x6c, 0x79, 0x64, 0x69, 0x73,
  0x73, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x55, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x3e, 0x26,
  0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x2f, 0x49, 0x74, 0x20, 0x69, 0x73, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x54, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x77,
  0x69, 0x6c, 0x6c, 0x20, 0x68, 0x61, 0x76, 0x65, 0x6f, 0x72, 0x67, 0x61, 0x6e,
  0x69, 0x73, 0x6d, 0x73, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65,
  0x46, 0x72, 0x69, 0x65, 0x64, 0x72, 0x69, 0x63, 0x68, 0x77, 0x61, 0x73, 0x20,
  0x66, 0x69, 0x72, 0x73, 0x74, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x6c, 0x79,
  0x20, 0x66, 0x61, 0x63, 0x74, 0x20, 0x74, 0x68, 0x61, 0x74, 0x66, 0x6f, 0x72,
  0x6d, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64, 0x69,
  0x6e, 0x67, 0x54, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x70, 0x68,
  0x79, 0x73, 0x69, 0x63, 0x69, 0x73, 0x74, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x73,
  0x20, 0x69, 0x6e, 0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x73,
  0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x73, 0x70, 0x61, 0x6e, 0x20,
  0x69, 0x64, 0x3d, 0x22, 0x73, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x20, 0x74, 0x6f,
  0x62, 0x65, 0x6c, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x72, 0x76,
  0x69, 0x76, 0x69, 0x6e, 0x67, 0x7d, 0x3c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3e, 0x68, 0x69, 0x73, 0x20, 0x64, 0x65, 0x61, 0x74, 0x68, 0x61, 0x73, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x70, 0x61, 0x72, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x65, 0x78,
  0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x75, 0x73, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x65, 0x77, 0x61, 0x73, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x61,
  0x20, 0x6c, 0x69, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x6c, 0x65, 0x76, 0x65, 0x6c,
  0x73, 0x20, 0x6f, 0x66, 0x6e, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x4f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x64, 0x69, 0x73, 0x6d,
  0x69, 0x73, 0x73, 0x65, 0x64, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x73,
  0x74, 0x72, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x65, 0x73, 0x64, 0x75, 0x70,
  0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x65, 0x78, 0x70, 0x6c, 0x6f, 0x73, 0x69,
  0x76, 0x65, 0x72, 0x65, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x61, 0x6c,
  0x6c, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x67, 0x61, 0x6c, 0x6c, 0x65, 0x72,
  0x69, 0x65, 0x73, 0x7b, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x67, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x73,
  0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x69, 0x6d, 0x67, 0x20,
  0x61, 0x6c, 0x74, 0x3d, 0x22, 0x69, 0x6e, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x72,
  0x6e, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65, 0x6d, 0x65, 0x74,
  0x68, 0x6f, 0x64, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x69,
  0x6e, 0x67, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x6e, 0x65,
  0x65, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x74, 0x68, 0x65, 0x20, 0x47, 0x72,
  0x65, 0x61, 0x74, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73,
  0x65, 0x65, 0x6d, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x76, 0x69, 0x65, 0x77, 0x65,
  0x64, 0x20, 0x61, 0x73, 0x69, 0x6d, 0x70, 0x61, 0x63, 0x74, 0x20, 0x6f, 0x6e,
  0x69, 0x64, 0x65, 0x61, 0x20, 0x74, 0x68, 0x61, 0x74, 0x74, 0x68, 0x65, 0x20,
  0x57, 0x6f, 0x72, 0x6c, 0x64, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x20, 0x6f,
  0x66, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x54, 0x68, 0x65,
  0x73, 0x65, 0x20, 0x61, 0x72, 0x65, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
  0x22, 0x3e, 0x63, 0x61, 0x72, 0x65, 0x66, 0x75, 0x6c, 0x6c, 0x79, 0x6d, 0x61,
  0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x63, 0x68, 0x61, 0x72, 0x67, 0x65,
  0x20, 0x6f, 0x66, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x61,
  0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x70, 0x72, 0x65, 0x64, 0x69,
  0x63, 0x74, 0x65, 0x64, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x72, 0x69, 0x67, 0x68,
  0x74, 0x22, 0x3e, 0x0d, 0x0a, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x63,
  0x65, 0x6c, 0x65, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e,
  0x74, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0x61, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x74,
  0x65, 0x6e, 0x20, 0x20, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x0d, 0x0a, 0x70, 0x72,
  0x6f, 0x62, 0x61, 0x62, 0x6c, 0x79, 0x20, 0x50, 0x72, 0x6f, 0x66, 0x65, 0x73,
  0x73, 0x6f, 0x72, 0x2d, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x22, 0x20, 0x72,
  0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64, 0x65, 0x64, 0x73, 0x61, 0x79, 0x73, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x68, 0x61, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65,
  0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x48, 0x75, 0x6e, 0x67,
  0x61, 0x72, 0x69, 0x61, 0x6e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x20, 0x6f,
  0x66, 0x73, 0x65, 0x72, 0x76, 0x65, 0x73, 0x20, 0x61, 0x73, 0x55, 0x6e, 0x69,
  0x76, 0x65, 0x72, 0x73, 0x61, 0x6c, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x67, 0x67, 0x72, 0x65, 0x67, 0x61, 0x74, 0x65, 0x66, 0x6f,
  0x72, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x69, 0x6e, 0x66, 0x65, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x67, 0x72, 0x65, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x68,
  0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c,
  0x61, 0x72, 0x22, 0x3e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x6f, 0x6e,
  0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x65, 0x6c, 0x65, 0x63,
  0x74, 0x6f, 0x72, 0x61, 0x6c, 0x73, 0x79, 0x6d, 0x62, 0x6f, 0x6c, 0x20, 0x6f,
  0x66, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x74,
  0x75, 0x72, 0x6e, 0x20, 0x74, 0x6f, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65,
  0x63, 0x74, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6e, 0x70, 0x72,
  0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x20, 0x6c, 0x69, 0x76, 0x69, 0x6e, 0x67,
  0x20, 0x69, 0x6e, 0x65, 0x61, 0x73, 0x69, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x70,
  0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x0a, 0x26, 0x6c, 0x74, 0x3b,
  0x21, 0x2d, 0x2d, 0x20, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x20, 0x6f, 0x66,
  0x61, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63, 0x73, 0x77, 0x61, 0x73, 0x20,
  0x74, 0x61, 0x6b, 0x65, 0x6e, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x74, 0x68,
  0x65, 0x74, 0x6f, 0x6f, 0x6b, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x62, 0x65, 0x6c,
  0x69, 0x65, 0x66, 0x20, 0x69, 0x6e, 0x41, 0x66, 0x72, 0x69, 0x6b, 0x61, 0x61,
  0x6e, 0x73, 0x61, 0x73, 0x20, 0x66, 0x61, 0x72, 0x20, 0x61, 0x73, 0x70, 0x72,
  0x65, 0x76, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x77, 0x6f, 0x72, 0x6b, 0x20, 0x77,
  0x69, 0x74, 0x68, 0x61, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x3c,
  0x66, 0x69, 0x65, 0x6c, 0x64, 0x73, 0x65, 0x74, 0x43, 0x68, 0x72, 0x69, 0x73,
  0x74, 0x6d, 0x61, 0x73, 0x52, 0x65, 0x74, 0x72, 0x69, 0x65, 0x76, 0x65, 0x64,
  0x0a, 0x0a, 0x49, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x63, 0x6b,
  0x20, 0x69, 0x6e, 0x74, 0x6f, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x61, 0x73,
  0x74, 0x6d, 0x61, 0x67, 0x61, 0x7a, 0x69, 0x6e, 0x65, 0x73, 0x3e, 0x3c, 0x73,
  0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x74,
  0x65, 0x65, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x67, 0x72,
  0x6f, 0x75, 0x70, 0x73, 0x20, 0x6f, 0x66, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x61,
  0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x69, 0x74, 0x73, 0x20, 0x66,
  0x69, 0x72, 0x73, 0x74, 0x74, 0x68, 0x65, 0x69, 0x72, 0x20, 0x6f, 0x77, 0x6e,
  0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x61, 0x6e, 0x20, 0x6f,
  0x62, 0x6a, 0x65, 0x63, 0x74, 0x43, 0x61, 0x72, 0x69, 0x62, 0x62, 0x65, 0x61,
  0x6e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x20, 0x74, 0x68, 0x65, 0x64, 0x69, 0x73,
  0x74, 0x72, 0x69, 0x63, 0x74, 0x73, 0x77, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x73,
  0x69, 0x6e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x3b, 0x20,
  0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x20, 0x69, 0x6e, 0x68, 0x61, 0x62, 0x69,
  0x74, 0x65, 0x64, 0x53, 0x6f, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x73, 0x74, 0x4a,
  0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x20, 0x31, 0x3c, 0x2f, 0x66, 0x6f, 0x6f,
  0x74, 0x65, 0x72, 0x3e, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x6c, 0x79,
  0x63, 0x68, 0x6f, 0x69, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20,
  0x73, 0x61, 0x6d, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,
  0x20, 0x62, 0x75, 0x73, 0x69, 0x6e, 0x65, 0x73, 0x73, 0x20, 0x54, 0x68, 0x65,
  0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x2e, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68,
  0x3b, 0x20, 0x64, 0x65, 0x73, 0x69, 0x72, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x65,
  0x61, 0x6c, 0x20, 0x77, 0x69, 0x74, 0x68, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x75, 0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x63,
  0x6f, 0x6e, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x69, 0x6e, 0x64, 0x65, 0x78,
  0x2e, 0x70, 0x68, 0x70, 0x61, 0x73, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b,
  0x65, 0x6e, 0x67, 0x61, 0x67, 0x65, 0x20, 0x69, 0x6e, 0x72, 0x65, 0x63, 0x65,
  0x6e, 0x74, 0x6c, 0x79, 0x2c, 0x66, 0x65, 0x77, 0x20, 0x79, 0x65, 0x61, 0x72,
  0x73, 0x77, 0x65, 0x72, 0x65, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x0a, 0x3c, 0x68,
  0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c, 0x65, 0x64, 0x69, 0x74, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x61, 0x72, 0x65, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x63, 0x69,
  0x74, 0x69, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
  0x6b, 0x65, 0x79, 0x63, 0x6f, 0x6e, 0x64, 0x65, 0x6d, 0x6e, 0x65, 0x64, 0x61,
  0x6c, 0x73, 0x6f, 0x20, 0x68, 0x61, 0x76, 0x65, 0x73, 0x65, 0x72, 0x76, 0x69,
  0x63, 0x65, 0x73, 0x2c, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x20, 0x6f, 0x66,
  0x53, 0x63, 0x68, 0x6f, 0x6f, 0x6c, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x76,
  0x65, 0x72, 0x74, 0x65, 0x64, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x6d, 0x69, 0x6e,
  0x69, 0x73, 0x74, 0x65, 0x72, 0x73, 0x3c, 0x2f, 0x6f, 0x62, 0x6a, 0x65, 0x63,
  0x74, 0x3e, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73, 0x20, 0x61, 0x20,
  0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e,
  0x63, 0x65, 0x73, 0x61, 0x64, 0x76, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x54,
  0x68, 0x65, 0x79, 0x20, 0x77, 0x65, 0x72, 0x65, 0x61, 0x6e, 0x79, 0x20, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
  0x65, 0x6e, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x75, 0x63, 0x68,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x72, 0x65, 0x66, 0x6c, 0x65, 0x63, 0x74, 0x65,
  0x64, 0x77, 0x61, 0x73, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x6f, 0x72, 0x69,
  0x67, 0x69, 0x6e, 0x61, 0x6c, 0x20, 0x61, 0x20, 0x74, 0x79, 0x70, 0x69, 0x63,
  0x61, 0x6c, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x79, 0x65, 0x6e,
  0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x73, 0x63, 0x6f, 0x75, 0x6c, 0x64, 0x20,
  0x6e, 0x6f, 0x74, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x77,
  0x65, 0x64, 0x6e, 0x65, 0x73, 0x64, 0x61, 0x79, 0x74, 0x68, 0x65, 0x20, 0x74,
  0x68, 0x69, 0x72, 0x64, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x73,
  0x4a, 0x61, 0x6e, 0x75, 0x61, 0x72, 0x79, 0x20, 0x32, 0x77, 0x68, 0x61, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x79, 0x61, 0x20, 0x63, 0x65, 0x72, 0x74, 0x61, 0x69,
  0x6e, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x72, 0x6f,
  0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x68,
  0x69, 0x73, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61, 0x73, 0x74, 0x20, 0x63, 0x6f,
  0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x22, 0x3e, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x64,
  0x65, 0x70, 0x65, 0x6e, 0x64, 0x20, 0x6f, 0x6e, 0x73, 0x65, 0x61, 0x72, 0x63,
  0x68, 0x22, 0x3e, 0x0a, 0x70, 0x69, 0x65, 0x63, 0x65, 0x73, 0x20, 0x6f, 0x66,
  0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x6e, 0x67, 0x52, 0x65, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x63, 0x65, 0x74, 0x65, 0x6e, 0x6e, 0x65, 0x73, 0x73, 0x65,
  0x65, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x68, 0x61, 0x73, 0x20, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x6f, 0x6e, 0x3d, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e,
  0x20, 0x3c, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x3e, 0x67, 0x69,
  0x76, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72,
  0x69, 0x61, 0x6e, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x22, 0x3e, 0x70,
  0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a, 0x30, 0x76, 0x69, 0x65, 0x77, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68, 0x65, 0x72, 0x2c,
  0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x77, 0x61, 0x73, 0x20,
  0x66, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x75, 0x62, 0x73, 0x65, 0x74, 0x20, 0x6f,
  0x66, 0x61, 0x74, 0x74, 0x61, 0x63, 0x6b, 0x20, 0x6f, 0x6e, 0x63, 0x68, 0x69,
  0x6c, 0x64, 0x72, 0x65, 0x6e, 0x2c, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x73, 0x20,
  0x6f, 0x66, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x70, 0x6f,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x65,
  0x64, 0x6c, 0x79, 0x43, 0x6c, 0x65, 0x76, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x77,
  0x61, 0x73, 0x20, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x20, 0x61,
  0x66, 0x74, 0x65, 0x72, 0x61, 0x72, 0x65, 0x20, 0x67, 0x69, 0x76, 0x65, 0x6e,
  0x77, 0x61, 0x73, 0x20, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x73, 0x63, 0x72, 0x6f,
  0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x20, 0x6f,
  0x66, 0x6d, 0x61, 0x6b, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x75, 0x63,
  0x68, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61,
  0x6e, 0x73, 0x2e, 0x0a, 0x0a, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x2c, 0x20,
  0x62, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x4d, 0x75, 0x73, 0x65, 0x75, 0x6d,
  0x20, 0x6f, 0x66, 0x6c, 0x6f, 0x75, 0x69, 0x73, 0x69, 0x61, 0x6e, 0x61, 0x28,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x69, 0x6e, 0x6e, 0x65,
  0x73, 0x6f, 0x74, 0x61, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x73,
  0x61, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x44, 0x6f, 0x6d, 0x69,
  0x6e, 0x69, 0x63, 0x61, 0x6e, 0x76, 0x6f, 0x6c, 0x75, 0x6d, 0x65, 0x20, 0x6f,
  0x66, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x66,
  0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x30, 0x30, 0x70, 0x78, 0x7c, 0x72, 0x69,
  0x67, 0x68, 0x6d, 0x61, 0x64, 0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x6d, 0x6f,
  0x75, 0x73, 0x65, 0x6f, 0x76, 0x65, 0x72, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x3d, 0x22, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x28,
  0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x69,
  0x6e, 0x75, 0x65, 0x73, 0x46, 0x72, 0x61, 0x6e, 0x63, 0x69, 0x73, 0x63, 0x6f,
  0x62, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68,
  0x6f, 0x75, 0x74, 0x20, 0x61, 0x77, 0x69, 0x74, 0x68, 0x20, 0x73, 0x6f, 0x6d,
  0x65, 0x77, 0x68, 0x6f, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x61, 0x20, 0x66,
  0x6f, 0x72, 0x6d, 0x20, 0x6f, 0x66, 0x61, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20,
  0x6f, 0x66, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x69, 0x74, 0x6b, 0x6e,
  0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x20, 0x20, 0x53, 0x65, 0x72, 0x76, 0x69,
  0x63, 0x65, 0x73, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61,
  0x6e, 0x64, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x6d, 0x65, 0x61, 0x73, 0x75,
  0x72, 0x69, 0x6e, 0x67, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73,
  0x70, 0x61, 0x70, 0x65, 0x72, 0x62, 0x61, 0x63, 0x6b, 0x76, 0x61, 0x6c, 0x75,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x0d, 0x0a, 0x3c, 0x74, 0x69, 0x74, 0x6c, 0x65,
  0x3e, 0x3d, 0x20, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x64, 0x65, 0x74,
  0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x26, 0x71, 0x75, 0x6f, 0x74,
  0x3b, 0x20, 0x70, 0x6c, 0x61, 0x79, 0x65, 0x64, 0x20, 0x62, 0x79, 0x61, 0x6e,
  0x64, 0x20, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x3c, 0x2f, 0x63, 0x65, 0x6e, 0x74,
  0x65, 0x72, 0x3e, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x69, 0x73, 0x74,
  0x68, 0x65, 0x20, 0x74, 0x68, 0x72, 0x65, 0x65, 0x70, 0x6f, 0x77, 0x65, 0x72,
  0x20, 0x61, 0x6e, 0x64, 0x6f, 0x66, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b,
  0x69, 0x6e, 0x6e, 0x65, 0x72, 0x48, 0x54, 0x4d, 0x4c, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x79, 0x3a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65,
  0x3b, 0x43, 0x68, 0x75, 0x72, 0x63, 0x68, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65,
  0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x76, 0x65, 0x72, 0x79, 0x20, 0x68, 0x69,
  0x67, 0x68, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x2d, 0x68,
  0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x3d, 0x22, 0x2f, 0x63, 0x67, 0x69, 0x2d, 0x62, 0x69, 0x6e, 0x2f, 0x74,
  0x6f, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x61, 0x66, 0x72, 0x69, 0x6b,
  0x61, 0x61, 0x6e, 0x73, 0x65, 0x73, 0x70, 0x65, 0x72, 0x61, 0x6e, 0x74, 0x6f,
  0x66, 0x72, 0x61, 0x6e, 0xc3, 0xa7, 0x61, 0x69, 0x73, 0x6c, 0x61, 0x74, 0x76,
  0x69, 0x65, 0xc5, 0xa1, 0x75, 0x6c, 0x69, 0x65, 0x74, 0x75, 0x76, 0x69, 0xc5,
  0xb3, 0xc4, 0x8c, 0x65, 0xc5, 0xa1, 0x74, 0x69, 0x6e, 0x61, 0xc4, 0x8d, 0x65,
  0xc5, 0xa1, 0x74, 0x69, 0x6e, 0x61, 0xe0, 0xb9, 0x84, 0xe0, 0xb8, 0x97, 0xe0,
  0xb8, 0xa2, 0xe6, 0x97, 0xa5, 0xe6, 0x9c, 0xac, 0xe8, 0xaa, 0x9e, 0xe7, 0xae,
  0x80, 0xe4, 0xbd, 0x93, 0xe5, 0xad, 0x97, 0xe7, 0xb9, 0x81, 0xe9, 0xab, 0x94,
  0xe5, 0xad, 0x97, 0xed, 0x95, 0x9c, 0xea, 0xb5, 0xad, 0xec, 0x96, 0xb4, 0xe4,
  0xb8, 0xba, 0xe4, 0xbb, 0x80, 0xe4, 0xb9, 0x88, 0xe8, 0xae, 0xa1, 0xe7, 0xae,
  0x97, 0xe6, 0x9c, 0xba, 0xe7, 0xac, 0x94, 0xe8, 0xae, 0xb0, 0xe6, 0x9c, 0xac,
  0xe8, 0xa8, 0x8e, 0xe8, 0xab, 0x96, 0xe5, 0x8d, 0x80, 0xe6, 0x9c, 0x8d, 0xe5,
  0x8a, 0xa1, 0xe5, 0x99, 0xa8, 0xe4, 0xba, 0x92, 0xe8, 0x81, 0x94, 0xe7, 0xbd,
  0x91, 0xe6, 0x88, 0xbf, 0xe5, 0x9c, 0xb0, 0xe4, 0xba, 0xa7, 0xe4, 0xbf, 0xb1,
  0xe4, 0xb9, 0x90, 0xe9, 0x83, 0xa8, 0xe5, 0x87, 0xba, 0xe7, 0x89, 0x88, 0xe7,
  0xa4, 0xbe, 0xe6, 0x8e, 0x92, 0xe8, 0xa1, 0x8c, 0xe6, 0xa6, 0x9c, 0xe9, 0x83,
  0xa8, 0xe8, 0x90, 0xbd, 0xe6, 0xa0, 0xbc, 0xe8, 0xbf, 0x9b, 0xe4, 0xb8, 0x80,
  0xe6, 0xad, 0xa5, 0xe6, 0x94, 0xaf, 0xe4, 0xbb, 0x98, 0xe5, 0xae, 0x9d, 0xe9,
  0xaa, 0x8c, 0xe8, 0xaf, 0x81, 0xe7, 0xa0, 0x81, 0xe5, 0xa7, 0x94, 0xe5, 0x91,
  0x98, 0xe4, 0xbc, 0x9a, 0xe6, 0x95, 0xb0, 0xe6, 0x8d, 0xae, 0xe5, 0xba, 0x93,
  0xe6, 0xb6, 0x88, 0xe8, 0xb4, 0xb9, 0xe8, 0x80, 0x85, 0xe5, 0x8a, 0x9e, 0xe5,
  0x85, 0xac, 0xe5, 0xae, 0xa4, 0xe8, 0xae, 0xa8, 0xe8, 0xae, 0xba, 0xe5, 0x8c,
  0xba, 0xe6, 0xb7, 0xb1, 0xe5, 0x9c, 0xb3, 0xe5, 0xb8, 0x82, 0xe6, 0x92, 0xad,
  0xe6, 0x94, 0xbe, 0xe5, 0x99, 0xa8, 0xe5, 0x8c, 0x97, 0xe4, 0xba, 0xac, 0xe5,
  0xb8, 0x82, 0xe5, 0xa4, 0xa7, 0xe5, 0xad, 0xa6, 0xe7, 0x94, 0x9f, 0xe8, 0xb6,
  0x8a, 0xe6, 0x9d, 0xa5, 0xe8, 0xb6, 0x8a, 0xe7, 0xae, 0xa1, 0xe7, 0x90, 0x86,
  0xe5, 0x91, 0x98, 0xe4, 0xbf, 0xa1, 0xe6, 0x81, 0xaf, 0xe7, 0xbd, 0x91, 0x73,
  0x65, 0x72, 0x76, 0x69, 0x63, 0x69, 0x6f, 0x73, 0x61, 0x72, 0x74, 0xc3, 0xad,
  0x63, 0x75, 0x6c, 0x6f, 0x61, 0x72, 0x67, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x61,
  0x62, 0x61, 0x72, 0x63, 0x65, 0x6c, 0x6f, 0x6e, 0x61, 0x63, 0x75, 0x61, 0x6c,
  0x71, 0x75, 0x69, 0x65, 0x72, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x64,
  0x6f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x6f, 0x73, 0x70, 0x6f, 0x6c,
  0xc3, 0xad, 0x74, 0x69, 0x63, 0x61, 0x72, 0x65, 0x73, 0x70, 0x75, 0x65, 0x73,
  0x74, 0x61, 0x77, 0x69, 0x6b, 0x69, 0x70, 0x65, 0x64, 0x69, 0x61, 0x73, 0x69,
  0x67, 0x75, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x62, 0xc3, 0xba, 0x73, 0x71, 0x75,
  0x65, 0x64, 0x61, 0x63, 0x6f, 0x6d, 0x75, 0x6e, 0x69, 0x64, 0x61, 0x64, 0x73,
  0x65, 0x67, 0x75, 0x72, 0x69, 0x64, 0x61, 0x64, 0x70, 0x72, 0x69, 0x6e, 0x63,
  0x69, 0x70, 0x61, 0x6c, 0x70, 0x72, 0x65, 0x67, 0x75, 0x6e, 0x74, 0x61, 0x73,
  0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x69, 0x64, 0x6f, 0x72, 0x65, 0x73, 0x70,
  0x6f, 0x6e, 0x64, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x65, 0x7a, 0x75, 0x65, 0x6c,
  0x61, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x61, 0x73, 0x64, 0x69, 0x63,
  0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x72, 0x65, 0x6c, 0x61, 0x63, 0x69, 0xc3,
  0xb3, 0x6e, 0x6e, 0x6f, 0x76, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x73, 0x69,
  0x6d, 0x69, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x79, 0x65, 0x63,
  0x74, 0x6f, 0x73, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x61, 0x73, 0x69,
  0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x6f, 0x61, 0x63, 0x74, 0x69, 0x76,
  0x69, 0x64, 0x61, 0x64, 0x65, 0x6e, 0x63, 0x75, 0x65, 0x6e, 0x74, 0x72, 0x61,
  0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0xc3, 0xad, 0x61, 0x69, 0x6d, 0xc3, 0xa1,
  0x67, 0x65, 0x6e, 0x65, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x61,
  0x72, 0x64, 0x65, 0x73, 0x63, 0x61, 0x72, 0x67, 0x61, 0x72, 0x6e, 0x65, 0x63,
  0x65, 0x73, 0x61, 0x72, 0x69, 0x6f, 0x61, 0x74, 0x65, 0x6e, 0x63, 0x69, 0xc3,
  0xb3, 0x6e, 0x74, 0x65, 0x6c, 0xc3, 0xa9, 0x66, 0x6f, 0x6e, 0x6f, 0x63, 0x6f,
  0x6d, 0x69, 0x73, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x61, 0x6e, 0x63, 0x69, 0x6f,
  0x6e, 0x65, 0x73, 0x63, 0x61, 0x70, 0x61, 0x63, 0x69, 0x64, 0x61, 0x64, 0x65,
  0x6e, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x72, 0x61, 0x6e, 0xc3, 0xa1, 0x6c,
  0x69, 0x73, 0x69, 0x73, 0x66, 0x61, 0x76, 0x6f, 0x72, 0x69, 0x74, 0x6f, 0x73,
  0x74, 0xc3, 0xa9, 0x72, 0x6d, 0x69, 0x6e, 0x6f, 0x73, 0x70, 0x72, 0x6f, 0x76,
  0x69, 0x6e, 0x63, 0x69, 0x61, 0x65, 0x74, 0x69, 0x71, 0x75, 0x65, 0x74, 0x61,
  0x73, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x73, 0x66, 0x75, 0x6e,
  0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x61,
  0x64, 0x6f, 0x63, 0x61, 0x72, 0xc3, 0xa1, 0x63, 0x74, 0x65, 0x72, 0x70, 0x72,
  0x6f, 0x70, 0x69, 0x65, 0x64, 0x61, 0x64, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69,
  0x70, 0x69, 0x6f, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x69, 0x64, 0x61, 0x64, 0x6d,
  0x75, 0x6e, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x63, 0x72, 0x65, 0x61, 0x63,
  0x69, 0xc3, 0xb3, 0x6e, 0x64, 0x65, 0x73, 0x63, 0x61, 0x72, 0x67, 0x61, 0x73,
  0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x63, 0x6f, 0x6d, 0x65,
  0x72, 0x63, 0x69, 0x61, 0x6c, 0x6f, 0x70, 0x69, 0x6e, 0x69, 0x6f, 0x6e, 0x65,
  0x73, 0x65, 0x6a, 0x65, 0x72, 0x63, 0x69, 0x63, 0x69, 0x6f, 0x65, 0x64, 0x69,
  0x74, 0x6f, 0x72, 0x69, 0x61, 0x6c, 0x73, 0x61, 0x6c, 0x61, 0x6d, 0x61, 0x6e,
  0x63, 0x61, 0x67, 0x6f, 0x6e, 0x7a, 0xc3, 0xa1, 0x6c, 0x65, 0x7a, 0x64, 0x6f,
  0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x70, 0x65, 0x6c, 0xc3, 0xad, 0x63,
  0x75, 0x6c, 0x61, 0x72, 0x65, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x73, 0x67,
  0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x65, 0x73, 0x74, 0x61, 0x72, 0x72, 0x61,
  0x67, 0x6f, 0x6e, 0x61, 0x70, 0x72, 0xc3, 0xa1, 0x63, 0x74, 0x69, 0x63, 0x61,
  0x6e, 0x6f, 0x76, 0x65, 0x64, 0x61, 0x64, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x70,
  0x75, 0x65, 0x73, 0x74, 0x61, 0x70, 0x61, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x65,
  0x73, 0x74, 0xc3, 0xa9, 0x63, 0x6e, 0x69, 0x63, 0x61, 0x73, 0x6f, 0x62, 0x6a,
  0x65, 0x74, 0x69, 0x76, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74,
  0x6f, 0x73, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x88,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4,
  0xb5, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0x95, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0x9b, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xad, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x88,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0x64, 0x69, 0x70, 0x6c, 0x6f,
  0x64, 0x6f, 0x63, 0x73, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xaf,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xab, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x94,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0x96, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb5, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xae,
  0xe0, 0xa5, 0x8c, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4,
  0x9c, 0xe0, 0xa5, 0x89, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x97,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xad, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0x97, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0x97,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xae, 0xe0,
  0xa4, 0x96, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xad, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa4, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0x9f, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x85,
  0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x90, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x8a, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0x9a, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x90, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xa6, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9,
  0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x96, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xac, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0x86, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb2,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x89, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xad, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x97, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0x95, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa0, 0xe0, 0xa5,
  0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x81,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xa4, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0x86,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x95, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8c, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0x96, 0xe0, 0xa5,
  0x81, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x80,
  0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x65, 0x78, 0x70,
  0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x3c, 0x2f, 0x74, 0x69, 0x74, 0x6c,
  0x65, 0x3e, 0x0d, 0x0a, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74,
  0x20, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x63, 0x6f,
  0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x76, 0x65, 0x72, 0x79,
  0x74, 0x68, 0x69, 0x6e, 0x67, 0x3c, 0x70, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x62,
  0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x3c, 0x61, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x26, 0x63, 0x6f, 0x70, 0x79, 0x3b, 0x20, 0x32, 0x30, 0x31,
  0x6a, 0x61, 0x76, 0x61, 0x53, 0x63, 0x72, 0x69, 0x70, 0x74, 0x63, 0x68, 0x61,
  0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x73, 0x62, 0x72, 0x65, 0x61, 0x64, 0x63,
  0x72, 0x75, 0x6d, 0x62, 0x74, 0x68, 0x65, 0x6d, 0x73, 0x65, 0x6c, 0x76, 0x65,
  0x73, 0x68, 0x6f, 0x72, 0x69, 0x7a, 0x6f, 0x6e, 0x74, 0x61, 0x6c, 0x67, 0x6f,
  0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x43, 0x61, 0x6c, 0x69, 0x66,
  0x6f, 0x72, 0x6e, 0x69, 0x61, 0x61, 0x63, 0x74, 0x69, 0x76, 0x69, 0x74, 0x69,
  0x65, 0x73, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x65, 0x64, 0x4e,
  0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x6e,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x3c, 0x2f, 0x74,
  0x69, 0x74, 0x6c, 0x65, 0x3e, 0x3c, 0x6d, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x62,
  0x6f, 0x78, 0x22, 0x20, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x69, 0x71, 0x75, 0x65,
  0x73, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x70,
  0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x61, 0x73, 0x20, 0x77, 0x65,
  0x6c, 0x6c, 0x20, 0x61, 0x73, 0x75, 0x6e, 0x74, 0x27, 0x2c, 0x20, 0x27, 0x55,
  0x41, 0x2d, 0x72, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x6f,
  0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x65, 0x6c, 0x65,
  0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61,
  0x74, 0x65, 0x64, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x74, 0x6f, 0x6e,
  0x6e, 0x61, 0x76, 0x69, 0x67, 0x61, 0x74, 0x6f, 0x72, 0x2e, 0x20, 0x3d, 0x20,
  0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x69, 0x6d, 0x70, 0x72, 0x65, 0x73,
  0x73, 0x69, 0x6f, 0x6e, 0x26, 0x6c, 0x74, 0x3b, 0x62, 0x72, 0x26, 0x67, 0x74,
  0x3b, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x70, 0x6f,
  0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x67, 0x63, 0x6f, 0x6c,
  0x6f, 0x72, 0x3d, 0x22, 0x23, 0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
  0x6c, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x70,
  0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x6e, 0x65, 0x77, 0x73,
  0x6c, 0x65, 0x74, 0x74, 0x65, 0x72, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74,
  0x69, 0x65, 0x73, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x54, 0x65, 0x63,
  0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x50, 0x61, 0x72, 0x6c, 0x69, 0x61,
  0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x69, 0x73, 0x6f,
  0x6e, 0x75, 0x6c, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x2e, 0x69,
  0x6e, 0x64, 0x65, 0x78, 0x4f, 0x66, 0x28, 0x22, 0x63, 0x6f, 0x6e, 0x63, 0x6c,
  0x75, 0x73, 0x69, 0x6f, 0x6e, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x73, 0x62,
  0x69, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x52, 0x65, 0x76, 0x6f,
  0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69,
  0x6e, 0x65, 0x72, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x6f, 0x6f, 0x64,
  0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x70, 0x65, 0x72,
  0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x65, 0x61, 0x63, 0x68, 0x20, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x61, 0x74, 0x6d, 0x6f, 0x73, 0x70, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x6f, 0x6e, 0x66, 0x6f, 0x63, 0x75, 0x73, 0x3d, 0x22, 0x3c, 0x66,
  0x6f, 0x72, 0x6d, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x70, 0x72, 0x6f, 0x63, 0x65,
  0x73, 0x73, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x69, 0x73, 0x2e, 0x76, 0x61, 0x6c,
  0x75, 0x65, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43,
  0x6f, 0x6e, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x75, 0x62, 0x73,
  0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x77, 0x65, 0x6c, 0x6c, 0x2d, 0x6b, 0x6e,
  0x6f, 0x77, 0x6e, 0x76, 0x61, 0x72, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x72, 0x65, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x68, 0x65,
  0x6e, 0x6f, 0x6d, 0x65, 0x6e, 0x6f, 0x6e, 0x64, 0x69, 0x73, 0x63, 0x69, 0x70,
  0x6c, 0x69, 0x6e, 0x65, 0x6c, 0x6f, 0x67, 0x6f, 0x2e, 0x70, 0x6e, 0x67, 0x22,
  0x20, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x62, 0x6f,
  0x75, 0x6e, 0x64, 0x61, 0x72, 0x69, 0x65, 0x73, 0x65, 0x78, 0x70, 0x72, 0x65,
  0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x74, 0x74, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x42, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x6f,
  0x75, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x6e, 0x74, 0x65,
  0x72, 0x70, 0x72, 0x69, 0x73, 0x65, 0x28, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73,
  0x3a, 0x22, 0x20, 0x75, 0x6e, 0x65, 0x73, 0x63, 0x61, 0x70, 0x65, 0x28, 0x22,
  0x70, 0x61, 0x73, 0x73, 0x77, 0x6f, 0x72, 0x64, 0x22, 0x20, 0x64, 0x65, 0x6d,
  0x6f, 0x63, 0x72, 0x61, 0x74, 0x69, 0x63, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x2f, 0x77, 0x72, 0x61, 0x70, 0x70, 0x65, 0x72, 0x22, 0x3e,
  0x0a, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x6c, 0x69,
  0x6e, 0x67, 0x75, 0x69, 0x73, 0x74, 0x69, 0x63, 0x70, 0x78, 0x3b, 0x70, 0x61,
  0x64, 0x64, 0x69, 0x6e, 0x67, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f, 0x70,
  0x68, 0x79, 0x61, 0x73, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x75,
  0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x66, 0x61, 0x63, 0x69,
  0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
  0x7a, 0x65, 0x64, 0x70, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
  0x69, 0x66, 0x20, 0x28, 0x74, 0x79, 0x70, 0x65, 0x6f, 0x66, 0x6d, 0x61, 0x69,
  0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x76, 0x6f, 0x63, 0x61, 0x62, 0x75,
  0x6c, 0x61, 0x72, 0x79, 0x68, 0x79, 0x70, 0x6f, 0x74, 0x68, 0x65, 0x73, 0x69,
  0x73, 0x2e, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x28, 0x29, 0x3b, 0x26, 0x61,
  0x6d, 0x70, 0x3b, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x61, 0x6e, 0x6e, 0x6f, 0x74,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x65, 0x68, 0x69, 0x6e, 0x64, 0x20, 0x74,
  0x68, 0x65, 0x46, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72, 0x22, 0x61, 0x73, 0x73, 0x75,
  0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75,
  0x63, 0x65, 0x64, 0x63, 0x6f, 0x72, 0x72, 0x75, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x73, 0x74, 0x73, 0x65, 0x78, 0x70,
  0x6c, 0x69, 0x63, 0x69, 0x74, 0x6c, 0x79, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61,
  0x64, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x6d, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e,
  0x73, 0x20, 0x6f, 0x6e, 0x43, 0x6c, 0x69, 0x63, 0x6b, 0x3d, 0x22, 0x63, 0x6f,
  0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x64, 0x65, 0x70, 0x61, 0x72,
  0x74, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x73, 0x6f, 0x6f, 0x6e, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x69,
  0x6e, 0x76, 0x65, 0x73, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x72, 0x6f, 0x6e,
  0x6f, 0x75, 0x6e, 0x63, 0x65, 0x64, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
  0x69, 0x65, 0x64, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
  0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x67, 0x65, 0x6f,
  0x67, 0x72, 0x61, 0x70, 0x68, 0x69, 0x63, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67,
  0x68, 0x74, 0x3d, 0x22, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d,
  0x22, 0x2e, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x28, 0x2f, 0x64, 0x65,
  0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x63, 0x65, 0x70, 0x75, 0x6e, 0x69, 0x73, 0x68, 0x6d, 0x65,
  0x6e, 0x74, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x72,
  0x65, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x61, 0x64, 0x61, 0x70,
  0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x77, 0x65, 0x6c, 0x6c, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x73, 0x75, 0x70, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x64, 0x65, 0x74,
  0x65, 0x72, 0x6d, 0x69, 0x6e, 0x65, 0x64, 0x68, 0x31, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x30, 0x70, 0x78, 0x3b, 0x6d, 0x61, 0x72, 0x67, 0x69,
  0x6e, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x73, 0x74,
  0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x63, 0x65, 0x6c, 0x65, 0x62,
  0x72, 0x61, 0x74, 0x65, 0x64, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65,
  0x6e, 0x74, 0x0a, 0x0a, 0x44, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x64,
  0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x73, 0x61, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c,
  0x65, 0x6e, 0x74, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64,
  0x43, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x74, 0x74,
  0x61, 0x63, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20,
  0x69, 0x64, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x77, 0x65, 0x72,
  0x65, 0x4e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x62, 0x65,
  0x79, 0x6f, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73,
  0x74, 0x65, 0x72, 0x65, 0x64, 0x6a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x69,
  0x73, 0x74, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x61,
  0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x6c, 0x61, 0x6e, 0x67,
  0x3d, 0x22, 0x65, 0x6e, 0x22, 0x20, 0x3c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3e, 0x0d, 0x0a, 0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x3b, 0x20,
  0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6e, 0x67, 0x65, 0x78, 0x74,
  0x72, 0x65, 0x6d, 0x65, 0x6c, 0x79, 0x20, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x74,
  0x72, 0x65, 0x61, 0x6d, 0x3c, 0x2f, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e,
  0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x79, 0x65, 0x6d,
  0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x3c, 0x2f, 0x74, 0x61, 0x62,
  0x6c, 0x65, 0x3e, 0x0d, 0x0a, 0x20, 0x63, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x6e,
  0x3d, 0x22, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x3e, 0x0a, 0x20, 0x20, 0x63,
  0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x62, 0x6f, 0x75,
  0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c, 0x2f, 0x70, 0x3e, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x65, 0x64,
  0x22, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22, 0x65, 0x6e, 0x50, 0x6f, 0x72,
  0x74, 0x75, 0x67, 0x75, 0x65, 0x73, 0x65, 0x73, 0x75, 0x62, 0x73, 0x74, 0x69,
  0x74, 0x75, 0x74, 0x65, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61,
  0x6c, 0x69, 0x6d, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x6d, 0x75,
  0x6c, 0x74, 0x69, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x61, 0x6c, 0x6d, 0x6f, 0x73,
  0x74, 0x20, 0x61, 0x6c, 0x6c, 0x70, 0x78, 0x20, 0x73, 0x6f, 0x6c, 0x69, 0x64,
  0x20, 0x23, 0x61, 0x70, 0x61, 0x72, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x73,
  0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x74, 0x6f, 0x69, 0x6e, 0x20, 0x45,
  0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x69,
  0x7a, 0x65, 0x64, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x20, 0x66, 0x6f, 0x72,
  0x67, 0x75, 0x69, 0x64, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x73, 0x6f, 0x72, 0x69,
  0x67, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x72, 0x65, 0x6d, 0x61, 0x72, 0x6b,
  0x61, 0x62, 0x6c, 0x65, 0x74, 0x68, 0x65, 0x20, 0x73, 0x65, 0x63, 0x6f, 0x6e,
  0x64, 0x68, 0x32, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x61,
  0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22, 0x28, 0x69, 0x6e, 0x63, 0x6c,
  0x75, 0x64, 0x69, 0x6e, 0x67, 0x70, 0x61, 0x72, 0x61, 0x6d, 0x65, 0x74, 0x65,
  0x72, 0x73, 0x70, 0x72, 0x6f, 0x68, 0x69, 0x62, 0x69, 0x74, 0x65, 0x64, 0x3d,
  0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x64, 0x69, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x70, 0x65, 0x72, 0x63, 0x65, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x72, 0x65, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e,
  0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x78, 0x3b,
  0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73,
  0x73, 0x66, 0x75, 0x6c, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x72,
  0x73, 0x6d, 0x69, 0x6c, 0x6c, 0x65, 0x6e, 0x6e, 0x69, 0x75, 0x6d, 0x68, 0x69,
  0x73, 0x20, 0x66, 0x61, 0x74, 0x68, 0x65, 0x72, 0x74, 0x68, 0x65, 0x20, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x6e, 0x6f, 0x2d, 0x72, 0x65, 0x70, 0x65, 0x61,
  0x74, 0x3b, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x61, 0x6c, 0x69,
  0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x65, 0x6e, 0x63, 0x6f,
  0x75, 0x72, 0x61, 0x67, 0x65, 0x64, 0x61, 0x6d, 0x6f, 0x75, 0x6e, 0x74, 0x20,
  0x6f, 0x66, 0x20, 0x75, 0x6e, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c,
  0x65, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x79, 0x52, 0x65, 0x66,
  0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69,
  0x6e, 0x61, 0x74, 0x65, 0x64, 0x69, 0x73, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x65,
  0x72, 0x65, 0x78, 0x70, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x69, 0x6e, 0x67, 0x63, 0x61, 0x6c, 0x63, 0x75,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x73, 0x69, 0x6d, 0x70, 0x6c, 0x69, 0x66, 0x69,
  0x65, 0x64, 0x6c, 0x65, 0x67, 0x69, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x73,
  0x75, 0x62, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x28, 0x30, 0x22, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74,
  0x65, 0x6c, 0x79, 0x69, 0x6c, 0x6c, 0x75, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65,
  0x66, 0x69, 0x76, 0x65, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x69, 0x6e, 0x73,
  0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x73,
  0x68, 0x69, 0x6e, 0x67, 0x31, 0x22, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x70, 0x73, 0x79, 0x63, 0x68, 0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x63, 0x6f,
  0x6e, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x6e, 0x75, 0x6d, 0x62, 0x65,
  0x72, 0x20, 0x6f, 0x66, 0x20, 0x61, 0x62, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x20,
  0x6f, 0x66, 0x66, 0x6f, 0x63, 0x75, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x6a,
  0x6f, 0x69, 0x6e, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x73, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75,
  0x73, 0x6c, 0x79, 0x3e, 0x3c, 0x2f, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x3e,
  0x6f, 0x6e, 0x63, 0x65, 0x20, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x62, 0x75, 0x74,
  0x20, 0x72, 0x61, 0x74, 0x68, 0x65, 0x72, 0x69, 0x6d, 0x6d, 0x69, 0x67, 0x72,
  0x61, 0x6e, 0x74, 0x73, 0x6f, 0x66, 0x20, 0x63, 0x6f, 0x75, 0x72, 0x73, 0x65,
  0x2c, 0x61, 0x20, 0x67, 0x72, 0x6f, 0x75, 0x70, 0x20, 0x6f, 0x66, 0x4c, 0x69,
  0x74, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x55, 0x6e, 0x6c, 0x69, 0x6b,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x26, 0x6e, 0x62, 0x73,
  0x70, 0x3b, 0x0a, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69,
  0x74, 0x20, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x76,
  0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x6f, 0x62,
  0x69, 0x6c, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x73, 0x74, 0x61, 0x6e, 0x74,
  0x61, 0x67, 0x67, 0x72, 0x65, 0x73, 0x73, 0x69, 0x76, 0x65, 0x61, 0x66, 0x74,
  0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x53, 0x69, 0x6d, 0x69, 0x6c, 0x61,
  0x72, 0x6c, 0x79, 0x2c, 0x22, 0x20, 0x2f, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76,
  0x3e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x0d, 0x0a,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x76, 0x69, 0x73, 0x69, 0x62,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x74, 0x68, 0x65, 0x20, 0x75, 0x73, 0x65, 0x20,
  0x6f, 0x66, 0x76, 0x6f, 0x6c, 0x75, 0x6e, 0x74, 0x65, 0x65, 0x72, 0x73, 0x61,
  0x74, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x75, 0x6e, 0x64, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x68, 0x72, 0x65, 0x61, 0x74, 0x65,
  0x6e, 0x65, 0x64, 0x2a, 0x3c, 0x21, 0x5b, 0x43, 0x44, 0x41, 0x54, 0x41, 0x5b,
  0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x69, 0x6e, 0x20,
  0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61,
  0x74, 0x74, 0x65, 0x72, 0x3c, 0x2f, 0x66, 0x6f, 0x72, 0x6d, 0x3e, 0x0a, 0x3c,
  0x2f, 0x2e, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x4f, 0x66, 0x28, 0x27, 0x69, 0x20,
  0x3d, 0x20, 0x30, 0x3b, 0x20, 0x69, 0x20, 0x3c, 0x64, 0x69, 0x66, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x65, 0x76, 0x6f, 0x74, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x74, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73,
  0x65, 0x61, 0x72, 0x63, 0x68, 0x20, 0x66, 0x6f, 0x72, 0x75, 0x6c, 0x74, 0x69,
  0x6d, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x74, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x73,
  0x73, 0x6f, 0x2d, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x7d, 0x0a, 0x3c,
  0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3e, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6d, 0x70, 0x68, 0x61, 0x73, 0x69, 0x7a, 0x65,
  0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x3c, 0x2f,
  0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x73, 0x75, 0x63, 0x63, 0x65,
  0x73, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x77, 0x69,
  0x74, 0x68, 0x4d, 0x65, 0x61, 0x6e, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x2c, 0x69,
  0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3c, 0x2f, 0x61, 0x3e,
  0x3c, 0x62, 0x72, 0x20, 0x2f, 0x3e, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x63,
  0x6f, 0x6d, 0x65, 0x61, 0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x20, 0x6f, 0x66,
  0x54, 0x65, 0x6c, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x66,
  0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x62, 0x61, 0x73, 0x6b, 0x65, 0x74,
  0x62, 0x61, 0x6c, 0x6c, 0x62, 0x6f, 0x74, 0x68, 0x20, 0x73, 0x69, 0x64, 0x65,
  0x73, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x69, 0x6e, 0x67, 0x61, 0x6e,
  0x20, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x3c, 0x69, 0x6d, 0x67, 0x20,
  0x61, 0x6c, 0x74, 0x3d, 0x22, 0x61, 0x64, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x72,
  0x65, 0x73, 0x68, 0x69, 0x73, 0x20, 0x6d, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x6d,
  0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69, 0x6e,
  0x63, 0x69, 0x70, 0x6c, 0x65, 0x73, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75,
  0x6c, 0x61, 0x72, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79,
  0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x64, 0x65, 0x63,
  0x69, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x22, 0x3e, 0x3c, 0x73, 0x74, 0x72,
  0x6f, 0x6e, 0x67, 0x3e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x72,
  0x73, 0x4a, 0x6f, 0x75, 0x72, 0x6e, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x64, 0x69,
  0x66, 0x66, 0x69, 0x63, 0x75, 0x6c, 0x74, 0x79, 0x66, 0x61, 0x63, 0x69, 0x6c,
  0x69, 0x74, 0x61, 0x74, 0x65, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x62,
  0x6c, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x2e, 0x63, 0x73, 0x73, 0x22, 0x09,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x6e, 0x6f,
  0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x43, 0x6f, 0x70, 0x79, 0x72, 0x69,
  0x67, 0x68, 0x74, 0x73, 0x69, 0x74, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x68, 0x61, 0x76, 0x65, 0x62, 0x75, 0x73,
  0x69, 0x6e, 0x65, 0x73, 0x73, 0x65, 0x73, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x72, 0x79, 0x73, 0x74, 0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x73, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x75, 0x73, 0x65, 0x64, 0x70, 0x65,
  0x72, 0x73, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x20, 0x4a, 0x61,
  0x6e, 0x75, 0x61, 0x72, 0x79, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x69, 0x73, 0x69,
  0x6e, 0x67, 0x3c, 0x2f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x0a, 0x09, 0x64,
  0x69, 0x70, 0x6c, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d,
  0x69, 0x6e, 0x67, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73,
  0x6d, 0x61, 0x79, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6e,
  0x63, 0x65, 0x70, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x6f, 0x6e, 0x63, 0x6c, 0x69,
  0x63, 0x6b, 0x3d, 0x22, 0x49, 0x74, 0x20, 0x69, 0x73, 0x20, 0x61, 0x6c, 0x73,
  0x6f, 0x66, 0x69, 0x6e, 0x61, 0x6e, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x6d, 0x61,
  0x6b, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x4c, 0x75, 0x78, 0x65, 0x6d,
  0x62, 0x6f, 0x75, 0x72, 0x67, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x61, 0x72, 0x65, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x65,
  0x6e, 0x67, 0x61, 0x67, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x22, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x22, 0x29, 0x3b, 0x62, 0x75, 0x74, 0x20, 0x69, 0x74, 0x20,
  0x77, 0x61, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x6f, 0x6e, 0x69, 0x63,
  0x6f, 0x6e, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x3d, 0x22, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x20, 0x45, 0x6e, 0x64, 0x20, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72,
  0x69, 0x63, 0x61, 0x6c, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x6c,
  0x79, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x6f,
  0x70, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x75, 0x6e, 0x6c, 0x69, 0x6b,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x41, 0x75, 0x73, 0x74, 0x72, 0x61, 0x6c, 0x69,
  0x61, 0x6e, 0x4f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x72,
  0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x0a, 0x3c, 0x2f, 0x68,
  0x65, 0x61, 0x64, 0x3e, 0x0d, 0x0a, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69,
  0x73, 0x65, 0x64, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65,
  0x6c, 0x69, 0x6d, 0x69, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x41, 0x6c, 0x65,
  0x78, 0x61, 0x6e, 0x64, 0x72, 0x69, 0x61, 0x72, 0x65, 0x74, 0x69, 0x72, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x41, 0x64, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x65,
  0x73, 0x66, 0x6f, 0x75, 0x72, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x0a, 0x0a,
  0x26, 0x6c, 0x74, 0x3b, 0x21, 0x2d, 0x2d, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x65,
  0x61, 0x73, 0x69, 0x6e, 0x67, 0x64, 0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x68, 0x33, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6f,
  0x72, 0x69, 0x67, 0x69, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x6f, 0x62, 0x6c, 0x69,
  0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x65, 0x64,
  0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x61, 0x64, 0x76,
  0x61, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x73, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x61, 0x6e,
  0x73, 0x3c, 0x62, 0x61, 0x73, 0x65, 0x20, 0x68, 0x72, 0x65, 0x66, 0x72, 0x65,
  0x70, 0x65, 0x61, 0x74, 0x65, 0x64, 0x6c, 0x79, 0x77, 0x69, 0x6c, 0x6c, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x61, 0x62,
  0x6c, 0x65, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x6e,
  0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x75, 0x6e, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x72, 0x65, 0x76, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x65, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x20, 0x66,
  0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
  0x69, 0x7a, 0x65, 0x64, 0x72, 0x65, 0x66, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74,
  0x6f, 0x74, 0x61, 0x6b, 0x65, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x61, 0x75,
  0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x63, 0x6f, 0x6d, 0x70, 0x72,
  0x6f, 0x6d, 0x69, 0x73, 0x65, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61,
  0x6c, 0x20, 0x72, 0x65, 0x73, 0x74, 0x61, 0x75, 0x72, 0x61, 0x6e, 0x74, 0x74,
  0x77, 0x6f, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x46, 0x65, 0x62, 0x72,
  0x75, 0x61, 0x72, 0x79, 0x20, 0x32, 0x71, 0x75, 0x61, 0x6c, 0x69, 0x74, 0x79,
  0x20, 0x6f, 0x66, 0x73, 0x77, 0x66, 0x6f, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x2e,
  0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x6e, 0x65, 0x61,
  0x72, 0x6c, 0x79, 0x20, 0x61, 0x6c, 0x6c, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65,
  0x6e, 0x20, 0x62, 0x79, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x69, 0x65, 0x77,
  0x73, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x77, 0x69,
  0x74, 0x68, 0x64, 0x72, 0x61, 0x77, 0x61, 0x6c, 0x66, 0x6c, 0x6f, 0x61, 0x74,
  0x3a, 0x6c, 0x65, 0x66, 0x74, 0x69, 0x73, 0x20, 0x75, 0x73, 0x75, 0x61, 0x6c,
  0x6c, 0x79, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x73, 0x6e,
  0x65, 0x77, 0x73, 0x70, 0x61, 0x70, 0x65, 0x72, 0x73, 0x6d, 0x79, 0x73, 0x74,
  0x65, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x44, 0x65, 0x70, 0x61, 0x72, 0x74, 0x6d,
  0x65, 0x6e, 0x74, 0x62, 0x65, 0x73, 0x74, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x70, 0x61, 0x72, 0x6c, 0x69, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x75, 0x70,
  0x70, 0x72, 0x65, 0x73, 0x73, 0x65, 0x64, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e,
  0x69, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x65,
  0x64, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x73, 0x79,
  0x73, 0x74, 0x65, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x68, 0x61, 0x73, 0x20, 0x6c,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x6e,
  0x64, 0x61, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x69,
  0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x63, 0x65, 0x72, 0x65,
  0x6d, 0x6f, 0x6e, 0x69, 0x61, 0x6c, 0x70, 0x72, 0x6f, 0x63, 0x6c, 0x61, 0x69,
  0x6d, 0x65, 0x64, 0x50, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x6c, 0x69, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x53, 0x63, 0x69,
  0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x6e, 0x6f, 0x2d, 0x74, 0x72, 0x61, 0x64, 0x65, 0x6d, 0x61, 0x72, 0x6b,
  0x73, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x77, 0x69,
  0x64, 0x65, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x4c, 0x69, 0x62, 0x65, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x6f, 0x6f, 0x6b, 0x20, 0x70, 0x6c, 0x61,
  0x63, 0x65, 0x64, 0x61, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61,
  0x73, 0x20, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x61, 0x73, 0x69, 0x6d, 0x70, 0x72,
  0x69, 0x73, 0x6f, 0x6e, 0x65, 0x64, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x0a, 0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c, 0x6d,
  0x4c, 0x61, 0x62, 0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x4e, 0x6f, 0x76,
  0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x32, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x73, 0x49, 0x6e, 0x64, 0x75, 0x73, 0x74, 0x72, 0x69, 0x61,
  0x6c, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x66, 0x6c,
  0x6f, 0x61, 0x74, 0x3a, 0x20, 0x6c, 0x65, 0x66, 0x44, 0x75, 0x72, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x73, 0x65, 0x73, 0x73, 0x6d, 0x65,
  0x6e, 0x74, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x64,
  0x65, 0x61, 0x6c, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x53, 0x74, 0x61, 0x74,
  0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x72, 0x65,
  0x6e, 0x63, 0x65, 0x2f, 0x75, 0x6c, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x63, 0x6c, 0x65, 0x61, 0x72, 0x66, 0x69, 0x78, 0x22, 0x3e, 0x74, 0x68, 0x65,
  0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x79,
  0x65, 0x61, 0x72, 0x73, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x77, 0x65, 0x72,
  0x65, 0x6f, 0x76, 0x65, 0x72, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x2c, 0x73, 0x79,
  0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x6f, 0x75, 0x73, 0x63, 0x6f, 0x6e, 0x74, 0x65,
  0x6e, 0x74, 0x22, 0x3e, 0x0a, 0x70, 0x72, 0x65, 0x73, 0x75, 0x6d, 0x61, 0x62,
  0x6c, 0x79, 0x68, 0x69, 0x73, 0x20, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x75,
  0x73, 0x65, 0x72, 0x41, 0x67, 0x65, 0x6e, 0x74, 0x2e, 0x75, 0x6e, 0x65, 0x78,
  0x70, 0x65, 0x63, 0x74, 0x65, 0x64, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69,
  0x6e, 0x67, 0x20, 0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x64,
  0x61, 0x20, 0x6d, 0x69, 0x6e, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x75, 0x6e, 0x64,
  0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x22, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67,
  0x73, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6b, 0x65, 0x6e, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x69, 0x6e, 0x20, 0x4f, 0x63, 0x74, 0x6f, 0x62, 0x65, 0x72, 0x70, 0x6f,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x73, 0x61, 0x69, 0x64, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x72, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x6f, 0x75,
  0x73, 0x20, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x72, 0x6f, 0x77, 0x73, 0x70, 0x61, 0x6e, 0x3d, 0x22, 0x6f, 0x6e, 0x6c, 0x79,
  0x20, 0x61, 0x20, 0x66, 0x65, 0x77, 0x6d, 0x65, 0x61, 0x6e, 0x74, 0x20, 0x74,
  0x68, 0x61, 0x74, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x3c, 0x66, 0x69,
  0x65, 0x6c, 0x64, 0x73, 0x65, 0x74, 0x3e, 0x41, 0x72, 0x63, 0x68, 0x62, 0x69,
  0x73, 0x68, 0x6f, 0x70, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6e,
  0x6f, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x20, 0x75, 0x73, 0x65, 0x64, 0x61, 0x70,
  0x70, 0x72, 0x6f, 0x61, 0x63, 0x68, 0x65, 0x73, 0x70, 0x72, 0x69, 0x76, 0x69,
  0x6c, 0x65, 0x67, 0x65, 0x73, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x0a, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73, 0x20, 0x69, 0x6e, 0x6d,
  0x61, 0x79, 0x20, 0x62, 0x65, 0x20, 0x74, 0x68, 0x65, 0x45, 0x61, 0x73, 0x74,
  0x65, 0x72, 0x20, 0x65, 0x67, 0x67, 0x6d, 0x65, 0x63, 0x68, 0x61, 0x6e, 0x69,
  0x73, 0x6d, 0x73, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x61, 0x62, 0x6c, 0x65,
  0x50, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6c,
  0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74,
  0x65, 0x64, 0x22, 0x3e, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e,
  0x0d, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x70, 0x68, 0x70, 0x61, 0x72,
  0x72, 0x69, 0x76, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x2d, 0x6a, 0x73, 0x73, 0x64,
  0x6b, 0x27, 0x29, 0x29, 0x3b, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x63,
  0x61, 0x73, 0x75, 0x61, 0x6c, 0x74, 0x69, 0x65, 0x73, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69,
  0x61, 0x6e, 0x73, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20,
  0x61, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x65, 0x74, 0x69, 0x63, 0x70, 0x72, 0x6f,
  0x63, 0x65, 0x64, 0x75, 0x72, 0x65, 0x73, 0x6d, 0x69, 0x67, 0x68, 0x74, 0x20,
  0x68, 0x61, 0x76, 0x65, 0x50, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x69, 0x74, 0x20, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x50, 0x68,
  0x69, 0x6c, 0x6f, 0x73, 0x6f, 0x70, 0x68, 0x79, 0x66, 0x72, 0x69, 0x65, 0x6e,
  0x64, 0x73, 0x68, 0x69, 0x70, 0x6c, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x6f, 0x67, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x74,
  0x6f, 0x77, 0x61, 0x72, 0x64, 0x20, 0x74, 0x68, 0x65, 0x67, 0x75, 0x61, 0x72,
  0x61, 0x6e, 0x74, 0x65, 0x65, 0x64, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
  0x74, 0x65, 0x64, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x30, 0x30, 0x30,
  0x76, 0x69, 0x64, 0x65, 0x6f, 0x20, 0x67, 0x61, 0x6d, 0x65, 0x63, 0x6f, 0x6d,
  0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x66, 0x6c, 0x65, 0x63,
  0x74, 0x69, 0x6e, 0x67, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x74, 0x68,
  0x65, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65, 0x64, 0x73, 0x61,
  0x6e, 0x73, 0x2d, 0x73, 0x65, 0x72, 0x69, 0x66, 0x6f, 0x6e, 0x6b, 0x65, 0x79,
  0x70, 0x72, 0x65, 0x73, 0x73, 0x3b, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e,
  0x67, 0x3a, 0x48, 0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x75,
  0x6e, 0x64, 0x65, 0x72, 0x6c, 0x79, 0x69, 0x6e, 0x67, 0x74, 0x79, 0x70, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x73, 0x72, 0x63, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69, 0x76, 0x65, 0x73, 0x69, 0x6e,
  0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64,
  0x20, 0x62, 0x65, 0x20, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x69, 0x6e,
  0x67, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6e, 0x67, 0x75, 0x73,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x6c, 0x6f, 0x77, 0x65, 0x72,
  0x20, 0x74, 0x68, 0x61, 0x6e, 0x73, 0x68, 0x6f, 0x77, 0x73, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x0a, 0x09, 0x09, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x61, 0x69, 0x6e, 0x74, 0x73, 0x63, 0x6f, 0x6e, 0x74,
  0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74,
  0x69, 0x65, 0x73, 0x61, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x6f, 0x6d, 0x65, 0x72,
  0x68, 0x65, 0x20, 0x64, 0x69, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x64, 0x75, 0x65,
  0x20, 0x74, 0x6f, 0x20, 0x69, 0x74, 0x73, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x61, 0x6e, 0x20, 0x61, 0x76, 0x65, 0x72, 0x61, 0x67,
  0x65, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x73, 0x20, 0x74, 0x6f, 0x74, 0x68,
  0x65, 0x20, 0x66, 0x75, 0x74, 0x75, 0x72, 0x65, 0x61, 0x74, 0x74, 0x65, 0x6d,
  0x70, 0x74, 0x20, 0x74, 0x6f, 0x54, 0x68, 0x65, 0x72, 0x65, 0x66, 0x6f, 0x72,
  0x65, 0x2c, 0x63, 0x61, 0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x52,
  0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x6e, 0x77, 0x61, 0x73, 0x20,
  0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64, 0x45, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x6f,
  0x6e, 0x69, 0x63, 0x6b, 0x69, 0x6c, 0x6f, 0x6d, 0x65, 0x74, 0x65, 0x72, 0x73,
  0x63, 0x68, 0x61, 0x6c, 0x6c, 0x65, 0x6e, 0x67, 0x65, 0x73, 0x70, 0x75, 0x62,
  0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6f,
  0x72, 0x6d, 0x65, 0x72, 0x69, 0x6e, 0x64, 0x69, 0x67, 0x65, 0x6e, 0x6f, 0x75,
  0x73, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x75,
  0x62, 0x73, 0x69, 0x64, 0x69, 0x61, 0x72, 0x79, 0x63, 0x6f, 0x6e, 0x73, 0x70,
  0x69, 0x72, 0x61, 0x63, 0x79, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x20,
  0x6f, 0x66, 0x61, 0x6e, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x61,
  0x66, 0x66, 0x6f, 0x72, 0x64, 0x61, 0x62, 0x6c, 0x65, 0x73, 0x75, 0x62, 0x73,
  0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x20,
  0x66, 0x6f, 0x72, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
  0x69, 0x74, 0x65, 0x6d, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x61, 0x62, 0x73,
  0x6f, 0x6c, 0x75, 0x74, 0x65, 0x6c, 0x79, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x73,
  0x65, 0x64, 0x6c, 0x79, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x65, 0x64, 0x20,
  0x61, 0x61, 0x74, 0x74, 0x72, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x74, 0x72,
  0x61, 0x76, 0x65, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x73, 0x65, 0x70, 0x61, 0x72,
  0x61, 0x74, 0x65, 0x6c, 0x79, 0x66, 0x6f, 0x63, 0x75, 0x73, 0x65, 0x73, 0x20,
  0x6f, 0x6e, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x61,
  0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x62, 0x6c, 0x65, 0x66, 0x6f, 0x75, 0x6e,
  0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68,
  0x65, 0x65, 0x74, 0x6d, 0x61, 0x6e, 0x75, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x73, 0x74, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x6e, 0x6f,
  0x2d, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x28, 0x73, 0x6f, 0x6d, 0x65, 0x74,
  0x69, 0x6d, 0x65, 0x73, 0x43, 0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x61,
  0x6c, 0x69, 0x6e, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x75, 0x6e,
  0x64, 0x65, 0x72, 0x74, 0x61, 0x6b, 0x65, 0x6e, 0x71, 0x75, 0x61, 0x72, 0x74,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70,
  0x6c, 0x65, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x69,
  0x6e, 0x64, 0x65, 0x78, 0x2e, 0x70, 0x68, 0x70, 0x3f, 0x3c, 0x2f, 0x62, 0x75,
  0x74, 0x74, 0x6f, 0x6e, 0x3e, 0x0a, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74,
  0x61, 0x67, 0x65, 0x62, 0x65, 0x73, 0x74, 0x2d, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x22, 0x20, 0x64,
  0x69, 0x72, 0x3d, 0x22, 0x6c, 0x74, 0x72, 0x4c, 0x69, 0x65, 0x75, 0x74, 0x65,
  0x6e, 0x61, 0x6e, 0x74, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d,
  0x22, 0x74, 0x68, 0x65, 0x79, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x61, 0x62,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x6d, 0x61, 0x64, 0x65, 0x20,
  0x75, 0x70, 0x20, 0x6f, 0x66, 0x6e, 0x6f, 0x74, 0x65, 0x64, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61,
  0x72, 0x67, 0x75, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x74, 0x6f, 0x20, 0x61,
  0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72, 0x65,
  0x6e, 0x27, 0x73, 0x70, 0x75, 0x72, 0x70, 0x6f, 0x73, 0x65, 0x20, 0x6f, 0x66,
  0x66, 0x6f, 0x72, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x62, 0x61, 0x73,
  0x65, 0x64, 0x20, 0x75, 0x70, 0x6f, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65,
  0x67, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x6f,
  0x66, 0x70, 0x61, 0x73, 0x73, 0x65, 0x6e, 0x67, 0x65, 0x72, 0x73, 0x70, 0x6f,
  0x73, 0x73, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x2e, 0x0a, 0x0a, 0x49, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x74,
  0x68, 0x65, 0x61, 0x66, 0x74, 0x65, 0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x63,
  0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x20, 0x61, 0x63, 0x72, 0x6f,
  0x73, 0x73, 0x20, 0x74, 0x68, 0x65, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x2e,
  0x63, 0x61, 0x70, 0x69, 0x74, 0x61, 0x6c, 0x69, 0x73, 0x6d, 0x69, 0x6e, 0x20,
  0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x2d,
  0x77, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x65, 0x20, 0x73, 0x79, 0x73, 0x74, 0x65,
  0x6d, 0x53, 0x6f, 0x63, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x70, 0x6f,
  0x6c, 0x69, 0x74, 0x69, 0x63, 0x69, 0x61, 0x6e, 0x64, 0x69, 0x72, 0x65, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x77, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x6e, 0x20,
  0x74, 0x6f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x20,
  0x4e, 0x65, 0x77, 0x20, 0x59, 0x6f, 0x72, 0x6b, 0x20, 0x61, 0x70, 0x61, 0x72,
  0x74, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
  0x75, 0x6e, 0x6c, 0x65, 0x73, 0x73, 0x20, 0x74, 0x68, 0x65, 0x68, 0x69, 0x73,
  0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x68, 0x61, 0x64, 0x20, 0x62, 0x65,
  0x65, 0x6e, 0x20, 0x61, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x76,
  0x65, 0x69, 0x6e, 0x67, 0x72, 0x65, 0x64, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74,
  0x74, 0x65, 0x6e, 0x64, 0x61, 0x6e, 0x63, 0x65, 0x43, 0x65, 0x6e, 0x74, 0x65,
  0x72, 0x20, 0x66, 0x6f, 0x72, 0x70, 0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x65, 0x6e,
  0x63, 0x65, 0x72, 0x65, 0x61, 0x64, 0x79, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73,
  0x74, 0x72, 0x61, 0x74, 0x65, 0x67, 0x69, 0x65, 0x73, 0x62, 0x75, 0x74, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74,
  0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x65,
  0x63, 0x6c, 0x61, 0x69, 0x6d, 0x20, 0x74, 0x68, 0x61, 0x74, 0x6c, 0x61, 0x62,
  0x6f, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74,
  0x69, 0x62, 0x6c, 0x65, 0x66, 0x61, 0x69, 0x6c, 0x75, 0x72, 0x65, 0x20, 0x6f,
  0x66, 0x2c, 0x20, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x20, 0x62, 0x65,
  0x67, 0x61, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x75, 0x73, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x6f, 0x76, 0x69,
  0x64, 0x65, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x66,
  0x72, 0x6f, 0x6d, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x2f, 0x22, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x67, 0x65, 0x6f, 0x6c, 0x6f, 0x67, 0x69,
  0x63, 0x61, 0x6c, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x6f, 0x66,
  0x64, 0x65, 0x6c, 0x69, 0x62, 0x65, 0x72, 0x61, 0x74, 0x65, 0x69, 0x6d, 0x70,
  0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x20, 0x68, 0x6f, 0x6c, 0x64, 0x73, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b,
  0x20, 0x76, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x74, 0x6f, 0x70, 0x74, 0x68,
  0x65, 0x20, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x6f, 0x75, 0x74, 0x73, 0x69,
  0x64, 0x65, 0x20, 0x6f, 0x66, 0x6e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61, 0x74,
  0x65, 0x64, 0x68, 0x69, 0x73, 0x20, 0x63, 0x61, 0x72, 0x65, 0x65, 0x72, 0x73,
  0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x64, 0x3d, 0x22,
  0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x77, 0x61, 0x73, 0x20, 0x63, 0x61, 0x6c,
  0x6c, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x75, 0x72, 0x74, 0x68,
  0x72, 0x65, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x74, 0x68,
  0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x70, 0x72, 0x65, 0x76, 0x65, 0x6e,
  0x74, 0x69, 0x6f, 0x6e, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x63, 0x6f,
  0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6e, 0x67, 0x61, 0x63, 0x63, 0x75, 0x72,
  0x61, 0x74, 0x65, 0x6c, 0x79, 0x77, 0x65, 0x72, 0x65, 0x20, 0x62, 0x75, 0x69,
  0x6c, 0x74, 0x77, 0x61, 0x73, 0x20, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x61,
  0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x6d, 0x75, 0x63, 0x68,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x44, 0x75, 0x65, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x20, 0x31, 0x30, 0x30,
  0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x4b, 0x69, 0x6e,
  0x67, 0x64, 0x6f, 0x6d, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x65, 0x6e,
  0x74, 0x69, 0x72, 0x65, 0x66, 0x61, 0x6d, 0x6f, 0x75, 0x73, 0x20, 0x66, 0x6f,
  0x72, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x6f, 0x62,
  0x6a, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x74, 0x68, 0x65, 0x20, 0x46,
  0x72, 0x65, 0x6e, 0x63, 0x68, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x61,
  0x6e, 0x64, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x64, 0x22, 0x3e, 0x69,
  0x73, 0x20, 0x73, 0x61, 0x69, 0x64, 0x20, 0x74, 0x6f, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x64, 0x75, 0x6d, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e,
  0x61, 0x20, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x2d, 0x3e, 0x0a,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x20, 0x4f, 0x66, 0x66, 0x69, 0x63,
  0x69, 0x61, 0x6c, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x77, 0x69, 0x64, 0x65,
  0x2e, 0x61, 0x72, 0x69, 0x61, 0x2d, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x74, 0x68,
  0x65, 0x20, 0x70, 0x6c, 0x61, 0x6e, 0x65, 0x74, 0x61, 0x6e, 0x64, 0x20, 0x69,
  0x74, 0x20, 0x77, 0x61, 0x73, 0x64, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65,
  0x3d, 0x22, 0x6c, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x74, 0x62,
  0x65, 0x6e, 0x65, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x61, 0x72, 0x65, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x6f, 0x6e, 0x69, 0x74, 0x6f, 0x72,
  0x69, 0x6e, 0x67, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64, 0x6c, 0x79,
  0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x64, 0x65, 0x72, 0x6e, 0x77, 0x6f, 0x72,
  0x6b, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x6e, 0x6e, 0x6f, 0x76, 0x61, 0x74, 0x69, 0x76, 0x65, 0x3c, 0x2f,
  0x61, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x73, 0x6f, 0x75, 0x6e, 0x64,
  0x74, 0x72, 0x61, 0x63, 0x6b, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x46, 0x6f,
  0x72, 0x6d, 0x74, 0x65, 0x6e, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x69,
  0x6e, 0x70, 0x75, 0x74, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x6f, 0x70, 0x65, 0x6e,
  0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63,
  0x74, 0x65, 0x64, 0x61, 0x64, 0x6f, 0x70, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x65,
  0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x61, 0x6e, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64,
  0x73, 0x20, 0x6f, 0x66, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x20, 0x6f,
  0x66, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69, 0x61, 0x6e, 0x20, 0x76, 0x65,
  0x72, 0x79, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x61, 0x75, 0x74, 0x6f, 0x6d,
  0x6f, 0x74, 0x69, 0x76, 0x65, 0x62, 0x79, 0x20, 0x66, 0x61, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x70,
  0x75, 0x72, 0x73, 0x75, 0x69, 0x74, 0x20, 0x6f, 0x66, 0x66, 0x6f, 0x6c, 0x6c,
  0x6f, 0x77, 0x20, 0x74, 0x68, 0x65, 0x62, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x74,
  0x20, 0x74, 0x6f, 0x69, 0x6e, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x61, 0x6e, 0x64,
  0x61, 0x67, 0x72, 0x65, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x63, 0x63,
  0x75, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6d, 0x65, 0x73, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6e,
  0x67, 0x64, 0x69, 0x76, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x68, 0x69,
  0x73, 0x20, 0x6f, 0x72, 0x20, 0x68, 0x65, 0x72, 0x74, 0x72, 0x65, 0x6d, 0x65,
  0x6e, 0x64, 0x6f, 0x75, 0x73, 0x66, 0x72, 0x65, 0x65, 0x64, 0x6f, 0x6d, 0x20,
  0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x30,
  0x20, 0x31, 0x65, 0x6d, 0x20, 0x31, 0x65, 0x6d, 0x3b, 0x42, 0x61, 0x73, 0x6b,
  0x65, 0x74, 0x62, 0x61, 0x6c, 0x6c, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x2e,
  0x63, 0x73, 0x73, 0x61, 0x6e, 0x20, 0x65, 0x61, 0x72, 0x6c, 0x69, 0x65, 0x72,
  0x65, 0x76, 0x65, 0x6e, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x2f, 0x22, 0x20,
  0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x69,
  0x6e, 0x64, 0x65, 0x78, 0x74, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x65, 0x70, 0x69, 0x74, 0x74, 0x73, 0x62, 0x75, 0x72, 0x67, 0x68, 0x63, 0x6f,
  0x6e, 0x74, 0x65, 0x6e, 0x74, 0x22, 0x3e, 0x0d, 0x3c, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x28, 0x66, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x6f,
  0x75, 0x74, 0x68, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x3c,
  0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x0d, 0x0a, 0x20, 0x6f, 0x63, 0x63, 0x61,
  0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65,
  0x20, 0x69, 0x74, 0x73, 0x74, 0x61, 0x72, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x3e, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x20, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x43, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79,
  0x2c, 0x20, 0x62, 0x67, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3d, 0x22, 0x74, 0x61,
  0x62, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x61, 0x73,
  0x74, 0x72, 0x6f, 0x75, 0x73, 0x41, 0x6e, 0x61, 0x6c, 0x79, 0x74, 0x69, 0x63,
  0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x68, 0x61, 0x73, 0x20, 0x61, 0x3e,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x3c, 0x2f, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3e, 0x0a, 0x3c, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20,
  0x66, 0x6f, 0x72, 0x73, 0x69, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x61, 0x6e, 0x64,
  0x2e, 0x73, 0x72, 0x63, 0x20, 0x3d, 0x20, 0x22, 0x2f, 0x2f, 0x76, 0x69, 0x6f,
  0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x68, 0x69, 0x73, 0x20, 0x70,
  0x6f, 0x69, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x6c,
  0x79, 0x69, 0x73, 0x20, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65, 0x64, 0x72, 0x65,
  0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x64, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x65, 0x64, 0x65, 0x72, 0x6c, 0x61, 0x6e,
  0x64, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xc3, 0xaa, 0x73, 0xd7,
  0xa2, 0xd7, 0x91, 0xd7, 0xa8, 0xd7, 0x99, 0xd7, 0xaa, 0xd9, 0x81, 0xd8, 0xa7,
  0xd8, 0xb1, 0xd8, 0xb3, 0xdb, 0x8c, 0x64, 0x65, 0x73, 0x61, 0x72, 0x72, 0x6f,
  0x6c, 0x6c, 0x6f, 0x63, 0x6f, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x69, 0x6f,
  0x65, 0x64, 0x75, 0x63, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x73, 0x65, 0x70,
  0x74, 0x69, 0x65, 0x6d, 0x62, 0x72, 0x65, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
  0x72, 0x61, 0x64, 0x6f, 0x64, 0x69, 0x72, 0x65, 0x63, 0x63, 0x69, 0xc3, 0xb3,
  0x6e, 0x75, 0x62, 0x69, 0x63, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70, 0x75,
  0x62, 0x6c, 0x69, 0x63, 0x69, 0x64, 0x61, 0x64, 0x72, 0x65, 0x73, 0x70, 0x75,
  0x65, 0x73, 0x74, 0x61, 0x73, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x61, 0x64,
  0x6f, 0x73, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x65, 0x72,
  0x65, 0x73, 0x65, 0x72, 0x76, 0x61, 0x64, 0x6f, 0x73, 0x61, 0x72, 0x74, 0xc3,
  0xad, 0x63, 0x75, 0x6c, 0x6f, 0x73, 0x64, 0x69, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x74, 0x65, 0x73, 0x73, 0x69, 0x67, 0x75, 0x69, 0x65, 0x6e, 0x74, 0x65, 0x73,
  0x72, 0x65, 0x70, 0xc3, 0xba, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x73, 0x69, 0x74,
  0x75, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74,
  0x65, 0x72, 0x69, 0x6f, 0x70, 0x72, 0x69, 0x76, 0x61, 0x63, 0x69, 0x64, 0x61,
  0x64, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x69, 0x6f, 0x66, 0x6f,
  0x72, 0x6d, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70, 0x6f, 0x62, 0x6c, 0x61,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e,
  0x74, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x69, 0x64, 0x6f, 0x73, 0x61,
  0x63, 0x63, 0x65, 0x73, 0x6f, 0x72, 0x69, 0x6f, 0x73, 0x74, 0x65, 0x63, 0x68,
  0x6e, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61,
  0x6c, 0x65, 0x73, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0xc3, 0xad, 0x61,
  0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x65, 0x73, 0x64, 0x69, 0x73,
  0x70, 0x6f, 0x6e, 0x69, 0x62, 0x6c, 0x65, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c,
  0x69, 0x64, 0x61, 0x64, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69,
  0x61, 0x76, 0x61, 0x6c, 0x6c, 0x61, 0x64, 0x6f, 0x6c, 0x69, 0x64, 0x62, 0x69,
  0x62, 0x6c, 0x69, 0x6f, 0x74, 0x65, 0x63, 0x61, 0x72, 0x65, 0x6c, 0x61, 0x63,
  0x69, 0x6f, 0x6e, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x64, 0x61, 0x72,
  0x69, 0x6f, 0x70, 0x6f, 0x6c, 0xc3, 0xad, 0x74, 0x69, 0x63, 0x61, 0x73, 0x61,
  0x6e, 0x74, 0x65, 0x72, 0x69, 0x6f, 0x72, 0x65, 0x73, 0x64, 0x6f, 0x63, 0x75,
  0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x73, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c,
  0x65, 0x7a, 0x61, 0x6d, 0x61, 0x74, 0x65, 0x72, 0x69, 0x61, 0x6c, 0x65, 0x73,
  0x64, 0x69, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x65, 0x63, 0x6f,
  0x6e, 0xc3, 0xb3, 0x6d, 0x69, 0x63, 0x61, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70,
  0x6f, 0x72, 0x74, 0x65, 0x72, 0x6f, 0x64, 0x72, 0xc3, 0xad, 0x67, 0x75, 0x65,
  0x7a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x72, 0x65, 0x6e,
  0x63, 0x75, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x63, 0x75,
  0x73, 0x69, 0xc3, 0xb3, 0x6e, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75,
  0x72, 0x61, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x66,
  0x72, 0x65, 0x63, 0x75, 0x65, 0x6e, 0x74, 0x65, 0x73, 0x70, 0x65, 0x72, 0x6d,
  0x61, 0x6e, 0x65, 0x6e, 0x74, 0x65, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x6d, 0x65,
  0x6e, 0x74, 0x65, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd0, 0xb1, 0xd1, 0x83, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xbc, 0xd0,
  0xbe, 0xd0, 0xb6, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb2, 0xd1, 0x80, 0xd0, 0xb5,
  0xd0, 0xbc, 0xd1, 0x8f, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xb6, 0xd0,
  0xb5, 0xd1, 0x87, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x8b, 0xd0, 0xb1,
  0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0xbe, 0xd1, 0x87, 0xd0,
  0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb3,
  0xd0, 0xbe, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0,
  0xbf, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb2, 0xd1, 0x81,
  0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xb9, 0xd1,
  0x82, 0xd0, 0xb5, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb7,
  0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb3, 0xd1, 0x83, 0xd1, 0x82, 0xd1, 0x81, 0xd0,
  0xb0, 0xd0, 0xb9, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xb6, 0xd0, 0xb8, 0xd0, 0xb7,
  0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xb6, 0xd0, 0xb4, 0xd1,
  0x83, 0xd0, 0xb1, 0xd1, 0x83, 0xd0, 0xb4, 0xd1, 0x83, 0xd1, 0x82, 0xd0, 0x9f,
  0xd0, 0xbe, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb7, 0xd0, 0xb4, 0xd0,
  0xb5, 0xd1, 0x81, 0xd1, 0x8c, 0xd0, 0xb2, 0xd0, 0xb8, 0xd0, 0xb4, 0xd0, 0xb5,
  0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb2, 0xd1, 0x8f, 0xd0, 0xb7, 0xd0, 0xb8, 0xd0,
  0xbd, 0xd1, 0x83, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb2,
  0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xb9, 0xd0, 0xbb, 0xd1, 0x8e, 0xd0, 0xb4, 0xd0,
  0xb5, 0xd0, 0xb9, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd0, 0xbc, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0,
  0xb5, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xb9, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe,
  0xd0, 0xb8, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0,
  0xb0, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0, 0xbc,
  0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0,
  0xb5, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb6, 0xd0, 0xb8, 0xd0, 0xb7, 0xd0, 0xbd,
  0xd1, 0x8c, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0,
  0xbb, 0xd1, 0x83, 0xd1, 0x87, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xbf, 0xd0, 0xb5,
  0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x81, 0xd1,
  0x82, 0xd0, 0xb8, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x8c,
  0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbd, 0xd0,
  0xbe, 0xd0, 0xb2, 0xd1, 0x8b, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb0,
  0xd0, 0xb2, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0, 0xbe, 0xd0,
  0xb9, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbc,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb5, 0xd1, 0x87, 0xd0, 0xb8, 0xd1,
  0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x8b,
  0xd0, 0xb5, 0xd1, 0x83, 0xd1, 0x81, 0xd0, 0xbb, 0xd1, 0x83, 0xd0, 0xb3, 0xd0,
  0xbe, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0, 0xb0,
  0xd0, 0xb7, 0xd0, 0xb0, 0xd0, 0xb4, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba, 0xd0,
  0xbe, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb0,
  0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x87, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0x9f, 0xd0,
  0xbe, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xba,
  0xd0, 0xb8, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x8b, 0xd0,
  0xb9, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb8, 0xd1, 0x82, 0xd1, 0x82,
  0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xb8, 0xd1, 0x85, 0xd1, 0x81, 0xd1, 0x80, 0xd0,
  0xb0, 0xd0, 0xb7, 0xd1, 0x83, 0xd0, 0xa1, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xba,
  0xd1, 0x82, 0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xbc, 0xd0,
  0x9a, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xbd,
  0xd0, 0xb8, 0xd0, 0xb3, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0,
  0xb2, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xb9,
  0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb9, 0xd1, 0x82, 0xd0, 0xb8, 0xd1, 0x81, 0xd0,
  0xb2, 0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xbc, 0xd1, 0x81, 0xd0, 0xb2, 0xd1, 0x8f,
  0xd0, 0xb7, 0xd1, 0x8c, 0xd0, 0xbb, 0xd1, 0x8e, 0xd0, 0xb1, 0xd0, 0xbe, 0xd0,
  0xb9, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x81,
  0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb8, 0xd0, 0x9a, 0xd1, 0x80, 0xd0,
  0xbe, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xa4, 0xd0, 0xbe, 0xd1, 0x80, 0xd1, 0x83,
  0xd0, 0xbc, 0xd1, 0x80, 0xd1, 0x8b, 0xd0, 0xbd, 0xd0, 0xba, 0xd0, 0xb5, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xbf, 0xd0, 0xbe,
  0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xba, 0xd1, 0x82, 0xd1, 0x8b, 0xd1, 0x81, 0xd1,
  0x8f, 0xd1, 0x87, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x8f, 0xd1, 0x86,
  0xd1, 0x86, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x82, 0xd1, 0x80, 0xd1, 0x82, 0xd1,
  0x80, 0xd1, 0x83, 0xd0, 0xb4, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xbc,
  0xd1, 0x8b, 0xd1, 0x85, 0xd1, 0x80, 0xd1, 0x8b, 0xd0, 0xbd, 0xd0, 0xba, 0xd0,
  0xb0, 0xd0, 0x9d, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x8b, 0xd0, 0xb9, 0xd1, 0x87,
  0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xb0, 0xd1, 0x84, 0xd0, 0xb8, 0xd0, 0xbb, 0xd1, 0x8c,
  0xd0, 0xbc, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x82, 0xd0, 0xb0, 0xd1,
  0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xbc, 0xd0, 0xb5,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xba, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x88, 0xd0, 0xb8, 0xd1, 0x85,
  0xd0, 0xbc, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x83, 0xd1, 0x82, 0xd0, 0xb8, 0xd0,
  0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb5,
  0xd1, 0x8e, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1,
  0x80, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb4, 0xd1, 0x81,
  0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x8d, 0xd1, 0x82, 0xd0,
  0xbe, 0xd0, 0xbc, 0xd1, 0x83, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbd, 0xd1, 0x86,
  0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xba, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0, 0x90, 0xd1, 0x80,
  0xd1, 0x85, 0xd0, 0xb8, 0xd0, 0xb2, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xaa, 0xd8,
  0xaf, 0xd9, 0x89, 0xd8, 0xa5, 0xd8, 0xb1, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb1, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x85, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa8,
  0xd9, 0x87, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x85, 0xd8,
  0xac, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x88, 0xd9, 0x85, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xb5, 0xd9, 0x88, 0xd8, 0xb1, 0xd8, 0xac, 0xd8, 0xaf, 0xd9,
  0x8a, 0xd8, 0xaf, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xb6,
  0xd9, 0x88, 0xd8, 0xa5, 0xd8, 0xb6, 0xd8, 0xa7, 0xd9, 0x81, 0xd8, 0xa9, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x82, 0xd8, 0xb3, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb9, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xaa, 0xd8, 0xad, 0xd9, 0x85, 0xd9,
  0x8a, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x84, 0xd9, 0x81, 0xd8, 0xa7, 0xd8, 0xaa,
  0xd9, 0x85, 0xd9, 0x84, 0xd8, 0xaa, 0xd9, 0x82, 0xd9, 0x89, 0xd8, 0xaa, 0xd8,
  0xb9, 0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb4,
  0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa3, 0xd8, 0xae, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd8, 0xaa, 0xd8, 0xb7, 0xd9, 0x88, 0xd9, 0x8a, 0xd8, 0xb1, 0xd8, 0xb9,
  0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xa5, 0xd8, 0xb1, 0xd9,
  0x81, 0xd8, 0xa7, 0xd9, 0x82, 0xd8, 0xb7, 0xd9, 0x84, 0xd8, 0xa8, 0xd8, 0xa7,
  0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x84, 0xd8, 0xba, 0xd8, 0xa9, 0xd8,
  0xaa, 0xd8, 0xb1, 0xd8, 0xaa, 0xd9, 0x8a, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84,
  0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb4, 0xd9,
  0x8a, 0xd8, 0xae, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xaf, 0xd9, 0x8a,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9,
  0x84, 0xd9, 0x82, 0xd8, 0xb5, 0xd8, 0xb5, 0xd8, 0xa7, 0xd9, 0x81, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x87, 0xd8,
  0xa7, 0xd8, 0xaa, 0xd8, 0xad, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xab, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x84, 0xd9, 0x87, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xb9, 0xd9, 0x85, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa8,
  0xd8, 0xa9, 0xd9, 0x8a, 0xd9, 0x85, 0xd9, 0x83, 0xd9, 0x86, 0xd9, 0x83, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xb7, 0xd9, 0x81, 0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x8a,
  0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x88, 0xd8, 0xa5, 0xd8, 0xaf, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd8, 0xa9, 0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xb1, 0xd9, 0x8a, 0xd8, 0xae,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb5, 0xd8, 0xad, 0xd8, 0xa9, 0xd8, 0xaa, 0xd8,
  0xb3, 0xd8, 0xac, 0xd9, 0x8a, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x88,
  0xd9, 0x82, 0xd8, 0xaa, 0xd8, 0xb9, 0xd9, 0x86, 0xd8, 0xaf, 0xd9, 0x85, 0xd8,
  0xa7, 0xd9, 0x85, 0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xa9, 0xd8, 0xaa,
  0xd8, 0xb5, 0xd9, 0x85, 0xd9, 0x8a, 0xd9, 0x85, 0xd8, 0xa3, 0xd8, 0xb1, 0xd8,
  0xb4, 0xd9, 0x8a, 0xd9, 0x81, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb0, 0xd9, 0x8a,
  0xd9, 0x86, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa8, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8,
  0xa8, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa9, 0xd8, 0xa3, 0xd9, 0x84,
  0xd8, 0xb9, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd9,
  0x81, 0xd8, 0xb1, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd9, 0x83, 0xd9, 0x84,
  0xd8, 0xaa, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x89, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xa3, 0xd9, 0x88, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3,
  0xd9, 0x86, 0xd8, 0xa9, 0xd8, 0xac, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xb9, 0xd8,
  0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb5, 0xd8, 0xad, 0xd9, 0x81, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x86, 0xd9, 0x83, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xae, 0xd8, 0xa7,
  0xd8, 0xb5, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x84, 0xd9, 0x81, 0xd8,
  0xa3, 0xd8, 0xb9, 0xd8, 0xb6, 0xd8, 0xa7, 0xd8, 0xa1, 0xd9, 0x83, 0xd8, 0xaa,
  0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xae, 0xd9,
  0x8a, 0xd8, 0xb1, 0xd8, 0xb1, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8, 0xa6, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x82, 0xd9, 0x84, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xa3, 0xd8, 0xaf, 0xd8, 0xa8, 0xd9, 0x85, 0xd9, 0x82, 0xd8, 0xa7,
  0xd8, 0xb7, 0xd8, 0xb9, 0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xa7, 0xd8, 0xb3, 0xd9,
  0x84, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xb7, 0xd9, 0x82, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xb1, 0xd8, 0xac, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xb4, 0xd8, 0xaa, 0xd8, 0xb1,
  0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x82, 0xd8, 0xaf, 0xd9, 0x85, 0xd9,
  0x8a, 0xd8, 0xb9, 0xd8, 0xb7, 0xd9, 0x8a, 0xd9, 0x83, 0x73, 0x42, 0x79, 0x54,
  0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x28, 0x2e, 0x6a, 0x70, 0x67, 0x22, 0x20,
  0x61, 0x6c, 0x74, 0x3d, 0x22, 0x31, 0x70, 0x78, 0x20, 0x73, 0x6f, 0x6c, 0x69,
  0x64, 0x20, 0x23, 0x2e, 0x67, 0x69, 0x66, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d,
  0x22, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x69,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x70, 0x70,
  0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x20, 0x6f, 0x6e, 0x63,
  0x6c, 0x69, 0x63, 0x6b, 0x3d, 0x22, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69,
  0x73, 0x68, 0x65, 0x64, 0x61, 0x64, 0x76, 0x65, 0x72, 0x74, 0x69, 0x73, 0x69,
  0x6e, 0x67, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22,
  0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x70, 0x65,
  0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x61, 0x70, 0x70, 0x72,
  0x6f, 0x70, 0x72, 0x69, 0x61, 0x74, 0x65, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6d,
  0x64, 0x61, 0x73, 0x68, 0x3b, 0x69, 0x6d, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
  0x65, 0x6c, 0x79, 0x3c, 0x2f, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x67, 0x3e, 0x3c,
  0x2f, 0x72, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x74,
  0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x64, 0x65, 0x76,
  0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x70, 0x65,
  0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f,
  0x6c, 0x64, 0x65, 0x72, 0x76, 0x69, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
  0x79, 0x3a, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3e,
  0x30, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x65, 0x76,
  0x65, 0x6e, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x72, 0x65, 0x70, 0x6c,
  0x61, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x3c, 0x75, 0x6c, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x41, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x69,
  0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c, 0x73, 0x70, 0x65, 0x72,
  0x73, 0x70, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x73, 0x65, 0x74, 0x54, 0x69,
  0x6d, 0x65, 0x6f, 0x75, 0x74, 0x28, 0x75, 0x72, 0x6c, 0x28, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x6d, 0x61, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x69,
  0x63, 0x73, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x74, 0x6f, 0x70, 0x3a,
  0x65, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x64, 0x65,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x29, 0x20, 0x6e, 0x6f,
  0x2d, 0x72, 0x65, 0x70, 0x65, 0x61, 0x74, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4a, 0x50, 0x47, 0x7c, 0x74, 0x68, 0x75,
  0x6d, 0x62, 0x7c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74,
  0x65, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x66,
  0x6c, 0x6f, 0x61, 0x74, 0x3a, 0x6c, 0x65, 0x66, 0x74, 0x3b, 0x3c, 0x6c, 0x69,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x68, 0x75, 0x6e, 0x64, 0x72,
  0x65, 0x64, 0x73, 0x20, 0x6f, 0x66, 0x0a, 0x0a, 0x48, 0x6f, 0x77, 0x65, 0x76,
  0x65, 0x72, 0x2c, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x3a, 0x62, 0x6f, 0x74, 0x68, 0x3b,
  0x63, 0x6f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x77, 0x69,
  0x74, 0x68, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61, 0x62, 0x65,
  0x6c, 0x20, 0x66, 0x6f, 0x72, 0x3d, 0x22, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x2d, 0x74, 0x6f, 0x70, 0x3a, 0x4e, 0x65, 0x77, 0x20, 0x5a, 0x65, 0x61, 0x6c,
  0x61, 0x6e, 0x64, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64, 0x65,
  0x64, 0x70, 0x68, 0x6f, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x79, 0x69,
  0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x26, 0x6c, 0x74,
  0x3b, 0x73, 0x75, 0x70, 0x26, 0x67, 0x74, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x72,
  0x6f, 0x76, 0x65, 0x72, 0x73, 0x79, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c,
  0x61, 0x6e, 0x64, 0x73, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x6d, 0x61, 0x78, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x3d, 0x22,
  0x73, 0x77, 0x69, 0x74, 0x7a, 0x65, 0x72, 0x6c, 0x61, 0x6e, 0x64, 0x44, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x73, 0x73, 0x65,
  0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x0a, 0x0a, 0x41, 0x6c, 0x74, 0x68,
  0x6f, 0x75, 0x67, 0x68, 0x20, 0x3c, 0x2f, 0x74, 0x65, 0x78, 0x74, 0x61, 0x72,
  0x65, 0x61, 0x3e, 0x74, 0x68, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x62, 0x69, 0x72,
  0x64, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x26,
  0x61, 0x6d, 0x70, 0x3b, 0x6e, 0x64, 0x61, 0x73, 0x68, 0x3b, 0x73, 0x70, 0x65,
  0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x75,
  0x6e, 0x69, 0x74, 0x69, 0x65, 0x73, 0x6c, 0x65, 0x67, 0x69, 0x73, 0x6c, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x6f, 0x6e, 0x69,
  0x63, 0x73, 0x0a, 0x09, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22,
  0x69, 0x6c, 0x6c, 0x75, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x64, 0x65, 0x6e,
  0x67, 0x69, 0x6e, 0x65, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x74, 0x65, 0x72, 0x72,
  0x69, 0x74, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72,
  0x69, 0x74, 0x69, 0x65, 0x73, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x65, 0x64, 0x36, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d,
  0x22, 0x73, 0x61, 0x6e, 0x73, 0x2d, 0x73, 0x65, 0x72, 0x69, 0x66, 0x3b, 0x63,
  0x61, 0x70, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x69, 0x73,
  0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x69, 0x6e, 0x74, 0x65, 0x72,
  0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x6f, 0x6f, 0x6b, 0x69, 0x6e, 0x67,
  0x20, 0x66, 0x6f, 0x72, 0x69, 0x74, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20,
  0x62, 0x65, 0x41, 0x66, 0x67, 0x68, 0x61, 0x6e, 0x69, 0x73, 0x74, 0x61, 0x6e,
  0x77, 0x61, 0x73, 0x20, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x4d, 0x61,
  0x74, 0x68, 0x2e, 0x66, 0x6c, 0x6f, 0x6f, 0x72, 0x28, 0x73, 0x75, 0x72, 0x72,
  0x6f, 0x75, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x63, 0x61, 0x6e, 0x20, 0x61, 0x6c,
  0x73, 0x6f, 0x20, 0x62, 0x65, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x6e, 0x63,
  0x65, 0x65, 0x6e, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x64, 0x3c,
  0x68, 0x32, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x6f, 0x72,
  0x65, 0x20, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x20, 0x68, 0x61,
  0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x69, 0x6e, 0x76, 0x61, 0x73, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x29, 0x2e, 0x67, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65,
  0x28, 0x29, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x6c,
  0x44, 0x65, 0x73, 0x70, 0x69, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65, 0x22, 0x3e,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x69, 0x6e, 0x73, 0x70,
  0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x78, 0x61, 0x6d, 0x69, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x72, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x65, 0x78, 0x70, 0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x3c,
  0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x76, 0x65, 0x72,
  0x73, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x73, 0x74, 0x72,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x20, 0x3d, 0x20, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e,
  0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x20, 0x2e, 0x73,
  0x75, 0x62, 0x73, 0x74, 0x72, 0x69, 0x6e, 0x67, 0x28, 0x65, 0x61, 0x63, 0x68,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69,
  0x6d, 0x65, 0x6e, 0x74, 0x73, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x74,
  0x69, 0x61, 0x6c, 0x69, 0x6e, 0x74, 0x65, 0x67, 0x72, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x64,
  0x75, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6d,
  0x62, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x6f, 0x20, 0x6e, 0x6f,
  0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x4d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x20,
  0x45, 0x61, 0x73, 0x74, 0x3c, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x3c, 0x63, 0x6f, 0x70, 0x79, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x20,
  0x70, 0x65, 0x72, 0x68, 0x61, 0x70, 0x73, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e,
  0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x20, 0x44,
  0x65, 0x63, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x61, 0x72, 0x72, 0x61, 0x6e, 0x67,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x66, 0x61, 0x6d,
  0x6f, 0x75, 0x73, 0x70, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x74,
  0x79, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6c,
  0x69, 0x6d, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x78, 0x63,
  0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x73, 0x6f, 0x76, 0x65, 0x72,
  0x65, 0x69, 0x67, 0x6e, 0x74, 0x79, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
  0x74, 0x22, 0x3e, 0x0a, 0x3c, 0x74, 0x64, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
  0x70, 0x61, 0x72, 0x61, 0x6c, 0x6c, 0x65, 0x6c, 0x20, 0x74, 0x6f, 0x64, 0x6f,
  0x63, 0x74, 0x72, 0x69, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x6f, 0x63, 0x63, 0x75,
  0x70, 0x69, 0x65, 0x64, 0x20, 0x62, 0x79, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x6f, 0x6c, 0x6f, 0x67, 0x79, 0x52, 0x65, 0x6e, 0x61, 0x69, 0x73, 0x73, 0x61,
  0x6e, 0x63, 0x65, 0x61, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x66, 0x6f, 0x72, 0x65,
  0x78, 0x70, 0x6c, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63,
  0x6f, 0x67, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x72, 0x65, 0x64, 0x65,
  0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72,
  0x63, 0x3d, 0x22, 0x2f, 0x3c, 0x68, 0x31, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x6d, 0x61, 0x79, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x62, 0x65, 0x73, 0x70,
  0x65, 0x63, 0x69, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x64, 0x3c, 0x2f, 0x66, 0x69,
  0x65, 0x6c, 0x64, 0x73, 0x65, 0x74, 0x3e, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x65,
  0x73, 0x73, 0x69, 0x76, 0x65, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x6f, 0x6e, 0x73,
  0x20, 0x6f, 0x66, 0x73, 0x74, 0x61, 0x74, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x65, 0x6e, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
  0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x65,
  0x20, 0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x2e, 0x70, 0x61, 0x72, 0x65,
  0x6e, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x61, 0x67, 0x72, 0x69, 0x63, 0x75, 0x6c,
  0x74, 0x75, 0x72, 0x65, 0x41, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x72, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x65, 0x72, 0x73,
  0x74, 0x6f, 0x77, 0x61, 0x72, 0x64, 0x73, 0x20, 0x74, 0x68, 0x65, 0x4d, 0x6f,
  0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x6e, 0x79,
  0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x28, 0x65, 0x73, 0x70, 0x65, 0x63,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x3c, 0x74, 0x64, 0x20, 0x77, 0x69, 0x64, 0x74,
  0x68, 0x3d, 0x22, 0x3b, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x31, 0x30, 0x30,
  0x25, 0x69, 0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x3c,
  0x68, 0x33, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x20, 0x6f, 0x6e,
  0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x3d, 0x22, 0x29, 0x2e, 0x61, 0x64, 0x64,
  0x43, 0x6c, 0x61, 0x73, 0x73, 0x28, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x4f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x64, 0x61, 0x75, 0x67, 0x68, 0x74, 0x65, 0x72, 0x20, 0x6f, 0x66,
  0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x62, 0x72,
  0x61, 0x6e, 0x63, 0x68, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x0d, 0x0a, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61,
  0x72, 0x67, 0x65, 0x73, 0x74, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x72, 0x65, 0x67, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74,
  0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x6f, 0x63,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x79, 0x69, 0x6e, 0x20, 0x6f, 0x72,
  0x64, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x22, 0x3e, 0x0a, 0x3c, 0x68, 0x65, 0x61,
  0x64, 0x3e, 0x0a, 0x3c, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d,
  0x22, 0x31, 0x61, 0x63, 0x72, 0x6f, 0x73, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x6f, 0x72, 0x69, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x29, 0x3b,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x69, 0x6d, 0x70, 0x6c,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65,
  0x20, 0x73, 0x65, 0x65, 0x6e, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61,
  0x73, 0x20, 0x61, 0x64, 0x65, 0x6d, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x74,
  0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x22, 0x3e, 0x63,
  0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x68, 0x65,
  0x20, 0x42, 0x72, 0x69, 0x74, 0x69, 0x73, 0x68, 0x77, 0x61, 0x73, 0x20, 0x77,
  0x72, 0x69, 0x74, 0x74, 0x65, 0x6e, 0x21, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74,
  0x61, 0x6e, 0x74, 0x3b, 0x70, 0x78, 0x3b, 0x20, 0x6d, 0x61, 0x72, 0x67, 0x69,
  0x6e, 0x2d, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x63, 0x6f,
  0x6d, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64, 0x64, 0x75, 0x72, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69, 0x6d, 0x6d, 0x69, 0x67, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x63, 0x61, 0x6c,
  0x6c, 0x65, 0x64, 0x3c, 0x68, 0x34, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x72,
  0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x62, 0x79, 0x67, 0x6f, 0x76,
  0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x6c, 0x6f, 0x63, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x4e, 0x6f, 0x76, 0x65,
  0x6d, 0x62, 0x65, 0x72, 0x77, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x3c, 0x2f, 0x70, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x61, 0x63, 0x71, 0x75, 0x69, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x61,
  0x6c, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x72, 0x73,
  0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7b, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69,
  0x7a, 0x65, 0x3a, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x20, 0x69,
  0x6e, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x65, 0x65,
  0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x6d, 0x6f, 0x73,
  0x74, 0x20, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x79, 0x77, 0x69, 0x64, 0x65, 0x6c,
  0x79, 0x20, 0x75, 0x73, 0x65, 0x64, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73,
  0x69, 0x6f, 0x6e, 0x73, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x63, 0x65, 0x20,
  0x6f, 0x66, 0x20, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
  0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x49, 0x74,
  0x20, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x69, 0x74, 0x20, 0x64,
  0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61,
  0x72, 0x79, 0x20, 0x74, 0x6f, 0x69, 0x6e, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61,
  0x6e, 0x74, 0x73, 0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x73, 0x63, 0x68, 0x6f, 0x6c, 0x61, 0x72, 0x73, 0x68, 0x69, 0x70, 0x63,
  0x6f, 0x6e, 0x73, 0x75, 0x6d, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x73,
  0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x20, 0x65,
  0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x72, 0x20,
  0x6d, 0x6f, 0x72, 0x65, 0x70, 0x78, 0x3b, 0x20, 0x70, 0x61, 0x64, 0x64, 0x69,
  0x6e, 0x67, 0x74, 0x68, 0x65, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74,
  0x61, 0x20, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x61, 0x72,
  0x65, 0x20, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x72, 0x6f, 0x6c, 0x65,
  0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x70, 0x72, 0x65, 0x76, 0x69, 0x6f,
  0x75, 0x73, 0x6c, 0x79, 0x20, 0x64, 0x65, 0x72, 0x69, 0x76, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x73, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x6f,
  0x66, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x63,
  0x6f, 0x6c, 0x6f, 0x72, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x74, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x63, 0x65, 0x72, 0x74, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x0a, 0x20, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64,
  0x3d, 0x22, 0x68, 0x69, 0x67, 0x68, 0x20, 0x73, 0x63, 0x68, 0x6f, 0x6f, 0x6c,
  0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x74, 0x6f, 0x63, 0x6f,
  0x6d, 0x66, 0x6f, 0x72, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x61, 0x64, 0x6f, 0x70,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x72, 0x65, 0x65, 0x20,
  0x79, 0x65, 0x61, 0x72, 0x73, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x75, 0x6e,
  0x74, 0x72, 0x79, 0x69, 0x6e, 0x20, 0x46, 0x65, 0x62, 0x72, 0x75, 0x61, 0x72,
  0x79, 0x73, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x77, 0x68, 0x6f, 0x20, 0x70, 0x72, 0x6f,
  0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x62, 0x79, 0x3c, 0x70, 0x61, 0x72, 0x61,
  0x6d, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x61, 0x66, 0x66, 0x65, 0x63, 0x74, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x69, 0x6e, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x73, 0x20,
  0x6f, 0x66, 0x61, 0x70, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x6d, 0x65, 0x6e, 0x74,
  0x49, 0x53, 0x4f, 0x2d, 0x38, 0x38, 0x35, 0x39, 0x2d, 0x31, 0x22, 0x77, 0x61,
  0x73, 0x20, 0x62, 0x6f, 0x72, 0x6e, 0x20, 0x69, 0x6e, 0x68, 0x69, 0x73, 0x74,
  0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64,
  0x65, 0x64, 0x20, 0x61, 0x73, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x69, 0x73, 0x20, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f,
  0x6e, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x3a,
  0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x73, 0x69, 0x67,
  0x6e, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6e, 0x74, 0x63, 0x65, 0x6c, 0x65, 0x62,
  0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6d, 0x69,
  0x74, 0x74, 0x65, 0x64, 0x2f, 0x6a, 0x73, 0x2f, 0x6a, 0x71, 0x75, 0x65, 0x72,
  0x79, 0x2e, 0x69, 0x73, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73,
  0x74, 0x68, 0x65, 0x6f, 0x72, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x74,
  0x61, 0x62, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x3d, 0x22, 0x69, 0x74, 0x20, 0x63,
  0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65, 0x3c, 0x6e, 0x6f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0a, 0x68, 0x61, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x62,
  0x65, 0x65, 0x6e, 0x0d, 0x0a, 0x3c, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0d, 0x0a,
  0x3c, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x54, 0x68, 0x65, 0x20, 0x63,
  0x6f, 0x6d, 0x70, 0x69, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x68, 0x65, 0x20,
  0x68, 0x61, 0x64, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x64, 0x75,
  0x63, 0x65, 0x64, 0x20, 0x62, 0x79, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f,
  0x70, 0x68, 0x65, 0x72, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
  0x65, 0x64, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x61, 0x6d, 0x6f, 0x6e, 0x67, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x63, 0x6f,
  0x6d, 0x70, 0x61, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x74, 0x6f, 0x20, 0x73,
  0x61, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65,
  0x65, 0x72, 0x69, 0x6e, 0x67, 0x61, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72,
  0x65, 0x6e, 0x74, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74,
  0x6f, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x62,
  0x65, 0x6c, 0x69, 0x65, 0x66, 0x20, 0x74, 0x68, 0x61, 0x74, 0x70, 0x68, 0x6f,
  0x74, 0x6f, 0x67, 0x72, 0x61, 0x70, 0x68, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74,
  0x69, 0x66, 0x79, 0x69, 0x6e, 0x67, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79,
  0x20, 0x6f, 0x66, 0x20, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20,
  0x6f, 0x66, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73, 0x61, 0x72, 0x69, 0x6c, 0x79,
  0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x74, 0x65,
  0x63, 0x68, 0x6e, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x6c, 0x65, 0x61, 0x76,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x61,
  0x63, 0x75, 0x6c, 0x61, 0x72, 0x66, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x69, 0x63, 0x69, 0x74,
  0x79, 0x68, 0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x73, 0x74, 0x61, 0x75, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x70, 0x61, 0x72,
  0x74, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x65, 0x6d, 0x70, 0x68, 0x61,
  0x73, 0x69, 0x73, 0x20, 0x6f, 0x6e, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x72, 0x65,
  0x63, 0x65, 0x6e, 0x74, 0x73, 0x68, 0x61, 0x72, 0x65, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x20, 0x73, 0x61, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x66, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x64, 0x65,
  0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x69, 0x74, 0x20, 0x69,
  0x73, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x22, 0x3e, 0x3c, 0x2f, 0x69, 0x66,
  0x72, 0x61, 0x6d, 0x65, 0x3e, 0x61, 0x73, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x73, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x63,
  0x6f, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x70, 0x6f, 0x69,
  0x6e, 0x74, 0x65, 0x64, 0x20, 0x6f, 0x75, 0x74, 0x6f, 0x70, 0x70, 0x6f, 0x72,
  0x74, 0x75, 0x6e, 0x69, 0x74, 0x79, 0x76, 0x69, 0x65, 0x77, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x64, 0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x69, 0x6e, 0x67, 0x68, 0x65,
  0x20, 0x72, 0x65, 0x63, 0x65, 0x69, 0x76, 0x65, 0x64, 0x73, 0x65, 0x74, 0x49,
  0x6e, 0x74, 0x65, 0x72, 0x76, 0x61, 0x6c, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x70,
  0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x69, 0x6e, 0x20, 0x4e, 0x65, 0x77, 0x20, 0x59,
  0x6f, 0x72, 0x6b, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
  0x20, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x0a,
  0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x69, 0x6e, 0x63,
  0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x65, 0x3b, 0x3c, 0x2f, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x45,
  0x76, 0x65, 0x6e, 0x74, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x22, 0x5f,
  0x63, 0x61, 0x72, 0x72, 0x69, 0x65, 0x64, 0x20, 0x6f, 0x75, 0x74, 0x53, 0x6f,
  0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x63, 0x69, 0x65,
  0x6e, 0x63, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69,
  0x6d, 0x65, 0x20, 0x6f, 0x66, 0x43, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
  0x72, 0x22, 0x3e, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x69, 0x6e,
  0x67, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x6f, 0x70, 0x68, 0x65, 0x72, 0x4d,
  0x75, 0x63, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x77, 0x72, 0x69,
  0x74, 0x69, 0x6e, 0x67, 0x73, 0x20, 0x6f, 0x66, 0x22, 0x20, 0x68, 0x65, 0x69,
  0x67, 0x68, 0x74, 0x3d, 0x22, 0x32, 0x73, 0x69, 0x7a, 0x65, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x66, 0x20, 0x6d, 0x69, 0x78, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x45, 0x78,
  0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x65, 0x64, 0x75, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74,
  0x69, 0x74, 0x69, 0x76, 0x65, 0x20, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x6d, 0x69,
  0x74, 0x3d, 0x22, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x20, 0x6f,
  0x66, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x69, 0x76, 0x65, 0x2f,
  0x44, 0x54, 0x44, 0x20, 0x58, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x72, 0x65, 0x6c,
  0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x74, 0x65, 0x6e, 0x64, 0x65,
  0x6e, 0x63, 0x79, 0x20, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x6e, 0x63,
  0x65, 0x20, 0x6f, 0x66, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x77, 0x6f, 0x75,
  0x6c, 0x64, 0x64, 0x65, 0x73, 0x70, 0x69, 0x74, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x20, 0x6c, 0x65,
  0x67, 0x69, 0x73, 0x6c, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2e, 0x69, 0x6e, 0x6e,
  0x65, 0x72, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x61, 0x6c, 0x6c, 0x65, 0x67, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x41, 0x67, 0x72, 0x69, 0x63, 0x75, 0x6c, 0x74,
  0x75, 0x72, 0x65, 0x77, 0x61, 0x73, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x69,
  0x6e, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x61, 0x63, 0x68, 0x20, 0x74, 0x6f, 0x69,
  0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x74, 0x79, 0x65, 0x61,
  0x72, 0x73, 0x20, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x2c, 0x73, 0x61, 0x6e, 0x73,
  0x2d, 0x73, 0x65, 0x72, 0x69, 0x66, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
  0x6e, 0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e,
  0x63, 0x65, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x61, 0x6e, 0x63, 0x65, 0x73,
  0x2c, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x66, 0x6f,
  0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x62, 0x62, 0x72,
  0x65, 0x76, 0x69, 0x61, 0x74, 0x65, 0x64, 0x68, 0x69, 0x67, 0x68, 0x65, 0x72,
  0x20, 0x74, 0x68, 0x61, 0x6e, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75, 0x61, 0x6c,
  0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x73,
  0x75, 0x70, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x63, 0x6c, 0x61,
  0x69, 0x6d, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x74, 0x74, 0x72, 0x69,
  0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69,
  0x7a, 0x65, 0x3a, 0x31, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20,
  0x6f, 0x66, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69, 0x63, 0x61, 0x6c, 0x20,
  0x68, 0x69, 0x73, 0x20, 0x62, 0x72, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x61, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x61, 0x6e, 0x6e, 0x69,
  0x76, 0x65, 0x72, 0x73, 0x61, 0x72, 0x79, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x20, 0x75, 0x6c, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x6c, 0x79,
  0x20, 0x69, 0x6e, 0x6e, 0x6f, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x69,
  0x74, 0x20, 0x69, 0x73, 0x20, 0x73, 0x74, 0x69, 0x6c, 0x6c, 0x63, 0x61, 0x6e,
  0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x62, 0x65, 0x64, 0x65, 0x66, 0x69, 0x6e,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x6f, 0x47, 0x4d, 0x54, 0x53, 0x74,
  0x72, 0x69, 0x6e, 0x67, 0x41, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20,
  0x6f, 0x66, 0x69, 0x6d, 0x67, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x45, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x2c, 0x77, 0x61,
  0x73, 0x20, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x6f, 0x63, 0x63, 0x75,
  0x72, 0x72, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x6e, 0x65, 0x69, 0x67, 0x68, 0x62,
  0x6f, 0x72, 0x69, 0x6e, 0x67, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75,
  0x69, 0x73, 0x68, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x68, 0x65, 0x20, 0x77, 0x61,
  0x73, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x69, 0x6e, 0x67, 0x74,
  0x65, 0x72, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x61, 0x6c, 0x4d, 0x61, 0x6e,
  0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x72, 0x67, 0x75, 0x65,
  0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x6e, 0x20, 0x41, 0x6d, 0x65, 0x72,
  0x69, 0x63, 0x61, 0x6e, 0x63, 0x6f, 0x6e, 0x71, 0x75, 0x65, 0x73, 0x74, 0x20,
  0x6f, 0x66, 0x77, 0x69, 0x64, 0x65, 0x73, 0x70, 0x72, 0x65, 0x61, 0x64, 0x20,
  0x77, 0x65, 0x72, 0x65, 0x20, 0x6b, 0x69, 0x6c, 0x6c, 0x65, 0x64, 0x73, 0x63,
  0x72, 0x65, 0x65, 0x6e, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x49, 0x6e, 0x20, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x61,
  0x6e, 0x74, 0x73, 0x61, 0x72, 0x65, 0x20, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x65,
  0x64, 0x6c, 0x65, 0x67, 0x69, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65, 0x67,
  0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x62, 0x61,
  0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x6d, 0x6f, 0x73, 0x74, 0x20,
  0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x79, 0x65, 0x61, 0x72, 0x73, 0x20, 0x61,
  0x66, 0x74, 0x65, 0x72, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73, 0x20,
  0x6e, 0x6f, 0x74, 0x68, 0x65, 0x20, 0x68, 0x69, 0x67, 0x68, 0x65, 0x73, 0x74,
  0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x20, 0x74, 0x68,
  0x65, 0x79, 0x20, 0x64, 0x6f, 0x20, 0x6e, 0x6f, 0x74, 0x61, 0x72, 0x67, 0x75,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x68, 0x6f, 0x77, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x70, 0x72, 0x65, 0x64, 0x6f, 0x6d, 0x69, 0x6e,
  0x61, 0x6e, 0x74, 0x74, 0x68, 0x65, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61,
  0x6c, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x63,
  0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x69, 0x6e, 0x67, 0x73, 0x68, 0x6f,
  0x72, 0x74, 0x2d, 0x6c, 0x69, 0x76, 0x65, 0x64, 0x3c, 0x2f, 0x73, 0x70, 0x61,
  0x6e, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x76, 0x65, 0x72, 0x79, 0x20, 0x6c, 0x69, 0x74, 0x74,
  0x6c, 0x65, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x68, 0x61, 0x64, 0x20, 0x61, 0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x69, 0x6e,
  0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x64, 0x63, 0x6f, 0x6d, 0x6d,
  0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x65, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65,
  0x6e, 0x74, 0x2c, 0x3c, 0x2f, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x22,
  0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x33, 0x49, 0x6e, 0x64,
  0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x70, 0x6f, 0x70, 0x75, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x2d, 0x73,
  0x63, 0x61, 0x6c, 0x65, 0x2e, 0x20, 0x41, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67,
  0x68, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65,
  0x64, 0x65, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x6f,
  0x73, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x73, 0x74, 0x61, 0x72,
  0x74, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x74, 0x77, 0x6f, 0x20, 0x6f, 0x72,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x73, 0x73, 0x75, 0x62, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x61, 0x74,
  0x65, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x68,
  0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x61, 0x6e, 0x64, 0x3c, 0x2f, 0x6f,
  0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x0d, 0x0a, 0x43, 0x6f, 0x6e, 0x74, 0x69,
  0x6e, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x65, 0x6c, 0x69, 0x6d, 0x69, 0x6e, 0x61,
  0x74, 0x69, 0x6e, 0x67, 0x77, 0x69, 0x6c, 0x6c, 0x20, 0x6e, 0x6f, 0x74, 0x20,
  0x62, 0x65, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x65, 0x20, 0x6f, 0x66,
  0x69, 0x6e, 0x20, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x73, 0x69,
  0x74, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x6e, 0x73, 0x75,
  0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x74, 0x6f, 0x20, 0x63, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x20, 0x61, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x73, 0x73, 0x69,
  0x70, 0x70, 0x69, 0x70, 0x6f, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c,
  0x79, 0x6f, 0x75, 0x74, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x62,
  0x65, 0x74, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x77, 0x68, 0x61,
  0x74, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x77, 0x73, 0x69, 0x74, 0x75, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x3d, 0x22, 0x54, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x54, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x68,
  0x65, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6f, 0x66, 0x61, 0x74, 0x6d, 0x6f,
  0x73, 0x70, 0x68, 0x65, 0x72, 0x69, 0x63, 0x69, 0x64, 0x65, 0x6f, 0x6c, 0x6f,
  0x67, 0x69, 0x63, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x69,
  0x73, 0x65, 0x73, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6e,
  0x67, 0x65, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x6d, 0x6e, 0x61, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x70, 0x6c, 0x75,
  0x67, 0x69, 0x6e, 0x73, 0x70, 0x61, 0x67, 0x65, 0x2f, 0x69, 0x6e, 0x64, 0x65,
  0x78, 0x2e, 0x70, 0x68, 0x70, 0x3f, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x65,
  0x64, 0x20, 0x69, 0x6e, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d,
  0x65, 0x64, 0x48, 0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f,
  0x77, 0x61, 0x73, 0x20, 0x61, 0x6c, 0x72, 0x65, 0x61, 0x64, 0x79, 0x73, 0x74,
  0x61, 0x74, 0x69, 0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x20, 0x66,
  0x61, 0x76, 0x6f, 0x72, 0x20, 0x6f, 0x66, 0x4d, 0x69, 0x6e, 0x69, 0x73, 0x74,
  0x72, 0x79, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x20, 0x6f, 0x66, 0x66, 0x6f, 0x72, 0x6d, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x69, 0x73, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x3c,
  0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x54, 0x68, 0x69,
  0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72,
  0x69, 0x7a, 0x65, 0x64, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x20,
  0x69, 0x6e, 0x61, 0x72, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x61, 0x6e, 0x64, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x6d, 0x61,
  0x64, 0x65, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x65, 0x6d,
  0x73, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x79,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x50, 0x61, 0x6c, 0x65, 0x73, 0x74, 0x69, 0x6e,
  0x69, 0x61, 0x6e, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x20, 0x61, 0x66, 0x74, 0x65,
  0x72, 0x69, 0x74, 0x20, 0x68, 0x61, 0x64, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x6d,
  0x6f, 0x73, 0x74, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x74, 0x6f, 0x20,
  0x72, 0x65, 0x66, 0x65, 0x72, 0x20, 0x74, 0x6f, 0x62, 0x75, 0x74, 0x20, 0x74,
  0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x63, 0x75,
  0x74, 0x69, 0x76, 0x65, 0x74, 0x65, 0x6d, 0x70, 0x6f, 0x72, 0x61, 0x72, 0x69,
  0x6c, 0x79, 0x49, 0x6e, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x2c,
  0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x61,
  0x6b, 0x65, 0x73, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x73, 0x75, 0x62, 0x64,
  0x69, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x69, 0x74,
  0x6f, 0x72, 0x69, 0x61, 0x6c, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x70, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x65, 0x6e, 0x74, 0x6c,
  0x79, 0x77, 0x61, 0x73, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x6c, 0x79, 0x6f,
  0x75, 0x74, 0x62, 0x72, 0x65, 0x61, 0x6b, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x73, 0x74, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x69, 0x6e, 0x67, 0x20, 0x61, 0x20, 0x78, 0x6d, 0x6c, 0x6e, 0x73, 0x3a,
  0x6f, 0x67, 0x3d, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74,
  0x43, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x6d, 0x61,
  0x79, 0x20, 0x62, 0x65, 0x20, 0x75, 0x73, 0x65, 0x64, 0x6d, 0x61, 0x6e, 0x75,
  0x66, 0x61, 0x63, 0x74, 0x75, 0x72, 0x65, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
  0x62, 0x65, 0x69, 0x6e, 0x67, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x66, 0x69, 0x78,
  0x22, 0x3e, 0x0a, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x66, 0x77, 0x61, 0x73, 0x20, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x74,
  0x6f, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6d, 0x65, 0x20, 0x61, 0x62, 0x65, 0x63,
  0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20,
  0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x69, 0x6e, 0x73, 0x70, 0x69, 0x72, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75,
  0x6c, 0x20, 0x61, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x77, 0x68, 0x65, 0x6e,
  0x6d, 0x6f, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x61, 0x6d,
  0x6f, 0x6e, 0x67, 0x73, 0x74, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20, 0x6f,
  0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a,
  0x31, 0x30, 0x30, 0x25, 0x3b, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f,
  0x67, 0x79, 0x2c, 0x77, 0x61, 0x73, 0x20, 0x61, 0x64, 0x6f, 0x70, 0x74, 0x65,
  0x64, 0x74, 0x6f, 0x20, 0x6b, 0x65, 0x65, 0x70, 0x20, 0x74, 0x68, 0x65, 0x73,
  0x65, 0x74, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x6c, 0x69, 0x76,
  0x65, 0x20, 0x62, 0x69, 0x72, 0x74, 0x68, 0x73, 0x69, 0x6e, 0x64, 0x65, 0x78,
  0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x43, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74,
  0x69, 0x63, 0x75, 0x74, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x3b,
  0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x20, 0x66, 0x6f, 0x72, 0x61, 0x6c,
  0x69, 0x67, 0x6e, 0x3d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x74, 0x68, 0x65, 0x20,
  0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x79, 0x61, 0x6c, 0x77, 0x61, 0x79, 0x73,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64,
  0x20, 0x74, 0x6f, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x42, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x74,
  0x68, 0x69, 0x73, 0x20, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x22, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x71, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x66, 0x69,
  0x6e, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x61, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c,
  0x74, 0x20, 0x6f, 0x66, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x22, 0x20,
  0x2f, 0x3e, 0x69, 0x73, 0x20, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79,
  0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x0d, 0x0a,
  0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0d, 0x0a, 0x43, 0x6f, 0x6e, 0x76,
  0x65, 0x72, 0x73, 0x65, 0x6c, 0x79, 0x2c, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76,
  0x20, 0x69, 0x64, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68,
  0x3d, 0x22, 0x31, 0x69, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x6c,
  0x79, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6d, 0x65, 0x63,
  0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x74, 0x68, 0x65,
  0x20, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x63, 0x69, 0x74, 0x69, 0x7a,
  0x65, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63,
  0x69, 0x61, 0x6e, 0x73, 0x72, 0x65, 0x61, 0x63, 0x68, 0x65, 0x64, 0x20, 0x74,
  0x68, 0x65, 0x61, 0x73, 0x20, 0x65, 0x61, 0x72, 0x6c, 0x79, 0x20, 0x61, 0x73,
  0x3a, 0x6e, 0x6f, 0x6e, 0x65, 0x3b, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x3c, 0x74,
  0x61, 0x62, 0x6c, 0x65, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x76, 0x61, 0x6c, 0x69,
  0x64, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74,
  0x6c, 0x79, 0x20, 0x74, 0x6f, 0x6f, 0x6e, 0x6d, 0x6f, 0x75, 0x73, 0x65, 0x64,
  0x6f, 0x77, 0x6e, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x74, 0x20, 0x69,
  0x73, 0x77, 0x68, 0x65, 0x6e, 0x20, 0x69, 0x74, 0x20, 0x77, 0x61, 0x73, 0x6d,
  0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x72, 0x65, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x61, 0x63, 0x63, 0x6f, 0x6d,
  0x6d, 0x6f, 0x64, 0x61, 0x74, 0x65, 0x61, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x77,
  0x69, 0x74, 0x68, 0x20, 0x49, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6c, 0x61,
  0x74, 0x65, 0x74, 0x68, 0x65, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68,
  0x64, 0x65, 0x6c, 0x69, 0x63, 0x69, 0x6f, 0x75, 0x73, 0x22, 0x3e, 0x74, 0x68,
  0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x74, 0x68, 0x65, 0x20,
  0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x79, 0x20, 0x61, 0x72, 0x65, 0x61, 0x6e, 0x64, 0x20, 0x66, 0x69, 0x6e, 0x61,
  0x6c, 0x6c, 0x79, 0x61, 0x20, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x0d, 0x0a, 0x09, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x0d,
  0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x66, 0x61, 0x73,
  0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x6d, 0x61, 0x6a, 0x6f, 0x72,
  0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x77,
  0x68, 0x69, 0x63, 0x68, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x74, 0x6f, 0x20, 0x6d, 0x61, 0x69, 0x6e, 0x74, 0x61, 0x69, 0x6e,
  0x69, 0x6d, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x61, 0x77,
  0x61, 0x72, 0x64, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x65, 0x72, 0x22, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x62,
  0x6f, 0x72, 0x64, 0x65, 0x72, 0x72, 0x65, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d,
  0x65, 0x61, 0x6e, 0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x20, 0x6f, 0x66, 0x74,
  0x68, 0x65, 0x69, 0x72, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x44, 0x75, 0x72,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x69,
  0x6e, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63,
  0x65, 0x20, 0x6f, 0x66, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28,
  0x29, 0x7b, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x20,
  0x77, 0x6f, 0x72, 0x6b, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x62, 0x65, 0x67, 0x69,
  0x6e, 0x73, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75,
  0x65, 0x6e, 0x74, 0x77, 0x61, 0x73, 0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x65,
  0x64, 0x65, 0x71, 0x75, 0x69, 0x6c, 0x69, 0x62, 0x72, 0x69, 0x75, 0x6d, 0x61,
  0x73, 0x73, 0x75, 0x6d, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x73, 0x20,
  0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x62, 0x79, 0x6e, 0x65, 0x65, 0x64, 0x73,
  0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x63, 0x6f, 0x6f, 0x72, 0x64, 0x69, 0x6e,
  0x61, 0x74, 0x65, 0x73, 0x74, 0x68, 0x65, 0x20, 0x76, 0x61, 0x72, 0x69, 0x6f,
  0x75, 0x73, 0x61, 0x72, 0x65, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66,
  0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x61,
  0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x69,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
  0x69, 0x65, 0x73, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x65, 0x64, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73,
  0x74, 0x72, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6f, 0x66, 0x70, 0x6f, 0x73,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x69, 0x6e, 0x70, 0x72, 0x65, 0x73, 0x65,
  0x6e, 0x74, 0x2d, 0x64, 0x61, 0x79, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73,
  0x61, 0x6c, 0x6c, 0x79, 0x74, 0x6f, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x74,
  0x68, 0x65, 0x62, 0x75, 0x74, 0x20, 0x69, 0x6e, 0x73, 0x74, 0x65, 0x61, 0x64,
  0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x74,
  0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x69, 0x73, 0x20, 0x63,
  0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x6c, 0x79, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
  0x73, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x74,
  0x68, 0x65, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x6d, 0x61, 0x64,
  0x65, 0x77, 0x61, 0x73, 0x20, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x77,
  0x68, 0x69, 0x63, 0x68, 0x20, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x62, 0x75, 0x74,
  0x20, 0x64, 0x69, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x6f, 0x6e, 0x4d, 0x6f, 0x75,
  0x73, 0x65, 0x4f, 0x76, 0x65, 0x72, 0x61, 0x73, 0x20, 0x70, 0x6f, 0x73, 0x73,
  0x69, 0x62, 0x6c, 0x65, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x63, 0x6f, 0x6d, 0x69, 0x6e, 0x67, 0x20, 0x66, 0x72, 0x6f, 0x6d,
  0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x79, 0x61, 0x64,
  0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x66, 0x6f, 0x72, 0x20,
  0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66,
  0x65, 0x72, 0x72, 0x65, 0x64, 0x61, 0x20, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64,
  0x20, 0x6f, 0x66, 0x61, 0x72, 0x65, 0x20, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x74,
  0x6f, 0x68, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x69, 0x74, 0x73,
  0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x68, 0x61, 0x76, 0x65, 0x6d, 0x75, 0x63,
  0x68, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x72, 0x0a, 0x09, 0x3c, 0x2f, 0x73,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x61, 0x64, 0x6f, 0x70, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x65, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x20,
  0x6f, 0x66, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x77, 0x61,
  0x73, 0x20, 0x62, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x63, 0x68, 0x69, 0x6c,
  0x64, 0x72, 0x65, 0x6e, 0x20, 0x6f, 0x66, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x61,
  0x6d, 0x6d, 0x69, 0x6e, 0x67, 0x6c, 0x6f, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x61, 0x6e, 0x6d, 0x61, 0x6e, 0x75, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x73, 0x77, 0x61, 0x72, 0x20, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x73, 0x74, 0x62,
  0x79, 0x20, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x61, 0x6e, 0x64,
  0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x73, 0x69, 0x6d, 0x69, 0x6c,
  0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x6f, 0x70, 0x72, 0x69, 0x65,
  0x74, 0x61, 0x72, 0x79, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x74, 0x69,
  0x6e, 0x67, 0x70, 0x72, 0x65, 0x73, 0x74, 0x69, 0x67, 0x69, 0x6f, 0x75, 0x73,
  0x67, 0x72, 0x61, 0x6d, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x65, 0x78,
  0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2e, 0x74, 0x6f, 0x20, 0x6d,
  0x61, 0x6b, 0x65, 0x20, 0x74, 0x68, 0x65, 0x49, 0x74, 0x20, 0x77, 0x61, 0x73,
  0x20, 0x61, 0x6c, 0x73, 0x6f, 0x69, 0x73, 0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64,
  0x20, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x69, 0x74, 0x6f, 0x72,
  0x73, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x55, 0x2e, 0x53, 0x2e, 0x72,
  0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x74, 0x68, 0x65, 0x62, 0x72, 0x6f,
  0x75, 0x67, 0x68, 0x74, 0x20, 0x74, 0x68, 0x65, 0x63, 0x61, 0x6c, 0x63, 0x75,
  0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x61, 0x6c, 0x6c, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72,
  0x61, 0x6c, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79,
  0x69, 0x6e, 0x20, 0x68, 0x6f, 0x6e, 0x6f, 0x72, 0x20, 0x6f, 0x66, 0x72, 0x65,
  0x6c, 0x65, 0x61, 0x73, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x72, 0x65, 0x73, 0x69,
  0x64, 0x65, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x6f,
  0x6d, 0x65, 0x20, 0x6f, 0x66, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74,
  0x6f, 0x31, 0x73, 0x74, 0x20, 0x45, 0x61, 0x72, 0x6c, 0x20, 0x6f, 0x66, 0x63,
  0x75, 0x6c, 0x74, 0x75, 0x72, 0x65, 0x20, 0x61, 0x6e, 0x64, 0x70, 0x72, 0x69,
  0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x6c, 0x79, 0x3c, 0x2f, 0x74, 0x69, 0x74,
  0x6c, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x74, 0x68, 0x65, 0x79, 0x20, 0x63, 0x61,
  0x6e, 0x20, 0x62, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x20, 0x74, 0x6f, 0x20, 0x74,
  0x68, 0x65, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x68, 0x69, 0x73,
  0x65, 0x78, 0x70, 0x6f, 0x73, 0x75, 0x72, 0x65, 0x20, 0x74, 0x6f, 0x61, 0x72,
  0x65, 0x20, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x66, 0x6f, 0x72, 0x6d,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x64, 0x64, 0x46, 0x61, 0x76,
  0x6f, 0x72, 0x69, 0x74, 0x65, 0x63, 0x69, 0x74, 0x69, 0x7a, 0x65, 0x6e, 0x73,
  0x68, 0x69, 0x70, 0x70, 0x61, 0x72, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
  0x65, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x69,
  0x6e, 0x20, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x65, 0x74, 0x6f, 0x20,
  0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65, 0x26, 0x61, 0x6d, 0x70, 0x3b,
  0x6d, 0x69, 0x6e, 0x75, 0x73, 0x3b, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73,
  0x74, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65,
  0x61, 0x6e, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x66, 0x75,
  0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x67, 0x70, 0x6c, 0x61, 0x79,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22,
  0x30, 0x22, 0x20, 0x69, 0x6e, 0x20, 0x68, 0x69, 0x73, 0x20, 0x62, 0x6f, 0x6f,
  0x6b, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x61, 0x66,
  0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x20, 0x74, 0x68, 0x65, 0x63, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65,
  0x6e, 0x63, 0x65, 0x20, 0x69, 0x6e, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c,
  0x2f, 0x74, 0x64, 0x3e, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69,
  0x73, 0x74, 0x74, 0x68, 0x65, 0x20, 0x69, 0x64, 0x65, 0x61, 0x20, 0x6f, 0x66,
  0x61, 0x20, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x77, 0x65,
  0x72, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x64, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x62, 0x74, 0x6e, 0x64, 0x61, 0x79, 0x73, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x66, 0x65, 0x61, 0x74, 0x75, 0x72, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x73, 0x68, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x20, 0x69, 0x6e, 0x69,
  0x6e, 0x20, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x75, 0x72,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x68,
  0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x4c, 0x6f, 0x72, 0x64, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c,
  0x6c, 0x79, 0x68, 0x61, 0x73, 0x20, 0x69, 0x74, 0x73, 0x20, 0x6f, 0x77, 0x6e,
  0x45, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x70,
  0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x73, 0x6f, 0x6d, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x61, 0x63, 0x68, 0x20, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x2c, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
  0x20, 0x6f, 0x66, 0x61, 0x6e, 0x64, 0x20, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73,
  0x65, 0x61, 0x6e, 0x64, 0x20, 0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x61,
  0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x72, 0x65, 0x63,
  0x6f, 0x72, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x62, 0x6c, 0x61, 0x63, 0x6b,
  0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x6d, 0x61, 0x79, 0x20, 0x69, 0x6e, 0x63,
  0x6c, 0x75, 0x64, 0x65, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64,
  0x27, 0x73, 0x63, 0x61, 0x6e, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x74, 0x6f,
  0x72, 0x65, 0x66, 0x65, 0x72, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x67, 0x6f, 0x76, 0x65,
  0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x77, 0x69, 0x6e, 0x6e, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x6c, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x57, 0x61, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x74, 0x6f, 0x6e, 0x2c, 0x74,
  0x68, 0x65, 0x20, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x63, 0x69, 0x74,
  0x79, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x3e, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0d, 0x0a, 0x09, 0x09, 0x72, 0x65, 0x66, 0x6c, 0x65, 0x63, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x6f, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
  0x74, 0x65, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x6d, 0x6f, 0x72, 0x65,
  0x72, 0x61, 0x64, 0x69, 0x6f, 0x61, 0x63, 0x74, 0x69, 0x76, 0x65, 0x72, 0x65,
  0x6a, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x77, 0x69, 0x74, 0x68,
  0x6f, 0x75, 0x74, 0x20, 0x61, 0x6e, 0x79, 0x68, 0x69, 0x73, 0x20, 0x66, 0x61,
  0x74, 0x68, 0x65, 0x72, 0x2c, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x63, 0x6f,
  0x75, 0x6c, 0x64, 0x63, 0x6f, 0x70, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x74, 0x6f, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x61,
  0x20, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x61, 0x63, 0x63,
  0x6f, 0x75, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x73, 0x74,
  0x69, 0x74, 0x75, 0x74, 0x65, 0x73, 0x77, 0x6f, 0x72, 0x6b, 0x65, 0x64, 0x20,
  0x77, 0x69, 0x74, 0x68, 0x65, 0x72, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c,
  0x69, 0x3e, 0x6f, 0x66, 0x20, 0x68, 0x69, 0x73, 0x20, 0x6c, 0x69, 0x66, 0x65,
  0x61, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69, 0x65, 0x64, 0x63, 0x6c,
  0x69, 0x65, 0x6e, 0x74, 0x57, 0x69, 0x64, 0x74, 0x68, 0x70, 0x72, 0x65, 0x76,
  0x65, 0x6e, 0x74, 0x20, 0x74, 0x68, 0x65, 0x4c, 0x65, 0x67, 0x69, 0x73, 0x6c,
  0x61, 0x74, 0x69, 0x76, 0x65, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x74, 0x6c, 0x79, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x69,
  0x6e, 0x68, 0x61, 0x73, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x66,
  0x6f, 0x72, 0x20, 0x61, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x74, 0x65, 0x78,
  0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x66, 0x6f, 0x75, 0x6e, 0x64,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x69, 0x73, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x66,
  0x6f, 0x72, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65,
  0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x70, 0x6c,
  0x61, 0x63, 0x65, 0x20, 0x77, 0x68, 0x65, 0x72, 0x65, 0x77, 0x68, 0x65, 0x72,
  0x65, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x3e, 0x20, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x6d, 0x73, 0x65, 0x6c, 0x76, 0x65, 0x73,
  0x2c, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x68, 0x65, 0x74,
  0x68, 0x61, 0x74, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x74, 0x72, 0x61,
  0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x72, 0x6f, 0x6c, 0x65, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x20, 0x61, 0x20, 0x72, 0x65,
  0x73, 0x75, 0x6c, 0x74, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x68, 0x69,
  0x6c, 0x64, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x77, 0x65, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x53, 0x6f,
  0x6d, 0x65, 0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x70, 0x72, 0x6f, 0x64,
  0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x73, 0x69, 0x64, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x65, 0x77, 0x73, 0x6c, 0x65, 0x74, 0x74,
  0x65, 0x72, 0x73, 0x75, 0x73, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68,
  0x65, 0x64, 0x6f, 0x77, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x61,
  0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x6c, 0x69, 0x76,
  0x65, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x61, 0x74, 0x74, 0x65, 0x6d,
  0x70, 0x74, 0x73, 0x20, 0x74, 0x6f, 0x6f, 0x75, 0x74, 0x73, 0x69, 0x64, 0x65,
  0x20, 0x74, 0x68, 0x65, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x69,
  0x65, 0x73, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x69, 0x6e,
  0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x65, 0x72, 0x73, 0x61, 0x74,
  0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x69, 0x6e, 0x61, 0x70, 0x70, 0x72,
  0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75,
  0x67, 0x68, 0x20, 0x69, 0x74, 0x77, 0x61, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74,
  0x20, 0x6f, 0x66, 0x61, 0x6e, 0x64, 0x20, 0x76, 0x61, 0x72, 0x69, 0x6f, 0x75,
  0x73, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6f, 0x72, 0x20, 0x6f, 0x66, 0x74,
  0x68, 0x65, 0x20, 0x61, 0x72, 0x74, 0x69, 0x63, 0x6c, 0x65, 0x74, 0x75, 0x72,
  0x6e, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x3e, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x74, 0x68, 0x65, 0x20, 0x65, 0x63, 0x6f,
  0x6e, 0x6f, 0x6d, 0x79, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f,
  0x73, 0x74, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x77, 0x69, 0x64, 0x65, 0x6c, 0x79,
  0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x61, 0x6e,
  0x64, 0x20, 0x70, 0x65, 0x72, 0x68, 0x61, 0x70, 0x73, 0x72, 0x69, 0x73, 0x65,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x63, 0x63, 0x75, 0x72, 0x73,
  0x20, 0x77, 0x68, 0x65, 0x6e, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x77, 0x68,
  0x69, 0x63, 0x68, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x2e, 0x74, 0x68, 0x65, 0x20, 0x77, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x74,
  0x68, 0x65, 0x6f, 0x72, 0x79, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x73, 0x20,
  0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20, 0x63,
  0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x68, 0x65, 0x73, 0x65, 0x65, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x6c,
  0x62, 0x75, 0x69, 0x6c, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x6d, 0x61,
  0x6e, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x68, 0x69, 0x73, 0x61, 0x72, 0x65, 0x61,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x74, 0x68, 0x65, 0x20, 0x57, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x54,
  0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73, 0x20, 0x6e, 0x6f, 0x65, 0x78, 0x74,
  0x65, 0x6e, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x53, 0x74, 0x61, 0x74, 0x69,
  0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x63, 0x6f, 0x6c, 0x73, 0x70, 0x61, 0x6e,
  0x3d, 0x32, 0x20, 0x7c, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x20, 0x73, 0x74, 0x6f,
  0x72, 0x79, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f,
  0x74, 0x6f, 0x70, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x63, 0x72,
  0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x70, 0x6f,
  0x72, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x61, 0x20, 0x43, 0x68, 0x72, 0x69,
  0x73, 0x74, 0x69, 0x61, 0x6e, 0x64, 0x65, 0x63, 0x69, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x74, 0x6f, 0x69, 0x73, 0x20, 0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74,
  0x6f, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x54,
  0x68, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x6d, 0x65, 0x72,
  0x63, 0x68, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x65, 0x66, 0x6f, 0x72, 0x20, 0x6d,
  0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x6e, 0x6f, 0x20, 0x65, 0x76, 0x69, 0x64,
  0x65, 0x6e, 0x63, 0x65, 0x65, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20,
  0x6f, 0x66, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x69, 0x6e,
  0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x2e, 0x20, 0x54, 0x68, 0x65, 0x63, 0x6f,
  0x6d, 0x2f, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x6d, 0x61, 0x6b, 0x65, 0x73, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72,
  0x6f, 0x63, 0x65, 0x73, 0x73, 0x72, 0x65, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x20,
  0x74, 0x68, 0x65, 0x6c, 0x69, 0x74, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65,
  0x2c, 0x69, 0x73, 0x20, 0x61, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x74,
  0x68, 0x65, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x74, 0x68, 0x65,
  0x20, 0x61, 0x6e, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x70, 0x72, 0x6f, 0x62, 0x6c,
  0x65, 0x6d, 0x73, 0x20, 0x69, 0x6e, 0x74, 0x69, 0x6d, 0x65, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x64, 0x65, 0x66, 0x65, 0x61, 0x74, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x61, 0x20, 0x66, 0x65, 0x77, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x6d, 0x75,
  0x63, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20,
  0x77, 0x6f, 0x72, 0x6b, 0x20, 0x6f, 0x66, 0x43, 0x61, 0x6c, 0x69, 0x66, 0x6f,
  0x72, 0x6e, 0x69, 0x61, 0x2c, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x20, 0x61,
  0x73, 0x20, 0x61, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74,
  0x2e, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x6d,
  0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x69, 0x6e, 0x09, 0x09, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x69, 0x74, 0x22, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67,
  0x65, 0x20, 0x6f, 0x66, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x79, 0x20, 0x61,
  0x72, 0x65, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20, 0x69, 0x6e,
  0x69, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78,
  0x70, 0x6c, 0x61, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x64, 0x69, 0x76, 0x3e,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x6c, 0x65, 0x61, 0x64, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x09, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22,
  0x2f, 0x77, 0x61, 0x73, 0x20, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x64, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x68, 0x61, 0x76, 0x65, 0x63, 0x6f, 0x6e,
  0x74, 0x69, 0x6e, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x77, 0x61, 0x73, 0x20, 0x73,
  0x65, 0x65, 0x6e, 0x20, 0x61, 0x73, 0x61, 0x6e, 0x64, 0x20, 0x72, 0x65, 0x6c,
  0x61, 0x74, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20, 0x72, 0x6f, 0x6c, 0x65, 0x20,
  0x6f, 0x66, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x73, 0x74, 0x65, 0x61,
  0x63, 0x68, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6e, 0x73,
  0x74, 0x61, 0x6e, 0x74, 0x69, 0x6e, 0x65, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65,
  0x20, 0x66, 0x72, 0x6f, 0x6d, 0x64, 0x69, 0x61, 0x6c, 0x65, 0x63, 0x74, 0x73,
  0x20, 0x6f, 0x66, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f,
  0x6e, 0x77, 0x61, 0x73, 0x20, 0x72, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x61,
  0x20, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x61, 0x75, 0x6e, 0x63,
  0x68, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x65,
  0x73, 0x74, 0x77, 0x68, 0x65, 0x72, 0x65, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65,
  0x61, 0x6e, 0x64, 0x20, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x62, 0x65,
  0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x74, 0x77, 0x6f, 0x69, 0x73, 0x20, 0x61,
  0x6c, 0x73, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73,
  0x68, 0x20, 0x61, 0x6e, 0x64, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x2c, 0x74, 0x68, 0x61, 0x74, 0x20, 0x69, 0x74, 0x20, 0x77, 0x61,
  0x73, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x74,
  0x68, 0x65, 0x6d, 0x73, 0x65, 0x6c, 0x76, 0x65, 0x73, 0x2e, 0x71, 0x75, 0x61,
  0x6e, 0x74, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x72, 0x61, 0x6e, 0x73, 0x70,
  0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d,
  0x65, 0x20, 0x61, 0x73, 0x74, 0x6f, 0x20, 0x6a, 0x6f, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x79, 0x20, 0x61, 0x6e, 0x64,
  0x74, 0x68, 0x69, 0x73, 0x20, 0x69, 0x73, 0x20, 0x74, 0x68, 0x65, 0x54, 0x68,
  0x69, 0x73, 0x20, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x61, 0x20, 0x73, 0x74,
  0x61, 0x74, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61,
  0x73, 0x74, 0x20, 0x74, 0x6f, 0x6c, 0x61, 0x73, 0x74, 0x49, 0x6e, 0x64, 0x65,
  0x78, 0x4f, 0x66, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x68, 0x69,
  0x73, 0x69, 0x73, 0x20, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x74,
  0x68, 0x65, 0x20, 0x74, 0x65, 0x72, 0x6d, 0x20, 0x69, 0x73, 0x69, 0x73, 0x20,
  0x70, 0x72, 0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x70, 0x72, 0x6f, 0x74, 0x65,
  0x63, 0x74, 0x20, 0x74, 0x68, 0x65, 0x6e, 0x67, 0x3c, 0x2f, 0x61, 0x3e, 0x3c,
  0x2f, 0x6c, 0x69, 0x3e, 0x54, 0x68, 0x65, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65,
  0x6e, 0x74, 0x74, 0x68, 0x65, 0x20, 0x73, 0x69, 0x74, 0x65, 0x20, 0x6f, 0x66,
  0x73, 0x75, 0x62, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x65, 0x78,
  0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x2c, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x57, 0x65, 0x73, 0x74, 0x74, 0x68, 0x65, 0x79, 0x20, 0x73,
  0x68, 0x6f, 0x75, 0x6c, 0x64, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0xc4, 0x8d,
  0x69, 0x6e, 0x61, 0x63, 0x6f, 0x6d, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x69, 0x6f,
  0x73, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x64, 0x61, 0x64, 0x63,
  0x6f, 0x6e, 0x64, 0x69, 0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x61, 0x63, 0x74,
  0x69, 0x76, 0x69, 0x64, 0x61, 0x64, 0x65, 0x73, 0x65, 0x78, 0x70, 0x65, 0x72,
  0x69, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x74, 0x65, 0x63, 0x6e, 0x6f, 0x6c, 0x6f,
  0x67, 0xc3, 0xad, 0x61, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x63, 0x69, 0xc3,
  0xb3, 0x6e, 0x70, 0x75, 0x6e, 0x74, 0x75, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e,
  0x61, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f,
  0x6e, 0x74, 0x72, 0x61, 0x73, 0x65, 0xc3, 0xb1, 0x61, 0x63, 0x61, 0x74, 0x65,
  0x67, 0x6f, 0x72, 0xc3, 0xad, 0x61, 0x73, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74,
  0x72, 0x61, 0x72, 0x73, 0x65, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x74, 0x72, 0x61, 0x74, 0x61, 0x6d, 0x69, 0x65, 0x6e, 0x74,
  0x6f, 0x72, 0x65, 0x67, 0xc3, 0xad, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x73,
  0x65, 0x63, 0x72, 0x65, 0x74, 0x61, 0x72, 0xc3, 0xad, 0x61, 0x70, 0x72, 0x69,
  0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x65, 0x73, 0x70, 0x72, 0x6f, 0x74, 0x65,
  0x63, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61,
  0x6e, 0x74, 0x65, 0x73, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x63,
  0x69, 0x61, 0x70, 0x6f, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x64, 0x61, 0x64,
  0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x61, 0x6e, 0x74, 0x65, 0x63, 0x72,
  0x65, 0x63, 0x69, 0x6d, 0x69, 0x65, 0x6e, 0x74, 0x6f, 0x6e, 0x65, 0x63, 0x65,
  0x73, 0x69, 0x64, 0x61, 0x64, 0x65, 0x73, 0x73, 0x75, 0x73, 0x63, 0x72, 0x69,
  0x62, 0x69, 0x72, 0x73, 0x65, 0x61, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x63, 0x69,
  0xc3, 0xb3, 0x6e, 0x64, 0x69, 0x73, 0x70, 0x6f, 0x6e, 0x69, 0x62, 0x6c, 0x65,
  0x73, 0x65, 0x76, 0x61, 0x6c, 0x75, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x65,
  0x73, 0x74, 0x75, 0x64, 0x69, 0x61, 0x6e, 0x74, 0x65, 0x73, 0x72, 0x65, 0x73,
  0x70, 0x6f, 0x6e, 0x73, 0x61, 0x62, 0x6c, 0x65, 0x72, 0x65, 0x73, 0x6f, 0x6c,
  0x75, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x67, 0x75, 0x61, 0x64, 0x61, 0x6c, 0x61,
  0x6a, 0x61, 0x72, 0x61, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x64,
  0x6f, 0x73, 0x6f, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x6e, 0x69, 0x64, 0x61, 0x64,
  0x63, 0x6f, 0x6d, 0x65, 0x72, 0x63, 0x69, 0x61, 0x6c, 0x65, 0x73, 0x66, 0x6f,
  0x74, 0x6f, 0x67, 0x72, 0x61, 0x66, 0xc3, 0xad, 0x61, 0x61, 0x75, 0x74, 0x6f,
  0x72, 0x69, 0x64, 0x61, 0x64, 0x65, 0x73, 0x69, 0x6e, 0x67, 0x65, 0x6e, 0x69,
  0x65, 0x72, 0xc3, 0xad, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x76, 0x69, 0x73, 0x69,
  0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6d, 0x70, 0x65, 0x74, 0x65, 0x6e, 0x63, 0x69,
  0x61, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x65,
  0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x63, 0x69, 0x64, 0x6f, 0x73, 0x69, 0x6d,
  0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x61, 0x63, 0x74, 0x75, 0x61,
  0x6c, 0x6d, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x61, 0x76, 0x65, 0x67, 0x61, 0x63,
  0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x69, 0x64,
  0x61, 0x64, 0x6c, 0x69, 0x6e, 0x65, 0x2d, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x3a, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x3a,
  0x22, 0x20, 0x3a, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x61,
  0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6c, 0x69,
  0x6e, 0x6b, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x73, 0x70, 0x65,
  0x63, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x2f, 0x2f, 0x3c, 0x21,
  0x5b, 0x43, 0x44, 0x41, 0x54, 0x41, 0x5b, 0x0a, 0x4f, 0x72, 0x67, 0x61, 0x6e,
  0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69,
  0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x30, 0x70, 0x78, 0x3b, 0x20, 0x68, 0x65,
  0x69, 0x67, 0x68, 0x74, 0x3a, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x68, 0x69, 0x70, 0x64, 0x65, 0x76, 0x69, 0x63, 0x65, 0x2d, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x3c, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x20, 0x66, 0x6f, 0x72, 0x3d,
  0x22, 0x72, 0x65, 0x67, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x3c, 0x2f, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x2f,
  0x69, 0x6e, 0x64, 0x65, 0x78, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x77, 0x69,
  0x6e, 0x64, 0x6f, 0x77, 0x2e, 0x6f, 0x70, 0x65, 0x6e, 0x28, 0x20, 0x21, 0x69,
  0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x3b, 0x61, 0x70, 0x70, 0x6c,
  0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x69, 0x6e, 0x64, 0x65, 0x70,
  0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
  0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x73, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x3c, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x22, 0x69, 0x6e, 0x74, 0x65, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x75, 0x61, 0x6c,
  0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x6c, 0x65, 0x66, 0x74, 0x3a, 0x31,
  0x38, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x61, 0x6e,
  0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x6e, 0x73,
  0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x62, 0x62, 0x72,
  0x65, 0x76, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3c, 0x69, 0x6d, 0x67, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69,
  0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x7a,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x31, 0x39, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74,
  0x75, 0x72, 0x65, 0x69, 0x6e, 0x63, 0x6f, 0x72, 0x70, 0x6f, 0x72, 0x61, 0x74,
  0x65, 0x64, 0x32, 0x30, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72,
  0x79, 0x2d, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x22, 0x3e,
  0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x79, 0x2f,
  0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x6e, 0x6f,
  0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x27, 0x75, 0x6e,
  0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x27, 0x29, 0x46, 0x75, 0x72, 0x74,
  0x68, 0x65, 0x72, 0x6d, 0x6f, 0x72, 0x65, 0x2c, 0x62, 0x65, 0x6c, 0x69, 0x65,
  0x76, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x6e, 0x6e, 0x65, 0x72, 0x48,
  0x54, 0x4d, 0x4c, 0x20, 0x3d, 0x20, 0x70, 0x72, 0x69, 0x6f, 0x72, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x64, 0x72, 0x61, 0x6d, 0x61, 0x74, 0x69, 0x63,
  0x61, 0x6c, 0x6c, 0x79, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x6f, 0x6e, 0x65, 0x67, 0x6f, 0x74, 0x69, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x68, 0x65, 0x61, 0x64, 0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72,
  0x73, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66, 0x72, 0x69, 0x63, 0x61,
  0x75, 0x6e, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x50,
  0x65, 0x6e, 0x6e, 0x73, 0x79, 0x6c, 0x76, 0x61, 0x6e, 0x69, 0x61, 0x41, 0x73,
  0x20, 0x61, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x2c, 0x3c, 0x68, 0x74,
  0x6d, 0x6c, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22, 0x26, 0x6c, 0x74, 0x3b,
  0x2f, 0x73, 0x75, 0x70, 0x26, 0x67, 0x74, 0x3b, 0x64, 0x65, 0x61, 0x6c, 0x69,
  0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x70, 0x68, 0x69, 0x6c, 0x61, 0x64,
  0x65, 0x6c, 0x70, 0x68, 0x69, 0x61, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x29, 0x3b, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x0a, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2d, 0x74,
  0x6f, 0x70, 0x3a, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x6d, 0x65, 0x6e, 0x74,
  0x61, 0x6c, 0x67, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73,
  0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f, 0x67, 0x69, 0x65, 0x73, 0x70,
  0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3d, 0x66,
  0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x7b, 0x73, 0x75, 0x62,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x6c, 0x2e, 0x64, 0x74,
  0x64, 0x22, 0x3e, 0x0d, 0x0a, 0x3c, 0x68, 0x74, 0x67, 0x65, 0x6f, 0x67, 0x72,
  0x61, 0x70, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x69,
  0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x27, 0x2c, 0x20, 0x66, 0x75, 0x6e, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x28, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x61, 0x67, 0x72, 0x69, 0x63, 0x75, 0x6c, 0x74, 0x75,
  0x72, 0x61, 0x6c, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x20, 0x31,
  0x61, 0x20, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x45, 0x6e,
  0x63, 0x79, 0x63, 0x6c, 0x6f, 0x70, 0x65, 0x64, 0x69, 0x61, 0x69, 0x66, 0x72,
  0x61, 0x6d, 0x65, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x64, 0x65, 0x6d, 0x6f,
  0x6e, 0x73, 0x74, 0x72, 0x61, 0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x69, 0x74, 0x69, 0x65, 0x73, 0x44, 0x65, 0x6d, 0x6f, 0x67, 0x72, 0x61,
  0x70, 0x68, 0x69, 0x63, 0x73, 0x29, 0x3b, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x3c, 0x64, 0x65, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x6f, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67, 0x65, 0x20,
  0x6f, 0x66, 0x73, 0x61, 0x74, 0x69, 0x73, 0x66, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x6c, 0x79,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x45,
  0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x20, 0x28, 0x55, 0x53, 0x29, 0x61, 0x70,
  0x70, 0x65, 0x6e, 0x64, 0x43, 0x68, 0x69, 0x6c, 0x64, 0x28, 0x74, 0x72, 0x61,
  0x6e, 0x73, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x20, 0x48,
  0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x69, 0x6e, 0x74, 0x65, 0x6c,
  0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x22, 0x20, 0x74, 0x61, 0x62, 0x69,
  0x6e, 0x64, 0x65, 0x78, 0x3d, 0x22, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x3a, 0x72,
  0x69, 0x67, 0x68, 0x74, 0x3b, 0x43, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x77, 0x65,
  0x61, 0x6c, 0x74, 0x68, 0x72, 0x61, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x20, 0x66,
  0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x74,
  0x68, 0x65, 0x61, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x6f, 0x6e,
  0x65, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x65, 0x6e, 0x63, 0x79, 0x63, 0x6c, 0x6f, 0x70, 0x65, 0x64, 0x69, 0x61, 0x3b,
  0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x31, 0x6a, 0x75,
  0x72, 0x69, 0x73, 0x64, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x74, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x22, 0x3e, 0x3c, 0x61,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x49, 0x6e, 0x20, 0x61, 0x64,
  0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x69, 0x6f, 0x6e, 0x2b, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x73,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x63, 0x74, 0x20,
  0x77, 0x69, 0x74, 0x68, 0x69, 0x73, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61,
  0x6c, 0x6c, 0x79, 0x72, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
  0x3d, 0x22, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x69, 0x6e,
  0x67, 0x26, 0x6c, 0x74, 0x3b, 0x6d, 0x61, 0x74, 0x68, 0x26, 0x67, 0x74, 0x3b,
  0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f,
  0x63, 0x63, 0x61, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x3c, 0x69,
  0x6d, 0x67, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x6e, 0x61, 0x76,
  0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x63, 0x6f, 0x6d, 0x70,
  0x65, 0x6e, 0x73, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x68, 0x61, 0x6d, 0x70,
  0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x3d,
  0x22, 0x61, 0x6c, 0x6c, 0x22, 0x20, 0x76, 0x69, 0x6f, 0x6c, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
  0x65, 0x20, 0x74, 0x6f, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x74, 0x72,
  0x75, 0x65, 0x3b, 0x53, 0x74, 0x72, 0x69, 0x63, 0x74, 0x2f, 0x2f, 0x45, 0x4e,
  0x22, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x76, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e,
  0x76, 0x65, 0x72, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x64, 0x69,
  0x66, 0x66, 0x69, 0x63, 0x75, 0x6c, 0x74, 0x69, 0x65, 0x73, 0x43, 0x68, 0x61,
  0x6d, 0x70, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x63, 0x61, 0x70, 0x61,
  0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x3c, 0x21, 0x5b, 0x65, 0x6e,
  0x64, 0x69, 0x66, 0x5d, 0x2d, 0x2d, 0x3e, 0x7d, 0x0a, 0x3c, 0x2f, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x69,
  0x61, 0x6e, 0x69, 0x74, 0x79, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d,
  0x70, 0x6c, 0x65, 0x2c, 0x50, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x77, 0x61, 0x73, 0x20, 0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x64,
  0x28, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x28, 0x75, 0x6e,
  0x65, 0x6d, 0x70, 0x6c, 0x6f, 0x79, 0x6d, 0x65, 0x6e, 0x74, 0x74, 0x68, 0x65,
  0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x2f, 0x69, 0x6e, 0x64, 0x65,
  0x78, 0x2e, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x73,
  0x68, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x2f, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x6f, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73,
  0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x47,
  0x75, 0x69, 0x64, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x76,
  0x65, 0x72, 0x77, 0x68, 0x65, 0x6c, 0x6d, 0x69, 0x6e, 0x67, 0x61, 0x67, 0x61,
  0x69, 0x6e, 0x73, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x63,
  0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x65, 0x64, 0x2c, 0x0a, 0x2e, 0x6e, 0x6f,
  0x6e, 0x74, 0x6f, 0x75, 0x63, 0x68, 0x20, 0x6f, 0x62, 0x73, 0x65, 0x72, 0x76,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x2f, 0x61, 0x3e, 0x0a, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x66, 0x20, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x2e, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3a, 0x20, 0x31,
  0x70, 0x78, 0x20, 0x7b, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69, 0x7a, 0x65,
  0x3a, 0x31, 0x74, 0x72, 0x65, 0x61, 0x74, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f,
  0x66, 0x30, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x31,
  0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49,
  0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x64, 0x69,
  0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x67, 0x72, 0x65,
  0x61, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x61, 0x63, 0x68, 0x69,
  0x65, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x65, 0x73, 0x74, 0x61, 0x62,
  0x6c, 0x69, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x4a, 0x61, 0x76, 0x61, 0x53, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x6e, 0x65, 0x76, 0x65, 0x72, 0x74, 0x68,
  0x65, 0x6c, 0x65, 0x73, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x6e, 0x63, 0x65, 0x42, 0x72, 0x6f, 0x61, 0x64, 0x63, 0x61, 0x73, 0x74,
  0x69, 0x6e, 0x67, 0x3e, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x2f, 0x74,
  0x64, 0x3e, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65, 0x72, 0x22, 0x3e,
  0x0a, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x61,
  0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x73, 0x72,
  0x63, 0x3d, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x6e, 0x61, 0x76,
  0x69, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x20, 0x68, 0x61, 0x6c, 0x66,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x75, 0x62, 0x73, 0x74,
  0x61, 0x6e, 0x74, 0x69, 0x61, 0x6c, 0x20, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x74, 0x61,
  0x67, 0x65, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
  0x79, 0x20, 0x6f, 0x66, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x6d, 0x65, 0x6e, 0x74,
  0x61, 0x6c, 0x20, 0x6d, 0x65, 0x74, 0x72, 0x6f, 0x70, 0x6f, 0x6c, 0x69, 0x74,
  0x61, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x69, 0x74,
  0x65, 0x22, 0x20, 0x78, 0x6d, 0x6c, 0x3a, 0x6c, 0x61, 0x6e, 0x67, 0x3d, 0x22,
  0x64, 0x65, 0x6c, 0x69, 0x62, 0x65, 0x72, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x61,
  0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x76,
  0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x70, 0x72, 0x65,
  0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6d, 0x70, 0x72,
  0x6f, 0x76, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x62, 0x65, 0x67, 0x69, 0x6e,
  0x6e, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x4a, 0x65, 0x73, 0x75, 0x73, 0x20,
  0x43, 0x68, 0x72, 0x69, 0x73, 0x74, 0x50, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x64, 0x69, 0x73, 0x61, 0x67, 0x72, 0x65, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67,
  0x6e, 0x3a, 0x72, 0x2c, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x28, 0x29, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x69, 0x74, 0x69, 0x65,
  0x73, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e,
  0x69, 0x73, 0x20, 0x63, 0x75, 0x72, 0x72, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x61,
  0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x73,
  0x20, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x6d, 0x61, 0x6e, 0x79,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6c, 0x6f, 0x77, 0x3a,
  0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x3b, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x69, 0x6e, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63,
  0x65, 0x20, 0x6f, 0x66, 0x61, 0x6c, 0x6c, 0x20, 0x6f, 0x76, 0x65, 0x72, 0x20,
  0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e,
  0x65, 0x74, 0x09, 0x3c, 0x75, 0x6c, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x6e, 0x65, 0x69, 0x67, 0x68, 0x62, 0x6f, 0x72, 0x68, 0x6f, 0x6f, 0x64, 0x61,
  0x72, 0x6d, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x73, 0x72, 0x65,
  0x64, 0x75, 0x63, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e,
  0x74, 0x69, 0x6e, 0x75, 0x65, 0x73, 0x20, 0x74, 0x6f, 0x4e, 0x6f, 0x6e, 0x65,
  0x74, 0x68, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x2c, 0x74, 0x65, 0x6d, 0x70, 0x65,
  0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x73, 0x0a, 0x09, 0x09, 0x3c, 0x61, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73,
  0x20, 0x6f, 0x66, 0x20, 0x69, 0x73, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74, 0x20,
  0x74, 0x68, 0x65, 0x28, 0x73, 0x65, 0x65, 0x20, 0x62, 0x65, 0x6c, 0x6f, 0x77,
  0x29, 0x2e, 0x22, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x73, 0x65, 0x61, 0x72, 0x63,
  0x68, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
  0x69, 0x73, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x74,
  0x68, 0x65, 0x20, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x09, 0x09,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x0a, 0x09, 0x09,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x61, 0x63, 0x63, 0x65,
  0x6c, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x68, 0x72, 0x6f, 0x75,
  0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x48, 0x61, 0x6c, 0x6c, 0x20, 0x6f,
  0x66, 0x20, 0x46, 0x61, 0x6d, 0x65, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x73, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x65, 0x72, 0x65,
  0x6e, 0x63, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x74, 0x65, 0x78,
  0x74, 0x2f, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x79, 0x65, 0x61, 0x72,
  0x73, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64,
  0x76, 0x65, 0x72, 0x79, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x7b,
  0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x3a, 0x74, 0x72,
  0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x73, 0x6f, 0x6d,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x6e,
  0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x65, 0x78, 0x70, 0x6c, 0x6f,
  0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x6d, 0x65, 0x72, 0x67, 0x65,
  0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x69, 0x74,
  0x75, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x20, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x72,
  0x79, 0x20, 0x6f, 0x66, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x6e, 0x74, 0x20, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74, 0x75, 0x72,
  0x65, 0x64, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x3e, 0x3c, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c,
  0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x62,
  0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x68, 0x61,
  0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x6e, 0x65, 0x69,
  0x67, 0x68, 0x62, 0x6f, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x77, 0x69, 0x74, 0x68,
  0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x64, 0x64, 0x65, 0x64,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x09, 0x3c, 0x6c, 0x69, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x6c, 0x53, 0x6f, 0x76, 0x69, 0x65, 0x74, 0x20, 0x55,
  0x6e, 0x69, 0x6f, 0x6e, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64,
  0x67, 0x65, 0x64, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x63, 0x61, 0x6e, 0x20,
  0x62, 0x65, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68,
  0x65, 0x61, 0x74, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f,
  0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x64,
  0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x49, 0x6e,
  0x20, 0x66, 0x61, 0x63, 0x74, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x6c, 0x69,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x61, 0x69, 0x6d, 0x70, 0x6c,
  0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x75, 0x69, 0x74, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x6d, 0x75, 0x63, 0x68, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6c, 0x6f, 0x6e, 0x69, 0x7a,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e,
  0x74, 0x69, 0x61, 0x6c, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c, 0x42, 0x75, 0x62,
  0x62, 0x6c, 0x65, 0x20, 0x49, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x73, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64,
  0x72, 0x65, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d,
  0x6f, 0x72, 0x65, 0x20, 0x6f, 0x72, 0x20, 0x6c, 0x65, 0x73, 0x73, 0x69, 0x6e,
  0x20, 0x53, 0x65, 0x70, 0x74, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x49, 0x6e, 0x74,
  0x65, 0x6c, 0x6c, 0x69, 0x67, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x72, 0x63, 0x3d,
  0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x70, 0x78, 0x3b, 0x20, 0x68,
  0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63,
  0x74, 0x75, 0x72, 0x65, 0x72, 0x68, 0x75, 0x6d, 0x61, 0x6e, 0x20, 0x72, 0x69,
  0x67, 0x68, 0x74, 0x73, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x2f, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69,
  0x74, 0x79, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x61,
  0x6c, 0x6f, 0x75, 0x74, 0x73, 0x69, 0x64, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x61, 0x73, 0x74, 0x72, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x61, 0x6c, 0x68,
  0x75, 0x6d, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x69, 0x6e, 0x67, 0x73, 0x6e, 0x61,
  0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x72, 0x65,
  0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x69, 0x6e, 0x61, 0x72, 0x65, 0x20,
  0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x73, 0x6d, 0x61, 0x6c, 0x6c,
  0x65, 0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x61, 0x20, 0x70, 0x65, 0x72, 0x73,
  0x6f, 0x6e, 0x20, 0x77, 0x68, 0x6f, 0x65, 0x78, 0x70, 0x61, 0x6e, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x61, 0x72, 0x67, 0x75, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x6e, 0x6f, 0x77, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x20, 0x61, 0x73, 0x49, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x61, 0x72,
  0x6c, 0x79, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x74,
  0x65, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d,
  0x53, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x61, 0x76, 0x69, 0x61, 0x6e, 0x3c,
  0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x63, 0x6f,
  0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20,
  0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20,
  0x4e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x69, 0x64, 0x3d, 0x22, 0x70, 0x61, 0x67, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
  0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73,
  0x69, 0x6f, 0x6e, 0x65, 0x64, 0x61, 0x6e, 0x61, 0x6c, 0x6f, 0x67, 0x6f, 0x75,
  0x73, 0x20, 0x74, 0x6f, 0x61, 0x72, 0x65, 0x20, 0x72, 0x65, 0x71, 0x75, 0x69,
  0x72, 0x65, 0x64, 0x2f, 0x75, 0x6c, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76,
  0x3e, 0x0a, 0x77, 0x61, 0x73, 0x20, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f,
  0x6e, 0x61, 0x6e, 0x64, 0x20, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x61,
  0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x74,
  0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x22, 0x20, 0x77, 0x61,
  0x73, 0x20, 0x63, 0x61, 0x70, 0x74, 0x75, 0x72, 0x65, 0x64, 0x6e, 0x6f, 0x20,
  0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x72, 0x65, 0x73, 0x70,
  0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6c, 0x79, 0x63, 0x6f, 0x6e, 0x74, 0x69,
  0x6e, 0x75, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x3e, 0x0d, 0x0a, 0x3c, 0x68, 0x65,
  0x61, 0x64, 0x3e, 0x0d, 0x0a, 0x3c, 0x77, 0x65, 0x72, 0x65, 0x20, 0x63, 0x72,
  0x65, 0x61, 0x74, 0x65, 0x64, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x67, 0x65, 0x6e,
  0x65, 0x72, 0x61, 0x6c, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x69, 0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6d, 0x70, 0x65, 0x72, 0x69, 0x61, 0x6c,
  0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x69, 0x6e,
  0x63, 0x6c, 0x75, 0x64, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x43, 0x6f, 0x6e,
  0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64,
  0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x20, 0x69, 0x6e,
  0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x69, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x65, 0x78, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x76,
  0x65, 0x6c, 0x79, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64,
  0x3a, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a,
  0x20, 0x69, 0x74, 0x73, 0x20, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c,
  0x69, 0x6e, 0x74, 0x6f, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x74,
  0x68, 0x69, 0x73, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x61, 0x6e,
  0x20, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x68, 0x6f, 0x77,
  0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x79,
  0x20, 0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x74, 0x72, 0x65, 0x6a, 0x65, 0x63,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63,
  0x69, 0x73, 0x6d, 0x20, 0x6f, 0x66, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20,
  0x77, 0x68, 0x69, 0x63, 0x68, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x6c, 0x79,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x69, 0x73, 0x20, 0x61, 0x72, 0x74, 0x69,
  0x63, 0x6c, 0x65, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28,
  0x29, 0x7b, 0x49, 0x74, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62,
  0x65, 0x61, 0x6e, 0x20, 0x61, 0x67, 0x72, 0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x61, 0x63, 0x63, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x6c, 0x79, 0x64,
  0x69, 0x66, 0x66, 0x65, 0x72, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x41, 0x72,
  0x63, 0x68, 0x69, 0x74, 0x65, 0x63, 0x74, 0x75, 0x72, 0x65, 0x62, 0x65, 0x74,
  0x74, 0x65, 0x72, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x61, 0x72, 0x72, 0x61,
  0x6e, 0x67, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x69, 0x6e, 0x66, 0x6c, 0x75,
  0x65, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x6e, 0x61, 0x74, 0x74, 0x65, 0x6e, 0x64,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x63,
  0x61, 0x6c, 0x20, 0x74, 0x6f, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x73, 0x73, 0x20, 0x74, 0x68, 0x72, 0x6f,
  0x75, 0x67, 0x68, 0x78, 0x6d, 0x6c, 0x22, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65,
  0x3d, 0x22, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x62, 0x6f, 0x6c, 0x64,
  0x3b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
  0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x6e, 0x6f, 0x6e, 0x65, 0x72,
  0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x69,
  0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x2f, 0x69, 0x68, 0x74, 0x74,
  0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x57, 0x6f, 0x72, 0x6c,
  0x64, 0x20, 0x57, 0x61, 0x72, 0x20, 0x49, 0x49, 0x74, 0x65, 0x73, 0x74, 0x69,
  0x6d, 0x6f, 0x6e, 0x69, 0x61, 0x6c, 0x73, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e,
  0x65, 0x64, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x73, 0x20, 0x6f, 0x66,
  0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x61, 0x62, 0x6c, 0x79,
  0x70, 0x75, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x62, 0x79, 0x74,
  0x68, 0x65, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x43, 0x6f,
  0x6e, 0x73, 0x65, 0x72, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e,
  0x73, 0x69, 0x73, 0x74, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x66, 0x65,
  0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x62, 0x61, 0x63, 0x6b, 0x20,
  0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x73, 0x73, 0x22, 0x20, 0x6d,
  0x65, 0x64, 0x69, 0x61, 0x3d, 0x22, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
  0x65, 0x20, 0x6f, 0x6e, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x20, 0x62, 0x65, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x22, 0x77, 0x61, 0x73, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61,
  0x73, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x69, 0x65, 0x73, 0x20, 0x6f, 0x66,
  0x6c, 0x69, 0x6b, 0x65, 0x6c, 0x79, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x63,
  0x6f, 0x6d, 0x70, 0x72, 0x69, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x66, 0x73, 0x75,
  0x70, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x68, 0x61, 0x6e,
  0x64, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x75, 0x70,
  0x6c, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x63, 0x6f, 0x6e, 0x6e, 0x65,
  0x63, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x3a, 0x6e, 0x6f, 0x6e, 0x65, 0x3b, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d,
  0x61, 0x6e, 0x63, 0x65, 0x73, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x20, 0x62,
  0x65, 0x69, 0x6e, 0x67, 0x6c, 0x61, 0x74, 0x65, 0x72, 0x20, 0x62, 0x65, 0x63,
  0x61, 0x6d, 0x65, 0x63, 0x61, 0x6c, 0x63, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65,
  0x64, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x66,
  0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74, 0x3e,
  0x3c, 0x6c, 0x69, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x65, 0x76,
  0x69, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x65, 0x78, 0x70,
  0x6c, 0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x76, 0x69,
  0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x61,
  0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20,
  0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x73, 0x49, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x61, 0x20, 0x77, 0x69, 0x64, 0x65, 0x20, 0x72, 0x61,
  0x6e, 0x67, 0x65, 0x6f, 0x6e, 0x20, 0x62, 0x65, 0x68, 0x61, 0x6c, 0x66, 0x20,
  0x6f, 0x66, 0x76, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x74, 0x6f, 0x70,
  0x22, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x6c, 0x65, 0x20, 0x6f, 0x66,
  0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x2c, 0x3c,
  0x2f, 0x6e, 0x6f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x73, 0x61,
  0x69, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x68, 0x61, 0x76, 0x65, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x77, 0x68, 0x69, 0x6c,
  0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x73, 0x68, 0x79, 0x70, 0x6f, 0x74,
  0x68, 0x65, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73,
  0x6f, 0x70, 0x68, 0x65, 0x72, 0x73, 0x70, 0x6f, 0x77, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x65,
  0x64, 0x20, 0x69, 0x6e, 0x70, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x6d, 0x65, 0x64,
  0x20, 0x62, 0x79, 0x69, 0x6e, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20,
  0x74, 0x6f, 0x77, 0x65, 0x72, 0x65, 0x20, 0x77, 0x72, 0x69, 0x74, 0x74, 0x65,
  0x6e, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x74,
  0x68, 0x65, 0x20, 0x71, 0x75, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e,
  0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x72, 0x65, 0x6a,
  0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x6d, 0x70, 0x6c,
  0x69, 0x65, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x6e, 0x76, 0x65, 0x6e,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74,
  0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x77, 0x61, 0x73, 0x20, 0x70, 0x72, 0x6f,
  0x62, 0x61, 0x62, 0x6c, 0x79, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x62, 0x65, 0x74,
  0x77, 0x65, 0x65, 0x6e, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x6f, 0x72,
  0x20, 0x6f, 0x66, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x65, 0x49, 0x6e, 0x64, 0x69, 0x61, 0x6e, 0x20, 0x4f, 0x63, 0x65, 0x61, 0x6e,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6c, 0x61, 0x73, 0x74, 0x77,
  0x6f, 0x72, 0x6b, 0x69, 0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x27, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x79, 0x65, 0x61,
  0x72, 0x73, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x54, 0x68, 0x69, 0x73,
  0x20, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x63, 0x72, 0x65,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x65, 0x61, 0x73, 0x75, 0x72, 0x65,
  0x6d, 0x65, 0x6e, 0x74, 0x73, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x74, 0x72, 0x65,
  0x6d, 0x65, 0x6c, 0x79, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x73, 0x74, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a,
  0x0a, 0x61, 0x6e, 0x20, 0x65, 0x66, 0x66, 0x6f, 0x72, 0x74, 0x20, 0x74, 0x6f,
  0x69, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x65, 0x20, 0x74, 0x68, 0x65, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x6f, 0x75, 0x74, 0x68, 0x73, 0x70,
  0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x3e, 0x73, 0x75, 0x66,
  0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x74, 0x68, 0x65, 0x20,
  0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x61, 0x6e, 0x63, 0x6f, 0x6e, 0x76, 0x65,
  0x72, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x54,
  0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x64, 0x69, 0x64, 0x20, 0x6e, 0x6f, 0x74,
  0x20, 0x68, 0x61, 0x76, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x74, 0x6c, 0x79, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e,
  0x65, 0x78, 0x74, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x20, 0x61, 0x6e,
  0x64, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68, 0x65,
  0x61, 0x72, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x61,
  0x6e, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e,
  0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x67, 0x69, 0x76,
  0x65, 0x6e, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74, 0x61, 0x74,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74, 0x65, 0x78, 0x70, 0x65, 0x6e,
  0x64, 0x69, 0x74, 0x75, 0x72, 0x65, 0x73, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e,
  0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x0a, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62,
  0x61, 0x73, 0x69, 0x73, 0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69,
  0x6e, 0x67, 0x3d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74,
  0x6f, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c,
  0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x61,
  0x73, 0x73, 0x61, 0x73, 0x73, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x73, 0x22,
  0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x61, 0x75, 0x74,
  0x68, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x6e, 0x6f, 0x72, 0x74,
  0x68, 0x77, 0x65, 0x73, 0x74, 0x65, 0x72, 0x6e, 0x3c, 0x2f, 0x64, 0x69, 0x76,
  0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x22, 0x3e, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0d, 0x0a, 0x20, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x75, 0x6c, 0x74,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x74,
  0x79, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x69, 0x74, 0x20, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20,
  0x62, 0x65, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74,
  0x73, 0x20, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x6c, 0x65, 0x66, 0x74,
  0x74, 0x68, 0x65, 0x20, 0x67, 0x72, 0x65, 0x61, 0x74, 0x65, 0x73, 0x74, 0x73,
  0x65, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x73, 0x75,
  0x70, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x64, 0x65, 0x70,
  0x65, 0x6e, 0x64, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x6e, 0x69, 0x73, 0x20, 0x6d,
  0x65, 0x6e, 0x74, 0x69, 0x6f, 0x6e, 0x65, 0x64, 0x61, 0x6c, 0x6c, 0x6f, 0x77,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x77, 0x61, 0x73, 0x20, 0x69, 0x6e,
  0x76, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x61, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61,
  0x6e, 0x79, 0x69, 0x6e, 0x67, 0x68, 0x69, 0x73, 0x20, 0x70, 0x65, 0x72, 0x73,
  0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65,
  0x20, 0x61, 0x74, 0x73, 0x74, 0x75, 0x64, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x65, 0x78, 0x65, 0x63, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x48, 0x75, 0x6d, 0x61, 0x6e, 0x20, 0x52, 0x69, 0x67, 0x68, 0x74, 0x73, 0x74,
  0x65, 0x72, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73,
  0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x72, 0x65, 0x73,
  0x65, 0x61, 0x72, 0x63, 0x68, 0x20, 0x61, 0x6e, 0x64, 0x73, 0x75, 0x63, 0x63,
  0x65, 0x65, 0x64, 0x65, 0x64, 0x20, 0x62, 0x79, 0x64, 0x65, 0x66, 0x65, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x64, 0x20, 0x66, 0x72,
  0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x62, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65,
  0x79, 0x20, 0x61, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x65,
  0x72, 0x20, 0x6f, 0x66, 0x73, 0x74, 0x61, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x79, 0x65, 0x61, 0x72, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x61,
  0x67, 0x65, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x75, 0x64, 0x79, 0x20, 0x6f,
  0x66, 0x3c, 0x75, 0x6c, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73,
  0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x77,
  0x68, 0x65, 0x72, 0x65, 0x20, 0x68, 0x65, 0x20, 0x77, 0x61, 0x73, 0x3c, 0x6c,
  0x69, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x66, 0x74, 0x68, 0x65,
  0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x6e, 0x6f, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x68, 0x65, 0x20, 0x70, 0x75,
  0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73,
  0x73, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x65, 0x72, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x77, 0x65, 0x69, 0x67,
  0x68, 0x74, 0x3a, 0x74, 0x65, 0x72, 0x72, 0x69, 0x74, 0x6f, 0x72, 0x79, 0x20,
  0x6f, 0x66, 0x65, 0x78, 0x74, 0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x22,
  0x3e, 0x52, 0x6f, 0x6d, 0x61, 0x6e, 0x20, 0x45, 0x6d, 0x70, 0x69, 0x72, 0x65,
  0x65, 0x71, 0x75, 0x61, 0x6c, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x49,
  0x6e, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x61, 0x73, 0x74, 0x2c, 0x68, 0x6f,
  0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x61, 0x6e, 0x64, 0x69, 0x73, 0x20,
  0x74, 0x79, 0x70, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x61, 0x6e, 0x64, 0x20,
  0x68, 0x69, 0x73, 0x20, 0x77, 0x69, 0x66, 0x65, 0x28, 0x61, 0x6c, 0x73, 0x6f,
  0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x3e, 0x3c, 0x75, 0x6c, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69,
  0x76, 0x65, 0x6c, 0x79, 0x20, 0x65, 0x76, 0x6f, 0x6c, 0x76, 0x65, 0x64, 0x20,
  0x69, 0x6e, 0x74, 0x6f, 0x73, 0x65, 0x65, 0x6d, 0x20, 0x74, 0x6f, 0x20, 0x68,
  0x61, 0x76, 0x65, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x69, 0x73, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x77, 0x61, 0x73, 0x20, 0x6e,
  0x6f, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x63, 0x65, 0x6c, 0x6c, 0x65, 0x6e, 0x74,
  0x61, 0x6c, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x64,
  0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65, 0x64, 0x20, 0x62, 0x79, 0x49, 0x6e,
  0x20, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x63, 0x65, 0x2c, 0x62, 0x72, 0x6f,
  0x61, 0x64, 0x63, 0x61, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x63, 0x68, 0x61, 0x72,
  0x67, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x72, 0x65, 0x66, 0x6c, 0x65,
  0x63, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x6d, 0x69, 0x6c, 0x69, 0x74, 0x61, 0x72,
  0x79, 0x20, 0x61, 0x6e, 0x64, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70,
  0x6f, 0x69, 0x6e, 0x74, 0x65, 0x63, 0x6f, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x61,
  0x6c, 0x6c, 0x79, 0x73, 0x65, 0x74, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x69,
  0x6e, 0x67, 0x61, 0x72, 0x65, 0x20, 0x61, 0x63, 0x74, 0x75, 0x61, 0x6c, 0x6c,
  0x79, 0x76, 0x69, 0x63, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x76, 0x65, 0x72,
  0x28, 0x29, 0x3b, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x63,
  0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x6f, 0x75, 0x73, 0x6c, 0x79, 0x72, 0x65,
  0x71, 0x75, 0x69, 0x72, 0x65, 0x64, 0x20, 0x66, 0x6f, 0x72, 0x65, 0x76, 0x6f,
  0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x6e, 0x20, 0x65,
  0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6e, 0x6f, 0x72, 0x74, 0x68,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x2c, 0x20, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x77, 0x61, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6e, 0x74, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72,
  0x77, 0x69, 0x73, 0x65, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x6d,
  0x20, 0x6f, 0x66, 0x68, 0x61, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65,
  0x65, 0x6e, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
  0x70, 0x65, 0x72, 0x6d, 0x69, 0x74, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x69,
  0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x20, 0x74, 0x68, 0x65, 0x64, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74,
  0x65, 0x72, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x74, 0x68, 0x65, 0x20,
  0x70, 0x72, 0x65, 0x76, 0x69, 0x6f, 0x75, 0x73, 0x63, 0x6f, 0x6e, 0x73, 0x69,
  0x73, 0x74, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x61, 0x72, 0x65, 0x20, 0x6b, 0x6e,
  0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x65,
  0x6c, 0x64, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x69, 0x73, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x20, 0x6f, 0x66, 0x67, 0x69, 0x76, 0x65, 0x6e, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x20,
  0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x74, 0x61, 0x69, 0x6e, 0x73, 0x20, 0x74, 0x68,
  0x65, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x20, 0x6f, 0x66,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x6f, 0x72, 0x74, 0x68, 0x64,
  0x75, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x69, 0x72, 0x61, 0x72,
  0x65, 0x20, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x63, 0x6f, 0x72,
  0x70, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x77, 0x61, 0x73, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x6e, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x70,
  0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x73, 0x75, 0x63, 0x63, 0x65, 0x65, 0x64,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72,
  0x65, 0x6e, 0x74, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x64, 0x65, 0x73, 0x69, 0x67, 0x6e, 0x65, 0x64, 0x20, 0x66, 0x6f,
  0x72, 0x6f, 0x77, 0x6e, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x20, 0x6f, 0x66,
  0x61, 0x6e, 0x64, 0x20, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x6c, 0x79, 0x73,
  0x74, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x64, 0x69, 0x7a, 0x65, 0x64, 0x72, 0x65,
  0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x54, 0x65, 0x78, 0x74, 0x77, 0x61, 0x73,
  0x20, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x72, 0x65, 0x63, 0x65,
  0x69, 0x76, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x73, 0x75, 0x6d,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x72, 0x65, 0x61, 0x73, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x70, 0x72, 0x69, 0x6d, 0x61, 0x72, 0x69,
  0x6c, 0x79, 0x20, 0x69, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x73, 0x69,
  0x73, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x65,
  0x6e, 0x73, 0x65, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x20, 0x66,
  0x6f, 0x72, 0x64, 0x65, 0x73, 0x74, 0x72, 0x6f, 0x79, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x61, 0x74, 0x20, 0x6c, 0x65, 0x61, 0x73, 0x74, 0x20, 0x74, 0x77, 0x6f,
  0x77, 0x61, 0x73, 0x20, 0x64, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x65, 0x64, 0x63,
  0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x62, 0x65, 0x53, 0x65,
  0x63, 0x72, 0x65, 0x74, 0x61, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x61, 0x70, 0x70,
  0x65, 0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x6d, 0x61, 0x72, 0x67,
  0x69, 0x6e, 0x2d, 0x74, 0x6f, 0x70, 0x3a, 0x31, 0x2f, 0x5e, 0x5c, 0x73, 0x2b,
  0x7c, 0x5c, 0x73, 0x2b, 0x24, 0x2f, 0x67, 0x65, 0x29, 0x7b, 0x74, 0x68, 0x72,
  0x6f, 0x77, 0x20, 0x65, 0x7d, 0x3b, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x61,
  0x72, 0x74, 0x20, 0x6f, 0x66, 0x74, 0x77, 0x6f, 0x20, 0x73, 0x65, 0x70, 0x61,
  0x72, 0x61, 0x74, 0x65, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x20,
  0x61, 0x6e, 0x64, 0x77, 0x68, 0x6f, 0x20, 0x68, 0x61, 0x64, 0x20, 0x62, 0x65,
  0x65, 0x6e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x66, 0x64, 0x65, 0x61, 0x74, 0x68, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x72, 0x65, 0x61, 0x6c, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x09,
  0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x70, 0x72,
  0x6f, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65,
  0x20, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6d, 0x70,
  0x65, 0x74, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x65, 0x6e, 0x67, 0x6c, 0x69,
  0x73, 0x68, 0x20, 0x28, 0x55, 0x4b, 0x29, 0x65, 0x6e, 0x67, 0x6c, 0x69, 0x73,
  0x68, 0x20, 0x28, 0x55, 0x53, 0x29, 0xd0, 0x9c, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0,
  0xb3, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xa1, 0xd1, 0x80, 0xd0, 0xbf, 0xd1, 0x81,
  0xd0, 0xba, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x80, 0xd0, 0xbf, 0xd1, 0x81, 0xd0,
  0xba, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x80, 0xd0, 0xbf, 0xd1, 0x81, 0xd0, 0xba,
  0xd0, 0xbe, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa8, 0xd9, 0x8a, 0xd8,
  0xa9, 0xe6, 0xad, 0xa3, 0xe9, 0xab, 0x94, 0xe4, 0xb8, 0xad, 0xe6, 0x96, 0x87,
  0xe7, 0xae, 0x80, 0xe4, 0xbd, 0x93, 0xe4, 0xb8, 0xad, 0xe6, 0x96, 0x87, 0xe7,
  0xb9, 0x81, 0xe4, 0xbd, 0x93, 0xe4, 0xb8, 0xad, 0xe6, 0x96, 0x87, 0xe6, 0x9c,
  0x89, 0xe9, 0x99, 0x90, 0xe5, 0x85, 0xac, 0xe5, 0x8f, 0xb8, 0xe4, 0xba, 0xba,
  0xe6, 0xb0, 0x91, 0xe6, 0x94, 0xbf, 0xe5, 0xba, 0x9c, 0xe9, 0x98, 0xbf, 0xe9,
  0x87, 0x8c, 0xe5, 0xb7, 0xb4, 0xe5, 0xb7, 0xb4, 0xe7, 0xa4, 0xbe, 0xe4, 0xbc,
  0x9a, 0xe4, 0xb8, 0xbb, 0xe4, 0xb9, 0x89, 0xe6, 0x93, 0x8d, 0xe4, 0xbd, 0x9c,
  0xe7, 0xb3, 0xbb, 0xe7, 0xbb, 0x9f, 0xe6, 0x94, 0xbf, 0xe7, 0xad, 0x96, 0xe6,
  0xb3, 0x95, 0xe8, 0xa7, 0x84, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x63,
  0x69, 0xc3, 0xb3, 0x6e, 0x68, 0x65, 0x72, 0x72, 0x61, 0x6d, 0x69, 0x65, 0x6e,
  0x74, 0x61, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0xc3, 0xb3, 0x6e, 0x69,
  0x63, 0x6f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x63, 0x69, 0xc3, 0xb3,
  0x6e, 0x63, 0x6c, 0x61, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x64, 0x6f, 0x73,
  0x63, 0x6f, 0x6e, 0x6f, 0x63, 0x69, 0x6d, 0x69, 0x65, 0x6e, 0x74, 0x6f, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x63, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x72, 0x65,
  0x6c, 0x61, 0x63, 0x69, 0x6f, 0x6e, 0x61, 0x64, 0x61, 0x73, 0x69, 0x6e, 0x66,
  0x6f, 0x72, 0x6d, 0xc3, 0xa1, 0x74, 0x69, 0x63, 0x61, 0x72, 0x65, 0x6c, 0x61,
  0x63, 0x69, 0x6f, 0x6e, 0x61, 0x64, 0x6f, 0x73, 0x64, 0x65, 0x70, 0x61, 0x72,
  0x74, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x6f, 0x74, 0x72, 0x61, 0x62, 0x61, 0x6a,
  0x61, 0x64, 0x6f, 0x72, 0x65, 0x73, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x61,
  0x6d, 0x65, 0x6e, 0x74, 0x65, 0x61, 0x79, 0x75, 0x6e, 0x74, 0x61, 0x6d, 0x69,
  0x65, 0x6e, 0x74, 0x6f, 0x6d, 0x65, 0x72, 0x63, 0x61, 0x64, 0x6f, 0x4c, 0x69,
  0x62, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0xc3, 0xa1, 0x63, 0x74, 0x65, 0x6e,
  0x6f, 0x73, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x63, 0x69, 0x6f, 0x6e, 0x65,
  0x73, 0x63, 0x75, 0x6d, 0x70, 0x6c, 0x69, 0x6d, 0x69, 0x65, 0x6e, 0x74, 0x6f,
  0x72, 0x65, 0x73, 0x74, 0x61, 0x75, 0x72, 0x61, 0x6e, 0x74, 0x65, 0x73, 0x64,
  0x69, 0x73, 0x70, 0x6f, 0x73, 0x69, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f,
  0x6e, 0x73, 0x65, 0x63, 0x75, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x65, 0x6c, 0x65,
  0x63, 0x74, 0x72, 0xc3, 0xb3, 0x6e, 0x69, 0x63, 0x61, 0x61, 0x70, 0x6c, 0x69,
  0x63, 0x61, 0x63, 0x69, 0x6f, 0x6e, 0x65, 0x73, 0x64, 0x65, 0x73, 0x63, 0x6f,
  0x6e, 0x65, 0x63, 0x74, 0x61, 0x64, 0x6f, 0x69, 0x6e, 0x73, 0x74, 0x61, 0x6c,
  0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x72, 0x65, 0x61, 0x6c, 0x69, 0x7a, 0x61,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x75, 0x74, 0x69, 0x6c, 0x69, 0x7a, 0x61, 0x63,
  0x69, 0xc3, 0xb3, 0x6e, 0x65, 0x6e, 0x63, 0x69, 0x63, 0x6c, 0x6f, 0x70, 0x65,
  0x64, 0x69, 0x61, 0x65, 0x6e, 0x66, 0x65, 0x72, 0x6d, 0x65, 0x64, 0x61, 0x64,
  0x65, 0x73, 0x69, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x6f,
  0x73, 0x65, 0x78, 0x70, 0x65, 0x72, 0x69, 0x65, 0x6e, 0x63, 0x69, 0x61, 0x73,
  0x69, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70,
  0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x65, 0x73, 0x73, 0x75,
  0x62, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x69, 0x61, 0xd1, 0x82, 0xd0,
  0xbe, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xa0, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x81, 0xd0, 0xb8, 0xd0, 0xb8, 0xd1, 0x80, 0xd0, 0xb0, 0xd0,
  0xb1, 0xd0, 0xbe, 0xd1, 0x82, 0xd1, 0x8b, 0xd0, 0xb1, 0xd0, 0xbe, 0xd0, 0xbb,
  0xd1, 0x8c, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xb5,
  0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb3, 0xd0,
  0xb8, 0xd1, 0x85, 0xd1, 0x81, 0xd0, 0xbb, 0xd1, 0x83, 0xd1, 0x87, 0xd0, 0xb0,
  0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xb9, 0xd1, 0x87, 0xd0, 0xb0, 0xd1,
  0x81, 0xd0, 0xb2, 0xd1, 0x81, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb0,
  0xd0, 0xa0, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x81, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0,
  0x9c, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xb4,
  0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb3, 0xd0, 0xb8, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0,
  0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xbe,
  0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0,
  0xbd, 0xd0, 0xbd, 0xd1, 0x8b, 0xd1, 0x85, 0xd0, 0xb4, 0xd0, 0xbe, 0xd0, 0xbb,
  0xd0, 0xb6, 0xd0, 0xbd, 0xd1, 0x8b, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0,
  0xbd, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0x9c, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xba,
  0xd0, 0xb2, 0xd1, 0x8b, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb1, 0xd0, 0xbb, 0xd0,
  0xb5, 0xd0, 0xb9, 0xd0, 0x9c, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb2,
  0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbd, 0xd1,
  0x8b, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xbe,
  0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb5, 0xd0,
  0xb4, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xb6, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x83,
  0xd1, 0x81, 0xd0, 0xbb, 0xd1, 0x83, 0xd0, 0xb3, 0xd0, 0xb8, 0xd1, 0x82, 0xd0,
  0xb5, 0xd0, 0xbf, 0xd0, 0xb5, 0xd1, 0x80, 0xd1, 0x8c, 0xd0, 0x9e, 0xd0, 0xb4,
  0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1,
  0x82, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x83, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb1,
  0xd0, 0xbe, 0xd1, 0x82, 0xd1, 0x83, 0xd0, 0xb0, 0xd0, 0xbf, 0xd1, 0x80, 0xd0,
  0xb5, 0xd0, 0xbb, 0xd1, 0x8f, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xb1,
  0xd1, 0x89, 0xd0, 0xb5, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0,
  0xb3, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xb3,
  0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb0, 0xd1, 0x82, 0xd1, 0x8c, 0xd0,
  0xb8, 0xd0, 0xb4, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb9,
  0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd1, 0x83, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1,
  0x85, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd1, 0x88, 0xd0, 0xbe, 0xd0, 0xbf,
  0xd1, 0x80, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xb2, 0xd1, 0x81, 0xd1,
  0x81, 0xd1, 0x8b, 0xd0, 0xbb, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xba, 0xd0, 0xb0,
  0xd0, 0xb6, 0xd0, 0xb4, 0xd1, 0x8b, 0xd0, 0xb9, 0xd0, 0xb2, 0xd0, 0xbb, 0xd0,
  0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xb3, 0xd1, 0x80, 0xd1, 0x83,
  0xd0, 0xbf, 0xd0, 0xbf, 0xd1, 0x8b, 0xd0, 0xb2, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1,
  0x81, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0,
  0xb0, 0xd0, 0xbb, 0xd0, 0xbf, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb2, 0xd1, 0x8b,
  0xd0, 0xb9, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb0, 0xd1, 0x82, 0xd1,
  0x8c, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 0xd0, 0xb3, 0xd0, 0xb8,
  0xd0, 0xbf, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0,
  0xb1, 0xd0, 0xb8, 0xd0, 0xb7, 0xd0, 0xbd, 0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xbe,
  0xd1, 0x81, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xbe, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x82, 0xd0, 0xba, 0xd1, 0x83,
  0xd0, 0xbf, 0xd0, 0xb8, 0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xb4, 0xd0, 0xbe, 0xd0,
  0xbb, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbc,
  0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x85, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x87, 0xd0,
  0xb0, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xa0, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xb0, 0xd0, 0xa2, 0xd0, 0xbe, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0,
  0xba, 0xd0, 0xbe, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xb2, 0xd1, 0x81, 0xd0, 0xb5,
  0xd0, 0xbc, 0xd0, 0xb2, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0,
  0xb9, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x87, 0xd0, 0xb0, 0xd0, 0xbb, 0xd0, 0xb0,
  0xd1, 0x81, 0xd0, 0xbf, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xba, 0xd1,
  0x81, 0xd0, 0xbb, 0xd1, 0x83, 0xd0, 0xb6, 0xd0, 0xb1, 0xd1, 0x8b, 0xd1, 0x81,
  0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xbf, 0xd0,
  0xb5, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0,
  0xbc, 0xd0, 0xbe, 0xd1, 0x89, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xb9,
  0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x87, 0xd0,
  0xb5, 0xd0, 0xbc, 0xd1, 0x83, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbe,
  0xd1, 0x89, 0xd1, 0x8c, 0xd0, 0xb4, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xb6, 0xd0,
  0xbd, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x81, 0xd1, 0x8b, 0xd0, 0xbb, 0xd0, 0xba,
  0xd0, 0xb8, 0xd0, 0xb1, 0xd1, 0x8b, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0,
  0xbe, 0xd0, 0xb4, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xbd, 0xd1, 0x8b, 0xd0, 0xb5,
  0xd0, 0xbc, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb8, 0xd0, 0xb5, 0xd0,
  0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xba, 0xd1, 0x82, 0xd0, 0xa1,
  0xd0, 0xb5, 0xd0, 0xb9, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xbc, 0xd0,
  0xbe, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xb0,
  0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0,
  0xbb, 0xd0, 0xb0, 0xd0, 0xb9, 0xd0, 0xbd, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1, 0x80,
  0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x80, 0xd1,
  0x81, 0xd0, 0xb8, 0xd1, 0x8f, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0,
  0xd0, 0xbd, 0xd0, 0xb5, 0xd1, 0x84, 0xd0, 0xb8, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0,
  0xbc, 0xd1, 0x8b, 0xd1, 0x83, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbd,
  0xd1, 0x8f, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0, 0xbd, 0xd1, 0x8b, 0xd1,
  0x85, 0xd0, 0xb8, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x82, 0xd1, 0x8c,
  0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd1, 0x8e, 0xd1,
  0x8f, 0xd0, 0xbd, 0xd0, 0xb2, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x8f, 0xd0, 0xbc,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd1, 0x8c, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0,
  0xbd, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xb8, 0xd1, 0x85, 0xd0, 0xb4, 0xd0, 0xb0,
  0xd0, 0xbd, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb9, 0xd0, 0xb7, 0xd0, 0xbd, 0xd0,
  0xb0, 0xd1, 0x87, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xbb,
  0xd1, 0x8c, 0xd0, 0xb7, 0xd1, 0x8f, 0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd1,
  0x83, 0xd0, 0xbc, 0xd0, 0xb0, 0xd0, 0xa2, 0xd0, 0xb5, 0xd0, 0xbf, 0xd0, 0xb5,
  0xd1, 0x80, 0xd1, 0x8c, 0xd0, 0xbc, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x8f, 0xd1,
  0x86, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0, 0xb0, 0xd1, 0x89, 0xd0, 0xb8, 0xd1, 0x82,
  0xd1, 0x8b, 0xd0, 0x9b, 0xd1, 0x83, 0xd1, 0x87, 0xd1, 0x88, 0xd0, 0xb8, 0xd0,
  0xb5, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0x85, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x85, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0x95, 0xe0, 0xa5,
  0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb2, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4,
  0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xae, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5,
  0x8b, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb9, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x87, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0x9f, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xad, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x86, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x81, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x98, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x9f,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0x85, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0x85, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xae, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0x9d, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xa1, 0xe0,
  0xa4, 0xbc, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9f,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x95, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb5,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5,
  0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0x97, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xa0,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x95, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb7, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb5,
  0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8b, 0xe0,
  0xa4, 0x9c, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb9, 0xe0,
  0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x89, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x82, 0xe0, 0xa4,
  0x9a, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4,
  0x9c, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x98, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0x9a, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x97, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x87, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xb9,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa1, 0xe0,
  0xa4, 0xbc, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x98, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0,
  0xa4, 0x9a, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5,
  0x80, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbc, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x9c, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x9f, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x96, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbc,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5,
  0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb2,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x96, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x85, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x88, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xab, 0xe0, 0xa5, 0x80, 0xe0,
  0xa4, 0x9c, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0xa4, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb5, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5,
  0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x8b, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xac,
  0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x9c, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xac,
  0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x8c, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbf,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb9, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x82, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa5, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xd8, 0xaa, 0xd8, 0xb3, 0xd8,
  0xaa, 0xd8, 0xb7, 0xd9, 0x8a, 0xd8, 0xb9, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7,
  0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xa9, 0xd8, 0xa8, 0xd9, 0x88, 0xd8, 0xa7, 0xd8,
  0xb3, 0xd8, 0xb7, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb5, 0xd9, 0x81,
  0xd8, 0xad, 0xd8, 0xa9, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xb6, 0xd9,
  0x8a, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xae, 0xd8, 0xa7, 0xd8, 0xb5,
  0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb2, 0xd9, 0x8a, 0xd8,
  0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa9,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa8, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xaf, 0xd9, 0x88, 0xd8, 0xaf, 0xd8, 0xa8,
  0xd8, 0xb1, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xac, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaf, 0xd9, 0x88, 0xd9, 0x84, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x85, 0xd9, 0x88, 0xd9, 0x82, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9,
  0xd8, 0xb1, 0xd8, 0xa8, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd8,
  0xb1, 0xd9, 0x8a, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd9, 0x88,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb0, 0xd9, 0x87, 0xd8,
  0xa7, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xad, 0xd9, 0x8a, 0xd8, 0xa7,
  0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xad, 0xd9, 0x82, 0xd9, 0x88, 0xd9,
  0x82, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd8, 0xb1, 0xd9, 0x8a, 0xd9, 0x85,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x82, 0xd9,
  0x85, 0xd8, 0xad, 0xd9, 0x81, 0xd9, 0x88, 0xd8, 0xb8, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xab, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 0x8a, 0xd9, 0x85, 0xd8,
  0xb4, 0xd8, 0xa7, 0xd9, 0x87, 0xd8, 0xaf, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84,
  0xd9, 0x85, 0xd8, 0xb1, 0xd8, 0xa3, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x82, 0xd8, 0xb1, 0xd8, 0xa2, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb4,
  0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xad, 0xd9,
  0x88, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd8, 0xaf,
  0xd9, 0x8a, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8, 0xb3, 0xd8,
  0xb1, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x88,
  0xd9, 0x85, 0xd9, 0x85, 0xd8, 0xac, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xb9, 0xd8,
  0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xad, 0xd9, 0x85, 0xd9, 0x86,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x86, 0xd9, 0x82, 0xd8, 0xa7, 0xd8, 0xb7, 0xd9,
  0x81, 0xd9, 0x84, 0xd8, 0xb3, 0xd8, 0xb7, 0xd9, 0x8a, 0xd9, 0x86, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x88, 0xd9, 0x8a, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaf, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xb1,
  0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa, 0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xb1, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xb6, 0xd8, 0xaa, 0xd8, 0xad, 0xd9, 0x8a,
  0xd8, 0xa7, 0xd8, 0xaa, 0xd9, 0x8a, 0xd8, 0xa8, 0xd8, 0xaa, 0xd9, 0x88, 0xd9,
  0x82, 0xd9, 0x8a, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd9, 0x88,
  0xd9, 0x84, 0xd9, 0x89, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa8, 0xd8, 0xb1, 0xd9,
  0x8a, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x84, 0xd8, 0xa7,
  0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8,
  0xb7, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb4, 0xd8, 0xae, 0xd8, 0xb5, 0xd9, 0x8a,
  0xd8, 0xb3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xab, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xab, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xb5, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xad, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xab, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xb2, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xae, 0xd9, 0x84, 0xd9, 0x8a, 0xd8, 0xac, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac,
  0xd9, 0x85, 0xd9, 0x8a, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8,
  0xa7, 0xd9, 0x85, 0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd9, 0x85,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8,
  0xb9, 0xd8, 0xa9, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd9, 0x87, 0xd8, 0xaf,
  0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xa6, 0xd9, 0x8a, 0xd8,
  0xb3, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaf, 0xd8, 0xae, 0xd9, 0x88, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xaf, 0xd9, 0x88, 0xd8, 0xb1, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaf, 0xd8, 0xb1, 0xd9, 0x88, 0xd8, 0xb3, 0xd8, 0xa7, 0xd8, 0xb3,
  0xd8, 0xaa, 0xd8, 0xba, 0xd8, 0xb1, 0xd9, 0x82, 0xd8, 0xaa, 0xd8, 0xb5, 0xd8,
  0xa7, 0xd9, 0x85, 0xd9, 0x8a, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa8,
  0xd9, 0x86, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8,
  0xb8, 0xd9, 0x8a, 0xd9, 0x85, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x74, 0x61, 0x69,
  0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61,
  0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x3d, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x28, 0x29, 0x2e, 0x6a, 0x70, 0x67, 0x22, 0x20, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x75, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x6e, 0x67, 0x22, 0x20, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3d, 0x22, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x4d, 0x61, 0x74, 0x68, 0x2e, 0x72, 0x61, 0x6e,
  0x64, 0x6f, 0x6d, 0x28, 0x29, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6d, 0x70, 0x6f,
  0x72, 0x61, 0x72, 0x79, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x53,
  0x74, 0x61, 0x74, 0x65, 0x73, 0x63, 0x69, 0x72, 0x63, 0x75, 0x6d, 0x73, 0x74,
  0x61, 0x6e, 0x63, 0x65, 0x73, 0x2e, 0x61, 0x70, 0x70, 0x65, 0x6e, 0x64, 0x43,
  0x68, 0x69, 0x6c, 0x64, 0x28, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x22, 0x3e, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x22, 0x2f, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x67, 0x75,
  0x69, 0x73, 0x68, 0x65, 0x64, 0x74, 0x68, 0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64,
  0x73, 0x20, 0x6f, 0x66, 0x20, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x22, 0x3e, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x2e,
  0x69, 0x63, 0x6f, 0x22, 0x20, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x72,
  0x69, 0x67, 0x68, 0x74, 0x3a, 0x62, 0x61, 0x73, 0x65, 0x64, 0x20, 0x6f, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x4d, 0x61, 0x73, 0x73, 0x61, 0x63, 0x68, 0x75,
  0x73, 0x65, 0x74, 0x74, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x3d, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x6b, 0x6e, 0x6f,
  0x77, 0x6e, 0x20, 0x61, 0x73, 0x70, 0x72, 0x6f, 0x6e, 0x75, 0x6e, 0x63, 0x69,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75,
  0x6e, 0x64, 0x3a, 0x23, 0x66, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2d,
  0x6c, 0x65, 0x66, 0x74, 0x3a, 0x46, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d,
  0x70, 0x6c, 0x65, 0x2c, 0x20, 0x6d, 0x69, 0x73, 0x63, 0x65, 0x6c, 0x6c, 0x61,
  0x6e, 0x65, 0x6f, 0x75, 0x73, 0x26, 0x6c, 0x74, 0x3b, 0x2f, 0x6d, 0x61, 0x74,
  0x68, 0x26, 0x67, 0x74, 0x3b, 0x70, 0x73, 0x79, 0x63, 0x68, 0x6f, 0x6c, 0x6f,
  0x67, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69,
  0x63, 0x75, 0x6c, 0x61, 0x72, 0x65, 0x61, 0x72, 0x63, 0x68, 0x22, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x6d, 0x65, 0x74,
  0x68, 0x6f, 0x64, 0x3d, 0x22, 0x61, 0x73, 0x20, 0x6f, 0x70, 0x70, 0x6f, 0x73,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x53, 0x75, 0x70, 0x72, 0x65, 0x6d, 0x65, 0x20,
  0x43, 0x6f, 0x75, 0x72, 0x74, 0x6f, 0x63, 0x63, 0x61, 0x73, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x6c, 0x79, 0x20, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x6c, 0x79, 0x2c, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x20, 0x41, 0x6d,
  0x65, 0x72, 0x69, 0x63, 0x61, 0x70, 0x78, 0x3b, 0x62, 0x61, 0x63, 0x6b, 0x67,
  0x72, 0x6f, 0x75, 0x6e, 0x64, 0x6f, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x6e,
  0x69, 0x74, 0x69, 0x65, 0x73, 0x45, 0x6e, 0x74, 0x65, 0x72, 0x74, 0x61, 0x69,
  0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x74, 0x6f, 0x4c, 0x6f, 0x77, 0x65, 0x72,
  0x43, 0x61, 0x73, 0x65, 0x28, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74,
  0x75, 0x72, 0x69, 0x6e, 0x67, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x46, 0x6f, 0x72, 0x20, 0x69, 0x6e, 0x73, 0x74,
  0x61, 0x6e, 0x63, 0x65, 0x2c, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x69,
  0x6e, 0x67, 0x20, 0x6f, 0x66, 0x22, 0x20, 0x6d, 0x61, 0x78, 0x6c, 0x65, 0x6e,
  0x67, 0x74, 0x68, 0x3d, 0x22, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x66,
  0x61, 0x6c, 0x73, 0x65, 0x3b, 0x63, 0x6f, 0x6e, 0x73, 0x63, 0x69, 0x6f, 0x75,
  0x73, 0x6e, 0x65, 0x73, 0x73, 0x4d, 0x65, 0x64, 0x69, 0x74, 0x65, 0x72, 0x72,
  0x61, 0x6e, 0x65, 0x61, 0x6e, 0x65, 0x78, 0x74, 0x72, 0x61, 0x6f, 0x72, 0x64,
  0x69, 0x6e, 0x61, 0x72, 0x79, 0x61, 0x73, 0x73, 0x61, 0x73, 0x73, 0x69, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x62, 0x73, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x74, 0x6c, 0x79, 0x20, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x75, 0x6d, 0x62,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x6f, 0x72, 0x69, 0x67,
  0x69, 0x6e, 0x61, 0x6c, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x72, 0x65, 0x68, 0x65,
  0x6e, 0x73, 0x69, 0x76, 0x65, 0x72, 0x65, 0x66, 0x65, 0x72, 0x73, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f, 0x75, 0x6c, 0x3e, 0x0a, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f, 0x70,
  0x68, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x2e, 0x68, 0x72, 0x65, 0x66, 0x77, 0x61, 0x73, 0x20, 0x70, 0x75, 0x62, 0x6c,
  0x69, 0x73, 0x68, 0x65, 0x64, 0x53, 0x61, 0x6e, 0x20, 0x46, 0x72, 0x61, 0x6e,
  0x63, 0x69, 0x73, 0x63, 0x6f, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x28, 0x29, 0x7b, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d,
  0x22, 0x6d, 0x61, 0x69, 0x6e, 0x73, 0x6f, 0x70, 0x68, 0x69, 0x73, 0x74, 0x69,
  0x63, 0x61, 0x74, 0x65, 0x64, 0x6d, 0x61, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x20, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0d, 0x0a,
  0x3c, 0x62, 0x6f, 0x64, 0x79, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x73,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x68, 0x69, 0x70, 0x73, 0x6d, 0x61, 0x79, 0x20, 0x68, 0x61, 0x76, 0x65,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x28, 0x66, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61,
  0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x54, 0x68, 0x69, 0x73, 0x20, 0x61, 0x72, 0x74,
  0x69, 0x63, 0x6c, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x20,
  0x63, 0x61, 0x73, 0x65, 0x73, 0x70, 0x61, 0x72, 0x74, 0x73, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x47, 0x72, 0x65, 0x61, 0x74, 0x20, 0x42, 0x72,
  0x69, 0x74, 0x61, 0x69, 0x6e, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64,
  0x64, 0x69, 0x6e, 0x67, 0x3d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65,
  0x6e, 0x74, 0x20, 0x74, 0x6f, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x68, 0x6f, 0x6c,
  0x64, 0x65, 0x72, 0x3d, 0x22, 0x3b, 0x20, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73,
  0x69, 0x7a, 0x65, 0x3a, 0x20, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x75, 0x66, 0x66, 0x65, 0x72, 0x65, 0x64,
  0x20, 0x66, 0x72, 0x6f, 0x6d, 0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x20, 0x6c, 0x65, 0x61, 0x64, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x22, 0x2f, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x28, 0x29, 0x20, 0x7b, 0x61, 0x72, 0x65, 0x20, 0x61, 0x76, 0x61, 0x69,
  0x6c, 0x61, 0x62, 0x6c, 0x65, 0x0a, 0x09, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20,
  0x72, 0x65, 0x6c, 0x3d, 0x22, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x27, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x6e, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22, 0x22,
  0x20, 0x2f, 0x3e, 0x3c, 0x2f, 0x61, 0x72, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x65,
  0x72, 0x61, 0x6c, 0x6c, 0x79, 0x68, 0x61, 0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x70, 0x6f, 0x70,
  0x75, 0x6c, 0x61, 0x72, 0x20, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f,
  0x6e, 0x64, 0x69, 0x6e, 0x67, 0x63, 0x72, 0x65, 0x64, 0x69, 0x74, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x3a, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x73, 0x70,
  0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x2e, 0x67, 0x69, 0x66, 0x22, 0x20, 0x77, 0x69,
  0x64, 0x74, 0x68, 0x3d, 0x22, 0x3c, 0x69, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x20,
  0x73, 0x72, 0x63, 0x3d, 0x22, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2d, 0x62,
  0x6c, 0x6f, 0x63, 0x6b, 0x3b, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x6f, 0x67, 0x65, 0x74, 0x68, 0x65, 0x72,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d,
  0x61, 0x74, 0x65, 0x6c, 0x79, 0x70, 0x61, 0x72, 0x6c, 0x69, 0x61, 0x6d, 0x65,
  0x6e, 0x74, 0x61, 0x72, 0x79, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x61, 0x6e, 0x64,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a,
  0x6e, 0x6f, 0x6e, 0x65, 0x3b, 0x74, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x70, 0x72, 0x65, 0x64, 0x6f, 0x6d, 0x69, 0x6e,
  0x61, 0x6e, 0x74, 0x6c, 0x79, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x7c, 0x26,
  0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x2f,
  0x73, 0x70, 0x61, 0x6e, 0x3e, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x70, 0x61,
  0x63, 0x69, 0x6e, 0x67, 0x3d, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x6f, 0x72, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x61, 0x6c, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79,
  0x3d, 0x22, 0x6f, 0x67, 0x3a, 0x2f, 0x78, 0x2d, 0x73, 0x68, 0x6f, 0x63, 0x6b,
  0x77, 0x61, 0x76, 0x65, 0x2d, 0x64, 0x65, 0x6d, 0x6f, 0x6e, 0x73, 0x74, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x75, 0x6e, 0x64,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x4e, 0x65, 0x76, 0x65, 0x72, 0x74, 0x68, 0x65,
  0x6c, 0x65, 0x73, 0x73, 0x2c, 0x77, 0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x66, 0x69, 0x72, 0x73, 0x74, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72,
  0x61, 0x62, 0x6c, 0x65, 0x20, 0x41, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6e,
  0x6f, 0x74, 0x20, 0x62, 0x65, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x72, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79, 0x20,
  0x61, 0x66, 0x74, 0x65, 0x72, 0x66, 0x6f, 0x72, 0x20, 0x69, 0x6e, 0x73, 0x74,
  0x61, 0x6e, 0x63, 0x65, 0x2c, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
  0x64, 0x20, 0x61, 0x73, 0x20, 0x2f, 0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c,
  0x62, 0x6f, 0x64, 0x79, 0x20, 0x73, 0x74, 0x61, 0x72, 0x74, 0x69, 0x6e, 0x67,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x69,
  0x6e, 0x67, 0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66, 0x61, 0x63, 0x74,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x64, 0x69, 0x73, 0x63, 0x75, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x69, 0x64, 0x64, 0x6c, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x76,
  0x69, 0x64, 0x75, 0x61, 0x6c, 0x64, 0x69, 0x66, 0x66, 0x69, 0x63, 0x75, 0x6c,
  0x74, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x6f, 0x66,
  0x20, 0x76, 0x69, 0x65, 0x77, 0x68, 0x6f, 0x6d, 0x6f, 0x73, 0x65, 0x78, 0x75,
  0x61, 0x6c, 0x69, 0x74, 0x79, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x61, 0x6e,
  0x63, 0x65, 0x20, 0x6f, 0x66, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x6d, 0x61, 0x6e, 0x75, 0x66, 0x61, 0x63, 0x74,
  0x75, 0x72, 0x65, 0x72, 0x73, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x6c, 0x79,
  0x20, 0x75, 0x73, 0x65, 0x64, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e,
  0x63, 0x65, 0x20, 0x6f, 0x66, 0x64, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x6e, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75,
  0x6e, 0x64, 0x3a, 0x20, 0x23, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x20, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66,
  0x69, 0x63, 0x61, 0x6e, 0x74, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x3d, 0x22, 0x30, 0x22, 0x3e, 0x72, 0x65, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x72, 0x79, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x6c,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69,
  0x64, 0x65, 0x72, 0x65, 0x64, 0x77, 0x61, 0x73, 0x20, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x65, 0x64, 0x49, 0x6e, 0x64, 0x6f, 0x2d, 0x45, 0x75, 0x72,
  0x6f, 0x70, 0x65, 0x61, 0x6e, 0x76, 0x75, 0x6c, 0x6e, 0x65, 0x72, 0x61, 0x62,
  0x6c, 0x65, 0x20, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x6e, 0x65, 0x6e,
  0x74, 0x73, 0x20, 0x6f, 0x66, 0x61, 0x72, 0x65, 0x20, 0x73, 0x6f, 0x6d, 0x65,
  0x74, 0x69, 0x6d, 0x65, 0x73, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x72, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x4e, 0x65, 0x77, 0x20, 0x59, 0x6f, 0x72, 0x6b,
  0x20, 0x43, 0x69, 0x74, 0x79, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x73,
  0x65, 0x61, 0x72, 0x63, 0x68, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x63, 0x6f, 0x75, 0x72, 0x73, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x68, 0x65, 0x6d, 0x61, 0x74,
  0x69, 0x63, 0x69, 0x61, 0x6e, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65,
  0x6e, 0x64, 0x20, 0x6f, 0x66, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65,
  0x6e, 0x64, 0x20, 0x6f, 0x66, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72,
  0x3d, 0x22, 0x30, 0x22, 0x20, 0x74, 0x65, 0x63, 0x68, 0x6e, 0x6f, 0x6c, 0x6f,
  0x67, 0x69, 0x63, 0x61, 0x6c, 0x2e, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x43,
  0x6c, 0x61, 0x73, 0x73, 0x28, 0x62, 0x72, 0x61, 0x6e, 0x63, 0x68, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x76, 0x69, 0x64, 0x65, 0x6e, 0x63, 0x65,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d,
  0x2d, 0x2d, 0x3e, 0x0d, 0x0a, 0x49, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20, 0x61, 0x20, 0x73,
  0x69, 0x6e, 0x67, 0x6c, 0x65, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
  0x76, 0x65, 0x6c, 0x79, 0x2e, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x66, 0x6f, 0x72, 0x65, 0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x69,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x6c, 0x6f, 0x63, 0x61, 0x74,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x77, 0x68, 0x69, 0x63, 0x68, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x69, 0x73,
  0x20, 0x61, 0x6c, 0x73, 0x6f, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x61, 0x6e,
  0x63, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6e, 0x64,
  0x61, 0x73, 0x68, 0x3b, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
  0x73, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64,
  0x65, 0x6e, 0x74, 0x6c, 0x79, 0x65, 0x71, 0x75, 0x69, 0x70, 0x70, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74,
  0x20, 0x68, 0x61, 0x76, 0x65, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x68, 0x72,
  0x65, 0x66, 0x3d, 0x22, 0x2f, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61,
  0x67, 0x65, 0x20, 0x6f, 0x66, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x54, 0x68, 0x65, 0x73, 0x65, 0x20, 0x69, 0x6e,
  0x63, 0x6c, 0x75, 0x64, 0x65, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x6c, 0x65,
  0x73, 0x73, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x62, 0x65,
  0x20, 0x75, 0x73, 0x65, 0x64, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x20,
  0x74, 0x69, 0x6d, 0x65, 0x73, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
  0x74, 0x20, 0x74, 0x68, 0x65, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x69, 0x6c,
  0x69, 0x74, 0x69, 0x65, 0x73, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x61,
  0x67, 0x65, 0x20, 0x6f, 0x66, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20, 0x61, 0x74, 0x74, 0x65, 0x6d,
  0x70, 0x74, 0x20, 0x74, 0x6f, 0x70, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x6a,
  0x71, 0x75, 0x65, 0x72, 0x79, 0x74, 0x77, 0x6f, 0x20, 0x64, 0x69, 0x66, 0x66,
  0x65, 0x72, 0x65, 0x6e, 0x74, 0x62, 0x65, 0x6c, 0x6f, 0x6e, 0x67, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73,
  0x68, 0x6d, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x22, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c,
  0x65, 0x20, 0x66, 0x6f, 0x72, 0x41, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x69, 0x64, 0x65, 0x20, 0x72, 0x61, 0x6e,
  0x67, 0x65, 0x20, 0x6f, 0x66, 0x09, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6d,
  0x6d, 0x6f, 0x6e, 0x6c, 0x79, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x73, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x61, 0x6c, 0x69, 0x74, 0x79, 0x77, 0x61, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70,
  0x6c, 0x65, 0x74, 0x65, 0x64, 0x20, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6d, 0x64,
  0x61, 0x73, 0x68, 0x3b, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x63, 0x68, 0x61, 0x72,
  0x61, 0x63, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x66, 0x61, 0x63, 0x74, 0x20, 0x74, 0x68, 0x61,
  0x74, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70,
  0x6c, 0x65, 0x20, 0x6f, 0x66, 0x73, 0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x6e, 0x74, 0x6c, 0x79, 0x6f, 0x6e, 0x6d, 0x6f, 0x75, 0x73, 0x65, 0x6f,
  0x76, 0x65, 0x72, 0x3d, 0x22, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x79, 0x20, 0x61, 0x73, 0x79, 0x6e, 0x63, 0x20, 0x3d, 0x20,
  0x74, 0x72, 0x75, 0x65, 0x3b, 0x70, 0x72, 0x6f, 0x62, 0x6c, 0x65, 0x6d, 0x73,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x73, 0x65, 0x65, 0x6d, 0x73, 0x20, 0x74, 0x6f,
  0x20, 0x68, 0x61, 0x76, 0x65, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x75,
  0x6c, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x61, 0x72,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x70, 0x6f, 0x73, 0x73, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x28, 0x29, 0x20, 0x7b, 0x74, 0x6f, 0x6f, 0x6b, 0x20, 0x70, 0x6c, 0x61,
  0x63, 0x65, 0x20, 0x69, 0x6e, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x6f, 0x6d, 0x65,
  0x74, 0x69, 0x6d, 0x65, 0x73, 0x73, 0x75, 0x62, 0x73, 0x74, 0x61, 0x6e, 0x74,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x2f,
  0x73, 0x70, 0x61, 0x6e, 0x3e, 0x69, 0x73, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e,
  0x20, 0x75, 0x73, 0x65, 0x64, 0x69, 0x6e, 0x20, 0x61, 0x6e, 0x20, 0x61, 0x74,
  0x74, 0x65, 0x6d, 0x70, 0x74, 0x67, 0x72, 0x65, 0x61, 0x74, 0x20, 0x64, 0x65,
  0x61, 0x6c, 0x20, 0x6f, 0x66, 0x45, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x6c, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x66,
  0x75, 0x6c, 0x6c, 0x79, 0x20, 0x76, 0x69, 0x72, 0x74, 0x75, 0x61, 0x6c, 0x6c,
  0x79, 0x20, 0x61, 0x6c, 0x6c, 0x32, 0x30, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x2c, 0x70, 0x72, 0x6f, 0x66, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x73, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73, 0x61, 0x72,
  0x79, 0x20, 0x74, 0x6f, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20,
  0x69, 0x74, 0x20, 0x69, 0x73, 0x44, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61,
  0x72, 0x79, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x54, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x6c, 0x6c,
  0x6f, 0x77, 0x69, 0x6e, 0x67, 0x6d, 0x61, 0x79, 0x20, 0x72, 0x65, 0x66, 0x65,
  0x72, 0x20, 0x74, 0x6f, 0x3a, 0x43, 0x6f, 0x6e, 0x73, 0x65, 0x71, 0x75, 0x65,
  0x6e, 0x74, 0x6c, 0x79, 0x2c, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x61, 0x74, 0x20, 0x77, 0x6f, 0x75,
  0x6c, 0x64, 0x20, 0x62, 0x65, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x27, 0x73, 0x20,
  0x66, 0x69, 0x72, 0x73, 0x74, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69,
  0x65, 0x64, 0x20, 0x61, 0x73, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x28, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75,
  0x6c, 0x61, 0x72, 0x6c, 0x79, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x6c,
  0x65, 0x66, 0x74, 0x22, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x63, 0x6f, 0x6d,
  0x6d, 0x6f, 0x6e, 0x6c, 0x79, 0x62, 0x61, 0x73, 0x69, 0x73, 0x20, 0x66, 0x6f,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x69,
  0x74, 0x79, 0x20, 0x6f, 0x66, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x74, 0x6f, 0x20, 0x72, 0x65, 0x64, 0x75, 0x63,
  0x65, 0x20, 0x74, 0x68, 0x65, 0x6a, 0x75, 0x72, 0x69, 0x73, 0x64, 0x69, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x6e, 0x6d, 0x6f, 0x75, 0x73, 0x65,
  0x6f, 0x75, 0x74, 0x3d, 0x22, 0x4e, 0x65, 0x77, 0x20, 0x54, 0x65, 0x73, 0x74,
  0x61, 0x6d, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c,
  0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x55,
  0x6e, 0x69, 0x74, 0x65, 0x64, 0x66, 0x69, 0x6c, 0x6d, 0x20, 0x64, 0x69, 0x72,
  0x65, 0x63, 0x74, 0x6f, 0x72, 0x2d, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x2e,
  0x64, 0x74, 0x64, 0x22, 0x3e, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e,
  0x20, 0x75, 0x73, 0x65, 0x64, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x74, 0x68, 0x69, 0x73, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x20,
  0x6f, 0x74, 0x68, 0x65, 0x72, 0x62, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x61, 0x72, 0x65, 0x75, 0x6e, 0x70, 0x72, 0x65, 0x63, 0x65, 0x64,
  0x65, 0x6e, 0x74, 0x65, 0x64, 0x69, 0x73, 0x20, 0x73, 0x69, 0x6d, 0x69, 0x6c,
  0x61, 0x72, 0x20, 0x74, 0x6f, 0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
  0x6c, 0x79, 0x20, 0x69, 0x6e, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20,
  0x62, 0x6f, 0x6c, 0x64, 0x3b, 0x69, 0x73, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x09, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x72, 0x65, 0x20, 0x74, 0x79, 0x70, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x63, 0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x41, 0x6e, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70,
  0x6c, 0x65, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x69, 0x74, 0x69,
  0x65, 0x73, 0x20, 0x6f, 0x66, 0x72, 0x61, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x61, 0x6e, 0x20, 0x61, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x65, 0x6c, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x65, 0x73, 0x73, 0x61, 0x72,
  0x79, 0x20, 0x66, 0x6f, 0x72, 0x72, 0x65, 0x70, 0x6f, 0x72, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61,
  0x6c, 0x20, 0x61, 0x6e, 0x64, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x6e,
  0x62, 0x73, 0x70, 0x3b, 0x3c, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
  0x65, 0x73, 0x20, 0x74, 0x6f, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65,
  0x20, 0x79, 0x65, 0x61, 0x72, 0x47, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x68, 0x61, 0x76, 0x65, 0x20, 0x6e, 0x6f, 0x74,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61, 0x6c, 0x20,
  0x79, 0x65, 0x61, 0x72, 0x73, 0x63, 0x6f, 0x6d, 0x6d, 0x69, 0x74, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x74, 0x6f, 0x09, 0x09, 0x3c, 0x75, 0x6c, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x76, 0x69, 0x73, 0x75, 0x61, 0x6c, 0x69, 0x7a,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x31, 0x39, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x2c, 0x70, 0x72, 0x61, 0x63, 0x74, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x65, 0x72, 0x73, 0x74, 0x68, 0x61, 0x74, 0x20, 0x68, 0x65, 0x20,
  0x77, 0x6f, 0x75, 0x6c, 0x64, 0x61, 0x6e, 0x64, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x69, 0x6e, 0x75, 0x65, 0x64, 0x6f, 0x63, 0x63, 0x75, 0x70, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e,
  0x65, 0x64, 0x20, 0x61, 0x73, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x61, 0x6d, 0x6f, 0x75,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x65, 0x71, 0x75, 0x69, 0x76, 0x61, 0x6c, 0x65,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e,
  0x74, 0x69, 0x61, 0x74, 0x65, 0x62, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x20,
  0x61, 0x62, 0x6f, 0x75, 0x74, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x6c,
  0x65, 0x66, 0x74, 0x3a, 0x20, 0x61, 0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x74, 0x20,
  0x6f, 0x66, 0x20, 0x61, 0x73, 0x53, 0x6f, 0x6d, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x73, 0x65, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x69, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x64, 0x75, 0x63, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x61, 0x6e, 0x64, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x72, 0x65, 0x70, 0x75, 0x74, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x61, 0x73, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x63, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x64,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x20, 0x70, 0x61,
  0x72, 0x74, 0x20, 0x6f, 0x66, 0x49, 0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74,
  0x65, 0x20, 0x66, 0x6f, 0x72, 0x74, 0x68, 0x65, 0x20, 0x73, 0x6f, 0x2d, 0x63,
  0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x61, 0x67, 0x61, 0x69, 0x6e, 0x73, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6e, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20,
  0x63, 0x61, 0x73, 0x65, 0x2c, 0x77, 0x61, 0x73, 0x20, 0x61, 0x70, 0x70, 0x6f,
  0x69, 0x6e, 0x74, 0x65, 0x64, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x74, 0x68, 0x69, 0x73, 0x44, 0x65, 0x70, 0x61, 0x72, 0x74, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x6d, 0x61,
  0x69, 0x6e, 0x69, 0x6e, 0x67, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x20, 0x6f,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c,
  0x61, 0x72, 0x6c, 0x79, 0x20, 0x64, 0x65, 0x61, 0x6c, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x20, 0x74, 0x68, 0x65, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x61, 0x6c, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x61,
  0x6c, 0x77, 0x61, 0x79, 0x73, 0x61, 0x72, 0x65, 0x20, 0x63, 0x75, 0x72, 0x72,
  0x65, 0x6e, 0x74, 0x6c, 0x79, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f, 0x70,
  0x68, 0x79, 0x20, 0x6f, 0x66, 0x66, 0x6f, 0x72, 0x20, 0x6d, 0x6f, 0x72, 0x65,
  0x20, 0x74, 0x68, 0x61, 0x6e, 0x63, 0x69, 0x76, 0x69, 0x6c, 0x69, 0x7a, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69,
  0x73, 0x6c, 0x61, 0x6e, 0x64, 0x73, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x65, 0x64,
  0x49, 0x6e, 0x64, 0x65, 0x78, 0x63, 0x61, 0x6e, 0x20, 0x72, 0x65, 0x73, 0x75,
  0x6c, 0x74, 0x20, 0x69, 0x6e, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d,
  0x22, 0x22, 0x20, 0x2f, 0x3e, 0x74, 0x68, 0x65, 0x20, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x20, 0x2f, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x4d, 0x61, 0x6e, 0x79, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x73, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x55,
  0x6e, 0x69, 0x74, 0x65, 0x64, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x6d, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x74,
  0x72, 0x61, 0x63, 0x65, 0x64, 0x69, 0x73, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x6f,
  0x6e, 0x65, 0x20, 0x6f, 0x66, 0x69, 0x73, 0x20, 0x66, 0x72, 0x65, 0x71, 0x75,
  0x65, 0x6e, 0x74, 0x6c, 0x79, 0x6c, 0x69, 0x76, 0x69, 0x6e, 0x67, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x65, 0x74, 0x69,
  0x63, 0x61, 0x6c, 0x6c, 0x79, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x52, 0x65, 0x76, 0x6f, 0x6c, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x72, 0x79, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x69, 0x6e, 0x69, 0x73, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72,
  0x6d, 0x69, 0x6e, 0x65, 0x64, 0x74, 0x68, 0x65, 0x20, 0x70, 0x6f, 0x6c, 0x69,
  0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x73, 0x75, 0x66, 0x66, 0x69, 0x63, 0x69, 0x65,
  0x6e, 0x74, 0x20, 0x74, 0x6f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x22, 0x3e, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x20, 0x73, 0x74,
  0x6f, 0x72, 0x69, 0x65, 0x73, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x61, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x77, 0x68,
  0x65, 0x74, 0x68, 0x65, 0x72, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x66, 0x6f,
  0x72, 0x20, 0x69, 0x74, 0x73, 0x77, 0x61, 0x73, 0x20, 0x69, 0x6e, 0x69, 0x74,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a,
  0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x69, 0x73, 0x20, 0x61, 0x6e, 0x20, 0x65, 0x78,
  0x61, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x69, 0x6e,
  0x63, 0x69, 0x70, 0x61, 0x6c, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x73, 0x74, 0x73,
  0x20, 0x6f, 0x66, 0x20, 0x61, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e, 0x69, 0x7a,
  0x65, 0x64, 0x20, 0x61, 0x73, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x61, 0x20, 0x73, 0x75, 0x62, 0x73, 0x74, 0x61,
  0x6e, 0x74, 0x69, 0x61, 0x6c, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72,
  0x75, 0x63, 0x74, 0x65, 0x64, 0x68, 0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x20,
  0x73, 0x74, 0x61, 0x74, 0x65, 0x72, 0x65, 0x73, 0x69, 0x73, 0x74, 0x61, 0x6e,
  0x63, 0x65, 0x20, 0x74, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x67, 0x72, 0x61,
  0x64, 0x75, 0x61, 0x74, 0x65, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72,
  0x65, 0x20, 0x74, 0x77, 0x6f, 0x67, 0x72, 0x61, 0x76, 0x69, 0x74, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61, 0x72, 0x65, 0x20, 0x64, 0x65, 0x73, 0x63,
  0x72, 0x69, 0x62, 0x65, 0x64, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x73, 0x65, 0x72, 0x76, 0x65, 0x64, 0x20, 0x61,
  0x73, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x68,
  0x65, 0x61, 0x64, 0x65, 0x72, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x66, 0x75, 0x6e, 0x64, 0x61, 0x6d, 0x65, 0x6e,
  0x74, 0x61, 0x6c, 0x6c, 0x79, 0x64, 0x6f, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x6f, 0x74, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65,
  0x20, 0x77, 0x69, 0x74, 0x68, 0x77, 0x61, 0x73, 0x20, 0x66, 0x6f, 0x72, 0x63,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74, 0x69,
  0x76, 0x65, 0x6c, 0x79, 0x2c, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x6f, 0x6c, 0x69,
  0x74, 0x69, 0x63, 0x61, 0x6c, 0x69, 0x6e, 0x20, 0x73, 0x75, 0x70, 0x70, 0x6f,
  0x72, 0x74, 0x20, 0x6f, 0x66, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x69,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x32, 0x30, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x2e, 0x61, 0x6e, 0x64, 0x20, 0x70, 0x75, 0x62, 0x6c,
  0x69, 0x73, 0x68, 0x65, 0x64, 0x6c, 0x6f, 0x61, 0x64, 0x43, 0x68, 0x61, 0x72,
  0x74, 0x62, 0x65, 0x61, 0x74, 0x74, 0x6f, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72,
  0x73, 0x74, 0x61, 0x6e, 0x64, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x73,
  0x74, 0x61, 0x74, 0x65, 0x73, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d,
  0x65, 0x6e, 0x74, 0x61, 0x6c, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x68, 0x61,
  0x6c, 0x66, 0x20, 0x6f, 0x66, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65,
  0x73, 0x20, 0x61, 0x6e, 0x64, 0x61, 0x72, 0x63, 0x68, 0x69, 0x74, 0x65, 0x63,
  0x74, 0x75, 0x72, 0x61, 0x6c, 0x62, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69,
  0x64, 0x65, 0x72, 0x65, 0x64, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65,
  0x72, 0x69, 0x7a, 0x65, 0x64, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x49, 0x6e, 0x74,
  0x65, 0x72, 0x76, 0x61, 0x6c, 0x61, 0x75, 0x74, 0x68, 0x6f, 0x72, 0x69, 0x74,
  0x61, 0x74, 0x69, 0x76, 0x65, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x77, 0x61, 0x73, 0x20, 0x73, 0x75, 0x63, 0x63,
  0x65, 0x65, 0x64, 0x65, 0x64, 0x61, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x72,
  0x65, 0x20, 0x61, 0x72, 0x65, 0x61, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x65, 0x71,
  0x75, 0x65, 0x6e, 0x63, 0x65, 0x74, 0x68, 0x65, 0x20, 0x50, 0x72, 0x65, 0x73,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x69, 0x6e, 0x63,
  0x6c, 0x75, 0x64, 0x65, 0x64, 0x66, 0x72, 0x65, 0x65, 0x20, 0x73, 0x6f, 0x66,
  0x74, 0x77, 0x61, 0x72, 0x65, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x77, 0x61, 0x73, 0x20, 0x64, 0x65, 0x73, 0x74,
  0x72, 0x6f, 0x79, 0x65, 0x64, 0x61, 0x77, 0x61, 0x79, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x20, 0x74, 0x68, 0x65, 0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x74, 0x68, 0x65, 0x79, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65, 0x64,
  0x20, 0x62, 0x79, 0x20, 0x61, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x70, 0x6f, 0x77,
  0x65, 0x72, 0x66, 0x75, 0x6c, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x20, 0x61, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69,
  0x74, 0x79, 0x20, 0x6f, 0x66, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x6d, 0x61, 0x6e, 0x79, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x65, 0x73,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x48, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x73, 0x6f, 0x6d, 0x65, 0x69, 0x73, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x67,
  0x68, 0x74, 0x20, 0x74, 0x6f, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x65, 0x6e, 0x64, 0x77, 0x61, 0x73, 0x20, 0x61, 0x6e, 0x6e, 0x6f,
  0x75, 0x6e, 0x63, 0x65, 0x64, 0x61, 0x72, 0x65, 0x20, 0x69, 0x6d, 0x70, 0x6f,
  0x72, 0x74, 0x61, 0x6e, 0x74, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x69, 0x6e, 0x63,
  0x6c, 0x75, 0x64, 0x65, 0x73, 0x3e, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x74, 0x68, 0x65, 0x20, 0x63, 0x65, 0x6e, 0x74,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x44, 0x4f, 0x20, 0x4e, 0x4f, 0x54, 0x20,
  0x41, 0x4c, 0x54, 0x45, 0x52, 0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
  0x72, 0x65, 0x66, 0x65, 0x72, 0x74, 0x68, 0x65, 0x6d, 0x65, 0x73, 0x2f, 0x3f,
  0x73, 0x6f, 0x72, 0x74, 0x3d, 0x74, 0x68, 0x61, 0x74, 0x20, 0x68, 0x61, 0x64,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x62, 0x61, 0x73, 0x69,
  0x73, 0x20, 0x66, 0x6f, 0x72, 0x68, 0x61, 0x73, 0x20, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x65, 0x64, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x73,
  0x75, 0x6d, 0x6d, 0x65, 0x72, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x72, 0x61, 0x74,
  0x69, 0x76, 0x65, 0x6c, 0x79, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x63, 0x68, 0x20, 0x61, 0x73, 0x20,
  0x74, 0x68, 0x6f, 0x73, 0x65, 0x74, 0x68, 0x65, 0x20, 0x72, 0x65, 0x73, 0x75,
  0x6c, 0x74, 0x69, 0x6e, 0x67, 0x69, 0x73, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x73,
  0x73, 0x69, 0x62, 0x6c, 0x65, 0x76, 0x61, 0x72, 0x69, 0x6f, 0x75, 0x73, 0x20,
  0x6f, 0x74, 0x68, 0x65, 0x72, 0x53, 0x6f, 0x75, 0x74, 0x68, 0x20, 0x41, 0x66,
  0x72, 0x69, 0x63, 0x61, 0x6e, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x73, 0x61, 0x6d, 0x65, 0x65, 0x66, 0x66, 0x65, 0x63, 0x74, 0x69, 0x76,
  0x65, 0x6e, 0x65, 0x73, 0x73, 0x69, 0x6e, 0x20, 0x77, 0x68, 0x69, 0x63, 0x68,
  0x20, 0x63, 0x61, 0x73, 0x65, 0x3b, 0x20, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61,
  0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72,
  0x65, 0x20, 0x61, 0x6e, 0x64, 0x3b, 0x20, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72,
  0x6f, 0x75, 0x6e, 0x64, 0x3a, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20,
  0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d,
  0x61, 0x72, 0x67, 0x69, 0x6e, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x74, 0x68, 0x65, 0x62, 0x61, 0x68, 0x61, 0x73, 0x61, 0x20, 0x4d,
  0x65, 0x6c, 0x61, 0x79, 0x75, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x62, 0x6f,
  0x6b, 0x6d, 0xc3, 0xa5, 0x6c, 0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x20, 0x6e, 0x79,
  0x6e, 0x6f, 0x72, 0x73, 0x6b, 0x73, 0x6c, 0x6f, 0x76, 0x65, 0x6e, 0xc5, 0xa1,
  0xc4, 0x8d, 0x69, 0x6e, 0x61, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x63,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x63, 0x61, 0x6c, 0x69, 0x66, 0x69, 0x63, 0x61,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63,
  0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x22, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x61, 0x6d, 0x62, 0x69,
  0x67, 0x75, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e,
  0x4e, 0x61, 0x6d, 0x65, 0x27, 0x2c, 0x20, 0x27, 0x61, 0x64, 0x6d, 0x69, 0x6e,
  0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x69, 0x6d, 0x75,
  0x6c, 0x74, 0x61, 0x6e, 0x65, 0x6f, 0x75, 0x73, 0x6c, 0x79, 0x74, 0x72, 0x61,
  0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x49, 0x6e,
  0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x6d,
  0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x3a,
  0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74,
  0x79, 0x3c, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d, 0x2d, 0x2d, 0x3e,
  0x0a, 0x3c, 0x2f, 0x3e, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x22, 0x69, 0x6d, 0x70, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x69, 0x6e, 0x66, 0x72, 0x61, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x75, 0x72, 0x65, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e,
  0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x2d,
  0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x3a, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64,
  0x3e, 0x0a, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x3d, 0x68, 0x74, 0x74, 0x70,
  0x25, 0x33, 0x41, 0x25, 0x32, 0x46, 0x25, 0x32, 0x46, 0x3c, 0x66, 0x6f, 0x72,
  0x6d, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x6d, 0x65, 0x74,
  0x68, 0x6f, 0x64, 0x3d, 0x22, 0x70, 0x6f, 0x73, 0x74, 0x22, 0x20, 0x2f, 0x66,
  0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x2e, 0x69, 0x63, 0x6f, 0x22, 0x20, 0x7d,
  0x29, 0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a,
  0x2e, 0x73, 0x65, 0x74, 0x41, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65,
  0x28, 0x41, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x3d, 0x20, 0x6e, 0x65, 0x77, 0x20, 0x41, 0x72, 0x72, 0x61, 0x79,
  0x28, 0x29, 0x3b, 0x3c, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d, 0x2d,
  0x2d, 0x3e, 0x0d, 0x0a, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x62,
  0x6c, 0x6f, 0x63, 0x6b, 0x3b, 0x55, 0x6e, 0x66, 0x6f, 0x72, 0x74, 0x75, 0x6e,
  0x61, 0x74, 0x65, 0x6c, 0x79, 0x2c, 0x22, 0x3e, 0x26, 0x6e, 0x62, 0x73, 0x70,
  0x3b, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x2f, 0x66, 0x61, 0x76, 0x69, 0x63,
  0x6f, 0x6e, 0x2e, 0x69, 0x63, 0x6f, 0x22, 0x3e, 0x3d, 0x27, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x27, 0x20, 0x69, 0x64, 0x65, 0x6e,
  0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2c, 0x20, 0x66,
  0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x3c, 0x6c,
  0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x2f, 0x61,
  0x6e, 0x20, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x76, 0x65,
  0x61, 0x73, 0x20, 0x61, 0x20, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x20, 0x6f,
  0x66, 0x70, 0x74, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x0a, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x73, 0x75, 0x62, 0x6d, 0x69,
  0x74, 0x22, 0x20, 0x0a, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x28, 0x29, 0x20, 0x7b, 0x72, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x65, 0x6e, 0x64,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x61, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x2f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
  0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x72, 0x65, 0x63, 0x6f, 0x6e, 0x73,
  0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x2e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x20, 0x41, 0x63, 0x63,
  0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x68, 0x69, 0x64,
  0x64, 0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x6c,
  0x6f, 0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x64,
  0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x62, 0x6f, 0x64, 0x79, 0x2e,
  0x61, 0x70, 0x70, 0x72, 0x6f, 0x78, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x6c, 0x79,
  0x20, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x73, 0x70, 0x6f, 0x73, 0x74, 0x22, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x3d, 0x22, 0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x2d, 0x2d, 0x3c, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69,
  0x66, 0x5d, 0x2d, 0x2d, 0x3e, 0x50, 0x72, 0x69, 0x6d, 0x65, 0x20, 0x4d, 0x69,
  0x6e, 0x69, 0x73, 0x74, 0x65, 0x72, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
  0x65, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x3c, 0x2f, 0x61, 0x3e, 0x20, 0x3c,
  0x61, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x74, 0x68, 0x65, 0x20, 0x68,
  0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x6f, 0x6e, 0x6d,
  0x6f, 0x75, 0x73, 0x65, 0x6f, 0x76, 0x65, 0x72, 0x3d, 0x22, 0x74, 0x68, 0x65,
  0x20, 0x67, 0x6f, 0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x68, 0x72,
  0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77,
  0x61, 0x73, 0x20, 0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79,
  0x77, 0x61, 0x73, 0x20, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65,
  0x64, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74,
  0x69, 0x76, 0x65, 0x61, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64,
  0x65, 0x72, 0x65, 0x64, 0x3c, 0x21, 0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d,
  0x2d, 0x2d, 0x3e, 0x0a, 0x0a, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x73, 0x20,
  0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73,
  0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x6e, 0x20, 0x63, 0x6f, 0x6e,
  0x74, 0x72, 0x61, 0x73, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x6c, 0x61, 0x63,
  0x65, 0x68, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x63, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x74,
  0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x63, 0x6f,
  0x6e, 0x73, 0x74, 0x69, 0x74, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x2d,
  0x3a, 0x20, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x20,
  0x7b, 0x42, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x2d, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x2e, 0x64, 0x74, 0x64,
  0x22, 0x3e, 0x0a, 0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x61, 0x63, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x6e, 0x69,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x2f, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70,
  0x65, 0x6f, 0x70, 0x6c, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x61,
  0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x73, 0x29, 0x3b,
  0x20, 0x6a, 0x73, 0x2e, 0x69, 0x64, 0x20, 0x3d, 0x20, 0x69, 0x64, 0x22, 0x20,
  0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x30, 0x25, 0x22, 0x72,
  0x65, 0x67, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x52, 0x6f, 0x6d, 0x61, 0x6e, 0x20, 0x43, 0x61, 0x74, 0x68, 0x6f, 0x6c, 0x69,
  0x63, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x65,
  0x6e, 0x74, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x2e, 0x67, 0x69, 0x66, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74,
  0x68, 0x3d, 0x22, 0x31, 0x74, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x69, 0x6e, 0x67, 0x20, 0x64, 0x69, 0x73, 0x63, 0x72, 0x69, 0x6d, 0x69,
  0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x72, 0x63, 0x68, 0x61, 0x65, 0x6f,
  0x6c, 0x6f, 0x67, 0x69, 0x63, 0x61, 0x6c, 0x70, 0x72, 0x69, 0x6d, 0x65, 0x20,
  0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x65, 0x72, 0x2e, 0x6a, 0x73, 0x22, 0x3e,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x63, 0x6f, 0x6d, 0x62,
  0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x6d, 0x61,
  0x72, 0x67, 0x69, 0x6e, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x63, 0x72,
  0x65, 0x61, 0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x28, 0x77,
  0x2e, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x28,
  0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72,
  0x3e, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
  0x2f, 0x61, 0x49, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c,
  0x61, 0x72, 0x2c, 0x20, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x6c, 0x65,
  0x66, 0x74, 0x22, 0x20, 0x43, 0x7a, 0x65, 0x63, 0x68, 0x20, 0x52, 0x65, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x63, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b,
  0x69, 0x6e, 0x67, 0x64, 0x6f, 0x6d, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70,
  0x6f, 0x6e, 0x64, 0x65, 0x6e, 0x63, 0x65, 0x63, 0x6f, 0x6e, 0x63, 0x6c, 0x75,
  0x64, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x2e, 0x68, 0x74, 0x6d, 0x6c,
  0x22, 0x20, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3d, 0x22, 0x28, 0x66, 0x75, 0x6e,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x28, 0x29, 0x20, 0x7b, 0x63, 0x6f, 0x6d,
  0x65, 0x73, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x61, 0x70,
  0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x3c,
  0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73,
  0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62,
  0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x28, 0x27, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x27, 0x3c, 0x2f, 0x61, 0x3e, 0x0a, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x0a,
  0x3c, 0x6c, 0x69, 0x76, 0x65, 0x72, 0x79, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x74, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x28, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x6b,
  0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x09, 0x3c, 0x6c, 0x69, 0x3e, 0x3c,
  0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x3e, 0x3c, 0x69, 0x6e, 0x70,
  0x75, 0x74, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x73, 0x65, 0x70, 0x61,
  0x72, 0x61, 0x74, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x72, 0x65, 0x66,
  0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x73, 0x20, 0x76,
  0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x74, 0x6f, 0x70, 0x22, 0x3e, 0x66,
  0x6f, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x61, 0x74, 0x74, 0x65, 0x6d, 0x70, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f,
  0x20, 0x63, 0x61, 0x72, 0x62, 0x6f, 0x6e, 0x20, 0x64, 0x69, 0x6f, 0x78, 0x69,
  0x64, 0x65, 0x0a, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73, 0x65, 0x61,
  0x72, 0x63, 0x68, 0x2d, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x6f, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x6e,
  0x69, 0x74, 0x79, 0x20, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x3c, 0x2f, 0x68, 0x65, 0x61, 0x64,
  0x3e, 0x0d, 0x0a, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x3d, 0x22, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x54, 0x69, 0xe1, 0xba,
  0xbf, 0x6e, 0x67, 0x20, 0x56, 0x69, 0xe1, 0xbb, 0x87, 0x74, 0x63, 0x68, 0x61,
  0x6e, 0x67, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x2d, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x30,
  0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x20,
  0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x3c, 0x77, 0x61, 0x73, 0x20, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
  0x65, 0x64, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78,
  0x74, 0x22, 0x20, 0x29, 0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x3e, 0x0a, 0x0a, 0x44, 0x65, 0x70, 0x61, 0x72, 0x74, 0x6d, 0x65, 0x6e,
  0x74, 0x20, 0x6f, 0x66, 0x20, 0x65, 0x63, 0x63, 0x6c, 0x65, 0x73, 0x69, 0x61,
  0x73, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x68,
  0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74,
  0x69, 0x6e, 0x67, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x3c, 0x2f, 0x62, 0x6f, 0x64,
  0x79, 0x3e, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x68, 0x61, 0x73, 0x20,
  0x6e, 0x65, 0x76, 0x65, 0x72, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x74, 0x68, 0x65,
  0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x69, 0x6e,
  0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x20, 0x74, 0x6f, 0x61,
  0x75, 0x74, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x6c, 0x79, 0x20,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x69, 0x77, 0x61, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72,
  0x65, 0x64, 0x70, 0x65, 0x72, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x22, 0x20, 0x2f, 0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x64, 0x65, 0x73, 0x63, 0x65, 0x6e, 0x64, 0x65,
  0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x73, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74,
  0x2d, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x74, 0x6f, 0x20, 0x62, 0x65,
  0x20, 0x63, 0x6f, 0x6e, 0x66, 0x75, 0x73, 0x65, 0x64, 0x6d, 0x65, 0x6d, 0x62,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x61, 0x64,
  0x64, 0x69, 0x6e, 0x67, 0x2d, 0x72, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x74, 0x72,
  0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69,
  0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x77, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x6f, 0x72, 0x20, 0x6e,
  0x6f, 0x74, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20, 0x61,
  0x6c, 0x73, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65, 0x20,
  0x6d, 0x61, 0x6e, 0x79, 0x61, 0x20, 0x73, 0x6d, 0x61, 0x6c, 0x6c, 0x20, 0x6e,
  0x75, 0x6d, 0x62, 0x65, 0x72, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x70, 0x61,
  0x72, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x69, 0x6d, 0x70, 0x6f, 0x73, 0x73, 0x69,
  0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x62, 0x75, 0x74, 0x74, 0x6f, 0x6e, 0x6c, 0x6f, 0x63, 0x61, 0x74,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x2e, 0x20, 0x48, 0x6f,
  0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x61, 0x6e, 0x64,
  0x20, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x41, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x62,
  0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x74, 0x73,
  0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x73, 0x20, 0x74, 0x68,
  0x65, 0x3c, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x3d, 0x22, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x70, 0x6f,
  0x73, 0x74, 0x22, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x70, 0x6f, 0x73, 0x73,
  0x69, 0x62, 0x6c, 0x65, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x6c, 0x69, 0x6b, 0x65,
  0x6c, 0x79, 0x20, 0x74, 0x6f, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x65,
  0x61, 0x73, 0x65, 0x20, 0x69, 0x6e, 0x68, 0x61, 0x76, 0x65, 0x20, 0x61, 0x6c,
  0x73, 0x6f, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73,
  0x70, 0x6f, 0x6e, 0x64, 0x73, 0x20, 0x74, 0x6f, 0x61, 0x6e, 0x6e, 0x6f, 0x75,
  0x6e, 0x63, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x6c, 0x69, 0x67,
  0x6e, 0x3d, 0x22, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3e, 0x6d, 0x61, 0x6e,
  0x79, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x66, 0x6f,
  0x72, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x65,
  0x61, 0x72, 0x6c, 0x69, 0x65, 0x73, 0x74, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x69, 0x74, 0x20, 0x77, 0x61,
  0x73, 0x70, 0x74, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x0d, 0x20, 0x76, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x74, 0x6f,
  0x70, 0x22, 0x20, 0x69, 0x6e, 0x68, 0x61, 0x62, 0x69, 0x74, 0x61, 0x6e, 0x74,
  0x73, 0x20, 0x6f, 0x66, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x20, 0x79, 0x65, 0x61, 0x72, 0x0d, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x69, 0x6c, 0x6c, 0x69, 0x6f, 0x6e,
  0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f,
  0x76, 0x65, 0x72, 0x73, 0x69, 0x61, 0x6c, 0x20, 0x63, 0x6f, 0x6e, 0x63, 0x65,
  0x72, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x61, 0x72, 0x67, 0x75,
  0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x67, 0x6f, 0x76,
  0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x61, 0x6e, 0x64, 0x61, 0x20,
  0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x74, 0x6f, 0x74,
  0x72, 0x61, 0x6e, 0x73, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x62, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x63, 0x6f, 0x6c, 0x6f,
  0x72, 0x3a, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68,
  0x65, 0x72, 0x65, 0x62, 0x65, 0x73, 0x74, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e,
  0x20, 0x66, 0x6f, 0x72, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x6d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x74, 0x68,
  0x61, 0x6e, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x72, 0x65, 0x63, 0x6f, 0x67, 0x6e,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x43, 0x6f, 0x75, 0x6e, 0x63,
  0x69, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x65, 0x64, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x20, 0x3c,
  0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x45, 0x6e,
  0x74, 0x65, 0x72, 0x74, 0x61, 0x69, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x61,
  0x77, 0x61, 0x79, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x3b, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x72, 0x69, 0x67, 0x68, 0x74,
  0x3a, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x20,
  0x6f, 0x66, 0x69, 0x6e, 0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x73, 0x63, 0x6f, 0x6e, 0x6e, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20,
  0x77, 0x69, 0x74, 0x68, 0x61, 0x6e, 0x64, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x20,
  0x6f, 0x74, 0x68, 0x65, 0x72, 0x61, 0x6c, 0x74, 0x68, 0x6f, 0x75, 0x67, 0x68,
  0x20, 0x69, 0x74, 0x20, 0x69, 0x73, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69,
  0x6e, 0x67, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x3c, 0x73, 0x70, 0x61, 0x6e,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x64, 0x65, 0x73, 0x63, 0x65,
  0x6e, 0x64, 0x61, 0x6e, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x3c, 0x73, 0x70, 0x61,
  0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x20, 0x61, 0x6c,
  0x69, 0x67, 0x6e, 0x3d, 0x22, 0x72, 0x69, 0x67, 0x68, 0x74, 0x22, 0x3c, 0x2f,
  0x68, 0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x20, 0x61,
  0x73, 0x70, 0x65, 0x63, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x68, 0x61, 0x73, 0x20, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x20, 0x62, 0x65, 0x65,
  0x6e, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x61, 0x6e, 0x20, 0x55, 0x6e, 0x69,
  0x6f, 0x6e, 0x72, 0x65, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x63, 0x65, 0x6e, 0x74,
  0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x64, 0x69, 0x66, 0x66, 0x69,
  0x63, 0x75, 0x6c, 0x74, 0x56, 0x69, 0x63, 0x65, 0x20, 0x50, 0x72, 0x65, 0x73,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x70, 0x61, 0x73, 0x73, 0x65, 0x64, 0x20,
  0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x69,
  0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x66, 0x6f, 0x6e, 0x74, 0x2d,
  0x73, 0x69, 0x7a, 0x65, 0x3a, 0x31, 0x31, 0x70, 0x78, 0x65, 0x78, 0x70, 0x6c,
  0x61, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65,
  0x20, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x70, 0x74, 0x20, 0x6f, 0x66, 0x77, 0x72,
  0x69, 0x74, 0x74, 0x65, 0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x09,
  0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x69, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x72, 0x65, 0x73, 0x65, 0x6d, 0x62, 0x6c, 0x61, 0x6e, 0x63, 0x65, 0x20,
  0x74, 0x6f, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x67, 0x72, 0x6f, 0x75,
  0x6e, 0x64, 0x73, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x61, 0x69, 0x6e, 0x73, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x65, 0x61, 0x6e, 0x73, 0x20,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x75, 0x74, 0x73, 0x69,
  0x64, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x70, 0x70,
  0x6f, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x69, 0x6e,
  0x70, 0x75, 0x74, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x73,
  0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x74, 0x28,
  0x4d, 0x61, 0x74, 0x68, 0x2e, 0x72, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x28, 0x29,
  0x6d, 0x6f, 0x73, 0x74, 0x20, 0x70, 0x72, 0x6f, 0x6d, 0x69, 0x6e, 0x65, 0x6e,
  0x74, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x43, 0x6f, 0x6e, 0x73, 0x74, 0x61, 0x6e, 0x74, 0x69, 0x6e, 0x6f,
  0x70, 0x6c, 0x65, 0x77, 0x65, 0x72, 0x65, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69,
  0x73, 0x68, 0x65, 0x64, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x73, 0x65, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x31, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67,
  0x68, 0x74, 0x3d, 0x22, 0x31, 0x22, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x69,
  0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x77, 0x68, 0x69, 0x63, 0x68,
  0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x73, 0x77, 0x68, 0x69, 0x63,
  0x68, 0x20, 0x68, 0x61, 0x64, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x64, 0x65, 0x73,
  0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x74, 0x68,
  0x65, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x0a,
  0x09, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x6f,
  0x66, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x20, 0x75, 0x73,
  0x65, 0x64, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x68,
  0x61, 0x76, 0x65, 0x73, 0x75, 0x63, 0x63, 0x65, 0x73, 0x73, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x20,
  0x74, 0x6f, 0x20, 0x62, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x20,
  0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x63, 0x6c, 0x65, 0x61, 0x72, 0x3a, 0x62, 0x0d, 0x0a, 0x3c, 0x2f, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x3c, 0x77, 0x61, 0x73, 0x20, 0x66,
  0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x69, 0x6e, 0x74, 0x65,
  0x72, 0x76, 0x69, 0x65, 0x77, 0x20, 0x77, 0x69, 0x74, 0x68, 0x5f, 0x69, 0x64,
  0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x63, 0x61,
  0x70, 0x69, 0x74, 0x61, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x0d,
  0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73,
  0x72, 0x65, 0x6c, 0x65, 0x61, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x20, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x78, 0x4d, 0x4c, 0x48, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75,
  0x65, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x20, 0x73, 0x75, 0x62, 0x73, 0x65, 0x71,
  0x75, 0x65, 0x6e, 0x74, 0x73, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, 0x6c, 0x61,
  0x72, 0x67, 0x65, 0x73, 0x74, 0x76, 0x65, 0x72, 0x79, 0x20, 0x69, 0x6d, 0x70,
  0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x73, 0x70, 0x65, 0x63, 0x69, 0x66, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x75, 0x72, 0x66, 0x61, 0x63,
  0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x61, 0x70, 0x70, 0x6c, 0x69,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x66, 0x6f, 0x72, 0x65,
  0x69, 0x67, 0x6e, 0x20, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x73, 0x65,
  0x74, 0x44, 0x6f, 0x6d, 0x61, 0x69, 0x6e, 0x4e, 0x61, 0x6d, 0x65, 0x65, 0x73,
  0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x69,
  0x73, 0x20, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x49, 0x6e, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74,
  0x6f, 0x6d, 0x65, 0x61, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x69, 0x73, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x64, 0x20, 0x61, 0x66,
  0x74, 0x65, 0x72, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73,
  0x65, 0x6e, 0x74, 0x65, 0x64, 0x44, 0x65, 0x63, 0x6c, 0x61, 0x72, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x65, 0x66,
  0x66, 0x69, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x43, 0x6c, 0x61, 0x73, 0x73, 0x69,
  0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x74, 0x68, 0x65, 0x72,
  0x20, 0x66, 0x6f, 0x72, 0x6d, 0x73, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x20, 0x72,
  0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x3c, 0x73, 0x70,
  0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x70, 0x65,
  0x72, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x28,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x20, 0x7b, 0x0d,
  0x69, 0x66, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x69,
  0x66, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x6c, 0x65, 0x61, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20,
  0x77, 0x69, 0x74, 0x68, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4e, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x68,
  0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74,
  0x68, 0x61, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x79, 0x70, 0x65, 0x22, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x41, 0x73, 0x73, 0x6f, 0x63,
  0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x0a, 0x3c, 0x2f, 0x68,
  0x65, 0x61, 0x64, 0x3e, 0x0a, 0x3c, 0x62, 0x6f, 0x64, 0x79, 0x6c, 0x6f, 0x63,
  0x61, 0x74, 0x65, 0x64, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73,
  0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x28,
  0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65,
  0x63, 0x6f, 0x6e, 0x63, 0x65, 0x6e, 0x74, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x74, 0x68, 0x65, 0x20, 0x69, 0x6e, 0x64, 0x69, 0x76, 0x69, 0x64, 0x75,
  0x61, 0x6c, 0x61, 0x6d, 0x6f, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d,
  0x6f, 0x73, 0x74, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x61, 0x6e, 0x79, 0x20, 0x6f,
  0x74, 0x68, 0x65, 0x72, 0x2f, 0x3e, 0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20,
  0x72, 0x65, 0x6c, 0x3d, 0x22, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20,
  0x66, 0x61, 0x6c, 0x73, 0x65, 0x3b, 0x74, 0x68, 0x65, 0x20, 0x70, 0x75, 0x72,
  0x70, 0x6f, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20, 0x61, 0x62,
  0x69, 0x6c, 0x69, 0x74, 0x79, 0x20, 0x74, 0x6f, 0x3b, 0x63, 0x6f, 0x6c, 0x6f,
  0x72, 0x3a, 0x23, 0x66, 0x66, 0x66, 0x7d, 0x0a, 0x2e, 0x0a, 0x3c, 0x73, 0x70,
  0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x74, 0x68, 0x65,
  0x20, 0x73, 0x75, 0x62, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x6f, 0x66, 0x64, 0x65,
  0x66, 0x69, 0x6e, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x3e,
  0x0d, 0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22,
  0x63, 0x6c, 0x61, 0x69, 0x6d, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68,
  0x65, 0x68, 0x61, 0x76, 0x65, 0x20, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70,
  0x65, 0x64, 0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x77, 0x69, 0x64, 0x74,
  0x68, 0x3d, 0x22, 0x63, 0x65, 0x6c, 0x65, 0x62, 0x72, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x46, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x64, 0x69, 0x73, 0x74, 0x69,
  0x6e, 0x67, 0x75, 0x69, 0x73, 0x68, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x62, 0x74, 0x61, 0x6b, 0x65, 0x73, 0x20,
  0x70, 0x6c, 0x61, 0x63, 0x65, 0x20, 0x69, 0x6e, 0x75, 0x6e, 0x64, 0x65, 0x72,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x6e, 0x6f, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x3e, 0x3c, 0x21,
  0x5b, 0x65, 0x6e, 0x64, 0x69, 0x66, 0x5d, 0x2d, 0x2d, 0x3e, 0x0a, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x69,
  0x6e, 0x73, 0x74, 0x65, 0x61, 0x64, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x65, 0x64, 0x20, 0x74, 0x68,
  0x65, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x20,
  0x6f, 0x66, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61, 0x73, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x65, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
  0x73, 0x20, 0x69, 0x6e, 0x65, 0x73, 0x74, 0x69, 0x6d, 0x61, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c,
  0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x77, 0x61, 0x73, 0x20, 0x65, 0x76,
  0x65, 0x6e, 0x74, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x74, 0x68, 0x72, 0x6f, 0x75,
  0x67, 0x68, 0x6f, 0x75, 0x74, 0x20, 0x68, 0x69, 0x73, 0x74, 0x68, 0x65, 0x20,
  0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x6f, 0x6d,
  0x65, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x70,
  0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x2f, 0x73,
  0x69, 0x67, 0x6e, 0x69, 0x66, 0x69, 0x63, 0x61, 0x6e, 0x74, 0x6c, 0x79, 0x20,
  0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x0d,
  0x0a, 0x65, 0x6e, 0x76, 0x69, 0x72, 0x6f, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x61,
  0x6c, 0x20, 0x74, 0x6f, 0x20, 0x70, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x20,
  0x74, 0x68, 0x65, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x65, 0x73, 0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x6c,
  0x79, 0x20, 0x66, 0x6f, 0x72, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61,
  0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x65, 0x73, 0x73, 0x65,
  0x6e, 0x74, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x77, 0x65, 0x72, 0x65, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x69, 0x73, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x73, 0x74, 0x68, 0x61, 0x76, 0x65,
  0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x6d, 0x61, 0x64, 0x65, 0x22, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x69, 0x6e,
  0x74, 0x65, 0x72, 0x70, 0x72, 0x65, 0x74, 0x65, 0x64, 0x20, 0x61, 0x73, 0x73,
  0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, 0x68, 0x61, 0x6c, 0x66, 0x20, 0x6f, 0x66,
  0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x6e, 0x6f, 0x22,
  0x20, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20,
  0x6f, 0x66, 0x49, 0x49, 0x2c, 0x20, 0x48, 0x6f, 0x6c, 0x79, 0x20, 0x52, 0x6f,
  0x6d, 0x61, 0x6e, 0x69, 0x73, 0x20, 0x65, 0x78, 0x70, 0x65, 0x63, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x6f, 0x68, 0x61, 0x76, 0x65, 0x20, 0x74, 0x68, 0x65, 0x69,
  0x72, 0x20, 0x6f, 0x77, 0x6e, 0x64, 0x65, 0x66, 0x69, 0x6e, 0x65, 0x64, 0x20,
  0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x74, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x64,
  0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x65, 0x20, 0x6f,
  0x66, 0x74, 0x65, 0x6e, 0x20, 0x75, 0x73, 0x65, 0x64, 0x74, 0x6f, 0x20, 0x65,
  0x6e, 0x73, 0x75, 0x72, 0x65, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x67, 0x72,
  0x65, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x63, 0x6f,
  0x6e, 0x74, 0x61, 0x69, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x61,
  0x72, 0x65, 0x20, 0x66, 0x72, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x6c, 0x79,
  0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x6e, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x20, 0x69, 0x73, 0x20, 0x74,
  0x68, 0x65, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x69,
  0x6e, 0x20, 0x61, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c,
  0x2f, 0x75, 0x6c, 0x3e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x66,
  0x6f, 0x6f, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x64, 0x20, 0x65, 0x73, 0x70, 0x65,
  0x63, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x62,
  0x75, 0x74, 0x74, 0x6f, 0x6e, 0x22, 0x20, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e,
  0x3e, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x77, 0x68, 0x69, 0x63, 0x68,
  0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x3e, 0x0a, 0x3c, 0x6d,
  0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x63, 0x6f, 0x6e,
  0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x68, 0x65, 0x63, 0x61,
  0x72, 0x72, 0x69, 0x65, 0x64, 0x20, 0x6f, 0x75, 0x74, 0x20, 0x62, 0x79, 0x48,
  0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x69, 0x74, 0x20, 0x69, 0x73,
  0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f,
  0x66, 0x69, 0x6e, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x74, 0x6f, 0x70, 0x6f, 0x70, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x63, 0x61, 0x70, 0x69, 0x74, 0x61,
  0x6c, 0x20, 0x6f, 0x66, 0x77, 0x61, 0x73, 0x20, 0x6f, 0x66, 0x66, 0x69, 0x63,
  0x69, 0x61, 0x6c, 0x6c, 0x79, 0x77, 0x68, 0x69, 0x63, 0x68, 0x20, 0x68, 0x61,
  0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x74, 0x68, 0x65, 0x20, 0x48, 0x69, 0x73,
  0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e,
  0x61, 0x74, 0x69, 0x76, 0x65, 0x20, 0x74, 0x6f, 0x64, 0x69, 0x66, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x74, 0x6f, 0x20, 0x73,
  0x75, 0x70, 0x70, 0x6f, 0x72, 0x74, 0x20, 0x74, 0x68, 0x65, 0x73, 0x75, 0x67,
  0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x72, 0x6f, 0x63, 0x65, 0x73, 0x73, 0x20,
  0x20, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x74, 0x68, 0x65, 0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x62, 0x65, 0x63, 0x61, 0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x68,
  0x69, 0x73, 0x63, 0x6f, 0x6e, 0x63, 0x65, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x77,
  0x69, 0x74, 0x68, 0x74, 0x68, 0x65, 0x20, 0x75, 0x6e, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x69, 0x74, 0x79, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x78, 0x74, 0x20, 0x6f, 0x66, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x70, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20,
  0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x71, 0x22, 0x09, 0x09, 0x3c, 0x64, 0x69,
  0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x74, 0x68, 0x65, 0x20,
  0x73, 0x63, 0x69, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x63, 0x72, 0x65, 0x70,
  0x72, 0x65, 0x73, 0x65, 0x6e, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x6d, 0x61,
  0x74, 0x68, 0x65, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x69, 0x61, 0x6e, 0x73, 0x65,
  0x6c, 0x65, 0x63, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65,
  0x74, 0x68, 0x61, 0x74, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65,
  0x6e, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x22, 0x63, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x68, 0x65, 0x61,
  0x64, 0x65, 0x72, 0x69, 0x6e, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75,
  0x6c, 0x61, 0x72, 0x2c, 0x63, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74, 0x65, 0x64,
  0x20, 0x69, 0x6e, 0x74, 0x6f, 0x29, 0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x70, 0x68, 0x69, 0x6c, 0x6f, 0x73, 0x6f,
  0x70, 0x68, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x73, 0x72, 0x70, 0x73, 0x6b, 0x6f,
  0x68, 0x72, 0x76, 0x61, 0x74, 0x73, 0x6b, 0x69, 0x74, 0x69, 0xe1, 0xba, 0xbf,
  0x6e, 0x67, 0x20, 0x56, 0x69, 0xe1, 0xbb, 0x87, 0x74, 0xd0, 0xa0, 0xd1, 0x83,
  0xd1, 0x81, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xb9, 0xd1, 0x80, 0xd1,
  0x83, 0xd1, 0x81, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xb9, 0x69, 0x6e,
  0x76, 0x65, 0x73, 0x74, 0x69, 0x67, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x70,
  0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e,
  0xd0, 0xba, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd1, 0x8b, 0xd0,
  0xb5, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0, 0xbb, 0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82,
  0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd1,
  0x8b, 0xd0, 0xb9, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xb2,
  0xd0, 0xb5, 0xd0, 0xba, 0xd1, 0x81, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x82, 0xd0,
  0xb5, 0xd0, 0xbc, 0xd1, 0x8b, 0xd0, 0x9d, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xbe, 0xd1, 0x82, 0xd0,
  0xbe, 0xd1, 0x80, 0xd1, 0x8b, 0xd1, 0x85, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0, 0xbb,
  0xd0, 0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xb2, 0xd1, 0x80, 0xd0,
  0xb5, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb0, 0xd1, 0x8f, 0xd1, 0x81, 0xd0,
  0xb5, 0xd0, 0xb3, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xbd, 0xd1, 0x8f, 0xd1, 0x81,
  0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x82, 0xd1, 0x8c, 0xd0,
  0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8,
  0xd0, 0xa3, 0xd0, 0xba, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1,
  0x8b, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd1, 0x81,
  0xd1, 0x8b, 0xd0, 0xba, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0,
  0xbe, 0xd0, 0xb9, 0xd1, 0x81, 0xd0, 0xb4, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xb0,
  0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xbe, 0xd1,
  0x89, 0xd1, 0x8c, 0xd1, 0x8e, 0xd1, 0x81, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x80, 0xd0,
  0xb0, 0xd0, 0xb7, 0xd0, 0xbe, 0xd0, 0xbc, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe,
  0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xbd, 0xd1, 0x8b, 0xd1, 0x83, 0xd1, 0x87, 0xd0,
  0xb0, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb5,
  0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb5, 0xd0, 0x93, 0xd0,
  0xbb, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x8f, 0xd0, 0xb8,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xb8, 0xd1,
  0x81, 0xd0, 0xb8, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbc, 0xd0, 0xb0,
  0xd1, 0x80, 0xd0, 0xb5, 0xd1, 0x88, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1,
  0x8f, 0xd0, 0xa1, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x87, 0xd0, 0xb0, 0xd1, 0x82,
  0xd1, 0x8c, 0xd0, 0xbf, 0xd0, 0xbe, 0xd1, 0x8d, 0xd1, 0x82, 0xd0, 0xbe, 0xd0,
  0xbc, 0xd1, 0x83, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x83,
  0xd0, 0xb5, 0xd1, 0x82, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0,
  0xb0, 0xd1, 0x82, 0xd1, 0x8c, 0xd1, 0x82, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xb0,
  0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbd, 0xd0,
  0xb5, 0xd1, 0x87, 0xd0, 0xbd, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb5, 0xd1, 0x88,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb5, 0xd0, 0xba, 0xd0, 0xbe, 0xd1,
  0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xbe, 0xd1, 0x80,
  0xd0, 0xb3, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xba, 0xd0,
  0xbe, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xbc, 0xd0, 0xa0,
  0xd0, 0xb5, 0xd0, 0xba, 0xd0, 0xbb, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xb0, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xaf, 0xd9, 0x89,
  0xd9, 0x85, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8,
  0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xb6, 0xd9, 0x88,
  0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa8, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9,
  0x85, 0xd8, 0xac, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xa7,
  0xd9, 0x82, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8, 0xb3, 0xd8,
  0xa7, 0xd8, 0xa6, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8, 0xb1,
  0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8,
  0xb9, 0xd8, 0xb6, 0xd8, 0xa7, 0xd8, 0xa1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1,
  0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xb6, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xaa, 0xd8, 0xb5, 0xd9, 0x85, 0xd9, 0x8a, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xa7, 0xd8, 0xb9, 0xd8, 0xb6, 0xd8, 0xa7, 0xd8, 0xa1, 0xd8, 0xa7, 0xd9,
  0x84, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xa6, 0xd8, 0xac, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xa3, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd8, 0xb3, 0xd8, 0xac, 0xd9, 0x8a, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd9, 0x82, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9,
  0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb6, 0xd8, 0xba, 0xd8, 0xb7, 0xd8, 0xa7,
  0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x8a, 0xd8, 0xaf, 0xd9,
  0x8a, 0xd9, 0x88, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd8, 0xb1, 0xd8, 0xad,
  0xd9, 0x8a, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd8, 0xaf, 0xd9,
  0x8a, 0xd8, 0xaf, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd8, 0xb9,
  0xd9, 0x84, 0xd9, 0x8a, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8,
  0xae, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7,
  0xd9, 0x81, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xa3, 0xd9, 0x81, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x85, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xaa, 0xd8, 0xa7, 0xd8, 0xb1, 0xd9, 0x8a, 0xd8, 0xae, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaa, 0xd9, 0x82, 0xd9, 0x86, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd8, 0xa8, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xae, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xb7, 0xd8, 0xb1,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xac, 0xd8, 0xaa, 0xd9, 0x85, 0xd8,
  0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaf, 0xd9, 0x8a, 0xd9, 0x83, 0xd9, 0x88,
  0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8,
  0xad, 0xd8, 0xa9, 0xd8, 0xb9, 0xd8, 0xa8, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84,
  0xd9, 0x84, 0xd9, 0x87, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xaa, 0xd8, 0xb1, 0xd8,
  0xa8, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd9, 0x88,
  0xd8, 0xa7, 0xd8, 0xa8, 0xd8, 0xb7, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa3, 0xd8,
  0xaf, 0xd8, 0xa8, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7,
  0xd8, 0xae, 0xd8, 0xa8, 0xd8, 0xa7, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xaa, 0xd8, 0xad, 0xd8, 0xaf, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xa7, 0xd8, 0xba, 0xd8, 0xa7, 0xd9, 0x86, 0xd9, 0x8a, 0x63, 0x75, 0x72,
  0x73, 0x6f, 0x72, 0x3a, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x3b, 0x3c,
  0x2f, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x3e, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61,
  0x20, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x22, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c,
  0x61, 0x73, 0x73, 0x3d, 0x22, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
  0x2e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x76, 0x65, 0x72, 0x74,
  0x69, 0x63, 0x61, 0x6c, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x2f, 0x61,
  0x3e, 0x20, 0x7c, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22,
  0x3c, 0x21, 0x64, 0x6f, 0x63, 0x74, 0x79, 0x70, 0x65, 0x20, 0x68, 0x74, 0x6d,
  0x6c, 0x3e, 0x6d, 0x65, 0x64, 0x69, 0x61, 0x3d, 0x22, 0x73, 0x63, 0x72, 0x65,
  0x65, 0x6e, 0x22, 0x20, 0x3c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22, 0x66, 0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e,
  0x2e, 0x69, 0x63, 0x6f, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x09, 0x09, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x68, 0x61,
  0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x69, 0x73, 0x74, 0x69, 0x63, 0x73, 0x22,
  0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x67, 0x65, 0x74, 0x22,
  0x20, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f, 0x68, 0x74, 0x6d,
  0x6c, 0x3e, 0x0a, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x63, 0x75, 0x74, 0x20, 0x69,
  0x63, 0x6f, 0x6e, 0x22, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
  0x2e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x28, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e,
  0x67, 0x2d, 0x62, 0x6f, 0x74, 0x74, 0x6f, 0x6d, 0x3a, 0x72, 0x65, 0x70, 0x72,
  0x65, 0x73, 0x65, 0x6e, 0x74, 0x61, 0x74, 0x69, 0x76, 0x65, 0x73, 0x73, 0x75,
  0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3d, 0x22,
  0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72,
  0x22, 0x20, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x6f, 0x75, 0x74, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x66,
  0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x0a, 0x20, 0x20, 0x3c, 0x64, 0x69, 0x76,
  0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73, 0x75, 0x62, 0x6d, 0x69,
  0x74, 0x22, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x6f, 0x6e, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20,
  0x76, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x74, 0x6f, 0x70, 0x22, 0x3e,
  0x3c, 0x77, 0x61, 0x73, 0x20, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73,
  0x68, 0x65, 0x64, 0x29, 0x3b, 0x0d, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x20, 0x66,
  0x61, 0x6c, 0x73, 0x65, 0x3b, 0x22, 0x3e, 0x29, 0x2e, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x2e, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x62, 0x65, 0x63, 0x61,
  0x75, 0x73, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x6f,
  0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x63, 0x6f, 0x6f, 0x6b, 0x69, 0x65,
  0x3c, 0x66, 0x6f, 0x72, 0x6d, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d,
  0x22, 0x2f, 0x7d, 0x62, 0x6f, 0x64, 0x79, 0x7b, 0x6d, 0x61, 0x72, 0x67, 0x69,
  0x6e, 0x3a, 0x30, 0x3b, 0x45, 0x6e, 0x63, 0x79, 0x63, 0x6c, 0x6f, 0x70, 0x65,
  0x64, 0x69, 0x61, 0x20, 0x6f, 0x66, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x2e, 0x63, 0x72, 0x65, 0x61,
  0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x28, 0x6e, 0x61, 0x6d,
  0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a,
  0x0a, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x20, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x72, 0x79, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x22, 0x3e, 0x3c, 0x69, 0x6e, 0x70,
  0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x70, 0x6f, 0x72, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x73,
  0x20, 0x70, 0x61, 0x72, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74,
  0x72, 0x69, 0x65, 0x73, 0x22, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e,
  0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x49, 0x6e, 0x20, 0x6f, 0x74,
  0x68, 0x65, 0x72, 0x20, 0x77, 0x6f, 0x72, 0x64, 0x73, 0x2c, 0x64, 0x69, 0x73,
  0x70, 0x6c, 0x61, 0x79, 0x3a, 0x20, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x3b, 0x63,
  0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x2f, 0x3e, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e,
  0x61, 0x6d, 0x65, 0x3d, 0x22, 0x61, 0x73, 0x20, 0x77, 0x65, 0x6c, 0x6c, 0x20,
  0x61, 0x73, 0x20, 0x74, 0x68, 0x65, 0x20, 0x69, 0x6e, 0x20, 0x72, 0x65, 0x63,
  0x65, 0x6e, 0x74, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x0d, 0x0a, 0x09, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x09, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a,
  0x69, 0x6e, 0x73, 0x70, 0x69, 0x72, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x65, 0x6e, 0x64, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c,
  0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20,
  0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x20, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x3a, 0x2e, 0x6a, 0x73,
  0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x20,
  0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
  0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62,
  0x65, 0x65, 0x6e, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x20, 0x6c, 0x61, 0x6e,
  0x67, 0x75, 0x61, 0x67, 0x65, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x43, 0x6f, 0x6d, 0x6d, 0x75, 0x6e,
  0x69, 0x73, 0x74, 0x20, 0x50, 0x61, 0x72, 0x74, 0x79, 0x63, 0x6f, 0x6e, 0x73,
  0x69, 0x73, 0x74, 0x65, 0x6e, 0x74, 0x20, 0x77, 0x69, 0x74, 0x68, 0x62, 0x6f,
  0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c, 0x6c,
  0x20, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x3d, 0x22, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x69, 0x74,
  0x79, 0x20, 0x6f, 0x66, 0x22, 0x20, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22,
  0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x65, 0x64,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x6e, 0x79, 0x20,
  0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x4f, 0x72, 0x74,
  0x68, 0x6f, 0x64, 0x6f, 0x78, 0x20, 0x43, 0x68, 0x75, 0x72, 0x63, 0x68, 0x73,
  0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x2f, 0x3e, 0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c,
  0x3d, 0x22, 0x73, 0x77, 0x61, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x75, 0x6e, 0x74, 0x69, 0x6c, 0x20, 0x68, 0x69,
  0x73, 0x20, 0x64, 0x65, 0x61, 0x74, 0x68, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x0a,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x63, 0x6f,
  0x6d, 0x70, 0x61, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65,
  0x70, 0x6f, 0x72, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x4e, 0x65, 0x74, 0x68, 0x65, 0x72, 0x6c,
  0x61, 0x6e, 0x64, 0x73, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x20,
  0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f,
  0x75, 0x6e, 0x64, 0x3a, 0x75, 0x72, 0x6c, 0x28, 0x61, 0x72, 0x67, 0x75, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x73, 0x63, 0x72,
  0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x6e, 0x6f, 0x22, 0x20, 0x69,
  0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68,
  0x65, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63,
  0x61, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
  0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x74, 0x68, 0x65, 0x20, 0x74, 0x72,
  0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x66, 0x72,
  0x65, 0x71, 0x75, 0x65, 0x6e, 0x74, 0x6c, 0x79, 0x20, 0x75, 0x73, 0x65, 0x64,
  0x61, 0x20, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x76, 0x65, 0x72, 0x79, 0x20, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61,
  0x72, 0x20, 0x74, 0x6f, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x69, 0x73, 0x61, 0x6c, 0x69, 0x67, 0x6e,
  0x3d, 0x22, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x3e, 0x77, 0x6f, 0x75,
  0x6c, 0x64, 0x20, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x69,
  0x6d, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x61, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x3d, 0x61, 0x74, 0x74, 0x61, 0x63, 0x68, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x66,
  0x6f, 0x72, 0x6d, 0x20, 0x6f, 0x66, 0x20, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76,
  0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x69, 0x73, 0x20, 0x64,
  0x65, 0x72, 0x69, 0x76, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x6e, 0x61,
  0x6d, 0x65, 0x64, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65,
  0x49, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x74, 0x6f, 0x72, 0x65, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x20, 0x6f, 0x6e, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x77,
  0x69, 0x64, 0x74, 0x68, 0x3a, 0x20, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65, 0x20,
  0x75, 0x73, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63,
  0x72, 0x65, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x6d, 0x6f, 0x73,
  0x74, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74, 0x20, 0x69,
  0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x6e,
  0x64, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x70, 0x73, 0x65, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x54, 0x68, 0x69, 0x73, 0x20, 0x6d, 0x65, 0x61,
  0x6e, 0x73, 0x20, 0x74, 0x68, 0x61, 0x74, 0x65, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
  0x74, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x77, 0x61, 0x73, 0x20,
  0x72, 0x65, 0x70, 0x6c, 0x61, 0x63, 0x65, 0x64, 0x20, 0x62, 0x79, 0x61, 0x6e,
  0x61, 0x6c, 0x79, 0x73, 0x69, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65,
  0x69, 0x6e, 0x73, 0x70, 0x69, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x66,
  0x6f, 0x72, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x65, 0x64, 0x20, 0x61, 0x73,
  0x20, 0x74, 0x68, 0x65, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x73, 0x75, 0x63, 0x63,
  0x65, 0x73, 0x73, 0x66, 0x75, 0x6c, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20, 0x61,
  0x73, 0x20, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x61, 0x20, 0x63, 0x6f, 0x6d,
  0x70, 0x72, 0x65, 0x68, 0x65, 0x6e, 0x73, 0x69, 0x76, 0x65, 0x48, 0x69, 0x73,
  0x74, 0x6f, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77,
  0x65, 0x72, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65,
  0x64, 0x72, 0x65, 0x74, 0x75, 0x72, 0x6e, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x61, 0x72, 0x65, 0x20, 0x72, 0x65, 0x66, 0x65, 0x72, 0x72,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x55, 0x6e, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
  0x64, 0x20, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x3e, 0x0a, 0x09, 0x3c, 0x64, 0x69,
  0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x73,
  0x69, 0x73, 0x74, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74,
  0x6f, 0x70, 0x50, 0x72, 0x6f, 0x70, 0x61, 0x67, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x69, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x73, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x61, 0x76, 0x61, 0x69, 0x6c, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74,
  0x79, 0x20, 0x6f, 0x66, 0x61, 0x70, 0x70, 0x65, 0x61, 0x72, 0x73, 0x20, 0x74,
  0x6f, 0x20, 0x68, 0x61, 0x76, 0x65, 0x65, 0x6c, 0x65, 0x63, 0x74, 0x72, 0x6f,
  0x6d, 0x61, 0x67, 0x6e, 0x65, 0x74, 0x69, 0x63, 0x65, 0x6e, 0x61, 0x62, 0x6c,
  0x65, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x28, 0x66, 0x75, 0x6e,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x49,
  0x74, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e,
  0x74, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29,
  0x7b, 0x76, 0x61, 0x72, 0x20, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x76, 0x65,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x61, 0x73, 0x20, 0x61, 0x20, 0x72,
  0x65, 0x73, 0x75, 0x6c, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x46, 0x6f,
  0x72, 0x20, 0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x2c, 0x20, 0x69, 0x6e,
  0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x70, 0x6f, 0x73, 0x74,
  0x22, 0x20, 0x77, 0x61, 0x73, 0x20, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x65,
  0x64, 0x20, 0x62, 0x79, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6d, 0x64, 0x61, 0x73,
  0x68, 0x3b, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x61, 0x70, 0x70,
  0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6a, 0x73, 0x22, 0x3e, 0x3c,
  0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x75, 0x6c, 0x3e,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x61,
  0x66, 0x74, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x61, 0x74,
  0x68, 0x77, 0x69, 0x74, 0x68, 0x20, 0x72, 0x65, 0x73, 0x70, 0x65, 0x63, 0x74,
  0x20, 0x74, 0x6f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x70, 0x61, 0x64,
  0x64, 0x69, 0x6e, 0x67, 0x3a, 0x69, 0x73, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69,
  0x63, 0x75, 0x6c, 0x61, 0x72, 0x6c, 0x79, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61,
  0x79, 0x3a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x3b, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x69, 0x73,
  0x20, 0x64, 0x69, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f,
  0xe4, 0xb8, 0xad, 0xe6, 0x96, 0x87, 0x20, 0x28, 0xe7, 0xae, 0x80, 0xe4, 0xbd,
  0x93, 0x29, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x61, 0x62, 0x69, 0x6c,
  0x69, 0x64, 0x61, 0x64, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x72,
  0x61, 0x63, 0x69, 0xc3, 0xb3, 0x6e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
  0x63, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x65, 0x73, 0x63, 0x6f, 0x72, 0x72, 0x65,
  0x73, 0x70, 0x6f, 0x6e, 0x64, 0x69, 0x65, 0x6e, 0x74, 0x65, 0xe0, 0xa4, 0x89,
  0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb5, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0,
  0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa5, 0x81, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0x96, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0x8f, 0xe0, 0xa4, 0xad, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4,
  0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa3, 0xe0,
  0xa4, 0xac, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0,
  0xa5, 0x89, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb9,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0,
  0xa5, 0x83, 0xe0, 0xa4, 0xb7, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa0, 0xe0, 0xa4,
  0xac, 0xe0, 0xa4, 0xa2, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xaa, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x96, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xab, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5,
  0x8c, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xae, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xaa, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4,
  0xac, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9b,
  0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xb6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0x89,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xae, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0x88, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xa2, 0xe0, 0xa4,
  0xbc, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xab, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xae, 0xe0, 0xa4,
  0xae, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x96, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf,
  0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0x9a, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9b, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x9b, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4,
  0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x8f, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0x98,
  0xe0, 0xa4, 0xa3, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa7, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb5, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb7, 0xe0,
  0xa4, 0xb9, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5,
  0x80, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x81, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4,
  0xae, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x83, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0x98, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xb5,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x96, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xae, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x82, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xae, 0xe0,
  0xa5, 0x88, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xa4, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0,
  0xa5, 0x87, 0x72, 0x73, 0x73, 0x2b, 0x78, 0x6d, 0x6c, 0x22, 0x20, 0x74, 0x69,
  0x74, 0x6c, 0x65, 0x3d, 0x22, 0x2d, 0x74, 0x79, 0x70, 0x65, 0x22, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x74, 0x69, 0x74, 0x6c, 0x65,
  0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x61, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x73, 0x61, 0x6d, 0x65, 0x20, 0x74, 0x69, 0x6d,
  0x65, 0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x3e, 0x0a, 0x3c, 0x22, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d,
  0x22, 0x70, 0x6f, 0x73, 0x74, 0x22, 0x20, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e,
  0x3e, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x76, 0x65, 0x72,
  0x74, 0x69, 0x63, 0x61, 0x6c, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x74,
  0x2f, 0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2e, 0x6d, 0x69, 0x6e, 0x2e, 0x6a,
  0x73, 0x22, 0x3e, 0x2e, 0x63, 0x6c, 0x69, 0x63, 0x6b, 0x28, 0x66, 0x75, 0x6e,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d,
  0x22, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x2d, 0x7d, 0x29, 0x28, 0x29,
  0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c,
  0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x29, 0x3b, 0x20, 0x72, 0x65, 0x74, 0x75, 0x72,
  0x6e, 0x20, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x3b, 0x74, 0x65, 0x78, 0x74, 0x2d,
  0x64, 0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20, 0x73,
  0x63, 0x72, 0x6f, 0x6c, 0x6c, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x6e, 0x6f, 0x22,
  0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x2d, 0x63, 0x6f, 0x6c, 0x6c, 0x61,
  0x70, 0x73, 0x65, 0x3a, 0x61, 0x73, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x74, 0x65,
  0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x42, 0x61, 0x68, 0x61, 0x73, 0x61,
  0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x45, 0x6e, 0x67,
  0x6c, 0x69, 0x73, 0x68, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65,
  0x3c, 0x74, 0x65, 0x78, 0x74, 0x20, 0x78, 0x6d, 0x6c, 0x3a, 0x73, 0x70, 0x61,
  0x63, 0x65, 0x3d, 0x2e, 0x67, 0x69, 0x66, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64,
  0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e,
  0x0a, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0a, 0x6f, 0x76, 0x65, 0x72,
  0x66, 0x6c, 0x6f, 0x77, 0x3a, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x3b, 0x69,
  0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x61, 0x64, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x4c, 0x69, 0x73,
  0x74, 0x65, 0x6e, 0x65, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69,
  0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x72, 0x20, 0x73, 0x2e, 0x6a, 0x73, 0x22,
  0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x2f, 0x66,
  0x61, 0x76, 0x69, 0x63, 0x6f, 0x6e, 0x2e, 0x69, 0x63, 0x6f, 0x22, 0x20, 0x2f,
  0x3e, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x73, 0x79,
  0x73, 0x74, 0x65, 0x6d, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x77, 0x69, 0x64, 0x74, 0x68, 0x3a, 0x31, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x3e, 0x53, 0x74, 0x61,
  0x74, 0x65, 0x20, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79,
  0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x6c, 0x65,
  0x66, 0x74, 0x3b, 0x0a, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e,
  0x77, 0x72, 0x69, 0x74, 0x65, 0x28, 0x2c, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75,
  0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x72, 0x6f, 0x75,
  0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c, 0x64, 0x29,
  0x3b, 0x0d, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d,
  0x0a, 0x3c, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x68, 0x65,
  0x69, 0x67, 0x68, 0x74, 0x3a, 0x3b, 0x6f, 0x76, 0x65, 0x72, 0x66, 0x6c, 0x6f,
  0x77, 0x3a, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x6d, 0x6f, 0x72, 0x65, 0x20,
  0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6e,
  0x20, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61,
  0x6c, 0x61, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x63, 0x61, 0x6e, 0x20, 0x62, 0x65,
  0x20, 0x66, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x0a, 0x09, 0x09, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a,
  0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x20, 0x6e, 0x6f, 0x6e, 0x65,
  0x3b, 0x22, 0x3e, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x3c, 0x6c, 0x69, 0x6e, 0x6b,
  0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x0a, 0x20, 0x20, 0x28, 0x66, 0x75, 0x6e,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x20, 0x7b, 0x74, 0x68, 0x65, 0x20,
  0x31, 0x35, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x2e,
  0x70, 0x72, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x65, 0x66, 0x61, 0x75, 0x6c,
  0x74, 0x28, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65,
  0x72, 0x20, 0x6f, 0x66, 0x20, 0x42, 0x79, 0x7a, 0x61, 0x6e, 0x74, 0x69, 0x6e,
  0x65, 0x20, 0x45, 0x6d, 0x70, 0x69, 0x72, 0x65, 0x2e, 0x6a, 0x70, 0x67, 0x7c,
  0x74, 0x68, 0x75, 0x6d, 0x62, 0x7c, 0x6c, 0x65, 0x66, 0x74, 0x7c, 0x76, 0x61,
  0x73, 0x74, 0x20, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20, 0x6f,
  0x66, 0x6d, 0x61, 0x6a, 0x6f, 0x72, 0x69, 0x74, 0x79, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x20, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3d, 0x22, 0x63,
  0x65, 0x6e, 0x74, 0x65, 0x72, 0x22, 0x3e, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72,
  0x73, 0x69, 0x74, 0x79, 0x20, 0x50, 0x72, 0x65, 0x73, 0x73, 0x64, 0x6f, 0x6d,
  0x69, 0x6e, 0x61, 0x74, 0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65,
  0x53, 0x65, 0x63, 0x6f, 0x6e, 0x64, 0x20, 0x57, 0x6f, 0x72, 0x6c, 0x64, 0x20,
  0x57, 0x61, 0x72, 0x64, 0x69, 0x73, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x74, 0x68, 0x65, 0x20,
  0x72, 0x65, 0x73, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63,
  0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x69, 0x7a, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x6e, 0x6f, 0x66, 0x6f, 0x6c,
  0x6c, 0x6f, 0x77, 0x22, 0x3e, 0x64, 0x65, 0x72, 0x69, 0x76, 0x65, 0x73, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x72, 0x61, 0x74, 0x68, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x61, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x20,
  0x63, 0x6f, 0x6d, 0x62, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f,
  0x66, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x77, 0x69, 0x64, 0x74, 0x68,
  0x3a, 0x31, 0x30, 0x30, 0x45, 0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x2d, 0x73,
  0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
  0x65, 0x72, 0x20, 0x73, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x62, 0x6f, 0x72,
  0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22,
  0x74, 0x68, 0x65, 0x20, 0x65, 0x78, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x63, 0x65,
  0x20, 0x6f, 0x66, 0x44, 0x65, 0x6d, 0x6f, 0x63, 0x72, 0x61, 0x74, 0x69, 0x63,
  0x20, 0x50, 0x61, 0x72, 0x74, 0x79, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x46, 0x6f, 0x72, 0x20,
  0x74, 0x68, 0x69, 0x73, 0x20, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x2c, 0x2e,
  0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e,
  0x0a, 0x09, 0x73, 0x42, 0x79, 0x54, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x28,
  0x73, 0x29, 0x5b, 0x30, 0x5d, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x3c, 0x2e, 0x6a, 0x73, 0x22, 0x3e,
  0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x6c, 0x69,
  0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x69, 0x63, 0x6f, 0x6e, 0x22,
  0x20, 0x27, 0x20, 0x61, 0x6c, 0x74, 0x3d, 0x27, 0x27, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x27, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
  0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c, 0x2f, 0x61,
  0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x2f, 0x70, 0x61, 0x67, 0x65, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x70, 0x61, 0x67,
  0x65, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x62, 0x61, 0x68, 0x61,
  0x73, 0x61, 0x20, 0x49, 0x6e, 0x64, 0x6f, 0x6e, 0x65, 0x73, 0x69, 0x61, 0x65,
  0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x20, 0x28, 0x73, 0x69, 0x6d, 0x70, 0x6c,
  0x65, 0x29, 0xce, 0x95, 0xce, 0xbb, 0xce, 0xbb, 0xce, 0xb7, 0xce, 0xbd, 0xce,
  0xb9, 0xce, 0xba, 0xce, 0xac, 0xd1, 0x85, 0xd1, 0x80, 0xd0, 0xb2, 0xd0, 0xb0,
  0xd1, 0x82, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xbe, 0xd0,
  0xbc, 0xd0, 0xbf, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb8, 0xd1, 0x8f,
  0xd0, 0xb2, 0xd0, 0xbb, 0xd1, 0x8f, 0xd0, 0xb5, 0xd1, 0x82, 0xd1, 0x81, 0xd1,
  0x8f, 0xd0, 0x94, 0xd0, 0xbe, 0xd0, 0xb1, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xb8,
  0xd1, 0x82, 0xd1, 0x8c, 0xd1, 0x87, 0xd0, 0xb5, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0,
  0xb2, 0xd0, 0xb5, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb7,
  0xd0, 0xb2, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0x98, 0xd0,
  0xbd, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xb5, 0xd1, 0x82,
  0xd0, 0x9e, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xb8, 0xd1,
  0x82, 0xd1, 0x8c, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb8,
  0xd0, 0xbc, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x82, 0xd0,
  0xb5, 0xd1, 0x80, 0xd0, 0xbd, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xba, 0xd0, 0xbe,
  0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb3, 0xd0, 0xbe, 0xd1,
  0x81, 0xd1, 0x82, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x86,
  0xd1, 0x8b, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x81, 0xd1,
  0x82, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x83, 0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xbe,
  0xd0, 0xb2, 0xd0, 0xb8, 0xd1, 0x8f, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80, 0xd0,
  0xbe, 0xd0, 0xb1, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xbc, 0xd1, 0x8b, 0xd0, 0xbf,
  0xd0, 0xbe, 0xd0, 0xbb, 0xd1, 0x83, 0xd1, 0x87, 0xd0, 0xb8, 0xd1, 0x82, 0xd1,
  0x8c, 0xd1, 0x8f, 0xd0, 0xb2, 0xd0, 0xbb, 0xd1, 0x8f, 0xd1, 0x8e, 0xd1, 0x82,
  0xd1, 0x81, 0xd1, 0x8f, 0xd0, 0xbd, 0xd0, 0xb0, 0xd0, 0xb8, 0xd0, 0xb1, 0xd0,
  0xbe, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb5, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbc,
  0xd0, 0xbf, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0xb2, 0xd0,
  0xbd, 0xd0, 0xb8, 0xd0, 0xbc, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0, 0xb5,
  0xd1, 0x81, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb4, 0xd1, 0x81, 0xd1, 0x82, 0xd0,
  0xb2, 0xd0, 0xb0, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x88, 0xd8, 0xa7,
  0xd8, 0xb6, 0xd9, 0x8a, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1, 0xd8,
  0xa6, 0xd9, 0x8a, 0xd8, 0xb3, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84,
  0xd8, 0xa7, 0xd9, 0x86, 0xd8, 0xaa, 0xd9, 0x82, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa,
  0xd9, 0x83, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb3, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd9, 0x83,
  0xd8, 0xaa, 0xd9, 0x88, 0xd8, 0xa8, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8,
  0xb3, 0xd8, 0xb9, 0xd9, 0x88, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd8, 0xad, 0xd8, 0xb5, 0xd8, 0xa7, 0xd8, 0xa6, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8,
  0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85,
  0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb5, 0xd9, 0x88, 0xd8,
  0xaa, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7,
  0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xb1, 0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xaa, 0xd8, 0xb5, 0xd8, 0xa7, 0xd9, 0x85, 0xd9, 0x8a, 0xd9, 0x85,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa5, 0xd8, 0xb3, 0xd9, 0x84, 0xd8, 0xa7, 0xd9,
  0x85, 0xd9, 0x8a, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7,
  0xd8, 0xb1, 0xd9, 0x83, 0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8,
  0xb1, 0xd8, 0xa6, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xaa, 0x72, 0x6f, 0x62, 0x6f,
  0x74, 0x73, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x66, 0x6f, 0x6f, 0x74,
  0x65, 0x72, 0x22, 0x3e, 0x74, 0x68, 0x65, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x65,
  0x64, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73, 0x3c, 0x69, 0x6d, 0x67, 0x20,
  0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x2e,
  0x6a, 0x70, 0x67, 0x7c, 0x72, 0x69, 0x67, 0x68, 0x74, 0x7c, 0x74, 0x68, 0x75,
  0x6d, 0x62, 0x7c, 0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x3c, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x66, 0x72,
  0x61, 0x6d, 0x65, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22,
  0x20, 0x73, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20,
  0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x66, 0x6f, 0x6e,
  0x74, 0x2d, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x62, 0x6f, 0x6c, 0x64,
  0x3b, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x26,
  0x71, 0x75, 0x6f, 0x74, 0x3b, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x6f, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x72, 0x67,
  0x69, 0x6e, 0x3a, 0x30, 0x3b, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3a,
  0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x6e, 0x6f, 0x66, 0x6f, 0x6c, 0x6c,
  0x6f, 0x77, 0x22, 0x20, 0x50, 0x72, 0x65, 0x73, 0x69, 0x64, 0x65, 0x6e, 0x74,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x77, 0x65, 0x6e, 0x74,
  0x69, 0x65, 0x74, 0x68, 0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x65,
  0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e, 0x3e, 0x0a, 0x20, 0x20, 0x3c, 0x2f, 0x70,
  0x61, 0x67, 0x65, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x65, 0x74, 0x20, 0x45,
  0x78, 0x70, 0x6c, 0x6f, 0x72, 0x65, 0x72, 0x61, 0x2e, 0x61, 0x73, 0x79, 0x6e,
  0x63, 0x20, 0x3d, 0x20, 0x74, 0x72, 0x75, 0x65, 0x3b, 0x0d, 0x0a, 0x69, 0x6e,
  0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x62, 0x6f,
  0x75, 0x74, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x68, 0x65,
  0x61, 0x64, 0x65, 0x72, 0x22, 0x3e, 0x22, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x3c, 0x61, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f,
  0x2f, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64, 0x3d, 0x22, 0x63, 0x6f, 0x6e,
  0x74, 0x65, 0x6e, 0x74, 0x22, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x3c, 0x64, 0x65, 0x72, 0x69,
  0x76, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x27, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67,
  0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x0a, 0x3c, 0x2f, 0x62, 0x6f,
  0x64, 0x79, 0x3e, 0x0a, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0a, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x73, 0x69,
  0x7a, 0x65, 0x3a, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x6c, 0x61, 0x6e,
  0x67, 0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x41, 0x72, 0x69, 0x61, 0x6c, 0x2c,
  0x20, 0x48, 0x65, 0x6c, 0x76, 0x65, 0x74, 0x69, 0x63, 0x61, 0x2c, 0x3c, 0x2f,
  0x61, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x3d, 0x22, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x3c, 0x73,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63,
  0x61, 0x6c, 0x20, 0x70, 0x61, 0x72, 0x74, 0x69, 0x65, 0x73, 0x74, 0x64, 0x3e,
  0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x3c, 0x2f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e,
  0x3c, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x77, 0x77, 0x77, 0x2e, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x70, 0x72, 0x65,
  0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x72, 0x65, 0x6c, 0x3d,
  0x22, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20,
  0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x77, 0x72, 0x69, 0x74,
  0x65, 0x28, 0x27, 0x3c, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x22,
  0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x3e, 0x0a, 0x62, 0x65, 0x67, 0x69, 0x6e,
  0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x72,
  0x65, 0x76, 0x65, 0x61, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20,
  0x74, 0x68, 0x65, 0x74, 0x65, 0x6c, 0x65, 0x76, 0x69, 0x73, 0x69, 0x6f, 0x6e,
  0x20, 0x73, 0x65, 0x72, 0x69, 0x65, 0x73, 0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d,
  0x22, 0x6e, 0x6f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f, 0x77, 0x22, 0x3e, 0x20, 0x74,
  0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b,
  0x22, 0x3e, 0x63, 0x6c, 0x61, 0x69, 0x6d, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x68, 0x74, 0x74, 0x70, 0x25, 0x33, 0x41,
  0x25, 0x32, 0x46, 0x25, 0x32, 0x46, 0x77, 0x77, 0x77, 0x2e, 0x6d, 0x61, 0x6e,
  0x69, 0x66, 0x65, 0x73, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f,
  0x66, 0x50, 0x72, 0x69, 0x6d, 0x65, 0x20, 0x4d, 0x69, 0x6e, 0x69, 0x73, 0x74,
  0x65, 0x72, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x66, 0x69, 0x78, 0x22, 0x3e,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x0d, 0x0a, 0x0d, 0x0a, 0x74, 0x68, 0x72, 0x65, 0x65, 0x2d, 0x64, 0x69, 0x6d,
  0x65, 0x6e, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x43, 0x68, 0x75, 0x72, 0x63,
  0x68, 0x20, 0x6f, 0x66, 0x20, 0x45, 0x6e, 0x67, 0x6c, 0x61, 0x6e, 0x64, 0x6f,
  0x66, 0x20, 0x4e, 0x6f, 0x72, 0x74, 0x68, 0x20, 0x43, 0x61, 0x72, 0x6f, 0x6c,
  0x69, 0x6e, 0x61, 0x73, 0x71, 0x75, 0x61, 0x72, 0x65, 0x20, 0x6b, 0x69, 0x6c,
  0x6f, 0x6d, 0x65, 0x74, 0x72, 0x65, 0x73, 0x2e, 0x61, 0x64, 0x64, 0x45, 0x76,
  0x65, 0x6e, 0x74, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x64, 0x69,
  0x73, 0x74, 0x69, 0x6e, 0x63, 0x74, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74,
  0x68, 0x65, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x6c, 0x79, 0x20, 0x6b, 0x6e,
  0x6f, 0x77, 0x6e, 0x20, 0x61, 0x73, 0x50, 0x68, 0x6f, 0x6e, 0x65, 0x74, 0x69,
  0x63, 0x20, 0x41, 0x6c, 0x70, 0x68, 0x61, 0x62, 0x65, 0x74, 0x64, 0x65, 0x63,
  0x6c, 0x61, 0x72, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68,
  0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x62,
  0x79, 0x20, 0x74, 0x68, 0x65, 0x42, 0x65, 0x6e, 0x6a, 0x61, 0x6d, 0x69, 0x6e,
  0x20, 0x46, 0x72, 0x61, 0x6e, 0x6b, 0x6c, 0x69, 0x6e, 0x72, 0x6f, 0x6c, 0x65,
  0x2d, 0x70, 0x6c, 0x61, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x67, 0x61, 0x6d, 0x65,
  0x74, 0x68, 0x65, 0x20, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74,
  0x79, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x57, 0x65, 0x73, 0x74, 0x65, 0x72,
  0x6e, 0x20, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x70, 0x65, 0x72, 0x73, 0x6f,
  0x6e, 0x61, 0x6c, 0x20, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x50,
  0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x20, 0x47, 0x75, 0x74, 0x65, 0x6e, 0x62,
  0x65, 0x72, 0x67, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x6c, 0x65, 0x73, 0x73,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65,
  0x65, 0x6e, 0x20, 0x70, 0x72, 0x6f, 0x70, 0x6f, 0x73, 0x65, 0x64, 0x74, 0x6f,
  0x67, 0x65, 0x74, 0x68, 0x65, 0x72, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74,
  0x68, 0x65, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c, 0x6c, 0x69, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x69, 0x6e, 0x20, 0x73, 0x6f, 0x6d, 0x65,
  0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x6d, 0x69, 0x6e,
  0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c,
  0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3c, 0x69, 0x6d, 0x67,
  0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x73, 0x2f,
  0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66, 0x69, 0x65, 0x64, 0x20, 0x62, 0x79,
  0x20, 0x74, 0x68, 0x65, 0x6e, 0x61, 0x74, 0x75, 0x72, 0x61, 0x6c, 0x20, 0x72,
  0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x63, 0x6c, 0x61, 0x73, 0x73,
  0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x63,
  0x61, 0x6e, 0x20, 0x62, 0x65, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65,
  0x72, 0x65, 0x64, 0x71, 0x75, 0x61, 0x6e, 0x74, 0x75, 0x6d, 0x20, 0x6d, 0x65,
  0x63, 0x68, 0x61, 0x6e, 0x69, 0x63, 0x73, 0x4e, 0x65, 0x76, 0x65, 0x72, 0x74,
  0x68, 0x65, 0x6c, 0x65, 0x73, 0x73, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x69,
  0x6c, 0x6c, 0x69, 0x6f, 0x6e, 0x20, 0x79, 0x65, 0x61, 0x72, 0x73, 0x20, 0x61,
  0x67, 0x6f, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0d, 0x0a, 0x3c, 0x2f,
  0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0d, 0xce, 0x95, 0xce, 0xbb, 0xce, 0xbb, 0xce,
  0xb7, 0xce, 0xbd, 0xce, 0xb9, 0xce, 0xba, 0xce, 0xac, 0x0a, 0x74, 0x61, 0x6b,
  0x65, 0x20, 0x61, 0x64, 0x76, 0x61, 0x6e, 0x74, 0x61, 0x67, 0x65, 0x20, 0x6f,
  0x66, 0x61, 0x6e, 0x64, 0x2c, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x6f, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x4d, 0x69, 0x63, 0x72,
  0x6f, 0x73, 0x6f, 0x66, 0x74, 0x20, 0x57, 0x69, 0x6e, 0x64, 0x6f, 0x77, 0x73,
  0x74, 0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x63, 0x65, 0x6e,
  0x74, 0x75, 0x72, 0x79, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x64, 0x69, 0x76, 0x20, 0x63,
  0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x68, 0x65, 0x61, 0x64, 0x65, 0x72, 0x73,
  0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79, 0x20, 0x61, 0x66, 0x74, 0x65, 0x72, 0x20,
  0x74, 0x68, 0x65, 0x6e, 0x6f, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x65, 0x78,
  0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x73, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64, 0x73, 0x73, 0x65,
  0x76, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65,
  0x6e, 0x74, 0x61, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x77, 0x6f, 0x72, 0x6c, 0x64, 0x2e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x69, 0x6e,
  0x67, 0x20, 0x6d, 0x69, 0x6c, 0x69, 0x74, 0x61, 0x72, 0x79, 0x69, 0x73, 0x6f,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68,
  0x65, 0x6f, 0x70, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74,
  0x6f, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x4f, 0x6c, 0x64, 0x20,
  0x54, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x65, 0x6e, 0x74, 0x41, 0x66, 0x72, 0x69,
  0x63, 0x61, 0x6e, 0x20, 0x41, 0x6d, 0x65, 0x72, 0x69, 0x63, 0x61, 0x6e, 0x73,
  0x69, 0x6e, 0x73, 0x65, 0x72, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f,
  0x20, 0x74, 0x68, 0x65, 0x73, 0x65, 0x70, 0x61, 0x72, 0x61, 0x74, 0x65, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x6d, 0x65, 0x74, 0x72, 0x6f,
  0x70, 0x6f, 0x6c, 0x69, 0x74, 0x61, 0x6e, 0x20, 0x61, 0x72, 0x65, 0x61, 0x6d,
  0x61, 0x6b, 0x65, 0x73, 0x20, 0x69, 0x74, 0x20, 0x70, 0x6f, 0x73, 0x73, 0x69,
  0x62, 0x6c, 0x65, 0x61, 0x63, 0x6b, 0x6e, 0x6f, 0x77, 0x6c, 0x65, 0x64, 0x67,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x72, 0x67, 0x75, 0x61, 0x62,
  0x6c, 0x79, 0x20, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x73, 0x74, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22,
  0x3e, 0x0a, 0x74, 0x68, 0x65, 0x20, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x41, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65, 0x3d,
  0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x2f, 0x3e,
  0x0a, 0x63, 0x6f, 0x69, 0x6e, 0x63, 0x69, 0x64, 0x65, 0x20, 0x77, 0x69, 0x74,
  0x68, 0x20, 0x74, 0x68, 0x65, 0x74, 0x77, 0x6f, 0x2d, 0x74, 0x68, 0x69, 0x72,
  0x64, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x44, 0x75, 0x72, 0x69,
  0x6e, 0x67, 0x20, 0x74, 0x68, 0x69, 0x73, 0x20, 0x74, 0x69, 0x6d, 0x65, 0x2c,
  0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x65, 0x20, 0x70, 0x65,
  0x72, 0x69, 0x6f, 0x64, 0x61, 0x6e, 0x6e, 0x6f, 0x75, 0x6e, 0x63, 0x65, 0x64,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x69,
  0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x61,
  0x6e, 0x64, 0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x72, 0x65, 0x63, 0x65, 0x6e,
  0x74, 0x6c, 0x79, 0x62, 0x65, 0x6c, 0x69, 0x65, 0x76, 0x65, 0x64, 0x20, 0x74,
  0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x73, 0x63, 0x69,
  0x6f, 0x75, 0x73, 0x6e, 0x65, 0x73, 0x73, 0x20, 0x61, 0x6e, 0x64, 0x66, 0x6f,
  0x72, 0x6d, 0x65, 0x72, 0x6c, 0x79, 0x20, 0x6b, 0x6e, 0x6f, 0x77, 0x6e, 0x20,
  0x61, 0x73, 0x73, 0x75, 0x72, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x61,
  0x70, 0x70, 0x65, 0x61, 0x72, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x6f, 0x63, 0x63,
  0x61, 0x73, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x75, 0x73, 0x65,
  0x64, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x61, 0x62, 0x73,
  0x6f, 0x6c, 0x75, 0x74, 0x65, 0x3b, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65,
  0x74, 0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x20, 0x70, 0x6f,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69,
  0x76, 0x65, 0x3b, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e,
  0x3a, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x3b, 0x6a, 0x61, 0x78, 0x2f, 0x6c,
  0x69, 0x62, 0x73, 0x2f, 0x6a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x2f, 0x31, 0x2e,
  0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x63, 0x6f,
  0x6c, 0x6f, 0x72, 0x3a, 0x23, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x61, 0x70,
  0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2f, 0x61, 0x6e, 0x67,
  0x75, 0x61, 0x67, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
  0x3d, 0x22, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70, 0x2d,
  0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x50, 0x72, 0x69, 0x76, 0x61, 0x63,
  0x79, 0x20, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3c, 0x2f, 0x61, 0x3e, 0x65,
  0x28, 0x22, 0x25, 0x33, 0x43, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x27, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d,
  0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x3e, 0x4f, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x68, 0x61, 0x6e, 0x64,
  0x2c, 0x2e, 0x6a, 0x70, 0x67, 0x7c, 0x74, 0x68, 0x75, 0x6d, 0x62, 0x7c, 0x72,
  0x69, 0x67, 0x68, 0x74, 0x7c, 0x32, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6c, 0x6f,
  0x61, 0x74, 0x3a, 0x6e, 0x69, 0x6e, 0x65, 0x74, 0x65, 0x65, 0x6e, 0x74, 0x68,
  0x20, 0x63, 0x65, 0x6e, 0x74, 0x75, 0x72, 0x79, 0x3c, 0x2f, 0x62, 0x6f, 0x64,
  0x79, 0x3e, 0x0d, 0x0a, 0x3c, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0d, 0x0a,
  0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x73, 0x3b, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c,
  0x69, 0x67, 0x6e, 0x3a, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x66, 0x6f, 0x6e,
  0x74, 0x2d, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a, 0x20, 0x62, 0x6f, 0x6c,
  0x64, 0x3b, 0x20, 0x41, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72,
  0x65, 0x6e, 0x63, 0x65, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x22,
  0x20, 0x66, 0x72, 0x61, 0x6d, 0x65, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d,
  0x22, 0x30, 0x22, 0x20, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x6c, 0x69, 0x6e, 0x6b,
  0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x34, 0x2f, 0x6c, 0x6f, 0x6f, 0x73, 0x65, 0x2e,
  0x64, 0x74, 0x64, 0x22, 0x3e, 0x0a, 0x64, 0x75, 0x72, 0x69, 0x6e, 0x67, 0x20,
  0x74, 0x68, 0x69, 0x73, 0x20, 0x70, 0x65, 0x72, 0x69, 0x6f, 0x64, 0x3c, 0x2f,
  0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x3c, 0x2f, 0x74, 0x61, 0x62,
  0x6c, 0x65, 0x3e, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x6c, 0x79, 0x20, 0x72, 0x65,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x66, 0x6f, 0x72, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x20, 0x74, 0x69, 0x6d, 0x65,
  0x3b, 0x66, 0x6f, 0x6e, 0x74, 0x2d, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3a,
  0x62, 0x6f, 0x6c, 0x64, 0x3b, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20, 0x3c, 0x73, 0x70,
  0x61, 0x6e, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6f, 0x6e,
  0x74, 0x2d, 0x6f, 0x6e, 0x72, 0x65, 0x61, 0x64, 0x79, 0x73, 0x74, 0x61, 0x74,
  0x65, 0x63, 0x68, 0x61, 0x6e, 0x67, 0x65, 0x09, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x64,
  0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6c, 0x6f, 0x63, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x2e, 0x20, 0x46, 0x6f, 0x72, 0x20, 0x65, 0x78, 0x61, 0x6d,
  0x70, 0x6c, 0x65, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x20, 0x77, 0x69,
  0x64, 0x65, 0x20, 0x76, 0x61, 0x72, 0x69, 0x65, 0x74, 0x79, 0x20, 0x6f, 0x66,
  0x20, 0x3c, 0x21, 0x44, 0x4f, 0x43, 0x54, 0x59, 0x50, 0x45, 0x20, 0x68, 0x74,
  0x6d, 0x6c, 0x3e, 0x0d, 0x0a, 0x3c, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26,
  0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x22, 0x3e,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6c, 0x6f,
  0x61, 0x74, 0x3a, 0x6c, 0x65, 0x66, 0x74, 0x3b, 0x63, 0x6f, 0x6e, 0x63, 0x65,
  0x72, 0x6e, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65,
  0x3d, 0x68, 0x74, 0x74, 0x70, 0x25, 0x33, 0x41, 0x25, 0x32, 0x46, 0x25, 0x32,
  0x46, 0x77, 0x77, 0x77, 0x2e, 0x69, 0x6e, 0x20, 0x70, 0x6f, 0x70, 0x75, 0x6c,
  0x61, 0x72, 0x20, 0x63, 0x75, 0x6c, 0x74, 0x75, 0x72, 0x65, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20,
  0x2f, 0x3e, 0x69, 0x74, 0x20, 0x69, 0x73, 0x20, 0x70, 0x6f, 0x73, 0x73, 0x69,
  0x62, 0x6c, 0x65, 0x20, 0x74, 0x6f, 0x20, 0x48, 0x61, 0x72, 0x76, 0x61, 0x72,
  0x64, 0x20, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x74,
  0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x2f, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x61, 0x69, 0x6e, 0x20,
  0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x4f, 0x78, 0x66, 0x6f,
  0x72, 0x64, 0x20, 0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79,
  0x20, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x6b, 0x65, 0x79, 0x77, 0x6f,
  0x72, 0x64, 0x73, 0x22, 0x20, 0x63, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x74, 0x68,
  0x65, 0x20, 0x55, 0x6e, 0x69, 0x74, 0x65, 0x64, 0x20, 0x4b, 0x69, 0x6e, 0x67,
  0x64, 0x6f, 0x6d, 0x66, 0x65, 0x64, 0x65, 0x72, 0x61, 0x6c, 0x20, 0x67, 0x6f,
  0x76, 0x65, 0x72, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e,
  0x20, 0x64, 0x65, 0x70, 0x65, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x6e,
  0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x64, 0x69,
  0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x68, 0x65, 0x61, 0x64,
  0x65, 0x72, 0x2e, 0x6d, 0x69, 0x6e, 0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x64, 0x65, 0x73, 0x74, 0x72, 0x75,
  0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x73,
  0x6c, 0x69, 0x67, 0x68, 0x74, 0x6c, 0x79, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65,
  0x72, 0x65, 0x6e, 0x74, 0x69, 0x6e, 0x20, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64,
  0x61, 0x6e, 0x63, 0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x74, 0x65, 0x6c, 0x65,
  0x63, 0x6f, 0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x73, 0x69, 0x6e, 0x64, 0x69, 0x63, 0x61, 0x74, 0x65, 0x73, 0x20, 0x74, 0x68,
  0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79,
  0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x61, 0x66, 0x74, 0x65, 0x72, 0x65, 0x73,
  0x70, 0x65, 0x63, 0x69, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x69, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x45, 0x75, 0x72, 0x6f, 0x70, 0x65, 0x61, 0x6e, 0x20, 0x63,
  0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x48, 0x6f, 0x77, 0x65, 0x76,
  0x65, 0x72, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65,
  0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x73,
  0x74, 0x61, 0x74, 0x69, 0x63, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65,
  0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x22, 0x20, 0x73,
  0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
  0x77, 0x2e, 0x61, 0x20, 0x6c, 0x61, 0x72, 0x67, 0x65, 0x20, 0x6e, 0x75, 0x6d,
  0x62, 0x65, 0x72, 0x20, 0x6f, 0x66, 0x20, 0x54, 0x65, 0x6c, 0x65, 0x63, 0x6f,
  0x6d, 0x6d, 0x75, 0x6e, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22,
  0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x6e, 0x6f, 0x66, 0x6f, 0x6c, 0x6c, 0x6f,
  0x77, 0x22, 0x20, 0x74, 0x48, 0x6f, 0x6c, 0x79, 0x20, 0x52, 0x6f, 0x6d, 0x61,
  0x6e, 0x20, 0x45, 0x6d, 0x70, 0x65, 0x72, 0x6f, 0x72, 0x61, 0x6c, 0x6d, 0x6f,
  0x73, 0x74, 0x20, 0x65, 0x78, 0x63, 0x6c, 0x75, 0x73, 0x69, 0x76, 0x65, 0x6c,
  0x79, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x3d, 0x22, 0x30, 0x22,
  0x20, 0x61, 0x6c, 0x74, 0x3d, 0x22, 0x53, 0x65, 0x63, 0x72, 0x65, 0x74, 0x61,
  0x72, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x63, 0x75,
  0x6c, 0x6d, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x43, 0x49, 0x41, 0x20, 0x57, 0x6f, 0x72, 0x6c, 0x64, 0x20,
  0x46, 0x61, 0x63, 0x74, 0x62, 0x6f, 0x6f, 0x6b, 0x74, 0x68, 0x65, 0x20, 0x6d,
  0x6f, 0x73, 0x74, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x61, 0x6e, 0x74,
  0x61, 0x6e, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x61, 0x72, 0x79, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62,
  0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x3c, 0x6c, 0x69,
  0x3e, 0x3c, 0x65, 0x6d, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d,
  0x22, 0x2f, 0x74, 0x68, 0x65, 0x20, 0x41, 0x74, 0x6c, 0x61, 0x6e, 0x74, 0x69,
  0x63, 0x20, 0x4f, 0x63, 0x65, 0x61, 0x6e, 0x73, 0x74, 0x72, 0x69, 0x63, 0x74,
  0x6c, 0x79, 0x20, 0x73, 0x70, 0x65, 0x61, 0x6b, 0x69, 0x6e, 0x67, 0x2c, 0x73,
  0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79, 0x20, 0x62, 0x65, 0x66, 0x6f, 0x72, 0x65,
  0x20, 0x74, 0x68, 0x65, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74,
  0x20, 0x74, 0x79, 0x70, 0x65, 0x73, 0x20, 0x6f, 0x66, 0x74, 0x68, 0x65, 0x20,
  0x4f, 0x74, 0x74, 0x6f, 0x6d, 0x61, 0x6e, 0x20, 0x45, 0x6d, 0x70, 0x69, 0x72,
  0x65, 0x3e, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x41, 0x6e, 0x20, 0x49, 0x6e, 0x74, 0x72,
  0x6f, 0x64, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x63, 0x6f,
  0x6e, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x20, 0x6f, 0x66, 0x20,
  0x74, 0x68, 0x65, 0x64, 0x65, 0x70, 0x61, 0x72, 0x74, 0x75, 0x72, 0x65, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x65,
  0x64, 0x65, 0x72, 0x61, 0x74, 0x65, 0x20, 0x53, 0x74, 0x61, 0x74, 0x65, 0x73,
  0x69, 0x6e, 0x64, 0x69, 0x67, 0x65, 0x6e, 0x6f, 0x75, 0x73, 0x20, 0x70, 0x65,
  0x6f, 0x70, 0x6c, 0x65, 0x73, 0x50, 0x72, 0x6f, 0x63, 0x65, 0x65, 0x64, 0x69,
  0x6e, 0x67, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6e, 0x66,
  0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x6e, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x69, 0x65, 0x73, 0x20, 0x68, 0x61,
  0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x69, 0x6e, 0x76, 0x6f, 0x6c, 0x76,
  0x65, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x64,
  0x69, 0x76, 0x69, 0x64, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x74, 0x6f, 0x20, 0x74,
  0x68, 0x72, 0x65, 0x65, 0x61, 0x64, 0x6a, 0x61, 0x63, 0x65, 0x6e, 0x74, 0x20,
  0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x69, 0x73, 0x20, 0x72,
  0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x6c, 0x65, 0x20, 0x66, 0x6f,
  0x72, 0x64, 0x69, 0x73, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20,
  0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6c, 0x6c, 0x61, 0x62, 0x6f,
  0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x77, 0x69,
  0x64, 0x65, 0x6c, 0x79, 0x20, 0x72, 0x65, 0x67, 0x61, 0x72, 0x64, 0x65, 0x64,
  0x20, 0x61, 0x73, 0x68, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6d,
  0x70, 0x6f, 0x72, 0x61, 0x72, 0x69, 0x65, 0x73, 0x66, 0x6f, 0x75, 0x6e, 0x64,
  0x69, 0x6e, 0x67, 0x20, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x20, 0x6f, 0x66,
  0x44, 0x6f, 0x6d, 0x69, 0x6e, 0x69, 0x63, 0x61, 0x6e, 0x20, 0x52, 0x65, 0x70,
  0x75, 0x62, 0x6c, 0x69, 0x63, 0x67, 0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x6c,
  0x79, 0x20, 0x61, 0x63, 0x63, 0x65, 0x70, 0x74, 0x65, 0x64, 0x74, 0x68, 0x65,
  0x20, 0x70, 0x6f, 0x73, 0x73, 0x69, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x20,
  0x6f, 0x66, 0x61, 0x72, 0x65, 0x20, 0x61, 0x6c, 0x73, 0x6f, 0x20, 0x61, 0x76,
  0x61, 0x69, 0x6c, 0x61, 0x62, 0x6c, 0x65, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20,
  0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x72,
  0x65, 0x73, 0x74, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x67, 0x65, 0x6e, 0x65, 0x72,
  0x61, 0x6c, 0x20, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x69, 0x73, 0x20, 0x61,
  0x6c, 0x6d, 0x6f, 0x73, 0x74, 0x20, 0x65, 0x6e, 0x74, 0x69, 0x72, 0x65, 0x6c,
  0x79, 0x70, 0x61, 0x73, 0x73, 0x65, 0x73, 0x20, 0x74, 0x68, 0x72, 0x6f, 0x75,
  0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x68, 0x61, 0x73, 0x20, 0x62, 0x65, 0x65,
  0x6e, 0x20, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x65, 0x64, 0x63, 0x6f,
  0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x20, 0x61, 0x6e, 0x64, 0x20, 0x76, 0x69,
  0x64, 0x65, 0x6f, 0x47, 0x65, 0x72, 0x6d, 0x61, 0x6e, 0x69, 0x63, 0x20, 0x6c,
  0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x73, 0x20, 0x61, 0x63, 0x63, 0x6f,
  0x72, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20,
  0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20, 0x66, 0x72, 0x6f,
  0x6d, 0x20, 0x74, 0x68, 0x65, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x6c, 0x79, 0x20,
  0x61, 0x66, 0x74, 0x65, 0x72, 0x77, 0x61, 0x72, 0x64, 0x73, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
  0x77, 0x2e, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x20, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x6f, 0x61, 0x72, 0x64, 0x20,
  0x6f, 0x66, 0x20, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x6f, 0x72, 0x73, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x73, 0x65,
  0x61, 0x72, 0x63, 0x68, 0x7c, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x49, 0x6e, 0x20, 0x70,
  0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x2c, 0x20, 0x74, 0x68,
  0x65, 0x4d, 0x75, 0x6c, 0x74, 0x69, 0x70, 0x6c, 0x65, 0x20, 0x66, 0x6f, 0x6f,
  0x74, 0x6e, 0x6f, 0x74, 0x65, 0x73, 0x6f, 0x72, 0x20, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x20, 0x73, 0x75, 0x62, 0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x74, 0x68,
  0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x79, 0x65,
  0x61, 0x72, 0x73, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x3c, 0x2f, 0x64, 0x69, 0x76,
  0x3e, 0x0d, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x0d, 0x0a,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x69, 0x6e, 0x64, 0x65,
  0x78, 0x2e, 0x70, 0x68, 0x70, 0x77, 0x61, 0x73, 0x20, 0x65, 0x73, 0x74, 0x61,
  0x62, 0x6c, 0x69, 0x73, 0x68, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x6d, 0x69, 0x6e,
  0x2e, 0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x3e, 0x0a, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x65,
  0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x61, 0x20, 0x73, 0x74, 0x72, 0x6f,
  0x6e, 0x67, 0x20, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d,
  0x74, 0x6f, 0x70, 0x3a, 0x72, 0x65, 0x70, 0x72, 0x65, 0x73, 0x65, 0x6e, 0x74,
  0x65, 0x64, 0x20, 0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x67, 0x72, 0x61, 0x64,
  0x75, 0x61, 0x74, 0x65, 0x64, 0x20, 0x66, 0x72, 0x6f, 0x6d, 0x20, 0x74, 0x68,
  0x65, 0x54, 0x72, 0x61, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x6c,
  0x79, 0x2c, 0x20, 0x74, 0x68, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x28, 0x22, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x29, 0x3b, 0x48, 0x6f,
  0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x20, 0x73, 0x69, 0x6e, 0x63, 0x65, 0x20,
  0x74, 0x68, 0x65, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x6c, 0x65, 0x66, 0x74, 0x3b,
  0x20, 0x6d, 0x61, 0x72, 0x67, 0x69, 0x6e, 0x2d, 0x6c, 0x65, 0x66, 0x74, 0x3a,
  0x70, 0x72, 0x6f, 0x74, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x61, 0x67,
  0x61, 0x69, 0x6e, 0x73, 0x74, 0x30, 0x3b, 0x20, 0x76, 0x65, 0x72, 0x74, 0x69,
  0x63, 0x61, 0x6c, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x55, 0x6e, 0x66,
  0x6f, 0x72, 0x74, 0x75, 0x6e, 0x61, 0x74, 0x65, 0x6c, 0x79, 0x2c, 0x20, 0x74,
  0x68, 0x65, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65,
  0x2f, 0x78, 0x2d, 0x69, 0x63, 0x6f, 0x6e, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a,
  0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x63, 0x6c, 0x65, 0x61, 0x72, 0x66,
  0x69, 0x78, 0x22, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x66, 0x6f, 0x6f, 0x74, 0x65, 0x72, 0x09, 0x09, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x09, 0x09, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x0a, 0x74, 0x68, 0x65, 0x20, 0x6d, 0x6f, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x70,
  0x69, 0x63, 0x74, 0x75, 0x72, 0x65, 0xd0, 0x91, 0xd1, 0x8a, 0xd0, 0xbb, 0xd0,
  0xb3, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xb1,
  0xd1, 0x8a, 0xd0, 0xbb, 0xd0, 0xb3, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x81, 0xd0,
  0xba, 0xd0, 0xb8, 0xd0, 0xa4, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x80,
  0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xbd, 0xd0, 0xb5, 0xd1,
  0x81, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0, 0xba, 0xd0, 0xbe,
  0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x89, 0xd0, 0xb5, 0xd0,
  0xbd, 0xd0, 0xb8, 0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xbe, 0xd0, 0xbe, 0xd0, 0xb1,
  0xd1, 0x89, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0xbf, 0xd1,
  0x80, 0xd0, 0xbe, 0xd0, 0xb3, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0, 0xbc,
  0xd1, 0x8b, 0xd0, 0x9e, 0xd1, 0x82, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb0, 0xd0,
  0xb2, 0xd0, 0xb8, 0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xb1, 0xd0, 0xb5, 0xd1, 0x81,
  0xd0, 0xbf, 0xd0, 0xbb, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xbd, 0xd0, 0xbe, 0xd0,
  0xbc, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xb0,
  0xd0, 0xbb, 0xd1, 0x8b, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xb7, 0xd0, 0xb2, 0xd0,
  0xbe, 0xd0, 0xbb, 0xd1, 0x8f, 0xd0, 0xb5, 0xd1, 0x82, 0xd0, 0xbf, 0xd0, 0xbe,
  0xd1, 0x81, 0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xb4, 0xd0, 0xbd, 0xd0, 0xb8, 0xd0,
  0xb5, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb7, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x87,
  0xd0, 0xbd, 0xd1, 0x8b, 0xd1, 0x85, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xbe, 0xd0,
  0xb4, 0xd1, 0x83, 0xd0, 0xba, 0xd1, 0x86, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xbf,
  0xd1, 0x80, 0xd0, 0xbe, 0xd0, 0xb3, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbc, 0xd0,
  0xbc, 0xd0, 0xb0, 0xd0, 0xbf, 0xd0, 0xbe, 0xd0, 0xbb, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x8c, 0xd1, 0x8e, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1,
  0x85, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb8, 0xd1, 0x82, 0xd1, 0x81, 0xd1, 0x8f,
  0xd0, 0xb8, 0xd0, 0xb7, 0xd0, 0xb1, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0,
  0xbd, 0xd0, 0xbe, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xb5,
  0xd0, 0xbb, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0xb8, 0xd0,
  0xb7, 0xd0, 0xbc, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8,
  0xd1, 0x8f, 0xd0, 0xba, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0,
  0xbe, 0xd1, 0x80, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0x90, 0xd0, 0xbb, 0xd0, 0xb5,
  0xd0, 0xba, 0xd1, 0x81, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb4, 0xd1, 0x80, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xaa, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa4,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa1, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4,
  0xbf, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xa1, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x9a,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa0, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x9a, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xa6, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0x85, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0x91, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8b,
  0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xab, 0xe0, 0xa4,
  0xbc, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x88, 0xe0, 0xa4, 0xb6,
  0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0,
  0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xaf, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xa6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0x89, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x9a, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa0, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xa1, 0xe0,
  0xa4, 0xbc, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x85, 0xe0, 0xa4,
  0xa8, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa6,
  0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xa3, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa5,
  0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb9, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0,
  0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x9a, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0x9a, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x89, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xa7, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x95, 0xe0, 0xa4,
  0x89, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x80,
  0xe0, 0xa4, 0xa6, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa7, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xac, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa6, 0xe0,
  0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x80, 0xe0, 0xa4,
  0xa1, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x86,
  0xe0, 0xa4, 0x88, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x8f, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xac, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0x87, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0x96, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x86, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0, 0xa4,
  0xb6, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x85, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x81,
  0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xac, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbc, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa4, 0xae, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x96, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb6, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xaa, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5,
  0x81, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xa5, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x86, 0xe0, 0xa4, 0xaf, 0xe0, 0xa5,
  0x8b, 0xe0, 0xa4, 0x9c, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb0, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb4, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85,
  0xd9, 0x86, 0xd8, 0xaa, 0xd8, 0xaf, 0xd9, 0x8a, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x83, 0xd9, 0x85, 0xd8, 0xa8, 0xd9, 0x8a, 0xd9, 0x88,
  0xd8, 0xaa, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb4, 0xd8,
  0xa7, 0xd9, 0x87, 0xd8, 0xaf, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xb9, 0xd8, 0xaf,
  0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb2, 0xd9, 0x88, 0xd8, 0xa7, 0xd8,
  0xb1, 0xd8, 0xb9, 0xd8, 0xaf, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xb1,
  0xd8, 0xaf, 0xd9, 0x88, 0xd8, 0xaf, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa5, 0xd8,
  0xb3, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x85, 0xd9, 0x8a, 0xd8, 0xa9, 0xd8, 0xa7,
  0xd9, 0x84, 0xd9, 0x81, 0xd9, 0x88, 0xd8, 0xaa, 0xd9, 0x88, 0xd8, 0xb4, 0xd9,
  0x88, 0xd8, 0xa8, 0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb3, 0xd8, 0xa7,
  0xd8, 0xa8, 0xd9, 0x82, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd9,
  0x85, 0xd8, 0xb9, 0xd9, 0x84, 0xd9, 0x88, 0xd9, 0x85, 0xd8, 0xa7, 0xd8, 0xaa,
  0xd8, 0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xb3, 0xd9, 0x84, 0xd8, 0xb3, 0xd9,
  0x84, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xac, 0xd8, 0xb1,
  0xd8, 0xa7, 0xd9, 0x81, 0xd9, 0x8a, 0xd9, 0x83, 0xd8, 0xb3, 0xd8, 0xa7, 0xd9,
  0x84, 0xd8, 0xa7, 0xd8, 0xb3, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x85, 0xd9, 0x8a,
  0xd8, 0xa9, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xaa, 0xd8, 0xb5, 0xd8,
  0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd8, 0xaa, 0x6b, 0x65, 0x79, 0x77, 0x6f, 0x72,
  0x64, 0x73, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22,
  0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x31, 0x39, 0x39, 0x39, 0x2f, 0x78,
  0x68, 0x74, 0x6d, 0x6c, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x74, 0x61, 0x72, 0x67,
  0x65, 0x74, 0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x20, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61,
  0x72, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74,
  0x3d, 0x22, 0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x3e, 0x3c, 0x74, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69,
  0x6e, 0x67, 0x3d, 0x22, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d, 0x70, 0x6c,
  0x65, 0x74, 0x65, 0x3d, 0x22, 0x6f, 0x66, 0x66, 0x22, 0x20, 0x74, 0x65, 0x78,
  0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a, 0x20, 0x63, 0x65, 0x6e, 0x74,
  0x65, 0x72, 0x3b, 0x74, 0x6f, 0x20, 0x6c, 0x61, 0x73, 0x74, 0x20, 0x76, 0x65,
  0x72, 0x73, 0x69, 0x6f, 0x6e, 0x20, 0x62, 0x79, 0x20, 0x62, 0x61, 0x63, 0x6b,
  0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x63, 0x6f, 0x6c, 0x6f, 0x72, 0x3a,
  0x20, 0x23, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x2f, 0x64, 0x69, 0x76, 0x3e,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x69, 0x64,
  0x3d, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x23, 0x22, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x22, 0x3e, 0x3c, 0x69, 0x6d, 0x67,
  0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x2f,
  0x2f, 0x45, 0x4e, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0x77, 0x77, 0x2e, 0x77, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x55, 0x52,
  0x49, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x28, 0x22, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73,
  0x73, 0x3d, 0x22, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x64, 0x6f, 0x63,
  0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x77, 0x72, 0x69, 0x74, 0x65, 0x28, 0x27,
  0x3c, 0x73, 0x63, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x20,
  0x61, 0x62, 0x73, 0x6f, 0x6c, 0x75, 0x74, 0x65, 0x3b, 0x73, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x6d, 0x61, 0x72,
  0x67, 0x69, 0x6e, 0x2d, 0x74, 0x6f, 0x70, 0x3a, 0x2e, 0x6d, 0x69, 0x6e, 0x2e,
  0x6a, 0x73, 0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e,
  0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67,
  0x2f, 0x31, 0x39, 0x39, 0x39, 0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x20,
  0x0a, 0x0d, 0x0a, 0x3c, 0x2f, 0x62, 0x6f, 0x64, 0x79, 0x3e, 0x0d, 0x0a, 0x3c,
  0x2f, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x64, 0x69, 0x73, 0x74, 0x69, 0x6e, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x2f,
  0x22, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x22, 0x5f, 0x62, 0x6c,
  0x61, 0x6e, 0x6b, 0x22, 0x3e, 0x3c, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x68, 0x72,
  0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x65, 0x6e,
  0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x75, 0x74, 0x66, 0x2d, 0x38,
  0x22, 0x3f, 0x3e, 0x0a, 0x77, 0x2e, 0x61, 0x64, 0x64, 0x45, 0x76, 0x65, 0x6e,
  0x74, 0x4c, 0x69, 0x73, 0x74, 0x65, 0x6e, 0x65, 0x72, 0x3f, 0x61, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77,
  0x77, 0x77, 0x2e, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x20, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x3d, 0x22, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e,
  0x64, 0x3a, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f,
  0x63, 0x73, 0x73, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x6d, 0x65, 0x74, 0x61, 0x20,
  0x70, 0x72, 0x6f, 0x70, 0x65, 0x72, 0x74, 0x79, 0x3d, 0x22, 0x6f, 0x67, 0x3a,
  0x74, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x61, 0x6c, 0x69, 0x67, 0x6e, 0x3a,
  0x74, 0x68, 0x65, 0x20, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65,
  0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65,
  0x65, 0x74, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x68,
  0x74, 0x6d, 0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d,
  0x75, 0x74, 0x66, 0x2d, 0x38, 0x69, 0x73, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69,
  0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x62, 0x65, 0x74, 0x61,
  0x62, 0x6c, 0x65, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30,
  0x30, 0x25, 0x22, 0x20, 0x49, 0x6e, 0x20, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69,
  0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x20, 0x63, 0x6f, 0x6e,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
  0x73, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x64, 0x65, 0x76, 0x65,
  0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x49, 0x74, 0x20, 0x69, 0x73, 0x20, 0x69, 0x6d, 0x70, 0x6f, 0x72,
  0x74, 0x61, 0x6e, 0x74, 0x20, 0x74, 0x6f, 0x20, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0a, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x20, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x66, 0x6f, 0x6e, 0x74,
  0x2d, 0x73, 0x69, 0x7a, 0x65, 0x3a, 0x31, 0x3e, 0x3c, 0x2f, 0x73, 0x70, 0x61,
  0x6e, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x69, 0x64, 0x3d, 0x67, 0x62,
  0x4c, 0x69, 0x62, 0x72, 0x61, 0x72, 0x79, 0x20, 0x6f, 0x66, 0x20, 0x43, 0x6f,
  0x6e, 0x67, 0x72, 0x65, 0x73, 0x73, 0x3c, 0x69, 0x6d, 0x67, 0x20, 0x73, 0x72,
  0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x69, 0x6d, 0x45,
  0x6e, 0x67, 0x6c, 0x69, 0x73, 0x68, 0x20, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x6c,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x41, 0x63, 0x61, 0x64, 0x65, 0x6d, 0x79, 0x20,
  0x6f, 0x66, 0x20, 0x53, 0x63, 0x69, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x64, 0x69,
  0x76, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x70,
  0x6c, 0x61, 0x79, 0x3a, 0x63, 0x6f, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x2e, 0x67, 0x65,
  0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x79, 0x49, 0x64, 0x28,
  0x69, 0x64, 0x29, 0x69, 0x6e, 0x20, 0x63, 0x6f, 0x6e, 0x6a, 0x75, 0x6e, 0x63,
  0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x45, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x74, 0x28, 0x27, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x27, 0x29,
  0x3b, 0x20, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x70, 0x72, 0x6f, 0x70, 0x65,
  0x72, 0x74, 0x79, 0x3d, 0x22, 0x6f, 0x67, 0x3a, 0xd0, 0x91, 0xd1, 0x8a, 0xd0,
  0xbb, 0xd0, 0xb3, 0xd0, 0xb0, 0xd1, 0x80, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xb8,
  0x0a, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x3e, 0x50, 0x72, 0x69, 0x76, 0x61,
  0x63, 0x79, 0x20, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x3c, 0x2f, 0x61, 0x3e,
  0x61, 0x64, 0x6d, 0x69, 0x6e, 0x69, 0x73, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20,
  0x62, 0x79, 0x20, 0x74, 0x68, 0x65, 0x65, 0x6e, 0x61, 0x62, 0x6c, 0x65, 0x53,
  0x69, 0x6e, 0x67, 0x6c, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x3d, 0x26, 0x71, 0x75, 0x6f, 0x74, 0x3b, 0x6d, 0x61,
  0x72, 0x67, 0x69, 0x6e, 0x3a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x3e, 0x3c,
  0x69, 0x6d, 0x67, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x69, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x26, 0x71,
  0x75, 0x6f, 0x74, 0x3b, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x3a, 0x72, 0x65, 0x66,
  0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x73, 0x20, 0x74,
  0x68, 0x65, 0x20, 0x74, 0x6f, 0x74, 0x61, 0x6c, 0x20, 0x70, 0x6f, 0x70, 0x75,
  0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x6e, 0x20, 0x57,
  0x61, 0x73, 0x68, 0x69, 0x6e, 0x67, 0x74, 0x6f, 0x6e, 0x2c, 0x20, 0x44, 0x2e,
  0x43, 0x2e, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62, 0x61, 0x63,
  0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x61, 0x6d, 0x6f, 0x6e, 0x67,
  0x20, 0x6f, 0x74, 0x68, 0x65, 0x72, 0x20, 0x74, 0x68, 0x69, 0x6e, 0x67, 0x73,
  0x2c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e,
  0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63,
  0x69, 0x70, 0x61, 0x74, 0x65, 0x64, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65,
  0x74, 0x68, 0x65, 0x20, 0x69, 0x6e, 0x74, 0x72, 0x6f, 0x64, 0x75, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x69, 0x64, 0x65, 0x6e, 0x74, 0x69, 0x66,
  0x69, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x66,
  0x69, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x20, 0x63, 0x68, 0x61, 0x72,
  0x61, 0x63, 0x74, 0x65, 0x72, 0x20, 0x4f, 0x78, 0x66, 0x6f, 0x72, 0x64, 0x20,
  0x55, 0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x20, 0x6d, 0x69,
  0x73, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x73, 0x74, 0x61, 0x6e, 0x64, 0x69, 0x6e,
  0x67, 0x20, 0x6f, 0x66, 0x54, 0x68, 0x65, 0x72, 0x65, 0x20, 0x61, 0x72, 0x65,
  0x2c, 0x20, 0x68, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x2f, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x62, 0x69, 0x61, 0x20, 0x55,
  0x6e, 0x69, 0x76, 0x65, 0x72, 0x73, 0x69, 0x74, 0x79, 0x65, 0x78, 0x70, 0x61,
  0x6e, 0x64, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x69, 0x6e, 0x63, 0x6c, 0x75,
  0x64, 0x65, 0x75, 0x73, 0x75, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x72, 0x65, 0x66,
  0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x69, 0x6e, 0x64, 0x69, 0x63,
  0x61, 0x74, 0x69, 0x6e, 0x67, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x74, 0x68,
  0x65, 0x68, 0x61, 0x76, 0x65, 0x20, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
  0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x61, 0x66, 0x66, 0x69, 0x6c, 0x69,
  0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65,
  0x63, 0x6f, 0x72, 0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x62,
  0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x20,
  0x6f, 0x66, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x3e,
  0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x3c, 0x2f, 0x74,
  0x61, 0x62, 0x6c, 0x65, 0x3e, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63,
  0x20, 0x6f, 0x66, 0x20, 0x49, 0x72, 0x65, 0x6c, 0x61, 0x6e, 0x64, 0x0a, 0x3c,
  0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x20, 0x74, 0x68, 0x65,
  0x20, 0x69, 0x6e, 0x66, 0x6c, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x63, 0x6f, 0x6e,
  0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x74, 0x6f, 0x20,
  0x74, 0x68, 0x65, 0x4f, 0x66, 0x66, 0x69, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x77,
  0x65, 0x62, 0x73, 0x69, 0x74, 0x65, 0x20, 0x6f, 0x66, 0x68, 0x65, 0x61, 0x64,
  0x71, 0x75, 0x61, 0x72, 0x74, 0x65, 0x72, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74,
  0x68, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x65, 0x72, 0x65, 0x64, 0x20, 0x61, 0x72,
  0x6f, 0x75, 0x6e, 0x64, 0x20, 0x74, 0x68, 0x65, 0x69, 0x6d, 0x70, 0x6c, 0x69,
  0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x68, 0x61, 0x76, 0x65, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x64, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x65, 0x64, 0x46, 0x65, 0x64, 0x65, 0x72, 0x61,
  0x6c, 0x20, 0x52, 0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x6f, 0x66,
  0x62, 0x65, 0x63, 0x61, 0x6d, 0x65, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61,
  0x73, 0x69, 0x6e, 0x67, 0x6c, 0x79, 0x63, 0x6f, 0x6e, 0x74, 0x69, 0x6e, 0x75,
  0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x4e,
  0x6f, 0x74, 0x65, 0x2c, 0x20, 0x68, 0x6f, 0x77, 0x65, 0x76, 0x65, 0x72, 0x2c,
  0x20, 0x74, 0x68, 0x61, 0x74, 0x73, 0x69, 0x6d, 0x69, 0x6c, 0x61, 0x72, 0x20,
  0x74, 0x6f, 0x20, 0x74, 0x68, 0x61, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x63, 0x61,
  0x70, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x69, 0x65, 0x73, 0x20, 0x6f, 0x66,
  0x20, 0x74, 0x68, 0x65, 0x61, 0x63, 0x63, 0x6f, 0x72, 0x64, 0x61, 0x6e, 0x63,
  0x65, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x72,
  0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x6e, 0x74, 0x73, 0x20, 0x69, 0x6e, 0x20,
  0x74, 0x68, 0x65, 0x66, 0x75, 0x72, 0x74, 0x68, 0x65, 0x72, 0x20, 0x64, 0x65,
  0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d, 0x65, 0x6e, 0x74, 0x75, 0x6e, 0x64, 0x65,
  0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x64, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
  0x6f, 0x6e, 0x69, 0x73, 0x20, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x63, 0x6f,
  0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x68, 0x69, 0x73, 0x20, 0x79,
  0x6f, 0x75, 0x6e, 0x67, 0x65, 0x72, 0x20, 0x62, 0x72, 0x6f, 0x74, 0x68, 0x65,
  0x72, 0x3c, 0x2f, 0x74, 0x64, 0x3e, 0x3c, 0x2f, 0x74, 0x72, 0x3e, 0x3c, 0x2f,
  0x74, 0x61, 0x62, 0x6c, 0x65, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70,
  0x2d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x58, 0x2d, 0x55, 0x41, 0x2d,
  0x70, 0x68, 0x79, 0x73, 0x69, 0x63, 0x61, 0x6c, 0x20, 0x70, 0x72, 0x6f, 0x70,
  0x65, 0x72, 0x74, 0x69, 0x65, 0x73, 0x6f, 0x66, 0x20, 0x42, 0x72, 0x69, 0x74,
  0x69, 0x73, 0x68, 0x20, 0x43, 0x6f, 0x6c, 0x75, 0x6d, 0x62, 0x69, 0x61, 0x68,
  0x61, 0x73, 0x20, 0x62, 0x65, 0x65, 0x6e, 0x20, 0x63, 0x72, 0x69, 0x74, 0x69,
  0x63, 0x69, 0x7a, 0x65, 0x64, 0x28, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x65, 0x78, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x71, 0x75,
  0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x61, 0x62, 0x6f, 0x75, 0x74,
  0x20, 0x74, 0x68, 0x65, 0x70, 0x61, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x20, 0x74,
  0x68, 0x72, 0x6f, 0x75, 0x67, 0x68, 0x20, 0x74, 0x68, 0x65, 0x30, 0x22, 0x20,
  0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69, 0x6e, 0x67, 0x3d, 0x22,
  0x30, 0x22, 0x20, 0x74, 0x68, 0x6f, 0x75, 0x73, 0x61, 0x6e, 0x64, 0x73, 0x20,
  0x6f, 0x66, 0x20, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x72, 0x65, 0x64, 0x69,
  0x72, 0x65, 0x63, 0x74, 0x73, 0x20, 0x68, 0x65, 0x72, 0x65, 0x2e, 0x20, 0x46,
  0x6f, 0x72, 0x68, 0x61, 0x76, 0x65, 0x20, 0x63, 0x68, 0x69, 0x6c, 0x64, 0x72,
  0x65, 0x6e, 0x20, 0x75, 0x6e, 0x64, 0x65, 0x72, 0x25, 0x33, 0x45, 0x25, 0x33,
  0x43, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x25, 0x33, 0x45, 0x22, 0x29,
  0x29, 0x3b, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x3c, 0x6c, 0x69, 0x3e,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x73, 0x69, 0x74, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x22,
  0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x74, 0x65, 0x78,
  0x74, 0x2d, 0x64, 0x65, 0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a,
  0x6e, 0x6f, 0x6e, 0x65, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x64, 0x69,
  0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x20, 0x6e, 0x6f, 0x6e, 0x65, 0x3c, 0x6d,
  0x65, 0x74, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70, 0x2d, 0x65, 0x71, 0x75, 0x69,
  0x76, 0x3d, 0x22, 0x58, 0x2d, 0x6e, 0x65, 0x77, 0x20, 0x44, 0x61, 0x74, 0x65,
  0x28, 0x29, 0x2e, 0x67, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x28, 0x29, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x78,
  0x2d, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e,
  0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22,
  0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x6a, 0x61, 0x76,
  0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x77, 0x69, 0x6e, 0x64, 0x6f, 0x77,
  0x2e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x68, 0x72, 0x65,
  0x66, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x6a, 0x61, 0x76,
  0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3a, 0x2d, 0x2d, 0x3e, 0x0d, 0x0a,
  0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x74, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x27, 0x68, 0x74,
  0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x68, 0x6f, 0x72, 0x74,
  0x63, 0x75, 0x74, 0x20, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x20, 0x68, 0x72, 0x65,
  0x66, 0x3d, 0x22, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0d, 0x0a, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x3c, 0x73, 0x63,
  0x72, 0x69, 0x70, 0x74, 0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x74, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x2f, 0x61, 0x3e, 0x20, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x20,
  0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x61, 0x72,
  0x65, 0x6e, 0x63, 0x79, 0x3d, 0x22, 0x58, 0x2d, 0x55, 0x41, 0x2d, 0x43, 0x6f,
  0x6d, 0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e,
  0x72, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x20,
  0x62, 0x65, 0x74, 0x77, 0x65, 0x65, 0x6e, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x20, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c, 0x2f, 0x75,
  0x6c, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x61, 0x73, 0x73, 0x6f, 0x63,
  0x69, 0x61, 0x74, 0x65, 0x64, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x70, 0x72, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x69, 0x6e, 0x67,
  0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3c, 0x2f, 0x61, 0x3e,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c,
  0x6c, 0x69, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x66, 0x6f, 0x72,
  0x6d, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20, 0x6e, 0x61, 0x6d,
  0x65, 0x3d, 0x22, 0x71, 0x22, 0x3c, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x20, 0x77,
  0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31, 0x30, 0x30, 0x25, 0x22, 0x20, 0x62,
  0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x70, 0x6f, 0x73,
  0x69, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x22, 0x20, 0x62, 0x6f, 0x72, 0x64, 0x65,
  0x72, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
  0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73, 0x68, 0x6f, 0x72, 0x74, 0x63, 0x75, 0x74,
  0x20, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x20, 0x68, 0x36, 0x3e, 0x3c, 0x75, 0x6c,
  0x3e, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d,
  0x22, 0x20, 0x20, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70,
  0x2d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x63, 0x73, 0x73, 0x22, 0x20,
  0x6d, 0x65, 0x64, 0x69, 0x61, 0x3d, 0x22, 0x73, 0x63, 0x72, 0x65, 0x65, 0x6e,
  0x22, 0x20, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x69, 0x62, 0x6c, 0x65,
  0x20, 0x66, 0x6f, 0x72, 0x20, 0x74, 0x68, 0x65, 0x20, 0x22, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x61, 0x70, 0x70, 0x6c, 0x69, 0x63, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x2f, 0x22, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x3d, 0x22, 0x62,
  0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f, 0x75, 0x6e, 0x64, 0x2d, 0x68, 0x74, 0x6d,
  0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x75, 0x74,
  0x66, 0x2d, 0x38, 0x22, 0x20, 0x61, 0x6c, 0x6c, 0x6f, 0x77, 0x74, 0x72, 0x61,
  0x6e, 0x73, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x63, 0x79, 0x3d, 0x22, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x74, 0x65, 0x0d, 0x0a, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20,
  0x68, 0x74, 0x74, 0x70, 0x2d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x3e,
  0x3c, 0x2f, 0x73, 0x70, 0x61, 0x6e, 0x3e, 0x3c, 0x73, 0x70, 0x61, 0x6e, 0x20,
  0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c,
  0x6c, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x3e,
  0x3b, 0x0a, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x73, 0x6f, 0x6d, 0x65, 0x74, 0x69,
  0x6d, 0x65, 0x73, 0x20, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x64, 0x20, 0x74, 0x68,
  0x65, 0x64, 0x6f, 0x65, 0x73, 0x20, 0x6e, 0x6f, 0x74, 0x20, 0x6e, 0x65, 0x63,
  0x65, 0x73, 0x73, 0x61, 0x72, 0x69, 0x6c, 0x79, 0x46, 0x6f, 0x72, 0x20, 0x6d,
  0x6f, 0x72, 0x65, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x69,
  0x6f, 0x6e, 0x61, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x67, 0x69,
  0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x20, 0x6f, 0x66, 0x20, 0x3c, 0x21, 0x44, 0x4f,
  0x43, 0x54, 0x59, 0x50, 0x45, 0x20, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x3c, 0x68,
  0x74, 0x6d, 0x6c, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x75, 0x6c, 0x61, 0x72,
  0x6c, 0x79, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61,
  0x6d, 0x65, 0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70,
  0x74, 0x3a, 0x76, 0x6f, 0x69, 0x64, 0x28, 0x30, 0x29, 0x3b, 0x22, 0x65, 0x66,
  0x66, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x6e, 0x65, 0x73, 0x73, 0x20, 0x6f,
  0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x61, 0x75, 0x74, 0x6f, 0x63, 0x6f, 0x6d,
  0x70, 0x6c, 0x65, 0x74, 0x65, 0x3d, 0x22, 0x6f, 0x66, 0x66, 0x22, 0x20, 0x67,
  0x65, 0x6e, 0x65, 0x72, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x63, 0x6f, 0x6e, 0x73,
  0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x3e, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74,
  0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20,
  0x22, 0x3e, 0x3c, 0x2f, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3e, 0x0d, 0x0a,
  0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x74, 0x68, 0x72, 0x6f, 0x75, 0x67,
  0x68, 0x6f, 0x75, 0x74, 0x20, 0x74, 0x68, 0x65, 0x20, 0x77, 0x6f, 0x72, 0x6c,
  0x64, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x20, 0x6d, 0x69, 0x73, 0x63, 0x6f,
  0x6e, 0x63, 0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x73, 0x73, 0x6f, 0x63,
  0x69, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74,
  0x68, 0x65, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0a, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x64, 0x75, 0x72, 0x69,
  0x6e, 0x67, 0x20, 0x68, 0x69, 0x73, 0x20, 0x6c, 0x69, 0x66, 0x65, 0x74, 0x69,
  0x6d, 0x65, 0x2c, 0x63, 0x6f, 0x72, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x64,
  0x69, 0x6e, 0x67, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x78, 0x2d, 0x69, 0x63,
  0x6f, 0x6e, 0x22, 0x20, 0x61, 0x6e, 0x20, 0x69, 0x6e, 0x63, 0x72, 0x65, 0x61,
  0x73, 0x69, 0x6e, 0x67, 0x20, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x64, 0x69,
  0x70, 0x6c, 0x6f, 0x6d, 0x61, 0x74, 0x69, 0x63, 0x20, 0x72, 0x65, 0x6c, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x61, 0x72, 0x65, 0x20, 0x6f, 0x66, 0x74, 0x65,
  0x6e, 0x20, 0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x6d,
  0x65, 0x74, 0x61, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x22,
  0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x20, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74,
  0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22, 0x20,
  0x65, 0x78, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x20, 0x69, 0x6e, 0x63, 0x6c,
  0x75, 0x64, 0x65, 0x20, 0x74, 0x68, 0x65, 0x22, 0x3e, 0x3c, 0x69, 0x6d, 0x67,
  0x20, 0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x69, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x74, 0x68, 0x65, 0x20, 0x65,
  0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68, 0x6d, 0x65, 0x6e, 0x74, 0x20,
  0x6f, 0x66, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x64, 0x69,
  0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x22, 0x26, 0x61, 0x6d, 0x70,
  0x3b, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x26, 0x61, 0x6d, 0x70, 0x3b, 0x6e, 0x62,
  0x73, 0x70, 0x3b, 0x74, 0x6f, 0x20, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69,
  0x6e, 0x65, 0x20, 0x77, 0x68, 0x65, 0x74, 0x68, 0x65, 0x72, 0x71, 0x75, 0x69,
  0x74, 0x65, 0x20, 0x64, 0x69, 0x66, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x74, 0x20,
  0x66, 0x72, 0x6f, 0x6d, 0x6d, 0x61, 0x72, 0x6b, 0x65, 0x64, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x64, 0x69,
  0x73, 0x74, 0x61, 0x6e, 0x63, 0x65, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65, 0x65,
  0x6e, 0x20, 0x74, 0x68, 0x65, 0x63, 0x6f, 0x6e, 0x74, 0x72, 0x69, 0x62, 0x75,
  0x74, 0x69, 0x6f, 0x6e, 0x73, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65, 0x63,
  0x6f, 0x6e, 0x66, 0x6c, 0x69, 0x63, 0x74, 0x20, 0x62, 0x65, 0x74, 0x77, 0x65,
  0x65, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x77, 0x69, 0x64, 0x65, 0x6c, 0x79, 0x20,
  0x63, 0x6f, 0x6e, 0x73, 0x69, 0x64, 0x65, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f,
  0x77, 0x61, 0x73, 0x20, 0x6f, 0x6e, 0x65, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68,
  0x65, 0x20, 0x66, 0x69, 0x72, 0x73, 0x74, 0x77, 0x69, 0x74, 0x68, 0x20, 0x76,
  0x61, 0x72, 0x79, 0x69, 0x6e, 0x67, 0x20, 0x64, 0x65, 0x67, 0x72, 0x65, 0x65,
  0x73, 0x68, 0x61, 0x76, 0x65, 0x20, 0x73, 0x70, 0x65, 0x63, 0x75, 0x6c, 0x61,
  0x74, 0x65, 0x64, 0x20, 0x74, 0x68, 0x61, 0x74, 0x28, 0x64, 0x6f, 0x63, 0x75,
  0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x70, 0x61, 0x72, 0x74, 0x69, 0x63, 0x69, 0x70, 0x61, 0x74, 0x69,
  0x6e, 0x67, 0x20, 0x69, 0x6e, 0x20, 0x74, 0x68, 0x65, 0x6f, 0x72, 0x69, 0x67,
  0x69, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x20, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f,
  0x70, 0x65, 0x64, 0x65, 0x74, 0x61, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65,
  0x74, 0x3d, 0x22, 0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x3e, 0x20, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22,
  0x20, 0x2f, 0x3e, 0x0a, 0x69, 0x6e, 0x74, 0x65, 0x72, 0x63, 0x68, 0x61, 0x6e,
  0x67, 0x65, 0x61, 0x62, 0x6c, 0x79, 0x20, 0x77, 0x69, 0x74, 0x68, 0x6d, 0x6f,
  0x72, 0x65, 0x20, 0x63, 0x6c, 0x6f, 0x73, 0x65, 0x6c, 0x79, 0x20, 0x72, 0x65,
  0x6c, 0x61, 0x74, 0x65, 0x64, 0x73, 0x6f, 0x63, 0x69, 0x61, 0x6c, 0x20, 0x61,
  0x6e, 0x64, 0x20, 0x70, 0x6f, 0x6c, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6c, 0x74,
  0x68, 0x61, 0x74, 0x20, 0x77, 0x6f, 0x75, 0x6c, 0x64, 0x20, 0x6f, 0x74, 0x68,
  0x65, 0x72, 0x77, 0x69, 0x73, 0x65, 0x70, 0x65, 0x72, 0x70, 0x65, 0x6e, 0x64,
  0x69, 0x63, 0x75, 0x6c, 0x61, 0x72, 0x20, 0x74, 0x6f, 0x20, 0x74, 0x68, 0x65,
  0x73, 0x74, 0x79, 0x6c, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x22, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x69, 0x65, 0x73, 0x20, 0x72, 0x65, 0x73,
  0x69, 0x64, 0x69, 0x6e, 0x67, 0x20, 0x69, 0x6e, 0x64, 0x65, 0x76, 0x65, 0x6c,
  0x6f, 0x70, 0x69, 0x6e, 0x67, 0x20, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x72, 0x69,
  0x65, 0x73, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x72, 0x20, 0x70, 0x72,
  0x6f, 0x67, 0x72, 0x61, 0x6d, 0x6d, 0x69, 0x6e, 0x67, 0x65, 0x63, 0x6f, 0x6e,
  0x6f, 0x6d, 0x69, 0x63, 0x20, 0x64, 0x65, 0x76, 0x65, 0x6c, 0x6f, 0x70, 0x6d,
  0x65, 0x6e, 0x74, 0x64, 0x65, 0x74, 0x65, 0x72, 0x6d, 0x69, 0x6e, 0x61, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x66, 0x6f, 0x72,
  0x20, 0x6d, 0x6f, 0x72, 0x65, 0x20, 0x69, 0x6e, 0x66, 0x6f, 0x72, 0x6d, 0x61,
  0x74, 0x69, 0x6f, 0x6e, 0x6f, 0x6e, 0x20, 0x73, 0x65, 0x76, 0x65, 0x72, 0x61,
  0x6c, 0x20, 0x6f, 0x63, 0x63, 0x61, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x70, 0x6f,
  0x72, 0x74, 0x75, 0x67, 0x75, 0xc3, 0xaa, 0x73, 0x20, 0x28, 0x45, 0x75, 0x72,
  0x6f, 0x70, 0x65, 0x75, 0x29, 0xd0, 0xa3, 0xd0, 0xba, 0xd1, 0x80, 0xd0, 0xb0,
  0xd1, 0x97, 0xd0, 0xbd, 0xd1, 0x81, 0xd1, 0x8c, 0xd0, 0xba, 0xd0, 0xb0, 0xd1,
  0x83, 0xd0, 0xba, 0xd1, 0x80, 0xd0, 0xb0, 0xd1, 0x97, 0xd0, 0xbd, 0xd1, 0x81,
  0xd1, 0x8c, 0xd0, 0xba, 0xd0, 0xb0, 0xd0, 0xa0, 0xd0, 0xbe, 0xd1, 0x81, 0xd1,
  0x81, 0xd0, 0xb8, 0xd0, 0xb9, 0xd1, 0x81, 0xd0, 0xba, 0xd0, 0xbe, 0xd0, 0xb9,
  0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb5, 0xd1, 0x80, 0xd0, 0xb8, 0xd0,
  0xb0, 0xd0, 0xbb, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x84,
  0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd0,
  0xb8, 0xd1, 0x83, 0xd0, 0xbf, 0xd1, 0x80, 0xd0, 0xb0, 0xd0, 0xb2, 0xd0, 0xbb,
  0xd0, 0xb5, 0xd0, 0xbd, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0xbd, 0xd0, 0xb5, 0xd0,
  0xbe, 0xd0, 0xb1, 0xd1, 0x85, 0xd0, 0xbe, 0xd0, 0xb4, 0xd0, 0xb8, 0xd0, 0xbc,
  0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd0,
  0xbc, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd1, 0x8f, 0xd0, 0x98, 0xd0, 0xbd,
  0xd1, 0x84, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x86, 0xd0,
  0xb8, 0xd1, 0x8f, 0xd0, 0xa0, 0xd0, 0xb5, 0xd1, 0x81, 0xd0, 0xbf, 0xd1, 0x83,
  0xd0, 0xb1, 0xd0, 0xbb, 0xd0, 0xb8, 0xd0, 0xba, 0xd0, 0xb8, 0xd0, 0xba, 0xd0,
  0xbe, 0xd0, 0xbb, 0xd0, 0xb8, 0xd1, 0x87, 0xd0, 0xb5, 0xd1, 0x81, 0xd1, 0x82,
  0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xbd, 0xd1, 0x84, 0xd0, 0xbe, 0xd1,
  0x80, 0xd0, 0xbc, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd1, 0x8e, 0xd1, 0x82,
  0xd0, 0xb5, 0xd1, 0x80, 0xd1, 0x80, 0xd0, 0xb8, 0xd1, 0x82, 0xd0, 0xbe, 0xd1,
  0x80, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xb4, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x82,
  0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xbe, 0xd1, 0x87, 0xd0, 0xbd, 0xd0, 0xbe, 0xd8,
  0xa7, 0xd9, 0x84, 0xd9, 0x85, 0xd8, 0xaa, 0xd9, 0x88, 0xd8, 0xa7, 0xd8, 0xac,
  0xd8, 0xaf, 0xd9, 0x88, 0xd9, 0x86, 0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd8,
  0xb4, 0xd8, 0xaa, 0xd8, 0xb1, 0xd8, 0xa7, 0xd9, 0x83, 0xd8, 0xa7, 0xd8, 0xaa,
  0xd8, 0xa7, 0xd9, 0x84, 0xd8, 0xa7, 0xd9, 0x82, 0xd8, 0xaa, 0xd8, 0xb1, 0xd8,
  0xa7, 0xd8, 0xad, 0xd8, 0xa7, 0xd8, 0xaa, 0x68, 0x74, 0x6d, 0x6c, 0x3b, 0x20,
  0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x55, 0x54, 0x46, 0x2d, 0x38,
  0x22, 0x20, 0x73, 0x65, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x6f, 0x75, 0x74, 0x28,
  0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x28, 0x29, 0x64, 0x69, 0x73,
  0x70, 0x6c, 0x61, 0x79, 0x3a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x2d, 0x62,
  0x6c, 0x6f, 0x63, 0x6b, 0x3b, 0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x73, 0x75, 0x62, 0x6d, 0x69, 0x74, 0x22, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x20, 0x3d, 0x20, 0x27, 0x74, 0x65, 0x78, 0x74, 0x2f,
  0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x3c, 0x69, 0x6d, 0x67, 0x20,
  0x73, 0x72, 0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77,
  0x77, 0x77, 0x2e, 0x22, 0x20, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0x77, 0x77, 0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x73, 0x68,
  0x6f, 0x72, 0x74, 0x63, 0x75, 0x74, 0x20, 0x69, 0x63, 0x6f, 0x6e, 0x22, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x22, 0x20, 0x61, 0x75, 0x74, 0x6f, 0x63,
  0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x3d, 0x22, 0x6f, 0x66, 0x66, 0x22,
  0x20, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x64,
  0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d, 0x3c, 0x2f, 0x61, 0x3e,
  0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x0a, 0x3c, 0x6c, 0x69, 0x20, 0x63, 0x6c, 0x61,
  0x73, 0x73, 0x3d, 0x22, 0x63, 0x73, 0x73, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65,
  0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x3c,
  0x66, 0x6f, 0x72, 0x6d, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x22,
  0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73,
  0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x61,
  0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x22, 0x20, 0x0d, 0x0a, 0x3c,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x2f, 0x20, 0x6f, 0x6e, 0x63, 0x6c, 0x69, 0x63, 0x6b,
  0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x3a,
  0x28, 0x6e, 0x65, 0x77, 0x20, 0x44, 0x61, 0x74, 0x65, 0x29, 0x2e, 0x67, 0x65,
  0x74, 0x54, 0x69, 0x6d, 0x65, 0x28, 0x29, 0x7d, 0x68, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x3d, 0x22, 0x31, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22,
  0x31, 0x22, 0x20, 0x50, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x27, 0x73, 0x20, 0x52,
  0x65, 0x70, 0x75, 0x62, 0x6c, 0x69, 0x63, 0x20, 0x6f, 0x66, 0x20, 0x20, 0x3c,
  0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a,
  0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x74, 0x65, 0x78, 0x74, 0x2d, 0x64, 0x65,
  0x63, 0x6f, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x3a, 0x75, 0x6e, 0x64, 0x65,
  0x72, 0x74, 0x68, 0x65, 0x20, 0x62, 0x65, 0x67, 0x69, 0x6e, 0x6e, 0x69, 0x6e,
  0x67, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x0a, 0x3c, 0x2f, 0x64,
  0x69, 0x76, 0x3e, 0x0a, 0x65, 0x73, 0x74, 0x61, 0x62, 0x6c, 0x69, 0x73, 0x68,
  0x6d, 0x65, 0x6e, 0x74, 0x20, 0x6f, 0x66, 0x20, 0x74, 0x68, 0x65, 0x20, 0x3c,
  0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f,
  0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x23, 0x76, 0x69, 0x65, 0x77, 0x70,
  0x6f, 0x72, 0x74, 0x7b, 0x6d, 0x69, 0x6e, 0x2d, 0x68, 0x65, 0x69, 0x67, 0x68,
  0x74, 0x3a, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x73, 0x72,
  0x63, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x6f, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x3e, 0x3c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x3d, 0x6f, 0x66, 0x74, 0x65, 0x6e, 0x20, 0x72, 0x65,
  0x66, 0x65, 0x72, 0x72, 0x65, 0x64, 0x20, 0x74, 0x6f, 0x20, 0x61, 0x73, 0x20,
  0x2f, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x3e, 0x0a, 0x3c, 0x6f, 0x70, 0x74,
  0x69, 0x6f, 0x6e, 0x20, 0x76, 0x61, 0x6c, 0x75, 0x3c, 0x21, 0x44, 0x4f, 0x43,
  0x54, 0x59, 0x50, 0x45, 0x20, 0x68, 0x74, 0x6d, 0x6c, 0x3e, 0x0a, 0x3c, 0x21,
  0x2d, 0x2d, 0x5b, 0x49, 0x6e, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x69, 0x6f,
  0x6e, 0x61, 0x6c, 0x20, 0x41, 0x69, 0x72, 0x70, 0x6f, 0x72, 0x74, 0x3e, 0x0a,
  0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70,
  0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x3c, 0x2f, 0x61, 0x3e, 0x3c, 0x61, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0xe0, 0xb8, 0xa0, 0xe0, 0xb8, 0xb2, 0xe0, 0xb8, 0xa9, 0xe0, 0xb8, 0xb2,
  0xe0, 0xb9, 0x84, 0xe0, 0xb8, 0x97, 0xe0, 0xb8, 0xa2, 0xe1, 0x83, 0xa5, 0xe1,
  0x83, 0x90, 0xe1, 0x83, 0xa0, 0xe1, 0x83, 0x97, 0xe1, 0x83, 0xa3, 0xe1, 0x83,
  0x9a, 0xe1, 0x83, 0x98, 0xe6, 0xad, 0xa3, 0xe9, 0xab, 0x94, 0xe4, 0xb8, 0xad,
  0xe6, 0x96, 0x87, 0x20, 0x28, 0xe7, 0xb9, 0x81, 0xe9, 0xab, 0x94, 0x29, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xa6, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb6, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xb2, 0xe0, 0xa5, 0x8b, 0xe0,
  0xa4, 0xa1, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb7, 0xe0, 0xa5,
  0x87, 0xe0, 0xa4, 0xa4, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x9c,
  0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4,
  0xac, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4,
  0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa5, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5,
  0x8d, 0xe0, 0xa4, 0xb5, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4,
  0xb8, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x9a, 0xe0, 0xa4, 0xbf, 0xe0,
  0xa4, 0x9f, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa0, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9c, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0x9e, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x85, 0xe0,
  0xa4, 0xae, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xad,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0x97, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xa1, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0xaf, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xaf, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x95, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb8, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4,
  0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb7, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa4, 0xb9, 0xe0, 0xa5, 0x81, 0xe0, 0xa4, 0x81, 0xe0, 0xa4, 0x9a, 0xe0,
  0xa4, 0xa4, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb0, 0xe0, 0xa4, 0xac, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xa8,
  0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0,
  0xa4, 0xaa, 0xe0, 0xa4, 0xa3, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0x95, 0xe0, 0xa5,
  0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xad, 0xe0, 0xa4,
  0xaa, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xae, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4,
  0x82, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xab, 0xe0, 0xa4, 0xbc, 0xe0, 0xa5, 0x8d,
  0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xa8, 0xe0,
  0xa4, 0xbf, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xae, 0xe0, 0xa4,
  0xbe, 0xe0, 0xa4, 0xa3, 0xe0, 0xa4, 0xb2, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xae,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x9f, 0xe0, 0xa5, 0x87, 0xe0, 0xa4, 0xa1, 0x64,
  0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x20, 0x63,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x64, 0x6f, 0x63, 0x75, 0x6d,
  0x65, 0x6e, 0x74, 0x2e, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
  0x70, 0x72, 0x6f, 0x74, 0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x73, 0x42, 0x79, 0x54, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x28,
  0x3c, 0x21, 0x44, 0x4f, 0x43, 0x54, 0x59, 0x50, 0x45, 0x20, 0x68, 0x74, 0x6d,
  0x6c, 0x3e, 0x0a, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x3c, 0x6d, 0x65, 0x74,
  0x61, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x22, 0x75, 0x74,
  0x66, 0x2d, 0x38, 0x22, 0x3e, 0x3a, 0x75, 0x72, 0x6c, 0x22, 0x20, 0x63, 0x6f,
  0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f,
  0x2f, 0x2e, 0x63, 0x73, 0x73, 0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73,
  0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74,
  0x2f, 0x63, 0x73, 0x73, 0x22, 0x3e, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66,
  0x3d, 0x22, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x31, 0x39, 0x39, 0x39,
  0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x22, 0x20, 0x78, 0x6d, 0x6c, 0x74, 0x79,
  0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x6d, 0x65, 0x74, 0x68, 0x6f,
  0x64, 0x3d, 0x22, 0x67, 0x65, 0x74, 0x22, 0x20, 0x61, 0x63, 0x74, 0x69, 0x6f,
  0x6e, 0x3d, 0x22, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22,
  0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x20,
  0x3d, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x65,
  0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x2f, 0x78, 0x2d, 0x69, 0x63, 0x6f, 0x6e,
  0x22, 0x20, 0x2f, 0x3e, 0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x64, 0x69,
  0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x70,
  0x2e, 0x63, 0x73, 0x73, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x3c, 0x2f, 0x61, 0x3e,
  0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d,
  0x22, 0x31, 0x22, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74, 0x3d, 0x22, 0x31,
  0x22, 0x22, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x73, 0x74, 0x79,
  0x6c, 0x65, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x6e,
  0x6f, 0x6e, 0x65, 0x3b, 0x22, 0x3e, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61,
  0x74, 0x65, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x61, 0x70, 0x70,
  0x6c, 0x69, 0x2d, 0x2f, 0x2f, 0x57, 0x33, 0x43, 0x2f, 0x2f, 0x44, 0x54, 0x44,
  0x20, 0x58, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x31, 0x2e, 0x30, 0x20, 0x65, 0x6c,
  0x6c, 0x73, 0x70, 0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x20,
  0x63, 0x65, 0x6c, 0x6c, 0x70, 0x61, 0x64, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x76, 0x61, 0x6c, 0x75,
  0x65, 0x3d, 0x22, 0x2f, 0x61, 0x3e, 0x26, 0x6e, 0x62, 0x73, 0x70, 0x3b, 0x3c,
  0x73, 0x70, 0x61, 0x6e, 0x20, 0x72, 0x6f, 0x6c, 0x65, 0x3d, 0x22, 0x73, 0x0a,
  0x3c, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x6c, 0x61, 0x6e, 0x67, 0x75,
  0x61, 0x67, 0x65, 0x3d, 0x22, 0x4a, 0x61, 0x76, 0x61, 0x53, 0x63, 0x72, 0x69,
  0x70, 0x74, 0x22, 0x20, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74,
  0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42,
  0x67, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x70, 0x61,
  0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x6d, 0x65,
  0x64, 0x69, 0x61, 0x3d, 0x22, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x74, 0x65,
  0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x27, 0x77, 0x69, 0x74, 0x68, 0x20, 0x74, 0x68, 0x65, 0x20, 0x65, 0x78, 0x63,
  0x65, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x6f, 0x66, 0x20, 0x79, 0x70, 0x65,
  0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73, 0x22, 0x20, 0x72,
  0x65, 0x6c, 0x3d, 0x22, 0x73, 0x74, 0x20, 0x68, 0x65, 0x69, 0x67, 0x68, 0x74,
  0x3d, 0x22, 0x31, 0x22, 0x20, 0x77, 0x69, 0x64, 0x74, 0x68, 0x3d, 0x22, 0x31,
  0x22, 0x20, 0x3d, 0x27, 0x2b, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x55, 0x52,
  0x49, 0x43, 0x6f, 0x6d, 0x70, 0x6f, 0x6e, 0x65, 0x6e, 0x74, 0x28, 0x3c, 0x6c,
  0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x61, 0x6c, 0x74, 0x65,
  0x72, 0x6e, 0x61, 0x74, 0x65, 0x22, 0x20, 0x0a, 0x62, 0x6f, 0x64, 0x79, 0x2c,
  0x20, 0x74, 0x72, 0x2c, 0x20, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x2c, 0x20, 0x74,
  0x65, 0x78, 0x74, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x22, 0x72, 0x6f, 0x62, 0x6f, 0x74, 0x73, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x6d,
  0x65, 0x74, 0x68, 0x6f, 0x64, 0x3d, 0x22, 0x70, 0x6f, 0x73, 0x74, 0x22, 0x20,
  0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x3d, 0x22, 0x3e, 0x0a, 0x3c, 0x61, 0x20,
  0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f,
  0x77, 0x77, 0x77, 0x2e, 0x63, 0x73, 0x73, 0x22, 0x20, 0x72, 0x65, 0x6c, 0x3d,
  0x22, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20,
  0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c,
  0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x6c, 0x61, 0x6e, 0x67,
  0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x22, 0x3e, 0x61, 0x72, 0x69, 0x61, 0x2d, 0x68, 0x69, 0x64,
  0x64, 0x65, 0x6e, 0x3d, 0x22, 0x74, 0x72, 0x75, 0x65, 0x22, 0x3e, 0xc2, 0xb7,
  0x3c, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x6c, 0x3d, 0x30,
  0x3b, 0x7d, 0x29, 0x28, 0x29, 0x3b, 0x0a, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74,
  0x69, 0x6f, 0x6e, 0x28, 0x29, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x67, 0x72, 0x6f,
  0x75, 0x6e, 0x64, 0x2d, 0x69, 0x6d, 0x61, 0x67, 0x65, 0x3a, 0x20, 0x75, 0x72,
  0x6c, 0x28, 0x2f, 0x61, 0x3e, 0x3c, 0x2f, 0x6c, 0x69, 0x3e, 0x3c, 0x6c, 0x69,
  0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x09, 0x09,
  0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22,
  0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x20,
  0x61, 0x72, 0x69, 0x61, 0x2d, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x3d, 0x22,
  0x74, 0x72, 0x75, 0x3e, 0x20, 0x3c, 0x61, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d,
  0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x6c,
  0x61, 0x6e, 0x67, 0x75, 0x61, 0x67, 0x65, 0x3d, 0x22, 0x6a, 0x61, 0x76, 0x61,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x22, 0x20, 0x2f, 0x6f, 0x70, 0x74, 0x69,
  0x6f, 0x6e, 0x3e, 0x0a, 0x3c, 0x6f, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x20, 0x76,
  0x61, 0x6c, 0x75, 0x65, 0x2f, 0x64, 0x69, 0x76, 0x3e, 0x3c, 0x2f, 0x64, 0x69,
  0x76, 0x3e, 0x3c, 0x64, 0x69, 0x76, 0x20, 0x63, 0x6c, 0x61, 0x73, 0x73, 0x3d,
  0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x20, 0x61, 0x72, 0x69, 0x61, 0x2d, 0x68,
  0x69, 0x64, 0x64, 0x65, 0x6e, 0x3d, 0x22, 0x74, 0x72, 0x65, 0x3d, 0x28, 0x6e,
  0x65, 0x77, 0x20, 0x44, 0x61, 0x74, 0x65, 0x29, 0x2e, 0x67, 0x65, 0x74, 0x54,
  0x69, 0x6d, 0x65, 0x28, 0x29, 0x70, 0x6f, 0x72, 0x74, 0x75, 0x67, 0x75, 0xc3,
  0xaa, 0x73, 0x20, 0x28, 0x64, 0x6f, 0x20, 0x42, 0x72, 0x61, 0x73, 0x69, 0x6c,
  0x29, 0xd0, 0xbe, 0xd1, 0x80, 0xd0, 0xb3, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8,
  0xd0, 0xb7, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xb2, 0xd0,
  0xbe, 0xd0, 0xb7, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x8c, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x80, 0xd0,
  0xb0, 0xd0, 0xb7, 0xd0, 0xbe, 0xd0, 0xb2, 0xd0, 0xb0, 0xd0, 0xbd, 0xd0, 0xb8,
  0xd1, 0x8f, 0xd1, 0x80, 0xd0, 0xb5, 0xd0, 0xb3, 0xd0, 0xb8, 0xd1, 0x81, 0xd1,
  0x82, 0xd1, 0x80, 0xd0, 0xb0, 0xd1, 0x86, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xb2,
  0xd0, 0xbe, 0xd0, 0xb7, 0xd0, 0xbc, 0xd0, 0xbe, 0xd0, 0xb6, 0xd0, 0xbd, 0xd0,
  0xbe, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd0, 0xbe, 0xd0, 0xb1, 0xd1, 0x8f,
  0xd0, 0xb7, 0xd0, 0xb0, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbb, 0xd1, 0x8c, 0xd0,
  0xbd, 0xd0, 0xb0, 0x3c, 0x21, 0x44, 0x4f, 0x43, 0x54, 0x59, 0x50, 0x45, 0x20,
  0x68, 0x74, 0x6d, 0x6c, 0x20, 0x50, 0x55, 0x42, 0x4c, 0x49, 0x43, 0x20, 0x22,
  0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x3c, 0x6d, 0x65,
  0x74, 0x61, 0x20, 0x68, 0x74, 0x74, 0x70, 0x2d, 0x65, 0x71, 0x75, 0x69, 0x76,
  0x3d, 0x22, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x72, 0x61, 0x6e, 0x73, 0x69, 0x74,
  0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x2f, 0x2f, 0x45, 0x4e, 0x22, 0x20, 0x22, 0x68,
  0x74, 0x74, 0x70, 0x3a, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x78, 0x6d, 0x6c,
  0x6e, 0x73, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77,
  0x77, 0x2d, 0x2f, 0x2f, 0x57, 0x33, 0x43, 0x2f, 0x2f, 0x44, 0x54, 0x44, 0x20,
  0x58, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x31, 0x2e, 0x30, 0x20, 0x54, 0x44, 0x54,
  0x44, 0x2f, 0x78, 0x68, 0x74, 0x6d, 0x6c, 0x31, 0x2d, 0x74, 0x72, 0x61, 0x6e,
  0x73, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x2f, 0x2f, 0x77, 0x77, 0x77,
  0x2e, 0x77, 0x33, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x54, 0x52, 0x2f, 0x78, 0x68,
  0x74, 0x6d, 0x6c, 0x31, 0x2f, 0x70, 0x65, 0x20, 0x3d, 0x20, 0x27, 0x74, 0x65,
  0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x27, 0x3b, 0x3c, 0x6d, 0x65, 0x74, 0x61, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
  0x22, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x70,
  0x61, 0x72, 0x65, 0x6e, 0x74, 0x4e, 0x6f, 0x64, 0x65, 0x2e, 0x69, 0x6e, 0x73,
  0x65, 0x72, 0x74, 0x42, 0x65, 0x66, 0x6f, 0x72, 0x65, 0x3c, 0x69, 0x6e, 0x70,
  0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x68, 0x69, 0x64, 0x64,
  0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61, 0x6a, 0x73, 0x22, 0x20, 0x74, 0x79, 0x70,
  0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73,
  0x63, 0x72, 0x69, 0x28, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x29,
  0x2e, 0x72, 0x65, 0x61, 0x64, 0x79, 0x28, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69,
  0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x69, 0x6d, 0x61,
  0x67, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x3d, 0x22,
  0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x55, 0x41, 0x2d, 0x43, 0x6f, 0x6d,
  0x70, 0x61, 0x74, 0x69, 0x62, 0x6c, 0x65, 0x22, 0x20, 0x63, 0x6f, 0x6e, 0x74,
  0x65, 0x6e, 0x74, 0x3d, 0x74, 0x6d, 0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72,
  0x73, 0x65, 0x74, 0x3d, 0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x20, 0x2f, 0x3e,
  0x0a, 0x6c, 0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73, 0x68,
  0x6f, 0x72, 0x74, 0x63, 0x75, 0x74, 0x20, 0x69, 0x63, 0x6f, 0x6e, 0x3c, 0x6c,
  0x69, 0x6e, 0x6b, 0x20, 0x72, 0x65, 0x6c, 0x3d, 0x22, 0x73, 0x74, 0x79, 0x6c,
  0x65, 0x73, 0x68, 0x65, 0x65, 0x74, 0x22, 0x20, 0x3c, 0x2f, 0x73, 0x63, 0x72,
  0x69, 0x70, 0x74, 0x3e, 0x0a, 0x3c, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x3d, 0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
  0x6e, 0x74, 0x2e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d,
  0x65, 0x6e, 0x3c, 0x61, 0x20, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x3d, 0x22,
  0x5f, 0x62, 0x6c, 0x61, 0x6e, 0x6b, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d,
  0x20, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x67, 0x65, 0x74,
  0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x69, 0x6e, 0x70, 0x75,
  0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x22,
  0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x61, 0x2e, 0x74, 0x79, 0x70, 0x65, 0x20,
  0x3d, 0x20, 0x27, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73,
  0x63, 0x72, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d,
  0x22, 0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x65,
  0x68, 0x74, 0x6d, 0x6c, 0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74,
  0x3d, 0x75, 0x74, 0x66, 0x2d, 0x38, 0x22, 0x20, 0x2f, 0x3e, 0x64, 0x74, 0x64,
  0x22, 0x3e, 0x0a, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x78, 0x6d, 0x6c, 0x6e,
  0x73, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x2d, 0x2f, 0x2f, 0x57, 0x33, 0x43,
  0x2f, 0x2f, 0x44, 0x54, 0x44, 0x20, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x34, 0x2e,
  0x30, 0x31, 0x20, 0x54, 0x65, 0x6e, 0x74, 0x73, 0x42, 0x79, 0x54, 0x61, 0x67,
  0x4e, 0x61, 0x6d, 0x65, 0x28, 0x27, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x27,
  0x29, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x68, 0x69, 0x64, 0x64, 0x65, 0x6e, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x3c, 0x73,
  0x63, 0x72, 0x69, 0x70, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74,
  0x65, 0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x22, 0x20, 0x73, 0x74,
  0x79, 0x6c, 0x65, 0x3d, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a,
  0x6e, 0x6f, 0x6e, 0x65, 0x3b, 0x22, 0x3e, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
  0x6e, 0x74, 0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
  0x42, 0x79, 0x49, 0x64, 0x28, 0x3d, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e,
  0x74, 0x2e, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6c, 0x65, 0x6d, 0x65,
  0x6e, 0x74, 0x28, 0x27, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x74, 0x65,
  0x78, 0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74,
  0x27, 0x69, 0x6e, 0x70, 0x75, 0x74, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x22,
  0x74, 0x65, 0x78, 0x74, 0x22, 0x20, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x22, 0x64,
  0x2e, 0x67, 0x65, 0x74, 0x45, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x42,
  0x79, 0x54, 0x61, 0x67, 0x4e, 0x61, 0x6d, 0x65, 0x28, 0x73, 0x6e, 0x69, 0x63,
  0x61, 0x6c, 0x22, 0x20, 0x68, 0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74,
  0x70, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x43, 0x2f, 0x2f, 0x44, 0x54,
  0x44, 0x20, 0x48, 0x54, 0x4d, 0x4c, 0x20, 0x34, 0x2e, 0x30, 0x31, 0x20, 0x54,
  0x72, 0x61, 0x6e, 0x73, 0x69, 0x74, 0x3c, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x20,
  0x74, 0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73,
  0x73, 0x22, 0x3e, 0x0a, 0x0a, 0x3c, 0x73, 0x74, 0x79, 0x6c, 0x65, 0x20, 0x74,
  0x79, 0x70, 0x65, 0x3d, 0x22, 0x74, 0x65, 0x78, 0x74, 0x2f, 0x63, 0x73, 0x73,
  0x22, 0x3e, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x2e, 0x64, 0x74, 0x64, 0x22, 0x3e,
  0x0a, 0x3c, 0x68, 0x74, 0x6d, 0x6c, 0x20, 0x78, 0x6d, 0x6c, 0x6e, 0x73, 0x3d,
  0x68, 0x74, 0x74, 0x70, 0x2d, 0x65, 0x71, 0x75, 0x69, 0x76, 0x3d, 0x22, 0x43,
  0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2d, 0x54, 0x79, 0x70, 0x65, 0x64, 0x69,
  0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x20, 0x63, 0x65, 0x6c, 0x6c, 0x73, 0x70,
  0x61, 0x63, 0x69, 0x6e, 0x67, 0x3d, 0x22, 0x30, 0x22, 0x68, 0x74, 0x6d, 0x6c,
  0x3b, 0x20, 0x63, 0x68, 0x61, 0x72, 0x73, 0x65, 0x74, 0x3d, 0x75, 0x74, 0x66,
  0x2d, 0x38, 0x22, 0x20, 0x2f, 0x3e, 0x0a, 0x20, 0x73, 0x74, 0x79, 0x6c, 0x65,
  0x3d, 0x22, 0x64, 0x69, 0x73, 0x70, 0x6c, 0x61, 0x79, 0x3a, 0x6e, 0x6f, 0x6e,
  0x65, 0x3b, 0x22, 0x3e, 0x3c, 0x3c, 0x6c, 0x69, 0x3e, 0x3c, 0x61, 0x20, 0x68,
  0x72, 0x65, 0x66, 0x3d, 0x22, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x77,
  0x77, 0x77, 0x2e, 0x20, 0x74, 0x79, 0x70, 0x65, 0x3d, 0x27, 0x74, 0x65, 0x78,
  0x74, 0x2f, 0x6a, 0x61, 0x76, 0x61, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x27,
  0x3e, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x8f, 0xd1, 0x82, 0xd0, 0xb5, 0xd0, 0xbb,
  0xd1, 0x8c, 0xd0, 0xbd, 0xd0, 0xbe, 0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xd1,
  0x81, 0xd0, 0xbe, 0xd0, 0xbe, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xb5, 0xd1, 0x82,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xb8, 0xd0, 0xb8, 0xd0, 0xbf, 0xd1,
  0x80, 0xd0, 0xbe, 0xd0, 0xb8, 0xd0, 0xb7, 0xd0, 0xb2, 0xd0, 0xbe, 0xd0, 0xb4,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb2, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xb5, 0xd0,
  0xb7, 0xd0, 0xbe, 0xd0, 0xbf, 0xd0, 0xb0, 0xd1, 0x81, 0xd0, 0xbd, 0xd0, 0xbe,
  0xd1, 0x81, 0xd1, 0x82, 0xd0, 0xb8, 0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x81, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0x82,
  0xe0, 0xa4, 0x97, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa5, 0x87, 0xe0,
  0xa4, 0xb8, 0xe0, 0xa4, 0x89, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb9, 0xe0, 0xa5, 0x8b, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0xa8, 0xe0, 0xa5, 0x87,
  0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa7, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0xa8, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0xad, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0xab, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb8,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0x82, 0xe0, 0xa4, 0x97, 0xe0, 0xa4, 0xb8, 0xe0,
  0xa5, 0x81, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4,
  0xb7, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x89,
  0xe0, 0xa4, 0xaa, 0xe0, 0xa5, 0x80, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xbe, 0xe0,
  0xa4, 0x87, 0xe0, 0xa4, 0x9f, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbf, 0xe0, 0xa4,
  0x9c, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0x9e, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xaa,
  0xe0, 0xa4, 0xa8, 0xe0, 0xa4, 0x95, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4, 0xb0, 0xe0,
  0xa5, 0x8d, 0xe0, 0xa4, 0xb0, 0xe0, 0xa4, 0xb5, 0xe0, 0xa4, 0xbe, 0xe0, 0xa4,
  0x88, 0xe0, 0xa4, 0xb8, 0xe0, 0xa4, 0x95, 0xe0, 0xa5, 0x8d, 0xe0, 0xa4, 0xb0,
  0xe0, 0xa4, 0xbf, 0xe0, 0xa4, 0xaf, 0xe0, 0xa4, 0xa4, 0xe0, 0xa4, 0xbe,
};

#if defined(__cplusplus) || defined(c_plusplus)
}    /* extern "C" */
#endif
