// Code generated by "golang.org/x/tools/gopls/doc/generate"; DO NOT EDIT.

package source

var GeneratedAPIJSON = &APIJSON{
	Options: map[string][]*OptionJSON{
		"User": {
			{
				Name:      "buildFlags",
				Type:      "[]string",
				Doc:       "buildFlags is the set of flags passed on to the build system when invoked.\nIt is applied to queries like `go list`, which is used when discovering files.\nThe most common use is to set `-tags`.\n",
				Default:   "[]",
				Hierarchy: "build",
			},
			{
				Name:      "env",
				Type:      "map[string]string",
				Doc:       "env adds environment variables to external commands run by `gopls`, most notably `go list`.\n",
				Default:   "{}",
				Hierarchy: "build",
			},
			{
				Name:      "directoryFilters",
				Type:      "[]string",
				Doc:       "directoryFilters can be used to exclude unwanted directories from the\nworkspace. By default, all directories are included. Filters are an\noperator, `+` to include and `-` to exclude, followed by a path prefix\nrelative to the workspace folder. They are evaluated in order, and\nthe last filter that applies to a path controls whether it is included.\nThe path prefix can be empty, so an initial `-` excludes everything.\n\nExamples:\n\nExclude node_modules: `-node_modules`\n\nInclude only project_a: `-` (exclude everything), `+project_a`\n\nInclude only project_a, but not node_modules inside it: `-`, `+project_a`, `-project_a/node_modules`\n",
				Default:   "[\"-node_modules\"]",
				Hierarchy: "build",
			},
			{
				Name:      "templateExtensions",
				Type:      "[]string",
				Doc:       "templateExtensions gives the extensions of file names that are treateed\nas template files. (The extension\nis the part of the file name after the final dot.)\n",
				Default:   "[]",
				Hierarchy: "build",
			},
			{
				Name: "memoryMode",
				Type: "enum",
				Doc:  "memoryMode controls the tradeoff `gopls` makes between memory usage and\ncorrectness.\n\nValues other than `Normal` are untested and may break in surprising ways.\n",
				EnumValues: []EnumValue{
					{
						Value: "\"DegradeClosed\"",
						Doc:   "`\"DegradeClosed\"`: In DegradeClosed mode, `gopls` will collect less information about\npackages without open files. As a result, features like Find\nReferences and Rename will miss results in such packages.\n",
					},
					{Value: "\"Normal\""},
				},
				Default:   "\"Normal\"",
				Status:    "experimental",
				Hierarchy: "build",
			},
			{
				Name:      "expandWorkspaceToModule",
				Type:      "bool",
				Doc:       "expandWorkspaceToModule instructs `gopls` to adjust the scope of the\nworkspace to find the best available module root. `gopls` first looks for\na go.mod file in any parent directory of the workspace folder, expanding\nthe scope to that directory if it exists. If no viable parent directory is\nfound, gopls will check if there is exactly one child directory containing\na go.mod file, narrowing the scope to that directory if it exists.\n",
				Default:   "true",
				Status:    "experimental",
				Hierarchy: "build",
			},
			{
				Name:      "experimentalWorkspaceModule",
				Type:      "bool",
				Doc:       "experimentalWorkspaceModule opts a user into the experimental support\nfor multi-module workspaces.\n",
				Default:   "false",
				Status:    "experimental",
				Hierarchy: "build",
			},
			{
				Name:      "experimentalPackageCacheKey",
				Type:      "bool",
				Doc:       "experimentalPackageCacheKey controls whether to use a coarser cache key\nfor package type information to increase cache hits. This setting removes\nthe user's environment, build flags, and working directory from the cache\nkey, which should be a safe change as all relevant inputs into the type\nchecking pass are already hashed into the key. This is temporarily guarded\nby an experiment because caching behavior is subtle and difficult to\ncomprehensively test.\n",
				Default:   "true",
				Status:    "experimental",
				Hierarchy: "build",
			},
			{
				Name:      "allowModfileModifications",
				Type:      "bool",
				Doc:       "allowModfileModifications disables -mod=readonly, allowing imports from\nout-of-scope modules. This option will eventually be removed.\n",
				Default:   "false",
				Status:    "experimental",
				Hierarchy: "build",
			},
			{
				Name:      "allowImplicitNetworkAccess",
				Type:      "bool",
				Doc:       "allowImplicitNetworkAccess disables GOPROXY=off, allowing implicit module\ndownloads rather than requiring user action. This option will eventually\nbe removed.\n",
				Default:   "false",
				Status:    "experimental",
				Hierarchy: "build",
			},
			{
				Name:      "experimentalUseInvalidMetadata",
				Type:      "bool",
				Doc:       "experimentalUseInvalidMetadata enables gopls to fall back on outdated\npackage metadata to provide editor features if the go command fails to\nload packages for some reason (like an invalid go.mod file). This will\neventually be the default behavior, and this setting will be removed.\n",
				Default:   "false",
				Status:    "experimental",
				Hierarchy: "build",
			},
			{
				Name: "hoverKind",
				Type: "enum",
				Doc:  "hoverKind controls the information that appears in the hover text.\nSingleLine and Structured are intended for use only by authors of editor plugins.\n",
				EnumValues: []EnumValue{
					{Value: "\"FullDocumentation\""},
					{Value: "\"NoDocumentation\""},
					{Value: "\"SingleLine\""},
					{
						Value: "\"Structured\"",
						Doc:   "`\"Structured\"` is an experimental setting that returns a structured hover format.\nThis format separates the signature from the documentation, so that the client\ncan do more manipulation of these fields.\n\nThis should only be used by clients that support this behavior.\n",
					},
					{Value: "\"SynopsisDocumentation\""},
				},
				Default:   "\"FullDocumentation\"",
				Hierarchy: "ui.documentation",
			},
			{
				Name:      "linkTarget",
				Type:      "string",
				Doc:       "linkTarget controls where documentation links go.\nIt might be one of:\n\n* `\"godoc.org\"`\n* `\"pkg.go.dev\"`\n\nIf company chooses to use its own `godoc.org`, its address can be used as well.\n",
				Default:   "\"pkg.go.dev\"",
				Hierarchy: "ui.documentation",
			},
			{
				Name:      "linksInHover",
				Type:      "bool",
				Doc:       "linksInHover toggles the presence of links to documentation in hover.\n",
				Default:   "true",
				Hierarchy: "ui.documentation",
			},
			{
				Name:      "usePlaceholders",
				Type:      "bool",
				Doc:       "placeholders enables placeholders for function parameters or struct\nfields in completion responses.\n",
				Default:   "false",
				Hierarchy: "ui.completion",
			},
			{
				Name:      "completionBudget",
				Type:      "time.Duration",
				Doc:       "completionBudget is the soft latency goal for completion requests. Most\nrequests finish in a couple milliseconds, but in some cases deep\ncompletions can take much longer. As we use up our budget we\ndynamically reduce the search scope to ensure we return timely\nresults. Zero means unlimited.\n",
				Default:   "\"100ms\"",
				Status:    "debug",
				Hierarchy: "ui.completion",
			},
			{
				Name: "matcher",
				Type: "enum",
				Doc:  "matcher sets the algorithm that is used when calculating completion\ncandidates.\n",
				EnumValues: []EnumValue{
					{Value: "\"CaseInsensitive\""},
					{Value: "\"CaseSensitive\""},
					{Value: "\"Fuzzy\""},
				},
				Default:   "\"Fuzzy\"",
				Status:    "advanced",
				Hierarchy: "ui.completion",
			},
			{
				Name:      "experimentalPostfixCompletions",
				Type:      "bool",
				Doc:       "experimentalPostfixCompletions enables artifical method snippets\nsuch as \"someSlice.sort!\".\n",
				Default:   "true",
				Status:    "experimental",
				Hierarchy: "ui.completion",
			},
			{
				Name: "importShortcut",
				Type: "enum",
				Doc:  "importShortcut specifies whether import statements should link to\ndocumentation or go to definitions.\n",
				EnumValues: []EnumValue{
					{Value: "\"Both\""},
					{Value: "\"Definition\""},
					{Value: "\"Link\""},
				},
				Default:   "\"Both\"",
				Hierarchy: "ui.navigation",
			},
			{
				Name: "symbolMatcher",
				Type: "enum",
				Doc:  "symbolMatcher sets the algorithm that is used when finding workspace symbols.\n",
				EnumValues: []EnumValue{
					{Value: "\"CaseInsensitive\""},
					{Value: "\"CaseSensitive\""},
					{Value: "\"FastFuzzy\""},
					{Value: "\"Fuzzy\""},
				},
				Default:   "\"Fuzzy\"",
				Status:    "advanced",
				Hierarchy: "ui.navigation",
			},
			{
				Name: "symbolStyle",
				Type: "enum",
				Doc:  "symbolStyle controls how symbols are qualified in symbol responses.\n\nExample Usage:\n\n```json5\n\"gopls\": {\n...\n  \"symbolStyle\": \"Dynamic\",\n...\n}\n```\n",
				EnumValues: []EnumValue{
					{
						Value: "\"Dynamic\"",
						Doc:   "`\"Dynamic\"` uses whichever qualifier results in the highest scoring\nmatch for the given symbol query. Here a \"qualifier\" is any \"/\" or \".\"\ndelimited suffix of the fully qualified symbol. i.e. \"to/pkg.Foo.Field\" or\njust \"Foo.Field\".\n",
					},
					{
						Value: "\"Full\"",
						Doc:   "`\"Full\"` is fully qualified symbols, i.e.\n\"path/to/pkg.Foo.Field\".\n",
					},
					{
						Value: "\"Package\"",
						Doc:   "`\"Package\"` is package qualified symbols i.e.\n\"pkg.Foo.Field\".\n",
					},
				},
				Default:   "\"Dynamic\"",
				Status:    "advanced",
				Hierarchy: "ui.navigation",
			},
			{
				Name: "analyses",
				Type: "map[string]bool",
				Doc:  "analyses specify analyses that the user would like to enable or disable.\nA map of the names of analysis passes that should be enabled/disabled.\nA full list of analyzers that gopls uses can be found\n[here](https://github.com/golang/tools/blob/master/gopls/doc/analyzers.md).\n\nExample Usage:\n\n```json5\n...\n\"analyses\": {\n  \"unreachable\": false, // Disable the unreachable analyzer.\n  \"unusedparams\": true  // Enable the unusedparams analyzer.\n}\n...\n```\n",
				EnumKeys: EnumKeys{
					ValueType: "bool",
					Keys: []EnumKey{
						{
							Name:    "\"asmdecl\"",
							Doc:     "report mismatches between assembly files and Go declarations",
							Default: "true",
						},
						{
							Name:    "\"assign\"",
							Doc:     "check for useless assignments\n\nThis checker reports assignments of the form x = x or a[i] = a[i].\nThese are almost always useless, and even when they aren't they are\nusually a mistake.",
							Default: "true",
						},
						{
							Name:    "\"atomic\"",
							Doc:     "check for common mistakes using the sync/atomic package\n\nThe atomic checker looks for assignment statements of the form:\n\n\tx = atomic.AddUint64(&x, 1)\n\nwhich are not atomic.",
							Default: "true",
						},
						{
							Name:    "\"atomicalign\"",
							Doc:     "check for non-64-bits-aligned arguments to sync/atomic functions",
							Default: "true",
						},
						{
							Name:    "\"bools\"",
							Doc:     "check for common mistakes involving boolean operators",
							Default: "true",
						},
						{
							Name:    "\"buildtag\"",
							Doc:     "check that +build tags are well-formed and correctly located",
							Default: "true",
						},
						{
							Name:    "\"cgocall\"",
							Doc:     "detect some violations of the cgo pointer passing rules\n\nCheck for invalid cgo pointer passing.\nThis looks for code that uses cgo to call C code passing values\nwhose types are almost always invalid according to the cgo pointer\nsharing rules.\nSpecifically, it warns about attempts to pass a Go chan, map, func,\nor slice to C, either directly, or via a pointer, array, or struct.",
							Default: "true",
						},
						{
							Name:    "\"composites\"",
							Doc:     "check for unkeyed composite literals\n\nThis analyzer reports a diagnostic for composite literals of struct\ntypes imported from another package that do not use the field-keyed\nsyntax. Such literals are fragile because the addition of a new field\n(even if unexported) to the struct will cause compilation to fail.\n\nAs an example,\n\n\terr = &net.DNSConfigError{err}\n\nshould be replaced by:\n\n\terr = &net.DNSConfigError{Err: err}\n",
							Default: "true",
						},
						{
							Name:    "\"copylocks\"",
							Doc:     "check for locks erroneously passed by value\n\nInadvertently copying a value containing a lock, such as sync.Mutex or\nsync.WaitGroup, may cause both copies to malfunction. Generally such\nvalues should be referred to through a pointer.",
							Default: "true",
						},
						{
							Name:    "\"deepequalerrors\"",
							Doc:     "check for calls of reflect.DeepEqual on error values\n\nThe deepequalerrors checker looks for calls of the form:\n\n    reflect.DeepEqual(err1, err2)\n\nwhere err1 and err2 are errors. Using reflect.DeepEqual to compare\nerrors is discouraged.",
							Default: "true",
						},
						{
							Name:    "\"errorsas\"",
							Doc:     "report passing non-pointer or non-error values to errors.As\n\nThe errorsas analysis reports calls to errors.As where the type\nof the second argument is not a pointer to a type implementing error.",
							Default: "true",
						},
						{
							Name:    "\"fieldalignment\"",
							Doc:     "find structs that would use less memory if their fields were sorted\n\nThis analyzer find structs that can be rearranged to use less memory, and provides\na suggested edit with the optimal order.\n\nNote that there are two different diagnostics reported. One checks struct size,\nand the other reports \"pointer bytes\" used. Pointer bytes is how many bytes of the\nobject that the garbage collector has to potentially scan for pointers, for example:\n\n\tstruct { uint32; string }\n\nhave 16 pointer bytes because the garbage collector has to scan up through the string's\ninner pointer.\n\n\tstruct { string; *uint32 }\n\nhas 24 pointer bytes because it has to scan further through the *uint32.\n\n\tstruct { string; uint32 }\n\nhas 8 because it can stop immediately after the string pointer.\n",
							Default: "false",
						},
						{
							Name:    "\"httpresponse\"",
							Doc:     "check for mistakes using HTTP responses\n\nA common mistake when using the net/http package is to defer a function\ncall to close the http.Response Body before checking the error that\ndetermines whether the response is valid:\n\n\tresp, err := http.Head(url)\n\tdefer resp.Body.Close()\n\tif err != nil {\n\t\tlog.Fatal(err)\n\t}\n\t// (defer statement belongs here)\n\nThis checker helps uncover latent nil dereference bugs by reporting a\ndiagnostic for such mistakes.",
							Default: "true",
						},
						{
							Name:    "\"ifaceassert\"",
							Doc:     "detect impossible interface-to-interface type assertions\n\nThis checker flags type assertions v.(T) and corresponding type-switch cases\nin which the static type V of v is an interface that cannot possibly implement\nthe target interface T. This occurs when V and T contain methods with the same\nname but different signatures. Example:\n\n\tvar v interface {\n\t\tRead()\n\t}\n\t_ = v.(io.Reader)\n\nThe Read method in v has a different signature than the Read method in\nio.Reader, so this assertion cannot succeed.\n",
							Default: "true",
						},
						{
							Name:    "\"infertypeargs\"",
							Doc:     "check for unnecessary type arguments in call expressions\n\nExplicit type arguments may be omitted from call expressions if they can be\ninferred from function arguments, or from other type arguments:\n\n\tfunc f[T any](T) {}\n\t\n\tfunc _() {\n\t\tf[string](\"foo\") // string could be inferred\n\t}\n",
							Default: "true",
						},
						{
							Name:    "\"loopclosure\"",
							Doc:     "check references to loop variables from within nested functions\n\nThis analyzer checks for references to loop variables from within a\nfunction literal inside the loop body. It checks only instances where\nthe function literal is called in a defer or go statement that is the\nlast statement in the loop body, as otherwise we would need whole\nprogram analysis.\n\nFor example:\n\n\tfor i, v := range s {\n\t\tgo func() {\n\t\t\tprintln(i, v) // not what you might expect\n\t\t}()\n\t}\n\nSee: https://golang.org/doc/go_faq.html#closures_and_goroutines",
							Default: "true",
						},
						{
							Name:    "\"lostcancel\"",
							Doc:     "check cancel func returned by context.WithCancel is called\n\nThe cancellation function returned by context.WithCancel, WithTimeout,\nand WithDeadline must be called or the new context will remain live\nuntil its parent context is cancelled.\n(The background context is never cancelled.)",
							Default: "true",
						},
						{
							Name:    "\"nilfunc\"",
							Doc:     "check for useless comparisons between functions and nil\n\nA useless comparison is one like f == nil as opposed to f() == nil.",
							Default: "true",
						},
						{
							Name:    "\"nilness\"",
							Doc:     "check for redundant or impossible nil comparisons\n\nThe nilness checker inspects the control-flow graph of each function in\na package and reports nil pointer dereferences, degenerate nil\npointers, and panics with nil values. A degenerate comparison is of the form\nx==nil or x!=nil where x is statically known to be nil or non-nil. These are\noften a mistake, especially in control flow related to errors. Panics with nil\nvalues are checked because they are not detectable by\n\n\tif r := recover(); r != nil {\n\nThis check reports conditions such as:\n\n\tif f == nil { // impossible condition (f is a function)\n\t}\n\nand:\n\n\tp := &v\n\t...\n\tif p != nil { // tautological condition\n\t}\n\nand:\n\n\tif p == nil {\n\t\tprint(*p) // nil dereference\n\t}\n\nand:\n\n\tif p == nil {\n\t\tpanic(p)\n\t}\n",
							Default: "false",
						},
						{
							Name:    "\"printf\"",
							Doc:     "check consistency of Printf format strings and arguments\n\nThe check applies to known functions (for example, those in package fmt)\nas well as any detected wrappers of known functions.\n\nA function that wants to avail itself of printf checking but is not\nfound by this analyzer's heuristics (for example, due to use of\ndynamic calls) can insert a bogus call:\n\n\tif false {\n\t\t_ = fmt.Sprintf(format, args...) // enable printf checking\n\t}\n\nThe -funcs flag specifies a comma-separated list of names of additional\nknown formatting functions or methods. If the name contains a period,\nit must denote a specific function using one of the following forms:\n\n\tdir/pkg.Function\n\tdir/pkg.Type.Method\n\t(*dir/pkg.Type).Method\n\nOtherwise the name is interpreted as a case-insensitive unqualified\nidentifier such as \"errorf\". Either way, if a listed name ends in f, the\nfunction is assumed to be Printf-like, taking a format string before the\nargument list. Otherwise it is assumed to be Print-like, taking a list\nof arguments with no format string.\n",
							Default: "true",
						},
						{
							Name:    "\"shadow\"",
							Doc:     "check for possible unintended shadowing of variables\n\nThis analyzer check for shadowed variables.\nA shadowed variable is a variable declared in an inner scope\nwith the same name and type as a variable in an outer scope,\nand where the outer variable is mentioned after the inner one\nis declared.\n\n(This definition can be refined; the module generates too many\nfalse positives and is not yet enabled by default.)\n\nFor example:\n\n\tfunc BadRead(f *os.File, buf []byte) error {\n\t\tvar err error\n\t\tfor {\n\t\t\tn, err := f.Read(buf) // shadows the function variable 'err'\n\t\t\tif err != nil {\n\t\t\t\tbreak // causes return of wrong value\n\t\t\t}\n\t\t\tfoo(buf)\n\t\t}\n\t\treturn err\n\t}\n",
							Default: "false",
						},
						{
							Name:    "\"shift\"",
							Doc:     "check for shifts that equal or exceed the width of the integer",
							Default: "true",
						},
						{
							Name:    "\"simplifycompositelit\"",
							Doc:     "check for composite literal simplifications\n\nAn array, slice, or map composite literal of the form:\n\t[]T{T{}, T{}}\nwill be simplified to:\n\t[]T{{}, {}}\n\nThis is one of the simplifications that \"gofmt -s\" applies.",
							Default: "true",
						},
						{
							Name:    "\"simplifyrange\"",
							Doc:     "check for range statement simplifications\n\nA range of the form:\n\tfor x, _ = range v {...}\nwill be simplified to:\n\tfor x = range v {...}\n\nA range of the form:\n\tfor _ = range v {...}\nwill be simplified to:\n\tfor range v {...}\n\nThis is one of the simplifications that \"gofmt -s\" applies.",
							Default: "true",
						},
						{
							Name:    "\"simplifyslice\"",
							Doc:     "check for slice simplifications\n\nA slice expression of the form:\n\ts[a:len(s)]\nwill be simplified to:\n\ts[a:]\n\nThis is one of the simplifications that \"gofmt -s\" applies.",
							Default: "true",
						},
						{
							Name:    "\"sortslice\"",
							Doc:     "check the argument type of sort.Slice\n\nsort.Slice requires an argument of a slice type. Check that\nthe interface{} value passed to sort.Slice is actually a slice.",
							Default: "true",
						},
						{
							Name:    "\"stdmethods\"",
							Doc:     "check signature of methods of well-known interfaces\n\nSometimes a type may be intended to satisfy an interface but may fail to\ndo so because of a mistake in its method signature.\nFor example, the result of this WriteTo method should be (int64, error),\nnot error, to satisfy io.WriterTo:\n\n\ttype myWriterTo struct{...}\n        func (myWriterTo) WriteTo(w io.Writer) error { ... }\n\nThis check ensures that each method whose name matches one of several\nwell-known interface methods from the standard library has the correct\nsignature for that interface.\n\nChecked method names include:\n\tFormat GobEncode GobDecode MarshalJSON MarshalXML\n\tPeek ReadByte ReadFrom ReadRune Scan Seek\n\tUnmarshalJSON UnreadByte UnreadRune WriteByte\n\tWriteTo\n",
							Default: "true",
						},
						{
							Name:    "\"stringintconv\"",
							Doc:     "check for string(int) conversions\n\nThis checker flags conversions of the form string(x) where x is an integer\n(but not byte or rune) type. Such conversions are discouraged because they\nreturn the UTF-8 representation of the Unicode code point x, and not a decimal\nstring representation of x as one might expect. Furthermore, if x denotes an\ninvalid code point, the conversion cannot be statically rejected.\n\nFor conversions that intend on using the code point, consider replacing them\nwith string(rune(x)). Otherwise, strconv.Itoa and its equivalents return the\nstring representation of the value in the desired base.\n",
							Default: "true",
						},
						{
							Name:    "\"structtag\"",
							Doc:     "check that struct field tags conform to reflect.StructTag.Get\n\nAlso report certain struct tags (json, xml) used with unexported fields.",
							Default: "true",
						},
						{
							Name:    "\"testinggoroutine\"",
							Doc:     "report calls to (*testing.T).Fatal from goroutines started by a test.\n\nFunctions that abruptly terminate a test, such as the Fatal, Fatalf, FailNow, and\nSkip{,f,Now} methods of *testing.T, must be called from the test goroutine itself.\nThis checker detects calls to these functions that occur within a goroutine\nstarted by the test. For example:\n\nfunc TestFoo(t *testing.T) {\n    go func() {\n        t.Fatal(\"oops\") // error: (*T).Fatal called from non-test goroutine\n    }()\n}\n",
							Default: "true",
						},
						{
							Name:    "\"tests\"",
							Doc:     "check for common mistaken usages of tests and examples\n\nThe tests checker walks Test, Benchmark and Example functions checking\nmalformed names, wrong signatures and examples documenting non-existent\nidentifiers.\n\nPlease see the documentation for package testing in golang.org/pkg/testing\nfor the conventions that are enforced for Tests, Benchmarks, and Examples.",
							Default: "true",
						},
						{
							Name:    "\"unmarshal\"",
							Doc:     "report passing non-pointer or non-interface values to unmarshal\n\nThe unmarshal analysis reports calls to functions such as json.Unmarshal\nin which the argument type is not a pointer or an interface.",
							Default: "true",
						},
						{
							Name:    "\"unreachable\"",
							Doc:     "check for unreachable code\n\nThe unreachable analyzer finds statements that execution can never reach\nbecause they are preceded by an return statement, a call to panic, an\ninfinite loop, or similar constructs.",
							Default: "true",
						},
						{
							Name:    "\"unsafeptr\"",
							Doc:     "check for invalid conversions of uintptr to unsafe.Pointer\n\nThe unsafeptr analyzer reports likely incorrect uses of unsafe.Pointer\nto convert integers to pointers. A conversion from uintptr to\nunsafe.Pointer is invalid if it implies that there is a uintptr-typed\nword in memory that holds a pointer value, because that word will be\ninvisible to stack copying and to the garbage collector.",
							Default: "true",
						},
						{
							Name:    "\"unusedparams\"",
							Doc:     "check for unused parameters of functions\n\nThe unusedparams analyzer checks functions to see if there are\nany parameters that are not being used.\n\nTo reduce false positives it ignores:\n- methods\n- parameters that do not have a name or are underscored\n- functions in test files\n- functions with empty bodies or those with just a return stmt",
							Default: "false",
						},
						{
							Name:    "\"unusedresult\"",
							Doc:     "check for unused results of calls to some functions\n\nSome functions like fmt.Errorf return a result and have no side effects,\nso it is always a mistake to discard the result. This analyzer reports\ncalls to certain functions in which the result of the call is ignored.\n\nThe set of functions may be controlled using flags.",
							Default: "true",
						},
						{
							Name:    "\"unusedwrite\"",
							Doc:     "checks for unused writes\n\nThe analyzer reports instances of writes to struct fields and\narrays that are never read. Specifically, when a struct object\nor an array is copied, its elements are copied implicitly by\nthe compiler, and any element write to this copy does nothing\nwith the original object.\n\nFor example:\n\n\ttype T struct { x int }\n\tfunc f(input []T) {\n\t\tfor i, v := range input {  // v is a copy\n\t\t\tv.x = i  // unused write to field x\n\t\t}\n\t}\n\nAnother example is about non-pointer receiver:\n\n\ttype T struct { x int }\n\tfunc (t T) f() {  // t is a copy\n\t\tt.x = i  // unused write to field x\n\t}\n",
							Default: "false",
						},
						{
							Name:    "\"useany\"",
							Doc:     "check for constraints that could be simplified to \"any\"",
							Default: "true",
						},
						{
							Name:    "\"fillreturns\"",
							Doc:     "suggest fixes for errors due to an incorrect number of return values\n\nThis checker provides suggested fixes for type errors of the\ntype \"wrong number of return values (want %d, got %d)\". For example:\n\tfunc m() (int, string, *bool, error) {\n\t\treturn\n\t}\nwill turn into\n\tfunc m() (int, string, *bool, error) {\n\t\treturn 0, \"\", nil, nil\n\t}\n\nThis functionality is similar to https://github.com/sqs/goreturns.\n",
							Default: "true",
						},
						{
							Name:    "\"nonewvars\"",
							Doc:     "suggested fixes for \"no new vars on left side of :=\"\n\nThis checker provides suggested fixes for type errors of the\ntype \"no new vars on left side of :=\". For example:\n\tz := 1\n\tz := 2\nwill turn into\n\tz := 1\n\tz = 2\n",
							Default: "true",
						},
						{
							Name:    "\"noresultvalues\"",
							Doc:     "suggested fixes for unexpected return values\n\nThis checker provides suggested fixes for type errors of the\ntype \"no result values expected\" or \"too many return values\".\nFor example:\n\tfunc z() { return nil }\nwill turn into\n\tfunc z() { return }\n",
							Default: "true",
						},
						{
							Name:    "\"undeclaredname\"",
							Doc:     "suggested fixes for \"undeclared name: <>\"\n\nThis checker provides suggested fixes for type errors of the\ntype \"undeclared name: <>\". It will either insert a new statement,\nsuch as:\n\n\"<> := \"\n\nor a new function declaration, such as:\n\nfunc <>(inferred parameters) {\n\tpanic(\"implement me!\")\n}\n",
							Default: "true",
						},
						{
							Name:    "\"fillstruct\"",
							Doc:     "note incomplete struct initializations\n\nThis analyzer provides diagnostics for any struct literals that do not have\nany fields initialized. Because the suggested fix for this analysis is\nexpensive to compute, callers should compute it separately, using the\nSuggestedFix function below.\n",
							Default: "true",
						},
					},
				},
				Default:   "{}",
				Hierarchy: "ui.diagnostic",
			},
			{
				Name:      "staticcheck",
				Type:      "bool",
				Doc:       "staticcheck enables additional analyses from staticcheck.io.\n",
				Default:   "false",
				Status:    "experimental",
				Hierarchy: "ui.diagnostic",
			},
			{
				Name: "annotations",
				Type: "map[string]bool",
				Doc:  "annotations specifies the various kinds of optimization diagnostics\nthat should be reported by the gc_details command.\n",
				EnumKeys: EnumKeys{
					ValueType: "bool",
					Keys: []EnumKey{
						{
							Name:    "\"bounds\"",
							Doc:     "`\"bounds\"` controls bounds checking diagnostics.\n",
							Default: "true",
						},
						{
							Name:    "\"escape\"",
							Doc:     "`\"escape\"` controls diagnostics about escape choices.\n",
							Default: "true",
						},
						{
							Name:    "\"inline\"",
							Doc:     "`\"inline\"` controls diagnostics about inlining choices.\n",
							Default: "true",
						},
						{
							Name:    "\"nil\"",
							Doc:     "`\"nil\"` controls nil checks.\n",
							Default: "true",
						},
					},
				},
				Default:   "{\"bounds\":true,\"escape\":true,\"inline\":true,\"nil\":true}",
				Status:    "experimental",
				Hierarchy: "ui.diagnostic",
			},
			{
				Name:      "diagnosticsDelay",
				Type:      "time.Duration",
				Doc:       "diagnosticsDelay controls the amount of time that gopls waits\nafter the most recent file modification before computing deep diagnostics.\nSimple diagnostics (parsing and type-checking) are always run immediately\non recently modified packages.\n\nThis option must be set to a valid duration string, for example `\"250ms\"`.\n",
				Default:   "\"250ms\"",
				Status:    "advanced",
				Hierarchy: "ui.diagnostic",
			},
			{
				Name:      "experimentalWatchedFileDelay",
				Type:      "time.Duration",
				Doc:       "experimentalWatchedFileDelay controls the amount of time that gopls waits\nfor additional workspace/didChangeWatchedFiles notifications to arrive,\nbefore processing all such notifications in a single batch. This is\nintended for use by LSP clients that don't support their own batching of\nfile system notifications.\n\nThis option must be set to a valid duration string, for example `\"100ms\"`.\n",
				Default:   "\"0s\"",
				Status:    "experimental",
				Hierarchy: "ui.diagnostic",
			},
			{
				Name: "codelenses",
				Type: "map[string]bool",
				Doc:  "codelenses overrides the enabled/disabled state of code lenses. See the\n\"Code Lenses\" section of the\n[Settings page](https://github.com/golang/tools/blob/master/gopls/doc/settings.md)\nfor the list of supported lenses.\n\nExample Usage:\n\n```json5\n\"gopls\": {\n...\n  \"codelenses\": {\n    \"generate\": false,  // Don't show the `go generate` lens.\n    \"gc_details\": true  // Show a code lens toggling the display of gc's choices.\n  }\n...\n}\n```\n",
				EnumKeys: EnumKeys{
					ValueType: "bool",
					Keys: []EnumKey{
						{
							Name:    "\"gc_details\"",
							Doc:     "Toggle the calculation of gc annotations.",
							Default: "false",
						},
						{
							Name:    "\"generate\"",
							Doc:     "Runs `go generate` for a given directory.",
							Default: "true",
						},
						{
							Name:    "\"regenerate_cgo\"",
							Doc:     "Regenerates cgo definitions.",
							Default: "true",
						},
						{
							Name:    "\"test\"",
							Doc:     "Runs `go test` for a specific set of test or benchmark functions.",
							Default: "false",
						},
						{
							Name:    "\"tidy\"",
							Doc:     "Runs `go mod tidy` for a module.",
							Default: "true",
						},
						{
							Name:    "\"upgrade_dependency\"",
							Doc:     "Upgrades a dependency in the go.mod file for a module.",
							Default: "true",
						},
						{
							Name:    "\"vendor\"",
							Doc:     "Runs `go mod vendor` for a module.",
							Default: "true",
						},
					},
				},
				Default:   "{\"gc_details\":false,\"generate\":true,\"regenerate_cgo\":true,\"tidy\":true,\"upgrade_dependency\":true,\"vendor\":true}",
				Hierarchy: "ui",
			},
			{
				Name:      "semanticTokens",
				Type:      "bool",
				Doc:       "semanticTokens controls whether the LSP server will send\nsemantic tokens to the client.\n",
				Default:   "false",
				Status:    "experimental",
				Hierarchy: "ui",
			},
			{
				Name:      "local",
				Type:      "string",
				Doc:       "local is the equivalent of the `goimports -local` flag, which puts\nimports beginning with this string after third-party packages. It should\nbe the prefix of the import path whose imports should be grouped\nseparately.\n",
				Default:   "\"\"",
				Hierarchy: "formatting",
			},
			{
				Name:      "gofumpt",
				Type:      "bool",
				Doc:       "gofumpt indicates if we should run gofumpt formatting.\n",
				Default:   "false",
				Hierarchy: "formatting",
			},
			{
				Name:    "verboseOutput",
				Type:    "bool",
				Doc:     "verboseOutput enables additional debug logging.\n",
				Default: "false",
				Status:  "debug",
			},
		},
	},
	Commands: []*CommandJSON{
		{
			Command: "gopls.add_dependency",
			Title:   "Add a dependency",
			Doc:     "Adds a dependency to the go.mod file for a module.",
			ArgDoc:  "{\n\t// The go.mod file URI.\n\t\"URI\": string,\n\t// Additional args to pass to the go command.\n\t\"GoCmdArgs\": []string,\n\t// Whether to add a require directive.\n\t\"AddRequire\": bool,\n}",
		},
		{
			Command: "gopls.add_import",
			Title:   "Add an import",
			Doc:     "Ask the server to add an import path to a given Go file.  The method will\ncall applyEdit on the client so that clients don't have to apply the edit\nthemselves.",
			ArgDoc:  "{\n\t// ImportPath is the target import path that should\n\t// be added to the URI file\n\t\"ImportPath\": string,\n\t// URI is the file that the ImportPath should be\n\t// added to\n\t\"URI\": string,\n}",
		},
		{
			Command: "gopls.apply_fix",
			Title:   "Apply a fix",
			Doc:     "Applies a fix to a region of source code.",
			ArgDoc:  "{\n\t// The fix to apply.\n\t\"Fix\": string,\n\t// The file URI for the document to fix.\n\t\"URI\": string,\n\t// The document range to scan for fixes.\n\t\"Range\": {\n\t\t\"start\": {\n\t\t\t\"line\": uint32,\n\t\t\t\"character\": uint32,\n\t\t},\n\t\t\"end\": {\n\t\t\t\"line\": uint32,\n\t\t\t\"character\": uint32,\n\t\t},\n\t},\n}",
		},
		{
			Command: "gopls.check_upgrades",
			Title:   "Check for upgrades",
			Doc:     "Checks for module upgrades.",
			ArgDoc:  "{\n\t// The go.mod file URI.\n\t\"URI\": string,\n\t// The modules to check.\n\t\"Modules\": []string,\n}",
		},
		{
			Command: "gopls.gc_details",
			Title:   "Toggle gc_details",
			Doc:     "Toggle the calculation of gc annotations.",
			ArgDoc:  "string",
		},
		{
			Command: "gopls.generate",
			Title:   "Run go generate",
			Doc:     "Runs `go generate` for a given directory.",
			ArgDoc:  "{\n\t// URI for the directory to generate.\n\t\"Dir\": string,\n\t// Whether to generate recursively (go generate ./...)\n\t\"Recursive\": bool,\n}",
		},
		{
			Command: "gopls.generate_gopls_mod",
			Title:   "Generate gopls.mod",
			Doc:     "(Re)generate the gopls.mod file for a workspace.",
			ArgDoc:  "{\n\t// The file URI.\n\t\"URI\": string,\n}",
		},
		{
			Command: "gopls.go_get_package",
			Title:   "go get a package",
			Doc:     "Runs `go get` to fetch a package.",
			ArgDoc:  "{\n\t// Any document URI within the relevant module.\n\t\"URI\": string,\n\t// The package to go get.\n\t\"Pkg\": string,\n\t\"AddRequire\": bool,\n}",
		},
		{
			Command:   "gopls.list_known_packages",
			Title:     "List known packages",
			Doc:       "Retrieve a list of packages that are importable from the given URI.",
			ArgDoc:    "{\n\t// The file URI.\n\t\"URI\": string,\n}",
			ResultDoc: "{\n\t// Packages is a list of packages relative\n\t// to the URIArg passed by the command request.\n\t// In other words, it omits paths that are already\n\t// imported or cannot be imported due to compiler\n\t// restrictions.\n\t\"Packages\": []string,\n}",
		},
		{
			Command: "gopls.regenerate_cgo",
			Title:   "Regenerate cgo",
			Doc:     "Regenerates cgo definitions.",
			ArgDoc:  "{\n\t// The file URI.\n\t\"URI\": string,\n}",
		},
		{
			Command: "gopls.remove_dependency",
			Title:   "Remove a dependency",
			Doc:     "Removes a dependency from the go.mod file of a module.",
			ArgDoc:  "{\n\t// The go.mod file URI.\n\t\"URI\": string,\n\t// The module path to remove.\n\t\"ModulePath\": string,\n\t\"OnlyDiagnostic\": bool,\n}",
		},
		{
			Command: "gopls.run_tests",
			Title:   "Run test(s)",
			Doc:     "Runs `go test` for a specific set of test or benchmark functions.",
			ArgDoc:  "{\n\t// The test file containing the tests to run.\n\t\"URI\": string,\n\t// Specific test names to run, e.g. TestFoo.\n\t\"Tests\": []string,\n\t// Specific benchmarks to run, e.g. BenchmarkFoo.\n\t\"Benchmarks\": []string,\n}",
		},
		{
			Command:   "gopls.start_debugging",
			Title:     "Start the gopls debug server",
			Doc:       "Start the gopls debug server if it isn't running, and return the debug\naddress.",
			ArgDoc:    "{\n\t// Optional: the address (including port) for the debug server to listen on.\n\t// If not provided, the debug server will bind to \"localhost:0\", and the\n\t// full debug URL will be contained in the result.\n\t// \n\t// If there is more than one gopls instance along the serving path (i.e. you\n\t// are using a daemon), each gopls instance will attempt to start debugging.\n\t// If Addr specifies a port, only the daemon will be able to bind to that\n\t// port, and each intermediate gopls instance will fail to start debugging.\n\t// For this reason it is recommended not to specify a port (or equivalently,\n\t// to specify \":0\").\n\t// \n\t// If the server was already debugging this field has no effect, and the\n\t// result will contain the previously configured debug URL(s).\n\t\"Addr\": string,\n}",
			ResultDoc: "{\n\t// The URLs to use to access the debug servers, for all gopls instances in\n\t// the serving path. For the common case of a single gopls instance (i.e. no\n\t// daemon), this will be exactly one address.\n\t// \n\t// In the case of one or more gopls instances forwarding the LSP to a daemon,\n\t// URLs will contain debug addresses for each server in the serving path, in\n\t// serving order. The daemon debug address will be the last entry in the\n\t// slice. If any intermediate gopls instance fails to start debugging, no\n\t// error will be returned but the debug URL for that server in the URLs slice\n\t// will be empty.\n\t\"URLs\": []string,\n}",
		},
		{
			Command: "gopls.test",
			Title:   "Run test(s) (legacy)",
			Doc:     "Runs `go test` for a specific set of test or benchmark functions.",
			ArgDoc:  "string,\n[]string,\n[]string",
		},
		{
			Command: "gopls.tidy",
			Title:   "Run go mod tidy",
			Doc:     "Runs `go mod tidy` for a module.",
			ArgDoc:  "{\n\t// The file URIs.\n\t\"URIs\": []string,\n}",
		},
		{
			Command: "gopls.toggle_gc_details",
			Title:   "Toggle gc_details",
			Doc:     "Toggle the calculation of gc annotations.",
			ArgDoc:  "{\n\t// The file URI.\n\t\"URI\": string,\n}",
		},
		{
			Command: "gopls.update_go_sum",
			Title:   "Update go.sum",
			Doc:     "Updates the go.sum file for a module.",
			ArgDoc:  "{\n\t// The file URIs.\n\t\"URIs\": []string,\n}",
		},
		{
			Command: "gopls.upgrade_dependency",
			Title:   "Upgrade a dependency",
			Doc:     "Upgrades a dependency in the go.mod file for a module.",
			ArgDoc:  "{\n\t// The go.mod file URI.\n\t\"URI\": string,\n\t// Additional args to pass to the go command.\n\t\"GoCmdArgs\": []string,\n\t// Whether to add a require directive.\n\t\"AddRequire\": bool,\n}",
		},
		{
			Command: "gopls.vendor",
			Title:   "Run go mod vendor",
			Doc:     "Runs `go mod vendor` for a module.",
			ArgDoc:  "{\n\t// The file URI.\n\t\"URI\": string,\n}",
		},
		{
			Command:   "gopls.workspace_metadata",
			Title:     "Query workspace metadata",
			Doc:       "Query the server for information about active workspaces.",
			ResultDoc: "{\n\t// All workspaces for this session.\n\t\"Workspaces\": []{\n\t\t\"Name\": string,\n\t\t\"ModuleDir\": string,\n\t},\n}",
		},
	},
	Lenses: []*LensJSON{
		{
			Lens:  "gc_details",
			Title: "Toggle gc_details",
			Doc:   "Toggle the calculation of gc annotations.",
		},
		{
			Lens:  "generate",
			Title: "Run go generate",
			Doc:   "Runs `go generate` for a given directory.",
		},
		{
			Lens:  "regenerate_cgo",
			Title: "Regenerate cgo",
			Doc:   "Regenerates cgo definitions.",
		},
		{
			Lens:  "test",
			Title: "Run test(s) (legacy)",
			Doc:   "Runs `go test` for a specific set of test or benchmark functions.",
		},
		{
			Lens:  "tidy",
			Title: "Run go mod tidy",
			Doc:   "Runs `go mod tidy` for a module.",
		},
		{
			Lens:  "upgrade_dependency",
			Title: "Upgrade a dependency",
			Doc:   "Upgrades a dependency in the go.mod file for a module.",
		},
		{
			Lens:  "vendor",
			Title: "Run go mod vendor",
			Doc:   "Runs `go mod vendor` for a module.",
		},
	},
	Analyzers: []*AnalyzerJSON{
		{
			Name:    "asmdecl",
			Doc:     "report mismatches between assembly files and Go declarations",
			Default: true,
		},
		{
			Name:    "assign",
			Doc:     "check for useless assignments\n\nThis checker reports assignments of the form x = x or a[i] = a[i].\nThese are almost always useless, and even when they aren't they are\nusually a mistake.",
			Default: true,
		},
		{
			Name:    "atomic",
			Doc:     "check for common mistakes using the sync/atomic package\n\nThe atomic checker looks for assignment statements of the form:\n\n\tx = atomic.AddUint64(&x, 1)\n\nwhich are not atomic.",
			Default: true,
		},
		{
			Name:    "atomicalign",
			Doc:     "check for non-64-bits-aligned arguments to sync/atomic functions",
			Default: true,
		},
		{
			Name:    "bools",
			Doc:     "check for common mistakes involving boolean operators",
			Default: true,
		},
		{
			Name:    "buildtag",
			Doc:     "check that +build tags are well-formed and correctly located",
			Default: true,
		},
		{
			Name:    "cgocall",
			Doc:     "detect some violations of the cgo pointer passing rules\n\nCheck for invalid cgo pointer passing.\nThis looks for code that uses cgo to call C code passing values\nwhose types are almost always invalid according to the cgo pointer\nsharing rules.\nSpecifically, it warns about attempts to pass a Go chan, map, func,\nor slice to C, either directly, or via a pointer, array, or struct.",
			Default: true,
		},
		{
			Name:    "composites",
			Doc:     "check for unkeyed composite literals\n\nThis analyzer reports a diagnostic for composite literals of struct\ntypes imported from another package that do not use the field-keyed\nsyntax. Such literals are fragile because the addition of a new field\n(even if unexported) to the struct will cause compilation to fail.\n\nAs an example,\n\n\terr = &net.DNSConfigError{err}\n\nshould be replaced by:\n\n\terr = &net.DNSConfigError{Err: err}\n",
			Default: true,
		},
		{
			Name:    "copylocks",
			Doc:     "check for locks erroneously passed by value\n\nInadvertently copying a value containing a lock, such as sync.Mutex or\nsync.WaitGroup, may cause both copies to malfunction. Generally such\nvalues should be referred to through a pointer.",
			Default: true,
		},
		{
			Name:    "deepequalerrors",
			Doc:     "check for calls of reflect.DeepEqual on error values\n\nThe deepequalerrors checker looks for calls of the form:\n\n    reflect.DeepEqual(err1, err2)\n\nwhere err1 and err2 are errors. Using reflect.DeepEqual to compare\nerrors is discouraged.",
			Default: true,
		},
		{
			Name:    "errorsas",
			Doc:     "report passing non-pointer or non-error values to errors.As\n\nThe errorsas analysis reports calls to errors.As where the type\nof the second argument is not a pointer to a type implementing error.",
			Default: true,
		},
		{
			Name: "fieldalignment",
			Doc:  "find structs that would use less memory if their fields were sorted\n\nThis analyzer find structs that can be rearranged to use less memory, and provides\na suggested edit with the optimal order.\n\nNote that there are two different diagnostics reported. One checks struct size,\nand the other reports \"pointer bytes\" used. Pointer bytes is how many bytes of the\nobject that the garbage collector has to potentially scan for pointers, for example:\n\n\tstruct { uint32; string }\n\nhave 16 pointer bytes because the garbage collector has to scan up through the string's\ninner pointer.\n\n\tstruct { string; *uint32 }\n\nhas 24 pointer bytes because it has to scan further through the *uint32.\n\n\tstruct { string; uint32 }\n\nhas 8 because it can stop immediately after the string pointer.\n",
		},
		{
			Name:    "httpresponse",
			Doc:     "check for mistakes using HTTP responses\n\nA common mistake when using the net/http package is to defer a function\ncall to close the http.Response Body before checking the error that\ndetermines whether the response is valid:\n\n\tresp, err := http.Head(url)\n\tdefer resp.Body.Close()\n\tif err != nil {\n\t\tlog.Fatal(err)\n\t}\n\t// (defer statement belongs here)\n\nThis checker helps uncover latent nil dereference bugs by reporting a\ndiagnostic for such mistakes.",
			Default: true,
		},
		{
			Name:    "ifaceassert",
			Doc:     "detect impossible interface-to-interface type assertions\n\nThis checker flags type assertions v.(T) and corresponding type-switch cases\nin which the static type V of v is an interface that cannot possibly implement\nthe target interface T. This occurs when V and T contain methods with the same\nname but different signatures. Example:\n\n\tvar v interface {\n\t\tRead()\n\t}\n\t_ = v.(io.Reader)\n\nThe Read method in v has a different signature than the Read method in\nio.Reader, so this assertion cannot succeed.\n",
			Default: true,
		},
		{
			Name:    "infertypeargs",
			Doc:     "check for unnecessary type arguments in call expressions\n\nExplicit type arguments may be omitted from call expressions if they can be\ninferred from function arguments, or from other type arguments:\n\n\tfunc f[T any](T) {}\n\t\n\tfunc _() {\n\t\tf[string](\"foo\") // string could be inferred\n\t}\n",
			Default: true,
		},
		{
			Name:    "loopclosure",
			Doc:     "check references to loop variables from within nested functions\n\nThis analyzer checks for references to loop variables from within a\nfunction literal inside the loop body. It checks only instances where\nthe function literal is called in a defer or go statement that is the\nlast statement in the loop body, as otherwise we would need whole\nprogram analysis.\n\nFor example:\n\n\tfor i, v := range s {\n\t\tgo func() {\n\t\t\tprintln(i, v) // not what you might expect\n\t\t}()\n\t}\n\nSee: https://golang.org/doc/go_faq.html#closures_and_goroutines",
			Default: true,
		},
		{
			Name:    "lostcancel",
			Doc:     "check cancel func returned by context.WithCancel is called\n\nThe cancellation function returned by context.WithCancel, WithTimeout,\nand WithDeadline must be called or the new context will remain live\nuntil its parent context is cancelled.\n(The background context is never cancelled.)",
			Default: true,
		},
		{
			Name:    "nilfunc",
			Doc:     "check for useless comparisons between functions and nil\n\nA useless comparison is one like f == nil as opposed to f() == nil.",
			Default: true,
		},
		{
			Name: "nilness",
			Doc:  "check for redundant or impossible nil comparisons\n\nThe nilness checker inspects the control-flow graph of each function in\na package and reports nil pointer dereferences, degenerate nil\npointers, and panics with nil values. A degenerate comparison is of the form\nx==nil or x!=nil where x is statically known to be nil or non-nil. These are\noften a mistake, especially in control flow related to errors. Panics with nil\nvalues are checked because they are not detectable by\n\n\tif r := recover(); r != nil {\n\nThis check reports conditions such as:\n\n\tif f == nil { // impossible condition (f is a function)\n\t}\n\nand:\n\n\tp := &v\n\t...\n\tif p != nil { // tautological condition\n\t}\n\nand:\n\n\tif p == nil {\n\t\tprint(*p) // nil dereference\n\t}\n\nand:\n\n\tif p == nil {\n\t\tpanic(p)\n\t}\n",
		},
		{
			Name:    "printf",
			Doc:     "check consistency of Printf format strings and arguments\n\nThe check applies to known functions (for example, those in package fmt)\nas well as any detected wrappers of known functions.\n\nA function that wants to avail itself of printf checking but is not\nfound by this analyzer's heuristics (for example, due to use of\ndynamic calls) can insert a bogus call:\n\n\tif false {\n\t\t_ = fmt.Sprintf(format, args...) // enable printf checking\n\t}\n\nThe -funcs flag specifies a comma-separated list of names of additional\nknown formatting functions or methods. If the name contains a period,\nit must denote a specific function using one of the following forms:\n\n\tdir/pkg.Function\n\tdir/pkg.Type.Method\n\t(*dir/pkg.Type).Method\n\nOtherwise the name is interpreted as a case-insensitive unqualified\nidentifier such as \"errorf\". Either way, if a listed name ends in f, the\nfunction is assumed to be Printf-like, taking a format string before the\nargument list. Otherwise it is assumed to be Print-like, taking a list\nof arguments with no format string.\n",
			Default: true,
		},
		{
			Name: "shadow",
			Doc:  "check for possible unintended shadowing of variables\n\nThis analyzer check for shadowed variables.\nA shadowed variable is a variable declared in an inner scope\nwith the same name and type as a variable in an outer scope,\nand where the outer variable is mentioned after the inner one\nis declared.\n\n(This definition can be refined; the module generates too many\nfalse positives and is not yet enabled by default.)\n\nFor example:\n\n\tfunc BadRead(f *os.File, buf []byte) error {\n\t\tvar err error\n\t\tfor {\n\t\t\tn, err := f.Read(buf) // shadows the function variable 'err'\n\t\t\tif err != nil {\n\t\t\t\tbreak // causes return of wrong value\n\t\t\t}\n\t\t\tfoo(buf)\n\t\t}\n\t\treturn err\n\t}\n",
		},
		{
			Name:    "shift",
			Doc:     "check for shifts that equal or exceed the width of the integer",
			Default: true,
		},
		{
			Name:    "simplifycompositelit",
			Doc:     "check for composite literal simplifications\n\nAn array, slice, or map composite literal of the form:\n\t[]T{T{}, T{}}\nwill be simplified to:\n\t[]T{{}, {}}\n\nThis is one of the simplifications that \"gofmt -s\" applies.",
			Default: true,
		},
		{
			Name:    "simplifyrange",
			Doc:     "check for range statement simplifications\n\nA range of the form:\n\tfor x, _ = range v {...}\nwill be simplified to:\n\tfor x = range v {...}\n\nA range of the form:\n\tfor _ = range v {...}\nwill be simplified to:\n\tfor range v {...}\n\nThis is one of the simplifications that \"gofmt -s\" applies.",
			Default: true,
		},
		{
			Name:    "simplifyslice",
			Doc:     "check for slice simplifications\n\nA slice expression of the form:\n\ts[a:len(s)]\nwill be simplified to:\n\ts[a:]\n\nThis is one of the simplifications that \"gofmt -s\" applies.",
			Default: true,
		},
		{
			Name:    "sortslice",
			Doc:     "check the argument type of sort.Slice\n\nsort.Slice requires an argument of a slice type. Check that\nthe interface{} value passed to sort.Slice is actually a slice.",
			Default: true,
		},
		{
			Name:    "stdmethods",
			Doc:     "check signature of methods of well-known interfaces\n\nSometimes a type may be intended to satisfy an interface but may fail to\ndo so because of a mistake in its method signature.\nFor example, the result of this WriteTo method should be (int64, error),\nnot error, to satisfy io.WriterTo:\n\n\ttype myWriterTo struct{...}\n        func (myWriterTo) WriteTo(w io.Writer) error { ... }\n\nThis check ensures that each method whose name matches one of several\nwell-known interface methods from the standard library has the correct\nsignature for that interface.\n\nChecked method names include:\n\tFormat GobEncode GobDecode MarshalJSON MarshalXML\n\tPeek ReadByte ReadFrom ReadRune Scan Seek\n\tUnmarshalJSON UnreadByte UnreadRune WriteByte\n\tWriteTo\n",
			Default: true,
		},
		{
			Name:    "stringintconv",
			Doc:     "check for string(int) conversions\n\nThis checker flags conversions of the form string(x) where x is an integer\n(but not byte or rune) type. Such conversions are discouraged because they\nreturn the UTF-8 representation of the Unicode code point x, and not a decimal\nstring representation of x as one might expect. Furthermore, if x denotes an\ninvalid code point, the conversion cannot be statically rejected.\n\nFor conversions that intend on using the code point, consider replacing them\nwith string(rune(x)). Otherwise, strconv.Itoa and its equivalents return the\nstring representation of the value in the desired base.\n",
			Default: true,
		},
		{
			Name:    "structtag",
			Doc:     "check that struct field tags conform to reflect.StructTag.Get\n\nAlso report certain struct tags (json, xml) used with unexported fields.",
			Default: true,
		},
		{
			Name:    "testinggoroutine",
			Doc:     "report calls to (*testing.T).Fatal from goroutines started by a test.\n\nFunctions that abruptly terminate a test, such as the Fatal, Fatalf, FailNow, and\nSkip{,f,Now} methods of *testing.T, must be called from the test goroutine itself.\nThis checker detects calls to these functions that occur within a goroutine\nstarted by the test. For example:\n\nfunc TestFoo(t *testing.T) {\n    go func() {\n        t.Fatal(\"oops\") // error: (*T).Fatal called from non-test goroutine\n    }()\n}\n",
			Default: true,
		},
		{
			Name:    "tests",
			Doc:     "check for common mistaken usages of tests and examples\n\nThe tests checker walks Test, Benchmark and Example functions checking\nmalformed names, wrong signatures and examples documenting non-existent\nidentifiers.\n\nPlease see the documentation for package testing in golang.org/pkg/testing\nfor the conventions that are enforced for Tests, Benchmarks, and Examples.",
			Default: true,
		},
		{
			Name:    "unmarshal",
			Doc:     "report passing non-pointer or non-interface values to unmarshal\n\nThe unmarshal analysis reports calls to functions such as json.Unmarshal\nin which the argument type is not a pointer or an interface.",
			Default: true,
		},
		{
			Name:    "unreachable",
			Doc:     "check for unreachable code\n\nThe unreachable analyzer finds statements that execution can never reach\nbecause they are preceded by an return statement, a call to panic, an\ninfinite loop, or similar constructs.",
			Default: true,
		},
		{
			Name:    "unsafeptr",
			Doc:     "check for invalid conversions of uintptr to unsafe.Pointer\n\nThe unsafeptr analyzer reports likely incorrect uses of unsafe.Pointer\nto convert integers to pointers. A conversion from uintptr to\nunsafe.Pointer is invalid if it implies that there is a uintptr-typed\nword in memory that holds a pointer value, because that word will be\ninvisible to stack copying and to the garbage collector.",
			Default: true,
		},
		{
			Name: "unusedparams",
			Doc:  "check for unused parameters of functions\n\nThe unusedparams analyzer checks functions to see if there are\nany parameters that are not being used.\n\nTo reduce false positives it ignores:\n- methods\n- parameters that do not have a name or are underscored\n- functions in test files\n- functions with empty bodies or those with just a return stmt",
		},
		{
			Name:    "unusedresult",
			Doc:     "check for unused results of calls to some functions\n\nSome functions like fmt.Errorf return a result and have no side effects,\nso it is always a mistake to discard the result. This analyzer reports\ncalls to certain functions in which the result of the call is ignored.\n\nThe set of functions may be controlled using flags.",
			Default: true,
		},
		{
			Name: "unusedwrite",
			Doc:  "checks for unused writes\n\nThe analyzer reports instances of writes to struct fields and\narrays that are never read. Specifically, when a struct object\nor an array is copied, its elements are copied implicitly by\nthe compiler, and any element write to this copy does nothing\nwith the original object.\n\nFor example:\n\n\ttype T struct { x int }\n\tfunc f(input []T) {\n\t\tfor i, v := range input {  // v is a copy\n\t\t\tv.x = i  // unused write to field x\n\t\t}\n\t}\n\nAnother example is about non-pointer receiver:\n\n\ttype T struct { x int }\n\tfunc (t T) f() {  // t is a copy\n\t\tt.x = i  // unused write to field x\n\t}\n",
		},
		{
			Name:    "useany",
			Doc:     "check for constraints that could be simplified to \"any\"",
			Default: true,
		},
		{
			Name:    "fillreturns",
			Doc:     "suggest fixes for errors due to an incorrect number of return values\n\nThis checker provides suggested fixes for type errors of the\ntype \"wrong number of return values (want %d, got %d)\". For example:\n\tfunc m() (int, string, *bool, error) {\n\t\treturn\n\t}\nwill turn into\n\tfunc m() (int, string, *bool, error) {\n\t\treturn 0, \"\", nil, nil\n\t}\n\nThis functionality is similar to https://github.com/sqs/goreturns.\n",
			Default: true,
		},
		{
			Name:    "nonewvars",
			Doc:     "suggested fixes for \"no new vars on left side of :=\"\n\nThis checker provides suggested fixes for type errors of the\ntype \"no new vars on left side of :=\". For example:\n\tz := 1\n\tz := 2\nwill turn into\n\tz := 1\n\tz = 2\n",
			Default: true,
		},
		{
			Name:    "noresultvalues",
			Doc:     "suggested fixes for unexpected return values\n\nThis checker provides suggested fixes for type errors of the\ntype \"no result values expected\" or \"too many return values\".\nFor example:\n\tfunc z() { return nil }\nwill turn into\n\tfunc z() { return }\n",
			Default: true,
		},
		{
			Name:    "undeclaredname",
			Doc:     "suggested fixes for \"undeclared name: <>\"\n\nThis checker provides suggested fixes for type errors of the\ntype \"undeclared name: <>\". It will either insert a new statement,\nsuch as:\n\n\"<> := \"\n\nor a new function declaration, such as:\n\nfunc <>(inferred parameters) {\n\tpanic(\"implement me!\")\n}\n",
			Default: true,
		},
		{
			Name:    "fillstruct",
			Doc:     "note incomplete struct initializations\n\nThis analyzer provides diagnostics for any struct literals that do not have\nany fields initialized. Because the suggested fix for this analysis is\nexpensive to compute, callers should compute it separately, using the\nSuggestedFix function below.\n",
			Default: true,
		},
	},
}
