package authorization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleEligibilitySchedulesClient is the client for the RoleEligibilitySchedules methods of the Authorization service.
type RoleEligibilitySchedulesClient struct {
	BaseClient
}

// NewRoleEligibilitySchedulesClient creates an instance of the RoleEligibilitySchedulesClient client.
func NewRoleEligibilitySchedulesClient(subscriptionID string) RoleEligibilitySchedulesClient {
	return NewRoleEligibilitySchedulesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRoleEligibilitySchedulesClientWithBaseURI creates an instance of the RoleEligibilitySchedulesClient client using
// a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign
// clouds, Azure stack).
func NewRoleEligibilitySchedulesClientWithBaseURI(baseURI string, subscriptionID string) RoleEligibilitySchedulesClient {
	return RoleEligibilitySchedulesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get get the specified role eligibility schedule for a resource scope
// Parameters:
// scope - the scope of the role eligibility schedule.
// roleEligibilityScheduleName - the name (guid) of the role eligibility schedule to get.
func (client RoleEligibilitySchedulesClient) Get(ctx context.Context, scope string, roleEligibilityScheduleName string) (result RoleEligibilitySchedule, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilitySchedulesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, roleEligibilityScheduleName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RoleEligibilitySchedulesClient) GetPreparer(ctx context.Context, scope string, roleEligibilityScheduleName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleEligibilityScheduleName": autorest.Encode("path", roleEligibilityScheduleName),
		"scope":                       scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilitySchedules/{roleEligibilityScheduleName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilitySchedulesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RoleEligibilitySchedulesClient) GetResponder(resp *http.Response) (result RoleEligibilitySchedule, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListForScope gets role eligibility schedules for a resource scope.
// Parameters:
// scope - the scope of the role eligibility schedules.
// filter - the filter to apply on the operation. Use $filter=atScope() to return all role eligibility
// schedules at or above the scope. Use $filter=principalId eq {id} to return all role eligibility schedules
// at, above or below the scope for the specified principal. Use $filter=assignedTo('{userId}') to return all
// role eligibility schedules for the user. Use $filter=asTarget() to return all role eligibility schedules
// created for the current user.
func (client RoleEligibilitySchedulesClient) ListForScope(ctx context.Context, scope string, filter string) (result RoleEligibilityScheduleListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilitySchedulesClient.ListForScope")
		defer func() {
			sc := -1
			if result.reslr.Response.Response != nil {
				sc = result.reslr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listForScopeNextResults
	req, err := client.ListForScopePreparer(ctx, scope, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "ListForScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.reslr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "ListForScope", resp, "Failure sending request")
		return
	}

	result.reslr, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "ListForScope", resp, "Failure responding to request")
		return
	}
	if result.reslr.hasNextLink() && result.reslr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForScopePreparer prepares the ListForScope request.
func (client RoleEligibilitySchedulesClient) ListForScopePreparer(ctx context.Context, scope string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilitySchedules", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForScopeSender sends the ListForScope request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilitySchedulesClient) ListForScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForScopeResponder handles the response to the ListForScope request. The method always
// closes the http.Response Body.
func (client RoleEligibilitySchedulesClient) ListForScopeResponder(resp *http.Response) (result RoleEligibilityScheduleListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForScopeNextResults retrieves the next set of results, if any.
func (client RoleEligibilitySchedulesClient) listForScopeNextResults(ctx context.Context, lastResults RoleEligibilityScheduleListResult) (result RoleEligibilityScheduleListResult, err error) {
	req, err := lastResults.roleEligibilityScheduleListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "listForScopeNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "listForScopeNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilitySchedulesClient", "listForScopeNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForScopeComplete enumerates all values, automatically crossing page boundaries as required.
func (client RoleEligibilitySchedulesClient) ListForScopeComplete(ctx context.Context, scope string, filter string) (result RoleEligibilityScheduleListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilitySchedulesClient.ListForScope")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForScope(ctx, scope, filter)
	return
}
