/* timer.c generated by valac 0.22.0.21-8a007, the Vala compiler
 * generated from timer.vala, do not modify */

/*
 * Copyright (C) 2013  Paolo Borelli <pborelli@gnome.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define CLOCKS_TYPE_ANALOG_FRAME (clocks_analog_frame_get_type ())
#define CLOCKS_ANALOG_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrame))
#define CLOCKS_ANALOG_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrameClass))
#define CLOCKS_IS_ANALOG_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_ANALOG_FRAME))
#define CLOCKS_IS_ANALOG_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_ANALOG_FRAME))
#define CLOCKS_ANALOG_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_ANALOG_FRAME, ClocksAnalogFrameClass))

typedef struct _ClocksAnalogFrame ClocksAnalogFrame;
typedef struct _ClocksAnalogFrameClass ClocksAnalogFrameClass;
typedef struct _ClocksAnalogFramePrivate ClocksAnalogFramePrivate;

#define CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME (clocks_timer_countdown_frame_get_type ())
#define CLOCKS_TIMER_COUNTDOWN_FRAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrame))
#define CLOCKS_TIMER_COUNTDOWN_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrameClass))
#define CLOCKS_TIMER_IS_COUNTDOWN_FRAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME))
#define CLOCKS_TIMER_IS_COUNTDOWN_FRAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME))
#define CLOCKS_TIMER_COUNTDOWN_FRAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrameClass))

typedef struct _ClocksTimerCountdownFrame ClocksTimerCountdownFrame;
typedef struct _ClocksTimerCountdownFrameClass ClocksTimerCountdownFrameClass;
typedef struct _ClocksTimerCountdownFramePrivate ClocksTimerCountdownFramePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define CLOCKS_TYPE_CLOCK (clocks_clock_get_type ())
#define CLOCKS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_CLOCK, ClocksClock))
#define CLOCKS_IS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_CLOCK))
#define CLOCKS_CLOCK_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), CLOCKS_TYPE_CLOCK, ClocksClockIface))

typedef struct _ClocksClock ClocksClock;
typedef struct _ClocksClockIface ClocksClockIface;

#define CLOCKS_TYPE_HEADER_BAR (clocks_header_bar_get_type ())
#define CLOCKS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBar))
#define CLOCKS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))
#define CLOCKS_IS_HEADER_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_IS_HEADER_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TYPE_HEADER_BAR))
#define CLOCKS_HEADER_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TYPE_HEADER_BAR, ClocksHeaderBarClass))

typedef struct _ClocksHeaderBar ClocksHeaderBar;
typedef struct _ClocksHeaderBarClass ClocksHeaderBarClass;

#define CLOCKS_TYPE_PANEL_ID (clocks_panel_id_get_type ())

#define CLOCKS_TIMER_TYPE_MAIN_PANEL (clocks_timer_main_panel_get_type ())
#define CLOCKS_TIMER_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_TIMER_TYPE_MAIN_PANEL, ClocksTimerMainPanel))
#define CLOCKS_TIMER_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_TIMER_TYPE_MAIN_PANEL, ClocksTimerMainPanelClass))
#define CLOCKS_TIMER_IS_MAIN_PANEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_TIMER_TYPE_MAIN_PANEL))
#define CLOCKS_TIMER_IS_MAIN_PANEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_TIMER_TYPE_MAIN_PANEL))
#define CLOCKS_TIMER_MAIN_PANEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_TIMER_TYPE_MAIN_PANEL, ClocksTimerMainPanelClass))

typedef struct _ClocksTimerMainPanel ClocksTimerMainPanel;
typedef struct _ClocksTimerMainPanelClass ClocksTimerMainPanelClass;
typedef struct _ClocksTimerMainPanelPrivate ClocksTimerMainPanelPrivate;

#define CLOCKS_TIMER_MAIN_PANEL_TYPE_STATE (clocks_timer_main_panel_state_get_type ())

#define CLOCKS_UTILS_TYPE_BELL (clocks_utils_bell_get_type ())
#define CLOCKS_UTILS_BELL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBell))
#define CLOCKS_UTILS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))
#define CLOCKS_UTILS_IS_BELL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_IS_BELL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CLOCKS_UTILS_TYPE_BELL))
#define CLOCKS_UTILS_BELL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CLOCKS_UTILS_TYPE_BELL, ClocksUtilsBellClass))

typedef struct _ClocksUtilsBell ClocksUtilsBell;
typedef struct _ClocksUtilsBellClass ClocksUtilsBellClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _ClocksAnalogFrame {
	GtkFrame parent_instance;
	ClocksAnalogFramePrivate * priv;
};

struct _ClocksAnalogFrameClass {
	GtkFrameClass parent_class;
	void (*draw_progress) (ClocksAnalogFrame* self, cairo_t* cr, gint center_x, gint center_y, gint radius);
};

struct _ClocksTimerCountdownFrame {
	ClocksAnalogFrame parent_instance;
	ClocksTimerCountdownFramePrivate * priv;
};

struct _ClocksTimerCountdownFrameClass {
	ClocksAnalogFrameClass parent_class;
};

struct _ClocksTimerCountdownFramePrivate {
	gdouble _span;
	gdouble elapsed;
	gdouble elapsed_before_pause;
};

typedef enum  {
	CLOCKS_PANEL_ID_WORLD,
	CLOCKS_PANEL_ID_ALARM,
	CLOCKS_PANEL_ID_STOPWATCH,
	CLOCKS_PANEL_ID_TIMER
} ClocksPanelId;

struct _ClocksClockIface {
	GTypeInterface parent_iface;
	void (*activate_new) (ClocksClock* self);
	void (*activate_select_all) (ClocksClock* self);
	void (*activate_select_none) (ClocksClock* self);
	gboolean (*escape_pressed) (ClocksClock* self);
	void (*update_header_bar) (ClocksClock* self);
	const gchar* (*get_label) (ClocksClock* self);
	void (*set_label) (ClocksClock* self, const gchar* value);
	ClocksHeaderBar* (*get_header_bar) (ClocksClock* self);
	void (*set_header_bar) (ClocksClock* self, ClocksHeaderBar* value);
	ClocksPanelId (*get_panel_id) (ClocksClock* self);
	void (*set_panel_id) (ClocksClock* self, ClocksPanelId value);
};

struct _ClocksTimerMainPanel {
	GtkStack parent_instance;
	ClocksTimerMainPanelPrivate * priv;
};

struct _ClocksTimerMainPanelClass {
	GtkStackClass parent_class;
	void (*ring) (ClocksTimerMainPanel* self);
};

typedef enum  {
	CLOCKS_TIMER_MAIN_PANEL_STATE_STOPPED,
	CLOCKS_TIMER_MAIN_PANEL_STATE_RUNNING,
	CLOCKS_TIMER_MAIN_PANEL_STATE_PAUSED
} ClocksTimerMainPanelState;

struct _ClocksTimerMainPanelPrivate {
	gchar* _label;
	ClocksHeaderBar* _header_bar;
	ClocksPanelId _panel_id;
	ClocksTimerMainPanelState state;
	GSettings* settings;
	guint tick_id;
	gdouble span;
	GTimer* timer;
	ClocksUtilsBell* bell;
	ClocksAnalogFrame* setup_frame;
	GtkGrid* grid_spinbuttons;
	GtkSpinButton* h_spinbutton;
	GtkSpinButton* m_spinbutton;
	GtkSpinButton* s_spinbutton;
	GtkButton* start_button;
	ClocksTimerCountdownFrame* countdown_frame;
	GtkLabel* countdown_label;
	GtkButton* left_button;
};


static gpointer clocks_timer_countdown_frame_parent_class = NULL;
static gpointer clocks_timer_main_panel_parent_class = NULL;
static ClocksClockIface* clocks_timer_main_panel_clocks_clock_parent_iface = NULL;

GType clocks_analog_frame_get_type (void) G_GNUC_CONST;
GType clocks_timer_countdown_frame_get_type (void) G_GNUC_CONST;
#define CLOCKS_TIMER_COUNTDOWN_FRAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFramePrivate))
enum  {
	CLOCKS_TIMER_COUNTDOWN_FRAME_DUMMY_PROPERTY,
	CLOCKS_TIMER_COUNTDOWN_FRAME_SPAN
};
static gdouble clocks_timer_countdown_frame_get_progress (ClocksTimerCountdownFrame* self);
gdouble clocks_timer_countdown_frame_get_span (ClocksTimerCountdownFrame* self);
void clocks_timer_countdown_frame_update (ClocksTimerCountdownFrame* self, gdouble e);
void clocks_timer_countdown_frame_pause (ClocksTimerCountdownFrame* self);
void clocks_timer_countdown_frame_reset (ClocksTimerCountdownFrame* self);
static void clocks_timer_countdown_frame_real_draw_progress (ClocksAnalogFrame* base, cairo_t* cr, gint center_x, gint center_y, gint radius);
#define CLOCKS_ANALOG_FRAME_LINE_WIDTH 6
ClocksTimerCountdownFrame* clocks_timer_countdown_frame_new (void);
ClocksTimerCountdownFrame* clocks_timer_countdown_frame_construct (GType object_type);
ClocksAnalogFrame* clocks_analog_frame_new (void);
ClocksAnalogFrame* clocks_analog_frame_construct (GType object_type);
void clocks_timer_countdown_frame_set_span (ClocksTimerCountdownFrame* self, gdouble value);
static void clocks_timer_countdown_frame_finalize (GObject* obj);
static void _vala_clocks_timer_countdown_frame_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_clocks_timer_countdown_frame_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType clocks_header_bar_get_type (void) G_GNUC_CONST;
GType clocks_panel_id_get_type (void) G_GNUC_CONST;
GType clocks_clock_get_type (void) G_GNUC_CONST;
GType clocks_timer_main_panel_get_type (void) G_GNUC_CONST;
static GType clocks_timer_main_panel_state_get_type (void) G_GNUC_UNUSED;
GType clocks_utils_bell_get_type (void) G_GNUC_CONST;
#define CLOCKS_TIMER_MAIN_PANEL_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), CLOCKS_TIMER_TYPE_MAIN_PANEL, ClocksTimerMainPanelPrivate))
enum  {
	CLOCKS_TIMER_MAIN_PANEL_DUMMY_PROPERTY,
	CLOCKS_TIMER_MAIN_PANEL_LABEL,
	CLOCKS_TIMER_MAIN_PANEL_HEADER_BAR,
	CLOCKS_TIMER_MAIN_PANEL_PANEL_ID
};
ClocksTimerMainPanel* clocks_timer_main_panel_new (ClocksHeaderBar* header_bar);
ClocksTimerMainPanel* clocks_timer_main_panel_construct (GType object_type, ClocksHeaderBar* header_bar);
ClocksUtilsBell* clocks_utils_bell_new (const gchar* soundid, const gchar* title, const gchar* msg);
ClocksUtilsBell* clocks_utils_bell_construct (GType object_type, const gchar* soundid, const gchar* title, const gchar* msg);
static void clocks_timer_main_panel_reset (ClocksTimerMainPanel* self);
static gboolean clocks_timer_main_panel_show_leading_zeros (ClocksTimerMainPanel* self, GtkSpinButton* spin_button);
static gboolean _clocks_timer_main_panel_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender, gpointer self);
static void clocks_timer_main_panel_update_start_button (ClocksTimerMainPanel* self);
static void _clocks_timer_main_panel_update_start_button_gtk_editable_changed (GtkEditable* _sender, gpointer self);
static void clocks_timer_main_panel_on_start_button_clicked (ClocksTimerMainPanel* self);
static void clocks_timer_main_panel_start (ClocksTimerMainPanel* self);
static void _clocks_timer_main_panel_on_start_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_timer_main_panel_on_left_button_clicked (ClocksTimerMainPanel* self);
static void clocks_timer_main_panel_pause (ClocksTimerMainPanel* self);
static void clocks_timer_main_panel_restart (ClocksTimerMainPanel* self);
static void _clocks_timer_main_panel_on_left_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_timer_main_panel_on_right_button_clicked (ClocksTimerMainPanel* self);
static void _clocks_timer_main_panel_on_right_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void clocks_timer_main_panel_remove_tick (ClocksTimerMainPanel* self);
static void clocks_timer_main_panel_update_countdown_label (ClocksTimerMainPanel* self, gint h, gint m, gint s);
static void clocks_timer_main_panel_add_tick (ClocksTimerMainPanel* self);
static gboolean ___lambda46_ (ClocksTimerMainPanel* self, GtkWidget* c);
static gboolean clocks_timer_main_panel_count (ClocksTimerMainPanel* self);
static gboolean ____lambda46__gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static void clocks_timer_main_panel_update_countdown (ClocksTimerMainPanel* self, gdouble elapsed);
void clocks_utils_time_to_hms (gdouble t, gint* h, gint* m, gint* s, gdouble* remainder);
static void clocks_timer_main_panel_real_grab_focus (GtkWidget* base);
static void clocks_timer_main_panel_real_ring (ClocksTimerMainPanel* self);
void clocks_utils_bell_ring_once (ClocksUtilsBell* self);
static void clocks_timer_main_panel_finalize (GObject* obj);
const gchar* clocks_clock_get_label (ClocksClock* self);
ClocksHeaderBar* clocks_clock_get_header_bar (ClocksClock* self);
ClocksPanelId clocks_clock_get_panel_id (ClocksClock* self);
static void _vala_clocks_timer_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
void clocks_clock_set_label (ClocksClock* self, const gchar* value);
void clocks_clock_set_header_bar (ClocksClock* self, ClocksHeaderBar* value);
void clocks_clock_set_panel_id (ClocksClock* self, ClocksPanelId value);
static void _vala_clocks_timer_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


static gdouble clocks_timer_countdown_frame_get_progress (ClocksTimerCountdownFrame* self) {
	gdouble result = 0.0;
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp1_ = self->priv->_span;
	if (_tmp1_ != ((gdouble) 0)) {
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp2_ = self->priv->elapsed_before_pause;
		_tmp3_ = self->priv->elapsed;
		_tmp4_ = self->priv->_span;
		_tmp0_ = (_tmp2_ + _tmp3_) / _tmp4_;
	} else {
		_tmp0_ = (gdouble) 0;
	}
	_tmp5_ = _tmp0_;
	result = _tmp5_;
	return result;
}


void clocks_timer_countdown_frame_update (ClocksTimerCountdownFrame* self, gdouble e) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = e;
	self->priv->elapsed = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void clocks_timer_countdown_frame_pause (ClocksTimerCountdownFrame* self) {
	gdouble _tmp0_ = 0.0;
	gdouble _tmp1_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->elapsed_before_pause;
	_tmp1_ = self->priv->elapsed;
	self->priv->elapsed_before_pause = _tmp0_ + _tmp1_;
	self->priv->elapsed = (gdouble) 0;
}


void clocks_timer_countdown_frame_reset (ClocksTimerCountdownFrame* self) {
	g_return_if_fail (self != NULL);
	self->priv->elapsed_before_pause = (gdouble) 0;
	self->priv->elapsed = (gdouble) 0;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void clocks_timer_countdown_frame_real_draw_progress (ClocksAnalogFrame* base, cairo_t* cr, gint center_x, gint center_y, gint radius) {
	ClocksTimerCountdownFrame * self;
	GtkStyleContext* context = NULL;
	GtkStyleContext* _tmp0_ = NULL;
	GtkStyleContext* _tmp1_ = NULL;
	cairo_t* _tmp2_ = NULL;
	cairo_t* _tmp3_ = NULL;
	GdkRGBA color = {0};
	GdkRGBA _tmp4_ = {0};
	gdouble progress = 0.0;
	gdouble _tmp5_ = 0.0;
	cairo_t* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	cairo_t* _tmp10_ = NULL;
	GdkRGBA _tmp11_ = {0};
	cairo_t* _tmp12_ = NULL;
	self = (ClocksTimerCountdownFrame*) base;
	g_return_if_fail (cr != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	context = _tmp1_;
	gtk_style_context_save (context);
	gtk_style_context_add_class (context, "progress");
	_tmp2_ = cr;
	cairo_set_line_width (_tmp2_, (gdouble) CLOCKS_ANALOG_FRAME_LINE_WIDTH);
	_tmp3_ = cr;
	cairo_set_line_cap (_tmp3_, CAIRO_LINE_CAP_ROUND);
	gtk_style_context_get_color (context, GTK_STATE_FLAG_NORMAL, &_tmp4_);
	color = _tmp4_;
	_tmp5_ = clocks_timer_countdown_frame_get_progress (self);
	progress = _tmp5_;
	_tmp6_ = cr;
	_tmp7_ = center_x;
	_tmp8_ = center_y;
	_tmp9_ = radius;
	cairo_arc (_tmp6_, (gdouble) _tmp7_, (gdouble) _tmp8_, (gdouble) (_tmp9_ - (CLOCKS_ANALOG_FRAME_LINE_WIDTH / 2)), 1.5 * G_PI, (1.5 + ((1 - progress) * 2)) * G_PI);
	_tmp10_ = cr;
	_tmp11_ = color;
	gdk_cairo_set_source_rgba (_tmp10_, &_tmp11_);
	_tmp12_ = cr;
	cairo_stroke (_tmp12_);
	gtk_style_context_restore (context);
	_g_object_unref0 (context);
}


ClocksTimerCountdownFrame* clocks_timer_countdown_frame_construct (GType object_type) {
	ClocksTimerCountdownFrame * self = NULL;
	self = (ClocksTimerCountdownFrame*) clocks_analog_frame_construct (object_type);
	return self;
}


ClocksTimerCountdownFrame* clocks_timer_countdown_frame_new (void) {
	return clocks_timer_countdown_frame_construct (CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME);
}


gdouble clocks_timer_countdown_frame_get_span (ClocksTimerCountdownFrame* self) {
	gdouble result;
	gdouble _tmp0_ = 0.0;
	g_return_val_if_fail (self != NULL, 0.0);
	_tmp0_ = self->priv->_span;
	result = _tmp0_;
	return result;
}


void clocks_timer_countdown_frame_set_span (ClocksTimerCountdownFrame* self, gdouble value) {
	gdouble _tmp0_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_span = _tmp0_;
	g_object_notify ((GObject *) self, "span");
}


static void clocks_timer_countdown_frame_class_init (ClocksTimerCountdownFrameClass * klass) {
	clocks_timer_countdown_frame_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksTimerCountdownFramePrivate));
	CLOCKS_ANALOG_FRAME_CLASS (klass)->draw_progress = clocks_timer_countdown_frame_real_draw_progress;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_timer_countdown_frame_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_timer_countdown_frame_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_timer_countdown_frame_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_COUNTDOWN_FRAME_SPAN, g_param_spec_double ("span", "span", "span", -G_MAXDOUBLE, G_MAXDOUBLE, (gdouble) 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void clocks_timer_countdown_frame_instance_init (ClocksTimerCountdownFrame * self) {
	self->priv = CLOCKS_TIMER_COUNTDOWN_FRAME_GET_PRIVATE (self);
	self->priv->_span = (gdouble) 0;
}


static void clocks_timer_countdown_frame_finalize (GObject* obj) {
	ClocksTimerCountdownFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrame);
	G_OBJECT_CLASS (clocks_timer_countdown_frame_parent_class)->finalize (obj);
}


GType clocks_timer_countdown_frame_get_type (void) {
	static volatile gsize clocks_timer_countdown_frame_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_timer_countdown_frame_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksTimerCountdownFrameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_timer_countdown_frame_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksTimerCountdownFrame), 0, (GInstanceInitFunc) clocks_timer_countdown_frame_instance_init, NULL };
		GType clocks_timer_countdown_frame_type_id;
		clocks_timer_countdown_frame_type_id = g_type_register_static (CLOCKS_TYPE_ANALOG_FRAME, "ClocksTimerCountdownFrame", &g_define_type_info, 0);
		g_once_init_leave (&clocks_timer_countdown_frame_type_id__volatile, clocks_timer_countdown_frame_type_id);
	}
	return clocks_timer_countdown_frame_type_id__volatile;
}


static void _vala_clocks_timer_countdown_frame_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksTimerCountdownFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrame);
	switch (property_id) {
		case CLOCKS_TIMER_COUNTDOWN_FRAME_SPAN:
		g_value_set_double (value, clocks_timer_countdown_frame_get_span (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_timer_countdown_frame_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksTimerCountdownFrame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_COUNTDOWN_FRAME, ClocksTimerCountdownFrame);
	switch (property_id) {
		case CLOCKS_TIMER_COUNTDOWN_FRAME_SPAN:
		clocks_timer_countdown_frame_set_span (self, g_value_get_double (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GType clocks_timer_main_panel_state_get_type (void) {
	static volatile gsize clocks_timer_main_panel_state_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_timer_main_panel_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CLOCKS_TIMER_MAIN_PANEL_STATE_STOPPED, "CLOCKS_TIMER_MAIN_PANEL_STATE_STOPPED", "stopped"}, {CLOCKS_TIMER_MAIN_PANEL_STATE_RUNNING, "CLOCKS_TIMER_MAIN_PANEL_STATE_RUNNING", "running"}, {CLOCKS_TIMER_MAIN_PANEL_STATE_PAUSED, "CLOCKS_TIMER_MAIN_PANEL_STATE_PAUSED", "paused"}, {0, NULL, NULL}};
		GType clocks_timer_main_panel_state_type_id;
		clocks_timer_main_panel_state_type_id = g_enum_register_static ("ClocksTimerMainPanelState", values);
		g_once_init_leave (&clocks_timer_main_panel_state_type_id__volatile, clocks_timer_main_panel_state_type_id);
	}
	return clocks_timer_main_panel_state_type_id__volatile;
}


ClocksTimerMainPanel* clocks_timer_main_panel_construct (GType object_type, ClocksHeaderBar* header_bar) {
	ClocksTimerMainPanel * self = NULL;
	const gchar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	GTimer* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	ClocksUtilsBell* _tmp6_ = NULL;
	GtkGrid* _tmp7_ = NULL;
	g_return_val_if_fail (header_bar != NULL, NULL);
	_tmp0_ = _ ("Timer");
	_tmp1_ = header_bar;
	self = (ClocksTimerMainPanel*) g_object_new (object_type, "label", _tmp0_, "header-bar", _tmp1_, "transition-type", GTK_STACK_TRANSITION_TYPE_CROSSFADE, "panel-id", CLOCKS_PANEL_ID_TIMER, NULL);
	_tmp2_ = g_settings_new ("org.gnome.clocks");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp2_;
	self->priv->tick_id = (guint) 0;
	self->priv->span = (gdouble) 0;
	_tmp3_ = g_timer_new ();
	_g_timer_destroy0 (self->priv->timer);
	self->priv->timer = _tmp3_;
	_tmp4_ = _ ("Time is up!");
	_tmp5_ = _ ("Timer countdown finished");
	_tmp6_ = clocks_utils_bell_new ("complete", _tmp4_, _tmp5_);
	_g_object_unref0 (self->priv->bell);
	self->priv->bell = _tmp6_;
	_tmp7_ = self->priv->grid_spinbuttons;
	gtk_widget_set_direction ((GtkWidget*) _tmp7_, GTK_TEXT_DIR_LTR);
	clocks_timer_main_panel_reset (self);
	return self;
}


ClocksTimerMainPanel* clocks_timer_main_panel_new (ClocksHeaderBar* header_bar) {
	return clocks_timer_main_panel_construct (CLOCKS_TIMER_TYPE_MAIN_PANEL, header_bar);
}


static gboolean clocks_timer_main_panel_show_leading_zeros (ClocksTimerMainPanel* self, GtkSpinButton* spin_button) {
	gboolean result = FALSE;
	GtkSpinButton* _tmp0_ = NULL;
	GtkSpinButton* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (spin_button != NULL, FALSE);
	_tmp0_ = spin_button;
	_tmp1_ = spin_button;
	_tmp2_ = gtk_spin_button_get_value_as_int (_tmp1_);
	_tmp3_ = g_strdup_printf ("%02i", _tmp2_);
	_tmp4_ = _tmp3_;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, _tmp4_);
	_g_free0 (_tmp4_);
	result = TRUE;
	return result;
}


static gboolean _clocks_timer_main_panel_show_leading_zeros_gtk_spin_button_output (GtkSpinButton* _sender, gpointer self) {
	gboolean result;
	result = clocks_timer_main_panel_show_leading_zeros (self, _sender);
	return result;
}


static void clocks_timer_main_panel_update_start_button (ClocksTimerMainPanel* self) {
	gint h = 0;
	GtkSpinButton* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint m = 0;
	GtkSpinButton* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	gint s = 0;
	GtkSpinButton* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gint _tmp8_ = 0;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp12_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->h_spinbutton;
	_tmp1_ = gtk_spin_button_get_value_as_int (_tmp0_);
	h = _tmp1_;
	_tmp2_ = self->priv->m_spinbutton;
	_tmp3_ = gtk_spin_button_get_value_as_int (_tmp2_);
	m = _tmp3_;
	_tmp4_ = self->priv->s_spinbutton;
	_tmp5_ = gtk_spin_button_get_value_as_int (_tmp4_);
	s = _tmp5_;
	_tmp8_ = h;
	if (_tmp8_ != 0) {
		_tmp7_ = TRUE;
	} else {
		gint _tmp9_ = 0;
		_tmp9_ = m;
		_tmp7_ = _tmp9_ != 0;
	}
	_tmp10_ = _tmp7_;
	if (_tmp10_) {
		_tmp6_ = TRUE;
	} else {
		gint _tmp11_ = 0;
		_tmp11_ = s;
		_tmp6_ = _tmp11_ != 0;
	}
	_tmp12_ = _tmp6_;
	if (_tmp12_) {
		GtkButton* _tmp13_ = NULL;
		GtkButton* _tmp14_ = NULL;
		GtkStyleContext* _tmp15_ = NULL;
		_tmp13_ = self->priv->start_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
		_tmp14_ = self->priv->start_button;
		_tmp15_ = gtk_widget_get_style_context ((GtkWidget*) _tmp14_);
		gtk_style_context_add_class (_tmp15_, "suggested-action");
	} else {
		GtkButton* _tmp16_ = NULL;
		GtkButton* _tmp17_ = NULL;
		GtkStyleContext* _tmp18_ = NULL;
		_tmp16_ = self->priv->start_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp16_, FALSE);
		_tmp17_ = self->priv->start_button;
		_tmp18_ = gtk_widget_get_style_context ((GtkWidget*) _tmp17_);
		gtk_style_context_remove_class (_tmp18_, "suggested-action");
	}
}


static void _clocks_timer_main_panel_update_start_button_gtk_editable_changed (GtkEditable* _sender, gpointer self) {
	clocks_timer_main_panel_update_start_button (self);
}


static void clocks_timer_main_panel_on_start_button_clicked (ClocksTimerMainPanel* self) {
	g_return_if_fail (self != NULL);
	clocks_timer_main_panel_start (self);
}


static void _clocks_timer_main_panel_on_start_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	clocks_timer_main_panel_on_start_button_clicked (self);
}


static void clocks_timer_main_panel_on_left_button_clicked (ClocksTimerMainPanel* self) {
	ClocksTimerMainPanelState _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->state;
	switch (_tmp0_) {
		case CLOCKS_TIMER_MAIN_PANEL_STATE_RUNNING:
		{
			GtkButton* _tmp1_ = NULL;
			const gchar* _tmp2_ = NULL;
			GtkButton* _tmp3_ = NULL;
			GtkStyleContext* _tmp4_ = NULL;
			clocks_timer_main_panel_pause (self);
			_tmp1_ = self->priv->left_button;
			_tmp2_ = _ ("Continue");
			gtk_button_set_label (_tmp1_, _tmp2_);
			_tmp3_ = self->priv->left_button;
			_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
			gtk_style_context_add_class (_tmp4_, "suggested-action");
			break;
		}
		case CLOCKS_TIMER_MAIN_PANEL_STATE_PAUSED:
		{
			GtkButton* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			GtkButton* _tmp7_ = NULL;
			GtkStyleContext* _tmp8_ = NULL;
			clocks_timer_main_panel_restart (self);
			_tmp5_ = self->priv->left_button;
			_tmp6_ = _ ("Pause");
			gtk_button_set_label (_tmp5_, _tmp6_);
			_tmp7_ = self->priv->left_button;
			_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
			gtk_style_context_remove_class (_tmp8_, "suggested-action");
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void _clocks_timer_main_panel_on_left_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	clocks_timer_main_panel_on_left_button_clicked (self);
}


static void clocks_timer_main_panel_on_right_button_clicked (ClocksTimerMainPanel* self) {
	GtkButton* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	clocks_timer_main_panel_reset (self);
	_tmp0_ = self->priv->left_button;
	_tmp1_ = _ ("Pause");
	gtk_button_set_label (_tmp0_, _tmp1_);
}


static void _clocks_timer_main_panel_on_right_button_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	clocks_timer_main_panel_on_right_button_clicked (self);
}


static void clocks_timer_main_panel_reset (ClocksTimerMainPanel* self) {
	GTimer* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	GtkSpinButton* _tmp3_ = NULL;
	gdouble _tmp4_ = 0.0;
	GtkSpinButton* _tmp5_ = NULL;
	gdouble _tmp6_ = 0.0;
	GtkSpinButton* _tmp7_ = NULL;
	gdouble _tmp8_ = 0.0;
	GtkButton* _tmp9_ = NULL;
	GtkStyleContext* _tmp10_ = NULL;
	GtkLabel* _tmp11_ = NULL;
	GtkStyleContext* _tmp12_ = NULL;
	GtkButton* _tmp13_ = NULL;
	gdouble _tmp14_ = 0.0;
	ClocksTimerCountdownFrame* _tmp15_ = NULL;
	ClocksAnalogFrame* _tmp16_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->state = CLOCKS_TIMER_MAIN_PANEL_STATE_STOPPED;
	_tmp0_ = self->priv->timer;
	g_timer_reset (_tmp0_);
	clocks_timer_main_panel_remove_tick (self);
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_uint (_tmp1_, "timer");
	self->priv->span = (gdouble) _tmp2_;
	_tmp3_ = self->priv->h_spinbutton;
	_tmp4_ = self->priv->span;
	gtk_spin_button_set_value (_tmp3_, (gdouble) (((gint) _tmp4_) / 3600));
	_tmp5_ = self->priv->m_spinbutton;
	_tmp6_ = self->priv->span;
	gtk_spin_button_set_value (_tmp5_, (gdouble) (((gint) _tmp6_) / 60));
	_tmp7_ = self->priv->s_spinbutton;
	_tmp8_ = self->priv->span;
	gtk_spin_button_set_value (_tmp7_, fmod (_tmp8_, 60));
	_tmp9_ = self->priv->left_button;
	_tmp10_ = gtk_widget_get_style_context ((GtkWidget*) _tmp9_);
	gtk_style_context_remove_class (_tmp10_, "clocks-go");
	_tmp11_ = self->priv->countdown_label;
	_tmp12_ = gtk_widget_get_style_context ((GtkWidget*) _tmp11_);
	gtk_style_context_remove_class (_tmp12_, "clocks-blink");
	_tmp13_ = self->priv->start_button;
	_tmp14_ = self->priv->span;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, _tmp14_ > ((gdouble) 0));
	_tmp15_ = self->priv->countdown_frame;
	clocks_timer_countdown_frame_reset (_tmp15_);
	_tmp16_ = self->priv->setup_frame;
	gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp16_);
}


static void clocks_timer_main_panel_start (ClocksTimerMainPanel* self) {
	gboolean _tmp0_ = FALSE;
	ClocksTimerMainPanelState _tmp1_ = 0;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->state;
	if (_tmp1_ == CLOCKS_TIMER_MAIN_PANEL_STATE_STOPPED) {
		guint _tmp2_ = 0U;
		_tmp2_ = self->priv->tick_id;
		_tmp0_ = _tmp2_ == ((guint) 0);
	} else {
		_tmp0_ = FALSE;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		gint h = 0;
		GtkSpinButton* _tmp4_ = NULL;
		gint _tmp5_ = 0;
		gint m = 0;
		GtkSpinButton* _tmp6_ = NULL;
		gint _tmp7_ = 0;
		gint s = 0;
		GtkSpinButton* _tmp8_ = NULL;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		GSettings* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		GTimer* _tmp15_ = NULL;
		ClocksTimerCountdownFrame* _tmp16_ = NULL;
		gdouble _tmp17_ = 0.0;
		ClocksTimerCountdownFrame* _tmp18_ = NULL;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp4_ = self->priv->h_spinbutton;
		_tmp5_ = gtk_spin_button_get_value_as_int (_tmp4_);
		h = _tmp5_;
		_tmp6_ = self->priv->m_spinbutton;
		_tmp7_ = gtk_spin_button_get_value_as_int (_tmp6_);
		m = _tmp7_;
		_tmp8_ = self->priv->s_spinbutton;
		_tmp9_ = gtk_spin_button_get_value_as_int (_tmp8_);
		s = _tmp9_;
		self->priv->state = CLOCKS_TIMER_MAIN_PANEL_STATE_RUNNING;
		_tmp10_ = h;
		_tmp11_ = m;
		_tmp12_ = s;
		self->priv->span = (gdouble) (((_tmp10_ * 3600) + (_tmp11_ * 60)) + _tmp12_);
		_tmp13_ = self->priv->settings;
		_tmp14_ = self->priv->span;
		g_settings_set_uint (_tmp13_, "timer", (guint) _tmp14_);
		_tmp15_ = self->priv->timer;
		g_timer_start (_tmp15_);
		_tmp16_ = self->priv->countdown_frame;
		_tmp17_ = self->priv->span;
		clocks_timer_countdown_frame_set_span (_tmp16_, _tmp17_);
		_tmp18_ = self->priv->countdown_frame;
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp18_);
		_tmp19_ = h;
		_tmp20_ = m;
		_tmp21_ = s;
		clocks_timer_main_panel_update_countdown_label (self, _tmp19_, _tmp20_, _tmp21_);
		clocks_timer_main_panel_add_tick (self);
	}
}


static void clocks_timer_main_panel_restart (ClocksTimerMainPanel* self) {
	GTimer* _tmp0_ = NULL;
	GtkLabel* _tmp1_ = NULL;
	GtkStyleContext* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->state = CLOCKS_TIMER_MAIN_PANEL_STATE_RUNNING;
	_tmp0_ = self->priv->timer;
	g_timer_start (_tmp0_);
	clocks_timer_main_panel_add_tick (self);
	_tmp1_ = self->priv->countdown_label;
	_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
	gtk_style_context_remove_class (_tmp2_, "clocks-blink");
}


static void clocks_timer_main_panel_pause (ClocksTimerMainPanel* self) {
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	GTimer* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	ClocksTimerCountdownFrame* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkStyleContext* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->state = CLOCKS_TIMER_MAIN_PANEL_STATE_PAUSED;
	_tmp0_ = self->priv->timer;
	g_timer_stop (_tmp0_);
	_tmp1_ = self->priv->span;
	_tmp2_ = self->priv->timer;
	_tmp3_ = g_timer_elapsed (_tmp2_, NULL);
	self->priv->span = _tmp1_ - _tmp3_;
	_tmp4_ = self->priv->countdown_frame;
	clocks_timer_countdown_frame_pause (_tmp4_);
	clocks_timer_main_panel_remove_tick (self);
	_tmp5_ = self->priv->countdown_label;
	_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
	gtk_style_context_add_class (_tmp6_, "clocks-blink");
}


static gboolean ___lambda46_ (ClocksTimerMainPanel* self, GtkWidget* c) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (c != NULL, FALSE);
	_tmp0_ = clocks_timer_main_panel_count (self);
	result = _tmp0_;
	return result;
}


static gboolean ____lambda46__gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = ___lambda46_ (self, widget);
	return result;
}


static void clocks_timer_main_panel_add_tick (ClocksTimerMainPanel* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tick_id;
	if (_tmp0_ == ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = gtk_widget_add_tick_callback ((GtkWidget*) self, ____lambda46__gtk_tick_callback, g_object_ref (self), g_object_unref);
		self->priv->tick_id = _tmp1_;
	}
}


static void clocks_timer_main_panel_remove_tick (ClocksTimerMainPanel* self) {
	guint _tmp0_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->tick_id;
	if (_tmp0_ != ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->tick_id;
		gtk_widget_remove_tick_callback ((GtkWidget*) self, _tmp1_);
		self->priv->tick_id = (guint) 0;
	}
}


static gboolean clocks_timer_main_panel_count (ClocksTimerMainPanel* self) {
	gboolean result = FALSE;
	gdouble e = 0.0;
	GTimer* _tmp0_ = NULL;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp5_ = 0.0;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->timer;
	_tmp1_ = g_timer_elapsed (_tmp0_, NULL);
	e = _tmp1_;
	_tmp2_ = e;
	_tmp3_ = self->priv->span;
	if (_tmp2_ >= _tmp3_) {
		ClocksAnalogFrame* _tmp4_ = NULL;
		g_signal_emit_by_name (self, "ring");
		self->priv->state = CLOCKS_TIMER_MAIN_PANEL_STATE_STOPPED;
		clocks_timer_main_panel_remove_tick (self);
		clocks_timer_main_panel_update_countdown_label (self, 0, 0, 0);
		_tmp4_ = self->priv->setup_frame;
		gtk_stack_set_visible_child ((GtkStack*) self, (GtkWidget*) _tmp4_);
		result = FALSE;
		return result;
	}
	_tmp5_ = e;
	clocks_timer_main_panel_update_countdown (self, _tmp5_);
	result = TRUE;
	return result;
}


static void clocks_timer_main_panel_update_countdown (ClocksTimerMainPanel* self, gdouble elapsed) {
	GtkLabel* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->countdown_label;
	_tmp1_ = gtk_widget_get_mapped ((GtkWidget*) _tmp0_);
	if (_tmp1_) {
		gdouble t = 0.0;
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		gint h = 0;
		gint m = 0;
		gint s = 0;
		gdouble r = 0.0;
		gdouble _tmp5_ = 0.0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gdouble _tmp9_ = 0.0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		ClocksTimerCountdownFrame* _tmp13_ = NULL;
		gdouble _tmp14_ = 0.0;
		_tmp2_ = self->priv->span;
		_tmp3_ = elapsed;
		_tmp4_ = ceil (_tmp2_ - _tmp3_);
		t = _tmp4_;
		_tmp5_ = t;
		clocks_utils_time_to_hms (_tmp5_, &_tmp6_, &_tmp7_, &_tmp8_, &_tmp9_);
		h = _tmp6_;
		m = _tmp7_;
		s = _tmp8_;
		r = _tmp9_;
		_tmp10_ = h;
		_tmp11_ = m;
		_tmp12_ = s;
		clocks_timer_main_panel_update_countdown_label (self, _tmp10_, _tmp11_, _tmp12_);
		_tmp13_ = self->priv->countdown_frame;
		_tmp14_ = elapsed;
		clocks_timer_countdown_frame_update (_tmp13_, _tmp14_);
	}
}


static void clocks_timer_main_panel_update_countdown_label (ClocksTimerMainPanel* self, gint h, gint m, gint s) {
	GtkLabel* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->countdown_label;
	_tmp1_ = h;
	_tmp2_ = m;
	_tmp3_ = s;
	_tmp4_ = g_strdup_printf ("%02i\xE2\x80\x8E∶%02i\xE2\x80\x8E∶%02i", _tmp1_, _tmp2_, _tmp3_);
	_tmp5_ = _tmp4_;
	gtk_label_set_text (_tmp0_, _tmp5_);
	_g_free0 (_tmp5_);
}


static void clocks_timer_main_panel_real_grab_focus (GtkWidget* base) {
	ClocksTimerMainPanel * self;
	GtkWidget* _tmp0_ = NULL;
	GtkWidget* _tmp1_ = NULL;
	ClocksAnalogFrame* _tmp2_ = NULL;
	self = (ClocksTimerMainPanel*) base;
	_tmp0_ = gtk_stack_get_visible_child ((GtkStack*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->setup_frame;
	if (_tmp1_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GTK_TYPE_WIDGET, GtkWidget)) {
		GtkButton* _tmp3_ = NULL;
		_tmp3_ = self->priv->start_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp3_);
	}
}


static const gchar* clocks_timer_main_panel_real_get_label (ClocksClock* base) {
	const gchar* result;
	ClocksTimerMainPanel* self;
	const gchar* _tmp0_ = NULL;
	self = (ClocksTimerMainPanel*) base;
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}


static void clocks_timer_main_panel_real_set_label (ClocksClock* base, const gchar* value) {
	ClocksTimerMainPanel* self;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	self = (ClocksTimerMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 (self->priv->_label);
	self->priv->_label = _tmp1_;
	g_object_notify ((GObject *) self, "label");
}


static ClocksHeaderBar* clocks_timer_main_panel_real_get_header_bar (ClocksClock* base) {
	ClocksHeaderBar* result;
	ClocksTimerMainPanel* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	self = (ClocksTimerMainPanel*) base;
	_tmp0_ = self->priv->_header_bar;
	result = _tmp0_;
	return result;
}


static void clocks_timer_main_panel_real_set_header_bar (ClocksClock* base, ClocksHeaderBar* value) {
	ClocksTimerMainPanel* self;
	ClocksHeaderBar* _tmp0_ = NULL;
	ClocksHeaderBar* _tmp1_ = NULL;
	self = (ClocksTimerMainPanel*) base;
	_tmp0_ = value;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->_header_bar);
	self->priv->_header_bar = _tmp1_;
	g_object_notify ((GObject *) self, "header-bar");
}


static ClocksPanelId clocks_timer_main_panel_real_get_panel_id (ClocksClock* base) {
	ClocksPanelId result;
	ClocksTimerMainPanel* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksTimerMainPanel*) base;
	_tmp0_ = self->priv->_panel_id;
	result = _tmp0_;
	return result;
}


static void clocks_timer_main_panel_real_set_panel_id (ClocksClock* base, ClocksPanelId value) {
	ClocksTimerMainPanel* self;
	ClocksPanelId _tmp0_ = 0;
	self = (ClocksTimerMainPanel*) base;
	_tmp0_ = value;
	self->priv->_panel_id = _tmp0_;
	g_object_notify ((GObject *) self, "panel-id");
}


static void clocks_timer_main_panel_real_ring (ClocksTimerMainPanel* self) {
	ClocksUtilsBell* _tmp0_ = NULL;
	_tmp0_ = self->priv->bell;
	clocks_utils_bell_ring_once (_tmp0_);
}


static void clocks_timer_main_panel_class_init (ClocksTimerMainPanelClass * klass) {
	gint ClocksTimerMainPanel_private_offset;
	clocks_timer_main_panel_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ClocksTimerMainPanelPrivate));
	GTK_WIDGET_CLASS (klass)->grab_focus = clocks_timer_main_panel_real_grab_focus;
	CLOCKS_TIMER_MAIN_PANEL_CLASS (klass)->ring = clocks_timer_main_panel_real_ring;
	G_OBJECT_CLASS (klass)->get_property = _vala_clocks_timer_main_panel_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_clocks_timer_main_panel_set_property;
	G_OBJECT_CLASS (klass)->finalize = clocks_timer_main_panel_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_MAIN_PANEL_LABEL, g_param_spec_string ("label", "label", "label", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_MAIN_PANEL_HEADER_BAR, g_param_spec_object ("header-bar", "header-bar", "header-bar", CLOCKS_TYPE_HEADER_BAR, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CLOCKS_TIMER_MAIN_PANEL_PANEL_ID, g_param_spec_enum ("panel-id", "panel-id", "panel-id", CLOCKS_TYPE_PANEL_ID, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	ClocksTimerMainPanel_private_offset = g_type_class_get_instance_private_offset (klass);
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/clocks/ui/timer.ui");
	g_signal_new ("ring", CLOCKS_TIMER_TYPE_MAIN_PANEL, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ClocksTimerMainPanelClass, ring), NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "setup_frame", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, setup_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "grid_spinbuttons", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, grid_spinbuttons));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "h_spinbutton", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, h_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "m_spinbutton", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, m_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "s_spinbutton", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, s_spinbutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "start_button", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, start_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "countdown_frame", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, countdown_frame));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "countdown_label", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, countdown_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "left_button", FALSE, ClocksTimerMainPanel_private_offset + G_STRUCT_OFFSET (ClocksTimerMainPanelPrivate, left_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "show_leading_zeros", G_CALLBACK(_clocks_timer_main_panel_show_leading_zeros_gtk_spin_button_output));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "update_start_button", G_CALLBACK(_clocks_timer_main_panel_update_start_button_gtk_editable_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_start_button_clicked", G_CALLBACK(_clocks_timer_main_panel_on_start_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_left_button_clicked", G_CALLBACK(_clocks_timer_main_panel_on_left_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_right_button_clicked", G_CALLBACK(_clocks_timer_main_panel_on_right_button_clicked_gtk_button_clicked));
}


static void clocks_timer_main_panel_clocks_clock_interface_init (ClocksClockIface * iface) {
	clocks_timer_main_panel_clocks_clock_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_label = clocks_timer_main_panel_real_get_label;
	iface->set_label = clocks_timer_main_panel_real_set_label;
	iface->get_header_bar = clocks_timer_main_panel_real_get_header_bar;
	iface->set_header_bar = clocks_timer_main_panel_real_set_header_bar;
	iface->get_panel_id = clocks_timer_main_panel_real_get_panel_id;
	iface->set_panel_id = clocks_timer_main_panel_real_set_panel_id;
}


static void clocks_timer_main_panel_instance_init (ClocksTimerMainPanel * self) {
	self->priv = CLOCKS_TIMER_MAIN_PANEL_GET_PRIVATE (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}


static void clocks_timer_main_panel_finalize (GObject* obj) {
	ClocksTimerMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, CLOCKS_TIMER_TYPE_MAIN_PANEL, ClocksTimerMainPanel);
	_g_free0 (self->priv->_label);
	_g_object_unref0 (self->priv->_header_bar);
	_g_object_unref0 (self->priv->settings);
	_g_timer_destroy0 (self->priv->timer);
	_g_object_unref0 (self->priv->bell);
	_g_object_unref0 (self->priv->setup_frame);
	_g_object_unref0 (self->priv->grid_spinbuttons);
	_g_object_unref0 (self->priv->h_spinbutton);
	_g_object_unref0 (self->priv->m_spinbutton);
	_g_object_unref0 (self->priv->s_spinbutton);
	_g_object_unref0 (self->priv->start_button);
	_g_object_unref0 (self->priv->countdown_frame);
	_g_object_unref0 (self->priv->countdown_label);
	_g_object_unref0 (self->priv->left_button);
	G_OBJECT_CLASS (clocks_timer_main_panel_parent_class)->finalize (obj);
}


GType clocks_timer_main_panel_get_type (void) {
	static volatile gsize clocks_timer_main_panel_type_id__volatile = 0;
	if (g_once_init_enter (&clocks_timer_main_panel_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ClocksTimerMainPanelClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) clocks_timer_main_panel_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ClocksTimerMainPanel), 0, (GInstanceInitFunc) clocks_timer_main_panel_instance_init, NULL };
		static const GInterfaceInfo clocks_clock_info = { (GInterfaceInitFunc) clocks_timer_main_panel_clocks_clock_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType clocks_timer_main_panel_type_id;
		clocks_timer_main_panel_type_id = g_type_register_static (GTK_TYPE_STACK, "ClocksTimerMainPanel", &g_define_type_info, 0);
		g_type_add_interface_static (clocks_timer_main_panel_type_id, CLOCKS_TYPE_CLOCK, &clocks_clock_info);
		g_once_init_leave (&clocks_timer_main_panel_type_id__volatile, clocks_timer_main_panel_type_id);
	}
	return clocks_timer_main_panel_type_id__volatile;
}


static void _vala_clocks_timer_main_panel_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ClocksTimerMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_MAIN_PANEL, ClocksTimerMainPanel);
	switch (property_id) {
		case CLOCKS_TIMER_MAIN_PANEL_LABEL:
		g_value_set_string (value, clocks_clock_get_label ((ClocksClock*) self));
		break;
		case CLOCKS_TIMER_MAIN_PANEL_HEADER_BAR:
		g_value_set_object (value, clocks_clock_get_header_bar ((ClocksClock*) self));
		break;
		case CLOCKS_TIMER_MAIN_PANEL_PANEL_ID:
		g_value_set_enum (value, clocks_clock_get_panel_id ((ClocksClock*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_clocks_timer_main_panel_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ClocksTimerMainPanel * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, CLOCKS_TIMER_TYPE_MAIN_PANEL, ClocksTimerMainPanel);
	switch (property_id) {
		case CLOCKS_TIMER_MAIN_PANEL_LABEL:
		clocks_clock_set_label ((ClocksClock*) self, g_value_get_string (value));
		break;
		case CLOCKS_TIMER_MAIN_PANEL_HEADER_BAR:
		clocks_clock_set_header_bar ((ClocksClock*) self, g_value_get_object (value));
		break;
		case CLOCKS_TIMER_MAIN_PANEL_PANEL_ID:
		clocks_clock_set_panel_id ((ClocksClock*) self, g_value_get_enum (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



