------------------------------------------------------------------------------
--  Ada95 Interface to Oracle RDBMS                                         --
--  Copyright (C) 2000-2006 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-number_functions.adb,v 1.19 2008/05/05 12:06:47 vagul Exp $

with OCI.Thread;

package body OCI.Thick.Number_Functions is

   -------------
   -- Is_Zero --
   -------------

   function Is_Zero (Num : in OCINumber) return Boolean is
      use type C.int;
      Zero : aliased C_Boolean;
   begin
      Check_Error (OCINumberIsZero (Thread.Error, Num, Zero'Access));
      return Zero /= Lib.FALSE;
   end Is_Zero;

   ----------
   -- Sign --
   ----------

   function Sign (Num : in OCINumber) return Integer is
      Sign : aliased SWord;
   begin
      Check_Error (OCINumberSign (Thread.Error, Num, Sign'Access));
      return Integer (Sign);
   end Sign;

   ---------------
   -- To_Number --
   ---------------

   function To_Number (From : String; Format : String) return OCINumber is
      Result : aliased OCINumber;
   begin
      Check_Error (OCINumberFromText
        (Err          => Thread.Error,
         Buf          => C.To_C (From),
         Str_Length   => From'Length,
         Fmt          => C.To_C (Format),
         Fmt_Length   => Format'Length,
         NLS_params   => Empty_Undefined,
         nls_p_length => 0,
         number       => Result'Access));
      return Result;
   end To_Number;

   ---------------
   -- To_String --
   ---------------

   function To_String
     (From : OCINumber; Format : String := "TM9") return String
   is
      use type Ub4;
      Buff : aliased Text := (0 .. 127 => C.nul);
      Len  : aliased Ub4 := Buff'Length;
   begin
      Check_Error (OCINumberToText
        (Err        => Thread.Error,
         Date       => From,
         Fmt        => C.To_C (Format),
         Fmt_Length => Format'Length,
         Nls_Name   => Empty_Undefined,
         Nls_Length => 0,
         Buf_Size   => Len'Access,
         Buf        => CStr.To_Chars_Ptr (Buff'Unchecked_Access)));
      return C.To_Ada (Buff (0 .. C.size_t (Len - 1)), False);
   end To_String;

end OCI.Thick.Number_Functions;
