static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2015 Red Hat, Inc.                                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (scale, _(\"Scale\"), 1.0)                                    \n"
"    description(_(\"Scale, strength of effect\"))                             \n"
"    value_range (0.0, 1.0)                                                    \n"
"                                                                              \n"
"property_boolean (srgb, _(\"sRGB\"), TRUE)                                    \n"
"    description (_(\"Use sRGB gamma instead of linear\"))                     \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_C_SOURCE sepia.c                                              \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  const Babl *format;                                                         \n"
"                                                                              \n"
"  if (o->srgb)                                                                \n"
"    format = babl_format (\"R'G'B'A float\");                                 \n"
"  else                                                                        \n"
"    format = babl_format (\"RGBA float\");                                    \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"input\", format);                   \n"
"  gegl_operation_set_format (operation, \"output\", format);                  \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  gfloat *in = in_buf;                                                        \n"
"  gfloat *out = out_buf;                                                      \n"
"  gfloat m[25] = { 1.0, 0.0, 0.0, 0.0, 0.0,                                   \n"
"                   0.0, 1.0, 0.0, 0.0, 0.0,                                   \n"
"                   0.0, 0.0, 1.0, 0.0, 0.0,                                   \n"
"                   0.0, 0.0, 0.0, 1.0, 0.0,                                   \n"
"                   0.0, 0.0, 0.0, 0.0, 1.0 };                                 \n"
"  glong i;                                                                    \n"
"                                                                              \n"
"  m[0] = 0.393 + 0.607 * (1.0 - o->scale);                                    \n"
"  m[1] = 0.769 - 0.769 * (1.0 - o->scale);                                    \n"
"  m[2] = 0.189 - 0.189 * (1.0 - o->scale);                                    \n"
"                                                                              \n"
"  m[5] = 0.349 - 0.349 * (1.0 - o->scale);                                    \n"
"  m[6] = 0.686 + 0.314 * (1.0 - o->scale);                                    \n"
"  m[7] = 0.168 - 0.168 * (1.0 - o->scale);                                    \n"
"                                                                              \n"
"  m[10] = 0.272 - 0.272 * (1.0 - o->scale);                                   \n"
"  m[11] = 0.534 - 0.534 * (1.0 - o->scale);                                   \n"
"  m[12] = 0.131 + 0.869 * (1.0 - o->scale);                                   \n"
"                                                                              \n"
"  for (i = 0; i < n_pixels; i++)                                              \n"
"    {                                                                         \n"
"      out[0] = m[0] * in[0] + m[1] * in[1] + m[2] * in[2];                    \n"
"      out[1] = m[5] * in[0] + m[6] * in[1] + m[7] * in[2];                    \n"
"      out[2] = m[10] * in[0] + m[11] * in[1] + m[12] * in[2];                 \n"
"      out[3] = in[3];                                                         \n"
"                                                                              \n"
"      in += 4;                                                                \n"
"      out += 4;                                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass *operation_class = GEGL_OPERATION_CLASS (klass);         \n"
"  GeglOperationPointFilterClass *point_filter_class =                         \n"
"    GEGL_OPERATION_POINT_FILTER_CLASS (klass);                                \n"
"                                                                              \n"
"  operation_class->prepare = prepare;                                         \n"
"  operation_class->opencl_support = FALSE;                                    \n"
"                                                                              \n"
"  point_filter_class->process = process;                                      \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"       , \"gegl:sepia\",                                          \n"
"    \"title\",       _(\"Sepia\"),                                            \n"
"    \"categories\" , \"color\",                                               \n"
"    \"description\", _(\"Converts the input image to sepia\"),                \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
