/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.jsp.tagext;

import javax.servlet.jsp.tagext.TagAttributeInfo;
import javax.servlet.jsp.tagext.TagData;
import javax.servlet.jsp.tagext.TagExtraInfo;
import javax.servlet.jsp.tagext.TagLibraryInfo;
import javax.servlet.jsp.tagext.VariableInfo;

public class TagInfo {
    public static final String BODY_CONTENT_JSP = "JSP";
    public static final String BODY_CONTENT_TAG_DEPENDENT = "TAGDEPENDENT";
    public static final String BODY_CONTENT_EMPTY = "EMPTY";
    private String tagName;
    private String tagClassName;
    private String bodyContent;
    private String infoString;
    private TagLibraryInfo tagLibrary;
    private TagExtraInfo tagExtraInfo;
    private TagAttributeInfo[] attributeInfo;

    public TagInfo(String tagName, String tagClassName, String bodycontent, String infoString, TagLibraryInfo taglib, TagExtraInfo tagExtraInfo, TagAttributeInfo[] attributeInfo) {
        this.tagName = tagName;
        this.tagClassName = tagClassName;
        this.bodyContent = bodycontent;
        this.infoString = infoString;
        this.tagLibrary = taglib;
        this.tagExtraInfo = tagExtraInfo;
        this.attributeInfo = attributeInfo;
        if (tagExtraInfo != null) {
            tagExtraInfo.setTagInfo(this);
        }
    }

    public String getTagName() {
        return this.tagName;
    }

    public TagAttributeInfo[] getAttributes() {
        return this.attributeInfo;
    }

    public VariableInfo[] getVariableInfo(TagData data) {
        TagExtraInfo tei = this.getTagExtraInfo();
        if (tei == null) {
            return null;
        }
        return tei.getVariableInfo(data);
    }

    public boolean isValid(TagData data) {
        TagExtraInfo tei = this.getTagExtraInfo();
        if (tei == null) {
            return true;
        }
        return tei.isValid(data);
    }

    public TagExtraInfo getTagExtraInfo() {
        return this.tagExtraInfo;
    }

    public String getTagClassName() {
        return this.tagClassName;
    }

    public String getBodyContent() {
        return this.bodyContent;
    }

    public String getInfoString() {
        return this.infoString;
    }

    public TagLibraryInfo getTagLibrary() {
        return this.tagLibrary;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append("name = " + this.tagName + " ");
        b.append("class = " + this.tagClassName + " ");
        b.append("body = " + this.bodyContent + " ");
        b.append("info = " + this.infoString + " ");
        b.append("attributes = {\n");
        int i = 0;
        while (i < this.attributeInfo.length) {
            b.append("\t" + this.attributeInfo[i].toString());
            ++i;
        }
        b.append("\n}\n");
        return b.toString();
    }
}

