---
title: Lateef - Character Set Support
fontversion: 4.200
---

The Lateef font contains complete coverage of all the characters defined in Unicode for Arabic script (excluding the Arabic Presentation Forms blocks, which are not recommended for normal use). 

[Arabic (U+0600..U+06FF)](https://www.unicode.org/charts/PDF/U0600.pdf) was added to Unicode 1.0. [Arabic Supplement (U+0750..U+077F)](https://www.unicode.org/charts/PDF/U0750.pdf) was added to Unicode 4.1, [Arabic Extended-A (U+08A0..U+08FF)](https://www.unicode.org/charts/PDF/U08A0.pdf) was added to Unicode 6.1, [Arabic Extended-B (U+0870..U+089F)](https://www.unicode.org/charts/PDF/U0870.pdf) was added to Unicode 14.0, and [Arabic Extended-C (U+10EC0..U+10EFF)](https://www.unicode.org/charts/PDF/U10EC0.pdf) was added to Unicode 15.0. There are still some Arabic script characters being added to Unicode, so it is possible that not all languages using the Arabic script are fully represented in Unicode. 

## Supported characters

The following character ranges are supported by this font:

Unicode block | Lateef support
------------- | ---------------
Arabic 	| ✓
Arabic Supplement | ✓
Arabic Extended-A | ✓ 
Arabic Extended-B | ✓ 
Supplemental Punctuation | 2E41
Arabic Presentation Forms-A | only includes FD3E..FD3F, FD42, FD47, FDCF, FDF2, FDFA..FDFD
Arabic Presentation Forms-B | ✗ 
Arabic Extended-C | only includes 10EFD..10EFF
Codepage 1252 (Western)¹ | ✓

A selection of characters from the General Punctuation block, such as various-sized spaces, are also supported; a utility such as <a href="https://scripts.sil.org/ViewGlyph_home">SIL ViewGlyph</a> can be used to examine the exact repertoire of this font. U+204F REVERSED SEMICOLON and U+2E41 REVERSED COMMA have been added to support Sindhi punctuation.

¹Inclusion of basic Latin repertoire is provided as a convenience, e.g., for use in menus or for displaying markup in text files; these fonts are not intended for extensive Latin script use.

