#include "generator.ih"

void Generator::classHead(ostream &out) const
{
    key(out);

    std::string const &name = d_options.className();

    out << 
        "class " << name << ": public " << name << "Base\n"
        "{\n"
        "    public:\n"
        "        explicit " << name << "(std::istream &in = std::cin, "
                                        "std::ostream &out = std::cout, "
                                        "bool keepCwd = true);\n";

    if (not d_options.interactive())
        out << 
            "\n"
            "        " << name << "(std::string const &infile, "
                                   "std::string const &outfile, "
                                   "bool keepCwd = true);\n";
}
