/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;
import loci.formats.codec.BitBuffer;
import loci.formats.codec.MSRLECodec;
import loci.formats.codec.MSVideoCodec;

public class AVIReader
extends FormatReader {
    private static final int MSRLE = 1;
    private static final int MS_VIDEO = 1296126531;
    private Vector offsets;
    private Vector lengths;
    private String type = "error";
    private String fcc = "error";
    private int size = -1;
    private long pos;
    private int bmpColorsUsed;
    private int bmpWidth;
    private int bmpCompression;
    private int bmpScanLineSize;
    private short bmpBitsPerPixel;
    private byte[][] lut = null;
    private byte[] lastImage;

    public AVIReader() {
        super("Audio Video Interleave", "avi");
    }

    public boolean isThisType(byte[] block) {
        return new String(block).startsWith("RIFF");
    }

    public byte[][] get8BitLookupTable() throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        return this.lut;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        FormatTools.checkBufferSize(this, buf.length);
        int bytes = FormatTools.getBytesPerPixel(this.core.pixelType[0]);
        double p = (double)this.bmpScanLineSize / (double)this.bmpBitsPerPixel;
        int effectiveWidth = (int)((double)this.bmpScanLineSize / p);
        if (effectiveWidth == 0 || effectiveWidth < this.core.sizeX[0]) {
            effectiveWidth = this.core.sizeX[0];
        }
        long fileOff = (Long)this.offsets.get(no);
        this.in.seek(fileOff);
        if (this.bmpCompression != 0) {
            return this.uncompress(no, buf);
        }
        if (this.bmpBitsPerPixel < 8) {
            int rawSize = bytes * this.core.sizeY[0] * effectiveWidth * this.core.sizeC[0];
            byte[] b = new byte[rawSize /= 8 / this.bmpBitsPerPixel];
            int len = rawSize / this.core.sizeY[0];
            for (int y = 0; y < this.core.sizeY[0]; ++y) {
                this.in.read(b, (this.core.sizeY[0] - y - 1) * len, len);
            }
            BitBuffer bb = new BitBuffer(b);
            for (int i = 0; i < buf.length; ++i) {
                buf[i] = (byte)bb.getBits(this.bmpBitsPerPixel);
            }
            return buf;
        }
        int pad = this.bmpScanLineSize - this.core.sizeX[0] * (this.bmpBitsPerPixel / 8);
        int scanline = this.core.sizeX[0] * (this.bmpBitsPerPixel / 8);
        for (int i = this.core.sizeY[0] - 1; i >= 0; --i) {
            this.in.read(buf, i * scanline, scanline);
            if (this.bmpBitsPerPixel == 24) {
                for (int j = 0; j < this.core.sizeX[0]; ++j) {
                    byte r = buf[i * scanline + j * 3 + 2];
                    buf[i * scanline + j * 3 + 2] = buf[i * scanline + j * 3];
                    buf[i * scanline + j * 3] = r;
                }
            }
            this.in.skipBytes(pad * (this.bmpBitsPerPixel / 8));
        }
        if (this.bmpBitsPerPixel == 16) {
            byte[] r = new byte[this.core.sizeX[0] * this.core.sizeY[0] * 2];
            System.arraycopy(buf, 2 * (buf.length / 3), r, 0, r.length);
            System.arraycopy(buf, 0, buf, 2 * (buf.length / 3), r.length);
            System.arraycopy(r, 0, buf, 0, r.length);
        }
        return buf;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("AVIReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.in = new RandomAccessStream(id);
        this.in.order(true);
        this.status("Verifying AVI format");
        this.offsets = new Vector();
        this.lengths = new Vector();
        this.type = this.in.readString(4);
        this.size = this.in.readInt();
        this.fcc = this.in.readString(4);
        if (this.type.equals("RIFF")) {
            if (!this.fcc.equals("AVI ")) {
                throw new FormatException("Sorry, AVI RIFF format not found.");
            }
        } else {
            throw new FormatException("Not an AVI file");
        }
        long spos = this.pos = this.in.getFilePointer();
        this.status("Searching for image data");
        while (this.in.length() - this.in.getFilePointer() > 4L) {
            String listString = this.in.readString(4);
            this.in.seek(this.pos);
            if (listString.equals(" JUN")) {
                this.in.skipBytes(1);
                ++this.pos;
            }
            if (listString.equals("JUNK")) {
                this.type = this.in.readString(4);
                this.size = this.in.readInt();
                if (this.type.equals("JUNK")) {
                    this.in.skipBytes(this.size);
                }
            } else if (listString.equals("LIST")) {
                spos = this.in.getFilePointer();
                this.type = this.in.readString(4);
                this.size = this.in.readInt();
                this.fcc = this.in.readString(4);
                this.in.seek(spos);
                if (this.fcc.equals("hdrl")) {
                    this.type = this.in.readString(4);
                    this.size = this.in.readInt();
                    this.fcc = this.in.readString(4);
                    if (this.type.equals("LIST") && this.fcc.equals("hdrl")) {
                        this.type = this.in.readString(4);
                        this.size = this.in.readInt();
                        if (this.type.equals("avih")) {
                            spos = this.in.getFilePointer();
                            this.addMeta("Microseconds per frame", new Integer(this.in.readInt()));
                            this.addMeta("Max. bytes per second", new Integer(this.in.readInt()));
                            this.in.skipBytes(8);
                            this.addMeta("Total frames", new Integer(this.in.readInt()));
                            this.addMeta("Initial frames", new Integer(this.in.readInt()));
                            this.in.skipBytes(8);
                            this.core.sizeX[0] = this.in.readInt();
                            this.addMeta("Frame height", new Integer(this.in.readInt()));
                            this.addMeta("Scale factor", new Integer(this.in.readInt()));
                            this.addMeta("Frame rate", new Integer(this.in.readInt()));
                            this.addMeta("Start time", new Integer(this.in.readInt()));
                            this.addMeta("Length", new Integer(this.in.readInt()));
                            this.addMeta("Frame width", new Integer(this.core.sizeX[0]));
                            if (spos + (long)this.size <= this.in.length()) {
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                    }
                } else if (this.fcc.equals("strl")) {
                    long startPos = this.in.getFilePointer();
                    long streamSize = this.size;
                    this.type = this.in.readString(4);
                    this.size = this.in.readInt();
                    this.fcc = this.in.readString(4);
                    if (this.type.equals("LIST")) {
                        if (this.fcc.equals("strl")) {
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                            if (this.type.equals("strh")) {
                                spos = this.in.getFilePointer();
                                this.in.skipBytes(40);
                                this.addMeta("Stream quality", new Integer(this.in.readInt()));
                                this.addMeta("Stream sample size", new Integer(this.in.readInt()));
                                if (spos + (long)this.size <= this.in.length()) {
                                    this.in.seek(spos + (long)this.size);
                                }
                            }
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                            if (this.type.equals("strf")) {
                                spos = this.in.getFilePointer();
                                this.in.skipBytes(4);
                                this.bmpWidth = this.in.readInt();
                                this.core.sizeY[0] = this.in.readInt();
                                this.in.skipBytes(2);
                                this.bmpBitsPerPixel = this.in.readShort();
                                this.bmpCompression = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addMeta("Horizontal resolution", new Integer(this.in.readInt()));
                                this.addMeta("Vertical resolution", new Integer(this.in.readInt()));
                                this.bmpColorsUsed = this.in.readInt();
                                this.in.skipBytes(4);
                                this.addMeta("Bitmap compression value", new Integer(this.bmpCompression));
                                this.addMeta("Number of colors used", new Integer(this.bmpColorsUsed));
                                this.addMeta("Bits per pixel", new Integer(this.bmpBitsPerPixel));
                                int npad = this.bmpWidth % 4;
                                if (npad > 0) {
                                    npad = 4 - npad;
                                }
                                this.bmpScanLineSize = (this.bmpWidth + npad) * (this.bmpBitsPerPixel / 8);
                                int bmpActualColorsUsed = 0;
                                if (this.bmpColorsUsed != 0) {
                                    bmpActualColorsUsed = this.bmpColorsUsed;
                                } else if (this.bmpBitsPerPixel < 16) {
                                    bmpActualColorsUsed = 1 << this.bmpBitsPerPixel;
                                }
                                if (this.bmpCompression != 1 && this.bmpCompression != 0 && this.bmpCompression != 1296126531) {
                                    throw new FormatException("Unsupported compression type " + this.bmpCompression);
                                }
                                if (this.bmpBitsPerPixel != 4 && this.bmpBitsPerPixel != 8 && this.bmpBitsPerPixel != 24 && this.bmpBitsPerPixel != 16 && this.bmpBitsPerPixel != 32) {
                                    throw new FormatException(this.bmpBitsPerPixel + " bits per pixel not supported");
                                }
                                if (bmpActualColorsUsed != 0) {
                                    this.lut = new byte[3][this.bmpColorsUsed];
                                    for (int i = 0; i < this.bmpColorsUsed; ++i) {
                                        this.lut[2][i] = this.in.readByte();
                                        this.lut[1][i] = this.in.readByte();
                                        this.lut[0][i] = this.in.readByte();
                                        this.in.skipBytes(1);
                                    }
                                }
                                this.in.seek(spos + (long)this.size);
                            }
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.in.readString(4);
                        this.size = this.in.readInt();
                        if (this.type.equals("strd")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.in.readString(4);
                        this.size = this.in.readInt();
                        if (this.type.equals("strn")) {
                            this.in.skipBytes(this.size);
                        } else {
                            this.in.seek(spos);
                        }
                    }
                    if (startPos + streamSize + 8L <= this.in.length()) {
                        this.in.seek(startPos + 8L + streamSize);
                    }
                } else if (this.fcc.equals("movi")) {
                    this.type = this.in.readString(4);
                    this.size = this.in.readInt();
                    this.fcc = this.in.readString(4);
                    if (this.type.equals("LIST") && this.fcc.equals("movi")) {
                        spos = this.in.getFilePointer();
                        if (spos >= this.in.length() - 12L) break;
                        this.type = this.in.readString(4);
                        this.size = this.in.readInt();
                        this.fcc = this.in.readString(4);
                        if (!this.type.equals("LIST") || !this.fcc.equals("rec ")) {
                            this.in.seek(spos);
                        }
                        spos = this.in.getFilePointer();
                        this.type = this.in.readString(4);
                        this.size = this.in.readInt();
                        while (this.type.substring(2).equals("db") || this.type.substring(2).equals("dc") || this.type.substring(2).equals("wb")) {
                            if (this.type.substring(2).equals("db") || this.type.substring(2).equals("dc")) {
                                this.offsets.add(new Long(this.in.getFilePointer()));
                                this.lengths.add(new Long(this.size));
                                this.in.skipBytes(this.size);
                            }
                            spos = this.in.getFilePointer();
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                            if (!this.type.equals("JUNK")) continue;
                            this.in.skipBytes(this.size);
                            spos = this.in.getFilePointer();
                            this.type = this.in.readString(4);
                            this.size = this.in.readInt();
                        }
                        this.in.seek(spos);
                    }
                } else {
                    try {
                        this.in.skipBytes(8 + this.size);
                    }
                    catch (IllegalArgumentException iae) {}
                }
            } else {
                this.type = this.in.readString(4);
                if (this.in.getFilePointer() + (long)this.size + 4L <= this.in.length()) {
                    this.size = this.in.readInt();
                    this.in.skipBytes(this.size);
                }
            }
            this.pos = this.in.getFilePointer();
        }
        this.status("Populating metadata");
        this.core.imageCount[0] = this.offsets.size();
        this.core.rgb[0] = this.bmpBitsPerPixel > 8 || this.bmpCompression != 0;
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = this.core.rgb[0] ? 3 : 1;
        this.core.sizeT[0] = this.core.imageCount[0];
        this.core.currentOrder[0] = this.core.sizeC[0] == 3 ? "XYCTZ" : "XYTCZ";
        this.core.littleEndian[0] = true;
        this.core.interleaved[0] = this.bmpBitsPerPixel != 16;
        this.core.indexed[0] = this.bmpBitsPerPixel == 8 && this.bmpCompression != 0;
        this.core.falseColor[0] = false;
        this.core.metadataComplete[0] = true;
        if (this.bmpBitsPerPixel <= 8) {
            this.core.pixelType[0] = 1;
        } else if (this.bmpBitsPerPixel == 16) {
            this.core.pixelType[0] = 3;
        } else if (this.bmpBitsPerPixel == 32) {
            this.core.pixelType[0] = 5;
        } else if (this.bmpBitsPerPixel == 24) {
            this.core.pixelType[0] = 1;
        } else {
            throw new FormatException("Unknown matching for pixel bit width of: " + this.bmpBitsPerPixel);
        }
        if (this.bmpCompression != 0) {
            this.core.pixelType[0] = 1;
        }
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }

    private byte[] uncompress(int no, byte[] buf) throws FormatException, IOException {
        byte[] b = new byte[(int)((Long)this.lengths.get(no)).longValue()];
        this.in.read(b);
        if (this.bmpCompression == 1) {
            Object[] options = new Object[2];
            options[1] = this.lastImage;
            options[0] = new int[]{this.core.sizeX[0], this.core.sizeY[0]};
            MSRLECodec codec = new MSRLECodec();
            buf = codec.decompress(b, (Object)options);
            this.lastImage = buf;
            if (no == this.core.imageCount[0] - 1) {
                this.lastImage = null;
            }
            return buf;
        }
        if (this.bmpCompression == 1296126531) {
            Object[] options = new Object[]{new Integer(this.bmpBitsPerPixel), new Integer(this.core.sizeX[0]), new Integer(this.core.sizeY[0]), this.lastImage};
            MSVideoCodec codec = new MSVideoCodec();
            buf = codec.decompress(b, (Object)options);
            this.lastImage = buf;
            if (no == this.core.imageCount[0] - 1) {
                this.lastImage = null;
            }
            return buf;
        }
        throw new FormatException("Unsupported compression : " + this.bmpCompression);
    }
}

