-- $Id$

-- test resolution functions

-- Copyright (C) 2009 FAUmachine Team <info@faumachine.org>.
-- This program is free software. You can redistribute it and/or modify it
-- under the terms of the GNU General Public License, either version 2 of
-- the License, or (at your option) any later version. See COPYING.

package t is
	type bv is array(integer range <>) of boolean;
	function resolve_boolean_or(v : bv) return boolean;
	subtype boolean_or is resolve_boolean_or boolean;
end package t;

package body t is
	function resolve_boolean_or(v : bv) return boolean is
	begin
		for i in v'range loop
			if v(i) then
				return true;
			end if;
		end loop;

		return false;
	end;
end;

use t.boolean_or;
entity d is
	port (
		o : out boolean_or;
		i : in boolean
	);
end entity d;

architecture d_impl of d is
begin
	update_output : process(i)
	begin
		o <= i after 10 ms;
	end process;
end;

entity test_bench is
end entity test_bench;

use t.boolean_or;
architecture test_bench_impl of test_bench is
	signal r : boolean_or;
	signal i1 : boolean;
	signal i2 : boolean;
begin
	d1 : d port map(o => r, i => i1);
	d2 : d port map(o => r, i => i2);

	p : process
	begin
		i1 <= false;
		i2 <= false;

		wait for 12 ms;
		assert(r = false) report "r must be false" severity failure;

		i1 <= true;
		wait for 12 ms;
		assert(r = true) report "r must be true" severity failure;

		i2 <= true;
		wait for 12 ms;
		assert(r = true) report "r must be true" severity failure;

		i1 <= false;
		wait for 12 ms;
		assert(r = true) report "r must be true" severity failure;

		assert false report "simulation finished" severity note;
		wait;
	end process;
end;
