//
// File: ThreadTraitement.cc
// Created by: Éric Laly <elaly@free.fr>
// Created on: Thu Nov  9 12:25:54 2006
//

#include "ThreadTraitement.h"
#include "PanelResultat.h"


ThreadTraitement::ThreadTraitement(PanelCadres *panelcadres, PanelSaisieParametresSignature *panelsaisieparametresignature,
                                    PanelChoixImages *panelchoiximage, PanelParametresSortie *panelparametressortie, PanelResultat *panelresultat) : wxThread()
{
    panel_cadres=panelcadres;
    panel_signature=panelsaisieparametresignature;
    panel_choix_images=panelchoiximage;
    panel_parametres_sortie=panelparametressortie;
    panel_resultat=panelresultat;
}


ThreadTraitement::~ThreadTraitement()
{
	// TODO: put destructor code here
}

void ThreadTraitement::OnExit()
{
}

void *ThreadTraitement::Entry()
{ 
    panel_resultat->GaugeAvancementGlobalSetRange(panel_choix_images->GetNombreRepertoires()-1);
   // pour tous les répertoires source
    for (unsigned int i=0;i<panel_choix_images->GetNombreRepertoires();i++)
    {
        // on récupère le nom du répertoire de base des sorties
        wxString repertoire_destination(panel_parametres_sortie->GetRepertoireDestination());
        if (!panel_choix_images->GetNomSousRepertoire(i).IsSameAs(wxT("")))
        {
            // on rajoute au nom du répertoire destination le le nom du sous répertoire du répertoire source (cas récursif)
            repertoire_destination=repertoire_destination+panel_choix_images->GetNomSousRepertoire(i);
        }            
        // si le répertoires de destination n'existe pas, on le crée
        if (!wxDirExists(repertoire_destination)) 
        {    
            if (!wxMkdir(repertoire_destination))
            {    
                wxLogError(wxT("erreur à la création d'un des répertoires de sortie: %s"),repertoire_destination.c_str());
            }
        }
        // on récupère les noms des images
        if (CreeListeImage(panel_choix_images->GetRepertoireSource(i)))
        {    
            if (!liste_images.empty())
            {    
                // et on les encadre
                panel_resultat->SetLabelAvancementGlobal(wxT("Traitement du répertoire SOURCE")+panel_choix_images->GetNomSousRepertoire(i)+wxT(" en cours..."));
                EncadreFichiers(i);
            }   
        }
        panel_resultat->GaugeAvancementGlobalSetValue(i);     
    }    
    
    panel_resultat->TraitementTermine();
    
    return NULL;
}


bool ThreadTraitement::CreeListeImage(wxString repertoiresource)
{
    // on ouvre le répertoire source et on récupère les fichiers dont les extensions correspondent à des images
   liste_images.clear();
	wxDir dir(repertoiresource);
	if (!dir.IsOpened())
	{
			wxLogError(wxT("erreur lors de l'ouverture du répertoire source: %s"),repertoiresource.c_str());
            return false;
	} else{
        encadreur.SetRepertoireSource(repertoiresource);
        RecupereFichiers(wxT("*.jpg"),dir);
        RecupereFichiers(wxT("*.jpeg"),dir);
        #ifndef WIN32 // Windows
            RecupereFichiers(wxT("*.JPG"),dir);
            RecupereFichiers(wxT("*.JPEG"),dir);
        #endif
        return true;
	}	
}    

void ThreadTraitement::RecupereFichiers(wxString extension,wxDir &dir)
{
    //on récupère les fichiers avec l'extension indiquée dans le répertoire source et on les met dans la liste
    wxString nomfichier(wxT(""));
    int flags=wxDIR_FILES;
    wxString filespec(extension);
    bool cont=dir.GetFirst(&nomfichier,filespec,flags);
    while (cont)
    {
        liste_images.push_back(nomfichier);
        cont=dir.GetNext(&nomfichier);
    }
}    

void ThreadTraitement::EncadreFichiers(unsigned int num)
{
    int nombre_encadrement=panel_parametres_sortie->GetNombreEncadrement();
    int nombre_images=liste_images.size();

    panel_resultat->GaugeAvancementLocalSetRange(nombre_encadrement*nombre_images);

    // on fixe les paramètres d'encadrement
    if (!encadreur.SetPourcentagesCadres(panel_cadres->GetPourcentages())) 
        wxLogFatalError(wxT("erreur affectation pourcentage cadres"));
    encadreur.SetCouleursCadres(panel_cadres->GetCouleurs());
    encadreur.SetCouleursAutoCadres(panel_cadres->GetCouleursAuto());
    
    if (!encadreur.SetPourcentageFonteSignature(panel_signature->GetPourcentage())) 
        wxLogFatalError(wxT("erreur affectation pourcentage fonte signature"));
    encadreur.SetPositionSignature(panel_signature->GetPosition());
    encadreur.SetCouleurSignature(panel_signature->GetCouleur());
    encadreur.SetSignature(panel_signature->GetSignature());

    for (int num_sortie=0;num_sortie<nombre_encadrement;num_sortie++)
    {
        // on récupère le nom du répertoire de base des sorties
        wxString repertoire_destination(panel_parametres_sortie->GetRepertoireDestination());
        if (!panel_choix_images->GetNomSousRepertoire(num).IsSameAs(wxT("")))
        {
            // on rajoute au nom du répertoire destination le le nom du sous répertoire du répertoire source (cas récursif)
            repertoire_destination=repertoire_destination+panel_choix_images->GetNomSousRepertoire(num);
        }            
        // on rajoute le nom du sous-répertoire de sortie.
        repertoire_destination=repertoire_destination+wxT("/")+panel_parametres_sortie->GetSousRepertoireDestination(num_sortie);
        // si le répertoires de destination n'existe pas, on le crée
        bool rep_OK=false;
        if (!wxDirExists(repertoire_destination)) 
        {    
            if (!wxMkdir(repertoire_destination))
            {    
                wxLogError(wxT("erreur à la création d'un des répertoires de sortie: %s"),repertoire_destination.c_str());
            } else {
                rep_OK=true;
            }    
         } else {
                rep_OK=true;
         }    
          
        if (rep_OK)
        {    
            panel_resultat->SetLabelAvancementLocal(wxT("Écriture vers: DESTINATION")+panel_choix_images->GetNomSousRepertoire(num)+wxT("/")+
                                                                                   panel_parametres_sortie->GetSousRepertoireDestination(num_sortie));
            // on finit de fixer les paramètres d'encadrement
            encadreur.SetRepertoireDestination(repertoire_destination);
            encadreur.SetPrefixeFichier(panel_parametres_sortie->GetPrefixeFichier(num_sortie));
            encadreur.SetQualiteEnregistrement(panel_parametres_sortie->GetQualiteEnregistrement(num_sortie));
            encadreur.SetRedimensionnement(panel_parametres_sortie->GetTailleRedimensionement(num_sortie));
        
            for (unsigned int i=0;i<liste_images.size();i++)
            {    
                wxString nomfichier(liste_images[i]);
                panel_resultat->SetLabelNomFichierTraite(wxT("Fichier en cours: "+nomfichier));
                wxString retour(encadreur.Encadre(nomfichier));
                // on teste si l'application n'a pas demandé au thread de se terminer
                if (TestDestroy()) Exit(0);
                // on affiche une éventuelle erreur
                if (!retour.IsSameAs(wxT("")))
                {
                    wxString locallog(panel_parametres_sortie->GetNomSortie(num_sortie));
                    locallog<<wxT(": encadrement de ")<<nomfichier<<wxT(" PROBLÈME... ")<<retour;
                    wxLogError(wxT("Erreur à l'encadrement: %s"),locallog.c_str());
                }   
                panel_resultat->GaugeAvancementLocalSetValue(num_sortie*nombre_images+i+1);
            }     
        }                
    }       
}
