/*********************************************************************
 * FILE:         platform.cpp
 * PURPOSE:      platform specific stuff
 *********************************************************************/

#include "platform.h"

#ifdef CYGWIN
#include <ctype.h>
#endif /* CYGWIN */

#include <stdlib.h>
#include <string.h>

#ifdef WIN
#ifndef HAS_SFL

#include <windows.h>

unsigned int sleep(unsigned int seconds) {
	Sleep(seconds * 1000);
	return 0;
}

#endif /* !HAS_SFL */

#endif /* WIN */

char *convertFileName(const char *fname) {
	char *ff;

	ff = (char *)malloc((strlen(fname) + 10) * sizeof(char));
	if (ff == NULL) return NULL;

#ifdef CYGWIN
/* convert C: to /cygdrive/c, if necessary */
	char a[2];
	
	a[0] = toupper(fname[0]);
	a[1] = 0;
	if ((a[0] >= 'A') && (a[0] <= 'Z') && (fname[1] == ':')) {
		strcpy(ff, "/cygdrive/");
		strcat(ff, a);
		strcat(ff, fname + 2);
	} else {
		strcpy(ff, fname);
	}
#else
	strcpy(ff, fname);
#endif /* CYGWIN */

	return ff;
}

char *convertFileNameReverse(const char *fname) {
	char *ff;

	ff = (char *)malloc((strlen(fname) + 1) * sizeof(char));
	if (ff == NULL) return NULL;

#ifdef CYGWIN
/* convert /cygdrive/c to C:, if necessary */
	if (strlen(fname) >= 11) {
		if (strncmp(fname, "/cygdrive/", 10) == 0) {
			ff[0] = fname[10];
			ff[1] = ':';
			ff[2] = 0;
			strcat(ff, fname + 11);
		}
	} else {
		strcpy(ff, fname);
	}
#else
	strcpy(ff, fname);
#endif /* CYGWIN */

	return ff;
}

