#ifndef DPUSER2C_FUNCTIONS_H
#define DPUSER2C_FUNCTIONS_H

/*
 * Functions defined in external c++ files
 * The source code for the function is in the file
 * <function name>.cpp
 */

class dpString;
class CJulianDay;

#include "dpuserType.h"
#include <vector>

extern int nfunctions;
char *alternateFunctionName(char *s);
int lookupUserFunction(char *name);
int funcWord(char *s);
int funcWord_for_compile(const dpString &s);
int funcWord_for_store(const dpString &s);

//class compiled_function {
typedef struct {
    public:
    dpString name;
   dpString displaySyntax;
    int nargs;
    int nrCompiled;
    void *libHandle;
     dpuserType (*arg0)(void);
     dpuserType (*arg1)(dpuserType&);
     dpuserType (*arg2)(dpuserType&, dpuserType&);
     dpuserType (*arg3)(dpuserType&, dpuserType&, dpuserType&);
     dpuserType (*arg4)(dpuserType&, dpuserType&, dpuserType&, dpuserType&);
     dpuserType (*arg5)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
     dpuserType (*arg6)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
     dpuserType (*arg7)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
     dpuserType (*arg8)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
     dpuserType (*arg9)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg10)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg11)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg12)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg13)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg14)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg15)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg16)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg17)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg18)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg19)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
    dpuserType (*arg20)(dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&, dpuserType&);
} compiled_function;

extern std::vector<compiled_function> compiledfunctions;

dpuserType execCompiledFunction(dpString which, int nargs, dpuserType *args);

// BEGIN PARSE FOR DPUSER2C

dpuserType dpuserFunction_sin(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_cos(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_tan(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_sinh(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_cosh(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_tanh(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_asin(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_acos(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_atan(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_atan(dpuserType arg, dpuserType arg2, dpString option = "");
dpuserType dpuserFunction_asinh(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_acosh(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_atanh(dpuserType arg, dpString option = "");
dpuserType dpuserFunction_exp(dpuserType arg);
dpuserType dpuserFunction_log(dpuserType arg);
dpuserType dpuserFunction_log(dpuserType arg, dpuserType base);
dpuserType dpuserFunction_ln(dpuserType arg);
dpuserType dpuserFunction_sqrt(dpuserType arg);
dpuserType dpuserFunction_erf(dpuserType arg);
dpuserType dpuserFunction_bessel(dpuserType arg, dpuserType kind, dpuserType order);
dpuserType dpuserFunction_int(dpuserType arg);
dpuserType dpuserFunction_round(dpuserType arg);
dpuserType dpuserFunction_frac(dpuserType arg);
dpuserType dpuserFunction_abs(dpuserType arg);
dpuserType dpuserFunction_sign(dpuserType arg);
dpuserType dpuserFunction_rad2deg(dpuserType arg);
dpuserType dpuserFunction_deg2rad(dpuserType arg);
dpuserType dpuserFunction_float(dpuserType arg);
dpuserType dpuserFunction_strlen(dpuserType arg);
dpuserType dpuserFunction_min(dpuserType arg);
dpuserType dpuserFunction_min(dpuserType arg, dpuserType arg1);
dpuserType dpuserFunction_max(dpuserType arg);
dpuserType dpuserFunction_max(dpuserType arg, dpuserType arg1);
dpuserType dpuserFunction_avg(dpuserType arg);
dpuserType dpuserFunction_avg(dpuserType arg, dpuserType arg1);
dpuserType dpuserFunction_total(dpuserType arg);
dpuserType dpuserFunction_total(dpuserType arg, dpuserType arg1);
dpuserType dpuserFunction_median(dpuserType arg);
dpuserType dpuserFunction_median(dpuserType arg, dpuserType arg1);
dpuserType dpuserFunction_naxis(dpuserType arg);
dpuserType dpuserFunction_naxis1(dpuserType arg);
dpuserType dpuserFunction_naxis2(dpuserType arg);
dpuserType dpuserFunction_naxis3(dpuserType arg);
dpuserType dpuserFunction_xmax(dpuserType arg);
dpuserType dpuserFunction_ymax(dpuserType arg);
dpuserType dpuserFunction_xmin(dpuserType arg);
dpuserType dpuserFunction_ymin(dpuserType arg);
dpuserType dpuserFunction_xcen(dpuserType arg);
dpuserType dpuserFunction_ycen(dpuserType arg);
dpuserType dpuserFunction_real(dpuserType arg);
dpuserType dpuserFunction_imag(dpuserType arg);
dpuserType dpuserFunction_arg(dpuserType arg);
dpuserType dpuserFunction_jd(dpuserType day, dpuserType month, dpuserType year);
dpuserType dpuserFunction_jd(dpuserType day, dpuserType month, dpuserType year, dpuserType hour);
dpuserType dpuserFunction_jd(dpuserType day, dpuserType month, dpuserType year, dpuserType hour, dpuserType minute);
dpuserType dpuserFunction_jd(dpuserType day, dpuserType month, dpuserType year, dpuserType hour, dpuserType minute, dpuserType second);
dpuserType dpuserFunction_jdnumber(dpuserType day, dpuserType month, dpuserType year);
dpuserType dpuserFunction_jdnumber(dpuserType day, dpuserType month, dpuserType year, dpuserType hour);
dpuserType dpuserFunction_jdnumber(dpuserType day, dpuserType month, dpuserType year, dpuserType hour, dpuserType minute);
dpuserType dpuserFunction_jdnumber(dpuserType day, dpuserType month, dpuserType year, dpuserType hour, dpuserType minute, dpuserType second);
dpuserType dpuserFunction_jdfraction(dpuserType day, dpuserType month, dpuserType year);
dpuserType dpuserFunction_jdfraction(dpuserType day, dpuserType month, dpuserType year, dpuserType hour);
dpuserType dpuserFunction_jdfraction(dpuserType day, dpuserType month, dpuserType year, dpuserType hour, dpuserType minute);
dpuserType dpuserFunction_jdfraction(dpuserType day, dpuserType month, dpuserType year, dpuserType hour, dpuserType minute, dpuserType second);
dpuserType dpuserFunction_upper(dpuserType arg);
dpuserType dpuserFunction_lower(dpuserType arg);
dpuserType dpuserFunction_string(dpuserType number);
dpuserType dpuserFunction_string(dpuserType number, dpString option);
dpuserType dpuserFunction_calday(dpuserType jd);
dpuserType dpuserFunction_calday(dpuserType jd, dpuserType jd_frac);
dpuserType dpuserFunction_header(dpuserType X);
dpuserType dpuserFunction_header(dpuserType X, dpuserType extension);
dpuserType dpuserFunction_dayofweek(dpuserType jd);
dpuserType dpuserFunction_dayofweek(dpuserType jd, dpuserType jd_frac);
dpuserType dpuserFunction_dayofweek(dpuserType day, dpuserType month, dpuserType year);
dpuserType dpuserFunction_fits(dpuserType x);
dpuserType dpuserFunction_fits(dpuserType x, dpuserType y);
dpuserType dpuserFunction_fits(dpuserType x, dpuserType y, dpuserType z);
dpuserType dpuserFunction_gauss(dpuserType x);
dpuserType dpuserFunction_gauss(dpuserType x, dpuserType y, dpuserType fwhm1, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_gauss(dpuserType x, dpuserType y, dpuserType fwhm1, dpuserType fwhm2, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_gauss(dpuserType x, dpuserType y, dpuserType fwhm1, dpuserType fwhm2, dpuserType angle, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_circle(dpuserType x, dpuserType y, dpuserType radius, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_ellipse(dpuserType x, dpuserType y, dpuserType radius1, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_ellipse(dpuserType x, dpuserType y, dpuserType radius1, dpuserType radius2, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_ellipse(dpuserType x, dpuserType y, dpuserType radius1, dpuserType radius2, dpuserType angle, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_rect(dpuserType x, dpuserType y, dpuserType width, dpuserType height);
dpuserType dpuserFunction_rect(dpuserType x, dpuserType y, dpuserType width, dpuserType height, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_delta(dpuserType x, dpuserType y, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_delta(dpuserType x, dpuserType y, dpuserType factor, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_cosbell(dpuserType x, dpuserType y, dpuserType radius1, dpuserType radius2, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_chinhat(dpuserType x, dpuserType y, dpuserType radius, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_airy(dpuserType diameter, dpuserType pixelscale, dpuserType wavelength, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_cubemedian(dpuserType X);
dpuserType dpuserFunction_cubemedian(dpuserType X, dpuserType reject);
dpuserType dpuserFunction_cubemedian(dpuserType X, dpuserType reject, dpuserType val);
dpuserType dpuserFunction_cubeavg(dpuserType X);
dpuserType dpuserFunction_cubeavg(dpuserType X, dpuserType reject);
dpuserType dpuserFunction_cubeavg(dpuserType X, dpuserType reject, dpuserType value);
dpuserType dpuserFunction_ssa(dpuserType X, dpuserType xcen, dpuserType ycen, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask, dpString resize = "");
dpuserType dpuserFunction_ssa(dpuserType X, dpuserType xcen, dpuserType ycen, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask, dpuserType method, dpString resize = "");
dpuserType dpuserFunction_mosaic(dpuserType X);
dpuserType dpuserFunction_mosaic(dpuserType X, dpuserType xshift, dpuserType yshift);
dpuserType dpuserFunction_mosaic(dpuserType X, dpuserType xshift, dpuserType yshift, dpuserType scaleFactor);
dpuserType dpuserFunction_shift(dpuserType arg, dpuserType sx, dpuserType sy, dpString option = "");
dpuserType dpuserFunction_rotate(dpuserType X, dpuserType angle);
dpuserType dpuserFunction_rotate(dpuserType X, dpuserType angle, dpuserType xcen);
dpuserType dpuserFunction_rotate(dpuserType X, dpuserType angle, dpuserType xcen, dpuserType ycen);
dpuserType dpuserFunction_fft(dpuserType X);
dpuserType dpuserFunction_reass(dpuserType X);
dpuserType dpuserFunction_norm(dpuserType X, dpString option = "");
dpuserType dpuserFunction_clip(dpuserType X, dpuserType low, dpuserType high);
dpuserType dpuserFunction_clip(dpuserType X, dpuserType low, dpuserType high, dpuserType value);
dpuserType dpuserFunction_smooth(dpuserType X, dpuserType fwhm, dpString option = "");
dpuserType dpuserFunction_boxcar(dpuserType X, dpuserType width, dpString option1 = "", dpString option2 = "");
dpuserType dpuserFunction_3dmerge(dpuserType X, dpuserType Y);
dpuserType dpuserFunction_3dmerge(dpuserType X, dpuserType Y, dpuserType tweak);
dpuserType dpuserFunction_3dmegacal(dpuserType X, dpuserType run, dpuserType band);
dpuserType dpuserFunction_3dcubin(dpuserType X, dpuserType year, dpuserType band, dpuserType scale);
dpuserType dpuserFunction_dpixcreate(dpuserType X, dpuserType threshold);
dpuserType dpuserFunction_dpixcreate(dpuserType X, dpuserType threshold, dpuserType boxsize);
dpuserType dpuserFunction_dpixcreate(dpuserType X, dpuserType threshold, dpuserType boxsize, dpuserType npass);
dpuserType dpuserFunction_dpixapply(dpuserType X, dpuserType dpl, dpString option = "");
dpuserType dpuserFunction_dpixapply(dpuserType X, dpuserType dpl, dpuserType boxsize, dpString option = "");
dpuserType dpuserFunction_enlarge(dpuserType X, dpuserType scale);
dpuserType dpuserFunction_enlarge(dpuserType X, dpuserType scale, dpuserType method);
dpuserType dpuserFunction_resize(dpuserType arg, dpuserType x, dpuserType y);
dpuserType dpuserFunction_wien(dpuserType arg, dpuserType psf);
dpuserType dpuserFunction_wien(dpuserType arg, dpuserType psf, dpuserType factor);
dpuserType dpuserFunction_lucy(dpuserType arg, dpuserType psf, dpuserType niter);
dpuserType dpuserFunction_lucy(dpuserType arg, dpuserType psf, dpuserType niter, dpuserType thresh);
dpuserType dpuserFunction_center(dpuserType arg);
dpuserType dpuserFunction_3dnorm(dpuserType X);
dpuserType dpuserFunction_conj(dpuserType X);
dpuserType dpuserFunction_correl(dpuserType X, dpuserType Y, dpString option = "");
dpuserType dpuserFunction_readfits(dpuserType arg);
dpuserType dpuserFunction_3dspec(dpuserType X, dpuserType Y);
dpuserType dpuserFunction_3dspec(dpuserType X, dpuserType xcenter, dpuserType ycenter);
dpuserType dpuserFunction_3dspec(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType r1, dpString option = "");
dpuserType dpuserFunction_3dspec(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType r1, dpuserType r2, dpString option = "");
dpuserType dpuserFunction_stddev(dpuserType X);
dpuserType dpuserFunction_stddev(dpuserType X, dpuserType ignore);
dpuserType dpuserFunction_variance(dpuserType X);
dpuserType dpuserFunction_variance(dpuserType X, dpuserType ignore);
dpuserType dpuserFunction_meddev(dpuserType X);
dpuserType dpuserFunction_saomark();
dpuserType dpuserFunction_random();
dpuserType dpuserFunction_random(dpuserType seed);
dpuserType dpuserFunction_import(dpuserType filename, dpString option = "");
dpuserType dpuserFunction_import(dpuserType filename, dpuserType x, dpString option = "");
dpuserType dpuserFunction_rebin(dpuserType X, dpuserType x1, dpuserType x2);
dpuserType dpuserFunction_stringarray(dpuserType X);
dpuserType dpuserFunction_nelements(dpuserType arg);
dpuserType dpuserFunction_ssastat(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask);
dpuserType dpuserFunction_ssastat(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask, dpuserType method);
dpuserType dpuserFunction_sssa(dpuserType X, dpuserType stats, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask);
dpuserType dpuserFunction_sssa(dpuserType X, dpuserType stats, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask, dpuserType method);
dpuserType dpuserFunction_ssaselect(dpuserType X, dpuserType x1, dpuserType x2, dpuserType x3, dpuserType x4, dpuserType x5);
dpuserType dpuserFunction_maxentropy(dpuserType X, dpuserType PSF, dpuserType n);
dpuserType dpuserFunction_maxentropy(dpuserType X, dpuserType PSF, dpuserType n, dpuserType mask);
dpuserType dpuserFunction_cubeminimum(dpuserType X);
dpuserType dpuserFunction_cubemaximum(dpuserType X);
dpuserType dpuserFunction_fwhm(dpuserType X, dpuserType xcenter, dpuserType ycenter);
dpuserType dpuserFunction_fwhm(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType radius);
dpuserType dpuserFunction_setbitpix(dpuserType X, dpuserType bitpix);
dpuserType dpuserFunction_setbitpix(dpuserType X, dpuserType bitpix, dpuserType bscale);
dpuserType dpuserFunction_setbitpix(dpuserType X, dpuserType bitpix, dpuserType bscale, dpuserType bzero);
dpuserType dpuserFunction_bytearray(dpuserType x);
dpuserType dpuserFunction_bytearray(dpuserType x, dpuserType y);
dpuserType dpuserFunction_bytearray(dpuserType x, dpuserType y, dpuserType z);
dpuserType dpuserFunction_shortarray(dpuserType x);
dpuserType dpuserFunction_shortarray(dpuserType x, dpuserType y);
dpuserType dpuserFunction_shortarray(dpuserType x, dpuserType y, dpuserType z);
dpuserType dpuserFunction_longarray(dpuserType x);
dpuserType dpuserFunction_longarray(dpuserType x, dpuserType y);
dpuserType dpuserFunction_longarray(dpuserType x, dpuserType y, dpuserType z);
dpuserType dpuserFunction_floatarray(dpuserType x);
dpuserType dpuserFunction_floatarray(dpuserType x, dpuserType y);
dpuserType dpuserFunction_floatarray(dpuserType x, dpuserType y, dpuserType z);
dpuserType dpuserFunction_doublearray(dpuserType x);
dpuserType dpuserFunction_doublearray(dpuserType x, dpuserType y);
dpuserType dpuserFunction_doublearray(dpuserType x, dpuserType y, dpuserType z);
dpuserType dpuserFunction_complexarray(dpuserType x);
dpuserType dpuserFunction_complexarray(dpuserType x, dpuserType y);
dpuserType dpuserFunction_complexarray(dpuserType x, dpuserType y, dpuserType z);
dpuserType dpuserFunction_shrink(dpuserType X, dpuserType factor);
dpuserType dpuserFunction_shrink(dpuserType X, dpuserType axis, dpuserType factor);
dpuserType dpuserFunction_getfitskey(dpuserType X, dpuserType key, dpString option = "");
dpuserType dpuserFunction_polyfit(dpuserType X, dpuserType N);
dpuserType dpuserFunction_polyfit(dpuserType X, dpuserType N, dpuserType chisq);
dpuserType dpuserFunction_sprintf(dpuserType format, dpuserType X);
dpuserType dpuserFunction_photometry(dpuserType X, dpuserType poslist, dpuserType reflist, dpuserType searchbox, dpuserType radius, dpString option = "k");
dpuserType dpuserFunction_transcoords(dpuserType masterlist, dpuserType refstars, dpuserType imstars, dpString option1 = "", dpString option2 = "");
dpuserType dpuserFunction_transcoords(dpuserType masterlist, dpuserType refstars, dpuserType imstars, dpuserType xerror, dpuserType yerror, dpString option1 = "", dpString option2 = "");
dpuserType dpuserFunction_findfile(dpuserType pattern);
dpuserType dpuserFunction_markpos(dpuserType X, dpString option = "");
dpuserType dpuserFunction_markpos(dpuserType X, dpuserType radius, dpString option = "");
dpuserType dpuserFunction_lmst(dpuserType jd);
dpuserType dpuserFunction_lmst(dpuserType jd, dpuserType latitude);
dpuserType dpuserFunction_wsa(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType threshold, dpuserType speckles, dpuserType smooth, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask);
dpuserType dpuserFunction_wsa(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType threshold, dpuserType speckles, dpuserType smooth, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask, dpuserType bigmask);
dpuserType dpuserFunction_swsa(dpuserType X, dpuserType flags, dpuserType xcenter, dpuserType ycenter, dpuserType threshold, dpuserType speckles, dpuserType smooth, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask);
dpuserType dpuserFunction_swsa(dpuserType X, dpuserType flags, dpuserType xcenter, dpuserType ycenter, dpuserType threshold, dpuserType speckles, dpuserType smooth, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask, dpuserType bigmask);
dpuserType dpuserFunction_centroids(dpuserType X, dpuserType positions, dpuserType radius);
dpuserType dpuserFunction_maxima(dpuserType X, dpuserType positions, dpuserType radius, dpString option = "");
dpuserType dpuserFunction_fileexists(dpuserType filename);
dpuserType dpuserFunction_filesize(dpuserType filename);
dpuserType dpuserFunction_dir(dpString option = "");
dpuserType dpuserFunction_dir(dpuserType directory, dpString option = "");
dpuserType dpuserFunction_polyfitxy(dpuserType X, dpuserType Y, dpuserType N);
dpuserType dpuserFunction_polyfitxy(dpuserType X, dpuserType Y, dpuserType N, dpuserType CHISQ);
dpuserType dpuserFunction_sort(dpuserType X, dpString option = "");
dpuserType dpuserFunction_char(dpuserType n);
dpuserType dpuserFunction_complex(dpuserType re, dpuserType im);
dpuserType dpuserFunction_strpos(dpuserType X, dpuserType Y, dpString option = "");
dpuserType dpuserFunction_clean(dpuserType IMAGE, dpuserType PSF, dpuserType N, dpuserType GAIN);
dpuserType dpuserFunction_clean(dpuserType IMAGE, dpuserType PSF, dpuserType N, dpuserType GAIN , dpuserType SUB);
dpuserType dpuserFunction_collapse(dpuserType image, dpuserType axis);
dpuserType dpuserFunction_magnify(dpuserType image, dpuserType scale);
dpuserType dpuserFunction_magnify(dpuserType image, dpuserType scale, dpuserType fwhm);
dpuserType dpuserFunction_wsastat(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType threshold, dpuserType speckles, dpuserType smooth, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask);
dpuserType dpuserFunction_wsastat(dpuserType X, dpuserType xcenter, dpuserType ycenter, dpuserType threshold, dpuserType speckles, dpuserType smooth, dpuserType sky, dpuserType flat, dpuserType dpl, dpuserType mask, dpuserType bigmask);
dpuserType dpuserFunction_gaussfit(dpuserType X, dpuserType Y, dpuserType errors, dpuserType estimate);
dpuserType dpuserFunction_gaussfit(dpuserType X, dpuserType Y, dpuserType errors, dpuserType estimate, dpuserType CHISQ);
dpuserType dpuserFunction_gauss2dfit(dpuserType image, dpuserType errors, dpuserType estimate);
dpuserType dpuserFunction_gauss2dfit(dpuserType image, dpuserType errors, dpuserType estimate, dpuserType CHISQ);
dpuserType dpuserFunction_polyfitxyerr(dpuserType X, dpuserType Y, dpuserType N, dpuserType error);
dpuserType dpuserFunction_polyfitxyerr(dpuserType X, dpuserType Y, dpuserType N, dpuserType error, dpuserType CHISQ);
dpuserType dpuserFunction_psf(dpuserType X, dpuserType positions, dpString option = "");
dpuserType dpuserFunction_pwd();
dpuserType dpuserFunction_quickgauss(dpuserType X, dpuserType Y, dpuserType FWHM, dpuserType speed, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_cblank(dpuserType ARRAY);
dpuserType dpuserFunction_cblank(dpuserType ARRAY, dpuserType val);
dpuserType dpuserFunction_now();
dpuserType dpuserFunction_pgband(dpuserType val0, dpuserType val1, dpuserType val2, dpuserType val3, dpuserType val4, dpuserType val5, dpuserType val6);
dpuserType dpuserFunction_pgbeg(dpuserType val0, dpuserType val1, dpuserType val2, dpuserType val3);
dpuserType dpuserFunction_pgbegin(dpuserType val0, dpuserType val1, dpuserType val2, dpuserType val3);
dpuserType dpuserFunction_pgcurs(dpuserType val0, dpuserType val1, dpuserType val2);
dpuserType dpuserFunction_pgcurse(dpuserType val0, dpuserType val1, dpuserType val2);
dpuserType dpuserFunction_pgopen(dpuserType val0);
dpuserType dpuserFunction_pgrnd(dpuserType val0, dpuserType val1);
dpuserType dpuserFunction_polar(dpuserType ampl, dpuserType arg);
dpuserType dpuserFunction_transmatrix(dpuserType refstars, dpuserType imstars, dpString option = "");
dpuserType dpuserFunction_transmatrix(dpuserType refstars, dpuserType imstars, dpuserType xerrors, dpuserType yerrors, dpString option = "");
dpuserType dpuserFunction_transform(dpuserType coords, dpuserType trans);
dpuserType dpuserFunction_invert(dpuserType X);
dpuserType dpuserFunction_transpose(dpuserType X);
dpuserType dpuserFunction_isvariable(dpuserType S);
dpuserType dpuserFunction_pi();
dpuserType dpuserFunction_convolve(dpuserType a, dpuserType b);
dpuserType dpuserFunction_gammp(dpuserType a, dpuserType x);
dpuserType dpuserFunction_reform(dpuserType X);
dpuserType dpuserFunction_reform(dpuserType X, dpuserType n1);
dpuserType dpuserFunction_reform(dpuserType X, dpuserType n1, dpuserType n2);
dpuserType dpuserFunction_reform(dpuserType X, dpuserType n1, dpuserType n2, dpuserType n3);
dpuserType dpuserFunction_find(dpuserType image, dpuserType hmin, dpuserType fwhm, dpString option = "");
dpuserType dpuserFunction_find(dpuserType image, dpuserType hmin, dpuserType fwhm, dpuserType roundlim, dpString option = "");
dpuserType dpuserFunction_find(dpuserType image, dpuserType hmin, dpuserType fwhm, dpuserType roundlim, dpuserType sharplim, dpString option = "");
dpuserType dpuserFunction_histogram(dpuserType X, dpString option = "");
dpuserType dpuserFunction_histogram(dpuserType X, dpuserType min, dpString option = "");
dpuserType dpuserFunction_histogram(dpuserType X, dpuserType min, dpuserType max, dpString option = "");
dpuserType dpuserFunction_histogram(dpuserType X, dpuserType min, dpuserType max, dpuserType binsize, dpString option = "");
dpuserType dpuserFunction_meandev(dpuserType X);
dpuserType dpuserFunction_meandev(dpuserType X, dpuserType omit);
dpuserType dpuserFunction_version();
dpuserType dpuserFunction_spifficube(dpuserType X, dpString option = "");
dpuserType dpuserFunction_spiffiuncube(dpuserType X, dpString option = "");
dpuserType dpuserFunction_spiffishift(dpuserType X, dpString option = "");
dpuserType dpuserFunction_bezier(dpuserType X);
dpuserType dpuserFunction_bezier(dpuserType X, dpuserType val);
dpuserType dpuserFunction_bezier1d(dpuserType X,dpuserType Y);
dpuserType dpuserFunction_moffat(dpuserType X, dpuserType Y, dpuserType power, dpuserType fwhm1, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_moffat(dpuserType X, dpuserType Y, dpuserType power, dpuserType fwhm1, dpuserType fwhm2, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_moffat(dpuserType X, dpuserType Y, dpuserType power, dpuserType fwhm1, dpuserType fwhm2, dpuserType angle, dpuserType naxis1, dpuserType naxis2);
dpuserType dpuserFunction_readfitsextension(dpuserType filename, dpuserType extension);
dpuserType dpuserFunction_readfitsextension(dpuserType filename, dpuserType extension, dpuserType x1, dpuserType x2);
dpuserType dpuserFunction_readfitsextension(dpuserType filename, dpuserType extension, dpuserType x1, dpuserType x2, dpuserType y1, dpuserType y2);
dpuserType dpuserFunction_readfitsextension(dpuserType filename, dpuserType extension, dpuserType x1, dpuserType x2, dpuserType y1, dpuserType y2, dpuserType z1, dpuserType z2);
dpuserType dpuserFunction_multigauss2dfit(dpuserType image, dpuserType errors, dpuserType estimate);
dpuserType dpuserFunction_multigauss2dfit(dpuserType image, dpuserType errors, dpuserType estimate, dpuserType chisq);
dpuserType dpuserFunction_sincfit(dpuserType X, dpuserType Y, dpuserType errors, dpuserType estimate);
dpuserType dpuserFunction_sincfit(dpuserType X, dpuserType Y, dpuserType errors, dpuserType estimate, dpuserType chisq);
dpuserType dpuserFunction_rebin1d(dpuserType spectrum, dpuserType xstart, dpuserType xend, dpuserType xdelta);
dpuserType dpuserFunction_rebin1d(dpuserType spectrum, dpuserType xstart, dpuserType xend, dpuserType xdelta, dpuserType xvalues);
dpuserType dpuserFunction_velmap(dpuserType cube, dpuserType center, dpuserType fwhm, dpString option = "");
dpuserType dpuserFunction_velmap(dpuserType cube, dpuserType center, dpuserType fwhm, dpuserType threshold, dpString option = "");
dpuserType dpuserFunction_fxcor(dpuserType templ, dpuserType spectrum);
dpuserType dpuserFunction_correlmap(dpuserType cube, dpuserType templ);
dpuserType dpuserFunction_longslit(dpuserType cube, dpuserType x, dpuserType y, dpuserType theta, dpuserType width);
dpuserType dpuserFunction_evalvelmap(dpuserType fit, dpuserType templ);
dpuserType dpuserFunction_sinfit(dpuserType X, dpuserType Y, dpuserType errors, dpuserType estimate);
dpuserType dpuserFunction_sinfit(dpuserType X, dpuserType Y, dpuserType errors, dpuserType estimate, dpuserType chisqIndex);
dpuserType dpuserFunction_voronoi(dpuserType X, dpuserType signal, dpuserType noise, dpuserType target, dpuserType targetSN, dpString option = "");
dpuserType dpuserFunction_gauss2dsimplefit(dpuserType image, dpuserType x, dpuserType y, dpuserType width);
dpuserType dpuserFunction_gauss2dsimplefit(dpuserType image, dpuserType x, dpuserType y, dpuserType width, dpuserType chisqIndex);
dpuserType dpuserFunction_transpoly(dpuserType ref, dpuserType im, dpuserType errors);
dpuserType dpuserFunction_strtrim(dpuserType X);
dpuserType dpuserFunction_right(dpuserType str, dpuserType nr);
dpuserType dpuserFunction_ten(dpuserType x, dpuserType y, dpuserType z);
dpuserType dpuserFunction_primes(dpuserType nr);
dpuserType dpuserFunction_twodcut(dpuserType X, dpuserType nr1, dpuserType nr2, dpuserType nr3, dpuserType nr4);
dpuserType dpuserFunction_simplifywhitespace(dpuserType s);
dpuserType dpuserFunction_strsplit(dpuserType s);
dpuserType dpuserFunction_strsplit(dpuserType s, dpuserType delimiter);
dpuserType dpuserFunction_sersic2dfit(dpuserType image, dpuserType errors, dpuserType estimate, dpuserType chisq);
dpuserType dpuserFunction_sersic2dsimplefit(dpuserType image, dpuserType x, dpuserType y, dpuserType width, dpuserType chisq, dpuserType fixed_n);
dpuserType dpuserFunction_sersicfit(dpuserType X, dpuserType Y, dpuserType error, dpuserType estimate, dpuserType chisq);
dpuserType dpuserFunction_sersic2d(dpuserType naxis1, dpuserType naxis2, dpuserType Re, dpuserType x0, dpuserType y0, dpuserType angle, dpuserType q, dpuserType n);
dpuserType dpuserFunction_randomg(dpuserType sigma);
dpuserType dpuserFunction_randomg(dpuserType sigma, dpuserType seed);
dpuserType dpuserFunction_polyfit2d(dpuserType &image, dpuserType &degree, dpuserType &chisq);
dpuserType dpuserFunction_polyfit2derr(dpuserType &image, dpuserType &degree, dpuserType &errors, dpuserType &chisq);
dpuserType dpuserFunction_poly(dpuserType x, dpuserType c);
dpuserType dpuserFunction_poly(dpuserType x, dpuserType c, dpuserType derivative);
dpuserType dpuserFunction_getbitpix(dpuserType x);
dpuserType dpuserFunction_isnan(dpuserType x);
dpuserType dpuserFunction_isinf(dpuserType x);
dpuserType dpuserFunction_identifylines(dpuserType peaks, dpuserType lines, dpuserType min_disp, dpuserType max_disp, dpuserType tolerance);
dpuserType dpuserFunction_evalgaussfit(dpuserType x, dpuserType fit);
dpuserType dpuserFunction_polyroots(dpuserType polynomial);
dpuserType dpuserFunction_polyroots(dpuserType polynomial, dpuserType derivative);
dpuserType dpuserFunction_readfitsbintable(dpuserType fname, dpuserType ext, dpuserType col);
dpuserType dpuserFunction_listfitsextensions(dpuserType fname);
dpuserType dpuserFunction_listtablecolumns(dpuserType fname, dpuserType ext);

///////////////////////////////////////////////////////////////////////////////////
//	not yet in dpuser
///////////////////////////////////////////////////////////////////////////////////
dpuserType dpuserFunction_where(dpuserType arg, char *cmp, dpuserType what);
dpuserType dpuserFunction_where(dpuserType arg, char *cmp, dpuserType what, dpuserType elements);
dpuserType dpuserFunction_pow(dpuserType arg, dpuserType arg1);
dpuserType dpuserFunction_modulo(dpuserType arg, dpuserType arg1);
dpuserType dpuserFunction_matrixmul(dpuserType arg, dpuserType arg1);

// END PARSE FOR DPUSER2C

///////////////////////////////////////////////////////////////////////////////////
//	helper functions
///////////////////////////////////////////////////////////////////////////////////
CJulianDay convertToJulianDay(dpuserType day, dpuserType month, dpuserType year, dpuserType hour, dpuserType minute, dpuserType second);
dpuserType createarray(int x, int y, int z, int b);//FitsBitpix b);
double calcpolyfit(dpuserType &rv, dpuserType X, dpuserType N);
bool calctranscoords(dpuserType &rv, double &xerr, double &yerr, const dpuserType &masterlist, const dpuserType &refstars, const dpuserType &imstars, const dpString &option1 = "", const dpString &option2 = "");
double calcpolyfitxy(dpuserType &rv, const dpuserType &X, const dpuserType &Y, const dpuserType &N);
double calcgaussfit(dpuserType &rv, const dpuserType &X, const dpuserType &Y, const dpuserType &errors, const dpuserType &estimate);
double calcgauss2dfit(dpuserType &rv, const dpuserType &image, const dpuserType &errors, const dpuserType &estimate);
double calcpolyfitxyerr(dpuserType &rv, const dpuserType &X, const dpuserType &Y, const dpuserType &N, const dpuserType &error);
dpuserType calctransmatrix(double &xerror, double &yerror, const dpuserType &refstars, const dpuserType &imstars, dpString option = "");
dpuserType calcreform(const int &nargs, const dpuserType &X, const dpuserType &n1, const dpuserType &n2, const dpuserType &n3);
double calcmultigauss2dfit(dpuserType &rv, const dpuserType &image, const dpuserType &errors, const dpuserType &estimate);
double calcsincfit(dpuserType &rv, const dpuserType &X, const dpuserType &Y, const dpuserType &errors, const dpuserType &estimate);
double calcsinfit(dpuserType &rv, const dpuserType &X, const dpuserType &Y, const dpuserType &errors, const dpuserType &estimate);
double calcgauss2dsimplefit(dpuserType &rv, const dpuserType &image, const dpuserType &x, const dpuserType &y, const dpuserType &width);
double calcsersic2dfit(dpuserType &rv, const dpuserType &image, const dpuserType &errors, const dpuserType &estimate);
//double calcsersic2dsimplefit(dpuserType &rv, const dpuserType &image, const dpuserType &x, const dpuserType &y, const dpuserType &width);
//double calcsersicfit(dpuserType &rv, const dpuserType &X, const dpuserType &Y, const dpuserType &error, const dpuserType &estimate);

#endif /* DPUSER2C_FUNCTIONS_H */
