/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.regex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.regex.JDK14RegexTranslator;
import net.sf.saxon.regex.JDK15RegexTranslator;
import net.sf.saxon.regex.JRegexIterator;
import net.sf.saxon.regex.JTokenIterator;
import net.sf.saxon.regex.RegexIterator;
import net.sf.saxon.regex.RegexSyntaxException;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.trans.DynamicError;
import net.sf.saxon.trans.XPathException;

public class JRegularExpression
implements RegularExpression {
    Pattern pattern;

    public JRegularExpression(CharSequence charSequence, boolean bl, CharSequence charSequence2) throws XPathException {
        try {
            int n = JRegularExpression.setFlags(charSequence2);
            String string = System.getProperty("java.version");
            if (string.startsWith("1.4")) {
                JDK14RegexTranslator jDK14RegexTranslator = new JDK14RegexTranslator();
                jDK14RegexTranslator.setIgnoreWhitespace((n & 4) != 0);
                String string2 = jDK14RegexTranslator.translate(charSequence, bl);
                this.pattern = Pattern.compile(string2, n & 0xFFFFFFFB);
            } else {
                boolean bl2 = (n & 4) != 0;
                boolean bl3 = (n & 2) != 0;
                String string3 = JDK15RegexTranslator.translate(charSequence, bl, bl2, bl3);
                this.pattern = Pattern.compile(string3, n & 0xFFFFFFF9);
            }
        }
        catch (RegexSyntaxException regexSyntaxException) {
            throw new DynamicError(regexSyntaxException.getMessage());
        }
    }

    public RegexIterator analyze(CharSequence charSequence) {
        return new JRegexIterator(charSequence.toString(), this.pattern);
    }

    public boolean containsMatch(CharSequence charSequence) {
        return this.pattern.matcher(charSequence).find();
    }

    public boolean matches(CharSequence charSequence) {
        return this.pattern.matcher(charSequence).matches();
    }

    public CharSequence replace(CharSequence charSequence, CharSequence charSequence2) throws XPathException {
        Matcher matcher = this.pattern.matcher(charSequence);
        try {
            String string = matcher.replaceAll(charSequence2.toString());
            return string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            int n = matcher.groupCount();
            if (n >= 9) {
                throw indexOutOfBoundsException;
            }
            String string = charSequence2.toString();
            String string2 = "\\$[" + (n + 1) + "-9]";
            String string3 = Pattern.compile(string2).matcher(string).replaceAll("");
            String string4 = matcher.replaceAll(string3);
            return string4;
        }
    }

    public SequenceIterator tokenize(CharSequence charSequence) {
        return new JTokenIterator(charSequence, this.pattern);
    }

    public static int setFlags(CharSequence charSequence) throws DynamicError {
        int n = 1;
        block6: for (int i = 0; i < charSequence.length(); ++i) {
            char c = charSequence.charAt(i);
            switch (c) {
                case 'm': {
                    n |= 8;
                    continue block6;
                }
                case 'i': {
                    n |= 2;
                    n |= 0x40;
                    continue block6;
                }
                case 's': {
                    n |= 0x20;
                    continue block6;
                }
                case 'x': {
                    n |= 4;
                    continue block6;
                }
                default: {
                    DynamicError dynamicError = new DynamicError("Invalid character '" + c + "' in regular expression flags");
                    dynamicError.setErrorCode("FORX0001");
                    throw dynamicError;
                }
            }
        }
        return n;
    }
}

