//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Mask/MaskEditorPropertyPanel.h
//! @brief     Defines class MaskEditorPropertyPanel
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_MASK_MASKEDITORPROPERTYPANEL_H
#define BORNAGAIN_GUI_VIEW_MASK_MASKEDITORPROPERTYPANEL_H

#include "GUI/View/Common/DataAccessWidget.h"
#include "GUI/View/Mask/MaskEditorFlags.h"
#include <QFormLayout>
#include <QListView>
#include <QModelIndex>
#include <functional>

class IntensityDataItem;
class IntensityDataPropertyWidget;
class MaskContainerModel;
class MaskItem;
class RealLimits;

//! Tool widget for MaskEditor

class MaskEditorPropertyPanel : public DataAccessWidget {
    Q_OBJECT
public:
    MaskEditorPropertyPanel(QWidget* parent = nullptr);

    void setJobOrRealItem(QObject* job_or_real_item) override;

    QSize sizeHint() const override;
    QSize minimumSizeHint() const override;

    void setMaskContext(MaskContainerModel* containerModel);

    void resetContext();
    void setPanelHidden(bool hidden);
    QItemSelectionModel* selectionModel();

signals:
    void itemContextMenuRequest(const QPoint& point);

private slots:
    void onSelectionChanged(const QItemSelection& selected, const QItemSelection&);
    void onCustomContextMenuRequested(const QPoint& point);

private:
    //! Set the current mask and creates the UI to edit the mask's properties
    void setCurrentMaskItem(MaskItem* maskItem);

    //! Add a spinbox to edit a mask's double value
    void addMaskSpinBox(const QString& label, std::function<double()> getter,
                        std::function<void(double)> setter, const RealLimits& limits);

    //! Add a checkbox to edit a mask's boolean value
    void addMaskCheckBox(const QString& title, std::function<bool()> getter,
                         std::function<void(bool)> setter);

    //! Return the mask item for the given index. nullptr if index invalid or not pointing to a mask
    //! item.
    MaskItem* maskItemForIndex(const QModelIndex& index);

    //! Creates the UI to edit the current mask's properties
    void createMaskEditorUI();

private:
    QListView* m_listView;
    IntensityDataPropertyWidget* m_propertyPanel;
    MaskContainerModel* m_maskContainerModel;
    IntensityDataItem* m_intensityDataItem;
    QFormLayout* m_maskPropertiesLayout;
    MaskItem* m_currentMaskItem; //!< the mask item whose properties shall be edited
    bool m_inhibitSelectionChange = false;
};

#endif // BORNAGAIN_GUI_VIEW_MASK_MASKEDITORPROPERTYPANEL_H
