/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.cobertura.reporting.xml;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.TreeSet;
import net.sourceforge.cobertura.coveragedata.ClassData;
import net.sourceforge.cobertura.coveragedata.JumpData;
import net.sourceforge.cobertura.coveragedata.LineData;
import net.sourceforge.cobertura.coveragedata.PackageData;
import net.sourceforge.cobertura.coveragedata.ProjectData;
import net.sourceforge.cobertura.coveragedata.SourceFileData;
import net.sourceforge.cobertura.coveragedata.SwitchData;
import net.sourceforge.cobertura.reporting.ComplexityCalculator;
import net.sourceforge.cobertura.util.FileFinder;
import net.sourceforge.cobertura.util.Header;
import net.sourceforge.cobertura.util.IOUtil;
import net.sourceforge.cobertura.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XMLReport {
    private static final Logger logger = LoggerFactory.getLogger(XMLReport.class);
    protected static final String coverageDTD = "coverage-04.dtd";
    private final PrintWriter pw;
    private final FileFinder finder;
    private final ComplexityCalculator complexity;
    private int indent = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLReport(ProjectData projectData, File destinationDir, FileFinder finder, ComplexityCalculator complexity) throws IOException {
        this.complexity = complexity;
        this.finder = finder;
        File file = new File(destinationDir, "coverage.xml");
        this.pw = IOUtil.getPrintWriter(file);
        try {
            this.println("<?xml version=\"1.0\"?>");
            this.println("<!DOCTYPE coverage SYSTEM \"http://cobertura.sourceforge.net/xml/coverage-04.dtd\">");
            this.println("");
            double ccn = complexity.getCCNForProject(projectData);
            int numLinesCovered = projectData.getNumberOfCoveredLines();
            int numLinesValid = projectData.getNumberOfValidLines();
            int numBranchesCovered = projectData.getNumberOfCoveredBranches();
            int numBranchesValid = projectData.getNumberOfValidBranches();
            this.println("<coverage line-rate=\"" + projectData.getLineCoverageRate() + "\" branch-rate=\"" + projectData.getBranchCoverageRate() + "\" lines-covered=\"" + numLinesCovered + "\" lines-valid=\"" + numLinesValid + "\" branches-covered=\"" + numBranchesCovered + "\" branches-valid=\"" + numBranchesValid + "\" complexity=\"" + ccn + "\" version=\"" + Header.version() + "\" timestamp=\"" + new Date().getTime() + "\">");
            this.increaseIndentation();
            this.dumpSources();
            this.dumpPackages(projectData);
            this.decreaseIndentation();
            this.println("</coverage>");
        }
        finally {
            this.pw.close();
        }
    }

    void increaseIndentation() {
        ++this.indent;
    }

    void decreaseIndentation() {
        if (this.indent > 0) {
            --this.indent;
        }
    }

    void indent() {
        for (int i = 0; i < this.indent; ++i) {
            this.pw.print("\t");
        }
    }

    void println(String ln) {
        this.indent();
        this.pw.println(ln);
    }

    private void dumpSources() {
        this.println("<sources>");
        this.increaseIndentation();
        for (String dir : this.finder.getSourceDirectoryList()) {
            this.dumpSource(dir);
        }
        this.decreaseIndentation();
        this.println("</sources>");
    }

    private void dumpSource(String sourceDirectory) {
        this.println("<source>" + sourceDirectory + "</source>");
    }

    private void dumpPackages(ProjectData projectData) {
        this.println("<packages>");
        this.increaseIndentation();
        Iterator it = projectData.getPackages().iterator();
        while (it.hasNext()) {
            this.dumpPackage((PackageData)it.next());
        }
        this.decreaseIndentation();
        this.println("</packages>");
    }

    private void dumpPackage(PackageData packageData) {
        logger.debug("Dumping package " + packageData.getName());
        this.println("<package name=\"" + packageData.getName() + "\" line-rate=\"" + packageData.getLineCoverageRate() + "\" branch-rate=\"" + packageData.getBranchCoverageRate() + "\" complexity=\"" + this.complexity.getCCNForPackage(packageData) + "\"" + ">");
        this.increaseIndentation();
        this.dumpSourceFiles(packageData);
        this.decreaseIndentation();
        this.println("</package>");
    }

    private void dumpSourceFiles(PackageData packageData) {
        this.println("<classes>");
        this.increaseIndentation();
        Iterator it = packageData.getSourceFiles().iterator();
        while (it.hasNext()) {
            this.dumpClasses((SourceFileData)it.next());
        }
        this.decreaseIndentation();
        this.println("</classes>");
    }

    private void dumpClasses(SourceFileData sourceFileData) {
        Iterator it = sourceFileData.getClasses().iterator();
        while (it.hasNext()) {
            this.dumpClass((ClassData)it.next());
        }
    }

    private void dumpClass(ClassData classData) {
        logger.debug("Dumping class " + classData.getName());
        this.println("<class name=\"" + classData.getName() + "\" filename=\"" + classData.getSourceFileName() + "\" line-rate=\"" + classData.getLineCoverageRate() + "\" branch-rate=\"" + classData.getBranchCoverageRate() + "\" complexity=\"" + this.complexity.getCCNForClass(classData) + "\"" + ">");
        this.increaseIndentation();
        this.dumpMethods(classData);
        this.dumpLines(classData);
        this.decreaseIndentation();
        this.println("</class>");
    }

    private void dumpMethods(ClassData classData) {
        this.println("<methods>");
        this.increaseIndentation();
        TreeSet<String> sortedMethods = new TreeSet<String>();
        sortedMethods.addAll(classData.getMethodNamesAndDescriptors());
        Iterator iter = sortedMethods.iterator();
        while (iter.hasNext()) {
            this.dumpMethod(classData, (String)iter.next());
        }
        this.decreaseIndentation();
        this.println("</methods>");
    }

    private void dumpMethod(ClassData classData, String nameAndSig) {
        String name = nameAndSig.substring(0, nameAndSig.indexOf(40));
        String signature = nameAndSig.substring(nameAndSig.indexOf(40));
        double lineRate = classData.getLineCoverageRate(nameAndSig);
        double branchRate = classData.getBranchCoverageRate(nameAndSig);
        int methodComplexity = this.complexity.getCCNForMethod(classData, name, signature);
        this.println("<method name=\"" + XMLReport.xmlEscape(name) + "\" signature=\"" + XMLReport.xmlEscape(signature) + "\" line-rate=\"" + lineRate + "\" branch-rate=\"" + branchRate + "\" complexity=\"" + methodComplexity + "\">");
        this.increaseIndentation();
        this.dumpLines(classData, nameAndSig);
        this.decreaseIndentation();
        this.println("</method>");
    }

    private static String xmlEscape(String str) {
        str = StringUtil.replaceAll(str, "<", "&lt;");
        str = StringUtil.replaceAll(str, ">", "&gt;");
        return str;
    }

    private void dumpLines(ClassData classData) {
        this.dumpLines(classData.getLines());
    }

    private void dumpLines(ClassData classData, String methodNameAndSig) {
        this.dumpLines(classData.getLines(methodNameAndSig));
    }

    private void dumpLines(Collection lines) {
        this.println("<lines>");
        this.increaseIndentation();
        TreeSet sortedLines = new TreeSet();
        sortedLines.addAll(lines);
        Iterator iter = sortedLines.iterator();
        while (iter.hasNext()) {
            this.dumpLine((LineData)iter.next());
        }
        this.decreaseIndentation();
        this.println("</lines>");
    }

    private void dumpLine(LineData lineData) {
        int lineNumber = lineData.getLineNumber();
        long hitCount = lineData.getHits();
        boolean hasBranch = lineData.hasBranch();
        String conditionCoverage = lineData.getConditionCoverage();
        String lineInfo = "<line number=\"" + lineNumber + "\" hits=\"" + hitCount + "\" branch=\"" + hasBranch + "\"";
        if (hasBranch) {
            this.println(lineInfo + " condition-coverage=\"" + conditionCoverage + "\">");
            this.dumpConditions(lineData);
            this.println("</line>");
        } else {
            this.println(lineInfo + "/>");
        }
    }

    private void dumpConditions(LineData lineData) {
        this.increaseIndentation();
        this.println("<conditions>");
        for (int i = 0; i < lineData.getConditionSize(); ++i) {
            Object conditionData = lineData.getConditionData(i);
            String coverage = lineData.getConditionCoverage(i);
            this.dumpCondition(conditionData, coverage);
        }
        this.println("</conditions>");
        this.decreaseIndentation();
    }

    private void dumpCondition(Object conditionData, String coverage) {
        this.increaseIndentation();
        StringBuffer buffer = new StringBuffer("<condition");
        if (conditionData instanceof JumpData) {
            JumpData jumpData = (JumpData)conditionData;
            buffer.append(" number=\"").append(jumpData.getConditionNumber()).append("\"");
            buffer.append(" type=\"").append("jump").append("\"");
            buffer.append(" coverage=\"").append(coverage).append("\"");
        } else {
            SwitchData switchData = (SwitchData)conditionData;
            buffer.append(" number=\"").append(switchData.getSwitchNumber()).append("\"");
            buffer.append(" type=\"").append("switch").append("\"");
            buffer.append(" coverage=\"").append(coverage).append("\"");
        }
        buffer.append("/>");
        this.println(buffer.toString());
        this.decreaseIndentation();
    }
}

