/*
 * drive-sound.c - Drive sound for 1541 and friends
 *
 * Written by
 *  Kajtar Zsolt <soci@c64.rulez.org>
 *
 * This file is part of VICE, the Versatile Commodore Emulator.
 * See README for copyright notice.
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 *  02111-1307  USA.
 *
 */

#include "vice.h"

#include "archdep.h"
#include "drive.h"
#include "drive-sound.h"
#include "sound.h"

static const signed char hum[] = {
    0, -1, -2, -3, -2, 0, 3, 5, 6, 5, 3, 0, -3, -5, -6, -4, -2, 1, 2, 3, 3, 3,
    3, 2, 0, -3, -4, -4, -1, 2, 5, 5, 3, -1, -5, -6, -6, -4, -2, -1, 0, 0, 0,
    0, 1, 1, 1, 1, 1, 1, 1, 2, 2, 1, 1, 0, 0, -1, -1, -2, -2, -1, 2, 2, 1, -1,
    -1, 3, 7, 9, 7, 2, -3, -4, -2, 0, 2, 3, 2, 1, 0, -3, -5, -5, -4, -2, 0, 3,
    5, 7, 8, 6, 2, -3, -7, -9, -8, -7, -5, -2, 0, 0, -1, -4, -6, -6, -3, 0, 2,
    2, 1, 0, -1, -3, -5, -7, -6, -2, 2, 3, 0, -4, -6, -4, 1, 5, 5, 2, -2, -6,
    -7, -5, -2, 2, 6, 8, 7, 3, 0, -3, -3, -4, -6, -8, -8, -3, 2, 6, 6, 4, 2, 1,
    1, 0, -1, -1, 0, 2, 2, 0, -3, -6, -6, -5, -1, 3, 6, 7, 4, 0, -3, -5, -3,
    -1, 1, 2, 3, 4, 5, 4, 1, -3, -6, -7, -6, -4, 0, 3, 4, 5, 4, 2, 0, -2, -3,
    -1, 0, 1, 0, -2, -4, -4, -4, -3, -2, -2, -2, 0, 1, 3, 4, 3, 2, 0, -2, -3,
    -2, -1, -1, -2, -4, -3, -1, 1, 0, -2, -5, -5, -3, 0, 2, 1, -1, -1, 2, 4, 4,
    0, -4, -7, -7, -4, -2, -1, -2, -3, -3, -1, 3, 5, 4, 1, -2, -4, -3, -1, 0,
    0, -1, -1, 0, 1, 1, 1, 0, 0, 0, 1, 1, 1, 0, 0, 1, 3, 5, 7, 8, 5, 1, -3, -4,
    -2, 2, 3, 2, 0, 0, 1, 3, 4, 3, 3, 3, 3, 2, 0, -3, -5, -7, -8, -8, -6, -2,
    2, 3, 0, -5, -8, -6, -2, 2, 2, -1, -5, -7, -8, -7, -6, -4, -3, -3, -4, -6,
    -7, -5, -2, 1, 1, -1, -4, -6, -6, -3, 1, 4, 6, 4, 1, -2, -3, -2, 0, 1, 1,
    0, -1, -1, 0, 1, 4, 6, 8, 9, 7, 3, -1, -6, -7, -6, -1, 6, 11, 12, 9, 5, 0,
    -2, -2, -2, -3, -2, 0, 4, 7, 7, 3, -2, -7, -8, -5, 0, 3, 4, 1, -2, -5, -5,
    -3, -2, -1, -1, -1, -1, 0, 0, -1, -3, -5, -5, -5, -4, -2, -1, 0, 0, -1, -2,
    -3, -2, -1, 1, 4, 5, 3, -1, -7, -11, -10, -4, 1, 4, 3, -1, -4, -5, -4, -3,
    -1, 0, 1, 0, -2, -4, -5, -2, 3, 8, 9, 4, -5, -14, -18, -16, -8, 4, 13, 18,
    15, 7, -2, -8, -8, -3, 2, 5, 3, -1, -3, -2, 2, 5, 5, 3, 0, 0, 2, 5, 7, 5,
    0, -6, -10, -10, -5, 4, 12, 14, 10, 3, -4, -6, -4, -2, -1, -2, -4, -4, -3,
    -1, 2, 4, 3, 0, -4, -6, -5, -2, 1, 2, -1, -4, -6, -4, 0, 5, 8, 7, 2, -4,
    -7, -8, -6, -4, -3, -3, -2, -1, 3, 6, 8, 8, 4, -3, -10, -13, -11, -5, 1, 4,
    5, 6, 6, 5, 1, -6, -13, -15, -11, -4, 4, 9, 10, 5, -2, -8, -11, -9, -4, 0,
    1, 0, -1, 0, 2, 2, -1, -6, -9, -7, -1, 7, 10, 7, -1, -7, -10, -7, -3, 3, 7,
    9, 9, 6, 2, -2, -4, -4, -4, -4, -5, -5, -2, 3, 6, 7, 7, 7, 6, 4, 3, 0, -2,
    -5, -8, -8, -5, 0, 5, 8, 6, 3, 1, -1, -2, -3, -4, -4, -2, 0, 3, 7, 9, 8, 2,
    -5, -9, -8, -4, -2, -3, -7, -9, -5, 2, 9, 11, 8, 2, -5, -8, -10, -9, -8,
    -6, -4, -1, 5, 9, 11, 9, 3, -4, -8, -10, -9, -7, -5, -3, 0, 3, 5, 6, 5, 1,
    -3, -7, -10, -9, -5, 0, 3, 4, 3, 2, 2, 1, -1, -3, -5, -6, -6, -5, -3, 0, 2,
    3, 2, 1, 0, 0, 0, 1, 2, 0, -3, -7, -8, -4, 6, 15, 18, 13, 3, -7, -12, -11,
    -5, 1, 6, 9, 10, 9, 6, 1, -3, -5, -4, 0, 5, 9, 10, 8, 6, 2, -1, -5, -8, -9,
    -7, -4, 0, 1, 1, -1, -2, -4, -7, -9, -10, -8, -4, 1, 4, 4, 3, 0, -3, -7,
    -12, -15, -14, -11, -6, -1, 3, 4, 4, 4, 4, 3, 0, -5, -9, -10, -7, -2, 2, 4,
    2, 0, 0, 1, 4, 6, 6, 5, 2, -2, -4, -4, -2, 1, 4, 6, 7, 6, 5, 2, -2, -5, -6,
    -2, 4, 9, 12, 11, 7, 0, -6, -10, -9, -3, 4, 10, 10, 6, 1, -3, -5, -4, -4,
    -5, -5, -4, 0, 6, 10, 10, 6, 1, -5, -8, -9, -8, -4, 0, 4, 5, 5, 2, -1, -5,
    -7, -8, -7, -4, 0, 2, 2, 0, -3, -5, -5, -1, 2, 4, 2, -2, -5, -5, -2, 2, 2,
    -3, -10, -14, -10, -2, 7, 10, 4, -4, -10, -10, -4, 2, 5, 5, 3, -1, -4, -6,
    -5, -3, 1, 4, 3, -1, -5, -6, -5, -1, 2, 4, 5, 3, 0, -1, -1, 2, 6, 7, 3, -3,
    -6, -3, 3, 9, 10, 5, -2, -6, -5, -2, 3, 5, 4, 1, -3, -4, -3, 1, 5, 7, 6, 3,
    -1, -3, -2, 0, 1, 1, -1, -4, -6, -6, -4, 0, 4, 5, 1, -5, -9, -9, -3, 5, 9,
    6, -2, -10, -11, -4, 5, 11, 10, 2, -7, -13, -12, -8, -4, -1, 0, 1, 2, 3, 4,
    4, 3, 1, -1, -3, -3, -2, 1, 3, 3, 0, -4, -8, -9, -6, -1, 5, 8, 6, 2, -3,
    -4, -3, 0, 2, 1, -1, -3, -3, -1, 1, 2, 2, -1, -4, -8, -8, -6, -3, -1, 0, 1,
    2, 4, 5, 4, 2, 0, -1, -1, -3, -6, -8, -7, -2, 3, 6, 5, 2, -1, -3, -4, -4,
    -3, 1, 6, 10, 9, 5, -1, -4, -5, -4, -2, 0, 2, 3, 2, -1, -3, -2, 2, 5, 6, 3,
    1, -1, 0, 0, -1, -3, -4, -1, 2, 4, 4, 1, -1, -2, -2, -2, -1, 0, 2, 4, 5, 4,
    3, 2, 0, -2, -5, -7, -7, -4, 0, 2, 2, -1, -3, -3, -2, -2, -3, -3, -3, -1,
    1, 1, -1, -4, -7, -8, -8, -7, -5, -4, -2, 0, 2, 2, 0, -4, -7, -8, -8, -6,
    -5, -3, 1, 5, 8, 8, 4, -1, -4, -3, 0, 2, 2, -1, -4, -5, -3, 0, 2, 3, 2, 3,
    4, 6, 8, 7, 4, -1, -4, -3, 1, 6, 8, 5, 2, -1, -1, 0, 1, 0, -2, -3, 0, 5, 9,
    10, 5, -3, -9, -10, -5, 2, 7, 7, 4, -1, -3, -3, -2, -1, -2, -3, -5, -5, -3,
    -1, 2, 4, 5, 3, -1, -6, -10, -11, -9, -5, 0, 2, 2, -1, -4, -5, -3, 1, 3, 3,
    1, 0, -1, -2, -5, -8, -11, -10, -5, 1, 5, 5, 2, -3, -5, -5, -2, 1, 2, 1, 0,
    1, 2, 3, 2, -2, -5, -4, -1, 2, 3, 1, -1, -1, -1, -1, -2, -2, -2, -1, 1, 1,
    1, 2, 3, 4, 4, 1, -2, -4, -3, -1, 1, 3, 3, 3, 3, 2, 1, 0, 0, 1, 2, 2, 0,
    -2, -2, 0, 5, 7, 7, 3, -1, -3, -2, 1, 3, 4, 3, 1, -2, -4, -5, -6, -8, -8,
    -6, -3, 2, 5, 5, 3, 1, -1, -2, -2, -2, -2, -3, -3, -4, -5, -6, -7, -7, -5,
    -2, 1, 3, 3, 1, -1, -3, -2, 0, 3, 3, 1, -2, -4, -6, -6, -6, -6, -5, -4, 0,
    5, 9, 8, 3, -4, -9, -10, -7, 0, 6, 8, 6, 2, -2, -5, -6, -7, -8, -8, -5, -1,
    2, 4, 3, 1, 0, -1, -1, 0, 1, 3, 3, 2, 0, -2, -1, 1, 3, 4, 4, 3, 3, 2, 1, 0,
    1, 3, 7, 8, 6, 2, -1, -2, 1, 4, 5, 3, 0, -2, -2, 0, 1, 2, 2, 1, 1, 0, -2,
    -4, -7, -7, -6, -4, -2, -1, 0, 1, 2, 2, -1, -5, -10, -12, -10, -4, 3, 7, 6,
    1, -7, -13, -15, -11, -3, 4, 6, 4, 1, -2, -5, -6, -7, -6, -2, 3, 7, 6, 3,
    0, -2, -2, -3, -4, -5, -4, -1, 3, 6, 6, 3, -2, -6, -6, -3, 2, 4, 5, 4, 3,
    2, 1, 0, -1, -1, -1, -1, 0, 2, 3, 2, 0, -3, -6, -5, -1, 4, 9, 11, 10, 8, 4,
    0, -4, -7, -6, -2, 3, 5, 5, 2, 0, 0, 2, 4, 5, 5, 4, 3, 3, 3, 1, -1, -4, -5,
    -5, -3, -1, 1, 1, -1, -4, -5, -5, -4, -2, -1, 0, 0, -1, -2, -5, -8, -10,
    -11, -11, -11, -11, -9, -4, 2, 6, 5, 0, -8, -14, -14, -8, 0, 6, 7, 4, -1,
    -4, -5, -3, -1, -1, -4, -7, -7, -4, 2, 8, 9, 8, 6, 7, 9, 10, 9, 5, 0, -3,
    -3, 0, 4, 6, 6, 5, 2, -1, -2, -1, 1, 4, 6, 7, 6, 4, 1, -2, -2, 0, 2, 3, 2,
    0, -1, -2, -2, -4, -7, -10, -10, -7, -3, 2, 4, 5, 5, 4, 2, -1, -4, -6, -5,
    -2, 0, 1, 0, -2, -5, -8, -10, -9, -5, 0, 3, 2, -2, -5, -4, 0, 4, 3, -2, -6,
    -7, -4, 0, 2, 1, -1, -3, -5, -7, -9, -8, -3, 3, 10, 12, 8, 2, -5, -10, -11,
    -8, -4, 1, 6, 9, 10, 7, 2, -3, -4, -2, 3, 5, 4, 1, -2, -2, 1, 4, 5, 4, 3,
    3, 4, 7, 8, 7, 3, -5, -13, -15, -9, 3, 15, 20, 17, 7, -5, -12, -13, -8, -1,
    2, 1, -3, -6, -3, 3, 9, 10, 3, -7, -14, -15, -9, -2, 4, 5, 3, -1, -5, -7,
    -6, -2, 1, 3, 1, -3, -6, -7, -5, -4, -4, -4, -2, 1, 6, 7, 5, 0, -7, -12,
    -12, -8, -2, 3, 6, 6, 4, 3, 3, 2, -1, -6, -10, -11, -5, 4, 11, 13, 8, -1,
    -7, -8, -4, 0, 0, -3, -6, -4, 2, 8, 10, 5, -3, -9, -8, -2, 6, 10, 7, -1,
    -9, -14, -14, -9, -2, 5, 9, 10, 8, 4, -1, -5, -6, -5, -2, 0, 0, 0, 0, 2, 4,
    5, 4, 1, -2, -2, -1, 2, 3, 1, -1, -3, -1, 5, 10, 12, 10, 3, -5, -11, -12,
    -10, -7, -3, 0, 3, 7, 9, 9, 5, -1, -6, -8, -7, -5, -6, -8, -8, -5, 2, 9,
    12, 9, 3, -3, -7, -9, -9, -9, -8, -5, 1, 7, 11, 13, 11, 6, 0, -7, -11, -12,
    -10, -6, -1, 4, 6, 7, 6, 4, 1, -3, -6, -8, -6, -2, 3, 6, 5, 2, 0, 0, 2, 2,
    0, -5, -10, -12, -12, -10, -5, -1, 2, 3, 3, 2, 2, 3, 3, 1, -2, -5, -6, -6,
    -3, -1, 1, 3, 3, 3, 3, 3, 3, 3, 3, 3, 4, 6, 6, 6, 4, 2, 0, -2, -3, -3, -1,
    2, 5, 7, 6, 2, -3, -7, -8, -7, -2, 4, 9, 10, 7, 2, -5, -12, -17, -18, -15,
    -8, 0, 6, 9, 8, 5, 1, -4, -8, -10, -11, -9, -5, 0, 2, 2, 1, 0, 0, 0, -1,
    -4, -8, -11, -11, -6, 0, 5, 7, 6, 3, 0, 0, 2, 4, 6, 6, 4, 1, 0, 1, 1, 0,
    -3, -8, -9, -7, -2, 3, 6, 6, 5, 4, 4, 5, 5, 4, 2, -3, -7, -9, -9, -5, 1, 5,
    8, 7, 3, 0, -2, -4, -5, -6, -6, -4, 1, 8, 13, 14, 10, 3, -5, -10, -11, -8,
    -1, 6, 9, 7, 0, -7, -10, -8, -4, 1, 4, 5, 3, 2, 0, 0, -1, -3, -6, -7, -6,
    -4, -2, -2, -1, 1, 3, 4, 2, -2, -7, -8, -5, -1, 1, -1, -4, -5, -3, 1, 5, 6,
    4, 1, -2, -3, -4, -4, -4, -3, -2, -1, 0, -1, -2, -2, -1, 1, 4, 6, 5, 0, -6,
    -10, -7, 0, 6, 6, 0, -9, -12, -6, 4, 12, 12, 5, -3, -7, -5, 0, 4, 3, 0, -3,
    -2, 1, 4, 6, 4, 2, -1, -2, -4, -5, -6, -4, 1, 6, 8, 5, -1, -5, -4, 1, 6, 5,
    0, -6, -8, -4, 2, 7, 7, 3, -1, -4, -3, 0, 2, 2, 0, -3, -5, -5, -3, 0, 2, 2,
    0, -2, -3, -3, -3, -2, -2, -3, -4, -7, -8, -8, -5, -1, 3, 5, 3, -1, -6, -8,
    -7, -3, 3, 8, 8, 4, -1, -6, -7, -5, -2, 0, -1, -4, -6, -4, 1, 7, 8, 4, -2,
    -7, -6, -2, 3, 5, 3, 0, -3, -4, -4, -3, -1, -1, -2, -3, -2, 2, 7, 10, 9, 4,
    -1, -4, -3, -2, -2, -3, -3, -1, 2, 4, 5, 3, 2, 1, 1, 1, 1, 1, 0, -2, -4,
    -7, -7, -4, 1, 5, 7, 6, 3, -1, -2, -3, -2, 0, 1, 3, 4, 4, 3, 1, -1, -3, -5,
    -6, -7, -5, -2, 2, 6, 7, 6, 3, -1, -5, -7, -6, -3, 2, 4, 3, -1, -6, -8, -7,
    -3, 0, 1, 0, -1, 0, 0, -2, -4, -5, -5, -2, 1, 2, 0, -3, -5, -4, -2, 2, 4,
    4, 2, -2, -6, -10, -12, -12, -8, -3, 3, 8, 10, 9, 5, 0, -3, -3, -1, 2, 2,
    0, -4, -6, -5, -3, 0, 1, 0, -1, 1, 6, 9, 10, 7, 3, 1, 1, 3, 4, 3, 0, -3,
    -3, -1, 1, 2, 1, 1, 2, 4, 5, 3, 0, -3, -4, -2, 3, 6, 7, 3, -4, -8, -9, -7,
    -3, -1, -2, -4, -6, -5, -3, 0, 1, 1, 1, 2, 2, 1, -1, -4, -6, -5, -4, -2,
    -2, -2, -3, -3, -2, 0, 2, 3, 2, 0, -3, -4, -5, -4, -4, -3, -4, -3, -2, 0,
    1, 1, 1, 0, -1, -2, -2, -1, -1, 0, 1, 1, 0, -2, -3, -4, -4, -1, 2, 5, 6, 5,
    2, -1, -4, -6, -8, -9, -7, -3, 3, 9, 11, 8, 2, -3, -5, -4, -1, 1, 0, -1,
    -2, 0, 3, 7, 10, 11, 8, 3, -1, -3, -1, 2, 4, 5, 4, 2, 1, 0, -1, -2, -1, 0,
    2, 3, 3, 2, -1, -5, -7, -8, -7, -3, 1, 5, 5, 4, 0, -5, -8, -8, -6, -1, 2,
    2, -1, -6, -8, -8, -4, 1, 3, 4, 2, 1, -1, -4, -7, -9, -9, -7, -3, 1, 1, 1,
    0, -1, -2, -3, -5, -6, -4, 1, 6, 8, 5, -1, -8, -12, -13, -8, 1, 10, 15, 12,
    3, -7, -12, -11, -6, -2, -1, -2, -2, 0, 3, 5, 6, 4, 3, 1, -1, -3, -3, -1,
    1, 3, 4, 3, 1, 0, 1, 3, 6, 9, 8, 6, 2, -1, -1, 2, 4, 6, 5, 4, 2, 2, 2, 1,
    -1, -3, -5, -6, -6, -4, -2, 1, 3, 4, 4, 2, -2, -6, -10, -9, -6, -3, -2, -3,
    -5, -7, -6, -5, -5, -6, -6, -5, -1, 3, 4, 2, -3, -9, -11, -9, -4, 1, 4, 5,
    2, -1, -4, -6, -6, -4, 0, 4, 6, 5, 2, -2, -2, 0, 3, 5, 4, 2, 0, -1, 0, 2,
    3, 4, 3, 1, -1, -2, -1, 0, 2, 2, 2, 1, 1, 0, -1, -3, -3, -3, 0, 3, 6, 7, 6,
    4, 2, -2, -7, -10, -10, -4, 4, 9, 9, 3, -3, -7, -7, -4, -1, 1, 2, 3, 3, 2,
    0, -1, -1, -2, -4, -5, -4, -1, 4, 6, 4, -2, -8, -11, -8, -1, 4, 6, 4, -1,
    -4, -6, -6, -5, -3, 0, 2, 3, 2, -1, -3, -4, -4, -4, -5, -8, -9, -7, -1, 6,
    8, 6, 0, -6, -6, -3, 2, 5, 6, 4, 2, 1, 1, 1, 1, -2, -5, -7, -5, 0, 7, 10,
    10, 6, 2, 0, -1, 0, -1, -1, -1, 1, 5, 6, 4, 0, -3, -3, -1, 2, 3, 0, -3, -4,
    -3, 1, 4, 5, 3, -1, -3, -3, -2, -1, -2, -4, -5, -5, -3, -1, -1, -3, -7, -9,
    -7, -2, 3, 4, 1, -3, -5, -4, -2, -1, -2, -3, -1, 3, 5, 3, -1, -6, -7, -6,
    -2, 0, 0, 0, -1, 1, 3, 6, 8, 6, 3, 0, -1, 0, 0, -2, -6, -8, -7, -4, -2, 0,
    0, 2, 4, 5, 3, 0, -4, -6, -5, -3, 0, 3, 7, 8, 7, 2, -5, -10, -10, -7, -2,
    0, 0, -1, 0, 3, 4, 3, 1, -1, 0, 3, 7, 8, 6, 2, -6, -13, -17, -14, -3, 10,
    20, 20, 12, 0, -10, -13, -10, -4, 2, 5, 5, 3, 1, 2, 5, 10, 10, 5, -4, -11,
    -13, -10, -3, 1, 1, -2, -4, -4, 0, 5, 7, 5, 0, -6, -10, -11, -9, -6, -3,
    -1, 1, 2, 3, 5, 5, 3, -1, -8, -13, -14, -10, -4, 1, 3, 4, 6, 9, 10, 7, -1,
    -10, -15, -13, -5, 4, 9, 7, 1, -6, -9, -8, -3, 2, 4, 1, -2, -2, 1, 4, 4, 0,
    -7, -10, -6, 3, 13, 17, 11, -1, -12, -17, -15, -8, -1, 3, 5, 7, 9, 8, 5, 0,
    -2, -2, -1, -1, -2, -3, 0, 4, 7, 7, 4, 1, 1, 3, 4, 2, -2, -5, -5, -4, -2,
    -1, 2, 5, 9, 9, 6, 0, -6, -10, -11, -9, -5, -1, 2, 4, 3, -1, -5, -7, -6,
    -5, -6, -8, -11, -10, -3, 7, 15, 16, 10, 0, -6, -7, -4, -2, -3, -6, -8, -6,
    0, 6, 9, 7, 2, -4, -7, -7, -4, -1, 1, 1, 0, -1, -2, -1, 2, 4, 4, 1, -6,
    -13, -17, -14, -6, 3, 10, 12, 11, 7, 2, -3, -6, -7, -5, -3, -3, -2, 0, 4,
    7, 7, 3, -1, -4, -2, 1, 4, 5, 3, 0, -2, -3, -2, 1, 4, 6, 6, 5, 4, 3, 3, 1,
    0, 0, 1, 3, 4, 2, 0, 0, 2, 6, 7, 5, 2, -1, -3, -4, -7, -11, -12, -10, -3,
    4, 8, 6, 2, -2, -5, -8, -11, -15, -17, -14, -7, 1, 6, 6, 3, -1, -5, -9,
    -13, -16, -17, -14, -8, 0, 7, 10, 9, 4, -3, -8, -9, -8, -5, -2, 0, 1, 2, 2,
    1, 0, -1, 1, 5, 11, 15, 15, 11, 4, -2, -3, -1, 2, 3, 3, 3, 5, 7, 9, 7, 3,
    -1, -1, 1, 5, 6, 5, 2, -1, -2, -3, -4, -4, -3, 0, 2, 4, 4, 1, -3, -7, -9,
    -9, -7, -3, 1, 5, 9, 10, 8, 1, -8, -15, -17, -12, -3, 6, 10, 9, 3, -3, -8,
    -10, -10, -8, -4, 2, 6, 6, 2, -5, -10, -11, -8, -3, 2, 5, 5, 3, 0, -3, -6,
    -8, -9, -7, -4, 1, 6, 9, 7, 1, -7, -12, -11, -5, 3, 8, 6, 1, -4, -6, -3, 1,
    4, 5, 3, 0, -3, -5, -4, 0, 5, 9, 10, 6, 1, -3, -4, -2, 2, 5, 6, 4, 2, 0,
    -1, 0, 2, 3, 3, 1, -1, -3, -3, -1, 2, 4, 5, 3, 0, -4, -5, -4, -1, 3, 3, 0,
    -5, -8, -8, -3, 3, 6, 5, -1, -7, -7, -1, 7, 13, 11, 1, -9, -14, -11, -1, 8,
    11, 6, -3, -11, -12, -7, 1, 7, 8, 5, 0, -4, -4, -3, -1, 0, 0, -1, -1, -2,
    -4, -7, -10, -11, -10, -6, -1, 3, 6, 7, 5, 0, -7, -13, -14, -11, -4, 3, 6,
    6, 3, 0, -2, -3, -4, -4, -4, -4, -4, -3, 0, 4, 8, 10, 7, 3, -1, -2, 1, 3,
    3, 1, -1, -2, -1, 2, 4, 6, 7, 7, 5, 1, -1, -1, 2, 6, 7, 4, 0, -4, -5, -3,
    -1, 1, 3, 4, 5, 4, 2, -1, -3, -4, -3, -1, 0, 1, 0, -1, -3, -6, -8, -7, -3,
    4, 9, 9, 2, -8, -16, -17, -12, -2, 8, 12, 9, 2, -5, -9, -9, -5, 0, 3, 2,
    -1, -3, -5, -4, -2, 1, 4, 5, 4, 1, -4, -8, -7, -3, 3, 8, 9, 6, 3, 0, -1,
    -3, -5, -8, -7, -3, 3, 7, 6, 0, -9, -14, -14, -8, -1, 5, 7, 7, 6, 5, 3, -1,
    -7, -11, -11, -7, -3, -2, -4, -7, -6, -2, 4, 8, 8, 6, 5, 4, 4, 2, -1, -5,
    -6, -3, 1, 4, 5, 3, 0, -1, 1, 2, 3, 1, 0, 1, 5, 9, 11, 9, 3, -2, -5, -5,
    -3, 0, 1, 3, 4, 5, 5, 1, -4, -8, -10, -7, -1, 5, 7, 5, 0, -3, -3, -1, 0, 0,
    -3, -6, -7, -6, -3, -1, 0, 0, -2, -3, -4, -5, -6, -7, -8, -8, -6, -4, -3,
    -2, -1, 0, 1, 2, 2, 1, -1, -3, -5, -8, -10, -11, -10, -5, 1, 6, 9, 8, 5, 3,
    2, 3, 3, 4, 3, 3, 4, 3, 2, -1, -4, -5, -3, 2, 8, 12, 13, 10, 3, -5, -9, -7,
    -1, 7, 10, 8, 1, -4, -5, -2, 3, 5, 3, 0, -3, -4, -4, -4, -3, -2, 0, 4, 7,
    8, 6, 3, 0, -3, -5, -6, -6, -6, -7, -9, -8, -6, -1, 5, 9, 10, 8, 4, 1, -2,
    -3, -4, -5, -7, -7, -7, -5, -2, 0, 0, -1, -2, -4, -4, -2, 2, 4, 4, 1, -3,
    -5, -5, -3, -1, 0, 0, -1, -1, -2, -5, -6, -6, -3, 0, 1, -1, -2, -1, 3, 8,
    10, 8, 4, 1, 1, 2, 3, 3, 3, 2, 0, -2, -3, -4, -2, 0, 3, 4, 3, 0, -3, -3, 0,
    2, 2, 1, -2, -2, -1, 1, 1, -2, -6, -9, -9, -7, -5, -3, -2, 1, 3, 4, 2, -2,
    -5, -5, 0, 6, 11, 11, 6, -1, -7, -8, -5, 0, 3, 3, 0, -4, -5, -1, 6, 10, 9,
    3, -2, -4, -2, 2, 5, 6, 6, 5, 2, -3, -10, -14, -13, -7, 1, 6, 6, 3, 0, -3,
    -3, -3, -2, -2, -2, -2, -2, -2, -3, -4, -5, -5, -5, -3, -2, -1, -1, -1, 0,
    2, 4, 4, 2, -2, -3, -1, 2, 3, 0, -5, -7, -5, 1, 5, 6, 3, -2, -4, -3, 0, 3,
    4, 3, 0, -2, -2, 0, 2, 4, 3, 1, -2, -4, -5, -5, -4, -2, 2, 7, 9, 9, 5, 0,
    -3, -5, -4, -2, 1, 3, 4, 3, 0, -2, -3, -2, 0, 1, 2, 0, -1, -3, -2, 0, 3, 6,
    6, 4, -1, -4, -4, -1, 2, 4, 3, -1, -6, -9, -9, -6, 0, 5, 7, 5, 0, -5, -8,
    -9, -7, -5, -1, 2, 5, 4, 1, -3, -6, -8, -8, -8, -8, -6, -2, 2, 5, 5, 2, -3,
    -7, -8, -7, -3, -1, 0, 0, 0, 1, 3, 5, 5, 2, -3, -9, -10, -7, -1, 7, 11, 10,
    5, -2, -6, -6, -4, -1, 2, 5, 8, 10, 9, 6, 4, 3, 3, 3, 0, -4, -6, -5, -1, 3,
    5, 2, -1, -4, -6, -5, -4, -1, 2, 4, 4, 4, 4, 4, 3, -1, -7, -11, -12, -8,
    -3, 1, 2, 2, 1, 0, -1, -1, 0, 3, 6, 7, 5, 0, -5, -8, -8, -5, -1, 2, 4, 3,
    1, -2, -4, -5, -5, -5, -5, -4, -2, 0, 2, 2, 1, -2, -5, -8, -7, -3, 2, 5, 5,
    1, -5, -9, -11, -12, -11, -7, 0, 9, 15, 15, 9, -1, -9, -12, -9, -4, 1, 3,
    4, 5, 5, 6, 5, 2, -2, -4, -2, 4, 9, 12, 10, 3, -5, -10, -10, -3, 8, 18, 21,
    16, 5, -7, -14, -15, -11, -6, -3, 0, 2, 5, 9, 11, 11, 7, -1, -9, -15, -15,
    -8, 1, 8, 8, 3, -5, -10, -9, -4, 1, 3, 2, -1, -2, -3, -2, -3, -4, -4, -3,
    0, 2, 2, 2, 0, -3, -6, -10, -12, -11, -8, -3, 1, 4, 7, 10, 10, 7, 0, -8,
    -13, -13, -6, 3, 10, 11, 6, -3, -10, -10, -4, 3, 7, 5, 0, -4, -4, 0, 3, 3,
    0, -3, -3, 1, 6, 8, 7, 1, -7, -13, -15, -10, -3, 4, 9, 10, 10, 7, 4, -1,
    -5, -8, -8, -6, -2, 0, 1, 1, 1, 2, 1, 0, -2, -4, -4, -2, 0, 2, 2, 1, 1, 2,
    2, 3, 4, 5, 5, 2, -2, -6, -7, -5, -1, 2, 5, 7, 9, 9, 7, 4, 1, -1, -2, -5,
    -7, -7, -4, 0, 4, 6, 4, 3, 2, 1, 0, -3, -7, -10, -12, -10, -5, 3, 10, 12,
    8, 1, -7, -12, -13, -10, -6, -4, -3, -3, -2, 1, 5, 6, 2, -5, -11, -14, -12,
    -7, -3, 1, 3, 4, 4, 2, -1, -3, -5, -7, -8, -9, -6, -1, 6, 9, 7, 2, -3, -5,
    -4, -1, 2, 3, 3, 1, -1, -2, 0, 4, 9, 11, 9, 4, -2, -5, -5, -2, 3, 9, 15,
    17, 15, 9, 1, -6, -10, -9, -4, 3, 11, 16, 16, 11, 3, -5, -10, -10, -7, -2,
    3, 6, 7, 4, -2, -7, -12, -14, -13, -11, -7, -2, 3, 6, 4, -1, -7, -12, -14,
    -14, -12, -11, -10, -7, -4, 0, 2, 3, 2, 0, -4, -8, -12, -12, -9, -3, 1, 4,
    3, 2, 1, 1, 1, -1, -3, -4, -3, -1, 1, 2, 3, 5, 6, 6, 5, 2, 0, -1, 0, 0, 0,
    1, 2, 5, 8, 10, 9, 6, 1, -3, -5, -5, -3, 0, 4, 8, 10, 10, 8, 3, -2, -5, -7,
    -6, -2, 2, 6, 7, 6, 2, -2, -5, -6, -5, -3, 0, 3, 6, 7, 5, 0, -5, -10, -11,
    -8, -4, 1, 3, 2, 0, -4, -7, -7, -5, -3, -2, -2, -4, -5, -4, -1, 2, 2, -1,
    -6, -11, -12, -9, -4, 0, 1, -1, -4, -4, -2, 1, 3, 3, 1, -2, -4, -4, -3, -1,
    1, 2, 0, -4, -7, -7, -5, -1, 3, 5, 7, 6, 5, 3, 0, -2, -3, -2, -1, -1, -2,
    -2, 0, 3, 6, 7, 4, 0, -4, -4, -2, 2, 5, 6, 5, 3, 2, 2, 4, 5, 5, 2, -1, -4,
    -5, -4, -1, 2, 4, 5, 4, 2, 1, 2, 5, 7, 4, -2, -7, -8, -3, 4, 8, 7, 0, -6,
    -9, -7, -2, 5, 8, 8, 4, 0, -3, -4, -4, -3, -3, -3, -4, -4, -4, -3, -3, -2,
    -3, -5, -7, -8, -5, 0, 6, 8, 5, -2, -9, -12, -11, -7, -1, 2, 1, -1, -4, -6,
    -5, -4, -4, -6, -7, -7, -4, 1, 6, 7, 6, 2, -2, -5, -7, -6, -4, -1, 2, 2, 0,
    -4, -7, -7, -3, 2, 7, 7, 4, 1, 1, 3, 6, 7, 6, 3, 2, 0, 0, 0, 1, 2, 3, 3, 3,
    4, 6, 7, 6, 2, -2, -3, -2, 0, 2, 3, 3, 4, 4, 5, 3, 0, -3, -5, -4, -1, 1, 1,
    -1, -3, -4, -2, 2, 5, 5, 3, -1, -5, -9, -10, -8, -5, 0, 3, 3, 3, 2, 0, -3,
    -6, -9, -10, -8, -4, -2, -1, -1, -1, -1, -1, -2, -4, -6, -5, -3, -1, 0, -1,
    -4, -7, -8, -6, -3, 1, 3, 3, 2, 3, 3, 2, -2, -6, -10, -9, -6, -2, 0, 1, 2,
    4, 7, 8, 6, 2, -3, -5, -3, 1, 3, 3, 1, 0, 1, 3, 5, 5, 4, 3, 3, 3, 3, 2, 0,
    -1, -1, 1, 5, 8, 8, 6, 2, -1, -3, -3, -2, -1, 1, 2, 4, 4, 3, 0, -2, -3, -2,
    -1, -1, -3, -6, -7, -5, -3, 0, 2, 1, -1, -3, -4, -5, -4, -3, -2, -2, -2,
    -3, -4, -5, -7, -8, -8, -6, -4, -2, -1, -3, -4, -5, -4, -2, 0, 0, -1, -3,
    -3, -3, -3, -3, -3, -3, -2, -1, 2, 3, 3, 2, 0, -1, -1, -1, 0, 3, 7, 11, 11,
    6, -1, -7, -8, -5, 1, 6, 8, 8, 6, 4, 1, -3, -5, -6, -5, -1, 3, 8, 10, 9, 6,
    0, -6, -9, -8, -4, 1, 6, 8, 8, 5, 1, -4, -7, -6, -3, 1, 3, 4, 3, 1, 0, -1,
    -4, -6, -7, -5, -1, 2, 3, 1, -2, -4, -3, -1, 2, 2, 0, -5, -11, -15, -16,
    -11, -2, 6, 11, 11, 8, 2, -3, -6, -9, -11, -10, -6, 1, 9, 12, 9, 2, -6,
    -11, -12, -9, -6, -1, 3, 8, 11, 12, 8, 1, -6, -10, -10, -7, -3, 1, 4, 5, 6,
    5, 3, 0, -1, -1, 0, 1, 0, -1, -1, 0, 2, 3, 3, 2, 1, 0, -1, -3, -5, -6, -4,
    -2, 1, 3, 5, 5, 4, 1, -3, -4, -5, -3, -3, -3, -4, -3, -1, 3, 4, 3, -2, -6,
    -8, -6, 0, 7, 12, 13, 10, 3, -6, -12, -14, -11, -4, 3, 8, 10, 9, 6, 0, -6,
    -9, -9, -5, 0, 2, 2, 0, -1, 0, 0, -1, -4, -7, -7, -2, 4, 8, 7, -1, -11,
    -17, -15, -5, 7, 15, 14, 7, -2, -8, -9, -8, -7, -6, -3, 4, 11, 14, 10, 1,
    -8, -10, -5, 3, 7, 6, 2, -1, -1, 0, 0, -5, -11, -12, -6, 4, 12, 14, 9, -1,
    -8, -10, -6, 0, 6, 7, 3, -1, -5, -4, -2, 0, -1, -3, -4, -2, 2, 5, 7, 6, 3,
    0, -2, -3, -1, 2, 4, 4, 3, 0, -3, -6, -8, -8, -5, -1, 2, 4, 3, 3, 3, 4, 2,
    -4, -9, -9, -4, 4, 9, 8, 1, -7, -13, -13, -8, 0, 7, 10, 9, 3, -3, -8, -10,
    -10, -8, -4, 2, 7, 10, 7, 0, -6, -9, -9, -7, -6, -6, -5, -1, 4, 8, 8, 2,
    -5, -9, -9, -5, 1, 4, 4, 1, -1, -1, 3, 7, 8, 3, -4, -9, -8, -2, 4, 7, 5, 1,
    -1, 1, 4, 5, 2, -2, -4, -2, 2, 5, 6, 5, 5, 4, 2, -1, -4, -6, -4, 0, 4, 6,
    6, 3, -1, -5, -7, -7, -4, 1, 5, 5, 1, -4, -7, -6, -2, -1, -2, -6, -8, -7,
    -3, 1, 2, 3, 3, 4, 3, -1, -7, -10, -9, -4, 2, 5, 5, 2, 0, -2, -2, -2, -1,
    0, 0, 0, 0, 1, 4, 5, 3, 0, -3, -5, -5, -5, -5, -4, 0, 4, 6, 4, -1, -6, -8,
    -5, 0, 4, 5, 4, -1, -5, -9, -10, -6, 2, 9, 13, 10, 3, -4, -9, -9, -8, -5,
    -3, -1, 1, 4, 4, 3, 1, 0, 0, 1, 3, 5, 6, 5, 0, -6, -12, -12, -6, 5, 14, 16,
    9, -1, -9, -10, -5, 0, 2, 0, -3, -3, 2, 10, 15, 13, 4, -8, -17, -19, -14,
    -5, 4, 9, 9, 4, -1, -6, -6, -3, 1, 4, 4, 3, 1, -1, -3, -6, -6, -4, -1, 4,
    6, 6, 5, 2, -2, -7, -11, -11, -7, 1, 8, 11, 9, 5, 2, 0, -3, -7, -12, -15,
    -12, -5, 4, 9, 8, 3, -4, -8, -8, -5, 0, 2, 2, -1, -4, -6, -6, -5, -4, -4,
    -3, -1, 3, 5, 5, 0, -6, -10, -10, -6, -1, 2, 4, 5, 5, 4, 2, -1, -3, -5, -6,
    -7, -8, -7, -3, 2, 7, 9, 10, 9, 7, 6, 3, 1, -1, -3, -4, -5, -3, 0, 5, 10,
    12, 11, 6, -1, -6, -8, -5, -1, 3, 6, 8, 9, 10, 9, 4, -3, -6, -6, -2, -1,
    -4, -8, -9, -4, 4, 12, 13, 9, 2, -5, -9, -9, -7, -5, -4, -3, -2, 1, 4, 6,
    5, 0, -4, -7, -6, -3, -2, -3, -5, -7, -5, -1, 5, 7, 2, -6, -14, -15, -9,
    -1, 4, 4, 2, 1, 1, 2, 2, -1, -5, -7, -8, -9, -8, -6, -4, -1, 0, 0, -1, 0,
    1, 3, 3, 3, 1, -1, -2, -1, 1, 5, 8, 8, 4, -2, -7, -10, -9, -5, 3, 10, 15,
    16, 13, 9, 5, 2, 0, -2, -2, -1, 2, 5, 7, 6, 4, -1, -7, -9, -8, -2, 5, 9, 9,
    6, 2, 0, -3, -6, -7, -7, -4, -1, 0, -2, -3, -3, -2, -2, -5, -9, -12, -11,
    -6, -1, 4, 6, 6, 4, 1, -2, -4, -7, -10, -12, -12, -8, -3, 2, 4, 2, -1, -3,
    -1, 3, 6, 6, 1, -5, -9, -7, -2, 3, 5, 3, 1, -1, 0, 1, 1, -1, -3, -4, -3, 1,
    6, 10, 12, 10, 5, -2, -7, -9, -8, -3, 3, 8, 10, 8, 3, -1, -4, -4, -2, 0, 3,
    6, 8, 7, 4, -1, -6, -9, -8, -5, 1, 5, 7, 6, 3, -1, -4, -5, -5, -5, -4, -1,
    3, 7, 9, 6, 1, -4, -7, -7, -4, -1, 1, 1, 0, -3, -4, -3, -1, 1, 0, -2, -3,
    -2, 1, 2, -1, -5, -8, -8, -4, 1, 3, 2, -2, -5, -7, -7, -7, -5, -4, -2, -1,
    -1, -2, -4, -4, -2, 2, 5, 5, 3, -1, -6, -8, -8, -4, 2, 7, 7, 4, 0, -2, 0,
    3, 6, 5, 1, -1, -1, 3, 6, 7, 5, 2, 0, 1, 3, 5, 6, 6, 5, 2, -1, -3, -5, -4,
    -1, 3, 7, 7, 4, -1, -4, -3, 0, 3, 4, 1, -3, -4, -2, 1, 2, 1, -3, -6, -7,
    -5, -2, 2, 2, 0, -4, -6, -5, -2, 1, 2, 0, -4, -6, -6, -5, -4, -3, -4, -6,
    -8, -9, -7, -3, 3, 7, 6, 1, -7, -13, -14, -10, -2, 6, 9, 7, 0, -7, -11,
    -10, -6, -2, -1, -1, -1, -1, 0, 1, 0, -1, -3, -3, -2, 1, 4, 4, 2, -1, -4,
    -4, -4, -2, 0, 3, 6, 7, 6, 3, -1, -3, -2, 2, 5, 7, 8, 8, 8, 7, 4, 1, -2,
    -4, -3, 1, 5, 7, 6, 3, -1, -2, 0, 3, 5, 5, 3, 2, 2, 3, 4, 2, 0, -2, -1, 1,
    4, 4, 1, -3, -6, -7, -5, -1, 4, 7, 8, 6, 2, -3, -7, -9, -9, -8, -6, -4, -2,
    1, 2, -1, -6, -11, -14, -13, -9, -4, 1, 4, 4, 2, -3, -9, -13, -13, -8, -1,
    5, 6, 3, -3, -9, -12, -10, -5, 0, 3, 4, 3, 2, 1, 0, 0, 0, 0, -1, -2, -3,
    -4, -4, -2, 1, 2, 2, 2, 1, 3, 5, 9, 12, 11, 6, -1, -7, -7, -3, 3, 7, 9, 9,
    8, 6, 4, 1, -2, -2, 1, 7, 12, 13, 10, 4, -2, -5, -5, -3, 0, 1, 2, 1, 0, -1,
    -3, -5, -6, -5, -1, 2, 4, 3, 0, -2, -3, -3, -4, -6, -9, -11, -11, -8, -3,
    1, 1, -2, -7, -10, -8, -4, -1, 0, -2, -3, -3, -2, -2, -4, -7, -9, -8, -5,
    -2, -1, 0, -1, -2, -3, -3, -2, 0, 2, 3, 4, 3, 2, 1, 0, -1, -1, 0, 3, 4, 4,
    4, 2, 2, 1, 1, 0, 0, 0, 2, 5, 7, 8, 6, 2, -1, -2, -1, 1, 3, 2, 0, -2, -1,
    1, 4, 5, 4, 2, 0, -1, -1, 0, 1, 2, 2, 1, -1, -1, 0, 3, 6, 7, 5, 1, -5, -9,
    -11, -9, -5, 0, 4, 6, 5, 3, 0, -1, 0, 2, 4, 3, 0, -4, -8, -10, -10, -8, -4,
    1, 4, 5, 3, 0, -2, -3, -4, -5, -5, -3, -1, 0, -1, -4, -7, -9, -8, -6, -5,
    -3, -1, 1, 3, 3, 2, 0, -1, -1, 0, 1, 1, 0, -1, -3, -4, -4, -3, 0, 2, 4, 5,
    4, 3, 0, -2, -4, -4, -1, 3, 7, 7, 4, -1, -5, -7, -6, -4, -4, -5, -4, -1, 4,
    7, 6, 3, 0, -1, 1, 3, 4, 3, 0, -2, -3, -2, -1, -1, -1, 0, 0, 1, 1, -1, -3,
    -5, -4, -1, 3, 4, 3, 1, -1, -1, -1, 0, 0, -2, -3, -5, -6, -5, -3, 0, 3, 4,
    4, 1, -2, -3, -2, 0, 2, 3, 0, -5, -9, -9, -7, -2, 0, 0, -4, -7, -7, -2, 5,
    10, 10, 5, -2, -7, -8, -5, -1, 2, 2, 0, -2, -2, -1, 1, 2, 2, 1, -1, -2, -4,
    -5, -3, 1, 5, 8, 6, 2, -2, -4, -3, -2, -1, -3, -4, -5, -4, -2, 1, 2, 2, 1,
    1, 1, 1, 1, 0, -2, -2, -1, 1, 3, 3, 2, 1, 0, 0, 0, 1, 0, -1, -3, -2, 0, 3,
    3, 1, -2, -3, -2, 1, 2, 1, -2, -2, 1, 5, 7, 5, 1, -4, -7, -6, -3, 0, 3, 3,
    2, 0, -1, -1, -1, 0, 0, -1, -1, -2, -4, -6, -6, -4, -1, 3, 6, 6, 2, -2, -6,
    -8, -8, -5, 0, 5, 9, 10, 6, -1, -9, -14, -13, -6, 3, 9, 9, 5, 0, -2, -1, 1,
    1, -2, -7, -10, -8, -3, 4, 7, 7, 3, 0, -1, 0, 2, 1, -1, -4, -5, -4, -2, 0,
    2, 4, 5, 5, 2, -2, -6, -7, -4, 1, 6, 9, 7, 1, -5, -8, -9, -5, 0, 4, 7, 6,
    4, 2, -1, -4, -7, -9, -8, -3, 4, 7, 6, 2, -2, -3, -2, -1, -1, -1, -2, -1,
    -1, -2, -5, -7, -6, -3, 0, 3, 4, 4, 1, -2, -5, -5, -3, -1, 0, -1, -3, -3,
    -1, 0, 1, 0, -1, -2, -3, -4, -4, -1, 2, 4, 5, 3, 0, -3, -6, -9, -10, -6, 0,
    8, 12, 11, 6, -1, -6, -7, -5, -2, 1, 3, 5, 6, 6, 5, 2, 0, 0, 2, 5, 7, 7, 5,
    1, -3, -7, -10, -8, 0, 10, 18, 19, 12, 0, -10, -14, -11, -5, 1, 4, 4, 2, 1,
    2, 5, 7, 5, 0, -7, -13, -15, -11, -4, 2, 6, 6, 2, -3, -5, -5, -3, 0, 1, 0,
    -3, -6, -8, -8, -6, -3, 0, 2, 4, 4, 4, 2, -3, -9, -13, -13, -9, -3, 1, 4,
    4, 5, 8, 10, 8, 1, -10, -19, -20, -13, 0, 12, 17, 10, -2, -14, -19, -14,
    -4, 4, 7, 4, 0, -1, -1, -1, -3, -7, -9, -5, 3, 11, 15, 13, 4, -6, -13, -15,
    -12, -5, 3, 11, 15, 15, 11, 3, -4, -8, -7, -2, 3, 6, 6, 5, 4, 3, 2, 0, -1,
    -1, 2, 5, 7, 5, 0, -5, -9, -8, -2, 7, 14, 16, 12, 3, -6, -13, -15, -14,
    -10, -5, 2, 9, 12, 10, 5, -2, -7, -8, -6, -6, -8, -12, -14, -10, 0, 11, 17,
    14, 5, -4, -9, -9, -6, -4, -6, -8, -8, -4, 3, 10, 13, 9, 2, -7, -11, -11,
    -7, -3, -1, -2, -4, -4, -2, 2, 6, 6, 3, -3, -9, -11, -10, -5, 0, 4, 6, 7,
    6, 4, 0, -4, -9, -13, -15, -12, -6, 3, 10, 11, 7, 2, -2, -2, 0, 4, 7, 9, 9,
    4, -3, -9, -11, -7, -1, 5, 7, 6, 6, 5, 5, 4, 4, 6, 8, 8, 6, 3, -1, -3, -4,
    -3, -1, 3, 7, 8, 7, 2, -5, -10, -12, -11, -7, -1, 5, 9, 9, 4, -3, -10, -14,
    -14, -12, -7, -2, 3, 5, 5, 2, -3, -7, -10, -12, -13, -13, -11, -5, 3, 9,
    11, 8, 2, -4, -9, -12, -13, -11, -6, 0, 4, 6, 4, 0, -3, -4, -2, 2, 6, 8, 7,
    2, -2, -5, -6, -5, -3, -1, 1, 4, 8, 10, 9, 6, 1, -1, -2, 0, 2, 3, 4, 4, 4,
    3, 1, 0, -1, 0, 2, 5, 7, 8, 6, 2, -2, -5, -5, -2, 3, 6, 6, 3, -1, -4, -5,
    -6, -5, -4, 0, 6, 11, 12, 7, 1, -5, -9, -9, -9, -8, -4, 0, 5, 7, 5, 0, -4,
    -7, -6, -3, 0, 2, 2, -1, -4, -6, -6, -5, -4, -4, -6, -7, -6, -3, 1, 2, 0,
    -4, -9, -12, -12, -9, -5, -1, 1, 1, 0, -1, -1, 0, 1, 0, -2, -4, -5, -4, -2,
    2, 5, 6, 4, 0, -6, -9, -8, -4, 0, 3, 4, 3, 2, 4, 7, 9, 9, 5, -1, -7, -10,
    -8, -2, 3, 7, 7, 6, 6, 6, 6, 5, 3, 3, 3, 3, 1, 0, 0, 4, 9, 11, 7, 0, -5,
    -4, 2, 9, 11, 6, -1, -6, -6, -1, 5, 7, 5, -2, -8, -11, -9, -3, 3, 5, 2, -4,
    -8, -9, -5, -1, 1, 0, -3, -6, -7, -7, -6, -5, -6, -8, -10, -12, -10, -5, 0,
    2, 0, -5, -10, -12, -11, -6, -1, 3, 4, 3, 0, -4, -6, -6, -5, -3, 0, 1, 2,
    0, -1, -1, 0, 1, 0, -1, -1, 1, 5, 7, 6, 2, 0, -2, -1, 0, 1, 2, 4, 5, 5, 2,
    0, 1, 5, 8, 9, 7, 4, 2, 2, 2, 1, -1, -2, -2, 0, 3, 5, 7, 7, 6, 3, 0, -1, 0,
    1, 1, -2, -5, -6, -3, 2, 7, 7, 4, 0, -4, -5, -3, -2, -1, -2, -3, -5, -4,
    -1, 3, 5, 4, -1, -8, -12, -12, -8, -3, 1, 3, 2, 1, -3, -6, -9, -10, -8, -5,
    -2, -1, -1, -2, -2, -1, 0, 0, -2, -6, -8, -6, -1, 4, 5, 1, -6, -11, -13,
    -10, -5, 0, 3, 6, 7, 7, 5, 0, -6, -9, -10, -8, -5, -2, 0, 1, 2, 3, 6, 7, 7,
    5, 4, 4, 5, 4, 0, -6, -10, -7, 2, 10, 14, 12, 7, 2, 1, 2, 2, 1, 0, 1, 4, 8,
    9, 7, 2, -4, -8, -10, -8, -3, 2, 6, 8, 8, 6, 0, -6, -12, -14, -11, -5, 3,
    8, 8, 6, 3, 0, -3, -6, -9, -12, -13, -12, -7, -2, 3, 4, 3, -1, -4, -6, -5,
    -3, -1, 0, 1, 2, 1, -4, -9, -13, -13, -8, -1, 4, 5, 2, -2, -6, -7, -5, 0,
    6, 11, 12, 8, 1, -4, -7, -6, -3, 0, 3, 5, 3, 1, -2, -3, -2, 1, 2, 1, 0, 2,
    6, 10, 11, 7, -1, -7, -9, -5, 2, 7, 8, 4, -2, -6, -7, -5, -3, -1, 1, 3, 5,
    8, 8, 6, 1, -5, -8, -6, 0, 5, 6, 2, -2, -4, -4, -2, -2, -3, -3, -1, 1, 1,
    0, -1, 1, 5, 8, 5, -1, -6, -6, -3, 1, 3, 1, -5, -10, -11, -7, 2, 9, 11, 7,
    0, -6, -7, -3, 3, 6, 3, -3, -7, -8, -6, -3, -2, -3, -4, -4, -2, -1, -2, -4,
    -6, -5, -2, 2, 5, 7, 5, 1, -5, -10, -11, -7, -1, 5, 8, 8, 5, -1, -8, -12,
    -12, -8, -1, 4, 6, 6, 4, 2, 0, -1, -1, -1, -1, -1, -1, -1, -1, -4, -7, -9,
    -7, 0, 7, 10, 8, 2, -3, -5, -5, -3, -1, 3, 7, 11, 13, 10, 4, -2, -5, -5,
    -3, 0, 2, 5, 8, 11, 10, 4, -6, -13, -14, -9, -2, 4, 8, 9, 9, 6, 1, -4, -7,
    -6, -3, 0, 2, 4, 6, 5, -2, -13, -21, -20, -8, 6, 12, 7, -4, -13, -12, -3,
    5, 8, 3, -4, -9, -9, -6, -2, 1, 3, 3, 3, 1, -1, -3, -4, -5, -5, -3, 0, 3,
    4, 2, -1, -3, -2, 1, 4, 5, 3, -1, -7, -11, -9, -2, 7, 14, 13, 4, -7, -15,
    -14, -6, 3, 8, 10, 7, 3, 0, -2, -3, -3, -4, -4, -5, -4, -1, 4, 7, 7, 3, -2,
    -4, -1, 5, 11, 12, 8, 0, -9, -13, -13, -9, -4, 0, 2, 2, 1, 1, 3, 5, 7, 7,
    6, 4, 2, 1, -2, -7, -10, -9, -2, 8, 15, 15, 8, -3, -12, -16, -16, -12, -7,
    -2, 4, 9, 10, 8, 2, -5, -10, -12, -9, -5, 0, 3, 5, 4, 3, 0, -4, -8, -9, -5,
    3, 10, 12, 7, -3, -11, -13, -9, -3, 2, 4, 3, 2, 1, -1, -3, -2, 1, 8, 13,
    12, 7, 0, -6, -10, -11, -10, -6, 0, 5, 6, 3, -2, -5, -5, -2, 1, 2, 2, 4, 8,
    10, 9, 3, -5, -12, -14, -10, -5, -1, -1, -3, -5, -5, -4, -4, -5, -6, -6,
    -4, 0, 4, 6, 8, 6, 2, -3, -6, -6, -2, 2, 4, 4, 3, 1, 0, -2, -3, -2, 1, 5,
    7, 5, 3, 1, 1, 0, -2, -4, -4, -3, -1, -1, 0, 1, 4, 6, 4, 0, -3, -3, 2, 6,
    7, 2, -5, -11, -15, -16, -12, -4, 8, 19, 22, 16, 3, -10, -16, -13, -5, 2,
    6, 5, 1, -3, -4, -4, -4, -3, -2, 0, 3, 6, 7, 3, -3, -10, -13, -11, -3, 9,
    18, 21, 14, -1, -15, -23, -20, -9, 3, 10, 10, 5, 0, -3, -1, 3, 6, 5, -1,
    -10, -16, -16, -8, 3, 11, 13, 9, 2, -2, -2, 2, 5, 6, 2, -2, -5, -4, -2, -1,
    -3, -5, -5, -2, 4, 9, 8, 1, -8, -13, -12, -6, 1, 5, 6, 4, 2, 1, 1, 0, -2,
    -4, -6, -7, -5, -1, 4, 5, 3, -1, -3, -2, 3, 5, 2, -4, -11, -12, -7, 0, 5,
    4, -1, -6, -7, -4, 2, 6, 6, 2, -4, -8, -8, -4, 1, 5, 7, 6, 3, -1, -3, -3,
    -2, 0, 1, -2, -5, -7, -7, -3, 1, 5, 6, 5, 4, 4, 5, 5, 4, 0, -5, -9, -11,
    -10, -5, 0, 6, 9, 9, 5, -1, -5, -5, 0, 7, 12, 14, 11, 7, 1, -3, -5, -5, -3,
    -3, -5, -10, -13, -11, -4, 6, 14, 18, 18, 13, 5, -4, -10, -11, -8, -4, -2,
    -4, -6, -6, -3, 0, 1, -1, -3, -4, -3, -3, -3, -5, -7, -6, -1, 5, 9, 9, 4,
    -5, -13, -17, -16, -12, -6, -1, 4, 8, 10, 9, 5, -1, -6, -9, -9, -6, 0, 6,
    11, 11, 6, 0, -5, -7, -5, -1, 3, 6, 6, 4, -1, -7, -9, -6, 3, 11, 15, 11, 2,
    -7, -13, -12, -5, 7, 17, 21, 16, 5, -6, -11, -8, -2, 2, 2, 1, 1, 5, 9, 9,
    3, -7, -14, -15, -9, 1, 11, 15, 12, 2, -8, -16, -17, -13, -6, 0, 6, 10, 13,
    13, 8, -2, -12, -20, -21, -17, -11, -4, 2, 7, 11, 12, 10, 5, -1, -7, -11,
    -12, -10, -6, -2, -1, -3, -7, -9, -4, 5, 14, 17, 12, 1, -12, -20, -18, -8,
    6, 16, 18, 10, -3, -15, -20, -15, -6, 4, 9, 10, 8, 6, 4, 3, 1, 0, -1, -1,
    -1, 1, 3, 3, 1, -3, -5, -3, 1, 4, 3, -2, -5, -3, 3, 10, 13, 9, 1, -6, -9,
    -6, 0, 7, 10, 7, 1, -5, -7, -5, -3, -2, -3, -4, -2, 0, 0, -3, -7, -8, -3,
    5, 11, 13, 10, 2, -6, -10, -9, -3, 5, 12, 13, 6, -6, -16, -18, -12, -3, 5,
    7, 4, 0, -2, -2, 1, 2, 1, -2, -7, -9, -7, 0, 8, 11, 6, -6, -16, -19, -13,
    -3, 5, 6, 2, -5, -12, -16, -15, -10, 0, 8, 13, 11, 5, -2, -7, -8, -6, -2,
    1, 3, 3, 2, 1, 1, 3, 4, 3, 0, -3, -4, -1, 4, 9, 11, 9, 5, 1, -1, 2, 7, 11,
    13, 10, 6, 2, 1, 2, 2, 1, -1, -4, -4, -2, 1, 3, 2, -1, -4, -5, -3, 1, 5, 7,
    5, 1, -4, -6, -4, 0, 2, -1, -8, -16, -20, -17, -9, 1, 6, 6, 0, -6, -8, -6,
    0, 4, 5, 1, -4, -8, -9, -8, -5, 0, 5, 8, 6, 1, -8, -14, -16, -12, -3, 6,
    11, 11, 7, 2, -1, -2, -1, -1, -2, -2, -2, -2, -2, -3, -3, -2, -1, -1, 0, 1,
    3, 3, 2, 0, -1, 0, 3, 7, 7, 4, -1, -4, -4, -2, 1, 3, 3, 3, 3, 5, 6, 6, 2,
    -4, -9, -9, -4, 5, 11, 11, 4, -5, -9, -8, -3, 3, 6, 6, 5, 4, 3, 1, -4, -7,
    -8, -4, 2, 7, 7, 4, -2, -6, -8, -10, -9, -6, -1, 5, 8, 8, 5, 1, -1, -2, -3,
    -4, -4, -3, -2, -2, -4, -6, -9, -9, -5, 1, 8, 11, 8, 1, -7, -10, -8, -2, 3,
    4, 1, -4, -7, -7, -3, 3, 8, 8, 3, -5, -11, -11, -6, 1, 6, 5, -1, -7, -8,
    -5, 1, 5, 6, 4, 3, 2, 2, -1, -6, -10, -9, -4, 3, 10, 12, 10, 4, -2, -4, -3,
    1, 4, 3, 0, -2, -2, 1, 4, 4, 1, -1, -1, 0, 2, 3, 3, 4, 4, 5, 5, 3, 1, -1,
    -1, 1, 2, 2, 0, -2, -4, -6, -8, -10, -10, -8, -2, 5, 9, 9, 4, -4, -12, -16,
    -13, -5, 5, 12, 12, 5, -5, -14, -19, -18, -14, -8, -3, 1, 5, 7, 7, 4, -3,
    -9, -10, -6, 1, 5, 5, 0, -5, -5, -1, 4, 7, 5, 0, -5, -7, -4, 1, 8, 11, 10,
    4, -4, -9, -9, -4, 4, 9, 11, 7, 3, -1, -3, -3, -1, 0, 0, 0, -1, -1, 0, 1,
    3, 3, 3, 3, 1, 0, -2, -2, -3, -2, -2, -2, -2, -2, 0, 2, 5, 6, 6, 5, 2, -4,
    -9, -11, -8, 0, 8, 12, 10, 3, -2, -4, -2, 0, 1, -1, -3, -5, -7, -9, -11,
    -10, -7, -1, 5, 7, 6, 1, -4, -8, -11, -10, -6, 0, 4, 4, 0, -7, -11, -10,
    -4, 2, 6, 7, 5, 1, -3, -7, -8, -6, -2, 2, 4, 4, 4, 4, 5, 5, 3, 0, -2, 1, 6,
    11, 12, 9, 3, -4, -8, -7, -3, 2, 4, 2, -1, -3, -3, 0, 3, 3, 1, -2, -3, -1,
    2, 4, 4, 2, -1, -4, -5, -4, -3, -2, -1, 0, 0, -1, -3, -4, -5, -4, -1, 1, 3,
    4, 3, 1, 0, 0, 1, 1, 1, 0, -1, -1, -2, -2, -3, -4, -4, -2, 0, 2, 3, 2, 1,
    0, -1, -1, -2, -4, -4, -3, 0, 2, 2, -1, -4, -4, -2, 0, -2, -8, -13, -15,
    -11, -4, 4, 8, 9, 6, 2, -2, -3, -2, 2, 6, 8, 6, 2, -3, -6, -6, -4, -1, 1,
    1, 1, 2, 3, 6, 8, 9, 8, 4, -1, -4, -4, 0, 3, 4, 1, -3, -5, -4, -1, 2, 2, 0,
    -1, 0, 2, 3, 1, -3, -6, -5, 0, 5, 8, 5, 0, -5, -7, -6, -3, -1, 0, 0, 1, 3,
    5, 4, -2, -10, -15, -14, -8, -1, 4, 5, 4, 3, 4, 3, 2, -1, -3, -2, 1, 5, 6,
    4, -1, -5, -7, -5, -1, 2, 3, 0, -4, -6, -5, -2, 1, 2, 1, -1, -3, -3, -3,
    -2, -1, 0, 0, 0, -3, -7, -10, -9, -5, 0, 3, 3, 0, -4, -4, -2, 1, 4, 4, 2,
    0, 0, 3, 5, 5, 1, -5, -9, -7, -2, 5, 7, 5, 2, -1, 0, 2, 5, 6, 4, 1, -2, -4,
    -3, 2, 8, 12, 13, 10, 3, -4, -9, -10, -8, -2, 4, 8, 7, 0, -9, -16, -16,
    -10, -2, 4, 4, 2, 0, 0, 0, -1, -5, -9, -9, -5, 1, 5, 5, 1, -4, -8, -9, -9,
    -7, -3, 2, 5, 6, 4, 1, -1, -1, 0, 2, 3, 4, 4, 4, 4, 2, 1, 0, 0, 0, -2, -5,
    -8, -10, -8, -5, -2, 0, 1, 3, 4, 4, 2, -1, -3, -1, 3, 7, 8, 4, -4, -11,
    -15, -13, -6, 3, 9, 10, 6, 1, -3, -3, -2, -2, -4, -6, -7, -4, 1, 7, 11, 12,
    11, 9, 5, 2, -1, -2, -2, -3, -4, -6, -7, -4, 1, 6, 10, 10, 5, -2, -7, -8,
    -5, 0, 3, 3, 1, -1, 0, 3, 7, 7, 1, -7, -16, -19, -17, -9, -1, 3, 2, -3, -7,
    -7, -3, 2, 4, 3, -2, -5, -5, -2, 2, 4, 2, -2, -6, -6, -2, 4, 8, 7, 0, -8,
    -14, -14, -10, -3, 5, 12, 17, 19, 18, 12, 2, -8, -15, -16, -10, 0, 9, 11
};

static const signed char spinup[] = {
    -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0,
    0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1,
    0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0,
    -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, -1, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    0, 0, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0,
    0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, -1,
    -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1,
    0, 0, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0,
    0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0,
    0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0,
    0, 0, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -2, -2, -1, -1, -1, 0, 0, 0,
    1, 1, 1, 0, 0, -1, -2, -2, -2, -1, -1, 0, 0, 1, 0, 0, 0, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -2, -2, -1, -1, 0, 1, 1, 1, 0,
    0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0,
    0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0,
    0, 0, 0, 0, 0, -1, -1, -1, -2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, -1, -1, -1, -1, -1, 0,
    0, 0, 0, 1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 1, 1, 0, 0, 0, 0,
    -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0,
    0, 0, 0, 1, 1, 0, 0, -1, -1, -2, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1,
    -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 1, 1, 0, 0,
    0, -1, -1, -1, -2, -2, -1, -1, -1, -1, 0, 0, 1, 1, 1, 1, 0, 0, -1, -1, -2,
    -2, -1, -1, -1, 0, 0, 0, 0, 0, 1, 1, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0,
    0, 1, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0,
    0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 0, -1, -2, -2, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0,
    0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0,
    0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0,
    0, 0, -1, -1, -1, -1, -2, -2, -1, -1, 0, 0, 1, 1, 1, 1, 0, 0, -1, -1, -1,
    -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0,
    0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 1, 0, 0, 0, -1, -1, -1,
    -1, -2, -2, -2, -1, 0, 1, 1, 1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, -1, -1,
    -1, -1, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1,
    -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -2, -2, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -2, -1, -1, 0, 0, 0, 0, 0,
    0, 0, 0, -1, -1, 0, 0, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 0, 0, 0, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 1, 1, 0, 0, 0, -1, -1, -2, -2, -2, -1, 0, 0,
    0, 0, 0, 1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, 0, 0, 1, 1,
    0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 1, 1, 0, 0, -1, -1, -1, -1, -1, -1, 0,
    0, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0,
    0, 0, 0, 0, 0, 0, -1, -2, -3, -2, -2, -1, -1, 0, 0, 0, 1, 1, 1, 0, 0, -1,
    -1, -2, -2, -2, -2, -1, 0, 1, 1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0,
    0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 1, 1, 1, 0, 0,
    -1, -2, -2, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0,
    -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    0, 0, 0, 0, -1, -1, -2, -2, -2, -2, -2, -1, 0, 1, 1, 1, 0, 0, 0, 0, 0, -1,
    -1, -2, -1, -1, -1, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1,
    -1, -1, -1, 0, 0, 1, 1, 1, 1, 0, 0, -1, -1, -1, -1, -1, 0, 0, 1, 1, 2, 2,
    2, 1, 0, -1, -2, -2, -2, -2, -2, -2, -1, 0, 1, 2, 1, 0, 0, -1, -1, -1, -1,
    -1, -2, -2, -2, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0,
    0, -1, -1, -1, -1, -2, -2, -1, -1, 0, 1, 1, 1, 1, 1, 1, 0, -1, -2, -2, -2,
    -2, -2, -1, -1, 0, 0, 1, 1, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -2, -1,
    -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0,
    0, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, 1, 1, 1, 1, 1, 0, -1, -2, -2, -2, -1, -1, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, -1, -2, -2, -2, -1, -1, -1, 0, 0, 0, 1, 1, 0, 0,
    -1, -1, -1, -1, -2, -2, -1, -1, -1, -1, -1, -1, 0, 0, 1, 1, 1, 0, 0, -1,
    -1, -2, -2, -2, -2, -1, 0, 0, 1, 1, 1, 1, 1, 0, -1, -2, -1, -1, -1, 0, 0,
    0, 0, 0, 0, 0, 0, -1, -1, -1, -2, -2, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, -1, -2, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, 1, 1, 1, 0, 0, -1, -1, 0, 0, 1, 1, 0, 0, 0, 0, -1, -1,
    -1, -1, 0, 0, 1, 0, 0, 0, 0, 0, 0, -1, -1, -2, -2, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -2, -2, -3, -3, -3,
    -3, -2, 0, 2, 3, 3, 2, 1, 1, 0, -1, -2, -3, -4, -4, -3, -3, -3, -2, 0, 2,
    5, 6, 5, 3, -1, -3, -4, -3, -2, 0, 1, 1, 0, -2, -3, -3, -3, -1, 1, 2, 3, 3,
    3, 2, 0, -1, -3, -4, -4, -3, -2, -1, 0, 1, 1, 0, -1, -1, 0, 3, 4, 2, -1,
    -5, -6, -5, -4, -2, 0, 5, 11, 15, 12, 0, -14, -24, -22, -12, 0, 8, 11, 11,
    12, 12, 9, 1, -10, -17, -17, -11, -1, 6, 9, 7, 4, -1, -7, -13, -15, -10, 3,
    17, 25, 22, 8, -8, -19, -22, -19, -11, -4, 3, 7, 10, 10, 11, 10, 6, -2,
    -14, -24, -24, -10, 10, 27, 30, 19, 1, -16, -24, -23, -16, -7, 3, 11, 16,
    18, 17, 12, 5, -5, -15, -24, -27, -20, -4, 17, 31, 29, 13, -9, -23, -21,
    -7, 9, 15, 9, -3, -12, -14, -9, -1, 5, 7, 6, 5, 5, 5, 3, -4, -14, -22, -21,
    -9, 9, 24, 29, 22, 8, -8, -19, -25, -26, -21, -9, 7, 23, 32, 30, 15, -8,
    -28, -35, -26, -5, 16, 25, 18, 3, -10, -14, -8, -1, 3, 0, -3, -2, 4, 10,
    10, 0, -15, -25, -23, -7, 13, 27, 28, 16, -1, -14, -18, -14, -8, -2, 1, 3,
    5, 7, 7, 3, -3, -8, -9, -4, 3, 9, 12, 10, 5, -1, -7, -12, -13, -11, -5, 2,
    8, 9, 7, 5, 3, 3, 0, -5, -12, -15, -12, -2, 9, 15, 12, 4, -3, -6, -4, -3,
    -6, -10, -13, -9, -1, 8, 13, 12, 7, 1, -3, -5, -6, -7, -8, -8, -4, 3, 10,
    13, 10, 2, -8, -13, -12, -8, -3, 0, 2, 4, 8, 12, 12, 7, -2, -11, -15, -14,
    -9, -3, 2, 5, 7, 9, 10, 9, 3, -5, -13, -17, -15, -8, 3, 13, 19, 17, 9, -2,
    -11, -14, -12, -7, -3, 0, 3, 6, 10, 10, 6, -1, -7, -9, -7, -4, -1, 0, 1, 2,
    4, 3, 1, -3, -6, -7, -5, -1, 3, 4, 3, 1, -1, -2, -3, -3, -3, -2, -1, 1, 2,
    1, -1, -3, -4, -4, -1, 2, 4, 6, 5, 3, 1, -1, -4, -6, -7, -5, -2, 2, 4, 5,
    3, 2, 3, 3, 1, -3, -9, -13, -12, -5, 4, 10, 11, 7, 1, -4, -8, -10, -10, -8,
    -5, 0, 5, 8, 8, 4, -3, -8, -11, -10, -5, 1, 5, 7, 7, 4, 1, -2, -4, -4, -4,
    -4, -4, -1, 2, 5, 7, 5, 1, -3, -5, -4, -1, 1, 2, 1, 0, -1, -1, -1, 0, 1, 3,
    4, 4, 2, -2, -7, -10, -10, -5, 2, 9, 12, 11, 6, -1, -6, -10, -11, -10, -6,
    0, 5, 9, 10, 8, 4, -1, -6, -8, -8, -5, -1, 2, 4, 5, 4, 1, -4, -7, -7, -5,
    -1, 2, 4, 5, 5, 4, 0, -5, -10, -13, -10, -5, 2, 6, 7, 5, 0, -5, -7, -6, -4,
    -3, -3, -3, -2, 0, 3, 3, 2, 0, -2, -3, -2, -1, 1, 2, 2, 1, -1, -4, -6, -5,
    -2, 3, 7, 7, 4, -1, -3, -2, 2, 4, 3, -1, -4, -5, -3, 1, 3, 3, 1, 0, 0, 0,
    0, 0, -1, -1, -2, -1, 1, 3, 3, 2, 0, 0, 1, 2, 1, -1, -4, -6, -6, -4, -1, 2,
    4, 4, 3, 1, 0, -2, -3, -5, -5, -4, 0, 5, 6, 3, -2, -5, -5, -5, -5, -5, -4,
    0, 3, 5, 3, 1, -1, -2, -4, -6, -7, -7, -4, 0, 3, 4, 5, 5, 3, 0, -4, -8, -9,
    -7, -3, 1, 3, 5, 5, 4, 3, 3, 2, 1, -1, -4, -5, -5, -2, 1, 2, 2, 1, 2, 3, 4,
    3, 1, -1, -3, -5, -5, -4, -1, 3, 6, 6, 4, 0, -4, -7, -9, -8, -6, -2, 2, 4,
    5, 4, 4, 3, 0, -4, -8, -10, -8, -4, 1, 3, 4, 4, 2, 0, -2, -3, -3, -3, -3,
    -3, -2, 0, 3, 5, 3, -1, -4, -4, -2, -1, 1, 1, 2, 3, 3, 2, 0, -2, -3, -2,
    -1, 0, 0, 1, 2, 2, 2, 3, 3, 2, -1, -3, -5, -4, -2, 0, 0, 1, 1, 2, 3, 1, 0,
    -2, -2, -3, -3, -4, -4, -4, -3, 0, 3, 6, 7, 5, -1, -9, -14, -13, -7, 0, 6,
    8, 8, 6, 4, 1, -5, -9, -11, -9, -4, 0, 2, 2, 2, 3, 4, 5, 3, 0, -3, -6, -7,
    -6, -2, 2, 4, 5, 4, 2, 2, 3, 2, 0, -2, -4, -4, -3, -2, -2, -1, 1, 3, 4, 4,
    3, 1, -2, -5, -6, -4, 0, 3, 4, 2, 0, -1, -3, -3, -4, -2, 0, 1, 1, -1, -1,
    1, 4, 5, 2, -2, -6, -8, -6, -3, 2, 6, 8, 7, 2, -5, -10, -11, -8, -2, 2, 4,
    4, 3, 2, 1, -1, -2, -4, -6, -7, -8, -6, -2, 4, 7, 6, 2, -3, -7, -6, -1, 3,
    4, 0, -5, -9, -9, -5, 2, 7, 8, 6, 1, -4, -7, -7, -3, 2, 6, 6, 4, 0, -1, 0,
    2, 3, 3, 0, -3, -3, 0, 4, 6, 6, 3, -1, -4, -4, -2, 1, 5, 7, 5, 0, -5, -6,
    -3, 2, 4, 2, -2, -5, -5, -4, -2, -2, -2, -1, 0, 1, 2, 2, 1, 0, -3, -5, -5,
    -3, -1, 1, 0, -2, -4, -4, -4, -3, -1, 2, 4, 4, 3, 0, -3, -5, -7, -8, -8,
    -5, 0, 4, 5, 3, 0, -1, -1, 0, 2, 3, 3, -1, -6, -10, -9, -3, 5, 9, 7, 1, -5,
    -6, -3, 2, 6, 6, 4, -1, -4, -5, -2, 2, 5, 5, 2, -2, -2, 0, 2, 2, 1, -1, 0,
    1, 1, 0, -2, -2, 0, 4, 7, 8, 5, 2, 0, -1, -2, -3, -5, -7, -7, -5, -2, 1, 6,
    9, 10, 7, 0, -8, -12, -12, -8, -2, 4, 7, 6, 2, -4, -8, -7, -3, 2, 3, 2, -2,
    -3, -2, -1, -1, -3, -6, -6, -4, 1, 6, 9, 7, 1, -6, -9, -7, -2, 2, 2, -1,
    -3, -3, 0, 3, 3, 1, 0, -1, 0, 0, 0, -1, -1, -2, -3, -4, -4, -3, 0, 2, 4, 5,
    4, 2, 0, -2, -2, -2, -1, -1, -2, -3, -1, 1, 3, 2, -1, -4, -6, -4, 1, 7, 10,
    9, 5, 0, -3, -5, -5, -4, -3, 0, 2, 3, 3, 0, -2, -4, -3, -1, 2, 5, 6, 6, 4,
    1, -2, -4, -6, -6, -5, -3, 0, 2, 3, 1, -2, -4, -5, -3, 1, 4, 6, 5, 1, -3,
    -7, -8, -6, -3, 0, 1, 0, -2, -3, -1, 1, 1, 0, -1, -1, 0, 1, 0, -3, -4, -3,
    -1, -1, -2, -3, -3, -1, 0, 1, 0, 0, 0, 0, -2, -3, -2, 0, 2, 1, -1, -4, -5,
    -4, -1, 2, 5, 6, 6, 2, -2, -5, -6, -3, 0, 2, 2, 1, -2, -3, -2, 1, 4, 6, 5,
    3, 1, 1, 1, 0, -2, -5, -5, -2, 1, 1, 0, -2, -1, 2, 5, 6, 4, 1, -1, -3, -3,
    -3, -1, 2, 3, 2, 1, 0, 0, 1, 1, -1, -4, -7, -6, -3, 0, 4, 6, 6, 4, 0, -4,
    -6, -5, -1, 2, 3, 0, -5, -9, -9, -6, -1, 2, 3, 1, -1, -2, -1, 0, -1, -2,
    -4, -5, -4, -2, 0, 0, 0, -1, -1, -1, -1, -2, -3, -3, -3, -3, -3, -2, -1, 0,
    1, 1, 2, 3, 4, 4, 3, 0, -3, -6, -6, -4, -1, 1, 3, 2, -1, -3, -2, 1, 6, 9,
    9, 5, 0, -3, -4, -3, -1, -1, -1, -1, 1, 3, 4, 5, 4, 2, 1, -1, -3, -5, -4,
    -1, 3, 6, 5, 1, -3, -5, -3, -1, 2, 2, 1, -1, -3, -4, -4, -2, 1, 2, 1, -2,
    -3, -3, -3, -2, -2, -2, 0, 2, 4, 4, 0, -4, -8, -10, -9, -5, 1, 6, 7, 4, -1,
    -4, -3, 0, 1, -1, -5, -7, -5, 0, 4, 6, 5, 2, -1, -4, -5, -4, -1, 3, 4, 2,
    -2, -5, -4, -1, 3, 4, 3, 1, 0, 0, 1, 2, 1, -1, -5, -7, -7, -5, -1, 2, 4, 5,
    4, 3, 2, 0, -2, -4, -4, -2, -1, 0, 0, -2, -3, -3, -1, 3, 5, 5, 3, -2, -6,
    -7, -6, -3, 1, 4, 4, 3, 2, 1, 2, 2, 0, -3, -5, -4, -3, -1, -1, 1, 3, 6, 7,
    4, -1, -5, -6, -5, -4, -3, -1, 1, 4, 5, 3, 0, -2, -2, -1, -1, -2, -3, -4,
    -5, -4, -2, 2, 5, 6, 4, -1, -6, -7, -4, 0, 3, 2, -1, -4, -4, -1, 4, 7, 6,
    1, -6, -11, -10, -5, 1, 5, 6, 4, 2, 2, 3, 4, 2, -1, -5, -7, -7, -5, -3, -1,
    0, 2, 3, 3, 1, 0, 0, 1, 2, 2, 1, -1, -3, -6, -8, -7, -2, 3, 6, 4, -1, -4,
    -3, 0, 4, 5, 3, 0, -2, -3, -2, -1, 2, 3, 2, -1, -4, -6, -4, -2, 0, 1, 1, 0,
    0, 0, 3, 5, 5, 1, -5, -9, -9, -5, 1, 5, 5, 2, -1, -4, -6, -7, -5, -1, 3, 4,
    4, 3, 3, 3, 2, -1, -4, -6, -4, -2, -1, -3, -4, -4, -3, -1, -1, 1, 3, 5, 5,
    2, -2, -5, -4, -2, 0, 1, 3, 3, 3, 1, -2, -4, -4, -3, -2, -2, -3, -3, -1, 2,
    5, 7, 7, 6, 2, -2, -5, -5, -2, 0, 0, -2, -5, -6, -3, 0, 3, 4, 3, 2, 2, 1,
    2, 2, 2, 0, -3, -8, -10, -9, -3, 3, 7, 6, 2, -3, -5, -4, -1, 2, 3, 1, -2,
    -6, -7, -5, -1, 3, 5, 2, -3, -6, -5, -1, 3, 5, 3, -1, -3, -2, 0, 1, -2, -5,
    -7, -6, -1, 5, 8, 8, 4, 0, -4, -6, -4, -1, 2, 4, 4, 1, -2, -4, -5, -4, -2,
    0, 1, 3, 3, 3, 3, 1, -1, -3, -4, -3, -1, 2, 3, 2, -1, -5, -6, -4, 0, 1, 1,
    -2, -3, -3, -1, 0, -1, -1, -2, -1, 1, 3, 5, 5, 3, -2, -8, -10, -9, -4, 0,
    3, 3, 3, 4, 5, 3, -1, -4, -5, -3, 1, 3, 3, 2, 1, 0, -1, -4, -6, -7, -6, -2,
    3, 8, 8, 5, -1, -7, -8, -5, 0, 3, 6, 6, 4, -1, -9, -14, -13, -5, 4, 10, 9,
    6, 2, 1, 0, 0, -1, -1, 0, -1, -2, -5, -5, -3, 0, 2, 1, 0, 1, 4, 6, 6, 2,
    -2, -6, -7, -6, -4, -2, -1, 1, 2, 2, 0, -1, -2, -1, 1, 2, 2, 0, -3, -6, -7,
    -5, -2, 1, 3, 2, 1, 0, 1, 1, 1, -1, -4, -8, -11, -12, -8, -1, 6, 10, 9, 5,
    1, -1, -2, -3, -4, -5, -6, -5, -4, -2, 1, 3, 3, 2, 1, 1, 2, 4, 4, 2, -1,
    -4, -4, -3, -1, 0, -1, -2, -1, 3, 7, 8, 5, 0, -2, -1, 3, 6, 5, 1, -5, -9,
    -11, -10, -7, -1, 6, 12, 15, 15, 10, 3, -3, -7, -8, -8, -8, -10, -13, -13,
    -8, 1, 12, 17, 14, 5, -5, -10, -8, -4, -1, -4, -9, -13, -11, -3, 7, 13, 12,
    4, -5, -10, -9, -3, 2, 3, -2, -7, -9, -5, 1, 6, 7, 6, 3, -1, -6, -10, -11,
    -8, -2, 2, 3, 3, 3, 4, 5, 5, 4, 1, -2, -4, -5, -5, -3, 0, 2, 0, -2, -2, 2,
    8, 12, 10, 5, 0, -2, -1, 0, 0, -2, -4, -3, -1, 2, 2, 0, -4, -6, -4, 2, 10,
    14, 11, 5, -2, -6, -6, -6, -8, -11, -11, -6, 2, 10, 13, 11, 5, -2, -6, -8,
    -7, -5, -4, -5, -7, -7, -5, -1, 2, 4, 4, 4, 2, 0, -5, -9, -10, -7, -2, 1,
    0, -3, -5, -4, 1, 5, 6, 4, -1, -5, -6, -5, -2, 0, 2, 2, 2, 1, 0, 0, 1, 3,
    4, 3, -1, -6, -8, -7, -2, 5, 10, 11, 9, 4, -1, -5, -6, -5, -2, 1, 2, 2, 1,
    3, 6, 9, 7, 0, -9, -13, -12, -6, 0, 4, 3, 2, 1, 1, 2, 3, 3, 2, 0, -2, -4,
    -6, -7, -7, -5, -2, 2, 6, 9, 8, 4, -2, -7, -9, -8, -7, -4, 0, 7, 13, 13, 7,
    -2, -10, -11, -8, -5, -4, -4, -4, -1, 4, 9, 11, 10, 6, 0, -5, -9, -11, -9,
    -6, -1, 4, 7, 6, 2, -4, -8, -8, -6, -2, 0, 0, 1, 1, 1, -1, -4, -6, -4, -2,
    0, -1, -3, -5, -4, -1, 4, 6, 6, 4, -1, -6, -8, -5, 0, 5, 7, 5, 1, -1, -1,
    0, 0, -2, -5, -8, -6, -1, 8, 16, 18, 11, -1, -13, -18, -14, -4, 6, 11, 12,
    8, 3, 0, -1, -1, -3, -6, -7, -5, 2, 9, 12, 11, 5, 0, -3, -5, -7, -9, -11,
    -10, -7, -3, 1, 5, 8, 10, 9, 5, -2, -10, -15, -15, -9, 1, 9, 11, 7, 0, -5,
    -7, -5, -4, -2, -2, -3, -5, -7, -7, -3, 6, 15, 16, 9, -4, -16, -20, -16,
    -9, -2, 2, 4, 5, 4, 3, 1, -1, -4, -6, -7, -5, 0, 5, 8, 6, 0, -6, -10, -7,
    1, 9, 14, 13, 7, -2, -8, -10, -7, -3, 1, 2, 0, -2, -3, -1, 5, 11, 13, 12,
    6, -1, -5, -7, -7, -7, -5, -2, 2, 7, 9, 8, 5, 3, 0, -2, -4, -4, -2, 3, 6,
    6, 2, -4, -7, -7, -3, 3, 7, 7, 3, -5, -11, -13, -10, -5, -1, 0, -2, -2, 0,
    2, 2, -2, -6, -9, -8, -5, -3, -2, -2, -4, -7, -8, -7, -2, 4, 7, 5, 0, -4,
    -3, 1, 3, 1, -5, -8, -6, 3, 12, 16, 9, -3, -15, -18, -9, 5, 16, 17, 10, 1,
    -5, -5, -1, 4, 6, 5, 4, 5, 5, 4, 1, -2, -5, -6, -5, -3, -1, 3, 6, 6, 2, -4,
    -8, -6, 0, 7, 12, 14, 13, 9, 4, -3, -11, -20, -27, -27, -19, -5, 10, 18,
    16, 9, 2, 0, 2, 4, 4, 0, -5, -11, -15, -12, -3, 9, 15, 10, -5, -19, -24,
    -19, -8, 1, 7, 10, 12, 11, 5, -3, -9, -9, -2, 3, 3, -1, -4, -5, -4, -4, -8,
    -10, -7, -2, 2, 1, -4, -5, 0, 10, 16, 14, 4, -8, -15, -17, -15, -9, -3, 4,
    8, 11, 12, 13, 13, 9, 2, -6, -12, -13, -9, -5, -2, 0, 4, 10, 16, 16, 12, 6,
    0, -4, -5, -3, 2, 6, 7, 5, 1, -2, -3, -2, -2, -2, -2, 1, 5, 7, 2, -5, -11,
    -13, -12, -10, -6, 2, 13, 23, 25, 13, -7, -24, -30, -24, -12, -2, 2, 2, 0,
    -2, -5, -7, -6, -2, 5, 9, 9, 3, -6, -15, -20, -21, -15, -3, 9, 16, 13, 3,
    -5, -8, -5, -1, -2, -5, -6, -2, 4, 8, 8, 5, 3, 3, 2, -1, -5, -7, -5, -1, 2,
    3, 2, -1, -2, -3, -2, 3, 10, 15, 14, 7, -3, -11, -12, -7, 1, 7, 8, 5, 0,
    -3, -3, 0, 4, 6, 4, 1, -1, -2, -1, 0, 1, 2, 3, 5, 7, 7, 7, 3, -2, -8, -12,
    -13, -11, -7, -4, -4, -6, -6, -3, 3, 10, 13, 13, 8, 2, -3, -6, -9, -11,
    -14, -13, -9, -2, 5, 7, 4, -3, -10, -14, -12, -7, -1, 5, 9, 12, 10, 2, -10,
    -21, -23, -16, -4, 6, 10, 6, 1, -2, -3, -4, -4, -3, 0, 3, 4, 4, 3, 1, -1,
    -4, -7, -6, -1, 7, 13, 14, 10, 4, -2, -7, -11, -11, -5, 6, 15, 17, 11, 2,
    -3, -3, -1, -1, -2, -2, 1, 5, 8, 9, 7, 2, -2, -5, -4, 0, 4, 6, 4, -1, -4,
    -5, -2, 2, 4, 3, 1, -1, -3, -5, -8, -9, -8, -6, -4, -3, -4, -5, -4, -2, 0,
    2, 3, 4, 4, 2, -2, -6, -7, -5, -3, -4, -8, -10, -9, -3, 3, 5, 3, 0, -2, -3,
    -3, -4, -3, 0, 3, 5, 3, 0, -1, 1, 4, 3, 0, -5, -8, -7, -5, -2, 1, 5, 9, 10,
    8, 4, 0, -2, -2, -1, 0, 2, 4, 5, 3, -1, -6, -9, -7, -1, 5, 8, 5, -1, -5,
    -5, -2, 1, 1, -1, -2, 1, 6, 11, 11, 6, -2, -8, -9, -6, -2, 1, 1, 0, -1, 1,
    2, 3, 0, -3, -3, 0, 4, 4, 0, -6, -10, -10, -6, -2, 1, 2, 2, 2, 2, 2, 2, 0,
    -3, -6, -8, -7, -3, 0, 1, -1, -2, -1, 3, 6, 6, 1, -3, -5, -2, 1, 2, -1, -3,
    -3, 1, 4, 4, -2, -7, -9, -6, 0, 3, 1, -3, -6, -4, 0, 4, 7, 6, 4, 1, -1, -1,
    0, 1, -1, -6, -9, -9, -4, 2, 5, 5, 2, 2, 4, 6, 4, -1, -6, -9, -10, -9, -6,
    -2, 4, 11, 16, 17, 11, 2, -9, -17, -18, -13, -3, 6, 9, 5, -2, -7, -5, 2, 9,
    12, 9, 4, 0, -3, -6, -9, -10, -9, -5, -1, 2, 2, 2, 3, 4, 5, 5, 3, 0, -4,
    -6, -7, -5, 1, 7, 10, 10, 5, -1, -8, -12, -12, -8, -2, 3, 5, 4, 3, 2, 2, 3,
    4, 2, 0, -3, -4, -5, -6, -7, -7, -6, -4, -1, 2, 3, 4, 5, 4, 2, -2, -6, -7,
    -6, -3, 0, 1, 1, 1, 1, 0, -3, -5, -6, -3, 0, 4, 4, 3, -1, -3, -3, -2, -1,
    -3, -7, -8, -3, 7, 15, 15, 6, -7, -15, -13, -4, 3, 4, 2, 0, 0, 1, 1, -1,
    -1, 2, 8, 10, 8, 0, -7, -10, -8, -1, 5, 8, 6, 1, -5, -10, -11, -5, 6, 17,
    22, 17, 4, -12, -21, -20, -12, 0, 10, 17, 17, 11, -2, -15, -21, -17, -4,
    10, 17, 12, 0, -10, -12, -6, 4, 10, 8, 2, -5, -10, -13, -14, -12, -8, -1,
    5, 6, 2, -2, -1, 5, 10, 10, 3, -7, -12, -10, -4, 4, 7, 6, -1, -8, -12, -11,
    -4, 5, 10, 12, 9, 4, -2, -9, -14, -14, -5, 10, 23, 25, 14, -4, -20, -24,
    -16, -2, 12, 16, 11, 0, -9, -10, -5, 1, 4, 1, -3, -4, 1, 8, 11, 8, 1, -4,
    -6, -5, -2, -1, -1, -2, -3, -3, -4, -4, -4, -2, 2, 7, 10, 9, 4, -3, -9,
    -11, -7, -1, 5, 8, 7, 3, -1, -3, -4, -3, -1, 1, 2, 2, -2, -7, -8, -5, 1, 7,
    7, 2, -4, -7, -7, -5, -4, -4, -6, -5, -3, 3, 8, 12, 10, 3, -5, -11, -10,
    -5, 1, 3, 0, -4, -6, -3, 3, 8, 8, 6, 3, 1, 1, 0, -3, -6, -7, -4, 3, 9, 12,
    8, 1, -6, -8, -7, -3, 0, 2, 3, 2, 1, 0, 0, 2, 5, 10, 12, 10, 3, -6, -15,
    -19, -16, -7, 4, 13, 15, 11, 4, -2, -6, -9, -10, -11, -9, -3, 4, 9, 9, 4,
    -1, -4, -5, -3, -2, 0, 2, 3, 2, -3, -9, -11, -7, 0, 6, 7, 3, -2, -3, -1, 3,
    5, 5, 2, 0, -2, -3, -3, -3, -2, 0, 2, 4, 5, 5, 0, -7, -12, -13, -8, 1, 8,
    10, 8, 3, 0, -1, -1, 0, -1, -2, -5, -7, -7, -6, -3, 0, 2, 4, 5, 4, 2, -2,
    -5, -7, -7, -5, -3, -2, 0, 0, 0, -1, -2, -3, -3, -2, -1, 0, 1, 2, 2, 2, 0,
    -2, -3, -3, 0, 3, 4, 3, 0, -2, -2, 1, 5, 7, 7, 5, 1, -2, -5, -4, 1, 7, 13,
    16, 14, 7, -3, -12, -16, -14, -8, 0, 5, 7, 6, 4, 1, -1, -2, 1, 4, 6, 3, -2,
    -9, -11, -7, -1, 4, 3, -3, -8, -10, -7, -3, -1, -1, -2, -2, -2, 0, 0, -1,
    -2, -5, -7, -9, -10, -8, -3, 2, 7, 8, 4, -4, -14, -20, -18, -8, 6, 16, 19,
    14, 5, -3, -8, -9, -9, -7, -2, 5, 12, 15, 13, 5, -3, -9, -9, -6, -1, 2, 2,
    0, 0, 4, 9, 13, 10, 2, -7, -11, -8, 1, 9, 11, 7, 0, -6, -7, -4, 1, 4, 5, 5,
    3, 0, -3, -6, -7, -5, -1, 2, 1, -1, -4, -4, -2, 1, 2, 1, -1, -3, -3, -2,
    -1, -1, -2, -4, -5, -3, -1, 0, -2, -5, -8, -8, -4, 2, 7, 6, 1, -6, -10, -8,
    -3, 3, 5, 3, -1, -4, -6, -5, -3, -2, -1, -1, 0, 1, 2, 4, 6, 5, 1, -4, -7,
    -8, -5, 1, 6, 8, 7, 3, -3, -7, -7, -2, 4, 8, 6, 1, -3, -5, -3, -1, 1, 1, 2,
    2, 2, 0, -2, -2, -1, 1, 1, 0, -2, -2, -1, 0, 0, 0, -1, -2, -4, -4, -3, 0,
    4, 6, 3, -2, -6, -6, -2, 1, 1, -1, -4, -5, -2, 1, 5, 5, 3, -1, -6, -7, -3,
    4, 9, 10, 6, -1, -7, -9, -8, -6, -4, -1, 3, 7, 10, 10, 8, 4, -1, -6, -11,
    -15, -14, -7, 2, 11, 13, 8, 0, -5, -6, -3, -1, -1, -4, -6, -6, -4, 0, 4, 6,
    6, 3, -2, -6, -6, -3, 1, 2, -2, -7, -11, -9, -3, 3, 7, 7, 5, 4, 3, 2, 0,
    -3, -6, -7, -5, -2, -1, -2, -4, -6, -4, 0, 4, 7, 7, 4, 1, -2, -4, -5, -4,
    -2, 2, 6, 9, 8, 4, -3, -9, -12, -10, -5, 1, 4, 4, 4, 5, 5, 4, 2, -1, -2,
    -1, 1, 3, 3, 1, -3, -7, -7, -4, 0, 3, 3, 1, 1, 4, 7, 7, 4, -2, -5, -5, -2,
    0, -1, -1, 0, 3, 5, 4, -1, -7, -11, -11, -9, -6, -3, 0, 1, 1, 0, -3, -5,
    -5, -4, -3, -2, -1, -1, -3, -5, -6, -6, -5, -3, -2, -1, 0, 2, 4, 3, 1, -2,
    -5, -5, -2, 2, 5, 6, 5, 1, -2, -4, -4, -3, -1, 1, 1, 0, 0, 2, 5, 6, 5, 1,
    -4, -7, -5, -1, 4, 7, 6, 5, 4, 4, 5, 4, 1, -2, -3, 0, 3, 5, 4, 2, 1, 1, 2,
    2, -1, -5, -7, -6, -3, 0, 2, 3, 3, 3, 2, 0, -4, -8, -10, -9, -6, -3, 0, 2,
    4, 5, 5, 4, 0, -6, -10, -12, -11, -7, -3, 0, 0, 0, -1, -1, 0, 1, 1, -1, -4,
    -8, -10, -8, -5, 0, 3, 4, 4, 2, -1, -4, -6, -8, -7, -4, -1, 2, 3, 3, 2, 3,
    4, 4, 3, 1, -1, -2, -1, 1, 3, 4, 3, 1, -1, -1, 1, 3, 5, 5, 3, 1, -1, -1, 0,
    1, 3, 4, 4, 2, -1, -2, -2, 1, 3, 4, 2, -2, -4, -3, -1, 1, 2, 3, 3, 3, 2,
    -1, -3, -4, -4, -2, 0, -1, -2, -3, -2, -1, 0, 1, 1, 1, 1, -1, -3, -6, -8,
    -10, -11, -9, -5, 0, 4, 5, 2, -2, -6, -9, -9, -9, -7, -4, 0, 4, 6, 5, 2,
    -2, -5, -7, -6, -4, -2, -1, -1, -1, 1, 2, 4, 4, 3, 0, -3, -4, -4, -1, 3, 6,
    8, 7, 5, 2, -2, -4, -5, -4, -1, 3, 6, 7, 6, 4, 2, 2, 2, 2, 1, -1, -4, -4,
    -2, 3, 8, 12, 11, 6, -1, -7, -10, -10, -7, -3, 1, 5, 6, 6, 2, -2, -4, -4,
    -1, 1, 0, -3, -4, -3, 1, 5, 4, -1, -8, -12, -10, -4, 2, 6, 6, 4, 1, -2, -3,
    -3, -3, -2, -2, -1, 0, 0, 1, 0, -2, -4, -7, -8, -7, -5, -2, 1, 3, 3, 1, -2,
    -5, -6, -4, 1, 4, 5, 2, -2, -5, -5, -3, -1, 1, 1, -1, -3, -4, -3, 0, 4, 4,
    2, -2, -4, -2, 2, 5, 6, 4, 1, -1, -2, -3, -3, -2, 1, 4, 6, 6, 4, 1, 0, 0,
    2, 4, 3, 0, -3, -4, -2, 2, 6, 7, 5, 2, -1, -1, -1, -1, -3, -4, -5, -4, -1,
    2, 4, 3, -1, -5, -7, -7, -5, -3, -2, -2, -2, -1, 0, 1, 1, 1, 1, 0, -1, -4,
    -7, -7, -4, 2, 6, 7, 3, -3, -7, -7, -4, 0, 2, 1, 0, 1, 4, 7, 7, 5, 1, -3,
    -4, -3, 0, 3, 3, -1, -7, -11, -12, -6, 2, 9, 11, 7, 2, -2, -3, -3, -3, -3,
    -4, -4, -3, -2, 0, 2, 3, 4, 2, 0, -2, -2, 0, 2, 1, -2, -5, -6, -2, 4, 11,
    14, 11, 3, -7, -13, -13, -8, 0, 5, 7, 5, 2, 1, 3, 4, 4, -1, -7, -11, -10,
    -5, 1, 5, 5, 3, 0, -1, 0, 1, 1, -1, -4, -6, -6, -5, -3, -1, -1, -2, -3, -4,
    -3, 0, 3, 6, 4, -2, -9, -15, -15, -11, -5, 0, 2, 4, 6, 9, 10, 7, -1, -9,
    -13, -10, -2, 6, 10, 8, 2, -3, -3, 1, 4, 5, 2, -1, -1, 2, 7, 9, 6, 0, -7,
    -9, -7, -1, 5, 8, 5, 0, -4, -5, -2, 1, 2, 1, 0, 0, 1, 1, 1, -1, -2, -2, -2,
    -3, -4, -4, -2, 2, 5, 5, 2, 0, -2, -4, -6, -10, -13, -12, -7, 0, 6, 10, 9,
    6, 2, -3, -7, -12, -14, -13, -8, 0, 7, 10, 10, 7, 4, 0, -4, -6, -6, -2, 1,
    1, -2, -5, -3, 3, 8, 8, 3, -3, -3, 1, 6, 3, -5, -13, -13, -4, 8, 14, 13, 6,
    0, -3, -4, -4, -5, -3, 1, 4, 5, 3, 1, 1, 2, 3, 0, -5, -9, -9, -4, 1, 3, 2,
    0, 0, 1, 2, 1, -1, -4, -6, -6, -6, -4, -2, 1, 2, 2, 0, -1, -2, -2, -2, -2,
    -3, -3, -2, -1, -1, 0, 0, 1, 0, -2, -4, -6, -5, -3, 0, 4, 7, 7, 5, 0, -4,
    -6, -6, -4, -2, 0, 1, 3, 5, 7, 7, 4, -2, -7, -9, -5, 1, 7, 9, 6, 3, 1, -1,
    -4, -8, -12, -10, -3, 6, 11, 10, 4, -3, -7, -10, -10, -8, -4, 0, 4, 3, 0,
    -3, -4, -2, 1, 2, 1, -3, -6, -8, -7, -5, -2, 1, 2, 3, 4, 5, 6, 5, 2, -3,
    -7, -8, -6, -1, 4, 8, 8, 6, 3, -1, -2, 0, 2, 3, 1, -2, -3, -3, -2, -1, -2,
    -2, -1, 0, 0, -1, -3, -2, -1, 1, 1, -1, -1, 1, 4, 4, 0, -6, -11, -12, -9,
    -4, 2, 6, 6, 4, -1, -6, -7, -4, 0, 3, 2, -1, -2, -2, 1, 2, 1, -1, -3, -3,
    -2, -1, 0, -1, -3, -3, -1, 2, 4, 4, 1, -1, 0, 3, 6, 6, 1, -6, -9, -7, 0, 6,
    7, 3, -3, -6, -4, 0, 3, 3, 1, -3, -4, -2, 3, 7, 9, 6, -2, -10, -14, -10,
    -2, 8, 13, 12, 6, -1, -7, -10, -8, -4, 1, 5, 6, 3, -1, -4, -3, -1, 2, 3, 2,
    -1, -3, -2, 2, 4, 5, 2, -2, -5, -5, -4, -3, -2, 0, 0, 0, -1, -2, -2, -1, 0,
    -1, -4, -6, -5, -2, 1, 3, 1, -3, -7, -8, -6, -2, 2, 3, 1, -3, -6, -7, -5,
    -1, 2, 3, 3, 2, 0, -1, -1, 0, 1, 1, -2, -4, -5, -3, 0, 3, 4, 3, 0, -3, -4,
    -3, 0, 2, 1, 0, -1, 0, 3, 6, 7, 5, 3, 2, 1, -1, -3, -5, -3, 1, 4, 4, 1, -2,
    -3, 0, 3, 3, 0, -2, -1, 2, 5, 5, 1, -4, -6, -4, -1, 0, 0, 0, -1, -1, -2,
    -2, -1, 0, 1, 1, -1, -3, -4, -3, -1, 2, 3, 3, 1, -2, -6, -8, -7, -4, 0, 2,
    0, -2, -2, 0, 1, -2, -7, -11, -10, -3, 5, 10, 9, 4, -2, -5, -5, -4, -3, -1,
    1, 4, 5, 4, 2, 0, -1, -1, -3, -5, -7, -5, -1, 5, 9, 9, 6, 1, -3, -4, -4,
    -2, 0, 2, 2, 1, 0, 0, 2, 5, 6, 3, -1, -5, -4, -1, 3, 3, -1, -4, -3, 0, 2,
    0, -5, -10, -10, -5, 2, 6, 6, 1, -5, -10, -12, -10, -7, -3, 0, 2, 4, 4, 2,
    -2, -6, -6, -2, 4, 7, 5, -1, -7, -9, -6, 0, 4, 5, 4, 3, 3, 3, 2, -1, -5,
    -7, -5, 2, 9, 13, 12, 7, 1, -2, -3, -2, -1, -2, -1, 1, 5, 7, 7, 2, -2, -4,
    -1, 3, 5, 3, -1, -4, -4, -2, -1, -2, -3, -4, -4, -3, -3, -3, -4, -5, -5,
    -4, -1, 0, 0, -2, -5, -7, -7, -5, -3, -2, -2, -2, -2, -2, -2, -3, -4, -5,
    -5, -3, 0, 2, 2, 1, 0, 1, 4, 6, 5, 2, -2, -5, -6, -5, -3, 0, 5, 9, 13, 13,
    10, 5, 0, -4, -6, -4, -1, 2, 4, 5, 4, 4, 4, 3, 1, -2, -5, -5, -2, 2, 5, 5,
    3, 0, -3, -4, -3, -2, 0, 2, 1, 0, -3, -5, -4, -1, 2, 3, 1, -1, -2, -2, -1,
    -1, -2, -2, -2, -1, -1, -2, -2, -1, 0, 0, -1, -3, -5, -6, -6, -7, -7, -6,
    -3, 1, 3, 3, 1, -1, -2, -2, -1, -1, -2, -3, -4, -5, -5, -4, -2, 1, 3, 4, 3,
    1, -1, -2, -1, 2, 4, 6, 5, 3, 1, 1, 3, 5, 3, -1, -3, -3, 2, 8, 12, 12, 9,
    4, -1, -4, -5, -2, 3, 9, 12, 11, 6, 0, -5, -7, -6, -3, 0, 2, 2, 1, -1, -2,
    -2, -1, -1, -2, -2, -3, -3, -2, -1, 0, 0, -2, -5, -8, -10, -8, -3, 2, 3,
    -1, -6, -10, -9, -3, 4, 8, 6, 1, -3, -5, -4, -2, -2, -3, -5, -4, 0, 3, 5,
    3, 0, -2, -2, 0, 2, 3, 4, 3, 2, -1, -4, -6, -5, -2, 1, 2, -1, -4, -5, -1,
    5, 10, 10, 4, -3, -9, -10, -6, 1, 6, 8, 4, -1, -4, -4, -2, 0, -1, -2, -2,
    2, 6, 8, 5, -1, -5, -5, 0, 4, 3, -2, -7, -8, -5, 1, 5, 5, 2, -1, -2, 0, 2,
    3, 2, 0, -2, -3, -1, 1, 4, 4, 3, 1, -2, -5, -5, -4, -2, -1, -1, -1, -1, 0,
    2, 4, 6, 6, 4, -1, -5, -7, -4, 1, 5, 6, 3, -1, -3, -1, 2, 4, 2, -2, -4, -3,
    2, 5, 5, 1, -4, -8, -7, -4, -1, 1, 1, 0, -2, -3, -4, -3, -3, -4, -5, -5,
    -3, 0, 2, 1, -2, -5, -5, -4, -2, -1, -2, -4, -4, -2, -1, 0, -2, -4, -4, -1,
    2, 4, 4, 0, -5, -7, -6, -2, 2, 3, 1, -3, -5, -4, 1, 7, 11, 11, 7, 1, -2,
    -2, 1, 4, 5, 4, 2, 2, 2, 3, 4, 3, 3, 3, 2, 0, -2, -3, -1, 2, 3, 3, 0, -1,
    -1, 2, 5, 6, 3, -2, -6, -8, -7, -5, -3, -3, -5, -6, -6, -4, 1, 4, 5, 3, -1,
    -5, -8, -9, -9, -6, -2, 1, 2, 1, -2, -4, -5, -5, -5, -4, -4, -3, -1, 0, 2,
    1, 0, -3, -4, -3, 0, 3, 4, 1, -3, -6, -7, -6, -4, -2, 1, 4, 8, 9, 7, 3, -1,
    -6, -10, -11, -8, 0, 9, 16, 16, 10, 1, -4, -4, 0, 2, 1, -2, -3, -1, 3, 7,
    8, 6, 3, 2, 3, 6, 8, 7, 3, -3, -8, -10, -10, -5, 2, 10, 14, 12, 5, -5, -12,
    -14, -10, -2, 5, 8, 6, 1, -3, -3, -2, -2, -5, -10, -14, -12, -6, 0, 3, 1,
    -3, -7, -8, -6, -3, 0, 2, 0, -3, -6, -8, -7, -6, -5, -5, -4, -2, 1, 3, 5,
    5, 3, -1, -7, -11, -12, -7, 0, 6, 9, 9, 9, 9, 6, 1, -7, -12, -12, -6, 4,
    12, 15, 10, 1, -6, -8, -4, 4, 9, 8, 4, 0, 0, 3, 6, 4, 0, -4, -4, 1, 6, 10,
    8, 2, -4, -7, -8, -6, -3, 0, 4, 7, 7, 5, 0, -5, -8, -7, -5, -3, -3, -3, -1,
    1, 2, 2, -1, -5, -7, -7, -4, -1, 0, -2, -4, -5, -5, -4, -3, -3, -2, 0, 1,
    0, -3, -6, -8, -7, -6, -4, -2, 2, 4, 4, 1, -3, -4, -3, -2, -4, -6, -7, -2,
    5, 10, 10, 6, -1, -5, -5, -3, -1, 0, 0, 0, 1, 2, 3, 5, 5, 4, 2, 0, -2, -2,
    -1, 1, 3, 4, 5, 5, 5, 6, 4, 0, -5, -8, -7, -2, 3, 6, 5, 3, 2, 1, -1, -3,
    -4, -3, -2, 0, 0, -1, -1, 0, 0, -1, -3, -3, -3, -2, -2, -3, -5, -5, -5, -4,
    -2, 0, 2, 2, 1, -1, -2, -3, -3, -4, -5, -6, -4, -1, 2, 4, 4, 3, 0, -4, -7,
    -8, -5, -1, 3, 5, 4, 2, 0, -3, -5, -5, -2, 1, 3, 3, 1, -2, -3, -4, -5, -6,
    -6, -4, -2, 1, 2, 1, 0, -2, -4, -6, -5, -3, -1, 0, 0, 0, 0, 1, 2, 1, 1, 1,
    1, 1, 1, 0, -1, 0, 0, -1, -1, 0, 2, 4, 6, 6, 4, 1, -3, -5, -5, -2, 3, 6, 6,
    4, 2, 2, 1, -1, -5, -10, -11, -7, 0, 7, 10, 10, 6, 0, -5, -7, -6, -3, 0, 2,
    2, 2, 1, 1, -1, -2, -3, -2, 0, 2, 2, 0, -2, -4, -5, -4, -4, -3, -3, -1, 2,
    5, 5, 3, -1, -4, -5, -5, -4, -3, -1, 1, 2, 1, -3, -7, -9, -7, -3, 3, 5, 3,
    -2, -7, -10, -8, -3, 2, 3, 1, -2, -4, -2, 2, 4, 2, -4, -10, -11, -9, -3, 1,
    2, 1, 0, 1, 2, 4, 4, 2, 0, -3, -5, -5, -3, 1, 6, 9, 11, 9, 4, -3, -8, -8,
    -3, 4, 9, 8, 3, -3, -6, -5
};

static const signed char spindown[] = {
    8, 8, 6, 3, -1, -4, -8, -9, -7, 0, 7, 10, 9, 5, 0, -6, -11, -16, -17, -14,
    -6, 3, 7, 8, 5, 0, -3, -7, -12, -15, -15, -11, -5, 0, 4, 5, 4, 2, -2, -6,
    -9, -11, -10, -8, -4, 1, 5, 7, 6, 1, -4, -7, -5, 1, 9, 14, 12, 5, -3, -9,
    -8, -3, 2, 7, 9, 9, 7, 3, -2, -7, -7, -3, 3, 9, 10, 9, 6, 3, 1, -2, -5, -6,
    -4, 1, 6, 8, 6, 1, -5, -8, -9, -6, -1, 3, 5, 6, 6, 6, 6, 5, 2, -4, -10,
    -13, -11, -4, 5, 10, 10, 4, -3, -8, -10, -9, -6, -2, 4, 9, 10, 7, 0, -5,
    -8, -7, -4, -2, -2, -4, -6, -6, -3, -1, 1, -1, -5, -8, -8, -5, -1, 2, 0,
    -3, -7, -10, -8, -4, 2, 6, 6, 2, -4, -8, -9, -6, -3, 0, 0, 0, -1, 0, 0, 2,
    3, 4, 5, 5, 4, 4, 3, 2, 1, -1, -4, -6, -5, -2, 3, 8, 11, 9, 3, -3, -6, -5,
    -1, 5, 9, 8, 5, 1, 0, 2, 6, 7, 5, 0, -5, -7, -6, -2, 3, 5, 5, 4, 2, 1, 1,
    3, 4, 3, 0, -3, -4, -3, 0, 2, 3, 2, -1, -4, -6, -5, -2, 2, 4, 3, 0, -2, -2,
    0, 1, -1, -6, -10, -11, -8, -4, 0, 3, 3, 0, -4, -9, -10, -8, -4, -1, -2,
    -5, -8, -8, -5, -2, 0, 0, 0, 1, 1, 1, -1, -3, -6, -7, -8, -8, -5, 0, 5, 7,
    5, 1, -3, -4, -2, -1, -2, -2, 0, 4, 8, 9, 5, -1, -5, -5, -3, 0, 0, 1, 3, 6,
    9, 9, 6, 2, 0, 1, 4, 5, 3, 0, -3, -4, -2, 1, 3, 4, 4, 4, 2, 1, 1, 2, 2, 1,
    -2, -4, -3, 0, 3, 6, 6, 3, -1, -4, -5, -5, -3, -2, -1, -1, -1, -1, -1, 1,
    1, 1, -1, -2, -2, -2, -1, -1, -1, -2, -3, -5, -5, -5, -3, -2, -1, -1, -2,
    -2, -2, -1, 0, 1, 1, 0, -3, -5, -5, -3, -1, -1, -4, -8, -10, -11, -9, -6,
    -3, 0, 4, 8, 9, 5, -2, -8, -11, -10, -6, -3, -2, -3, -3, -1, 2, 4, 4, 3, 3,
    5, 8, 9, 6, 0, -5, -6, -3, 2, 6, 7, 7, 6, 6, 6, 6, 5, 3, 1, 0, 0, 3, 7, 9,
    9, 6, 3, 0, 0, 0, 0, 1, 1, 1, 1, 0, -3, -7, -9, -7, -3, 3, 6, 7, 4, 2, -1,
    -3, -7, -11, -15, -15, -11, -6, -1, 1, -1, -4, -8, -8, -7, -4, -2, -1, -1,
    -2, -4, -6, -7, -8, -7, -5, -2, 0, 3, 3, 2, 0, -3, -6, -8, -8, -6, -2, 3,
    7, 8, 7, 5, 3, 2, 2, 2, 1, 0, 2, 4, 6, 5, 1, -2, -4, -2, 1, 4, 5, 5, 5, 5,
    4, 2, -1, -3, -2, 2, 6, 6, 2, -3, -6, -5, -2, 0, -1, -3, -3, 0, 3, 5, 4, 1,
    -2, -3, -2, -1, -1, -1, 0, 3, 4, 3, -1, -5, -8, -6, -2, 3, 6, 5, 2, -1, -1,
    0, 2, 3, 1, -2, -4, -5, -4, -4, -5, -7, -6, -3, 1, 4, 3, 0, -3, -3, -1, 2,
    1, -4, -8, -9, -6, -2, 0, -3, -6, -7, -4, 3, 7, 6, 1, -3, -4, -1, 2, 2, -1,
    -5, -7, -5, 0, 3, 5, 4, 2, 2, 2, 3, 3, 1, -1, -2, -1, 2, 4, 5, 4, 1, -1, 0,
    1, 2, -2, -6, -9, -8, -2, 4, 6, 5, 1, -1, 0, 2, 3, 4, 4, 4, 4, 2, -2, -6,
    -8, -6, -2, 3, 6, 7, 5, 2, -1, -2, 0, 2, 3, 1, -1, -2, 0, 2, 4, 3, 0, -3,
    -5, -6, -7, -7, -6, -4, 0, 2, 1, -2, -5, -6, -4, 0, 1, -1, -6, -10, -10,
    -6, -1, 1, -1, -5, -6, -5, -1, 2, 1, -3, -7, -8, -6, -1, 3, 5, 5, 2, 0, -2,
    -3, -2, -1, -1, 0, 1, 3, 4, 4, 2, 1, 2, 3, 4, 4, 2, 0, -1, -1, -1, -2, -3,
    -3, -1, 2, 4, 6, 7, 6, 4, 2, 0, -2, -3, -3, -2, -1, -1, -1, -2, -1, 1, 2,
    1, 0, -2, -1, 1, 3, 4, 3, 2, 1, 0, -1, -2, -2, 0, 1, 2, 0, -2, -3, -2, 2,
    5, 6, 4, 2, -1, -1, 1, 3, 4, 3, -2, -7, -11, -9, -5, 1, 3, 3, 1, -2, -4,
    -5, -5, -4, -2, 1, 2, 1, -2, -6, -8, -7, -5, -4, -4, -6, -8, -8, -6, -4,
    -4, -5, -6, -6, -3, 1, 4, 4, 2, -1, -3, -3, -1, 1, 2, 3, 2, 0, -3, -4, -3,
    1, 4, 6, 7, 5, 3, 1, 2, 4, 9, 12, 12, 7, 1, -4, -4, -1, 2, 3, 2, 2, 3, 6,
    8, 8, 6, 1, -3, -5, -3, 0, 3, 3, 1, -2, -4, -5, -3, -2, 0, 0, -2, -4, -5,
    -3, -1, 2, 2, -1, -5, -7, -7, -5, -2, -1, -2, -4, -6, -7, -6, -3, 1, 3, 3,
    -1, -5, -8, -9, -7, -5, -4, -6, -7, -6, -2, 3, 6, 5, 2, -2, -5, -8, -9, -9,
    -8, -5, -1, 1, 2, 2, 2, 2, 1, -2, -5, -6, -3, 3, 9, 11, 8, 2, -4, -7, -4,
    4, 12, 17, 15, 7, -2, -7, -7, -2, 4, 9, 10, 9, 7, 6, 5, 3, 1, -1, 0, 2, 5,
    7, 7, 6, 2, -4, -11, -14, -10, 0, 12, 19, 16, 5, -7, -15, -15, -10, -3, 0,
    0, -2, -3, -2, 1, 2, 0, -5, -11, -13, -10, -4, 2, 4, 1, -3, -7, -8, -6, -3,
    0, 2, 2, 0, -2, -3, -4, -5, -5, -6, -6, -6, -4, -2, 1, 2, 2, -1, -3, -5,
    -4, -2, 0, 1, 2, 3, 4, 2, -1, -7, -12, -13, -8, 0, 8, 11, 7, 0, -7, -9, -6,
    -1, 2, 2, 0, -1, 3, 8, 12, 10, 2, -9, -16, -15, -7, 4, 12, 13, 9, 4, 0, -1,
    0, 1, 2, 3, 4, 5, 6, 5, 2, 0, -1, 1, 3, 5, 5, 3, 2, 3, 4, 6, 5, 3, -1, -3,
    -5, -4, -2, 1, 2, 2, 3, 4, 5, 4, 1, -4, -8, -9, -6, -2, 0, -1, -2, -3, -3,
    -2, -2, -3, -3, -2, -2, -4, -8, -12, -13, -9, -3, 4, 8, 7, 3, -3, -7, -8,
    -7, -7, -8, -8, -5, 0, 6, 7, 4, -2, -7, -9, -6, 0, 4, 4, 1, -2, -4, -2, 1,
    3, 2, 0, -1, -1, 0, 0, -1, -3, -4, -3, 1, 4, 7, 7, 5, 2, -2, -5, -6, -4, 0,
    5, 7, 8, 8, 8, 6, 3, -1, -4, -3, 0, 4, 6, 6, 4, 4, 4, 4, 3, 1, 0, 0, 1, 3,
    4, 4, 2, -1, -3, -4, -3, -3, -3, -4, -4, -3, -1, 0, 2, 2, 1, -3, -7, -11,
    -11, -10, -7, -4, -2, -1, -1, -3, -7, -10, -11, -9, -7, -5, -4, -3, -1, 2,
    4, 2, -3, -9, -12, -11, -8, -4, -1, 0, 1, 1, 0, 0, -1, -1, -1, 1, 5, 8, 10,
    7, 3, -1, -3, -2, -1, -1, -1, 0, 3, 7, 9, 9, 7, 5, 4, 5, 6, 6, 5, 3, 2, 2,
    3, 5, 5, 4, 3, 2, 3, 4, 3, 2, 1, 0, 1, 3, 6, 7, 6, 4, 0, -3, -6, -7, -7,
    -6, -4, -2, 0, 1, 0, -2, -4, -5, -4, -3, -4, -5, -6, -4, -3, -2, -4, -8,
    -12, -13, -11, -7, -3, 0, -1, -3, -7, -9, -9, -7, -5, -3, -3, -3, -3, -2,
    -2, -1, -2, -4, -6, -6, -4, -1, 1, 2, 1, -1, -1, 0, 3, 5, 5, 3, 0, -2, -1,
    1, 3, 5, 6, 5, 5, 5, 5, 4, 4, 4, 5, 6, 6, 5, 4, 3, 4, 4, 4, 4, 4, 4, 6, 7,
    7, 4, 0, -3, -5, -4, -1, 2, 4, 4, 2, 0, 0, 0, 1, 0, -2, -5, -7, -7, -5, -2,
    0, 1, 1, 1, 1, 0, -2, -6, -9, -10, -8, -4, -1, 0, -2, -5, -7, -6, -3, -1,
    1, 1, 0, -2, -3, -3, -4, -5, -5, -5, -4, -3, -3, -5, -6, -6, -5, -2, -1,
    -1, -1, -1, 0, 0, -1, -3, -4, -4, -2, 0, 0, -1, -2, -4, -4, -3, 0, 3, 5, 5,
    4, 1, -1, -1, 0, 1, 1, 1, 1, 2, 4, 6, 8, 8, 6, 3, 0, -2, -2, 0, 4, 6, 7, 6,
    4, 3, 2, 2, 3, 3, 2, 1, 0, -1, 0, 1, 2, 1, -1, -3, -3, -1, 2, 5, 5, 2, -3,
    -6, -7, -6, -3, 0, 1, 2, 3, 3, 2, -1, -4, -6, -6, -4, -3, -4, -5, -6, -5,
    -2, 2, 3, 3, 1, -1, -1, 1, 3, 3, 0, -4, -7, -6, -3, 2, 5, 3, 0, -3, -3, -1,
    1, 1, -2, -5, -6, -5, -2, 2, 6, 9, 9, 6, -1, -7, -11, -9, -4, 2, 4, 2, -3,
    -7, -7, -4, 1, 5, 5, 2, -3, -8, -10, -9, -5, 0, 4, 4, 2, 0, -2, -4, -5, -5,
    -6, -5, -3, -1, 2, 4, 6, 5, 1, -3, -5, -4, 1, 7, 8, 5, -1, -7, -9, -5, 1,
    6, 8, 7, 4, 2, 1, 2, 4, 5, 4, 3, 1, 0, -1, -1, -1, 0, 1, 1, 0, -2, -4, -5,
    -3, -1, 2, 4, 5, 4, 2, 0, -2, -3, -4, -5, -5, -4, -2, -1, 0, -1, -3, -4,
    -3, 0, 4, 5, 3, -3, -8, -11, -8, -2, 5, 9, 9, 5, -1, -7, -10, -10, -7, -3,
    0, 2, 1, -1, -3, -4, -3, 1, 4, 6, 5, 2, 0, -2, -4, -6, -8, -9, -6, -2, 3,
    5, 4, 2, -1, -3, -3, -1, 1, 2, 2, 1, 0, 0, 1, 1, 1, 0, -1, -1, -2, -3, -4,
    -3, -1, 3, 7, 9, 9, 6, 2, -2, -4, -3, 0, 3, 4, 3, 0, -3, -5, -4, -2, 1, 2,
    2, 1, 1, 2, 2, 2, 1, 0, -1, 0, 0, 0, 0, -1, -2, -4, -6, -8, -8, -5, -2, 2,
    4, 5, 5, 2, -1, -4, -6, -6, -5, -3, -1, 1, 2, 1, -1, -4, -6, -6, -5, -3,
    -2, -1, -1, 0, 2, 2, 1, -1, -3, -4, -4, -3, -1, 0, -1, -2, -3, -3, -2, 0,
    2, 4, 4, 3, 1, 0, 0, 0, -1, -3, -3, -1, 2, 5, 4, 1, -2, -2, 1, 3, 4, 3, 2,
    1, 1, 0, -1, -2, 0, 3, 5, 6, 4, 2, -1, -3, -3, -1, 1, 1, -2, -5, -5, -3, 1,
    4, 3, 0, -3, -4, -3, -1, 0, 0, -1, -4, -6, -6, -4, -2, 0, 0, -1, -2, -3,
    -4, -4, -4, -2, 0, 0, -2, -4, -5, -4, -1, 2, 3, 2, 0, -1, 0, 1, 1, 0, -3,
    -5, -5, -3, 1, 4, 4, 3, 1, 0, 0, 2, 2, 2, 1, 0, -1, 0, 0, -1, -1, 0, 3, 5,
    5, 3, 0, -2, -3, -2, 0, 1, 2, 1, 0, 0, 0, 1, 1, 1, 1, 0, 0, -1, -1, -2, -3,
    -3, -2, 1, 4, 4, 2, -1, -5, -6, -5, -3, -1, 1, 2, 4, 4, 4, 1, -2, -6, -8,
    -8, -5, -1, 1, 1, -2, -5, -6, -3, 1, 4, 4, 2, 0, -2, -2, -2, -3, -4, -4,
    -2, 0, 2, 3, 2, 0, -3, -5, -5, -4, -2, 1, 3, 4, 3, 2, 0, -1, -1, 0, 1, 2,
    2, 1, 0, -1, 0, 1, 0, -1, -2, -2, -1, 1, 3, 1, -2, -6, -6, -2, 4, 8, 8, 4,
    0, -2, -2, -1, 0, -2, -4, -5, -4, -2, 0, 1, 1, 0, -1, -1, -1, 0, 1, 2, 2,
    2, 1, 0, -2, -4, -5, -4, -2, 1, 3, 3, 1, -2, -3, -2, 0, 2, 2, 1, 0, -1, -2,
    -3, -3, -2, -1, -1, -3, -5, -5, -3, 0, 2, 2, 1, 0, 0, 0, 0, -1, -3, -4, -5,
    -5, -3, -1, 0, -1, -3, -5, -4, -2, 0, 2, 4, 4, 2, -1, -4, -5, -3, 0, 2, 2,
    0, -2, -2, -1, 0, 0, -2, -3, -3, -1, 3, 7, 8, 6, 2, -2, -4, -3, -1, 2, 4,
    4, 2, 0, -1, -1, -1, 0, 2, 2, 2, 2, 1, 1, 1, 2, 1, -2, -4, -5, -4, 0, 3, 5,
    4, 1, -2, -5, -5, -4, -2, 0, 1, 0, -1, -1, 1, 2, 3, 1, -1, -4, -6, -7, -6,
    -4, -2, 1, 2, 2, 0, -2, -2, -1, 2, 3, 2, -2, -6, -8, -6, -1, 3, 4, 2, -3,
    -5, -6, -4, -2, -1, -1, -3, -4, -4, -2, 2, 5, 6, 4, -1, -5, -8, -8, -6, -4,
    -2, -1, -1, -1, -1, -1, 0, 1, 1, -1, -2, -2, 1, 3, 5, 3, -1, -4, -5, -3, 1,
    4, 4, 3, 0, -2, -3, -4, -2, 1, 5, 7, 7, 5, 3, 2, 1, 1, -1, -3, -5, -6, -5,
    -3, 0, 3, 5, 5, 2, -1, -3, -2, 0, 2, 3, 2, 0, -2, -3, -2, -1, 0, -1, -3,
    -5, -4, -1, 3, 6, 6, 3, -2, -6, -6, -3, 1, 4, 6, 4, 3, 1, 0, -1, -3, -6,
    -6, -3, 1, 5, 5, 2, -1, -3, -4, -2, -1, 0, 0, -1, -1, -2, -2, -4, -6, -7,
    -6, -4, -1, 1, 1, -2, -5, -8, -8, -6, -3, -1, 0, 0, 0, 1, 0, -2, -5, -8,
    -7, -4, -1, 2, 2, 1, 0, -1, -2, -3, -3, -2, 1, 4, 6, 7, 6, 3, 2, 1, 1, 1,
    1, 1, 1, 1, 2, 3, 3, 2, 2, 2, 2, 2, 1, 0, 0, 2, 6, 8, 8, 4, -2, -8, -9, -6,
    1, 7, 9, 5, -1, -6, -7, -5, -2, -1, -1, -1, -2, -2, -2, -3, -3, -3, -3, -1,
    0, 2, 3, 2, -1, -5, -10, -13, -13, -10, -4, 3, 6, 6, 2, -4, -7, -6, -2, 2,
    3, 1, -2, -3, -2, 2, 4, 3, -1, -5, -7, -5, -1, 2, 3, 0, -3, -4, -2, 3, 7,
    8, 6, 2, 0, -1, 0, 0, -1, -3, -4, -3, 0, 3, 5, 5, 3, 0, -2, -3, -1, 1, 3,
    2, 1, 0, -1, 0, 1, 0, -2, -3, -4, -3, 0, 2, 3, 3, 2, -1, -4, -7, -7, -4, 0,
    3, 5, 4, 2, 1, -1, -3, -7, -9, -8, -3, 4, 9, 9, 4, -3, -9, -12, -11, -7,
    -2, 3, 6, 9, 9, 8, 3, -4, -12, -16, -13, -5, 4, 8, 8, 4, 1, 0, -1, -1, -2,
    -3, -3, -3, -1, 0, 1, 0, -1, -1, -2, -1, 1, 2, 3, 2, 0, -2, -4, -5, -4, -1,
    1, 3, 3, 2, 1, -1, -1, -2, -2, -2, -3, -2, -1, 1, 3, 3, 1, -1, -2, -1, 2,
    4, 4, 2, -1, -3, -5, -5, -5, -4, -1, 1, 4, 6, 5, 3, 0, -3, -4, -3, 0, 3, 3,
    0, -3, -4, -2, 0, 1, -1, -3, -5, -4, -1, 3, 5, 3, -2, -7, -9, -7, -1, 4, 6,
    4, -2, -7, -8, -6, -3, 0, 1, 2, 2, 1, -2, -6, -8, -6, 0, 6, 8, 6, 1, -5,
    -7, -7, -3, 2, 6, 8, 5, 0, -6, -9, -8, -3, 4, 8, 9, 7, 5, 1, -3, -7, -7,
    -4, 2, 6, 7, 4, 1, -2, -3, -4, -4, -2, 1, 4, 5, 3, -1, -5, -9, -9, -7, -2,
    4, 9, 10, 5, -2, -9, -12, -11, -7, -1, 4, 7, 7, 3, -3, -9, -11, -9, -4, 2,
    5, 7, 6, 4, 1, -3, -7, -9, -10, -7, -2, 5, 9, 10, 7, 0, -6, -9, -8, -3, 2,
    5, 7, 6, 4, 1, -1, -3, -5, -6, -5, -3, 1, 4, 5, 4, 2, 0, -2, -3, -4, -4,
    -3, -1, 1, 1, 0, -1, -1, 0, 1, 1, -1, -3, -4, -2, 0, 1, 0, -3, -4, -3, 0,
    3, 4, 4, 2, 0, -2, -3, -4, -3, 0, 2, 4, 3, 3, 2, 1, 0, -2, -5, -6, -4, 0,
    5, 8, 7, 3, -3, -7, -7, -4, 1, 5, 7, 5, 1, -4, -8, -9, -8, -4, 0, 3, 4, 4,
    3, 1, -3, -6, -8, -7, -3, 2, 6, 7, 4, 0, -5, -9, -9, -7, -3, 1, 3, 3, 1,
    -1, -3, -3, -2, 1, 4, 7, 7, 4, 0, -4, -7, -7, -5, -3, 0, 2, 3, 3, 2, 2, 1,
    1, 1, 1, 1, 0, -1, -1, -2, -2, -1, 0, 3, 4, 4, 3, 0, -3, -6, -6, -5, -2, 1,
    3, 3, 3, 3, 3, 3, 2, 0, -2, -3, -3, -2, -1, -1, -1, -2, -4, -4, -3, 0, 4,
    5, 4, 1, -2, -3, -3, -2, -2, -4, -4, -3, -1, 1, 3, 4, 3, 1, -2, -6, -8, -8,
    -5, 0, 4, 5, 4, 1, -1, -2, -2, -3, -2, -2, -1, 0, 0, 0, 0, -1, -1, -1, 0,
    2, 4, 5, 3, 1, -2, -3, -2, 0, 2, 2, 1, 0, -1, -1, 0, 0, 0, 0, -1, -1, 0, 3,
    5, 6, 4, -2, -7, -10, -8, -2, 5, 9, 8, 5, -1, -6, -10, -10, -7, -2, 2, 6,
    7, 7, 5, 0, -6, -11, -12, -8, -2, 3, 4, 4, 3, 3, 2, -1, -5, -9, -8, -3, 3,
    8, 8, 5, 0, -4, -6, -5, -3, 1, 4, 6, 5, 1, -4, -8, -8, -4, 4, 10, 12, 9, 1,
    -6, -9, -8, -3, 2, 4, 4, 2, -1, -4, -6, -7, -6, -3, 2, 6, 8, 7, 4, -1, -6,
    -10, -10, -7, 0, 6, 9, 7, 3, -3, -7, -9, -8, -6, -2, 2, 5, 7, 8, 7, 4, 1,
    -2, -5, -5, -2, 2, 4, 4, 1, -3, -6, -5, -1, 4, 8, 9, 5, -1, -6, -9, -7, -2,
    2, 4, 4, 2, -1, -2, -3, -4, -4, -3, -1, 1, 2, 2, -1, -5, -8, -8, -5, 0, 4,
    6, 5, 2, -1, -4, -5, -5, -5, -4, -3, 0, 4, 7, 7, 5, 1, -2, -3, -3, -4, -4,
    -4, -1, 2, 5, 5, 3, 0, 1, 3, 5, 4, 0, -4, -7, -6, -2, 2, 4, 4, 2, 0, -2,
    -3, -3, -2, -1, 1, 3, 3, 2, -1, -4, -6, -5, -2, 3, 5, 3, -1, -4, -5, -3, 0,
    1, 0, -2, -3, -3, -1, 1, 3, 4, 4, 3, 0, -2, -2, -2, -2, -2, -1, -1, 1, 2,
    2, 1, 0, 0, 1, 1, 0, 0, 0, 1, 1, 0, -2, -4, -3, 0, 4, 7, 6, 1, -5, -8, -8,
    -4, 1, 4, 5, 3, 1, -1, -2, -2, -1, -1, 0, 0, 0, -1, -2, -3, -4, -2, 0, 2,
    3, 2, 1, -1, -2, -3, -3, -3, -1, 1, 4, 4, 2, -2, -5, -4, -2, 2, 4, 3, 2,
    -1, -2, -2, -2, -2, -3, -5, -4, -2, 3, 8, 9, 6, 1, -5, -9, -8, -5, -2, 1,
    3, 4, 4, 3, 0, -2, -4, -4, -3, -1, 0, -1, -3, -3, -1, 3, 7, 7, 4, -1, -4,
    -5, -3, 0, 2, 2, 0, -2, -3, -2, -1, 1, 1, 2, 3, 3, 3, 1, -1, -2, -2, -1, 1,
    2, 2, 2, 1, 1, 0, -1, -2, -2, -1, 0, 1, 1, 0, -2, -2, -1, 0, 3, 4, 3, 1,
    -1, -2, -2, -1, -1, -3, -4, -4, -2, 0, 2, 1, 0, -2, -2, -1, 0, 1, 2, 1, 0,
    -1, -1, -1, -1, -2, -3, -4, -3, -2, 0, 0, 0, 0, 1, 2, 3, 2, -1, -3, -3, -1,
    2, 3, 3, 1, -1, -2, -3, -4, -4, -3, -1, 1, 3, 3, 2, 1, 0, 0, 1, 1, 1, 0,
    -1, 0, 0, 1, 0, -3, -5, -5, -4, -1, 3, 5, 4, 2, -1, -3, -2, 0, 1, 2, 2, 1,
    0, 0, 0, -2, -3, -3, -3, -1, 0, 0, 0, 0, 1, 2, 1, 0, -1, -1, 1, 3, 3, 1,
    -3, -6, -5, -2, 2, 5, 5, 2, -2, -3, -3, -1, 1, 2, 2, 1, 0, -2, -2, -2, -1,
    0, 1, 1, 0, -2, -3, -2, -1, 0, 1, 1, 0, -1, -2, -2, -2, -2, -3, -3, -2, 1,
    4, 5, 3, -1, -4, -4, -4, -3, -2, -2, -1, 0, 2, 3, 2, 0, -2, -2, 0, 2, 3, 2,
    -1, -3, -3, -2, -1, 0, 0, -1, 0, 1, 3, 3, 1, -1, -2, -2, -1, 1, 2, 2, 1,
    -1, -2, -2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 1, 0, -2, -2, -1, 1,
    2, 1, -1, -3, -4, -3, -1, 1, 1, 1, 0, 0, -1, -2, -2, -2, -1, 0, 1, 1, 1, 0,
    -1, -1, -1, -2, -3, -4, -3, -2, 1, 3, 4, 2, 0, -2, -2, -2, -1, -1, 0, 1, 2,
    2, 0, -2, -4, -5, -3, 0, 2, 3, 3, 1, 0, -1, -2, -2, -2, -2, -1, 0, 0, 0, 1,
    2, 2, 0, -3, -5, -5, -4, 0, 3, 4, 3, 1, -2, -3, -2, 0, 2, 2, 1, -1, -2, -2,
    -1, -1, -2, -3, -3, -1, 1, 3, 3, 2, 1, 0, -1, -2, -4, -5, -4, -1, 2, 4, 3,
    1, -2, -2, -1, 0, 0, -1, -3, -3, -2, -1, 1, 1, 1, 1, 1, 1, 0, -1, -2, -3,
    -2, 0, 2, 2, 1, -1, -2, -3, -3, -2, -1, 0, 1, 2, 4, 3, 2, -1, -4, -4, -3,
    0, 1, 1, 1, 0, 0, -1, -2, -3, -3, -2, 1, 3, 4, 2, -1, -4, -5, -3, -1, 2, 2,
    0, -2, -3, -3, -1, 0, 0, 0, 0, 1, 2, 2, 0, -2, -5, -5, -3, 0, 3, 4, 3, 1,
    -1, -3, -4, -4, -3, -2, 0, 3, 5, 5, 3, -1, -5, -6, -4, -1, 3, 4, 3, 0, -2,
    -2, -2, -1, 0, 0, 0, 0, 0, 1, 1, 1, 0, -2, -2, -2, -1, 0, 1, 2, 1, 0, -2,
    -3, -3, -2, -1, 0, 1, 0, -1, -1, -1, 0, 1, 1, -1, -2, -3, -2, 0, 2, 2, 0,
    -2, -3, -4, -3, -1, 0, 1, 2, 1, 0, -2, -4, -4, -3, -1, 2, 3, 2, -1, -3, -3,
    -1, 2, 3, 1, -2, -4, -5, -3, 0, 2, 3, 1, -2, -4, -4, -2, 0, 2, 3, 2, 0, -3,
    -3, -3, -1, 1, 2, 1, -1, -3, -3, -2, 1, 3, 3, 1, -1, -3, -3, -2, 1, 2, 2,
    1, -1, -1, -1, 0, 0, -2, -2, -3, -2, -1, 0, 1, 2, 3, 4, 2, 0, -4, -6, -6,
    -4, -1, 1, 3, 3, 1, -1, -3, -3, -2, 0, 3, 3, 2, -1, -4, -6, -6, -4, -1, 2,
    3, 1, -1, -3, -4, -3, -1, 1, 2, 2, 0, -1, -2, -2, -2, -1, -2, -2, -2, -2,
    -1, 0, 0, 1, 0, 0, -2, -2, -2, -1, 1, 2, 2, 1, -2, -5, -6, -4, 0, 3, 4, 2,
    0, -2, -3, -2, -1, 1, 3, 3, 2, -1, -4, -6, -5, -2, 2, 4, 3, 2, 0, -1, -2,
    -3, -3, -2, 0, 2, 3, 2, 1, -1, -2, -2, -2, -1, -2, -2, -2, -1, 0, 1, 1, 0,
    -1, -2, -2, -2, -1, -1, -1, -1, -2, -2, -2, -1, 1, 1, 0, -2, -3, -3, -2,
    -1, -1, 0, 1, 2, 2, 1, -1, -3, -4, -3, -2, -1, -1, -1, 0, 1, 1, 1, 0, -1,
    -2, -2, -1, 0, 1, 2, 1, 0, -2, -3, -2, -1, 1, 3, 2, 0, -2, -3, -2, -1, 1,
    1, 0, -1, -2, -2, -2, -1, 1, 2, 2, 1, -1, -3, -4, -3, -2, -1, 1, 2, 2, 2,
    0, -2, -3, -2, -1, 0, 0, -1, -2, -2, -2, -1, 0, 1, 1, 2, 2, 2, 0, -2, -4,
    -5, -5, -3, 0, 3, 3, 2, 0, -1, -2, -1, 0, 1, 1, 1, 0, -1, -2, -2, -2, -2,
    -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 1, 1, 1, -1, -3, -4, -4, -2, 0,
    1, 1, 0, 0, -1, -1, 0, 0, 1, 1, 0, -2, -3, -3, -2, 0, 1, 1, -1, -3, -3, -1,
    1, 2, 2, 0, -1, -2, -1, 0, 1, 1, 0, -2, -2, -2, 0, 2, 2, 1, -1, -3, -3, -1,
    0, 1, 1, 0, -1, -2, -2, -1, -1, -1, 0, 0, 0, -1, -1, 0, 2, 2, 1, -1, -4,
    -5, -3, -1, 2, 3, 3, 1, -2, -3, -3, -2, 1, 2, 2, 1, -2, -3, -4, -3, -1, 0,
    0, 0, 0, 0, 0, 0, -1, -2, -2, -2, -1, 1, 2, 2, 2, 0, -3, -5, -5, -3, 0, 1,
    1, 0, -1, -1, -1, 0, 1, 0, -2, -3, -2, -1, 1, 2, 1, -2, -5, -5, -3, 0, 3,
    5, 4, 2, -1, -4, -4, -3, -1, 1, 3, 2, 0, -3, -4, -3, -1, 1, 2, 1, -1, -3,
    -3, -2, -1, 0, 0, 1, 1, 1, 1, 0, -1, -2, -2, -2, -1, 0, 0, 1, 0, -1, -2,
    -2, 0, 1, 2, 2, 1, -2, -5, -5, -3, 0, 2, 2, 0, -2, -3, -2, 1, 2, 2, 0, -2,
    -3, -3, -2, -1, 1, 1, 1, 1, 0, 0, 0, -1, -1, -2, -2, -2, -1, -1, 0, 0, 0,
    0, -1, -3, -4, -4, -1, 2, 4, 4, 2, -1, -4, -5, -3, -1, 2, 3, 3, 1, 0, -2,
    -3, -3, -2, 0, 1, 1, 0, -1, -1, 0, 1, 0, -1, -3, -3, -2, 1, 2, 1, -1, -4,
    -5, -4, -1, 2, 4, 5, 3, -1, -4, -6, -5, -2, 1, 4, 4, 2, -1, -3, -4, -3, -1,
    0, 0, -1, -1, -1, 1, 2, 2, 0, -2, -3, -2, 0, 2, 3, 1, -2, -4, -5, -4, 0, 4,
    6, 5, 1, -3, -6, -6, -2, 2, 5, 4, 0, -4, -7, -6, -2, 2, 3, 3, 1, -1, -1, 0,
    0, 0, -2, -4, -4, -3, 0, 3, 5, 5, 3, -1, -5, -7, -6, -2, 2, 4, 4, 1, -2,
    -5, -5, -4, -1, 1, 2, 2, 1, 0, -1, -2, -2, -2, -2, -1, 1, 2, 2, 0, -1, -3,
    -3, -2, 0, 1, 1, 1, 1, 0, -1, -2, -2, -2, 0, 1, 0, -1, -3, -3, -3, -1, 1,
    3, 4, 3, 1, -1, -3, -3, -2, -1, 0, 1, 0, -1, -1, 0, 0, 0, -1, -2, -3, -2,
    0, 3, 3, 2, -2, -4, -5, -4, -1, 2, 3, 1, -2, -5, -5, -2, 2, 5, 5, 2, -1,
    -4, -5, -4, -2, 0, 1, 0, -1, -2, -2, -1, 0, 0, 0, -1, -1, 0, 2, 3, 2, -2,
    -5, -7, -6, -2, 2, 4, 3, 1, -1, -1, -1, -1, -1, -1, 0, 1, 1, 1, -1, -1, -2,
    -1, -1, -1, -2, -2, -2, -1, 0, 1, 2, 2, 2, 0, -1, -2, -2, -2, -2, -1, 0, 1,
    2, 2, 0, -2, -4, -4, -2, -1, 1, 2, 3, 4, 3, 1, -3, -6, -7, -6, -2, 1, 4, 4,
    3, 1, -1, -2, -3, -3, -2, -1, 1, 2, 2, 0, -2, -4, -4, -4, -2, 1, 3, 3, 2,
    0, -3, -4, -4, -3, -1, 0, 1, 2, 1, 0, -1, -3, -4, -3, -2, 0, 1, 1, 1, 0,
    -1, -2, -2, -1, 0, 2, 3, 2, 0, -1, -3, -4, -4, -3, 0, 2, 4, 4, 2, 0, -1,
    -3, -3, -4, -3, -2, 0, 2, 3, 2, 1, -1, -2, -2, -1, 0, 1, 1, 1, 0, -2, -4,
    -4, -2, 2, 5, 5, 2, -2, -5, -6, -5, -3, -1, 1, 2, 3, 2, 1, -1, -2, -3, -3,
    -3, -3, -2, 0, 1, 2, 1, 0, 0, -1, -1, -2, -2, -2, 0, 1, 1, 0, -2, -3, -3,
    -1, 1, 2, 2, 1, 0, -2, -2, -3, -3, -3, -1, 1, 2, 3, 2, 0, -2, -3, -3, -2,
    0, 0, 0, -1, -2, -1, 1, 2, 2, 1, -1, -3, -4, -3, -2, 0, 2, 2, 1, -1, -2,
    -2, -1, 1, 2, 2, 0, -3, -4, -3, -2, 0, 2, 2, 1, 0, 0, 0, 0, -1, -2, -3, -4,
    -3, 0, 2, 4, 3, 1, -2, -4, -3, -2, 0, 1, 1, 0, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -2, -1, -1, 0, 0, 0, 0, -1, -1, 0, 1, 0, -1, -2, -4, -4, -2, 0,
    2, 3, 2, 0, -1, -2, -1, -1, -1, -2, -2, -1, 0, 1, 1, 0, -1, -1, 0, 0, -1,
    -1, -2, -1, 0, 1, 0, -1, -2, -2, -1, 1, 2, 1, 0, -1, -2, -2, -2, -2, -1, 0,
    1, 2, 2, 2, 1, -2, -3, -4, -3, -1, 1, 2, 1, 0, -1, -1, -1, -2, -2, -1, 0,
    1, 2, 0, -2, -4, -3, -1, 1, 3, 2, 0, -2, -3, -2, -1, -1, -1, -1, -1, 0, 1,
    1, 2, 1, 0, -2, -4, -4, -4, -1, 2, 3, 3, 2, -1, -3, -4, -3, -2, 1, 2, 2, 1,
    0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 1, 1, 0, -1, -2, -3, -2, 0, 1, 1,
    1, -1, -2, -2, -1, 0, 1, 1, 0, -1, -2, -2, -2, -1, 1, 2, 2, 1, -1, -2, -3,
    -2, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 1, 1, 1, 0, -1, -1,
    -1, -1, -1, -1, -1, 0, 1, 1, 1, 0, -1, -1, -1, -1, -2, -2, -2, 0, 2, 2, 1,
    0, -1, -1, -1, -1, -1, -1, -2, -1, 0, 1, 2, 2, 1, -1, -2, -3, -2, -1, 1, 2,
    2, 1, 0, -1, -1, -1, 0, 0, 0, 0, 0, -1, -2, -2, -1, 0, 1, 1, 0, -1, -1, -1,
    0, 1, 0, -1, -1, -2, -1, 0, 1, 1, 1, 1, 0, -1, -2, -3, -2, -1, 0, 1, 1, 1,
    0, -1, -1, -1, 0, 0, 1, 1, 1, 1, 0, -1, -2, -3, -3, -2, 0, 2, 3, 3, 2, 0,
    -2, -3, -4, -3, -2, 0, 2, 3, 3, 2, 1, -1, -3, -4, -3, -2, 1, 2, 2, 2, 1, 1,
    0, 0, -1, -2, -1, -1, 0, -1, -1, -1, 0, 2, 2, 1, 0, -1, -1, -1, -1, -1, -2,
    -1, 0, 1, 1, 1, 0, 0, -1, -1, 0, 0, 0, 0, -1, -1, -2, -1, 0, 1, 2, 2, 1, 0,
    -1, -1, -2, -2, -2, -2, 0, 2, 2, 1, 0, -1, -1, -2, -2, -2, -1, 0, 1, 1, 1,
    -1, -1, -1, -1, -1, 0, 0, 1, 2, 2, 0, -2, -3, -3, -2, 0, 1, 2, 1, 0, -1,
    -1, -1, -1, 0, 0, 0, -1, -1, 0, 1, 1, 0, -1, -3, -3, -1, 1, 2, 1, 0, -2,
    -2, -1, 1, 2, 2, 1, -1, -1, -2, -2, -1, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, -1, -2, -1, -1, 0, 1, 1, 0, -1, -1, -1, 0, 0, 0, 0, 0, 0, 1, 1, 0, -1,
    -2, -3, -2, -1, 1, 2, 2, 2, 1, -1, -2, -3, -3, -1, 1, 2, 3, 2, 1, 0, -2,
    -2, -3, -2, -2, -1, 0, 2, 2, 1, -1, -2, -3, -3, -1, 1, 3, 3, 2, 0, -2, -3,
    -3, -3, -2, 0, 1, 2, 2, 1, -1, -2, -2, -2, -2, -1, 0, 0, 0, 0, 0, 0, 0, -1,
    -1, -1, 0, 0, 0, 0, -1, -1, -2, -1, 0, 1, 1, 1, 0, 0, -1, 0, 0, -1, -1, -1,
    -1, 0, 0, 1, 1, 1, 0, -1, -3, -3, -2, 0, 2, 2, 1, -1, -2, -2, -1, 1, 1, 1,
    -1, -2, -2, -1, 0, 2, 1, 0, -2, -2, -1, 1, 3, 3, 1, -2, -4, -4, -3, 0, 2,
    3, 2, 0, -1, -2, -2, -2, -1, 0, 1, 1, 1, 0, -1, -2, -1, 0, 0, 0, -1, -1,
    -1, 0, 0, 0, -1, -2, -2, -1, 0, 2, 2, 1, -1, -3, -3, -3, -1, 0, 0, 0, 0, 0,
    0, 1, 1, 0, 0, -1, -2, -1, -1, 0, 1, 1, 1, 0, -1, -2, -2, -2, -1, 1, 1, 1,
    0, -1, -1, -1, 0, 0, 0, -1, -1, -2, -1, 1, 1, 1, 0, -1, -2, -2, -1, 0, 1,
    1, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -2, -2, -1,
    1, 1, 1, 0, -1, -2, -2, -1, 0, 0, 0, 0, -1, -1, 0, 0, 1, 1, 0, -1, -2, -2,
    -2, -2, -1, 0, 0, 1, 1, 0, 0, -1, -1, -2, -2, -2, -2, -1, 0, 1, 2, 2, 1,
    -1, -2, -2, -2, -1, 0, 1, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, -1, -2,
    -1, 0, 0, 1, 1, 0, 0, -1, -2, -2, -1, -1, 0, 0, 0, 1, 1, 0, 0, -1, -2, -1,
    -1, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0,
    -1, -1, -2, -1, 0, 1, 1, 0, 0, -1, -2, -2, -2, -1, 0, 0, 1, 1, 0, -1, -2,
    -2, -2, -2, -1, -1, -1, 0, 1, 1, 1, -1, -2, -3, -3, -2, 0, 1, 1, 1, 0, -1,
    -2, -2, -2, -1, 0, 1, 1, 1, 0, -1, -2, -3, -2, -1, 0, 1, 1, 0, -1, -2, -2,
    -2, -2, -1, 0, 1, 2, 1, 0, -2, -2, -2, -1, -1, 0, 0, 0, 1, 1, 0, -1, -1,
    -2, -2, -2, -1, 0, 1, 1, 1, 0, -1, -2, -2, -1, -1, 0, 0, 0, 0, 0, 0, -1,
    -2, -2, -2, -1, 0, 0, 0, -1, -2, -2, -2, -1, 0, 1, 1, 0, 0, -1, -2, -2, -1,
    -1, 0, 0, 0, 0, 0, -1, -1, -1, -2, -1, -1, 0, 0, 0, -1, -1, -2, -1, 0, 0,
    1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 1, 1, 0, -1, -2, -2, -2,
    0, 1, 2, 1, 0, -1, -1, -2, -2, -1, -1, 0, 0, 0, 0, -1, -1, 0, 0, -1, -1,
    -2, -1, -1, 0, 0, 0, 0, -1, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1,
    0, -1, -1, -2, -2, -2, -1, 0, 1, 1, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0,
    0, 0, 0, 0, 0, 0, 0, -1, -2, -2, -2, -1, 0, 1, 1, 0, -1, -2, -1, 0, 0, 0,
    -1, -2, -2, -1, 1, 1, 1, 0, -1, -2, -2, -2, -1, -1, -1, 0, 0, 1, 0, 0, -1,
    -1, -1, 0, 0, 0, 0, 0, 1, 1, 1, 0, -2, -2, -2, -1, 0, 0, 0, 0, -1, -1, 0,
    0, 1, 0, -1, -2, -2, -1, 0, 0, 1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1,
    -1, 0, 0, 1, 1, 0, -2, -2, -2, -1, 0, 1, 1, 0, -1, -1, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, -1, -2, -2, -2, -1, 0, 0, 0, 0, 0, 0, -1,
    -1, -2, -2, -1, -1, 0, 1, 0, 0, -1, -1, -1, 0, 0, -1, -1, -1, -1, 0, 0, 0,
    0, -1, -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 1, 0, -1, -2,
    -3, -2, -1, 1, 2, 2, 1, 0, -1, -1, -1, -1, -1, -2, -1, 0, 1, 2, 1, 0, -2,
    -2, -2, -1, 0, 0, -1, -1, -1, 0, 1, 1, 0, -1, -2, -2, -2, -1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, -1, -1, -2, -2, -2, -2, -1, 0, 1, 2, 1, 0, -2, -3, -2, -2,
    -1, -1, 0, 1, 2, 2, 1, 0, -2, -3, -3, -2, 0, 1, 1, 0, -1, -1, 0, 0, 0, -1,
    -2, -2, -1, 0, 1, 1, 0, -1, -1, -1, -1, -1, -1, -2, -2, -1, 0, 1, 1, 0, 0,
    0, 0, -1, -1, -2, -2, -1, 0, 1, 1, 0, 0, -1, -1, -1, -1, -1, -2, -2, -2, 0,
    1, 2, 1, 0, -1, -2, -1, -1, -1, -1, -2, -1, 0, 1, 2, 2, 0, -1, -2, -2, -2,
    -2, -1, -1, 0, 1, 1, 1, 0, -1, -2, -2, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1,
    -1, -2, -2, -1, 0, 0, 0, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0,
    0, 0, 0, -1, -1, -2, -2, -2, -1, 0, 0, 1, 1, 0, 0, -1, -1, -2, -2, -1, 0,
    1, 1, 1, 0, -1, -1, -1, -1, -1, -1, -1, 0, 1, 1, 1, -1, -1, -2, -2, -1, -1,
    -1, 0, 0, 1, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0,
    -1, -1, -1, -1, 0, -1, -1, 0, 0, 1, 0, -1, -1, -2, -1, -1, 0, 0, 0, 0, 0,
    0, -1, -2, -2, -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0,
    0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -2,
    -1, 0, 1, 1, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, -1, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -2, -1, -1, 0, 0,
    0, 0, 0, 0, -1, -2, -2, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1,
    0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1,
    -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1,
    -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1,
    -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 1, 0, 0, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -2, -2, -2, -2, -1, -1, 0, 0, -1, -1, -1,
    -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, -1, -1, -1, -1,
    0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, 0, 0, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, -1, -1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, 0, 0,
    0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, 0, 0, 0, -1, -1, -1,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1,
    -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    0, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, -1, 0, 0, 0, 0, -1,
    -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
    0, 0, 0, -1, 0, 0, 0, 0, 0, -1, -1, -1, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, -1, -1, -1, -1, -1, -1, -1, -1, 0, 0, 0, -1, -1, -1, -1, -1, -1, -1,
    -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -1, -1, 0, 0, 0, 0, 0, 0, 0, 0,
    -1, -1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};

static const signed char stepping[] = {
    -2, 0, 2, 2, 0, -2, -3, -2, -2, -4, -5, -2, 5, 11, 7, -7, -22, -28, -18, 1,
    16, 17, 8, -2, -6, -4, -1, -3, -8, -11, -9, -4, 2, 7, 11, 13, 10, 3, -4,
    -6, 1, 12, 18, 11, -3, -16, -19, -12, -1, 6, 7, 5, 3, 0, -4, -10, -13, -9,
    2, 15, 22, 23, 17, 8, -2, -12, -19, -22, -17, -8, 1, 7, 7, 2, -5, -12, -17,
    -18, -12, -2, 10, 19, 23, 20, 10, -4, -18, -26, -23, -11, 5, 16, 18, 13, 5,
    -4, -11, -17, -18, -14, -3, 13, 26, 31, 27, 16, 2, -9, -16, -19, -17, -11,
    -3, 4, 8, 6, -2, -11, -18, -20, -16, -8, -1, 6, 10, 11, 9, 3, -3, -8, -10,
    -9, -4, 2, 7, 10, 7, 2, -3, -3, 1, 7, 12, 13, 12, 10, 6, 1, -6, -12, -13,
    -10, -5, 1, 5, 9, 10, 6, -2, -12, -18, -16, -7, 5, 12, 13, 8, 1, -5, -11,
    -15, -18, -16, -11, -4, 4, 8, 10, 10, 7, 3, -1, -3, -1, 6, 13, 18, 17, 11,
    3, -5, -11, -14, -14, -11, -5, 0, 4, 5, 3, 1, -2, -3, -4, -4, -2, 0, 1, 2,
    3, 2, 2, 0, -2, -5, -7, -9, -9, -8, -6, -3, 0, 2, 2, 2, 0, -1, -2, -3, -4,
    -5, -5, -3, 0, 3, 6, 6, 4, 1, -2, -2, -2, -1, -1, -1, 0, 3, 6, 8, 7, 4, 0,
    -3, -4, -4, -2, 0, 2, 2, 2, 0, -4, -7, -9, -8, -5, -1, 2, 2, -1, -3, -4,
    -5, -4, -3, -1, 3, 7, 10, 10, 7, 3, 0, -3, -4, -3, -2, 0, 1, 2, 3, 2, 0,
    -3, -5, -5, -3, 0, 3, 3, 3, 1, 0, -1, -1, -1, -1, -2, -3, -4, -5, -5, -4,
    -3, 0, 2, 5, 6, 7, 8, 7, 5, 3, 0, -1, -2, -4, -5, -8, -9, -10, -9, -7, -5,
    -4, -5, -5, -5, -4, -2, -1, -1, 0, 2, 5, 7, 8, 6, 3, -1, -4, -5, -5, -4,
    -2, 0, 3, 5, 6, 5, 2, 0, -1, -2, -2, -2, -2, -2, -2, -3, -3, -2, -2, -3,
    -4, -4, -3, -1, 1, 2, 1, 0, -1, -1, 0, 4, 7, 9, 11, 10, 9, 6, 4, 1, -1, -1,
    0, 2, 3, 3, 2, 1, 0, -2, -3, -4, -3, -1, 0, 0, -2, -5, -7, -9, -10, -10,
    -8, -6, -4, -2, -1, -1, -2, -2, -2, -1, 0, 1, 2, 2, 1, -1, -2, -4, -5, -5,
    -5, -5, -4, -4, -3, -3, -3, -2, -1, 1, 2, 2, 2, 2, 2, 2, 3, 3, 2, 2, 1, 1,
    1, 2, 2, 2, 2, 1, 2, 2, 3, 3, 2, 0, -1, -3, -3, -3, -2, -1, 0, 0, 1, 1, 1,
    1, 2, 3, 4, 4, 4, 5, 5, 6, 5, 4, 2, 0, 0, 0, 1, 2, 2, 2, 1, 0, -2, -3, -4,
    -3, -2, 0, 0, -1, -2, -3, -3, -4, -5, -6, -8, -8, -7, -6, -4, -2, -1, 0,
    -1, -2, -3, -3, -1, 1, 2, 3, 3, 2, 2, 0, -2, -4, -5, -4, -2, -1, 0, 1, 1,
    1, 1, -1, -3, -4, -4, -2, 1, 2, 2, 0, -2, -4, -4, -4, -1, 2, 4, 5, 4, 3, 3,
    3, 3, 2, 2, 1, 1, 2, 2, 1, 0, -1, -1, 0, 0, 1, 1, 2, 3, 3, 3, 1, 0, -1, -1,
    -1, 0, 1, 1, 1, 0, -2, -4, -5, -6, -5, -5, -4, -3, -3, -2, -1, -1, -1, -2,
    -3, -2, -2, -1, 1, 2, 3, 3, 3, 2, 2, 2, 1, 0, -1, -2, -2, -2, -1, -1, -2,
    -2, -3, -3, -4, -4, -3, -3, -3, -3, -4, -5, -5, -3, -2, -1, -1, -1, -2, -1,
    -1, 0, 0, -1, -2, -3, -3, -2, -1, 1, 1, 2, 2, 2, 2, 3, 3, 3, 2, 2, 1, 1, 1,
    1, 1, 1, 1, 0, -1, -1, -1, -1, -1, 0, 0, 0, 1, 2, 3, 4
};

static const signed char stepping2[] = {
    -1, 1, 3, 3, 3, 1, -1, -2, -2, -2, -1, 0, 1, 1, -1, -3, -6, -7, -5, -1, 2,
    5, 4, 2, -1, -4, -6, -7, -6, -4, -2, -1, -1, -1, -2, -3, -4, -4, -3, 1, 6,
    9, 9, 5, 0, -4, -6, -6, -4, -3, -2, -1, -1, -3, -7, -11, -13, -12, -8, -1,
    6, 11, 14, 12, 7, 0, -5, -8, -7, -4, -1, 0, 0, -1, -1, 0, 0, 1, 2, 3, 5, 6,
    6, 6, 5, 5, 5, 5, 5, 4, 2, -2, -6, -9, -10, -8, -5, -1, 1, 2, 2, 1, -1, -3,
    -3, -2, 1, 4, 6, 5, 2, -1, -4, -5, -5, -5, -4, -3, -2, -2, -3, -4, -5, -3,
    -1, 2, 2, 1, -1, -3, -5, -6, -7, -6, -3, 0, 3, 5, 5, 4, 2, -1, -5, -7, -7,
    -4, 1, 4, 5, 2, -1, -4, -5, -4, -2, 1, 3, 6, 7, 6, 4, 1, -1, -1, 0, 1, 1,
    0, -1, -3, -4, -5, -5, -4, -2, 0, 2, 2, 1, 0, 1, 3, 5, 7, 7, 6, 3, 0, -2,
    -3, -3, -3, -3, -2, 0, 1, 3, 3, 2, 0, 0, 0, 1, 1, 0, -2, -3, -4, -3, -1, 0,
    2, 2, 1, -2, -5, -8, -9, -8, -6, -4, -2, -1, 0, 1, 1, -1, -3, -6, -7, -6,
    -3, -1, 0, 0, 0, 0, 0, 1, 2, 3, 3, 2, 0, -1, -2, -2, 0, 1, 3, 4, 4, 3, 1,
    -1, -2, -2, -1, 0, 2, 3, 2, 0, -3, -6, -9, -9, -7, -5, -3, -3, -4, -4, -4,
    -1, 1, 3, 4, 4, 3, 1, -1, -3, -2, 2, 6, 9, 8, 5, 0, -3, -4, -3, 0, 2, 4, 5,
    5, 5, 3, 1, 0, -1, -1, -2, -3, -4, -5, -5, -6, -6, -5, -4, -2, -1, 0, 1, 0,
    0, 1, 2, 3, 3, 4, 5, 5, 4, 2, -2, -7, -11, -13, -12, -9, -6, -3, -2, -1,
    -2, -2, -1, -1, 0, 1, 2, 4, 6, 5, 3, 0, -3, -5, -4, -3, -2, -2, -1, 1, 3,
    4, 4, 2, 0, -2, -3, -2, 0, 3, 6, 7, 7, 5, 1, -4, -8, -10, -10, -9, -7, -5,
    -4, -3, -3, -3, -3, -3, -2, -1, 0, 2, 4, 6, 7, 8, 8, 7, 5, 4, 2, 1, 1, 1,
    2, 3, 2, 1, 0, -1, -2, -1, -1, -1, 0, 0, 0, -1, -2, -4, -4, -4, -3, -3, -2,
    -3, -3, -4, -5, -4, -3, -2, 0, 1, 0, -1, -2, -3, -4, -4, -3, -2, -1, 0, 1,
    2, 2, 2, 1, 1, 1, 1, 2, 2, 2, 1, 0, -2, -2, -3, -3, -2, -1, 1, 2, 2, 1, 0,
    -2, -3, -2, -1, 1, 2, 2, 2, 1, 1, 0, 0, -1, -2, -2, -2, -2, -1, 0, 0, 1, 2,
    3, 4, 4, 3, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -1, -2, -3, -4, -4, -3, -2,
    -2, -3, -4, -5, -5, -5, -4, -4, -4, -3, -3, -2, -2, -3, -3, -2, -1, 1, 3,
    4, 4, 4, 5, 5, 6, 7, 6, 5, 4, 3, 2, 2, 2, 2, 1, -1, -3, -4, -5, -6, -6, -5,
    -4, -2, 0, 1, 0, -1, -2, -2, -2, -2, -2, -1, -1, -1, -1, -1, -2, -2, -2,
    -2, -2, -1, 0, 1, 2, 2, 2, 2, 1, 1, 1, 1, 0, -1, -1, -2, -2, -2, -1, 0, 0,
    0, -1, -2, -3, -2, -1, 1, 2, 4, 4, 4, 3, 1, -1, -2, -2, -2, -2, -2, -2, -1,
    0, 0, 0, -1, -2, -2, -2, 0, 1, 1, -1, -2, -4, -4, -4, -3, -2, -1, -1, -2,
    -3, -3, -3, -2, -1, 0, 1, 1, 1, 1, 2, 4, 5, 5, 4, 3, 2, 1, 1, 2, 2, 1, 0,
    0, 0, 1, 3, 3, 4, 4, 3, 2, 0, -2, -3, -2, -1, 0, 1, 0, -2, -4, -6, -7, -7,
    -7
};

static const signed char bump[] = {
    3, -1, -4, -3, 2, 4, 0, -5, -3, 7, 13, 5, -12, -20, -4, 29, 49, 35, -9,
    -49, -58, -37, -8, 10, 14, 17, 23, 23, 12, -4, -6, 12, 35, 36, 9, -27, -44,
    -37, -26, -34, -54, -56, -18, 44, 85, 71, 12, -43, -54, -27, 0, -4, -28,
    -35, -9, 29, 37, 4, -34, -34, 5, 38, 18, -49, -101, -80, 1, 73, 73, 8, -55,
    -58, -5, 45, 51, 21, 1, 11, 31, 25, -8, -32, -13, 37, 71, 59, 14, -18, -11,
    19, 31, 7, -31, -44, -20, 19, 41, 32, 5, -18, -29, -32, -31, -22, -2, 18,
    25, 14, -1, 1, 20, 33, 16, -30, -69, -69, -28, 20, 37, 18, -10, -18, -4,
    10, 10, 3, 11, 39, 67, 69, 44, 9, -15, -27, -40, -55, -54, -19, 42, 90, 88,
    35, -35, -80, -83, -60, -35, -17, 1, 24, 40, 33, -4, -51, -81, -75, -41, 1,
    35, 55, 60, 49, 22, -14, -42, -48, -35, -19, -13, -15, -7, 17, 41, 42, 12,
    -25, -34, -5, 40, 62, 45, 8, -17, -18, -8, -5, -13, -14, 2, 29, 42, 31, 5,
    -18, -27, -28, -32, -36, -31, -9, 19, 31, 16, -18, -49, -65, -65, -58, -48,
    -36, -19, -3, 4, -3, -17, -26, -23, -10, 9, 25, 37, 45, 48, 46, 40, 30, 20,
    12, 6, 5, 11, 27, 46, 59, 53, 28, -2, -21, -19, -3, 10, 8, -7, -19, -17,
    -2, 11, 13, 4, -7, -10, -4, 5, 11, 17, 26, 37, 45, 44, 34, 20, 9, 1, -3,
    -4, 0, 9, 19, 24, 19, 6, -11, -21, -22, -16, -9, -7, -10, -15, -16, -14,
    -11, -9, -7, -4, -2, -3, -8, -19, -30, -34, -30, -19, -10, -9, -14, -22,
    -29, -31, -31, -33, -34, -33, -30, -27, -29, -38, -50, -62, -69, -71, -68,
    -57, -37, -15, 1, 3, -9, -26, -34, -29, -13, 7, 26, 42, 53, 56, 53, 45, 36,
    32, 31, 32, 36, 40, 45, 48, 46, 37, 23, 10, 1, 0, 4, 11, 15, 16, 13, 9, 5,
    5, 6, 10, 14, 19, 24, 26, 26, 25, 25, 30, 38, 45, 46, 41, 32, 25, 23, 27,
    31, 33, 31, 30, 32, 35, 33, 24, 7, -8, -16, -14, -7, 0, 0, -6, -16, -26,
    -36, -46, -54, -60, -59, -52, -41, -34, -34, -41, -50, -55, -55, -51, -47,
    -45, -47, -53, -58, -60, -56, -47, -36, -28, -25, -27, -32, -34, -34, -29,
    -22, -13, -5, 0, 3, 6, 9, 15, 19, 20, 19, 18, 20, 25, 29, 28, 23, 17, 14,
    14, 15, 14, 11, 10, 11, 14, 16, 16, 17, 19, 23, 28, 31, 32, 33, 36, 40, 47,
    55, 62, 65, 62, 55, 47, 41, 41, 45, 49, 52, 51, 47, 40, 31, 21, 11, 5, 1,
    1, 1, 1, -1, -4, -11, -21, -33, -44, -50, -51, -48, -44, -42, -43, -47,
    -51, -55, -58, -60, -60, -59, -55, -51, -46, -43, -41, -40, -36, -31, -26,
    -23, -22, -21, -20, -18, -16, -15, -15, -14, -12, -10, -9, -9, -10, -11,
    -11, -9, -7, -4, -1, 3, 5, 6, 6, 5, 4, 5, 7, 8, 10, 13, 16, 19, 21, 22, 24,
    27, 32, 37, 40, 43, 44, 45, 44, 42, 39, 40, 44, 50, 55, 55, 49, 41, 33, 27,
    25, 24, 23, 21, 17, 12, 8, 6, 6, 7, 6, 3, -1, -6, -9, -12, -15, -17, -17,
    -15, -12, -9, -10, -16, -25, -34, -41, -43, -42, -38, -30, -21, -13, -8,
    -10, -17, -27, -34, -36, -34, -30, -25, -22, -19, -18, -19, -23, -29, -34,
    -35, -34, -31, -29, -28, -27, -25, -24, -23, -23, -22, -17, -10, -1, 6, 11,
    13, 12, 10, 6, 3, 2, 4, 9, 16, 24, 30, 33, 35, 35, 34, 32, 29, 26, 24, 24,
    25, 27, 28, 27, 25, 23, 22, 21, 20, 18, 16, 14, 12, 12, 12, 13, 13, 14, 16,
    18, 20, 21, 20, 16, 11, 6, 2, 0, 0, 0, -1, -2, -3, -2, -1, -1, -4, -9, -13,
    -15, -15, -14, -11, -10, -11, -14, -17, -21, -24, -25, -25, -25, -24, -23,
    -22, -21, -21, -21, -23, -24, -25, -25, -24, -22, -20, -18, -17, -17, -17,
    -18, -19, -20, -18, -15, -11, -7, -4, -2, 0, 2, 4, 5, 4, 2, 1, 1, 3, 6, 8,
    9, 10, 11, 11, 11, 11, 12, 13, 14, 15, 16, 16, 17, 17, 16, 16, 16, 16, 16,
    15, 14, 12, 10, 9, 8, 7, 7, 8, 9, 11, 11, 11, 10, 8, 6, 4, 1, 0, -1, 0, 1,
    3, 3, 3, 2, 0, -2, -4, -5, -4, -3, -2, 0, 0, 0, 1, 1, 0, -2, -4, -5, -2, 1,
    5, 7, 7, 6, 4, 3, 2, 3, 4, 5, 6, 5, 3, -1, -5, -9, -12, -13, -13, -12, -11,
    -12, -15, -19, -24, -27, -29, -29, -28, -27, -25, -24, -23, -22, -22, -21,
    -20, -17, -12, -7, -2, 0, 1, -1, -4, -7, -10, -11, -11, -8, -4, -1, 1, 2,
    2, 0, -2, -4, -5, -3, 0, 4, 7, 9, 10, 11, 13, 15, 16, 17, 18, 19, 20, 20,
    20, 18, 16, 15, 14, 15, 15, 15, 14, 13, 12, 13, 15, 17, 19, 19, 19, 19, 20,
    21, 20, 18, 16, 14, 11, 8, 4, 0, -2, -3, -4, -5, -7, -8, -9, -10, -11, -12,
    -14, -15, -15, -16, -17, -19, -20, -20, -21, -22, -22, -21, -19, -17, -16,
    -17, -19, -21, -23, -24, -24, -22, -18, -12, -7, -2, 0, 1, 1, 0, -3, -6,
    -8, -9, -7, -5, -2, 1, 3, 4, 4, 3, 1, 0, 0, 1, 2, 2, 2, 1, 0, 0, 1, 3, 5,
    6, 7, 7, 7, 7, 8, 8, 7, 4, 3, 2, 2, 3, 4, 4, 5, 6, 8, 9, 10, 10, 9, 8, 7,
    6, 5, 5, 5, 6, 7, 9, 10, 12, 13, 13, 13, 11, 8, 6, 4, 2, 0, -1, -1, -2, -1,
    -1, -2, -4, -7, -9, -11, -11, -10, -8, -5, -2, 0, 1, 0, -1, -1, -1, 0, 0,
    1, 2, 3, 4, 4, 3, 1, -2, -4, -7, -8, -8, -7, -6, -5, -4, -4, -5, -5, -6,
    -5, -5, -4, -4, -3, -3, -4, -5, -7, -10, -11, -11, -10, -9, -7, -7, -6, -6,
    -5, -5, -4, -3, -2, -2, -3, -6, -8, -11, -13, -14, -12, -8, -2, 3, 6, 7, 7,
    7, 5, 3, 0, -3, -3, -1, 2, 6, 9, 11, 10, 9, 7, 6, 4, 3, 4, 6, 8, 10, 10, 9,
    7, 5, 5, 6, 8, 10, 11, 10, 10, 9, 9, 8, 8, 7, 6, 6, 5, 4, 2, 1, -1, -2, -2,
    -2, -2, -2, -3, -2, -2, -1, 0, 0, 0, 0, 1, 2, 3, 2, 1, 0, -1, -3, -6, -8,
    -11, -12, -13, -12, -11, -10, -10, -13, -15, -17, -17, -16, -14, -13, -13,
    -13, -14, -16, -18, -19, -20, -19, -18, -15, -13, -10, -8, -7, -7, -7, -6,
    -4, 0, 4, 6, 8, 9, 10, 11, 11, 12, 12, 12, 12, 11, 11, 10, 9, 9, 10, 11,
    12, 12, 10, 7, 7, 8, 11, 12, 12, 11, 11, 12, 14, 15, 15, 15, 14, 14, 14,
    15, 15, 14, 13, 10, 6, 2, -1, -2, -2, -1, 1, 1, 1, 0, -2, -5, -7, -9, -10,
    -11, -11, -10, -9, -9, -9, -9, -9, -8, -8, -9, -10, -11, -12, -12, -12,
    -12, -13, -15, -17, -17, -17, -16, -14, -13, -13, -13, -12, -12, -11, -10,
    -10, -10, -9, -7, -5, -2, 0, 1, 2, 1, 0, -1, -1, 0, 3, 6, 7, 7, 6, 5, 3, 2,
    1, 1, 1, 4, 7, 10, 10, 7, 4, 1, 1, 1, 2, 3, 5, 7, 9, 10, 9, 6, 4, 4, 4, 4,
    2, 0, -2, -2, -2, -1, 0, 1, 2, 4, 6, 5, 4, 2, 1, 2, 3, 5, 6, 7, 8, 8, 8, 8,
    7, 6, 5, 4, 2, 1, 2, 4, 5, 5, 3, 1, -2, -3, -4, -4, -5, -5, -6, -6, -5, -5,
    -5, -5, -6, -6, -7, -8, -8, -8, -7, -7, -8, -9, -9, -9, -9, -10, -12, -14,
    -14, -12, -10, -7, -6, -6, -8, -9, -9, -9, -7, -4, -2, -1, -1, -3, -6, -10,
    -12, -12, -10, -7, -4, -3, -2, -3, -3, -4, -4, -5, -4, -2, 1, 4, 6, 8, 8,
    7, 5, 3, 1, 2, 4, 7, 10, 11, 11, 11, 11, 11, 10, 10, 10, 12, 14, 17, 18,
    19, 19, 18, 16, 14, 12, 12, 13, 15, 16, 16, 15, 13, 11, 9, 6, 3, 0, -1, -2,
    -2, -3, -5, -7, -7, -7, -7, -8, -10, -12, -12, -13, -15, -17, -19, -20,
    -20, -19, -19, -19, -17, -14, -13, -15, -17, -19, -17, -14, -10, -8, -7,
    -6, -4, -4, -5, -7, -9, -9, -7, -4, -2, -1, -2, -2, -3, -3, -4, -5, -5, -4,
    -3, -2, 0, 1, 3, 5, 5, 5, 4, 4, 6, 9, 11, 13, 14, 15, 17, 18, 18, 18, 18,
    17, 16, 15, 14, 14, 13, 12, 10, 10, 10, 10, 9, 7, 4, 2, 1, 2, 2, 0, -2, -4,
    -5, -8, -10, -12, -13, -11, -9, -7, -5, -2, 1, 1, -3, -10, -13, -12, -6,
    -3, -6, -11, -13, -9, -3, 1, 1, -1, 0, 3, 5, 3, -3, -9, -13, -16, -19, -19,
    -14, -4, 5, 8, 0, -12, -23, -28, -27, -23, -19, -15, -10, -2, 8, 17, 23,
    24, 18, 7, -8, -23, -32, -28, -13, 4, 17, 20, 18, 16, 15, 11, -1, -17, -25,
    -19, 0, 21, 33, 33, 29, 23, 17, 8, -5, -13, -12, -1, 15, 26, 27, 20, 11, 6,
    6, 11, 18, 25, 29, 26, 16, -1, -17, -26, -21, -6, 13, 25, 25, 15, -1, -18,
    -32, -40, -41, -33, -16, 5, 23, 30, 23, 3, -23, -43, -51, -47, -32, -13, 6,
    19, 25, 23, 11, -6, -23, -30, -25, -9, 7, 17, 17, 11, 6, 3, -2, -13, -25,
    -31, -27, -14, -1, 4, 1, -5, -10, -14, -15, -16, -13, -7, 1, 6, 6, 4, 3, 4,
    7, 7, 3, -1, -4, -2, 5, 11, 12, 8, 4, 4, 10, 18, 20, 15, 7, 3, 5, 8, 9, 5,
    1, -1, 2, 7, 10, 9, 4, -4, -11, -15, -15, -11, -5, 1, 7, 11, 12, 10, 6, 2,
    2, 4, 8, 10, 11, 10, 8, 6, 3, 0, -4, -7, -9, -8, -5, 0, 4, 4, 1, -3, -7,
    -8, -9, -8, -6, -3, -1, 1, -1, -4, -8, -9, -10, -10, -9, -9, -7, -6, -4,
    -3, -3, -1, 1, 2, 1, -2, -6, -8, -8, -4, -1, 0, -1, -2, -2, 1, 3, 2, -2,
    -8, -12, -12, -8, -1, 3, 3, 0, -5, -9, -11, -10, -7, -4, -1, -1, -2, -2,
    -1, 0, -1, -2, -4, -4, -1, 4, 9, 13, 13, 11, 9, 7, 5, 5, 4, 4, 2, 0, 0, 3,
    8, 11, 12, 11, 10, 11, 12, 10, 5, 2, 5, 12, 15, 10, -3, -12, -10, 2, 13,
    13, 4, -5, -4, 4, 11, 11, 4, -3, -6, -5, -5, -4, 0, 7, 13, 11, -1, -16,
    -23, -19, -10, -7, -14, -23, -26, -18, -5, 1, -4, -15, -22, -20, -14, -12,
    -14, -17, -12, -1, 10, 13, 7, -3, -12, -17, -20, -22, -20, -14, -4, 5, 10,
    9, 6, 4, 2, 1, 0, 2, 7, 14, 19, 18, 11, 0, -11, -17, -15, -6, 8, 18, 23,
    19, 11, 3, -2, -3, -2, 2, 8, 17, 26, 34, 33, 23, 6, -11, -19, -16, -6, 5,
    12, 16, 16, 14, 7, -4, -13, -16, -11, 0, 12, 20, 21, 14, 2, -12, -23, -26,
    -23, -15, -8, 0, 6, 9, 5, -4, -14, -19, -14, -4, 6, 12, 12, 9, 3, -3, -12,
    -18, -20, -16, -9, -2, 1, -1, -6, -13, -18, -21, -20, -16, -8, 2, 11, 17,
    15, 8, -2, -9, -11, -9, -5, -1, 4, 9, 14, 14, 9, 2, -5, -7, -4, 1, 8, 15,
    20, 21, 17, 8, -3, -12, -16, -14, -9, -1, 4, 7, 7, 3, -4, -13, -19, -20,
    -15, -7, 2, 8, 11, 10, 8, 4, 0, -2, -2, 0, 3, 5, 5, 3, 1, -1, -1, -1, 0, 1,
    2, 3, 2, -1, -6, -11, -12, -10, -5, 0, 4, 5, 3, -1, -6, -10, -11, -9, -6,
    -2, 1, 2, 2, 1, 0, -1, -2, -3, -3, -1, 3, 6, 8, 6, 2, -2, -5, -5, -4, -1,
    2, 4, 5, 4, 2, 0, -1, -2, -2, -1, 0, 1, 3, 4, 3, 0, -5, -9, -11, -11, -9,
    -6, -4, -2, -1, 1, 0, -1, -3, -5, -5, -4, -1, 1, 2, 2, 0, -2, -3, -2, 1, 3,
    6, 7, 7, 6, 5, 3, 2, 0, 0, 1, 2, 3, 3, 3, 2, 0, -2, -4, -5, -6, -6, -6, -6,
    -5, -2, 1, 2, 1, 0, 0, 2, 4, 4, 2, 0, -1, 0, 3, 5, 6, 5, 4, 3, 2, 1, -1,
    -3, -4, -4, -2, 0, 1, 0, -2, -4, -5, -7, -7, -8, -7, -6, -5, -3, -1, -1,
    -2, -4, -5, -4, -2, 2, 5, 6, 5, 2, 0, -1, 0, 2, 5, 7, 7, 6, 3, -1, -5, -7,
    -8, -6, -3, 0, 2, 4, 5, 4, 1, -2, -4, -5, -4, -2, 1, 2, 2, 1, -1, -4, -5,
    -5, -3, -1, 1, 2, 2, 0, -1, -2, -3, -3, -2, 1, 4, 7, 7, 4, 1, -2, -4, -6,
    -6, -5, -3, -1, 1, 1, 1, -1, -3, -5, -7, -7, -7, -5, -3, -2, -2, -3, -4,
    -5, -6, -6, -6, -5, -4, -2, 0, 1, 1, 0, -2, -3, -3, -2, 0, 2, 3, 4, 4, 3,
    2, 1, 0, 0, 1, 2, 5, 6, 7, 7, 6, 4, 1, 0, -1, 0, 3, 5, 7, 6, 4, 2, 0, -1,
    -1, -1, 0, 1, 2, 5, 6, 7, 6, 4, 3, 2, 3, 4, 4, 4, 3, 2, 0, -1, -1, 0, 2, 2,
    0, -2, -3, -3, -1, 0, 2, 2, 2, 1, 0, 0, -1, -1, -3, -4, -6, -8, -9, -8, -8,
    -7, -7, -8, -9, -11, -11, -11, -11, -11, -11, -12, -12, -12, -11, -11, -10,
    -9, -8, -7, -6, -4, -2, -1, -1, -2, -3, -4, -3, 0, 3, 4, 5, 5, 4, 5, 5, 5,
    4, 3, 1, 2, 3, 5, 5, 4, 3, 2, 3, 4, 5, 6, 7, 7, 8, 8, 8, 8, 8, 8, 8, 7, 7,
    7, 7, 8, 8, 7, 6, 5, 6, 7, 8, 8, 7, 5, 3, 1, -2, -5, -7, -8, -7, -6, -5,
    -4, -4, -4, -6, -7, -9, -11, -12, -11, -10, -9, -7, -6, -5, -4, -5, -5, -5,
    -5, -4, -4, -4, -4, -5, -6, -5, -3, -1, 1, 3, 3, 3, 2, 1, 1, 0, 0, 0, 0, 0,
    0, 1, 2, 2, 1, -1, -2, -2, -3, -4, -5, -6, -6, -6, -6, -4, -2, 1, 3, 3, 1,
    0, -1, -1, -1, -1, -1, 0, 2, 4, 5, 6, 6, 5, 4, 4, 3, 3, 4, 4, 4, 4, 4, 4,
    4, 2, 0, -3, -4, -5, -4, -4, -3, -3, -4, -5, -5, -4, -3, -2, -2, -1, 1, 2,
    3, 2, 1, 0, -1, 0, 2, 5, 7, 7, 6, 4, 2, 1, 1, 1, 3, 3, 3, 1, 1, 1, 2, 1, 0,
    -2, -3, -3
};

static const signed char nosound[1] = { 0 };

static sound_chip_t drive_sound;

static uint16_t drive_sound_offset;
static const signed char *step[DRIVE_NUM];
static const signed char *motor[DRIVE_NUM];
static int stepvol[DRIVE_NUM];
static int motorvol[DRIVE_NUM];

static int cycles_per_sec = 1000000;
static int sample_rate = 22050;

/* resources */
extern int drive_sound_emulation;
extern int drive_sound_emulation_volume;

static int drive_sound_machine_calculate_samples(sound_t **psid, int16_t *pbuf, int nr, int soc, int scc, int *delta_t)
{
    int i, j, nos = 0;
    static int div = 0;
    int m, s;

    for (i = 0; i < nr; i++) {
        for (j = 0; j < DRIVE_NUM; j++) {
            m = (((*motor[j]) * motorvol[j]) * drive_sound_emulation_volume) >> 8;
            s = (((*step[j]) * stepvol[j]) * drive_sound_emulation_volume) >> 8;
            switch (soc) {
                default:
                case 1:
                    pbuf[i] = sound_audio_mix(pbuf[i], m);
                    pbuf[i] = sound_audio_mix(pbuf[i], s);
                    break;
                case 2:
                    pbuf[i * 2] = sound_audio_mix(pbuf[i * 2], m);
                    pbuf[i * 2] = sound_audio_mix(pbuf[i * 2], s);
                    pbuf[i * 2 + 1] = sound_audio_mix(pbuf[i * 2 + 1], m);
                    pbuf[i * 2 + 1] = sound_audio_mix(pbuf[i * 2 + 1], s);
                    break;
            }
        }
        div += 44100;
        while (div >= sample_rate) {
            div -= sample_rate;
            nos = 1;
            for (j = 0; j < DRIVE_NUM; j++) {
                motor[j]++;
                if (motor[j] == &spinup[sizeof(spinup)]) {
                    motor[j] = hum;
                }
                if (motor[j] == &hum[sizeof(hum)]) {
                    motor[j] = hum;
                }
                if (motor[j] == &spindown[sizeof(spindown)]) {
                    motor[j] = nosound;
                }
                if (motor[j] == nosound + 1) {
                    motor[j] = nosound;
                } else {
                    nos = 0;
                }
                step[j]++;
                if (step[j] == &stepping[sizeof(stepping)]) {
                    step[j] = nosound;
                }
                if (step[j] == &stepping2[sizeof(stepping2)]) {
                    step[j] = nosound;
                }
                if (step[j] == &bump[sizeof(bump)]) {
                    step[j] = nosound;
                }
                if (step[j] == nosound + 1) {
                    step[j] = nosound;
                } else {
                    nos = 0;
                }
            }
        }
    }
    if (nos) {
        drive_sound.chip_enabled = 0;
    }
    return nr;
}

static int drive_sound_machine_init(sound_t *psid, int speed, int cycles)
{
    cycles_per_sec = cycles;
    sample_rate = speed;
    return 1;
}

static int drive_sound_machine_cycle_based(void)
{
    return 0;
}

static int drive_sound_machine_channels(void)
{
    return 1;
}

/* Drive sound 'chip', emulates the sound of a 1541 disk drive */
static sound_chip_t drive_sound = {
    NULL,                                  /* NO sound chip open function */ 
    drive_sound_machine_init,              /* sound chip init function */
    NULL,                                  /* NO sound chip close function */
    drive_sound_machine_calculate_samples, /* sound chip calculate samples function */
    NULL,                                  /* NO sound chip store function */
    NULL,                                  /* NO sound chip read function */
    NULL,                                  /* NO sound chip reset function */
    drive_sound_machine_cycle_based,       /* sound chip 'is_cycle_based()' function, chip is NOT cycle based */
    drive_sound_machine_channels,          /* sound chip 'get_amount_of_channels()' function, sound chip has 1 channel */
    0                                      /* sound chip enabled flag, toggled upon device (de-)activation */
};

void drive_sound_update(int i, int unit)
{
    if (!drive_sound_emulation) {
        drive_sound.chip_enabled = 0;
        return;
    }
    sound_store((uint16_t)drive_sound_offset, 0, 0);
    switch (i) {
        case DRIVE_SOUND_MOTOR_ON:
            motor[unit] = spinup;
            drive_sound.chip_enabled = 1;
            break;
        case DRIVE_SOUND_MOTOR_OFF:
            motor[unit] = spindown;
            drive_sound.chip_enabled = 1;
            break;
    }
}

void drive_sound_head(int track, int dir, int unit)
{
    if (!drive_sound_emulation) {
        drive_sound.chip_enabled = 0;
        return;
    }
    sound_store((uint16_t)drive_sound_offset, 0, 0);
    stepvol[unit] = 100 - track;
    if (track == 2 && dir == -1) {
        if (step[unit] == nosound) {
            drive_sound.chip_enabled = 1;
            step[unit] = bump;
        }
    } else {
        step[unit] = (track < 18) ? stepping : stepping2;
        drive_sound.chip_enabled = 1;
    }
}

void drive_sound_stop(void)
{
    int i;
    for (i = 0; i < DRIVE_NUM; i++) {
        motor[i] = nosound;
        step[i] = nosound;
        stepvol[i] = 0;
    }
    drive_sound.chip_enabled = 0;
}

void drive_sound_init(void)
{
    int i;
    drive_sound_stop();
    drive_sound_offset = sound_chip_register(&drive_sound);
    for (i = 0; i < DRIVE_NUM; i++) {
        motorvol[i] = 10;
    }
}
