#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotlsashplay.it>
# SPDX-FileCopyrightText: © 2021 Christian Stalp
# SPDX-FileCopyrightText: © 2023 Jacek Szafarkiewicz
set -o errexit

###
# Neverwinter Nights 1 Enhanced Edition
# send your bug reports to contact@dotslashplay.it
###

script_version=20231116.3

PLAYIT_COMPATIBILITY_LEVEL='2.27'

GAME_ID='neverwinter-nights-1-enhanced-edition'
GAME_NAME='Neverwinter Nights: Enhanced Edition'

ARCHIVE_BASE_5_NAME='neverwinter_nights_enhanced_edition_87_8193_35_40_65678.sh'
ARCHIVE_BASE_5_MD5='c1191f9e19f1da52f1424025017cf56f'
ARCHIVE_BASE_5_SIZE='6253452'
ARCHIVE_BASE_5_VERSION='87.8193.35.40-gog65678'
ARCHIVE_BASE_5_URL='https://www.gog.com/game/neverwinter_nights_enhanced_edition_pack'

ARCHIVE_BASE_5_FR_0_NAME='neverwinter_nights_enhanced_edition_french_87_8193_35_40_65678.sh'
ARCHIVE_BASE_5_FR_0_MD5='319194e7a229b24b19f7454d8ed860d6'
ARCHIVE_BASE_5_FR_0_SIZE='6253452'
ARCHIVE_BASE_5_FR_0_VERSION='87.8193.35.40-gog65678'
ARCHIVE_BASE_5_FR_0_URL='https://www.gog.com/game/neverwinter_nights_enhanced_edition_pack'

ARCHIVE_BASE_5_PL_0_NAME='neverwinter_nights_enhanced_edition_polish_87_8193_35_40_65678.sh'
ARCHIVE_BASE_5_PL_0_MD5='d4c3d4c4af501424a60bf9e09e5a2f01'
ARCHIVE_BASE_5_PL_0_SIZE='6253452'
ARCHIVE_BASE_5_PL_0_VERSION='87.8193.35.40-gog65678'
ARCHIVE_BASE_5_PL_0_URL='https://www.gog.com/game/neverwinter_nights_enhanced_edition_pack'

ARCHIVE_BASE_5_OPTIONAL_L10N_DE='neverwinter_nights_enhanced_edition_german_extras_87_8193_35_40_65678.sh'
ARCHIVE_BASE_5_OPTIONAL_L10N_DE_MD5='596b075b63b8f9f76bbf1eeaa8150cfb'
ARCHIVE_BASE_5_OPTIONAL_L10N_DE_SIZE='892816'
ARCHIVE_BASE_5_OPTIONAL_L10N_DE_URL='https://www.gog.com/game/neverwinter_nights_enhanced_edition_german_extras'

ARCHIVE_BASE_5_OPTIONAL_L10N_FR='neverwinter_nights_enhanced_edition_french_extras_87_8193_35_40_65678.sh'
ARCHIVE_BASE_5_OPTIONAL_L10N_FR_MD5='88b889d8eefadfde33d0fad8bac1b9be'
ARCHIVE_BASE_5_OPTIONAL_L10N_FR_SIZE='833404'
ARCHIVE_BASE_5_OPTIONAL_L10N_FR_URL='https://www.gog.com/game/neverwinter_nights_enhanced_edition_french_extras'

ARCHIVE_BASE_5_OPTIONAL_L10N_PL='neverwinter_nights_enhanced_edition_polish_extras_87_8193_35_40_65678.sh'
ARCHIVE_BASE_5_OPTIONAL_L10N_PL_MD5='c78a405c135ffad7e126bd44113ecc86'
ARCHIVE_BASE_5_OPTIONAL_L10N_PL_SIZE='833404'
ARCHIVE_BASE_5_OPTIONAL_L10N_PL_URL='https://www.gog.com/game/neverwinter_nights_enhanced_edition_polish_extras'

ARCHIVE_BASE_4_NAME='neverwinter_nights_enhanced_edition_85_8193_33_50393.sh'
ARCHIVE_BASE_4_MD5='4e6c4f7bd75791a9c726b7b573cfafe5'
ARCHIVE_BASE_4_SIZE='6300000'
ARCHIVE_BASE_4_VERSION='85.8193.33-gog50393'

ARCHIVE_BASE_4_FR_0_NAME='neverwinter_nights_enhanced_edition_french_85_8193_33_50393.sh'
ARCHIVE_BASE_4_FR_0_MD5='19b036e3c07fd4aa9a835de05b4aea1f'
ARCHIVE_BASE_4_FR_0_SIZE='6200000'
ARCHIVE_BASE_4_FR_0_VERSION='85.8193.33-gog50393'

ARCHIVE_BASE_4_OPTIONAL_L10N_DE='neverwinter_nights_enhanced_edition_german_extras_85_8193_33_50393.sh'
ARCHIVE_BASE_4_OPTIONAL_L10N_DE_MD5='d20a22fc2dfdeca4bb71bb7fd7e13a82'
ARCHIVE_BASE_4_OPTIONAL_L10N_DE_SIZE='900000'

ARCHIVE_BASE_4_OPTIONAL_L10N_FR='neverwinter_nights_enhanced_edition_french_extras_85_8193_33_50393.sh'
ARCHIVE_BASE_4_OPTIONAL_L10N_FR_MD5='f39ecc55b15740322d8ae860ccfecbc5'
ARCHIVE_BASE_4_OPTIONAL_L10N_FR_SIZE='840000'

ARCHIVE_BASE_3_NAME='neverwinter_nights_enhanced_edition_83_8193_23_47201.sh'
ARCHIVE_BASE_3_MD5='b85d2ea70aa6dba1096e97e944d98141'
ARCHIVE_BASE_3_SIZE='6300000'
ARCHIVE_BASE_3_VERSION='83.8193.23-gog47201'

ARCHIVE_BASE_2_NAME='neverwinter_nights_enhanced_edition_82_8193_20_1_43497.sh'
ARCHIVE_BASE_2_MD5='c80e73f0305ad99355cc089c632b8b0c'
ARCHIVE_BASE_2_SIZE='6200000'
ARCHIVE_BASE_2_VERSION='82.8193.20.1-gog43497'

ARCHIVE_BASE_1_NAME='neverwinter_nights_enhanced_edition_81_8193_16_41300.sh'
ARCHIVE_BASE_1_MD5='a52646002ab14c452731b0636fdc8278'
ARCHIVE_BASE_1_SIZE='6200000'
ARCHIVE_BASE_1_VERSION='81.8193.16-gog41300'

ARCHIVE_BASE_1_FR_0_NAME='neverwinter_nights_enhanced_edition_french_81_8193_16_41300.sh'
ARCHIVE_BASE_1_FR_0_MD5='67f42c1a1604a26fdbcd0cbc800856f5'
ARCHIVE_BASE_1_FR_0_SIZE='6200000'
ARCHIVE_BASE_1_FR_0_VERSION='81.8193.16-gog41300'

ARCHIVE_BASE_1_OPTIONAL_L10N_DE='neverwinter_nights_enhanced_edition_german_extras_81_8193_16_41300.sh'
ARCHIVE_BASE_1_OPTIONAL_L10N_DE_MD5='1e81fcf9d40bcf23dec0a77069222a52'
ARCHIVE_BASE_1_OPTIONAL_L10N_DE_SIZE='900000'

ARCHIVE_BASE_1_OPTIONAL_L10N_FR='neverwinter_nights_enhanced_edition_french_extras_81_8193_16_41300.sh'
ARCHIVE_BASE_1_OPTIONAL_L10N_FR_MD5='1fe0cc196c146834ff186935ae2d3d66'
ARCHIVE_BASE_1_OPTIONAL_L10N_FR_SIZE='840000'

ARCHIVE_BASE_0_NAME='neverwinter_nights_enhanced_edition_80_8193_9_37029.sh'
ARCHIVE_BASE_0_MD5='fb98f859b5f5516fc7df8b00c7264c07'
ARCHIVE_BASE_0_VERSION='80.8193.9-gog37029'
ARCHIVE_BASE_0_SIZE='5000000'

ARCHIVE_BASE_0_OPTIONAL_L10N_FR='neverwinter_nights_enhanced_edition_french_extras_80_8193_9_37029.sh'
ARCHIVE_BASE_0_OPTIONAL_L10N_FR_MD5='5e0564a161259b003c7dc0f8d8aa743f'
ARCHIVE_BASE_0_OPTIONAL_L10N_FR_SIZE='840000'

CONTENT_PATH_DEFAULT='data/noarch/game'
CONTENT_GAME_BIN_FILES='
bin/linux-x86'
CONTENT_GAME_L10N_DE_FILES='
lang/de/data'
CONTENT_GAME_L10N_FR_FILES='
lang/fr/data'
CONTENT_GAME_L10N_PL_FILES='
lang/pl/data'
## The English localization is provided in the base package, so it can always be used as a fallback.
CONTENT_GAME_DATA_FILES='
data
ovr
lang/en/data'
CONTENT_DOC_L10N_DE_PATH="${CONTENT_PATH_DEFAULT}/lang"
CONTENT_DOC_L10N_DE_FILES='
de/docs'
CONTENT_DOC_L10N_FR_PATH="${CONTENT_PATH_DEFAULT}/lang"
CONTENT_DOC_L10N_FR_FILES='
fr/docs'
CONTENT_DOC_L10N_PL_PATH="${CONTENT_PATH_DEFAULT}/lang"
CONTENT_DOC_L10N_PL_FILES='
pl/docs'
CONTENT_DOC_DATA_PATH="${CONTENT_PATH_DEFAULT}/lang"
CONTENT_DOC_DATA_FILES='
en/docs'

APP_MAIN_EXE='bin/linux-x86/nwmain-linux'
APP_MAIN_ICON='bin/win32/nwmain.exe'
## Run the game binary from its parent directory
APP_MAIN_PRERUN='# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")
'

APP_SERVER_ID="${GAME_ID}-server"
APP_SERVER_NAME="${GAME_NAME} - server"
APP_SERVER_EXE='bin/linux-x86/nwserver-linux'
APP_SERVER_ICON='bin/win32/nwserver.exe'
## Run the game binary from its parent directory
APP_SERVER_PRERUN='# Run the game binary from its parent directory
cd "$(dirname "$APP_EXE")"
APP_EXE=$(basename "$APP_EXE")
'

PACKAGES_LIST='
PKG_BIN
PKG_L10N_DE
PKG_L10N_FR
PKG_L10N_PL
PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_L10N_ID="${GAME_ID}-l10n"
PKG_L10N_DE_ID="${PKG_L10N_ID}-de"
PKG_L10N_FR_ID="${PKG_L10N_ID}-fr"
PKG_L10N_PL_ID="${PKG_L10N_ID}-pl"
PKG_L10N_PROVIDES="
$PKG_L10N_ID"
PKG_L10N_DE_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_FR_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_PL_PROVIDES="$PKG_L10N_PROVIDES"
PKG_L10N_DE_DESCRIPTION='German localization'
PKG_L10N_FR_DESCRIPTION='French localization'
PKG_L10N_PL_DESCRIPTION='Polish localization'
PKG_L10N_DEPS="$GAME_ID"
PKG_L10N_DE_DEPS="$PKG_L10N_DEPS"
PKG_L10N_FR_DEPS="$PKG_L10N_DEPS"
PKG_L10N_PL_DEPS="$PKG_L10N_DEPS"

PKG_BIN_ARCH='64'
PKG_BIN_DEPS="$PKG_DATA_ID"
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libstdc++.so.6'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Force the use of system-provided SDL

APP_MAIN_PRERUN="$(application_prerun 'APP_MAIN')
# Force the use of the system SDL library
export SDL_DYNAMIC_API='$(path_libraries_system)/libSDL2-2.0.so.0'
"

# Check for the presence of optional extra archives

archive_prefix=$(current_archive | grep --only-matching '^ARCHIVE_BASE_[0-9]*')
## German localization
if [ -n "$(get_value "${archive_prefix}_OPTIONAL_L10N_DE")" ]; then
	archive_initialize_optional \
		'ARCHIVE_L10N_DE' \
		"${archive_prefix}_OPTIONAL_L10N_DE"
fi
## French localization
if [ -n "$(get_value "${archive_prefix}_OPTIONAL_L10N_FR")" ]; then
	archive_initialize_optional \
		'ARCHIVE_L10N_FR' \
		"${archive_prefix}_OPTIONAL_L10N_FR"
fi
## Polish localization
if [ -n "$(get_value "${archive_prefix}_OPTIONAL_L10N_PL")" ]; then
	archive_initialize_optional \
		'ARCHIVE_L10N_PL' \
		"${archive_prefix}_OPTIONAL_L10N_PL"
fi

# Extract game data

archive_extraction 'SOURCE_ARCHIVE'
## German localization
if archive_is_available 'ARCHIVE_L10N_DE'; then
	archive_extraction 'ARCHIVE_L10N_DE'
fi
## French localization
if archive_is_available 'ARCHIVE_L10N_FR'; then
	archive_extraction 'ARCHIVE_L10N_FR'
fi
## Polish localization
if archive_is_available 'ARCHIVE_L10N_PL'; then
	archive_extraction 'ARCHIVE_L10N_PL'
fi

# Include game data

set_current_package 'PKG_DATA'
icons_inclusion
content_inclusion_default

# Write launchers

set_current_package 'PKG_BIN'
launchers_write

# Build packages

packages_generation
case "${LANG%_*}" in
	('fr')
		message='version %s :'
		lang_en='anglaise'
		lang_de='allemande'
		lang_fr='française'
		lang_pl='polonaise'
	;;
	('en'|*)
		message='%s version:'
		lang_en='English'
		lang_de='German'
		lang_fr='French'
		lang_pl='Polish'
	;;
esac
printf '\n'
printf "$message" "$lang_en"
print_instructions 'PKG_DATA' 'PKG_BIN'
printf "$message" "$lang_de"
print_instructions 'PKG_L10N_DE' 'PKG_DATA' 'PKG_BIN'
printf "$message" "$lang_fr"
print_instructions 'PKG_L10N_FR' 'PKG_DATA' 'PKG_BIN'
printf "$message" "$lang_pl"
print_instructions 'PKG_L10N_PL' 'PKG_DATA' 'PKG_BIN'

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

exit 0
