/*###############################################################################
# Linux Management Providers (LMP), OS provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr ,widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2009 Khahramon NURIDDINOV, TUIT <qahramon0786@gmail.com>
# Modified by 2009 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "cmpiOpenDRIM_OperatingSystem.h"
#include "OpenDRIM_OperatingSystemAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define OS_OpenDRIM_OperatingSystemProviderSetInstance OS_OpenDRIM_OperatingSystemProviderModifyInstance
#endif

int OS_OpenDRIM_OperatingSystem_init(const CMPIBroker* broker);

int OS_OpenDRIM_OperatingSystem_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus OS_OpenDRIM_OperatingSystemProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = OS_OpenDRIM_OperatingSystem_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_OperatingSystem> instances;
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystem_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = OS_OpenDRIM_OperatingSystem_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_OperatingSystem> instances;
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystem_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = OS_OpenDRIM_OperatingSystem_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystem instance;
	OS_OpenDRIM_OperatingSystem_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystem_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = OS_OpenDRIM_OperatingSystem_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystem newInstance, oldInstance;
	OS_OpenDRIM_OperatingSystem_toCPP(_broker, ci, newInstance);
	OS_OpenDRIM_OperatingSystem_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystem_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OS_OpenDRIM_OperatingSystem_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystem instance;
	OS_OpenDRIM_OperatingSystem_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystem_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OS_OpenDRIM_OperatingSystem_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OS_OpenDRIM_OperatingSystem_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = OS_OpenDRIM_OperatingSystem_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystem instance;
	OS_OpenDRIM_OperatingSystem_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = OS_OpenDRIM_OperatingSystem_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = OS_OpenDRIM_OperatingSystem_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                        Method Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus OS_OpenDRIM_OperatingSystemProviderMethodCleanup(CMPIMethodMI * mi, const CMPIContext * ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = OS_OpenDRIM_OperatingSystem_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus OS_OpenDRIM_OperatingSystemProviderInvokeMethod(CMPIMethodMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* methodName, const CMPIArgs* in, CMPIArgs* out) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_OperatingSystem instance;
	OS_OpenDRIM_OperatingSystem_toCPP(_broker, ref, instance);
	string errorMessage;

	const char* properties[] = {"Name", "CreationClassName", "CSCreationClassName", "CSName"};
	int errorCode = OS_OpenDRIM_OperatingSystem_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}

	if ((string) methodName =="RequestStateChange") {
		unsigned int returnValue;
		OpenDRIM_OperatingSystem_RequestStateChange_In inArgs;
		OS_OpenDRIM_OperatingSystem_toCPP(_broker, in, inArgs);
		OpenDRIM_OperatingSystem_RequestStateChange_Out outArgs;
		
		errorCode = OS_OpenDRIM_OperatingSystem_RequestStateChange(_broker, ctx, instance, returnValue, inArgs, outArgs, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		OS_OpenDRIM_OperatingSystem_toCMPIArg(_broker, out, outArgs);
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="Shutdown") {
		unsigned int returnValue;
		
		errorCode = OS_OpenDRIM_OperatingSystem_Shutdown(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else if ((string) methodName =="Reboot") {
		unsigned int returnValue;
		
		errorCode = OS_OpenDRIM_OperatingSystem_Reboot(_broker, ctx, instance, returnValue, errorMessage);
		if (errorCode != OK) {
			errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
			CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
			return rc;
		}
		
		CMPIValue value = CT_toCMPI(returnValue);
		CMReturnData(rslt, &value.uint32, CMPI_uint32);
	}
	else {
		errorMessage = (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + "The requested method (" + (string) methodName +") was not found.";
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) NOT_SUPPORTED, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	CMReturn(CMPI_RC_OK);
}

/* ---------------------------------------------------------------------------*/
/*                    End of Method Provider Interface                        */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int OS_OpenDRIM_OperatingSystem_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = OS_OpenDRIM_OperatingSystem_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "OS_OpenDRIM_OperatingSystem_init FAILED: " + (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int OS_OpenDRIM_OperatingSystem_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = OS_OpenDRIM_OperatingSystem_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "OS_OpenDRIM_OperatingSystem_unload FAILED: " + (string) OpenDRIM_OperatingSystem_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define OS_OpenDRIM_OperatingSystem_INIT if (OS_OpenDRIM_OperatingSystem_init(_broker) < 0) return NULL

CMInstanceMIStub(OS_OpenDRIM_OperatingSystemProvider, OS_OpenDRIM_OperatingSystemProvider, _broker, OS_OpenDRIM_OperatingSystem_INIT);
CMMethodMIStub(OS_OpenDRIM_OperatingSystemProvider, OS_OpenDRIM_OperatingSystemProvider, _broker, OS_OpenDRIM_OperatingSystem_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
