/* -*- c-file-style: "GNU" -*- */
/*
 * Copyright (C) CNRS, INRIA, Université Bordeaux 1, Télécom SudParis
 * See COPYING in top-level directory.
 */

#include <sys/ptrace.h>
#include <asm/ptrace.h>
#include <eztrace-core/types.h>
#include <sys/user.h>
#include <syscall.h>

// Copy/pasted from asm/unistd_32.h
#define __NR32_restart_syscall      0
#define __NR32_exit		  1
#define __NR32_fork		  2
#define __NR32_read		  3
#define __NR32_write		  4
#define __NR32_open		  5
#define __NR32_close		  6
#define __NR32_waitpid		  7
#define __NR32_creat		  8
#define __NR32_link		  9
#define __NR32_unlink		 10
#define __NR32_execve		 11
#define __NR32_chdir		 12
#define __NR32_time		 13
#define __NR32_mknod		 14
#define __NR32_chmod		 15
#define __NR32_lchown		 16
#define __NR32_break		 17
#define __NR32_oldstat		 18
#define __NR32_lseek		 19
#define __NR32_getpid		 20
#define __NR32_mount		 21
#define __NR32_umount		 22
#define __NR32_setuid		 23
#define __NR32_getuid		 24
#define __NR32_stime		 25
#define __NR32_ptrace		 26
#define __NR32_alarm		 27
#define __NR32_oldfstat		 28
#define __NR32_pause		 29
#define __NR32_utime		 30
#define __NR32_stty		 31
#define __NR32_gtty		 32
#define __NR32_access		 33
#define __NR32_nice		 34
#define __NR32_ftime		 35
#define __NR32_sync		 36
#define __NR32_kill		 37
#define __NR32_rename		 38
#define __NR32_mkdir		 39
#define __NR32_rmdir		 40
#define __NR32_dup		 41
#define __NR32_pipe		 42
#define __NR32_times		 43
#define __NR32_prof		 44
#define __NR32_brk		 45
#define __NR32_setgid		 46
#define __NR32_getgid		 47
#define __NR32_signal		 48
#define __NR32_geteuid		 49
#define __NR32_getegid		 50
#define __NR32_acct		 51
#define __NR32_umount2		 52
#define __NR32_lock		 53
#define __NR32_ioctl		 54
#define __NR32_fcntl		 55
#define __NR32_mpx		 56
#define __NR32_setpgid		 57
#define __NR32_ulimit		 58
#define __NR32_oldolduname	 59
#define __NR32_umask		 60
#define __NR32_chroot		 61
#define __NR32_ustat		 62
#define __NR32_dup2		 63
#define __NR32_getppid		 64
#define __NR32_getpgrp		 65
#define __NR32_setsid		 66
#define __NR32_sigaction		 67
#define __NR32_sgetmask		 68
#define __NR32_ssetmask		 69
#define __NR32_setreuid		 70
#define __NR32_setregid		 71
#define __NR32_sigsuspend		 72
#define __NR32_sigpending		 73
#define __NR32_sethostname	 74
#define __NR32_setrlimit		 75
#define __NR32_getrlimit		 76   /* Back compatible 2Gig limited rlimit */
#define __NR32_getrusage		 77
#define __NR32_gettimeofday	 78
#define __NR32_settimeofday	 79
#define __NR32_getgroups		 80
#define __NR32_setgroups		 81
#define __NR32_select		 82
#define __NR32_symlink		 83
#define __NR32_oldlstat		 84
#define __NR32_readlink		 85
#define __NR32_uselib		 86
#define __NR32_swapon		 87
#define __NR32_reboot		 88
#define __NR32_readdir		 89
#define __NR32_mmap		 90
#define __NR32_munmap		 91
#define __NR32_truncate		 92
#define __NR32_ftruncate		 93
#define __NR32_fchmod		 94
#define __NR32_fchown		 95
#define __NR32_getpriority	 96
#define __NR32_setpriority	 97
#define __NR32_profil		 98
#define __NR32_statfs		 99
#define __NR32_fstatfs		100
#define __NR32_ioperm		101
#define __NR32_socketcall		102
#define __NR32_syslog		103
#define __NR32_setitimer		104
#define __NR32_getitimer		105
#define __NR32_stat		106
#define __NR32_lstat		107
#define __NR32_fstat		108
#define __NR32_olduname		109
#define __NR32_iopl		110
#define __NR32_vhangup		111
#define __NR32_idle		112
#define __NR32_vm86old		113
#define __NR32_wait4		114
#define __NR32_swapoff		115
#define __NR32_sysinfo		116
#define __NR32_ipc		117
#define __NR32_fsync		118
#define __NR32_sigreturn		119
#define __NR32_clone		120
#define __NR32_setdomainname	121
#define __NR32_uname		122
#define __NR32_modify_ldt		123
#define __NR32_adjtimex		124
#define __NR32_mprotect		125
#define __NR32_sigprocmask	126
#define __NR32_create_module	127
#define __NR32_init_module	128
#define __NR32_delete_module	129
#define __NR32_get_kernel_syms	130
#define __NR32_quotactl		131
#define __NR32_getpgid		132
#define __NR32_fchdir		133
#define __NR32_bdflush		134
#define __NR32_sysfs		135
#define __NR32_personality	136
#define __NR32_afs_syscall	137 /* Syscall for Andrew File System */
#define __NR32_setfsuid		138
#define __NR32_setfsgid		139
#define __NR32__llseek		140
#define __NR32_getdents		141
#define __NR32__newselect		142
#define __NR32_flock		143
#define __NR32_msync		144
#define __NR32_readv		145
#define __NR32_writev		146
#define __NR32_getsid		147
#define __NR32_fdatasync		148
#define __NR32__sysctl		149
#define __NR32_mlock		150
#define __NR32_munlock		151
#define __NR32_mlockall		152
#define __NR32_munlockall		153
#define __NR32_sched_setparam		154
#define __NR32_sched_getparam		155
#define __NR32_sched_setscheduler		156
#define __NR32_sched_getscheduler		157
#define __NR32_sched_yield		158
#define __NR32_sched_get_priority_max	159
#define __NR32_sched_get_priority_min	160
#define __NR32_sched_rr_get_interval	161
#define __NR32_nanosleep		162
#define __NR32_mremap		163
#define __NR32_setresuid		164
#define __NR32_getresuid		165
#define __NR32_vm86		166
#define __NR32_query_module	167
#define __NR32_poll		168
#define __NR32_nfsservctl		169
#define __NR32_setresgid		170
#define __NR32_getresgid		171
#define __NR32_prctl              172
#define __NR32_rt_sigreturn	173
#define __NR32_rt_sigaction	174
#define __NR32_rt_sigprocmask	175
#define __NR32_rt_sigpending	176
#define __NR32_rt_sigtimedwait	177
#define __NR32_rt_sigqueueinfo	178
#define __NR32_rt_sigsuspend	179
#define __NR32_pread64		180
#define __NR32_pwrite64		181
#define __NR32_chown		182
#define __NR32_getcwd		183
#define __NR32_capget		184
#define __NR32_capset		185
#define __NR32_sigaltstack	186
#define __NR32_sendfile		187
#define __NR32_getpmsg		188	/* some people actually want streams */
#define __NR32_putpmsg		189	/* some people actually want streams */
#define __NR32_vfork		190
#define __NR32_ugetrlimit		191	/* SuS compliant getrlimit */
#define __NR32_mmap2		192
#define __NR32_truncate64		193
#define __NR32_ftruncate64	194
#define __NR32_stat64		195
#define __NR32_lstat64		196
#define __NR32_fstat64		197
#define __NR32_lchown32		198
#define __NR32_getuid32		199
#define __NR32_getgid32		200
#define __NR32_geteuid32		201
#define __NR32_getegid32		202
#define __NR32_setreuid32		203
#define __NR32_setregid32		204
#define __NR32_getgroups32	205
#define __NR32_setgroups32	206
#define __NR32_fchown32		207
#define __NR32_setresuid32	208
#define __NR32_getresuid32	209
#define __NR32_setresgid32	210
#define __NR32_getresgid32	211
#define __NR32_chown32		212
#define __NR32_setuid32		213
#define __NR32_setgid32		214
#define __NR32_setfsuid32		215
#define __NR32_setfsgid32		216
#define __NR32_pivot_root		217
#define __NR32_mincore		218
#define __NR32_madvise		219
#define __NR32_madvise1		219	/* delete when C lib stub is removed */
#define __NR32_getdents64		220
#define __NR32_fcntl64		221
/* 223 is unused */
#define __NR32_gettid		224
#define __NR32_readahead		225
#define __NR32_setxattr		226
#define __NR32_lsetxattr		227
#define __NR32_fsetxattr		228
#define __NR32_getxattr		229
#define __NR32_lgetxattr		230
#define __NR32_fgetxattr		231
#define __NR32_listxattr		232
#define __NR32_llistxattr		233
#define __NR32_flistxattr		234
#define __NR32_removexattr	235
#define __NR32_lremovexattr	236
#define __NR32_fremovexattr	237
#define __NR32_tkill		238
#define __NR32_sendfile64		239
#define __NR32_futex		240
#define __NR32_sched_setaffinity	241
#define __NR32_sched_getaffinity	242
#define __NR32_set_thread_area	243
#define __NR32_get_thread_area	244
#define __NR32_io_setup		245
#define __NR32_io_destroy		246
#define __NR32_io_getevents	247
#define __NR32_io_submit		248
#define __NR32_io_cancel		249
#define __NR32_fadvise64		250
/* 251 is available for reuse (was briefly sys_set_zone_reclaim) */
#define __NR32_exit_group		252
#define __NR32_lookup_dcookie	253
#define __NR32_epoll_create	254
#define __NR32_epoll_ctl		255
#define __NR32_epoll_wait		256
#define __NR32_remap_file_pages	257
#define __NR32_set_tid_address	258
#define __NR32_timer_create	259
#define __NR32_timer_settime	(__NR32_timer_create+1)
#define __NR32_timer_gettime	(__NR32_timer_create+2)
#define __NR32_timer_getoverrun	(__NR32_timer_create+3)
#define __NR32_timer_delete	(__NR32_timer_create+4)
#define __NR32_clock_settime	(__NR32_timer_create+5)
#define __NR32_clock_gettime	(__NR32_timer_create+6)
#define __NR32_clock_getres	(__NR32_timer_create+7)
#define __NR32_clock_nanosleep	(__NR32_timer_create+8)
#define __NR32_statfs64		268
#define __NR32_fstatfs64		269
#define __NR32_tgkill		270
#define __NR32_utimes		271
#define __NR32_fadvise64_64	272
#define __NR32_vserver		273
#define __NR32_mbind		274
#define __NR32_get_mempolicy	275
#define __NR32_set_mempolicy	276
#define __NR32_mq_open 		277
#define __NR32_mq_unlink		(__NR32_mq_open+1)
#define __NR32_mq_timedsend	(__NR32_mq_open+2)
#define __NR32_mq_timedreceive	(__NR32_mq_open+3)
#define __NR32_mq_notify		(__NR32_mq_open+4)
#define __NR32_mq_getsetattr	(__NR32_mq_open+5)
#define __NR32_kexec_load		283
#define __NR32_waitid		284
/* #define __NR32_sys_setaltroot	285 */
#define __NR32_add_key		286
#define __NR32_request_key	287
#define __NR32_keyctl		288
#define __NR32_ioprio_set		289
#define __NR32_ioprio_get		290
#define __NR32_inotify_init	291
#define __NR32_inotify_add_watch	292
#define __NR32_inotify_rm_watch	293
#define __NR32_migrate_pages	294
#define __NR32_openat		295
#define __NR32_mkdirat		296
#define __NR32_mknodat		297
#define __NR32_fchownat		298
#define __NR32_futimesat		299
#define __NR32_fstatat64		300
#define __NR32_unlinkat		301
#define __NR32_renameat		302
#define __NR32_linkat		303
#define __NR32_symlinkat		304
#define __NR32_readlinkat		305
#define __NR32_fchmodat		306
#define __NR32_faccessat		307
#define __NR32_pselect6		308
#define __NR32_ppoll		309
#define __NR32_unshare		310
#define __NR32_set_robust_list	311
#define __NR32_get_robust_list	312
#define __NR32_splice		313
#define __NR32_sync_file_range	314
#define __NR32_tee		315
#define __NR32_vmsplice		316
#define __NR32_move_pages		317
#define __NR32_getcpu		318
#define __NR32_epoll_pwait	319
#define __NR32_utimensat		320
#define __NR32_signalfd		321
#define __NR32_timerfd_create	322
#define __NR32_eventfd		323
#define __NR32_fallocate		324
#define __NR32_timerfd_settime	325
#define __NR32_timerfd_gettime	326
#define __NR32_signalfd4		327
#define __NR32_eventfd2		328
#define __NR32_epoll_create1	329
#define __NR32_dup3		330
#define __NR32_pipe2		331
#define __NR32_inotify_init1	332
#define __NR32_preadv		333
#define __NR32_pwritev		334
#define __NR32_rt_tgsigqueueinfo	335
#define __NR32_perf_event_open	336

#ifdef ENABLE_BINARY_INSTRUMENTATION
int trace_get_bits();
#ifdef __x86_64__
#define TRACE_SYSCALL(name) (trace_get_bits() == 32 ? __NR32_##name : __NR_##name)
#define MMAP_SYSCALLS (trace_get_bits() == 32 ? ((__NR32_mmap << 16) | (__NR32_mmap2)) : __NR_mmap)
#elif __arm__
#define TRACE_SYSCALL(name) (__NR_##name)
#define MMAP_SYSCALLS ((__NR32_mmap << 16) | (__NR32_mmap2))
#endif
#endif /* ENABLE_BINARY_INSTRUMENTATION */

#ifdef __x86_64__
#define REG_STRUCT struct user_regs_struct
#elif __arm__
#define REG_STRUCT struct user_regs
#endif

#define TRACE_SYSCALLS(name1, name2) ((TRACE_SYSCALL(name1) << 16) & TRACE_SYSCALL(name2))
