/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.message.token;

import javax.xml.namespace.QName;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.DOM2Writer;
import org.apache.ws.security.util.WSSecurityUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;

public class BinarySecurity {
    public static final QName TOKEN_BST = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "BinarySecurityToken");
    public static final QName TOKEN_KI = new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier");
    public static final String BASE64_ENCODING = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary";
    protected Element element = null;

    public BinarySecurity(Element elem) throws WSSecurityException {
        this.element = elem;
        QName el = new QName(this.element.getNamespaceURI(), this.element.getLocalName());
        if (!el.equals(TOKEN_BST) && !el.equals(TOKEN_KI)) {
            throw new WSSecurityException(4, "badTokenType", new Object[]{el});
        }
        String encoding = this.getEncodingType();
        if (el.equals(TOKEN_BST) ? encoding != null && encoding.length() > 0 && !encoding.equals(BASE64_ENCODING) : el.equals(TOKEN_KI) && !BASE64_ENCODING.equals(encoding)) {
            throw new WSSecurityException(4, "badEncoding", new Object[]{encoding});
        }
    }

    public BinarySecurity(Document doc) {
        this.element = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse:BinarySecurityToken");
        WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "wsse");
        this.setEncodingType(BASE64_ENCODING);
        this.element.appendChild(doc.createTextNode(""));
    }

    public String getValueType() {
        return this.element.getAttribute("ValueType");
    }

    public void setValueType(String type) {
        this.element.setAttributeNS(null, "ValueType", type);
    }

    public String getEncodingType() {
        return this.element.getAttribute("EncodingType");
    }

    public void setEncodingType(String encoding) {
        this.element.setAttributeNS(null, "EncodingType", encoding);
    }

    public byte[] getToken() {
        Text node = this.getFirstNode();
        if (node == null) {
            return null;
        }
        try {
            return Base64.decode(node.getData());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void setToken(byte[] data) {
        if (data == null) {
            throw new IllegalArgumentException("data == null");
        }
        Text node = this.getFirstNode();
        node.setData(Base64.encode(data));
    }

    protected Text getFirstNode() {
        Node node = this.element.getFirstChild();
        return node != null && node instanceof Text ? (Text)node : null;
    }

    public Element getElement() {
        return this.element;
    }

    public String getID() {
        return this.element.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
    }

    public void setID(String id) {
        String prefix = WSSecurityUtil.setNamespace(this.element, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu");
        this.element.setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", prefix + ":Id", id);
    }

    public String toString() {
        return DOM2Writer.nodeToString(this.element);
    }
}

