/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFG_PMKS.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	void cfgPushMKSargs(struct Cfg_Getopt *optstru)

 	Push the MKS argument line or, if not present, the normal
 	command line

 	MKS args are located within the environment as the very
 	first variable named "~".

ob(ject): cfgPushMKSargs
su(bsystem): cmdline
ty(pe): 
sy(nopsis): 
sh(ort description): Add the MKS arguments (if available) to the input stack
he(ader files): 
lo(ng description): Identify if MKS arguments are available; if so, these
	are pushed onto the input stack, otherwise the normal command line
	is pushed
pr(erequistes): 
va(lue): none
re(lated to): 
se(condary subsystems): 
xr(ef): 
im(port): 
fi(le): cfg_pmks.c
in(itialized by): 
wa(rning): 
bu(gs): 

*/

#include "initsupl.loc"

#ifndef _MICROC_
#include <string.h>
#endif
#include <portable.h>
#include "environ.h"
#include "cfg.loc"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFG_PMKS.C 1.4 1999/12/13 02:22:03 ska Exp ska $";
#endif

void cfgPushMKSargs(struct Cfg_Getopt * const optstru)
{	word segm;

	DBG_ENTER("cfgPushMKSargs", Suppl_cmdline)

	chkHeap
	if((segm = env_glbSeg) != 0
	 && peekb(segm, 0) == '~'
	 && peekb(segm, 0) == '=')		/* MKS args found */
	 	/* Because this variable is the very first, this call
	 		definitely pushed the correct line */
	 	cfgPushEnvVar(optstru, "~");
	else cfgPushCmdLine(optstru);

	chkHeap
	DBG_EXIT
}
