/*
 * Decompiled with CFR 0.152.
 */
package com.google.gwt.regexp.shared;

import com.google.gwt.regexp.shared.MatchResult;
import com.google.gwt.regexp.shared.SplitResult;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegExp {
    private static final Pattern REPLACEMENT_BACKSLASH = Pattern.compile("\\\\");
    private static final String REPLACEMENT_BACKSLASH_FOR_JAVA = "\\\\\\\\";
    private static final Pattern REPLACEMENT_DOLLAR_AMPERSAND = Pattern.compile("((?:^|\\G|[^$])(?:\\$\\$)*)\\$&");
    private static final String REPLACEMENT_DOLLAR_AMPERSAND_FOR_JAVA = "$1\\$0";
    private static final Pattern REPLACEMENT_DOLLAR_APOSTROPHE = Pattern.compile("(?:^|[^$])(?:\\$\\$)*\\$[`']");
    private static final Pattern REPLACEMENT_DOLLAR_DOLLAR = Pattern.compile("\\$\\$");
    private static final String REPLACEMENT_DOLLAR_DOLLAR_FOR_JAVA = "\\\\\\$";
    private final boolean globalFlag;
    private int lastIndex;
    private final Pattern pattern;
    private final String source;

    public static RegExp compile(String pattern) {
        return RegExp.compile(pattern, "");
    }

    public static RegExp compile(String pattern, String flags) {
        boolean globalFlag = false;
        int javaPatternFlags = 1;
        block5: for (char flag : RegExp.parseFlags(flags)) {
            switch (flag) {
                case 'g': {
                    globalFlag = true;
                    continue block5;
                }
                case 'i': {
                    javaPatternFlags |= 0x42;
                    continue block5;
                }
                case 'm': {
                    javaPatternFlags |= 8;
                    continue block5;
                }
            }
            throw new IllegalArgumentException("Unknown regexp flag: '" + flag + "'");
        }
        Pattern javaPattern = Pattern.compile(pattern, javaPatternFlags);
        return new RegExp(pattern, javaPattern, globalFlag);
    }

    private static Set<Character> parseFlags(String flags) {
        HashSet<Character> flagsSet = new HashSet<Character>(flags.length());
        for (int flagIndex = 0; flagIndex < flags.length(); ++flagIndex) {
            char flag = flags.charAt(flagIndex);
            if (flagsSet.add(Character.valueOf(flag))) continue;
            throw new IllegalArgumentException("Flag cannot be specified twice: '" + flag + "'");
        }
        return flagsSet;
    }

    private RegExp(String source, Pattern pattern, boolean globalFlag) {
        this.source = source;
        this.pattern = pattern;
        this.globalFlag = globalFlag;
        this.lastIndex = 0;
    }

    public MatchResult exec(String input) {
        Matcher matcher;
        int searchStartIndex;
        int n = searchStartIndex = this.globalFlag ? this.lastIndex : 0;
        if (input == null || searchStartIndex < 0 || searchStartIndex > input.length()) {
            matcher = null;
        } else {
            matcher = this.pattern.matcher(input);
            if (!matcher.find(searchStartIndex)) {
                matcher = null;
            }
        }
        if (matcher != null) {
            int groupCount = matcher.groupCount();
            ArrayList<String> groups = new ArrayList<String>(1 + groupCount);
            for (int group = 0; group <= groupCount; ++group) {
                groups.add(matcher.group(group));
            }
            if (this.globalFlag) {
                this.lastIndex = matcher.end();
            }
            return new MatchResult(matcher.start(), input, groups);
        }
        if (this.globalFlag) {
            this.lastIndex = 0;
        }
        return null;
    }

    public boolean getGlobal() {
        return this.globalFlag;
    }

    public boolean getIgnoreCase() {
        return (this.pattern.flags() & 2) != 0;
    }

    public int getLastIndex() {
        return this.lastIndex;
    }

    public boolean getMultiline() {
        return (this.pattern.flags() & 8) != 0;
    }

    public String getSource() {
        return this.source;
    }

    public String replace(String input, String replacement) {
        replacement = REPLACEMENT_BACKSLASH.matcher(replacement).replaceAll(REPLACEMENT_BACKSLASH_FOR_JAVA);
        if (REPLACEMENT_DOLLAR_APOSTROPHE.matcher(replacement = REPLACEMENT_DOLLAR_AMPERSAND.matcher(replacement).replaceAll(REPLACEMENT_DOLLAR_AMPERSAND_FOR_JAVA)).find()) {
            throw new UnsupportedOperationException("$` and $' replacements are not supported");
        }
        replacement = REPLACEMENT_DOLLAR_DOLLAR.matcher(replacement).replaceAll(REPLACEMENT_DOLLAR_DOLLAR_FOR_JAVA);
        return this.globalFlag ? this.pattern.matcher(input).replaceAll(replacement) : this.pattern.matcher(input).replaceFirst(replacement);
    }

    public void setLastIndex(int lastIndex) {
        this.lastIndex = lastIndex;
    }

    public SplitResult split(String input) {
        return this.split(input, -1);
    }

    public SplitResult split(String input, int limit) {
        String[] result;
        if (this.source.length() == 0) {
            int resultLength = input.length();
            if (resultLength > limit && limit >= 0) {
                resultLength = limit;
            }
            result = new String[resultLength];
            for (int i = 0; i < resultLength; ++i) {
                result[i] = input.substring(i, i + 1);
            }
        } else {
            result = this.pattern.split(input, limit < 0 ? -1 : limit + 1);
            if (result.length > limit && limit >= 0) {
                String[] realResult = new String[limit];
                for (int i = 0; i < limit; ++i) {
                    realResult[i] = result[i];
                }
                result = realResult;
            }
        }
        return new SplitResult(result);
    }

    public boolean test(String input) {
        return this.exec(input) != null;
    }
}

