'\" t
.\" Copyright 1999 Oracle and/or its affiliates. All rights reserved.
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining a
.\" copy of this software and associated documentation files (the "Software"),
.\" to deal in the Software without restriction, including without limitation
.\" the rights to use, copy, modify, merge, publish, distribute, sublicense,
.\" and/or sell copies of the Software, and to permit persons to whom the
.\" Software is furnished to do so, subject to the following conditions:
.\"
.\" The above copyright notice and this permission notice (including the next
.\" paragraph) shall be included in all copies or substantial portions of the
.\" Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
.\" IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
.\" FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
.\" THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
.\" LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
.\" FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
.\" DEALINGS IN THE SOFTWARE.
.\"
.TH XkbFreeControls __libmansuffix__ __xorgversion__ "XKB FUNCTIONS"
.SH NAME
XkbFreeControls \- Frees memory used by the ctrls member of an XkbDescRec structure
.SH SYNOPSIS
.HP
.B void XkbFreeControls
.BI "(\^XkbDescPtr " "xkb" "\^,"
.BI "unsigned int " "which" "\^,"
.BI "Bool " "free_all" "\^);"
.if n .ti +5n
.if t .ti +.5i
.SH ARGUMENTS
.TP
.I \- xkb
Xkb description in which to free controls components
.TP
.I \- which
mask of components of ctrls to free
.TP
.I \- free_all
True => free everything + ctrls itself
.SH DESCRIPTION
.LP
.I XkbFreeControls 
frees the specified components of the 
.I ctrls 
field in the 
.I xkb 
keyboard description and sets the corresponding structure component values to NULL or zero. The 
.I which 
mask specifies the fields of 
.I ctrls 
to be freed and can contain any of the controls components specified in Table 1.

Table 1 shows the actual values for the individual mask bits used to select 
controls for 
modification and to enable and disable the control. Note that the same mask bit 
is used to 
specify general modifications to the parameters used to configure the control 
(which), and to 
enable and disable the control (enabled_ctrls). The anomalies in the table (no 
"ok" in column) 
are for controls that have no configurable attributes; and for controls that are 
not boolean 
controls and therefore cannot be enabled or disabled.

.TS
c s s s
l l l l
l l l l
l l l l. 
Table 1 Controls Mask Bits
_
Mask Bit	which or	enabled	Value
	changed_ctrls	_ctrls
_
XkbRepeatKeysMask	ok	ok	(1L<<0)
XkbSlowKeysMask	ok	ok	(1L<<1)
XkbBounceKeysMask	ok	ok	(1L<<2)
XkbStickyKeysMask	ok	ok	(1L<<3)
XkbMouseKeysMask	ok	ok	(1L<<4)
XkbMouseKeysAccelMask	ok	ok	(1L<<5)
XkbAccessXKeysMask	ok	ok	(1L<<6)
XkbAccessXTimeoutMask	ok	ok	(1L<<7)
XkbAccessXFeedbackMask	ok	ok	(1L<<8)
XkbAudibleBellMask		ok	(1L<<9)
XkbOverlay1Mask		ok	(1L<<10)
XkbOverlay2Mask		ok	(1L<<11)
XkbIgnoreGroupLockMask		ok	(1L<<12)
XkbGroupsWrapMask	ok		(1L<<27)
XkbInternalModsMask	ok		(1L<<28)
XkbIgnoreLockModsMask	ok		(1L<<29)
XkbPerKeyRepeatMask	ok		(1L<<30)
XkbControlsEnabledMask	ok		(1L<<31)
XkbAccessXOptionsMask	ok	ok	(XkbStickyKeysMask | 
			XkbAccessXFeedbackMask)
XkbAllBooleanCtrlsMask		ok	(0x00001FFF) 
XkbAllControlsMask	ok		(0xF8001FFF)
.TE

If 
.I free_all 
is True, 
.I XkbFreeControls 
frees every non-NULL structure component in the controls, frees the XkbControlsRec structure referenced by the 
.I ctrls 
member of 
.I xkb, 
and sets 
.I ctrls 
to NULL.
