/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef PNG_HELPER_H_INCLUDED
#define PNG_HELPER_H_INCLUDED

#include <string>

namespace libgltf { namespace pnghelper
{

bool ReadPNGFromFile(const std::string& sFileName, char** pBuffer, int& nWidth, int& nHeight);

bool WritePNGToFile(const std::string& sFileName, const char* pBuffer, const int nWidth, const int nHeight);

} // pnghelper
} // libgltf

#endif // APITEST_H_INCLUDED

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
