/* SPDX-License-Identifier: GPL-2.0 */
/*
 * cs35l45.h - CS35L45 ALSA SoC audio driver
 *
 * Copyright 2019-2022 Cirrus Logic, Inc.
 *
 * Author: James Schulman <james.schulman@cirrus.com>
 *
 */

#ifndef CS35L45_H
#define CS35L45_H

#include <linux/pm_runtime.h>
#include <linux/regmap.h>
#include <linux/regulator/consumer.h>
#include <dt-bindings/sound/cs35l45.h>
#include "wm_adsp.h"

#define CS35L45_DEVID				0x00000000
#define CS35L45_REVID				0x00000004
#define CS35L45_RELID				0x0000000C
#define CS35L45_OTPID				0x00000010
#define CS35L45_SFT_RESET			0x00000020
#define CS35L45_GLOBAL_ENABLES			0x00002014
#define CS35L45_BLOCK_ENABLES			0x00002018
#define CS35L45_BLOCK_ENABLES2			0x0000201C
#define CS35L45_ERROR_RELEASE			0x00002034
#define CS35L45_SYNC_GPIO1			0x00002430
#define CS35L45_INTB_GPIO2_MCLK_REF		0x00002434
#define CS35L45_GPIO3				0x00002438
#define CS35L45_PWRMGT_CTL			0x00002900
#define CS35L45_WAKESRC_CTL			0x00002904
#define CS35L45_WKI2C_CTL			0x00002908
#define CS35L45_PWRMGT_STS			0x0000290C
#define CS35L45_REFCLK_INPUT			0x00002C04
#define CS35L45_GLOBAL_SAMPLE_RATE		0x00002C0C
#define CS35L45_BOOST_CCM_CFG			0x00003808
#define CS35L45_BOOST_DCM_CFG			0x0000380C
#define CS35L45_BOOST_OV_CFG			0x0000382C
#define CS35L45_ASP_ENABLES1			0x00004800
#define CS35L45_ASP_CONTROL1			0x00004804
#define CS35L45_ASP_CONTROL2			0x00004808
#define CS35L45_ASP_CONTROL3			0x0000480C
#define CS35L45_ASP_FRAME_CONTROL1		0x00004810
#define CS35L45_ASP_FRAME_CONTROL2		0x00004814
#define CS35L45_ASP_FRAME_CONTROL5		0x00004820
#define CS35L45_ASP_DATA_CONTROL1		0x00004830
#define CS35L45_ASP_DATA_CONTROL5		0x00004840
#define CS35L45_DACPCM1_INPUT			0x00004C00
#define CS35L45_ASPTX1_INPUT			0x00004C20
#define CS35L45_ASPTX2_INPUT			0x00004C24
#define CS35L45_ASPTX3_INPUT			0x00004C28
#define CS35L45_ASPTX4_INPUT			0x00004C2C
#define CS35L45_ASPTX5_INPUT			0x00004C30
#define CS35L45_DSP1RX1_INPUT			0x00004C40
#define CS35L45_DSP1RX2_INPUT			0x00004C44
#define CS35L45_DSP1RX3_INPUT			0x00004C48
#define CS35L45_DSP1RX4_INPUT			0x00004C4C
#define CS35L45_DSP1RX5_INPUT			0x00004C50
#define CS35L45_DSP1RX6_INPUT			0x00004C54
#define CS35L45_DSP1RX7_INPUT			0x00004C58
#define CS35L45_DSP1RX8_INPUT			0x00004C5C
#define CS35L45_HVLV_CONFIG			0x00006400
#define CS35L45_LDPM_CONFIG			0x00006404
#define CS35L45_AMP_PCM_CONTROL			0x00007000
#define CS35L45_AMP_PCM_HPF_TST			0x00007004
#define CS35L45_AMP_GAIN			0x00007800
#define CS35L45_IRQ1_CFG			0x0000E000
#define CS35L45_IRQ1_STATUS			0x0000E004
#define CS35L45_IRQ1_EINT_1			0x0000E010
#define CS35L45_IRQ1_EINT_2			0x0000E014
#define CS35L45_IRQ1_EINT_3			0x0000E018
#define CS35L45_IRQ1_EINT_4			0x0000E01C
#define CS35L45_IRQ1_EINT_5			0x0000E020
#define CS35L45_IRQ1_EINT_7			0x0000E028
#define CS35L45_IRQ1_EINT_8			0x0000E02C
#define CS35L45_IRQ1_EINT_18			0x0000E054
#define CS35L45_IRQ1_STS_1			0x0000E090
#define CS35L45_IRQ1_STS_2			0x0000E094
#define CS35L45_IRQ1_STS_3			0x0000E098
#define CS35L45_IRQ1_STS_4			0x0000E09C
#define CS35L45_IRQ1_STS_5			0x0000E0A0
#define CS35L45_IRQ1_STS_7			0x0000E0A8
#define CS35L45_IRQ1_STS_8			0x0000E0AC
#define CS35L45_IRQ1_STS_18			0x0000E0D4
#define CS35L45_IRQ1_MASK_1			0x0000E110
#define CS35L45_IRQ1_MASK_2			0x0000E114
#define CS35L45_IRQ1_MASK_3			0x0000E118
#define CS35L45_IRQ1_MASK_4			0x0000E11C
#define CS35L45_IRQ1_MASK_5			0x0000E120
#define CS35L45_IRQ1_MASK_6			0x0000E124
#define CS35L45_IRQ1_MASK_7			0x0000E128
#define CS35L45_IRQ1_MASK_8			0x0000E12C
#define CS35L45_IRQ1_MASK_9			0x0000E130
#define CS35L45_IRQ1_MASK_10			0x0000E134
#define CS35L45_IRQ1_MASK_11			0x0000E138
#define CS35L45_IRQ1_MASK_12			0x0000E13C
#define CS35L45_IRQ1_MASK_13			0x0000E140
#define CS35L45_IRQ1_MASK_14			0x0000E144
#define CS35L45_IRQ1_MASK_15			0x0000E148
#define CS35L45_IRQ1_MASK_16			0x0000E14C
#define CS35L45_IRQ1_MASK_17			0x0000E150
#define CS35L45_IRQ1_MASK_18			0x0000E154
#define CS35L45_GPIO_STATUS1			0x0000F000
#define CS35L45_GPIO1_CTRL1			0x0000F008
#define CS35L45_GPIO2_CTRL1			0x0000F00C
#define CS35L45_GPIO3_CTRL1			0x0000F010
#define CS35L45_DSP_MBOX_1			0x00011000
#define CS35L45_DSP_MBOX_2			0x00011004
#define CS35L45_DSP_VIRT1_MBOX_1		0x00011020
#define CS35L45_DSP_VIRT1_MBOX_2		0x00011024
#define CS35L45_DSP_VIRT1_MBOX_3		0x00011028
#define CS35L45_DSP_VIRT1_MBOX_4		0x0001102C
#define CS35L45_DSP_VIRT2_MBOX_1		0x00011040
#define CS35L45_DSP_VIRT2_MBOX_2		0x00011044
#define CS35L45_DSP_VIRT2_MBOX_3		0x00011048
#define CS35L45_DSP_VIRT2_MBOX_4		0x0001104C
#define CS35L45_DSP1_XMEM_PACK_0		0x02000000
#define CS35L45_DSP1_XMEM_PACK_4607		0x020047FC
#define CS35L45_DSP1_XMEM_UNPACK32_0		0x02400000
#define CS35L45_DSP1_XMEM_UNPACK32_3071	0x02402FFC
#define CS35L45_DSP1_SYS_ID			0x025E0000
#define CS35L45_DSP1_XMEM_UNPACK24_0		0x02800000
#define CS35L45_DSP1_XMEM_UNPACK24_6143	0x02805FFC
#define CS35L45_DSP1_CLOCK_FREQ		0x02B80000
#define CS35L45_DSP1_RX1_RATE			0x02B80080
#define CS35L45_DSP1_RX2_RATE			0x02B80088
#define CS35L45_DSP1_RX3_RATE			0x02B80090
#define CS35L45_DSP1_RX4_RATE			0x02B80098
#define CS35L45_DSP1_RX5_RATE			0x02B800A0
#define CS35L45_DSP1_RX6_RATE			0x02B800A8
#define CS35L45_DSP1_RX7_RATE			0x02B800B0
#define CS35L45_DSP1_RX8_RATE			0x02B800B8
#define CS35L45_DSP1_TX1_RATE			0x02B80280
#define CS35L45_DSP1_TX2_RATE			0x02B80288
#define CS35L45_DSP1_TX3_RATE			0x02B80290
#define CS35L45_DSP1_TX4_RATE			0x02B80298
#define CS35L45_DSP1_TX5_RATE			0x02B802A0
#define CS35L45_DSP1_TX6_RATE			0x02B802A8
#define CS35L45_DSP1_TX7_RATE			0x02B802B0
#define CS35L45_DSP1_TX8_RATE			0x02B802B8
#define CS35L45_DSP1_SCRATCH1			0x02B805C0
#define CS35L45_DSP1_SCRATCH2			0x02B805C8
#define CS35L45_DSP1_SCRATCH3			0x02B805D0
#define CS35L45_DSP1_SCRATCH4			0x02B805D8
#define CS35L45_DSP1_CCM_CORE_CONTROL		0x02BC1000
#define CS35L45_DSP1_YMEM_PACK_0		0x02C00000
#define CS35L45_DSP1_YMEM_PACK_1532		0x02C017F0
#define CS35L45_DSP1_YMEM_UNPACK32_0		0x03000000
#define CS35L45_DSP1_YMEM_UNPACK32_1022	0x03000FF8
#define CS35L45_DSP1_YMEM_UNPACK24_0		0x03400000
#define CS35L45_DSP1_YMEM_UNPACK24_2043	0x03401FEC
#define CS35L45_DSP1_PMEM_0			0x03800000
#define CS35L45_DSP1_PMEM_3834			0x03803BE8
#define CS35L45_LASTREG			0x03C6EFE8

/* SFT_RESET */
#define CS35L45_SOFT_RESET_TRIGGER		0x5A000000

/* GLOBAL_ENABLES */
#define CS35L45_GLOBAL_EN_SHIFT			0
#define CS35L45_GLOBAL_EN_MASK			BIT(0)

/* BLOCK_ENABLES */
#define CS35L45_IMON_EN_SHIFT			13
#define CS35L45_VMON_EN_SHIFT			12
#define CS35L45_TEMPMON_EN_SHIFT		10
#define CS35L45_VDD_BSTMON_EN_SHIFT		9
#define CS35L45_VDD_BATTMON_EN_SHIFT		8
#define CS35L45_BST_EN_SHIFT			4
#define CS35L45_BST_EN_MASK			GENMASK(5, 4)
#define CS35L45_RCV_EN_SHIFT			2
#define CS35L45_RCV_EN_MASK			BIT(2)
#define CS35L45_AMP_EN_SHIFT			0
#define CS35L45_AMP_EN_MASK			BIT(0)

#define CS35L45_BST_DISABLE_FET_OFF		0x00
#define CS35L45_BST_DISABLE_FET_ON		0x01
#define CS35L45_BST_ENABLE			0x02

/* BLOCK_ENABLES2 */
#define CS35L45_ASP_EN_SHIFT			27
#define CS35L45_AMP_DRE_EN_SHIFT		20
#define CS35L45_AMP_DRE_EN_MASK		BIT(20)
#define CS35L45_MEM_RDY_SHIFT			1
#define CS35L45_MEM_RDY_MASK			BIT(1)

/* ERROR_RELEASE */
#define CS35L45_GLOBAL_ERR_RLS_MASK		BIT(11)

/* CCM_CORE */
#define CS35L45_CCM_CORE_RESET_SHIFT		9
#define CS35L45_CCM_CORE_RESET_MASK		BIT(9)
#define CS35L45_CCM_PM_REMAP_SHIFT		7
#define CS35L45_CCM_PM_REMAP_MASK		BIT(7)
#define CS35L45_CCM_CORE_EN_SHIFT		0
#define CS35L45_CCM_CORE_EN_MASK		BIT(0)

/* REFCLK_INPUT */
#define CS35L45_PLL_FORCE_EN_SHIFT		16
#define CS35L45_PLL_FORCE_EN_MASK		BIT(16)
#define CS35L45_PLL_OPEN_LOOP_SHIFT		11
#define CS35L45_PLL_OPEN_LOOP_MASK		BIT(11)
#define CS35L45_PLL_REFCLK_FREQ_SHIFT		5
#define CS35L45_PLL_REFCLK_FREQ_MASK		GENMASK(10, 5)
#define CS35L45_PLL_REFCLK_EN_SHIFT		4
#define CS35L45_PLL_REFCLK_EN_MASK		BIT(4)
#define CS35L45_PLL_REFCLK_SEL_SHIFT		0
#define CS35L45_PLL_REFCLK_SEL_MASK		GENMASK(2, 0)

#define CS35L45_PLL_REFCLK_SEL_BCLK		0x0

/* GLOBAL_SAMPLE_RATE */
#define CS35L45_GLOBAL_FS_SHIFT			0
#define CS35L45_GLOBAL_FS_MASK			GENMASK(4, 0)

#define CS35L45_48P0_KHZ			0x03
#define CS35L45_96P0_KHZ			0x04
#define CS35L45_44P100_KHZ			0x0B
#define CS35L45_88P200_KHZ			0x0C

/* ASP_ENABLES_1 */
#define CS35L45_ASP_RX2_EN_SHIFT		17
#define CS35L45_ASP_RX1_EN_SHIFT		16
#define CS35L45_ASP_TX5_EN_SHIFT		4
#define CS35L45_ASP_TX4_EN_SHIFT		3
#define CS35L45_ASP_TX3_EN_SHIFT		2
#define CS35L45_ASP_TX2_EN_SHIFT		1
#define CS35L45_ASP_TX1_EN_SHIFT		0

/* ASP_CONTROL2 */
#define CS35L45_ASP_WIDTH_RX_SHIFT		24
#define CS35L45_ASP_WIDTH_RX_MASK		GENMASK(31, 24)
#define CS35L45_ASP_WIDTH_TX_SHIFT		16
#define CS35L45_ASP_WIDTH_TX_MASK		GENMASK(23, 16)
#define CS35L45_ASP_FMT_SHIFT			8
#define CS35L45_ASP_FMT_MASK			GENMASK(10, 8)
#define CS35L45_ASP_BCLK_INV_SHIFT		6
#define CS35L45_ASP_BCLK_INV_MASK		BIT(6)
#define CS35L45_ASP_FSYNC_INV_SHIFT		2
#define CS35L45_ASP_FSYNC_INV_MASK		BIT(2)

#define CS35l45_ASP_FMT_DSP_A			0
#define CS35L45_ASP_FMT_I2S			2

/* ASP_CONTROL3 */
#define CS35L45_ASP_DOUT_HIZ_CTRL_SHIFT		0
#define CS35L45_ASP_DOUT_HIZ_CTRL_MASK		GENMASK(1, 0)

/* ASP_FRAME_CONTROL1 */
#define CS35L45_ASP_TX4_SLOT_SHIFT		24
#define CS35L45_ASP_TX4_SLOT_MASK		GENMASK(29, 24)
#define CS35L45_ASP_TX3_SLOT_SHIFT		16
#define CS35L45_ASP_TX3_SLOT_MASK		GENMASK(21, 16)
#define CS35L45_ASP_TX2_SLOT_SHIFT		8
#define CS35L45_ASP_TX2_SLOT_MASK		GENMASK(13, 8)
#define CS35L45_ASP_TX1_SLOT_SHIFT		0
#define CS35L45_ASP_TX1_SLOT_MASK		GENMASK(5, 0)

#define CS35L45_ASP_TX_ALL_SLOTS		(CS35L45_ASP_TX4_SLOT_MASK | \
						CS35L45_ASP_TX3_SLOT_MASK  | \
						CS35L45_ASP_TX2_SLOT_MASK  | \
						CS35L45_ASP_TX1_SLOT_MASK)
/* ASP_FRAME_CONTROL5 */
#define CS35L45_ASP_RX2_SLOT_SHIFT		8
#define CS35L45_ASP_RX2_SLOT_MASK		GENMASK(13, 8)
#define CS35L45_ASP_RX1_SLOT_SHIFT		0
#define CS35L45_ASP_RX1_SLOT_MASK		GENMASK(5, 0)

#define CS35L45_ASP_RX_ALL_SLOTS		(CS35L45_ASP_RX2_SLOT_MASK | \
						CS35L45_ASP_RX1_SLOT_MASK)

/* ASP_DATA_CONTROL1 */
/* ASP_DATA_CONTROL5 */
#define CS35L45_ASP_WL_SHIFT			0
#define CS35L45_ASP_WL_MASK			GENMASK(5, 0)

/* HVLV_CONFIG */
#define CS35L45_FORCE_LV_OPERATION		0x01
#define CS35L45_FORCE_HV_OPERATION		0x02
#define CS35L45_HVLV_OPERATION			0x03
#define CS35L45_HVLV_MODE_SHIFT		0
#define CS35L45_HVLV_MODE_MASK			GENMASK(1, 0)

/* AMP_PCM_CONTROL */
#define CS35L45_AMP_VOL_PCM_SHIFT		0
#define CS35L45_AMP_VOL_PCM_WIDTH		11

/* AMP_PCM_HPF_TST */
#define CS35l45_HPF_DEFAULT			0x00000000
#define CS35L45_HPF_44P1			0x000108BD
#define CS35L45_HPF_88P2			0x0001045F

/* AMP_GAIN_PCM */
#define CS35L45_AMP_GAIN_PCM_10DBV		0x00
#define CS35L45_AMP_GAIN_PCM_13DBV		0x01
#define CS35L45_AMP_GAIN_PCM_16DBV		0x02
#define CS35L45_AMP_GAIN_PCM_19DBV		0x03

#define CS35L45_AMP_GAIN_PCM_SHIFT		8
#define CS35L45_AMP_GAIN_PCM_MASK		GENMASK(9, 8)

/* IRQ1_EINT_4 */
#define CS35L45_OTP_BOOT_DONE_STS_MASK		BIT(1)
#define CS35L45_OTP_BUSY_MASK			BIT(0)

/* GPIOX_CTRL1 */
#define CS35L45_GPIO_DIR_SHIFT			31
#define CS35L45_GPIO_DIR_MASK			BIT(31)
#define CS35L45_GPIO_LVL_SHIFT			15
#define CS35L45_GPIO_LVL_MASK			BIT(15)
#define CS35L45_GPIO_OP_CFG_SHIFT		14
#define CS35L45_GPIO_OP_CFG_MASK		BIT(14)
#define CS35L45_GPIO_POL_SHIFT			12
#define CS35L45_GPIO_POL_MASK			BIT(12)

/* SYNC_GPIO1, INTB_GPIO2_MCLK_REF, GPIO3 */
#define CS35L45_GPIO_CTRL_SHIFT		20
#define CS35L45_GPIO_CTRL_MASK			GENMASK(22, 20)
#define CS35L45_GPIO_INVERT_SHIFT		19
#define CS35L45_GPIO_INVERT_MASK		BIT(19)

/* CS35L45_IRQ1_EINT_1 */
#define CS35L45_BST_UVP_ERR_SHIFT		7
#define CS35L45_BST_UVP_ERR_MASK		BIT(7)
#define CS35L45_BST_SHORT_ERR_SHIFT		8
#define CS35L45_BST_SHORT_ERR_MASK		BIT(8)
#define CS35L45_TEMP_ERR_SHIFT			17
#define CS35L45_TEMP_ERR_MASK			BIT(17)
#define CS35L45_MSM_GLOBAL_EN_ASSERT_SHIFT	22
#define CS35L45_MSM_GLOBAL_EN_ASSERT_MASK	BIT(22)
#define CS35L45_UVLO_VDDBATT_ERR_SHIFT	29
#define CS35L45_UVLO_VDDBATT_ERR_MASK		BIT(29)
#define CS35L45_AMP_SHORT_ERR_SHIFT		31
#define CS35L45_AMP_SHORT_ERR_MASK		BIT(31)

/* CS35L45_IRQ1_EINT_2 */
#define CS35L45_DSP_WDT_EXPIRE_SHIFT		4
#define CS35L45_DSP_WDT_EXPIRE_MASK		BIT(4)
#define CS35L45_DSP_VIRT2_MBOX_SHIFT		21
#define CS35L45_DSP_VIRT2_MBOX_MASK		BIT(21)

/* CS35L45_IRQ1_EINT_3 */
#define CS35L45_PLL_LOCK_FLAG_SHIFT		1
#define CS35L45_PLL_LOCK_FLAG_MASK		BIT(1)
#define CS35L45_PLL_UNLOCK_FLAG_RISE_SHIFT	4
#define CS35L45_PLL_UNLOCK_FLAG_RISE_MASK	BIT(4)
#define CS35L45_AMP_CAL_ERR_SHIFT		25
#define CS35L45_AMP_CAL_ERR_MASK		BIT(25)

/* CS35L45_IRQ1_EINT_18 */
#define CS35L45_GLOBAL_ERROR_SHIFT		15
#define CS35L45_GLOBAL_ERROR_MASK		BIT(15)
#define CS35L45_UVLO_VDDLV_ERR_SHIFT		16
#define CS35L45_UVLO_VDDLV_ERR_MASK		BIT(16)

/* Mixer sources */
#define CS35L45_PCM_SRC_MASK			0x7F
#define CS35L45_PCM_SRC_ZERO			0x00
#define CS35L45_PCM_SRC_ASP_RX1			0x08
#define CS35L45_PCM_SRC_ASP_RX2			0x09
#define CS35L45_PCM_SRC_VMON			0x18
#define CS35L45_PCM_SRC_IMON			0x19
#define CS35L45_PCM_SRC_ERR_VOL			0x20
#define CS35L45_PCM_SRC_CLASSH_TGT		0x21
#define CS35L45_PCM_SRC_VDD_BATTMON		0x28
#define CS35L45_PCM_SRC_VDD_BSTMON		0x29
#define CS35L45_PCM_SRC_DSP_TX1			0x32
#define CS35L45_PCM_SRC_DSP_TX2			0x33
#define CS35L45_PCM_SRC_TEMPMON			0x3A
#define CS35L45_PCM_SRC_INTERPOLATOR		0x40
#define CS35L45_PCM_SRC_IL_TARGET		0x48

#define CS35L45_RESET_HOLD_US			2000
#define CS35L45_RESET_US			2000
#define CS35L45_POST_GLOBAL_EN_US		5000
#define CS35L45_PRE_GLOBAL_DIS_US		3000

/* WAKESRC_CTL */
#define CS35L45_WKSRC_SYNC_GPIO1		BIT(0)
#define CS35L45_WKSRC_INT_GPIO2			BIT(1)
#define CS35L45_WKSRC_GPIO3			BIT(2)
#define CS35L45_WKSRC_SPI			BIT(3)
#define CS35L45_WKSRC_I2C			BIT(4)
#define CS35L45_UPDT_WKCTL_SHIFT		15
#define CS35L45_UPDT_WKCTL_MASK			BIT(15)
#define CS35L45_WKSRC_EN_SHIFT			8
#define CS35L45_WKSRC_EN_MASK			GENMASK(12, 8)
#define CS35L45_WKSRC_POL_SHIFT			0
#define CS35L45_WKSRC_POL_MASK			GENMASK(3, 0)

/* WAKEI2C_CTL */
#define CS35L45_UPDT_WKI2C_SHIFT		15
#define CS35L45_UPDT_WKI2C_MASK			BIT(15)
#define CS35L45_WKI2C_ADDR_SHIFT		0
#define CS35L45_WKI2C_ADDR_MASK			GENMASK(6, 0)

#define CS35L45_SPI_MAX_FREQ			4000000

enum cs35l45_cspl_mboxstate {
	CSPL_MBOX_STS_RUNNING = 0,
	CSPL_MBOX_STS_PAUSED = 1,
	CSPL_MBOX_STS_RDY_FOR_REINIT = 2,
	CSPL_MBOX_STS_HIBERNATE = 3,
};

enum cs35l45_cspl_mboxcmd {
	CSPL_MBOX_CMD_NONE = 0,
	CSPL_MBOX_CMD_PAUSE = 1,
	CSPL_MBOX_CMD_RESUME = 2,
	CSPL_MBOX_CMD_REINIT = 3,
	CSPL_MBOX_CMD_STOP_PRE_REINIT = 4,
	CSPL_MBOX_CMD_HIBERNATE = 5,
	CSPL_MBOX_CMD_OUT_OF_HIBERNATE = 6,
	CSPL_MBOX_CMD_UNKNOWN_CMD = -1,
	CSPL_MBOX_CMD_INVALID_SEQUENCE = -2,
};

enum control_bus_type {
	CONTROL_BUS_I2C = 0,
	CONTROL_BUS_SPI = 1,
};

enum amp_mode {
	AMP_MODE_SPK  = 0,
	AMP_MODE_RCV  = 1,
};

#define CS35L45_FORMATS (SNDRV_PCM_FMTBIT_S16_LE | \
			 SNDRV_PCM_FMTBIT_S24_3LE| \
			 SNDRV_PCM_FMTBIT_S24_LE)

#define CS35L45_RATES (SNDRV_PCM_RATE_44100 | \
		       SNDRV_PCM_RATE_48000 | \
		       SNDRV_PCM_RATE_88200 | \
		       SNDRV_PCM_RATE_96000)

/*
 * IRQs
 */
#define CS35L45_IRQ(_irq, _name, _hand)		\
	{					\
		.irq = CS35L45_ ## _irq ## _IRQ,\
		.name = _name,			\
		.handler = _hand,		\
	}

struct cs35l45_irq {
	int irq;
	const char *name;
	irqreturn_t (*handler)(int irq, void *data);
};

#define CS35L45_REG_IRQ(_reg, _irq)					\
	[CS35L45_ ## _irq ## _IRQ] = {					\
		.reg_offset = (CS35L45_ ## _reg) - CS35L45_IRQ1_EINT_1,	\
		.mask = CS35L45_ ## _irq ## _MASK			\
	}

enum cs35l45_irq_list {
	CS35L45_AMP_SHORT_ERR_IRQ,
	CS35L45_UVLO_VDDBATT_ERR_IRQ,
	CS35L45_BST_SHORT_ERR_IRQ,
	CS35L45_BST_UVP_ERR_IRQ,
	CS35L45_TEMP_ERR_IRQ,
	CS35L45_AMP_CAL_ERR_IRQ,
	CS35L45_UVLO_VDDLV_ERR_IRQ,
	CS35L45_GLOBAL_ERROR_IRQ,
	CS35L45_DSP_WDT_EXPIRE_IRQ,
	CS35L45_PLL_UNLOCK_FLAG_RISE_IRQ,
	CS35L45_PLL_LOCK_FLAG_IRQ,
	CS35L45_DSP_VIRT2_MBOX_IRQ,
	CS35L45_NUM_IRQ
};

#define CS35L45_MBOX3_CMD_MASK		0xFF
#define CS35L45_MBOX3_CMD_SHIFT		0
#define CS35L45_MBOX3_DATA_MASK		0xFFFFFF00
#define CS35L45_MBOX3_DATA_SHIFT	8

enum mbox3_events {
	EVENT_SPEAKER_STATUS = 0x66,
	EVENT_BOOT_DONE = 0x67,
};

struct cs35l45_private {
	struct wm_adsp dsp; /* needs to be first member */
	struct device *dev;
	struct regmap *regmap;
	struct gpio_desc *reset_gpio;
	struct regulator *vdd_batt;
	struct regulator *vdd_a;
	bool initialized;
	bool sysclk_set;
	u8 slot_width;
	u8 slot_count;
	int amplifier_mode;
	int irq_invert;
	int irq;
	unsigned int i2c_addr;
	enum control_bus_type bus_type;
	struct regmap_irq_chip_data *irq_data;
};

extern const struct dev_pm_ops cs35l45_pm_ops;
extern const struct regmap_config cs35l45_i2c_regmap;
extern const struct regmap_config cs35l45_spi_regmap;
int cs35l45_apply_patch(struct cs35l45_private *cs35l45);
unsigned int cs35l45_get_clk_freq_id(unsigned int freq);
int cs35l45_probe(struct cs35l45_private *cs35l45);
void cs35l45_remove(struct cs35l45_private *cs35l45);

#endif /* CS35L45_H */
